<?php

namespace App\Exports;

use App\Models\Vcard;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class VcardTemplateExport implements FromArray, WithHeadings
{
    public function array(): array
    {
        return []; // no rows — just the headings
    }

    public function headings(): array
    {
        return [
            'url_alias',
            'VCard Name',
            'occupation',
            'description',
            'First Name',
            'Last Name',
            'email',
            'company',
            'job_title',
            'dob'
        ];
    }
    public function collection()
    {
        return Vcard::select('url_alias', 'name', 'occupation', 'description', 'first_name', 'last_name','email',
            'company',
            'job_title',
            'dob')->get();
    }
}
