<?php

namespace App\Exports;

use App\Models\Vcard;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class VcardTemplateExport implements FromArray, WithHeadings
{
    public function array(): array
    {
        return []; // no rows — just the headings
    }

    public function headings(): array
    {
        return [
            'url_alias',
            'VCard Name',
            'occupation',
            'Description (Optional)',
            'First Name',
            'Last Name',
            'email',
            'company',
            'Company Location',
            'Location url (google map )',
            'Website url (Optional)',
            'LinkedIn url (Optional)',
            'Facebook url (Optional)',
            'Instagram url (Optional)',
        ];
    }
    public function collection()
    {
        return Vcard::with('socialLinks')->get()->map(function ($vcard) {
        return [
            'url_alias'      => $vcard->url_alias,
            'VCard Name'     => $vcard->name,
            'occupation'     => $vcard->occupation,
            'description'    => $vcard->description,
            'First Name'     => $vcard->first_name,
            'Last Name'      => $vcard->last_name,
            'email'          => $vcard->email,
            'company'        => $vcard->company,
            'Company Location' => $vcard->location,
            'Location url'   => $vcard->location_url,
            'Website url'    => optional($vcard->socialLinks->where('type', 'website')->first())->url,
            'LinkedIn url'   => optional($vcard->socialLinks->where('type', 'linkedin')->first())->url,
            'Facebook url'   => optional($vcard->socialLinks->where('type', 'facebook')->first())->url,
            'Instagram url'  => optional($vcard->socialLinks->where('type', 'instagram')->first())->url,
        ];
    });
    }
}
