<?php

namespace App\Http\Controllers;

use Exception;
use Razorpay\Api\Api;
use App\Models\NfcOrders;
use Illuminate\View\View;
use Laracasts\Flash\Flash;
use App\Models\Transaction;
use App\Models\Subscription;
use Illuminate\Http\Request;
use App\Models\AffiliateUser;
use App\Mail\AdminNfcOrderMail;
use Illuminate\Http\JsonResponse;
use App\Models\NfcOrderTransaction;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\AppBaseController;
use App\Repositories\SubscriptionRepository;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;
use App\Models\Plan;
use App\Mail\PaymentSuccessMail;
use Carbon\Carbon;


class PaywayController extends AppBaseController
{
    /**
     * @var SubscriptionRepository
     */
    private $subscriptionRepository;

    public function __construct(SubscriptionRepository $subscriptionRepository)
    {
        $this->subscriptionRepository = $subscriptionRepository;
    }




    public function onBoard(Request $request)
    {



        $data = $this->subscriptionRepository->manageSubscription($request->all());
        $subscription = $data['subscription'];

        $mode = getSelectedPaymentGateway('payway_mode');
        $merchant_id = getSelectedPaymentGateway('payway_merchantid');

        $req_time = now()->setTimezone('UTC')->format('YmdHis');
        $tran_id = substr(uniqid(), 0, 20); // Max 20 chars
        $amount = $data['amountToPay'];
        //  $currency = $subscription->plan->currency->currency_code; /* 'USD' */
        $payment_option = 'abapay_khqr';
        $firstname = Auth::user()->full_name;
        // $lastname = 'Doe';
        $email = Auth::user()->email;
        $phone = Auth::user()->contact;


        $return_url = route('payway.success') . '?_token=' . csrf_token() . '&transid=' . $tran_id . '&subscriptionId=' . $subscription->id . '&cardrequests=' . $request->cardrequests;

        $cancel_url = route('payway.success');
        $skip_success_page = 0;
        $continue_success_url = route('payway.continuesuccessurl') . '?_token=' . csrf_token() . '&transid=' . $tran_id . '&subscriptionId=' . $subscription->id . '&cardrequests=' . $request->cardrequests;

        // Concatenate values for hash
        $b4hash = $req_time . $merchant_id . $tran_id . $amount . $firstname .  $email . $phone . $payment_option . $return_url . $continue_success_url;

        $api_key = getSelectedPaymentGateway('payway_secret');
        $hash = base64_encode(hash_hmac('sha512', $b4hash, $api_key, true));

        return response()->json(['link' => 'fdgdtt', 'subscriptionId' => $subscription->id, 'hash' => $hash, 'tran_id' => $tran_id, 'amount' => $amount, 'firstname' => $firstname, 'phone' => $phone, 'email' => $email, 'payment_option' => $payment_option, 'merchant_id' => $merchant_id, 'req_time' => $req_time, 'return_url' => $return_url, 'cardrequests' => $request->cardrequests, 'continue_success_url' => $continue_success_url, 'status' => 200]);

        // Prepare data
        /*  $postData = [
            'hash' => $hash,
            'req_time' => $req_time,
            'merchant_id' => $merchant_id,
            'tran_id' => $tran_id,
            'amount' => $amount,
            'firstname' => $firstname,
            'email' => $email,
            'phone' => $phone,
            'payment_option' => $payment_option,
            'return_url' => $return_url,
            'cancel_url' => $cancel_url,
            'continue_success_url' => $continue_success_url,
            'skip_success_page' => $skip_success_page,
        ];
        if (strtolower($mode)  == 'sandbox') {
            $paywayURL = env('PAYWAY_SANDBOX_URL');
        } else {
            $paywayURL = env('PAYWAY_LIVE_URL');
        }

        
        $response = Http::asMultipart()
            ->withOptions([
                'on_stats' => function (\GuzzleHttp\TransferStats $stats) use (&$finalUrl) {
                    $finalUrl = (string) $stats->getEffectiveUri();
                }
            ])
            ->post($paywayURL . 'payment-gateway/v1/payments/purchase', $postData);

        session(['payment_type' => request()->get('payment_type'), 'subscriptionId' => $subscription->id, 'amounttopay' => $amount, 'tran_id' => $tran_id]);
        return response()->json(['link' => $finalUrl,'subscriptionId' => $subscription->id, 'status' => 200]);*/
    }

    /**
     * @return false|\Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\RedirectResponse
     */


    public function paymentContinnueSuccessURL(Request $request)
    {
        $input = $request->all();
        $req_time = now()->utc()->format('YmdHis');
        $merchant_id = getSelectedPaymentGateway('payway_merchantid');
        $tran_id = $input['transid'];
        $subscriptionID = $input['subscriptionId'];
        $b4hash = $req_time . $merchant_id . $tran_id;

        $api_key = getSelectedPaymentGateway('payway_secret');
        $hash = base64_encode(hash_hmac('sha512', $b4hash, $api_key, true));

        $postData = [
            'hash' => $hash,
            'req_time' => $req_time,
            'merchant_id' => $merchant_id,
            'tran_id' => $tran_id,
        ];

        $mode = getSelectedPaymentGateway('payway_mode');
        if (strtolower($mode)  == 'sandbox') {
            $paywayURL = env('PAYWAY_SANDBOX_URL');
        } else {
            $paywayURL = env('PAYWAY_LIVE_URL');
        }

        // Send POST request
        $response = Http::post($paywayURL . 'payment-gateway/v1/payments/check-transaction-2', $postData);
        $transactionDetails = $response->json();

        // Get the response
        if (
            isset($transactionDetails['status']['code'], $transactionDetails['data']['payment_status']) &&
            $transactionDetails['status']['code'] === '00' &&
            $transactionDetails['data']['payment_status'] === 'APPROVED'
        ) {


            try {


                $amountToPay = $transactionDetails['data']['total_amount'];
                $paymentType = 'payway';

                $subscription = Subscription::find($subscriptionID);

                // Update selected subscription to ACTIVE
                Subscription::findOrFail($subscriptionID)->update(['status' => Subscription::ACTIVE, 'transaction_id' => $transactionDetails['status']['tran_id']]);



                // Create the transaction record
                $transactionId = $transactionDetails['status']['tran_id'] ?? null;

                $existing = Transaction::where('transaction_id', $transactionId)->first();

                if (!$existing && $transactionId) {
                    $transaction = Transaction::create([
                        'tenant_id' => $subscription->tenant_id,
                        'transaction_id' => $transactionId,
                        'type' => $paymentType,
                        'amount' => $amountToPay,
                        'status' => Subscription::ACTIVE,
                        'meta' => $transactionDetails,
                    ]);

                    $date = $transaction->created_at;
                    $formattedDate = $date->format('Y-m-d H:i:s'); // Optional formatting
                } else {
                    // Already exists
                    $transaction = $existing;
                    $formattedDate = $transaction->created_at->format('Y-m-d H:i:s');
                }
                $user = Auth::user();
                $data = $transactionDetails['data'] ?? [];

                $email = $data['email'] ?? null;
                $firstName = $data['first_name'] ?? '';
                $lastName = $data['last_name'] ?? '';
                $name = trim("$firstName $lastName");
                if ($email) {
                    // You can create a dummy user-like object or pass the data separately
                    $pseudoUser = (object)[
                        'first_name' => $firstName,
                        'last_name' => $lastName,
                        'name' => $name,
                        'email' => $email,
                        'transaction_id' => $transactionDetails['status']['tran_id'],
                    ];

                    Mail::to($email)->send(new PaymentSuccessMail($subscription, $amountToPay, $pseudoUser));
                } else {
                    Log::warning("Email not found in transaction data.");
                }
                $prefix = 'ODR';
                $plan = \App\Models\Plan::find($subscription->plan_id);
                $plan_name = $plan->name;

                if (!empty($input['cardrequests'])) {
                    $cardRequest = \App\Models\CardRequest::find($input['cardrequests']);
                    if ($cardRequest) {
                        $subscriptionId = $cardRequest->subscription_id;
                        if ($plan) {
                            $prefix = 'ODR-C';
                            Subscription::findOrFail($subscriptionID)->update(['no_of_vcards' => $subscriptionId]);
                            $perCardPrice = $plan->per_card_price;

                            // 3. Calculate price
                            $totalPrice = $perCardPrice * $subscriptionId;

                            // 4. Update CardRequest (or wherever you're updating)
                            $plan->price = $totalPrice;
                            $plan->no_of_vcards = $subscriptionId;
                            $plan->save();
                        }
                    }
                } else {
                    // Mark all other subscriptions as INACTIVE
                    $inactiveUpdated = Subscription::whereTenantId($subscription->tenant_id)
                        ->where('id', '!=', $subscriptionID)
                        ->where('status', '!=', Subscription::REJECT)
                        ->update(['status' => Subscription::INACTIVE]);
                }
                $date = Carbon::parse($transaction->created_at)->format('Y-m-d');
                $transactionIdFormatted = $prefix . '-' . $date . '-' . $transaction->id;
            } catch (\Exception $e) {
                return view('sadmin.plans.payment.paymentcancel');
            }


            return view('sadmin.plans.payment.paymentSuccess', compact(
                'amountToPay',
                'formattedDate',
                'transactionIdFormatted',
                'plan_name',
                'subscriptionID'
            ));
        } else {
            return view('sadmin.plans.payment.paymentcancel');
        }

        // return view('sadmin.plans.payment.paymentSuccess');

    }



    public function paymentStatusChecker($request)
    {

        $input = $request->all();
        $req_time = now()->utc()->format('YmdHis');
        $merchant_id = getSelectedPaymentGateway('payway_merchantid');
        $tran_id = $input['transid'];
        $subscriptionID = $input['subscriptionId'];
        $b4hash = $req_time . $merchant_id . $tran_id;

        $api_key = getSelectedPaymentGateway('payway_secret');
        $hash = base64_encode(hash_hmac('sha512', $b4hash, $api_key, true));

        $postData = [
            'hash' => $hash,
            'req_time' => $req_time,
            'merchant_id' => $merchant_id,
            'tran_id' => $tran_id,
        ];

        $mode = getSelectedPaymentGateway('payway_mode');
        if (strtolower($mode)  == 'sandbox') {
            $paywayURL = env('PAYWAY_SANDBOX_URL');
        } else {
            $paywayURL = env('PAYWAY_LIVE_URL');
        }

        // Send POST request
        $response = Http::post($paywayURL . 'payment-gateway/v1/payments/check-transaction-2', $postData);
        $transactionDetails = $response->json();

        // Get the response
        if (
            isset($transactionDetails['status']['code'], $transactionDetails['data']['payment_status']) &&
            $transactionDetails['status']['code'] === '00' &&
            $transactionDetails['data']['payment_status'] === 'APPROVED'
        ) {


            try {


                $amountToPay = $transactionDetails['data']['total_amount'];
                $paymentType = 'payway';

                $subscription = Subscription::find($subscriptionID);

                // Update selected subscription to ACTIVE
                Subscription::findOrFail($subscriptionID)->update(['status' => Subscription::ACTIVE, 'transaction_id' => $transactionDetails['status']['tran_id']]);



                // Create the transaction record
                $transactionId = $transactionDetails['status']['tran_id'] ?? null;

                $existing = Transaction::where('transaction_id', $transactionId)->first();

                if (!$existing && $transactionId) {
                    $transaction = Transaction::create([
                        'tenant_id' => $subscription->tenant_id,
                        'transaction_id' => $transactionId,
                        'type' => $paymentType,
                        'amount' => $amountToPay,
                        'status' => Subscription::ACTIVE,
                        'meta' => $transactionDetails,
                    ]);

                    $date = $transaction->created_at;
                    $formattedDate = $date->format('Y-m-d H:i:s'); // Optional formatting
                } else {
                    // Already exists
                    $transaction = $existing;
                    $formattedDate = $transaction->created_at->format('Y-m-d H:i:s');
                }



                $user = Auth::user();

                $data = $transactionDetails['data'] ?? [];

                $email = $data['email'] ?? null;
                $firstName = $data['first_name'] ?? '';
                $lastName = $data['last_name'] ?? '';
                $name = trim("$firstName $lastName");
                //  $email = 'jigsthakor111@gmail.com';
                if ($email) {
                    // You can create a dummy user-like object or pass the data separately
                    $pseudoUser = (object)[
                        'first_name' => $firstName,
                        'last_name' => $lastName,
                        'name' => $name,
                        'email' => $email,
                        'transaction_id' => $transactionDetails['status']['tran_id'],
                    ];

                    Mail::to($email)->send(new PaymentSuccessMail($subscription, $amountToPay, $pseudoUser));
                } else {
                    Log::warning("Email not found in transaction data.");
                }
                $prefix = 'ODR';
                $plan = \App\Models\Plan::find($subscription->plan_id);
                $plan_name = $plan->name;

                if (!empty($input['cardrequests'])) {

                    // 1. Get subscription_id from CardRequest
                    $cardRequest = \App\Models\CardRequest::find($input['cardrequests']);

                    if ($cardRequest) {
                        $subscriptionId = $cardRequest->subscription_id;

                        // 2. Get per_card_price from Plans table (plan id = 4)


                        if ($plan) {
                            $prefix = 'ODR-C';
                            Subscription::findOrFail($subscriptionID)->update(['no_of_vcards' => $subscriptionId]);
                            $perCardPrice = $plan->per_card_price;

                            // 3. Calculate price
                            $totalPrice = $perCardPrice * $subscriptionId;

                            // 4. Update CardRequest (or wherever you're updating)
                            $plan->price = $totalPrice;
                            $plan->no_of_vcards = $subscriptionId;
                            $plan->save();
                        }
                    }
                } else {
                    // Mark all other subscriptions as INACTIVE
                    $inactiveUpdated = Subscription::whereTenantId($subscription->tenant_id)
                        ->where('id', '!=', $subscriptionID)
                        ->where('status', '!=', Subscription::REJECT)
                        ->update(['status' => Subscription::INACTIVE]);
                }

                $date = Carbon::parse($transaction->created_at)->format('Y-m-d');
                $transactionIdFormatted = $prefix . '-' . $date . '-' . $transaction->id;
            } catch (\Exception $e) {
                return false;
                Log::error('Error in Payway transaction handler: ' . $e->getMessage());
                Log::error($e->getTraceAsString());
            }


            return view('sadmin.plans.payment.paymentSuccess', compact(
                'amountToPay',
                'formattedDate',
                'transactionIdFormatted',
                'plan_name'
            ));

            return true;
        } else {
            return false;
        }
    }

    public function paymentSuccess(Request $request)
    {

        $input = $request->all();
        $req_time = now()->utc()->format('YmdHis');
        $merchant_id = getSelectedPaymentGateway('payway_merchantid');
        $tran_id = $input['transid'];
        $subscriptionID = $input['subscriptionId'];
        $b4hash = $req_time . $merchant_id . $tran_id;

        $api_key = getSelectedPaymentGateway('payway_secret');
        $hash = base64_encode(hash_hmac('sha512', $b4hash, $api_key, true));

        $postData = [
            'hash' => $hash,
            'req_time' => $req_time,
            'merchant_id' => $merchant_id,
            'tran_id' => $tran_id,
        ];

        $mode = getSelectedPaymentGateway('payway_mode');
        if (strtolower($mode)  == 'sandbox') {
            $paywayURL = env('PAYWAY_SANDBOX_URL');
        } else {
            $paywayURL = env('PAYWAY_LIVE_URL');
        }

        // Send POST request
        $response = Http::post($paywayURL . 'payment-gateway/v1/payments/check-transaction-2', $postData);
        $transactionDetails = $response->json();

        // Get the response
        if (
            isset($transactionDetails['status']['code'], $transactionDetails['data']['payment_status']) &&
            $transactionDetails['status']['code'] === '00' &&
            $transactionDetails['data']['payment_status'] === 'APPROVED'
        ) {


            try {

                $amountToPay = $transactionDetails['data']['total_amount'];
                $paymentType = 'payway';

                $subscription = Subscription::find($subscriptionID);

                // Update selected subscription to ACTIVE
                Subscription::findOrFail($subscriptionID)->update(['status' => Subscription::ACTIVE, 'transaction_id' => $transactionDetails['status']['tran_id']]);


                // Create the transaction record
                $transactionId = $transactionDetails['status']['tran_id'] ?? null;

                $existing = Transaction::where('transaction_id', $transactionId)->first();

                if (!$existing && $transactionId) {
                    $transaction = Transaction::create([
                        'tenant_id' => $subscription->tenant_id,
                        'transaction_id' => $transactionId,
                        'type' => $paymentType,
                        'amount' => $amountToPay,
                        'status' => Subscription::ACTIVE,
                        'meta' => $transactionDetails,
                    ]);

                    $date = $transaction->created_at;
                    $formattedDate = $date->format('Y-m-d H:i:s'); // Optional formatting
                } else {
                    // Already exists
                    $transaction = $existing;
                    $formattedDate = $transaction->created_at->format('Y-m-d H:i:s');
                }

                if (!empty($input['cardrequests'])) {

                    // 1. Get subscription_id from CardRequest
                    $cardRequest = \App\Models\CardRequest::find($input['cardrequests']);

                    if ($cardRequest) {
                        $subscriptionId = $cardRequest->subscription_id;

                        // 2. Get per_card_price from Plans table (plan id = 4)
                        $plan = \App\Models\Plan::find($subscription->plan_id);

                        if ($plan) {
                            Subscription::findOrFail($subscriptionID)->update(['no_of_vcards' => $subscriptionId]);
                            $perCardPrice = $plan->per_card_price;

                            // 3. Calculate price
                            $totalPrice = $perCardPrice * $subscriptionId;

                            // 4. Update CardRequest (or wherever you're updating)
                            $plan->price = $totalPrice;
                            $plan->no_of_vcards = $subscriptionId;
                            $plan->save();
                        }
                    }
                } else {
                    // Mark all other subscriptions as INACTIVE
                    Subscription::whereTenantId($subscription->tenant_id)
                        ->where('id', '!=', $subscriptionID)
                        ->where('status', '!=', Subscription::REJECT)
                        ->update(['status' => Subscription::INACTIVE]);
                }
            } catch (\Exception $e) {
                Log::error('Error in Payway transaction handler: ' . $e->getMessage());
                Log::error($e->getTraceAsString());
                return false;
            }

            return response()->json(['status' => true, 'response' => $transactionDetails]);
        } else {
            return response()->json(['status' => false, 'response' => $transactionDetails]);
        }
    }

    /**
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function paymentFailed(): View
    {
        return view('sadmin.plans.payment.paymentcancel');
    }

    public function nfcPaymentSuccess(Request $request)
    {
        $input = $request->all();

        $api = new Api(getSelectedPaymentGateway('razorpay_key'), getSelectedPaymentGateway('razorpay_secret'));

        if (count($input) && ! empty($input['razorpay_payment_id'])) {
            try {
                $payment = $api->payment->fetch($input['razorpay_payment_id']);
                $generatedSignature = hash_hmac(
                    'sha256',
                    $payment['order_id'] . '|' . $input['razorpay_payment_id'],
                    getSelectedPaymentGateway('razorpay_secret')
                );

                if ($generatedSignature != $input['razorpay_signature']) {
                    return redirect()->back();
                }

                // $nfcOrder = NfcOrders::create([
                //     'name' => $payment['notes']['customer_name'],
                //     'designation' => $payment['notes']['designation'],
                //     'phone' => $payment['notes']['phone'],
                //     'email' => $payment['notes']['email'],
                //     'address' => $payment['notes']['address'],
                //     'company_name' => $payment['notes']['company_name'],
                //     'order_status' => NfcOrders::PENDING,
                //     'card_type' => $payment['notes']['card_type'],
                //     'user_id' => getLogInUserId(),
                //     'vcard_id' => $payment['notes']['vcard_id'],

                // ]);

                $id = session()->get('orderid');
                NfcOrders::where('id', $id)->update(['order_status' => NfcOrders::PENDING]);
                $nfcOrder = NfcOrders::where('id', $id)->get();


                NfcOrderTransaction::create([
                    'nfc_order_id' => $id,
                    'type' => NfcOrders::RAZOR_PAY,
                    'transaction_id' => $payment->id,
                    'amount' => $payment['notes']['amountToPay'],
                    'user_id' => getLogInUser()->id,
                    'status' => NfcOrders::SUCCESS,
                ]);

                Mail::to(getSuperAdminSettingValue('email'))->send(new AdminNfcOrderMail($nfcOrder[0]));

                Flash::success("Order Placed Successfully");

                return redirect(route('user.orders'));
            } catch (Exception $e) {
                Log::info($e->getMessage());
                return false;
            }
        }

        return redirect()->back();
    }

    public function nfcPaymentFailed(Request $request): View
    {
        $input = $request->all();
        $api = new Api(getSelectedPaymentGateway('razorpay_key'), getSelectedPaymentGateway('razorpay_secret'));
        $payment = $api->payment->fetch($input['razorpay_payment_id']);

        $id = session()->get('orderid');
        NfcOrders::where('id', $id)->update(['order_status' => NfcOrders::PENDING]);
        $nfcOrder = NfcOrders::where('id', $id)->get();

        // $nfcOrder = NfcOrders::create([
        //     'name' => $payment['notes']['customer_name'],
        //     'designation' => $payment['notes']['designation'],
        //     'phone' => $payment['notes']['phone'],
        //     'email' => $payment['notes']['email'],
        //     'address' => $payment['notes']['address'],
        //     'company_name' => $payment['notes']['company_name'],
        //     'order_status' => NfcOrders::PENDING,
        //     'card_type' => $payment['notes']['card_type'],
        //     'user_id' => getLogInUserId(),
        //     'vcard_id' => $payment['notes']['vcard_id'],

        // ]);

        NfcOrderTransaction::create([
            'nfc_order_id' => $id,
            'type' => NfcOrders::RAZOR_PAY,
            'transaction_id' => $payment->id,
            'amount' => $payment['notes']['amountToPay'],
            'user_id' => getLogInUser()->id,
            'status' => NfcOrders::FAIL,
        ]);

        return view('sadmin.plans.payment.paymentcancel');
    }
}
