<?php
namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Subscription;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Mail\SubscriptionExpirationMail;
use App\Http\Controllers\AppBaseController;

class SubscriptionReminderController extends AppBaseController
{

    public function subscriptionReminder()
    {

        $notificationDays = getSuperAdminSettingValue('plan_expire_notification') ?? 7;

        $today = now();
        $targetDate = now()->addDays($notificationDays);

        // Get subscriptions expiring in next X days
        $subscriptions = Subscription::with('plan')
            ->where('status', Subscription::ACTIVE)
            ->whereBetween('ends_at', [$today, $targetDate])
            ->get();
        // dd($subscriptions);

        $isExpired = false;


        foreach ($subscriptions as $subscription) {
            $endDate = Carbon::parse($subscription->ends_at);

            $days = $today->startOfDay()->diffInDays($endDate->startOfDay(), false);

                $user = User::whereTenantId($subscription->tenant_id)
                    ->where('is_active', User::IS_ACTIVE)
                    ->whereNotNull('email_verified_at')
                    ->first();

                if ($user) {
                    // Send email notification
                    Mail::to('valandaditya2004@gmail.com')->send(
                        new SubscriptionExpirationMail(
                            $subscription,
                            $user,
                            $days,
                            $isExpired
                        )
                    );


                }

        }

        // $this->info("Completed! Expiring: {$expiringCount}, Expired: {$expiredCount}, Errors: {$errorCount}");


        return response()->json([
            'status' => 'success',
            'message' => 'Subscription remainder API is working',
        ]);
    }
}

?>
