<?php

namespace App\Http\Livewire;

use App\Models\Plan;
use App\Models\Subscription;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;


class UsersubscriptionTable extends LivewireTableComponent
{

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setDefaultSort('created_at', 'desc');

        $this->setThAttributes(function (Column $column) {
            if ($column->isField('status')) {
                return [
                    'class' => 'd-flex justify-content-center',
                ];
            }
            return [];
        });

        $this->setTdAttributes(function (Column $column) {
            if ($column->isField('status')) {
                return [
                    'class' => 'text-center',
                ];
            }
            return [];
        });
    }
    public function columns(): array
    {
        return [
            Column::make(__('messages.subscription.plan_name'), 'plan.name')
                ->sortable(function (Builder $query, $direction) {
                    return $query->orderBy(Plan::select('name')->whereColumn('subscriptions.plan_id', 'plans.id'),
                        $direction);
                })->searchable(),
            Column::make(__('messages.subscription.amount'), 'payable_amount')
                ->sortable()
                ->format(function($value, $row) {
                    // Show the actual plan's currency (not user preference)
                    $currencyIcon = $row->plan->currency->currency_icon;
                    $currencyCode = $row->plan->currency->currency_code ?? '';

                    // Replace Rs with රු for LKR plans
                    if ($currencyCode === 'LKR') {
                        $currencyIcon = str_replace(['Rs', 'Rs.', 'LKR'], 'LKR', $currencyIcon);
                    }

                    return $currencyIcon . ' ' . number_format($value, 2);
                }),
            Column::make(__('messages.subscription.subscribed_date'), 'starts_at')
                ->sortable(),
            Column::make(__('messages.subscription.expired_date'), 'ends_at')->sortable(),
            Column::make(__('messages.common.status'), 'status')->sortable()->view('subscription.columns.status'),
            Column::make('Invoice')->label(function($row) {
                return view('subscription.columns.invoice', ['subscription' => $row]);
            }),
        ];
    }

    public function builder(): Builder
    {
        return Subscription::with(['plan.currency'])->where('tenant_id', getLogInTenantId())->select('subscriptions.*');
    }

}
