<?php

namespace App\Http\Livewire;

use App\Models\Testimonial;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;


class VcardTestimonialTable extends LivewireTableComponent
{
    protected $model = Testimonial::class;

    public bool $showButtonOnHeader = true;

    public string $buttonComponent = 'vcards.testimonials.add-button';

    protected $listeners = ['refresh' => '$refresh', 'resetPageTable'];

    public $vcardId;

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setPageName('vcard-testimonial-table');
        $this->setDefaultSort('created_at','desc');
        $this->setColumnSelectStatus(false);
        $this->setPerPage(10);

        $this->setThAttributes(function (Column $column) {
            if ($column->isField('id')) {
                return [
                    'class' => 'd-flex justify-content-center',
                ];
            }

            return [];
        });
    }
    public function columns(): array
    {
        return [
            Column::make(__('messages.vcard.image'), 'created_at')->view('vcards.testimonials.columns.icon'),
            Column::make(__('messages.common.name'), 'name')
                ->sortable()->searchable(),
            Column::make(__('messages.common.action'), 'id')->view('vcards.testimonials.columns.action'),

        ];
    }
    public function builder(): Builder
    {
        return Testimonial::whereVcardId($this->vcardId)->select('testimonials.*');
    }

    public function resetPageTable($pageName = 'vcard-testimonial-table')
    {
        $rowsPropertyData = $this->getRows()->toArray();
        $prevPageNum = $rowsPropertyData['current_page'] - 1;
        $prevPageNum = $prevPageNum > 0 ? $prevPageNum : 1;
        $pageNum = count($rowsPropertyData['data']) > 0 ? $rowsPropertyData['current_page'] : $prevPageNum;

        $this->setPage($pageNum, $pageName);
    }
}
