<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateGetStartedContactRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required|string|min:2|max:255',
            'last_name' => 'required|string|min:2|max:255',
            'email' => 'required|email:filter|max:255',
            'phone' => 'required|string|max:255',
            'message' => 'required|string|min:10|max:1000',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'first_name.required' => __('messages.placeholder.first_name_required'),
            'last_name.required' => __('messages.placeholder.last_name_required'),
            'email.required' => __('messages.placeholder.email_required'),
            'email.email' => __('messages.placeholder.email_must_be_valid'),
            'phone.required' => __('messages.placeholder.phone_required'),
            'message.required' => __('messages.placeholder.message_required'),
            'message.min' => __('messages.placeholder.message_min'),
        ];
    }
}

