<?php
namespace App\Imports;

use App\Models\Vcard;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsErrors;


class VcardsImport implements ToModel, WithHeadingRow, SkipsOnError
{
     use Importable, SkipsErrors;

    private $allowedCount;
    private $existingCount;
    private $rowsCount = 0;

    public function model(array $row)
    {
        return new Vcard([
            'user_id'     => Auth::id(),
            'url_alias'   => $row['url_alias'] ?? null,
            'VCard Name'        => $row['name'] ?? null,
            'occupation'  => $row['occupation'] ?? null,
            'description' => $row['description'] ?? null,
            'First Name'  => $row['first_name'] ?? null,
            'Last Name'   => $row['last_name'] ?? null,
            'email'       => $row['email'] ?? null,
            'company'     => $row['company'] ?? null,
            'dob'         => $row['dob'] ?? null,
            'job_title'   => $row['job_title'] ?? null,
        ]);
    }
}
