<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VcardSections extends Model
{
    use HasFactory;

    protected $table = 'vcard_sections';

    /**
     * @var array
     */
    protected $fillable = [
        'vcard_id',
        'header',
        'contact_list',
        'services',
        'products',
        'galleries',
        'blogs',
        'map',
        'testimonials',
        'business_hours',
        'appointments',
    ];

    protected $casts = [
        'vcard_id' => 'integer',
        'header' => 'string',
        'contact_list' => 'string',
        'services' => 'string',
        'products' => 'string',
        'galleries' => 'string',
        'blogs' => 'string',
        'map' => 'string',
        'testimonials' => 'string',
        'business_hours' => 'string',
        'appointments' => 'string',
    ];
}
