/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.auth":{"about":"\u0639\u0646","account_deactivate":"\u062d\u0633\u0627\u0628\u0643 \u063a\u064a\u0631 \u0646\u0634\u0637 \u062d\u0627\u0644\u064a\u0627 \u060c \u064a\u0631\u062c\u0649 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0628\u0627\u0644\u0645\u0633\u0624\u0648\u0644.","app":{"create":"\u064a\u062e\u0644\u0642","export":"\u064a\u0635\u062f\u0631","lock_account":"\u062d\u0633\u0627\u0628 \u0642\u0641\u0644","member_since":"\u0639\u0636\u0648 \u0645\u0646\u0630","messages":"\u0631\u0633\u0627\u0626\u0644","online":"\u0645\u062a\u0635\u0644","print":"\u0645\u0637\u0628\u0639\u0629","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","reload":"\u0625\u0639\u0627\u062f\u0629 \u062a\u062d\u0645\u064a\u0644","reset":"\u0625\u0639\u0627\u062f\u0629 \u0636\u0628\u0637","search":"\u0628\u062d\u062b","settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a"},"choose_a_plan_that's_right_for_you":"\u0627\u062e\u062a\u0631 \u062e\u0637\u0629 \u062a\u0646\u0627\u0633\u0628\u0643","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact":"\u0627\u062a\u0635\u0644","copyright_by":"\u062d\u0642\u0648\u0642 \u0627\u0644\u0637\u0628\u0639 \u0644","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_verify":"\u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0642\u0628\u0644 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644.","emails":{"password":{"reset_link":"\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643"}},"failed":"\u0623\u0648\u0631\u0627\u0642 \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0647\u0630\u0647 \u0644\u0627 \u062a\u062a\u0637\u0627\u0628\u0642 \u0645\u0639 \u0633\u062c\u0644\u0627\u062a\u0646\u0627.","features":"\u0633\u0645\u0627\u062a","forgot_password":{"send_pwd_reset":"\u0625\u0631\u0633\u0627\u0644 \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631","title":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631"},"full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","get_started":"\u0627\u0644\u0628\u062f\u0621","home":"\u0645\u0633\u0643\u0646","let's_hear_what_they_say":"\u062f\u0639\u0648\u0646\u0627 \u0646\u0633\u0645\u0639 \u0645\u0627 \u064a\u0642\u0648\u0644\u0648\u0646","login":{"forgot_password":"\u0644\u0642\u062f \u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","register_membership":"\u062a\u0633\u062c\u064a\u0644 \u0639\u0636\u0648\u064a\u0629 \u062c\u062f\u064a\u062f\u0629","title":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0628\u062f\u0621 \u0627\u0644\u062c\u0644\u0633\u0629 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643"},"modern_&_powerful_interface":"\u0648\u0627\u062c\u0647\u0629 \u062d\u062f\u064a\u062b\u0629 \u0648\u0642\u0648\u064a\u0629","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","pricing":"\u0627\u0644\u062a\u0633\u0639\u064a\u0631","register":"\u064a\u0633\u062c\u0644","registration":{"have_membership":"\u0644\u062f\u064a \u0639\u0636\u0648\u064a\u0629 \u0628\u0627\u0644\u0641\u0639\u0644","i_agree":"\u0623\u0648\u0627\u0641\u0642 \u0639\u0644\u0649","terms":"\u0627\u0644\u0634\u0631\u0648\u0637","title":"\u062a\u0633\u062c\u064a\u0644 \u0639\u0636\u0648\u064a\u0629 \u062c\u062f\u064a\u062f\u0629"},"remember_me":"\u062a\u0630\u0643\u0631\u0646\u0649","reset_password":{"reset_pwd_btn":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","title":"\u0627\u0639\u062f \u0636\u0628\u0637 \u0643\u0644\u0645\u0647 \u0627\u0644\u0633\u0631"},"sign_in":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","sign_out":"\u062e\u0631\u0648\u062c","sign_up":"\u0627\u0634\u062a\u0631\u0627\u0643","stories_from_our_customers":"\u0642\u0635\u0635 \u0645\u0646 \u0639\u0645\u0644\u0627\u0626\u0646\u0627","subscribe_here":"\u0627\u0634\u062a\u0631\u0643 \u0647\u0646\u0627","throttle":"\u0645\u062d\u0627\u0648\u0644\u0627\u062a \u062a\u0633\u062c\u064a\u0644 \u062f\u062e\u0648\u0644 \u0643\u062b\u064a\u0631\u0629 \u062c\u062f\u064b\u0627. \u064a\u0631\u062c\u0649 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u0641\u064a: \u062b\u0648\u0627\u0646\u064a."},"ar.cookie-consent::texts":{"agree":"\u0627\u0644\u0633\u0645\u0627\u062d","message":"\u0633\u064a\u062a\u0645 \u062a\u062d\u0633\u064a\u0646 \u062a\u062c\u0631\u0628\u062a\u0646\u0627 \u0639\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u0642\u0639 \u0645\u0646 \u062e\u0644\u0627\u0644 \u0627\u0644\u0633\u0645\u0627\u062d \u0628\u0645\u0644\u0641\u0627\u062a \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637"},"ar.cookieConsent::texts":{"agree":"\u0627\u0644\u0633\u0645\u0627\u062d","message":"\u0633\u064a\u062a\u0645 \u062a\u062d\u0633\u064a\u0646 \u062a\u062c\u0631\u0628\u062a\u0646\u0627 \u0639\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u0642\u0639 \u0645\u0646 \u062e\u0644\u0627\u0644 \u0627\u0644\u0633\u0645\u0627\u062d \u0628\u0645\u0644\u0641\u0627\u062a \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637"},"ar.crud":{"action":"\u0639\u0645\u0644","add_new":"\u0627\u0636\u0641 \u062c\u062f\u064a\u062f","are_you_sure":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f\u061f","back":"\u0639\u0648\u062f\u0629","cancel":"\u064a\u0644\u063a\u064a","created_at":"\u0623\u0646\u0634\u0626\u062a \u0641\u064a","deleted_at":"\u0645\u062d\u0630\u0648\u0641 \u0641\u064a","detail":"\u0627\u0644\u062a\u0641\u0627\u0635\u064a\u0644","edit":"\u062a\u0639\u062f\u064a\u0644","id":"\u0628\u0637\u0627\u0642\u0629 \u062a\u0639\u0631\u064a\u0641","save":"\u064a\u062d\u0641\u0638","updated_at":"\u062a\u0645 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0641\u064a"},"ar.livewire-tables::strings":{"All":"\u0627\u0644\u0643\u0644","Applied Filters":"\u0627\u0644\u062a\u0635\u0641\u064a\u0627\u062a \u0627\u0644\u0645\u0637\u0628\u0642\u0629","Applied Sorting":"\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0645\u0637\u0628\u0642","Bulk Actions":"\u0625\u062c\u0631\u0627\u0621\u0627\u062a","Clear":"\u0645\u0633\u062d","Filters":"\u0627\u0644\u062a\u0635\u0641\u064a\u0627\u062a","Remove filter option":"\u062d\u0630\u0641 \u062e\u064a\u0627\u0631 \u0627\u0644\u062a\u0635\u0641\u064a\u0629","Remove sort option":"\u062d\u0630\u0641 \u062e\u064a\u0627\u0631 \u0627\u0644\u062a\u0631\u062a\u064a\u0628","Search":"\u0628\u062d\u062b","Select All":"\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644","Show":"\u064a\u0639\u0631\u0636","Showing":"\u0627\u0633\u062a\u0639\u0631\u0627\u0636","Unselect All":"\u0625\u0644\u063a\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644","You are currently selecting all":"\u0623\u0646\u062a \u0627\u0644\u0622\u0646 \u062a\u062e\u062a\u0627\u0631 \u0627\u0644\u0643\u0644","You are not connected to the internet.":"\u0623\u0646\u062a \u063a\u064a\u0631 \u0645\u062a\u0635\u0644 \u0628\u0627\u0644\u0625\u0646\u062a\u0631\u0646\u062a.","You have selected":"\u0644\u0642\u062f \u0642\u0645\u062a \u0628\u0627\u062e\u062a\u064a\u0627\u0631","of":"\u0645\u0646","results":"\u0627\u0644\u0646\u062a\u0627\u0626\u062c","rows":"\u0635\u0641\u0648\u0641","rows, do you want to select all":"\u0627\u0644\u0635\u0641\u0648\u0641 \u060c \u0647\u0644 \u062a\u0631\u064a\u062f \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644","to":"\u0625\u0644\u0649"},"ar.messages":{"Business_Beacon":"\u0645\u0646\u0627\u0631\u0629 \u0627\u0644\u0623\u0639\u0645\u0627\u0644","CEO\/CXO":"\u0627\u0644\u0631\u0624\u0633\u0627\u0621 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a\u0648\u0646 \u0644\u0644\u0634\u0631\u0643\u0627\u062a\/CXOs vCard","Clean_Canvas":"\u0642\u0645\u0627\u0634 \u0646\u0638\u064a\u0641","Corporate_Classic":"\u0627\u0644\u0634\u0631\u0643\u0627\u062a \u0627\u0644\u0643\u0644\u0627\u0633\u064a\u0643\u064a\u0629","Corporate_Connect":"\u0627\u062a\u0635\u0627\u0644 \u0627\u0644\u0634\u0631\u0643\u0627\u062a","Corporate_Identity":"\u0647\u0648\u064a\u0629 \u0627\u0644\u0634\u0631\u0643\u0629","Culinary_Food_Services":"\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u0637\u0647\u064a \u0648\u0627\u0644\u0623\u063a\u0630\u064a\u0629 vCard","Event_Management":"\u0623\u062f\u0627\u0631\u0629 \u0627\u0644\u062d\u062f\u062b","Executive_Profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u062a\u0646\u0641\u064a\u0630\u064a","Fashion_Beauty":"\u0627\u0644\u0645\u0648\u0636\u0629 \u0648\u0627\u0644\u062c\u0645\u0627\u0644 vCard","Gym":"\u0646\u0627\u062f\u064a \u0631\u064a\u0627\u0636\u064a","Hospital":"\u0645\u0633\u062a\u0634\u0641\u0649","Lawyer":"\u0645\u062d\u0627\u0645\u064a","Manually":"\u064a\u062f\u0648\u064a\u0627","Modern_Edge":"\u0627\u0644\u062d\u0627\u0641\u0629 \u0627\u0644\u062d\u062f\u064a\u062b\u0629","Nov":"test","Paypal":"\u0628\u0627\u064a \u0628\u0627\u0644","Portfolio":"\u0645\u064e\u0644\u064e\u0641\u0651","Pro_Network":"\u0634\u0628\u0643\u0629 \u0628\u0631\u0648","Professional":"\u0627\u062d\u062a\u0631\u0627\u0641\u064a","Programmer":"\u0645\u0628\u0631\u0645\u062c","Razorpay":"\u0631\u0627\u0632\u0648\u0631\u0628\u0627\u064a","Receive_latest_news_update_and_many_other_things_every_week":"\u0627\u062d\u0635\u0644 \u0639\u0644\u0649 \u0622\u062e\u0631 \u0627\u0644\u0623\u062e\u0628\u0627\u0631 \u0648\u0627\u0644\u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0648\u0623\u0634\u064a\u0627\u0621 \u0623\u062e\u0631\u0649 \u0643\u062b\u064a\u0631\u0629 \u0643\u0644 \u0623\u0633\u0628\u0648\u0639.","Salon":"\u0635\u0627\u0644\u0648\u0646","Simple_Contact":"\u0627\u062a\u0635\u0627\u0644 \u0628\u0633\u064a\u0637","Social_Media":"\u0645\u0624\u062b\u0631\u0648 \u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u062a\u0648\u0627\u0635\u0644 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a vCard","Stripe":"\u0634\u0631\u064a\u0637","Subscribe_Our_Newsletter":"\u0627\u0634\u062a\u0631\u0643 \u0641\u064a \u0627\u0644\u0646\u0634\u0631\u0629 \u0627\u0644\u0625\u062e\u0628\u0627\u0631\u064a\u0629 \u0644\u062f\u064a\u0646\u0627","about_us":{"about_us":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0639\u0646\u0627","description":"\u0648\u0635\u0641","image":"\u062d\u0648\u0644 \u0627\u0644\u0635\u0648\u0631\u0629","title":"\u0639\u0646\u0648\u0627\u0646"},"admin":{"add_admin":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","admin":"\u0645\u0633\u0624\u0644","admin_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0628\u0646\u062c\u0627\u062d.","admin_delete_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0628\u0646\u062c\u0627\u062d.","admin_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","admin_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0628\u0646\u062c\u0627\u062d.","avatar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0631\u0645\u0632\u064a\u0629","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","edit_admin":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","female":"\u0623\u0646\u062b\u0649","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0627\u0648\u0644","full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","gender":"\u062c\u0646\u0633 \u062a\u0630\u0643\u064a\u0631 \u0623\u0648 \u062a\u0623\u0646\u064a\u062b","last_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0627\u0626\u0644\u0629","male":"\u0630\u0643\u0631","not_allowed_to_access":"\u064a\u0628\u062f\u0648 \u0623\u0646\u0647 \u063a\u064a\u0631 \u0645\u0633\u0645\u0648\u062d \u0644\u0643 \u0628\u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u0633\u062c\u0644.","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","profile_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a"},"admins":"\u0627\u0644\u0645\u0634\u0631\u0641\u0648\u0646","affiliation":{"affiliate_note":"\u0645\u0644\u062d\u0648\u0638\u0629: \u0633\u064a\u062a\u0645 \u0639\u0631\u0636 \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u062a\u0627\u0628\u0639\u0629 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u0639\u0644\u0649 \u0635\u0641\u062d\u0629 vcards \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u0641\u064a \u0627\u0644\u0623\u0633\u0641\u0644. \u0639\u0646\u062f\u0645\u0627 \u064a\u0642\u0648\u0645 \u0634\u062e\u0635 \u0645\u0627 \u0628\u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u0645\u0646 \u062e\u0644\u0627\u0644 \u0647\u0630\u0627 \u0648\u0634\u0631\u0627\u0621 \u0627\u0634\u062a\u0631\u0627\u0643 \u0628\u0639\u062f \u0630\u0644\u0643\u060c \u0633\u062a\u062a\u0645 \u0645\u0643\u0627\u0641\u0623\u062a\u0643 \u0628\u0645\u0628\u0644\u063a \u0631\u0648\u0628\u064a\u0629 \u0647\u0646\u062f\u064a\u0629","affiliated_by":"\u062a\u0627\u0628\u0639 \u0628\u0648\u0627\u0633\u0637\u0629","affiliation_transaction":"\u0645\u0639\u0627\u0645\u0644\u0627\u062a \u0627\u0644\u0627\u0646\u062a\u0633\u0627\u0628","affiliation_withdraw_detail":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0633\u062d\u0628 \u0627\u0644\u0627\u0646\u062a\u0633\u0627\u0628","affiliations":"\u0627\u0644\u0627\u0646\u062a\u0645\u0627\u0621\u0627\u062a","approval_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0642\u0628\u0648\u0644","approve":"\u064a\u0639\u062a\u0645\u062f","approve_withdraw_request":"\u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0637\u0644\u0628 \u0627\u0644\u0633\u062d\u0628","approved":"\u0648\u0627\u0641\u0642","cash_payment":"\u0627\u0644\u062a\u0633\u062f\u064a\u062f \u0646\u0642\u0630\u0627","current_amount":"\u0627\u0644\u0642\u064a\u0645\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629","reject":"\u064a\u0631\u0641\u0636","reject_withdraw_request":"\u0631\u0641\u0636 \u0637\u0644\u0628 \u0627\u0644\u0633\u062d\u0628","rejected":"\u0645\u0631\u0641\u0648\u0636","rejection_note":"\u0645\u0630\u0643\u0631\u0629 \u0627\u0644\u0631\u0641\u0636","total_affiliation_amount":"\u0625\u062c\u0645\u0627\u0644\u064a \u0645\u0628\u0644\u063a \u0627\u0644\u0627\u0646\u062a\u0633\u0627\u0628","verify_paypal_email":"\u062a\u062d\u0642\u0642 \u0645\u0646 \u0628\u0631\u064a\u062f Paypal \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","withdraw_amount":"\u0633\u062d\u0628 \u0627\u0644\u0645\u0628\u0644\u063a","withdrawal":"\u0627\u0646\u0633\u062d\u0627\u0628,"},"allowed_file_types":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","analytic":{"vcard_analytic":"\u062a\u062d\u0644\u064a\u0644\u064a Vcard"},"analytics":{"browsers":"\u0627\u0644\u0645\u062a\u0635\u0641\u062d\u0627\u062a","countries":"\u0627\u0644\u062f\u0648\u0644","devices":"\u0627\u0644\u0623\u062c\u0647\u0632\u0629","languages":"\u0627\u0644\u0644\u063a\u0627\u062a","os":"\u0623\u0646\u0638\u0645\u0629 \u0627\u0644\u062a\u0634\u063a\u064a\u0644","overview":"\u0645\u0644\u062e\u0635","see_all":"\u0627\u0638\u0647\u0627\u0631 \u0627\u0644\u0643\u0644","view_more":"\u0639\u0631\u0636 \u0627\u0644\u0645\u0632\u064a\u062f","visitors":"\u0627\u0644\u0632\u0627\u0626\u0631\u064a\u0646"},"appointment":{"appointment":"\u0645\u064a\u0639\u0627\u062f","appointment_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0648\u0639\u062f","appointment_type":"\u0646\u0648\u0639 \u0627\u0644\u0645\u0648\u0639\u062f:","calendar":"\u062a\u0642\u0648\u064a\u0645","ends":"\u0627\u0644\u0645\u0648\u0639\u062f \u064a\u0646\u062a\u0647\u064a","free":"\u062d\u0631","paid":"\u062f\u0641\u0639","starts":"\u064a\u0628\u062f\u0623 \u0627\u0644\u0645\u0648\u0639\u062f"},"appointments":"\u062a\u0639\u064a\u064a\u0646\u0627\u062a","business":{"business_hours":"\u0633\u0627\u0639\u0627\u062a \u0627\u0644\u0639\u0645\u0644","end_time":"\u0648\u0642\u062a \u0627\u0644\u0646\u0647\u0627\u064a\u0629","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","mon":"\u0627\u0644\u0625\u062b\u0646\u064a\u0646","sat":"\u062c\u0644\u0633","start_time":"\u0648\u0642\u062a \u0627\u0644\u0628\u062f\u0621","sun":"\u0627\u0644\u0623\u062d\u062f","thu":"\u062a\u062c\u0645\u064a\u0639","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","wed":"\u062a\u0632\u0648\u062c"},"by_signing_up_you_agree_to_our":"\u0628\u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u0641\u0625\u0646\u0643 \u062a\u0648\u0627\u0641\u0642 \u0639\u0644\u0649","cash_payment":"\u0627\u0644\u062a\u0633\u062f\u064a\u062f \u0646\u0642\u0630\u0627","city":{"cities":"\u0645\u062f\u0646","city":"\u0645\u062f\u064a\u0646\u0629","city_name":"\u0627\u0633\u0645 \u0627\u0644\u0645\u062f\u064a\u0646\u0629","edit_city":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u062f\u064a\u0646\u0629","new_city":"\u0645\u062f\u064a\u0646\u0629 \u062c\u062f\u064a\u062f\u0629","no_city_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0645\u062f\u064a\u0646\u0629 \u0645\u062a\u0627\u062d\u0629","no_city_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u062f\u064a\u0646\u0629","state_name":"\u0627\u0633\u0645 \u0627\u0644\u0648\u0644\u0627\u064a\u0629"},"common":{"Yes_Change":"\u0646\u0639\u0645 \u060c \u0627\u0644\u062a\u063a\u064a\u064a\u0631","action":"\u0639\u0645\u0644","active":"\u0646\u0634\u064a\u0637","add":"\u064a\u0636\u064a\u0641","add_virtual_background":"\u0623\u0636\u0641 \u062e\u0644\u0641\u064a\u0629 \u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","allow_cookies":"\u0627\u0644\u0633\u0645\u0627\u062d \u0644\u0644\u0643\u0648\u0643\u064a\u0632","already_have_an_account":"\u0647\u0644 \u0644\u062f\u064a\u0643 \u062d\u0633\u0627\u0628","apply":"\u064a\u062a\u0642\u062f\u0645","apply_changes":"\u0642\u0645 \u0628\u062a\u0637\u0628\u064a\u0642 \u0647\u0630\u0647 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a","are_you_completed":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062a\u063a\u064a\u064a\u0631 \u0647\u0630\u0647 \u0627\u0644\u062d\u0627\u0644\u0629\u061f","are_you_sure":"\u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_dublicate_vcard":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062e\u0629 \u0645\u0643\u0631\u0631\u0629 \u0645\u0646 VCard \u0647\u0630\u0647\u061f","back":"\u0639\u0648\u062f\u0629","back_subscription":"\u0631\u062c\u0648\u0639 \u0625\u0644\u0649 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643\u0627\u062a","cancel":"\u064a\u0644\u063a\u064a","captcha_enable":"\u062a\u0645\u0643\u064a\u0646 \u062c\u0648\u062c\u0644 \u0643\u0627\u0628\u062a\u0634\u0627","closed":"\u0645\u063a\u0644\u0642","completed":"\u0645\u0643\u062a\u0645\u0644","cookie_banner_enabled":"\u062a\u0645\u0643\u064a\u0646 \u0634\u0639\u0627\u0631 \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637","cookie_msg":"\u0633\u064a\u062a\u0645 \u062a\u062d\u0633\u064a\u0646 \u062a\u062c\u0631\u0628\u062a\u0643 \u0639\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u0645\u0648\u0642\u0639 \u0645\u0646 \u062e\u0644\u0627\u0644 \u0627\u0644\u0633\u0645\u0627\u062d \u0628\u0645\u0644\u0641\u0627\u062a \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637.","create_an_account":"\u0627\u0646\u0634\u0626 \u062d\u0633\u0627\u0628","currency_position":"\u0648\u0636\u0639 \u0627\u0644\u0639\u0645\u0644\u0629","custom":"\u0627\u0644\u0639\u0627\u062f\u0629","declined":"\u0627\u0646\u062e\u0641\u0627\u0636","default_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a","delete":"\u062d\u0630\u0641","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641","description":"\u0648\u0635\u0641","details":"\u062a\u0641\u0627\u0635\u064a\u0644","discard":"\u062a\u062c\u0627\u0647\u0644","download":"\u062a\u062d\u0645\u064a\u0644","duplicate":"\u064a\u0646\u0633\u062e !","duplicate_vcard_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0646\u0633\u062e\u0629 Vcard \u0645\u0643\u0631\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","edit":"\u062a\u0639\u062f\u064a\u0644","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enable_cookie_banner":"\u062a\u0641\u0639\u064a\u0644 \u0634\u0639\u0627\u0631 \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637","enable_page":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0645\u0642\u0635\u0648\u062f\u0629","enable_register":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u062a\u0633\u062c\u064a\u0644","enable_validation":"\u062a\u0641\u0639\u064a\u0644 \u0627\u0644\u062a\u062d\u0642\u0642","enquiry":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631\u0627\u062a","error":"\u062e\u0637\u0623","filter":"\u0645\u0646\u0642\u064a","forgot_password":"\u0647\u0644 \u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631","forgot_your_password":"\u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","from":"\u0645\u0646","has_been_completed":"\u0642\u062f \u062a\u0643\u062a\u0645\u0644.","has_been_deleted":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641.","icon":"\u0623\u064a\u0642\u0648\u0646\u0629","inactive":"\u063a\u064a\u0631 \u0646\u0634\u0637","infyvcard":"InfyVcard","is_active":"\u0646\u0634\u0637","link":"\u0648\u0635\u0644\u0629","loading":"\u062c\u0627\u0631 \u0627\u0644\u062a\u062d\u0645\u064a\u0644...","login":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","logout":"\u062a\u0633\u062c\u064a\u0644 \u062e\u0631\u0648\u062c","message":"\u0631\u0633\u0627\u0644\u0629","name":"\u0627\u0633\u0645","new_here":"\u062c\u062f\u064a\u062f \u0647\u0646\u0627","no":"\u0644\u0627 \u0625\u0644\u063a\u0627\u0621","no_data_available":"\u0644\u0627 \u062a\u062a\u0648\u0627\u0641\u0631 \u0628\u064a\u0627\u0646\u0627\u062a","notUsed":"\u0644\u0645 \u062a\u0633\u062a\u062e\u062f\u0645 \u0628\u0639\u062f","ok":"\u0645\u0648\u0627\u0641\u0642","payment_methods":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639 \u0627\u0648 \u0627\u0644\u0633\u062f\u0627\u062f","paypal_email":"\u0628\u0631\u064a\u062f \u0628\u0627\u064a \u0628\u0627\u0644","pending":"\u0631\u064a\u062b\u0645\u0627","phone":"\u0647\u0627\u062a\u0641","phone_validation":"\u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0635\u062d\u0629 \u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641","please_wait":"\u0623\u0631\u062c\u0648 \u0627\u0644\u0625\u0646\u062a\u0638\u0627\u0631...","price":"\u0633\u0639\u0631","product_url":"\u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0645\u0646\u062a\u062c","register":"\u064a\u0633\u062c\u0644","register_enable":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u062a\u0633\u062c\u064a\u0644","remember_me":"\u062a\u0630\u0643\u0631\u0646\u0649","reset":"\u0625\u0639\u0627\u062f\u0629 \u0636\u0628\u0637","save":"\u064a\u062d\u0641\u0638","service_url":"\u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u062e\u062f\u0645\u0629","show_currency_behind":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0639\u0645\u0644\u0629 \u0641\u064a \u0627\u0644\u062e\u0644\u0641","sign_in_here":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0647\u0646\u0627","status":"\u062d\u0627\u0644\u0629","sub_text":"\u0646\u0635 \u0641\u0631\u0639\u064a","subject":"\u0645\u0648\u0636\u0648\u0639","submit":"\u0625\u0631\u0633\u0627\u0644","successful":"\u0646\u0627\u062c\u062d","this_weeks":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","to":"\u0625\u0644\u0649","today":"\u0627\u0644\u064a\u0648\u0645","today_appointments":"\u0627\u0644\u062a\u0639\u064a\u064a\u0646\u0627\u062a \u0627\u0644\u064a\u0648\u0645","today_enquiry":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631\u0627\u062a \u0627\u0644\u064a\u0648\u0645","total__active_vcards":"\u0625\u062c\u0645\u0627\u0644\u064a VCards \u063a\u064a\u0631 \u0627\u0644\u0646\u0634\u0637\u0629","total__deactive_vcards":"\u0625\u062c\u0645\u0627\u0644\u064a \u0628\u0637\u0627\u0642\u0627\u062a \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u0627\u0644\u0645\u0639\u0637\u0644\u0629","total_active_users":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0627\u0644\u0646\u0634\u0637\u064a\u0646","total_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0625\u062c\u0645\u0627\u0644\u064a","total_deactive_users":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u063a\u064a\u0631 \u0627\u0644\u0646\u0634\u0637\u064a\u0646","total_plans":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u062e\u0637\u0637","total_users":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646","total_vcards":"\u0625\u062c\u0645\u0627\u0644\u064a VCards","type":"\u0648\u0635\u0644\u0629","unavailable":"\u063a\u064a\u0631 \u0645\u062a\u0648\u0641\u0631\u0647","upload_file":"\u0631\u0641\u0639 \u0645\u0644\u0641","user":"\u0627\u0644\u0645\u0633\u062a\u0639\u0645\u0644","view":"\u0631\u0623\u064a","virtual_note":"\u0645\u0644\u0627\u062d\u0638\u0629: \u0633\u062a\u0645\u0646\u062d\u0643 \u0627\u0644\u062e\u0644\u0641\u064a\u0627\u062a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629 \u0635\u0648\u0631 \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0639\u0645\u0644 \u0627\u0644\u062a\u064a \u0633\u064a\u062a\u0645 \u0643\u062a\u0627\u0628\u0629 \u0634\u0639\u0627\u0631\u0643 \u0648\u0627\u0633\u0645\u0643 \u0648\u0639\u0646\u0648\u0627\u0646\u0643 \u0648\u0647\u0627\u062a\u0641\u0643. \u0646\u0642\u0648\u0645 \u0628\u062a\u0635\u062f\u064a\u0631 \u0627\u0644\u0623\u062d\u062c\u0627\u0645 \u0627\u0644\u0642\u064a\u0627\u0633\u064a\u0629 \u0644\u0644\u062e\u0644\u0641\u064a\u0627\u062a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629 \u0627\u0644\u0623\u0641\u0642\u064a\u0629 \u0648\u0627\u0644\u0639\u0645\u0648\u062f\u064a\u0629 \u060c \u0648\u0627\u0644\u062a\u064a \u0633\u062a\u0643\u0648\u0646 \u0645\u0641\u064a\u062f\u0629 \u0639\u0646\u062f\u0645\u0627 \u062a\u0631\u064a\u062f \u062a\u0635\u0645\u064a\u0645 \u0628\u0637\u0627\u0642\u0629 NFC \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u060c \u064a\u0645\u0643\u0646\u0643 \u0625\u0639\u0637\u0627\u0621 \u0647\u0630\u0647 \u0627\u0644\u0635\u0648\u0631 \u0645\u0628\u0627\u0634\u0631\u0629 \u0644\u0645\u0639\u0627\u0644\u062c\u0627\u062a \u0627\u0644\u0637\u0628\u0627\u0639\u0629 NFC. \u064a\u0645\u0643\u0646\u0643 \u0623\u064a\u0636\u064b\u0627 \u0645\u0634\u0627\u0631\u0643\u0629 \u0647\u0630\u0627 \u0645\u0639 \u0623\u0635\u062f\u0642\u0627\u0626\u0643 \u0645\u0628\u0627\u0634\u0631\u0629\u064b \u0623\u064a\u0636\u064b\u0627 \u0623\u0648 \u062a\u0639\u064a\u064a\u0646\u0647 \u0643\u0635\u0648\u0631\u0629 \u0645\u0644\u0641 \u0634\u062e\u0635\u064a \/ \u0635\u0648\u0631\u0629 \u063a\u0644\u0627\u0641.","yes":"\u0646\u0639\u0645 \u060c \u0627\u062d\u0630\u0641","yes_duplicate":"\u0646\u0639\u0645 \u0645\u0643\u0631\u0631\u0629!"},"contact_us":{"contact":"\u0627\u062a\u0635\u0644 \u0628\u0646\u0627","contact_us":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631\u0627\u062a","inquries":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631\u0627\u062a","message":"\u0631\u0633\u0627\u0644\u0629","send_message":"\u0623\u0631\u0633\u0644 \u0631\u0633\u0627\u0644\u0629"},"copy_text":"\u064a\u0646\u0633\u062e","country":{"countries":"\u0628\u0644\u062f\u0627\u0646","country":"\u062f\u0648\u0644\u0629","country_name":"\u0627\u0633\u0645 \u0627\u0644\u062f\u0648\u0644\u0629","edit_country":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062f\u0648\u0644\u0629","new_country":"\u0628\u0644\u062f \u062c\u062f\u064a\u062f","no_country_available":"\u0644\u0627 \u064a\u0648\u062c\u062f \u0628\u0644\u062f \u0645\u062a\u0627\u062d","no_country_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0628\u0644\u062f","phone_code":"\u0643\u0648\u062f \u0627\u0644\u0647\u0627\u062a\u0641","short_code":"\u0631\u0645\u0632 \u0642\u0635\u064a\u0631"},"coupon_code":{"add_coupon_code":"\u0623\u0636\u0641 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","apply_here":"\u0642\u062f\u0645 \u0647\u0646\u0627","coupon_code":"\u0631\u0645\u0632 \u0627\u0644\u0643\u0648\u0628\u0648\u0646","coupon_code_applied":".\u062a\u0645 \u062a\u0637\u0628\u064a\u0642 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","coupon_code_created":".\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","coupon_code_percent_validation":".\u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0632\u064a\u062f \u062e\u0635\u0645 \u0627\u0644\u0643\u0648\u0628\u0648\u0646 \u0639\u0646 100%","coupon_code_status_updated":".\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","coupon_code_updated":".\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","coupon_codes":"\u0631\u0645\u0648\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","coupon_discount":"\u062e\u0635\u0645 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","coupon_name":"\u0627\u0633\u0645 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","coupon_type":"\u0646\u0648\u0639 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","edit_coupon_code":"\u062a\u062d\u0631\u064a\u0631 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","enter_coupon_code":"\u0623\u062f\u062e\u0644 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","enter_coupon_discount":"\u0623\u062f\u062e\u0644 \u0643\u0648\u0628\u0648\u0646 \u0627\u0644\u062e\u0635\u0645","enter_coupon_name":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","expire_at":"\u062a\u0646\u062a\u0647\u064a \u0641\u064a","fixed":"\u0646\u0648\u0639 \u062b\u0627\u0628\u062a","flat":"\u0645\u0633\u062a\u0648\u064a","have_a_coupon_code":"\u0647\u0644 \u0644\u062f\u064a\u0643 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u061f","percentage":"\u0646\u0633\u0628\u0629 \u0645\u0626\u0648\u064a\u0629","remove":"\u064a\u0632\u064a\u0644"},"create_vcard":"\u0642\u0645 \u0628\u0625\u0646\u0634\u0627\u0621 VCard \u0627\u0644\u062e\u0627\u0635 \u0628\u0643","create_your_business_digital_card_with_lots_of_information":"\u0642\u0645 \u0628\u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0639\u0645\u0644 \u0627\u0644\u0631\u0642\u0645\u064a\u0629 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u0645\u0639 \u0627\u0644\u0643\u062b\u064a\u0631 \u0645\u0646 \u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a","currency":{"currencies":"\u0627\u0644\u0639\u0645\u0644\u0627\u062a","currency_code":"\u0631\u0645\u0632 \u0627\u0644\u0639\u0645\u0644\u0629","currency_icon":"\u0631\u0645\u0632 \u0627\u0644\u0639\u0645\u0644\u0629"},"dashboard":"\u0644\u0648\u062d\u0627\u062a \u0627\u0644\u0642\u064a\u0627\u062f\u0629","date":"\u062a\u0627\u0631\u064a\u062e","deactivate":"\u062a\u0639\u0637\u064a\u0644","e_card":{"add_ecard":"\u0625\u0636\u0627\u0641\u0629 \u0628\u0637\u0627\u0642\u0629 \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u0629","ecard":"\u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u0629","ecard_info":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0628\u062d\u062c\u0645 150 \u00d7 150 \u0628\u0643\u0633\u0644","ecard_logo":"\u0634\u0639\u0627\u0631 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u0629","ecards":"\u0627\u0644\u0628\u0637\u0627\u0642\u0627\u062a \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u0629"},"edit_subscription":"\u062a\u062d\u0631\u064a\u0631 \u062e\u0637\u0629 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","email_not_found":"\u0644\u0627 \u064a\u0645\u0643\u0646\u0646\u0627 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0633\u062a\u062e\u062f\u0645 \u0644\u062f\u064a\u0647 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0647\u0630\u0627","email_password_reset_link":"\u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enquiry":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631\u0627\u062a","enquiry_detail":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0625\u0633\u062a\u0641\u0633\u0627\u0631","expire_in":"\u0627\u0644\u062e\u0637\u0629 \u0639\u0644\u0649 \u0648\u0634\u0643 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621 \u0641\u064a","extra_scripts":"\u0646\u0635 \u0625\u0636\u0627\u0641\u064a","feature":{"affiliation":"\u0627\u0644\u0627\u0646\u062a\u0645\u0627\u0621","analytics":"\u062a\u062d\u0644\u064a\u0644\u0627\u062a","appointments":"\u062a\u0639\u064a\u064a\u0646\u0627\u062a","blog":"\u0645\u062f\u0648\u0646\u0629 \u0627\u0648 \u0645\u0630\u0643\u0631\u0629","custom_css":"\u0644\u063a\u0629 \u062a\u0646\u0633\u064a\u0642 \u0648\u064a\u0628 \u062d\u0633\u0628 \u0627\u0644\u0637\u0644\u0628","custom_fonts":"\u062e\u0637\u0648\u0637 \u0639\u0627\u062f\u064a\u0629","custom_js":"\u0634\u0628\u064a\u0628\u0629 \u0645\u062e\u0635\u0635\u0629","custom_qrcode":"\u0643\u0648\u062f QR \u0627\u0644\u0645\u062e\u0635\u0635","description":"\u0648\u0635\u0641","edit_feature":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u064a\u0632\u0629","enquiry_form":"\u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0627\u0633\u062a\u0641\u0633\u0627\u0631","feature_image":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0645\u064a\u0632\u0629","gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","hide_branding":"\u0625\u062e\u0641\u0627\u0621 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629","image":"\u0635\u0648\u0631\u0629","name":"\u0627\u0633\u0645","order_nfc_card":"\u0627\u0637\u0644\u0628 \u0628\u0637\u0627\u0642\u0629 NFC","password":"\u062d\u0645\u0627\u064a\u0629 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","products":"\u0645\u0646\u062a\u062c\u0627\u062a","products_services":"\u062e\u062f\u0645\u0627\u062a","seo":"\u062a\u062d\u0633\u064a\u0646 \u0645\u062d\u0631\u0643\u0627\u062a \u0627\u0644\u0628\u062d\u062b","social_links":"\u0631\u0648\u0627\u0628\u0637 \u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629","testimonials":"\u0627\u0644\u0634\u0647\u0627\u062f\u0627\u062a - \u0627\u0644\u062a\u0648\u0635\u064a\u0627\u062a"},"features":"\u0633\u0645\u0627\u062a","flash":{"about_us_create":"\u062a\u0645 \u062d\u0641\u0638 \u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0639\u0646\u0627 \u0628\u0646\u062c\u0627\u062d.","can_not_change_time_format":"\u062a\u0645 \u062d\u062c\u0632 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0627\u0644\u0641\u0639\u0644 \u0644\u0647\u0630\u0627 \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0632\u0645\u0646\u064a","city_create":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0645\u062f\u064a\u0646\u0629 \u0628\u0646\u062c\u0627\u062d.","city_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u062f\u064a\u0646\u0629 \u0628\u0646\u062c\u0627\u062d.","country_create":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0628\u0644\u062f \u0628\u0646\u062c\u0627\u062d.","country_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0628\u0644\u062f \u0628\u0646\u062c\u0627\u062d.","country_used":"\u0627\u0644\u0628\u0644\u062f \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644","create_blog":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0645\u062f\u0648\u0646\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","create_front_testimonial":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0634\u0647\u0627\u062f\u0629 \u0628\u0646\u062c\u0627\u062d.","create_product":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0645\u0646\u062a\u062c VCard \u0628\u0646\u062c\u0627\u062d.","create_service":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u062e\u062f\u0645\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","create_testimonial":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0634\u0647\u0627\u062f\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","current_invalid":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.","database_upgrade_succesfully":"\u062a\u0645\u062a \u062a\u0631\u0642\u064a\u0629 \u0642\u0627\u0639\u062f\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u0628\u0646\u062c\u0627\u062d","decription_is_required":"\u062d\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0645\u0637\u0644\u0648\u0628","feature_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u064a\u0632\u0629 \u0628\u0646\u062c\u0627\u062d.","front_cms":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b Front CMS \u0628\u0646\u062c\u0627\u062d","language_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d.","mobile_validation":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0635\u062d\u0629 \u0627\u0644\u0647\u0627\u062a\u0641 \u0627\u0644\u0645\u062d\u0645\u0648\u0644 \u0628\u0646\u062c\u0627\u062d.","name_is_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0645\u0637\u0644\u0648\u0628","password_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631 \u0628\u0646\u062c\u0627\u062d.","plan_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d.","plan_default":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629 \u0628\u0646\u062c\u0627\u062d.","plan_status":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d","plan_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d.","reactive_account":"\u0623\u0639\u062f \u062a\u0646\u0634\u064a\u0637 \u062d\u0633\u0627\u0628\u0643 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f.","setting_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0628\u0646\u062c\u0627\u062d.","social_links_img_is_required":"\u0635\u0648\u0631\u0629 \u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629","social_links_is_required":"\u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629","state_create":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u062f\u0648\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","state_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062f\u0648\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","state_used":"\u0627\u0644\u062f\u0648\u0644\u0629 \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0628\u0627\u0644\u0641\u0639\u0644","success_theme_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0648\u0636\u0648\u0639 \u0628\u0646\u062c\u0627\u062d","update_blog":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u062f\u0648\u0646\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","update_front_testimonial":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0634\u0647\u0627\u062f\u0629 \u0628\u0646\u062c\u0627\u062d.","update_product":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u0646\u062a\u062c VCard \u0628\u0646\u062c\u0627\u062d.","update_service":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062e\u062f\u0645\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","update_testimonial":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0634\u0647\u0627\u062f\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","user_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d.","user_profile":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d.","user_status":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d","user_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d.","vcard_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 VCard \u0628\u0646\u062c\u0627\u062d.","vcard_delete":"\u062a\u0645 \u062d\u0630\u0641 VCard \u0628\u0646\u062c\u0627\u062d.","vcard_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f VCard \u0628\u0646\u062c\u0627\u062d","vcard_status":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 VCard \u0628\u0646\u062c\u0627\u062d","vcard_update":"\u062a\u0645 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0628\u0646\u062c\u0627\u062d.","verified_email":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0646\u062c\u0627\u062d"},"font":{"font_family":"\u062e\u0637 \u0627\u0644\u0639\u0627\u0626\u0644\u0629","font_size":"\u062d\u062c\u0645 \u0627\u0644\u062e\u0637","font_size_in_px":"\u062d\u062c\u0645 \u0627\u0644\u062e\u0637 \u0628\u0627\u0644\u0628\u0643\u0633\u0644","fonts":"\u0627\u0644\u062e\u0637\u0648\u0637","px":"\u0645\u0642\u0635\u0641"},"form":{"DOB":"\u0623\u062f\u062e\u0644 \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u064a\u0644\u0627\u062f","allowed_vcard":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 Vcards \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627","blog":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u0645\u062f\u0648\u0646\u0629","c_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","company":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u0634\u0631\u0643\u0629","contact":"\u0631\u0642\u0645 \u0627\u0644\u062a\u0644\u064a\u0641\u0648\u0646r","css":"\u0623\u062f\u062e\u0644 Css \u0645\u062e\u0635\u0635","description":"\u0623\u062f\u062e\u0644 \u0648\u0635\u0641 \u0628\u0637\u0627\u0642\u0629 VCard \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643","designation":"\u0623\u062f\u062e\u0644 \u0627\u0644\u062a\u0639\u064a\u064a\u0646","email":"\u0623\u062f\u062e\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_email":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_name":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0627\u0633\u0645","enter_phone":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0647\u0627\u062a\u0641","enter_trial":"\u0623\u062f\u062e\u0644 \u0623\u064a\u0627\u0645 \u0627\u0644\u062a\u062c\u0631\u0628\u0629","f_name":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644","facebook":"URL \u0627\u0644\u0641\u064a\u0633\u0628\u0648\u0643","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644","google_analytics":"\u0643\u0648\u062f \u062a\u062d\u0644\u064a\u0644\u0627\u062a \u062c\u0648\u062c\u0644","home_title":"\u0623\u062f\u062e\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0646\u0632\u0644","instagram":"\u0631\u0627\u0628\u0637 Instagram","job":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0645\u0633\u0645\u0649 \u0627\u0644\u0648\u0638\u064a\u0641\u064a","js":"\u0623\u062f\u062e\u0644 Custom Js","l_name":"\u0625\u062f\u062e\u0627\u0644 \u0627\u0633\u0645 \u0622\u062e\u0631","last_name":"\u0627\u0644\u0643\u0646\u064a\u0629","linkedin":"\u064a\u0646\u0643\u062f\u064a\u0646 URL","location":"\u0623\u062f\u062e\u0644 \u0645\u0648\u0642\u0639\u0643","location_url":"\u0623\u062f\u062e\u0644 \u0645\u0648\u0642\u0639\u0643 URL","mail":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","meta_description":"\u0623\u062f\u062e\u0644 \u0648\u0635\u0641 \u0627\u0644\u062a\u0639\u0631\u064a\u0641","meta_keyword":"\u0623\u062f\u062e\u0644 \u0643\u0644\u0645\u0629 \u062a\u0639\u0631\u064a\u0641\u064a\u0629","my_vcard_url":"\u0639\u0646\u0648\u0627\u0646 url \u0644\u0635\u0641\u062d\u0629 vcard \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u064a","occupation":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0645\u0647\u0646\u0629","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","phone":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641","pick_date":"\u0627\u062e\u062a\u0631 \u062a\u0627\u0631\u064a\u062e\u064b\u0627","pinterest":"\u0645\u0648\u0642\u0639 Pinterest URL","plan_name":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u062e\u0637\u0629","price":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0633\u0639\u0631","product":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u0645\u0646\u062a\u062c","product_url":"\u0623\u062f\u062e\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0645\u0646\u062a\u062c","reddit":"\u0645\u0648\u0642\u0639 Reddit","select_country":"\u062d\u062f\u062f \u0627\u0644\u062f\u0648\u0644\u0629","select_currency":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0639\u0645\u0644\u0629","select_state":"\u0627\u062e\u062a\u0631 \u0648\u0644\u0627\u064a\u0647","service":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u062e\u062f\u0645\u0629","short_description":"\u0623\u062f\u062e\u0644 \u0648\u0635\u0641 \u0642\u0635\u064a\u0631","site_title":"\u0623\u062f\u062e\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0648\u0642\u0639","testimonial":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u0634\u0647\u0627\u062f\u0629","tiktok":"\u0627\u0646\u0642\u0631 \u0641\u0648\u0642 URL","tumblr":"\u062a\u0645\u0628\u0644\u0631 URL","twitter":"Twitter URL","type_message":"\u0627\u0643\u062a\u0628 \u0631\u0633\u0627\u0644\u0629 \u0647\u0646\u0627 ...","vcard_name":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 VCard","website":"\u0631\u0627\u0628\u0637 \u0627\u0644\u0645\u0648\u0642\u0639","whatsapp":"\u0631\u0627\u0628\u0637 Whatsapp","your_email":"\u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f \u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","your_name":"\u0627\u0633\u0645\u0643","youtube":"\u064a\u0648\u062a\u064a\u0648\u0628 URL"},"from_time":"\u0645\u0646 \u0648\u0642\u062a","front":{"enter_your_email":"\u0623\u062f\u062e\u0644 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_your_message":"\u0623\u062f\u062e\u0644 \u0631\u0633\u0627\u0644\u062a\u0643","enter_your_name":"\u0623\u062f\u062e\u0644 \u0623\u0633\u0645\u0643","your_email_address":"\u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f\u0643  \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a"},"front_cms":{"banner":"\u0635\u0648\u0631\u0629 \u0628\u0627\u0646\u0631","description":"\u0648\u0635\u0641","front_cms":"\u0627\u0644\u062c\u0628\u0647\u0629 CMS","title":"\u0639\u0646\u0648\u0627\u0646"},"gallery":{"gallery_name":"\u0635\u0627\u0644\u0627\u062a \u0627\u0644\u0639\u0631\u0636","image":"\u0635\u0648\u0631\u0629","type":"\u0646\u0648\u0639","youtube":"\u0645\u0648\u0642\u0639 YouTube"},"hour":"\u0633\u0627\u0639\u0629","language":"\u0644\u063a\u0629","languages":{"edit_language":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0644\u063a\u0629","edit_translation":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062a\u0631\u062c\u0645\u0629","iso_code":"\u0643\u0648\u062f ISO","language":"\u0644\u063a\u0629","languages":"\u0627\u0644\u0644\u063a\u0627\u062a","new_language":"\u0644\u063a\u0629 \u062c\u062f\u064a\u062f\u0629","translation":"\u062a\u0631\u062c\u0645\u0629"},"made_by":"\u0645\u0635\u0646\u0648\u0639 \u0628\u0648\u0627\u0633\u0637\u0629","made_by_url":"\u0628\u0648\u0627\u0633\u0637\u0629 Url","mail":{"action_required":"\u0625\u0630\u0627 \u0644\u0645 \u062a\u0642\u0645 \u0628\u0625\u0646\u0634\u0627\u0621 \u062d\u0633\u0627\u0628 \u060c \u0641\u0644\u0627 \u062f\u0627\u0639\u064a \u0644\u0627\u062a\u062e\u0627\u0630 \u0623\u064a \u0625\u062c\u0631\u0627\u0621 \u0622\u062e\u0631.","appointment_time":"\u0648\u0642\u062a \u0627\u0644\u0645\u0648\u0639\u062f : ","approved_successfully":"\u062a\u0645\u062a \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0645\u0648\u0639\u062f\u0643 \u0628\u0646\u062c\u0627\u062d \u0641\u064a","attachment":"\u0645\u0631\u0641\u0642","between":"\u0645\u0627 \u0628\u064a\u0646","book_appointment":"\u0645\u0648\u0639\u062f \u0627\u0644\u0643\u062a\u0627\u0628","book_successfully":"\u062a\u0645 \u062d\u062c\u0632 \u0645\u0648\u0639\u062f\u0643 \u0628\u0646\u062c\u0627\u062d \u0641\u064a","booked_appointment_with_you":"\u062d\u062c\u0632 \u0645\u0648\u0639\u062f \u0645\u0639\u0643","email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a:","hello":"\u0645\u0631\u062d\u0628\u064b\u0627\u060c,","hello!":"\u0645\u0631\u062d\u0628\u064b\u0627!","here_is_enquiry":"\u0647\u0646\u0627 \u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u062a\u062d\u0642\u064a\u0642","messages":"\u0631\u0633\u0627\u0644\u0629: ","name":"\u0627\u0633\u0645: ","new_manual_payment_request":"\u0637\u0644\u0628 \u062f\u0641\u0639 \u064a\u062f\u0648\u064a \u062c\u062f\u064a\u062f","new_nfc_order":"\u0644\u0642\u062f \u062a\u0644\u0642\u064a\u062a \u0637\u0644\u0628 NFC \u062c\u062f\u064a\u062f\u064b\u0627 \u0645\u0646","notes":"\u0645\u0644\u0627\u062d\u0638\u0627\u062a","password_change":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 \u0645\u0646 \u0642\u0628\u0644 \u0627\u0644\u0645\u0633\u0624\u0648\u0644 ","please_click":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u0644\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u0632\u0631 \u0623\u062f\u0646\u0627\u0647 \u0644\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a.","please_contact_your_admin":"\u064a\u0631\u062c\u0649 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0628\u0627\u0644\u0645\u0633\u0624\u0648\u0644 \u0644\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u062c\u062f\u064a\u062f\u0629. ","regard":"\u064a\u0639\u062a\u0628\u0631\u060c","slot_text":"\u0625\u0630\u0627 \u0643\u0646\u062a \u062a\u0648\u0627\u062c\u0647 \u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u0627\u0644\u0646\u0642\u0631 \u0639\u0644\u0649 \u0627\u0644\u0632\u0631 \"\u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\"\u060c \u0641\u0627\u0646\u0633\u062e \u0639\u0646\u0648\u0627\u0646 URL \u0623\u062f\u0646\u0627\u0647 \u0648\u0627\u0644\u0635\u0642\u0647 \u0641\u064a \u0645\u062a\u0635\u0641\u062d \u0627\u0644\u0648\u064a\u0628 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643:","thanks_regard":"\u0645\u0639 \u0627\u0644\u0634\u0643\u0631 \u0648 \u0627\u0644\u062a\u0642\u062f\u064a\u0631\u060c","vcard_name":"\u0627\u0633\u0645 VCard: ","verify_email":"\u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","whoops":"\u0639\u0630\u0631\u064b\u0627!"},"make_appointment":"\u062d\u062f\u062f \u0645\u0648\u0639\u062f\u0627","make_appointments":"\u0625\u062d\u062c\u0632 \u0645\u0648\u0639\u062f","months":{"apr":"\u0623\u0628\u0631\u064a\u0644","aug":"\u0623\u063a\u0633\u0637\u0633","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","mar":"\u0645\u0627\u0631\u0633","may":"\u0645\u0627\u064a\u0648","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","sep":"\u0633\u0628\u062a\u0645\u0628\u0631"},"nfc":{"Add_NFC_card_photos_and_set_prices":"\u0625\u0636\u0627\u0641\u0629 \u0635\u0648\u0631 \u0628\u0637\u0627\u0642\u0627\u062a NFC \u0648\u062a\u0639\u064a\u064a\u0646 \u0627\u0644\u0623\u0633\u0639\u0627\u0631","Admin_Guide":"\u062f\u0644\u064a\u0644 \u0627\u0644\u0645\u0634\u0631\u0641: \u0628\u064a\u0639 \u0628\u0637\u0627\u0642\u0627\u062a NFC","Browse_and_select_an_NFC_card":"\u062a\u0635\u0641\u062d \u0648\u0627\u062e\u062a\u064a\u0627\u0631 \u0628\u0637\u0627\u0642\u0629 NFC","Cancelled":"\u0623\u0644\u063a\u064a\u062a","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"\u0627\u062e\u062a\u0631 vCard\u060c \u0648\u0633\u064a\u062a\u0645 \u0643\u062a\u0627\u0628\u0629 \u0639\u0646\u0648\u0627\u0646 URL \u0627\u0644\u062e\u0627\u0635 \u0628\u0640 vCard \u0639\u0644\u0649 \u0628\u0637\u0627\u0642\u0629 NFC.","Confirm_the_order_and_make_a payment":"\u062a\u0623\u0643\u064a\u062f \u0627\u0644\u0637\u0644\u0628 \u0648\u0625\u062c\u0631\u0627\u0621 \u0627\u0644\u062f\u0641\u0639","Create_or_log_in_to_your_account":"\u0625\u0646\u0634\u0627\u0621 \u062d\u0633\u0627\u0628 \u0623\u0648 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0625\u0644\u0649 \u062d\u0633\u0627\u0628\u0643","Delivered":"\u062a\u0645 \u0627\u0644\u062a\u0648\u0635\u064a\u0644","Dispatch_the_NFC_cards_to_users":"\u0625\u0631\u0633\u0627\u0644 \u0628\u0637\u0627\u0642\u0627\u062a NFC \u0625\u0644\u0649 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646","How_it_works":"\u0643\u064a\u0641 \u064a\u0639\u0645\u0644\u061f","Log_in_to_the_Admin_Dashboard":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0625\u0644\u0649 \u0644\u0648\u062d\u0629 \u0627\u0644\u062a\u062d\u0643\u0645 \u0644\u0644\u0645\u0634\u0631\u0641","Pending":"\u0642\u064a\u062f \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631","Ready To Ship":" \u0639\u0644\u0649 \u0627\u0633\u062a\u0639\u062f\u0627\u062f \u0644\u0644\u0633\u0641\u064a\u0646\u0629","Receive_and_enjoy_your_NFC_card":"\u0627\u0633\u062a\u0644\u0627\u0645 \u0648\u0627\u0644\u0627\u0633\u062a\u0645\u062a\u0627\u0639 \u0628\u0628\u0637\u0627\u0642\u0629 NFC \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643","Review_user_orders":"\u0645\u0631\u0627\u062c\u0639\u0629 \u0637\u0644\u0628\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646","Shipped":"\u0634\u062d\u0646\u0647\u0627","User_Guide":"\u062f\u0644\u064a\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645: \u0634\u0631\u0627\u0621 \u0648\u062a\u062e\u0635\u064a\u0635 \u0628\u0637\u0627\u0642\u0627\u062a NFC","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"\u0627\u0646\u062a\u0638\u0631 \u062d\u062a\u0649 \u064a\u0642\u0648\u0645 \u0627\u0644\u0645\u0634\u0631\u0641 \u0628\u0643\u062a\u0627\u0628\u0629 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 URL \u0648\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0628\u0637\u0627\u0642\u0629","Write_the_user_provided_URL_to_NFC_cards":"\u0643\u062a\u0627\u0628\u0629 \u0639\u0646\u0648\u0627\u0646 URL \u0627\u0644\u0630\u064a \u0642\u062f\u0645\u0647 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0639\u0644\u0649 \u0628\u0637\u0627\u0642\u0627\u062a NFC","add_nfc_card":"\u0625\u0636\u0627\u0641\u0629 \u0628\u0637\u0627\u0642\u0629 NFC","all":"\u0627\u0644\u062c\u0645\u064a\u0639","cancel":"\u0623\u0644\u063a\u064a\u062a","card_can_not_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0644\u0623\u0646\u0647\u0627 \u0645\u0631\u062a\u0628\u0637\u0629 \u0628\u0637\u0644\u0628\u0627\u062a \u0627\u0644\u0639\u0645\u0644\u0627\u0621.","card_type":"\u0646\u0648\u0639 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 ","company_name":"\u0627\u0633\u0645 \u0627\u0644\u0634\u0631\u0643\u0629","designation":"\u062a\u0639\u064a\u064a\u0646","edit_nfc_card":"\u062a\u062d\u0631\u064a\u0631 \u0628\u0637\u0627\u0642\u0629 NFC","enter_address":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","failed":"\u0641\u0634\u0644","logo":"\u0634\u0639\u0627\u0631","my_nfc_cards":"\u0628\u0637\u0627\u0642\u0627\u062a NFC \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u064a ","new_nfc_card":"\u0628\u0637\u0627\u0642\u0629 NFC \u062c\u062f\u064a\u062f\u0629","nfc":"\u0646\u0641\u0643","nfc_card":"\u0628\u0637\u0627\u0642\u0629 NFC","nfc_card_created_success":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0629 NFC \u0628\u0646\u062c\u0627\u062d","nfc_card_deleted_success":"\u062a\u0645 \u062d\u0630\u0641 \u0628\u0637\u0627\u0642\u0629 NFC \u0628\u0646\u062c\u0627\u062d","nfc_card_order_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0637\u0644\u0628 \u0628\u0637\u0627\u0642\u0629 NFC","nfc_card_orders":"\u0637\u0644\u0628\u0627\u062a \u0628\u0637\u0627\u0642\u0629 NFC","nfc_card_type":"\u0646\u0648\u0639 \u0628\u0637\u0627\u0642\u0629 NFC","nfc_card_types":"\u0623\u0646\u0648\u0627\u0639 \u0628\u0637\u0627\u0642\u0627\u062a NFC","nfc_card_updated_success":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0628\u0637\u0627\u0642\u0629 NFC \u0628\u0646\u062c\u0627\u062d","nfc_image":"\u0635\u0648\u0631\u0629 \u0627\u0644\u0628\u0637\u0627\u0642\u0629","nfc_image_required":"\u062d\u0642\u0644 \u0635\u0648\u0631\u0629 NFC \u0645\u0637\u0644\u0648\u0628.","order":"\u0637\u0644\u0628","order_nfc":"\u0627\u0637\u0644\u0628 NFC","order_placed_success":"\u062a\u0645 \u062a\u0642\u062f\u064a\u0645 \u0627\u0644\u0637\u0644\u0628 \u0628\u0646\u062c\u0627\u062d","order_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0637\u0644\u0628","order_status_update_success":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u0637\u0644\u0628 \u0628\u0646\u062c\u0627\u062d","orders":"\u0637\u0644\u0628\u0627\u062a","orders_count":"\u0639\u062f\u062f \u0627\u0644\u0637\u0644\u0628\u0627\u062a","paid":"\u0645\u062f\u0641\u0648\u0639","payment_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0633\u062f\u0627\u062f","payment_status_update_success":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d","pending":"\u0642\u064a\u062f \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631","razorpay_session_success":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u062c\u0644\u0633\u0629 RazorPay \u0628\u0646\u062c\u0627\u062d","required_vcard":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f Vcard","select_card":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0646\u0648\u0639 \u0627\u0644\u0628\u0637\u0627\u0642\u0629","select_vcard":"\u062d\u062f\u062f vCard","sell_nfc_cards":"\u0628\u064a\u0639 \u0628\u0637\u0627\u0642\u0627\u062a NFC","your_order_status_changed":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u062d\u0627\u0644\u0629 \u0637\u0644\u0628\u0643"},"no_data":"\u0644\u0627 \u062a\u062a\u0648\u0627\u0641\u0631 \u0628\u064a\u0627\u0646\u0627\u062a","no_matching_records_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0633\u062c\u0644\u0627\u062a \u0645\u0637\u0627\u0628\u0642\u0629","notification":{"mark_all_as_read":"\u0627\u0634\u0631 \u0639\u0644\u064a\u0647\u0627 \u0628\u0627\u0646\u0647\u0627 \u0642\u0631\u0627\u062a","notifications":"\u0625\u0634\u0639\u0627\u0631\u0627\u062a","you_don`t_have_any_new_notification":"\u0644\u064a\u0633 \u0644\u062f\u064a\u0643 \u0623\u064a \u0625\u062e\u0637\u0627\u0631 \u062c\u062f\u064a\u062f"},"paid_amount_can't_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0645\u0648\u0639\u062f \u0627\u0644\u0645\u062f\u0641\u0648\u0639","payment":{"cancelled":"\u0623\u0644\u063a\u064a\u062a","payment":"\u062f\u0641\u0639","payment_cancel":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u062f\u0641\u0639","payment_success":"\u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u0646\u0627\u062c\u062d","payment_successful":"\u062a\u0645 \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d"},"payment_method":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639 \u0627\u0648 \u0627\u0644\u0633\u062f\u0627\u062f","payment_type":"\u0646\u0648\u0639 \u0627\u0644\u062f\u0641\u0639","placeholder":{"12_hour":"12 \u0633\u0627\u0639\u0629","24_hour":"24 \u0633\u0627\u0639\u0629","address_field":"\u062d\u0642\u0644 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 \u0645\u0637\u0644\u0648\u0628.","agree_term":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0648\u0627\u0641\u0642 \u0639\u0644\u0649 \u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645.","all_rights_reserve":"\u0643\u0644 \u0627\u0644\u062d\u0642\u0648\u0642 \u0645\u062d\u0641\u0648\u0638\u0629","app_name_required":"\u062d\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0645\u0637\u0644\u0648\u0628","appointment_created":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0646\u062c\u0627\u062d.","cannot_switch_to_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0644\u062a\u0628\u062f\u064a\u0644 \u0625\u0644\u0649 \u062e\u0637\u0629 \u0627\u0644\u0635\u0641\u0631 \u0625\u0630\u0627 \u0643\u0627\u0646\u062a \u0627\u0644\u062a\u062c\u0631\u0628\u0629 \u0645\u062a\u0627\u062d\u0629 \/ \u0628\u0647\u0627 \u062e\u0637\u0629 \u0645\u062f\u0641\u0648\u0639\u0629 \u0646\u0634\u0637\u0629 \u062d\u0627\u0644\u064a\u064b\u0627","choose_one_template":"\u0627\u062e\u062a\u0631 \u0623\u064a \u0642\u0627\u0644\u0628 \u0648\u0627\u062d\u062f","copied_successfully":"\u062a\u0645 \u0627\u0644\u0646\u0633\u062e \u0628\u0646\u062c\u0627\u062d.","de_active":"\u0645\u0639\u0637\u0644","default_plan_can_not_be_delete":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","email_already_subscribed":"\u062a\u0645 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643 \u0641\u064a \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0627\u0644\u0641\u0639\u0644.","email_verification":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u0644\u0641\u0643 \u0627\u0644\u0634\u062e\u0635\u064a. \u0644\u0642\u062f \u0623\u0631\u0633\u0644\u0646\u0627 \u0644\u0643 \u0628\u0631\u064a\u062f \u062a\u062d\u0642\u0642. \u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","enquiry_sent":"\u0623\u0631\u0633\u0644 \u0627\u0644\u0627\u0633\u062a\u0641\u0633\u0627\u0631 \u0628\u0646\u062c\u0627\u062d.","enter_valid_email":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0635\u062d\u064a\u062d.","enter_your_email_to_reset":"\u0623\u062f\u062e\u0644 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643.","favicon_invalid":"\u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0645\u0641\u0636\u0644 \u0639\u0644\u0649 \u0623\u0628\u0639\u0627\u062f \u0635\u0648\u0631\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","first_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644 \u0645\u0637\u0644\u0648\u0628.","forgot_your_password_no_problem":"\u0646\u0633\u064a\u062a \u0631\u0642\u0645\u0643 \u0627\u0644\u0633\u0631\u064a\u061f \u0644\u0627 \u0645\u0634\u0643\u0644\u0629. \u0641\u0642\u0637 \u0623\u062e\u0628\u0631\u0646\u0627 \u0628\u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0648\u0633\u0646\u0631\u0633\u0644 \u0644\u0643 \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0639\u0628\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0627\u0644\u0630\u064a \u0633\u064a\u0633\u0645\u062d \u0644\u0643 \u0628\u0627\u062e\u062a\u064a\u0627\u0631 \u0639\u0646\u0648\u0627\u0646 \u062c\u062f\u064a\u062f..","gallery_created":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0639\u0631\u0636 \u0628\u0646\u062c\u0627\u062d.","gallery_updated":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0639\u0631\u0636 \u0628\u0646\u062c\u0627\u062d.","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u062f\u0648\u0644\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d","invalid_number":"\u0631\u0642\u0645 \u0635\u0627\u0644\u062d","lang_already_exists":" \u0627\u0644\u0644\u063a\u0629 \u0645\u0648\u062c\u0648\u062f\u0629 \u0628\u0627\u0644\u0641\u0639\u0644.","language_save":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d.","last_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631 \u0645\u0637\u0644\u0648\u0628.","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","login_via_facebook":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0639\u0628\u0631 Facebook","login_via_google":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0639\u0628\u0631 \u062c\u0648\u062c\u0644","message_sent":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","multi_templates":"\u0642\u0648\u0627\u0644\u0628 \u0645\u062a\u0639\u062f\u062f\u0629 \u0645\u0637\u0644\u0648\u0628\u0629","paid_appointment_cant_delete":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0645\u0648\u0639\u062f \u0627\u0644\u0645\u062f\u0641\u0648\u0639","password_character":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0643\u0648\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0646 8 \u0623\u062d\u0631\u0641 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644.","password_invalid":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629","password_is_correct":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0635\u062d\u064a\u062d\u0629","password_must_match":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0637\u0627\u0628\u0642 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0639 \u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631.","passwords":"\u062d\u0642\u0644 \u0643\u0644\u0645\u0627\u062a \u0627\u0644\u0645\u0631\u0648\u0631 \u0645\u0637\u0644\u0648\u0628.","payment_cancel":"\u062a\u0645 \u0625\u0644\u063a\u0627\u0621 \u062f\u0641\u0639\u062a\u0643","payment_done":"\u062a\u0645 \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d.","payment_not_complete":"\u0627\u0644\u062f\u0641\u0639 \u063a\u064a\u0631 \u0645\u0643\u062a\u0645\u0644","payment_received":"\u062a\u0645 \u0627\u0633\u062a\u0644\u0627\u0645 \u0627\u0644\u062f\u0641\u0639\u0629 \u0628\u0646\u062c\u0627\u062d.","paypal_created":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u062c\u0644\u0633\u0629 Paypal \u0628\u0646\u062c\u0627\u062d.","paypal_key":"\u0645\u0637\u0644\u0648\u0628 \u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d Paypal.","paypal_mode":"\u062d\u0642\u0644 \u0648\u0636\u0639 Paypal \u0645\u0637\u0644\u0648\u0628.","paypal_secret":"\u0645\u0637\u0644\u0648\u0628 \u062d\u0642\u0644 \u0633\u0631 Paypal.","phone_number_required":"\u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641 \u0645\u0637\u0644\u0648\u0628.","plan_already_used":"\u0627\u0644\u062e\u0637\u0629 \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0628\u0627\u0644\u0641\u0639\u0644","plan_expire_notification":"\u0645\u0637\u0644\u0648\u0628 \u062d\u0642\u0644 \u0625\u0634\u0639\u0627\u0631 \u0627\u0646\u062a\u0647\u0627\u0621 \u0635\u0644\u0627\u062d\u064a\u0629 \u0627\u0644\u062e\u0637\u0629.","please_add_payment_credentials":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u0636\u0627\u0641\u0629 \u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0639\u062a\u0645\u0627\u062f \u0627\u0644\u062f\u0641\u0639","privacy_policy":"\u0645\u0637\u0644\u0648\u0628 \u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629.","product_purchase":"\u062a\u0645 \u0634\u0631\u0627\u0621 \u0627\u0644\u0645\u0646\u062a\u062c \u0628\u0646\u062c\u0627\u062d.","purchased_plan":"\u0642\u0645\u062a \u0628\u0634\u0631\u0627\u0621 \u0647\u0630\u0647 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d.","receive_latest_news":"\u0627\u062d\u0635\u0644 \u0639\u0644\u0649 \u0622\u062e\u0631 \u0627\u0644\u0623\u062e\u0628\u0627\u0631 \u0648\u0627\u0644\u062a\u062d\u062f\u064a\u062b\u0627\u062a \u0648\u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0623\u0634\u064a\u0627\u0621 \u0627\u0644\u0623\u062e\u0631\u0649 \u0643\u0644 \u0623\u0633\u0628\u0648\u0639.","registered_success":"\u0644\u0642\u062f \u0642\u0645\u062a \u0628\u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u0628\u0646\u062c\u0627\u062d \u060c \u0642\u0645 \u0628\u062a\u0641\u0639\u064a\u0644 \u062d\u0633\u0627\u0628\u0643 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f.","required_captcha":"\u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u062a\u062d\u0642\u0642","role_created":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062f\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","select_hour":"\u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0623\u0648 \u0627\u0644\u0633\u0627\u0639\u0629","select_one_or_more":"\u062d\u062f\u062f \u0645\u064a\u0632\u0629 \u0648\u0627\u062d\u062f\u0629 \u0623\u0648 \u0623\u0643\u062b\u0631 \u0645\u0637\u0644\u0648\u0628","short_code_only_alpha":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0642\u0635\u064a\u0631 \u0639\u0628\u0627\u0631\u0629 \u0639\u0646 \u0623\u062d\u0631\u0641 \u0623\u0628\u062c\u062f\u064a\u0629 \u0641\u0642\u0637.","stripe_created":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u062c\u0644\u0633\u0629 \u0627\u0644\u0634\u0631\u064a\u0637 \u0628\u0646\u062c\u0627\u062d.","stripe_key":"\u0645\u0637\u0644\u0648\u0628 \u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0634\u0631\u064a\u0637.","stripe_secret":"\u0645\u0637\u0644\u0648\u0628 \u062d\u0642\u0644 \u0633\u0631 \u0627\u0644\u0634\u0631\u064a\u0637.","subscribed_plan":"\u0644\u0642\u062f \u0627\u0634\u062a\u0631\u0643\u062a \u0641\u064a \u0647\u0630\u0647 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d.","subscribed_plan_wait":"\u0644\u0642\u062f \u0627\u0634\u062a\u0631\u0643\u062a \u0641\u064a \u0647\u0630\u0647 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d \u0648\u0644\u0643\u0646 \u0627\u0646\u062a\u0638\u0631 \u0627\u0644\u062a\u0623\u0643\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","subscribed_successfully":"\u062a\u0645 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643 \u0628\u0646\u062c\u0627\u062d.","subscription_date_updated":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643 \u0628\u0646\u062c\u0627\u062d.","successfully_verified":"\u0644\u0642\u062f \u0646\u062c\u062d\u062a \u0641\u064a \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0628\u0631\u064a\u062f\u0643 \u060c \u064a\u0631\u062c\u0649 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644.","the_term_conditions":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629.","there_is_not_available_slot":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0641\u062a\u0631\u0627\u062a \u0632\u0645\u0646\u064a\u0629 \u0645\u062a\u0627\u062d\u0629 \u0641\u064a \u062a\u0627\u0631\u064a\u062e \u0645\u0639\u064a\u0646","this_currency_is_not_supported":"\u0644\u0627 \u064a\u062f\u0639\u0645 PayPal \u0647\u0630\u0647 \u0627\u0644\u0639\u0645\u0644\u0629 \u0644\u0625\u062c\u0631\u0627\u0621 \u0627\u0644\u0645\u062f\u0641\u0648\u0639\u0627\u062a.","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","time_format":"\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0648\u0642\u062a","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","unable_to_process_payment":"\u063a\u064a\u0631 \u0642\u0627\u062f\u0631 \u0639\u0644\u0649 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u062f\u0641\u0639 \u0641\u064a \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u062d\u0627\u0644\u064a. \u062d\u0627\u0648\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u0641\u064a \u0648\u0642\u062a \u0644\u0627\u062d\u0642.","upload_required":"\u0645\u0637\u0644\u0648\u0628 \u062d\u0642\u0644 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0645\u0644\u0641.","valid_number":"\u0631\u0642\u0645 \u0635\u0627\u0644\u062d","we_could_not_fb_id":"\u0644\u0645 \u0646\u062a\u0645\u0643\u0646 \u0645\u0646 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0641\u064a \u062d\u0633\u0627\u0628\u0643 \u0639\u0644\u0649 Facebook","withdrawal_request_send":"\u062a\u0645\u062a \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629 \u0639\u0644\u0649 \u0637\u0644\u0628 \u0627\u0644\u0633\u062d\u0628 \u0628\u0646\u062c\u0627\u062d.","your_mail_already_verified":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0628\u0631\u064a\u062f\u0643 \u0628\u0627\u0644\u0641\u0639\u0644 \u060c \u064a\u0631\u062c\u0649 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644."},"plan":{"We'll_never_share_your_email_with_anyone_else":"\u0644\u0646 \u0646\u0634\u0627\u0631\u0643 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0623\u0628\u062f\u064b\u0627 \u0645\u0639 \u0623\u064a \u0634\u062e\u0635 \u0622\u062e\u0631.","additional_domains":"\u0645\u062c\u0627\u0644\u0627\u062a \u0625\u0636\u0627\u0641\u064a\u0629","affiliation":"\u0627\u0644\u0627\u0646\u062a\u0645\u0627\u0621\u0627\u062a","analytics":"\u062a\u062d\u0644\u064a\u0644\u0627\u062a","blog":"\u0645\u062f\u0648\u0646\u0629 \u0627\u0648 \u0645\u0630\u0643\u0631\u0629","currency":"\u0639\u0645\u0644\u0629","custom_css":"\u0644\u063a\u0629 \u062a\u0646\u0633\u064a\u0642 \u0648\u064a\u0628 \u062d\u0633\u0628 \u0627\u0644\u0637\u0644\u0628","custom_fields":"\u0627\u0644\u062d\u0642\u0648\u0644 \u0627\u0644\u0645\u062e\u0635\u0635\u0629","custom_js":"\u0634\u0628\u064a\u0628\u0629 \u0645\u062e\u0635\u0635\u0629","custom_qrcode":"\u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0627\u0644\u0645\u062e\u0635\u0635","days":"\u0623\u064a\u0627\u0645","default_Plan":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","description":"\u0648\u0635\u0641","domains_limit":"\u062d\u062f\u0648\u062f \u0627\u0644\u0645\u062c\u0627\u0644\u0627\u062a","duration":"\u0645\u062f\u0629","duration_months":"\u0627\u0644\u0645\u062f\u0629 \u0634\u0647\u0648\u0631","duration_years":"\u0633\u0646\u0648\u0627\u062a \u0627\u0644\u0645\u062f\u0629","edit_plan":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062e\u0637\u0629","email_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enquiry_form":"\u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0627\u0633\u062a\u0641\u0633\u0627\u0631","features":"\u0633\u0645\u0627\u062a","frequency":"\u062a\u0643\u0631\u0627\u0631","gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","hide_branding":"\u0625\u062e\u0641\u0627\u0621 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629","is_trial":"\u0647\u064a \u0645\u062d\u0627\u0643\u0645\u0629","make_default":"\u062c\u0639\u0644 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a","monthly":"\u0634\u0647\u0631\u064a\u0627","months":"\u0634\u0647\u0648\u0631","multi_templates":"\u0642\u0648\u0627\u0644\u0628 \u0645\u062a\u0639\u062f\u062f\u0629","new_plan":"\u062e\u0637\u0629 \u062c\u062f\u064a\u062f\u0629","no_of_vcards":"\u0639\u062f\u062f \u0628\u0637\u0627\u0642\u0627\u062a VCards","password_protection":"\u062d\u0645\u0627\u064a\u0629 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","plan":"\u064a\u062e\u0637\u0637","plan_type":"\u0646\u0648\u0639 \u0627\u0644\u062e\u0637\u0629","portfolio":"\u0645\u0644\u0641","price":"\u0627\u0644\u0633\u0639\u0631","products":"\u0645\u0646\u062a\u062c\u0627\u062a","products_&_services":"\u0627\u0644\u0645\u0646\u062a\u062c\u0627\u062a \u0648\u0627\u0644\u062e\u062f\u0645\u0627\u062a","qrcode":"\u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","remaining_balance":"\u0627\u0644\u0631\u0635\u064a\u062f \u0627\u0644\u0645\u062a\u0628\u0642\u064a \u0645\u0646 \u0627\u0644\u0633\u0627\u0628\u0642. \u064a\u062e\u0637\u0637","select_all_feature":"\u062d\u062f\u062f \u0643\u0644 \u0627\u0644\u0645\u064a\u0632\u0627\u062a","select_plan":"\u0627\u062e\u062a\u0631 \u062e\u0637\u0629","sendemail":"\u0627\u0631\u0633\u0644 \u0628\u0631\u064a\u062f \u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","sendinvite":"\u0627\u0631\u0633\u0644 \u062f\u0639\u0648\u0629","seo":"\u062a\u062d\u0633\u064a\u0646 \u0645\u062d\u0631\u0643\u0627\u062a \u0627\u0644\u0628\u062d\u062b","services":"\u062e\u062f\u0645\u0627\u062a","status":"\u062d\u0627\u0644\u0629","testimonials":"\u0627\u0644\u0634\u0647\u0627\u062f\u0627\u062a - \u0627\u0644\u062a\u0648\u0635\u064a\u0627\u062a","total_custom_domains_limit":"\u0625\u062c\u0645\u0627\u0644\u064a \u062d\u062f \u0627\u0644\u0645\u062c\u0627\u0644\u0627\u062a \u0627\u0644\u0645\u062e\u0635\u0635\u0629","trial_days":"\u0623\u064a\u0627\u0645 \u0627\u0644\u0645\u062d\u0627\u0643\u0645\u0629","unlimited":"\u063a\u064a\u0631 \u0645\u062d\u062f\u0648\u062f","valid_upto":"\u0635\u0627\u0644\u062d \u062d\u062a\u0649","what_s_in_startup_plan":"\u0627\u0644\u0645\u062f\u0648\u0646\u0627\u062a","yearly":"\u0633\u0646\u0648\u064a","years":"\u0633\u0646\u064a\u0646"},"plan_expire":"\u0627\u0646\u062a\u0647\u062a \u0635\u0644\u0627\u062d\u064a\u0629 \u0627\u0644\u062e\u0637\u0629. \u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u062e\u062a\u064a\u0627\u0631 \u062e\u0637\u0629 \u0644\u0645\u0648\u0627\u0635\u0644\u0629 \u0627\u0644\u062e\u062f\u0645\u0629.","plan_expire_notification":"\u0625\u0634\u0639\u0627\u0631 \u0627\u0646\u062a\u0647\u0627\u0621 \u0635\u0644\u0627\u062d\u064a\u0629 \u0627\u0644\u062e\u0637\u0629 (\u0628\u0627\u0644\u0623\u064a\u0627\u0645)","plans":"\u0627\u0644\u062e\u0637\u0637","product_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0637\u0644\u0628 \u0627\u0644\u0645\u0646\u062a\u062c","product_orders":"\u0637\u0644\u0628\u0627\u062a \u0627\u0644\u0645\u0646\u062a\u062c\u0627\u062a","resend_verification_email":"\u0625\u0639\u0627\u062f\u0629 \u0627\u0631\u0633\u0627\u0644 \u0628\u0631\u064a\u062f \u0627\u0644\u062a\u062d\u0642\u0642","reset_password":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","role":{"edit_role":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062f\u0648\u0631","name":"\u0627\u0633\u0645","new_role":"\u062f\u0648\u0631 \u062c\u062f\u064a\u062f","permissions":"\u0623\u0630\u0648\u0646\u0627\u062a","role_permissions":"\u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u062f\u0648\u0631","select_all_permissions":"\u062d\u062f\u062f \u0643\u0627\u0641\u0629 \u0627\u0644\u0623\u0630\u0648\u0646\u0627\u062a"},"roles":"\u0627\u0644\u0623\u062f\u0648\u0627\u0631","sadmin_dashboard":{"contact":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","day":"\u064a\u0648\u0645","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","income":"\u0627\u0644\u0625\u064a\u0631\u0627\u062f\u0627\u062a","month":"\u0634\u0647\u0631","name":"\u0627\u0633\u0645","plans_by_users":"\u0627\u0644\u062e\u0637\u0637 \u0645\u0646 \u0642\u0628\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646","recent_users_registration":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0627\u0644\u0623\u062e\u064a\u0631","registered_on":"\u0645\u0633\u062c\u0644\u0629 \u0639\u0644\u0649","week":"\u0623\u0633\u0628\u0648\u0639"},"save":"Save","select_payment_type":"\u062d\u062f\u062f \u0628\u0648\u0627\u0628\u0629 \u0627\u0644\u062f\u0641\u0639","services":"\u062e\u062f\u0645\u0627\u062a","setting":{"add_contact":"\u0625\u0636\u0627\u0641\u0629 \u0644\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0645\u062a\u0635\u0644\u064a\u0646","address":"\u062a\u0628\u0648\u0643","affiliation_amount":"\u0645\u0628\u0644\u063a \u0627\u0644\u0627\u0646\u062a\u0633\u0627\u0628","affiliation_withdraw":"\u064a\u0633\u062d\u0628 \u0627\u0644\u0627\u0646\u062a\u0645\u0627\u0621","app_logo":"\u0634\u0639\u0627\u0631 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","app_name":"\u0627\u0633\u0645 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","clinic_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u064a\u0627\u062f\u0629","contact_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u062a\u0648\u0627\u0635\u0644","credentials":"\u0623\u0648\u0631\u0627\u0642 \u0627\u0639\u062a\u0645\u0627\u062f","currency":"\u0639\u0645\u0644\u0629","currency_settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0639\u0645\u0644\u0629","default_currency_format":"\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0639\u0645\u0644\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a","default_language":"\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","disable_landing_page":"\u062a\u0639\u0637\u064a\u0644 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0645\u0642\u0635\u0648\u062f\u0629","enable_addcontact":"\u062a\u0645\u0643\u064a\u0646 \u0625\u0636\u0627\u0641\u0629 \u0625\u0644\u0649 \u062c\u0647\u0629 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","enable_affiliation":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0627\u0646\u062a\u0633\u0627\u0628","enable_contact":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","favicon":"\u0641\u0627\u0641\u064a\u0643\u0648\u0646","front_page_enable":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629 \u062a\u0645\u0643\u064a\u0646","general":"\u0639\u0627\u0645","general_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0639\u0627\u0645\u0629","hide_stickybar":"\u0625\u062e\u0641\u0627\u0621 \u0634\u0631\u064a\u0637 vCard \u0627\u0644\u0644\u0627\u0635\u0642","location_url":"URL \u0627\u0644\u0645\u0648\u0642\u0639","manually":"\u064a\u062f\u0648\u064a\u0627","note":"\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0633\u0645 \u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0630\u064a \u062a\u0645 \u062a\u062d\u0645\u064a\u0644\u0647 \u0647\u0648 \"WeChat.png\" \/ \"Tumbler.png\" \/ \"XXX.png\" \u060c \u0623\u062b\u0646\u0627\u0621 \u062a\u0646\u0632\u064a\u0644 \u0645\u0644\u0641 .vcf \u060c \u0633\u064a\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0645 \u0643\u062a\u0633\u0645\u064a\u0629.","paypal":"\u0628\u0627\u064a \u0628\u0627\u0644","paypal_client_id":"\u0645\u0639\u0631\u0641 \u0639\u0645\u064a\u0644 Paypal","paypal_key":"\u0645\u0641\u062a\u0627\u062d Paypal","paypal_mode":"\u0648\u0636\u0639 Paypal","paypal_payout_email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u062f\u0641\u0639 Paypal","paypal_secret":"\u0633\u0631 \u0628\u0627\u064a \u0628\u0627\u0644","postal_code":"\u0631\u0645\u0632 \u0628\u0631\u064a\u062f\u064a","prefix":"\u0627\u062e\u062a\u0635\u0627\u0631","razorpay":"\u0631\u0627\u0632\u0648\u0631\u0628\u0627\u064a","razorpay_key":"\u0645\u0641\u062a\u0627\u062d Razorpay","razorpay_secret":"\u0633\u0631 Razorpay","select_currency":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0639\u0645\u0644\u0629","setting":"\u062c\u0644\u0633\u0629","shipping_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0634\u062d\u0646","specialities":"\u0627\u0644\u062a\u062e\u0635\u0635\u0627\u062a","stripe":"\u0634\u0631\u064a\u0637","stripe_key":"\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0634\u0631\u064a\u0637","stripe_secret":"\u0633\u0631 \u0627\u0644\u0634\u0631\u064a\u0637","upgrade_database":"\u062a\u0631\u0642\u064a\u0629 \u0642\u0627\u0639\u062f\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a","user_default_language":"\u0644\u063a\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","whatsapp_share":"\u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644 WhatsApp","withdraw_transactions":"\u0633\u062d\u0628 \u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0627\u062a","withdrawals":"\u0639\u0645\u0644\u064a\u0627\u062a \u0627\u0644\u0633\u062d\u0628","wp_number":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641"},"settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a","sign_out":"\u062e\u0631\u0648\u062c","social":{"Facebook":"\u0641\u064a\u0633\u0628\u0648\u0643","Instagram":"\u0627\u0646\u0633\u062a\u063a\u0631\u0627\u0645","Linkedin":"\u064a\u0646\u0643\u062f\u064a\u0646","Pinterest":"\u0628\u064a\u0646\u062a\u064a\u0631\u064a\u0633\u062a","Reddit":"\u0631\u062f\u064a\u062a","Share_on_email":"\u0634\u0627\u0631\u0643 \u0639\u0644\u0649 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","Share_on_facebook":"\u0623\u0646\u0634\u0631\u0647\u0627 \u0639\u0644\u0649 \u0627\u0644\u0641\u064a\u0633\u0628\u0648\u0643","Share_on_linkedin":"\u0634\u0627\u0631\u0643 \u0639\u0644\u0649 \u0644\u064a\u0646\u0643\u062f \u0625\u0646","Share_on_pinterest":"\u0634\u0627\u0631\u0643 \u0639\u0644\u0649 \u0628\u064a\u0646\u062a\u064a\u0631\u064a\u0633\u062a","Share_on_reddit":"\u0634\u0627\u0631\u0643 \u0639\u0644\u0649 \u0631\u062f\u064a\u062a","Share_on_twitter":"\u062d\u0635\u0629 \u0639\u0644\u0649 \u0627\u0644\u062a\u063a\u0631\u064a\u062f","Share_on_whatsapp":"\u0634\u0627\u0631\u0643 \u0639\u0644\u0649 \u0648\u0627\u062a\u0633 \u0627\u0628","Tiktok":"\u062a\u064a\u0643 \u062a\u0648\u0643","Tumblr":"\u0646\u0639\u0631\u0641\u0643\u0645","Twitter":"\u062a\u0648\u064a\u062a\u0631","Whatsapp":"\u0627\u0644 WhatsApp","Youtube":"\u0645\u0648\u0642\u0639 \u064a\u0648\u062a\u064a\u0648\u0628","map":"\u062e\u0631\u064a\u0637\u0629","social_links":"\u0627\u0644\u0631\u0648\u0627\u0628\u0637 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629 - \u0627\u0644\u0645\u0648\u0642\u0639","website":"\u0645\u0648\u0642\u0639 \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a"},"state":{"country_name":"\u0627\u0633\u0645 \u0627\u0644\u062f\u0648\u0644\u0629","edit_state":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062f\u0648\u0644\u0629","new_state":"\u062f\u0648\u0644\u0629 \u062c\u062f\u064a\u062f\u0629","no_state_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u062f\u0648\u0644\u0629 \u0645\u062a\u0627\u062d\u0629","no_state_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0648\u0644\u0627\u064a\u0629","state":"\u0648\u0644\u0627\u064a\u0629","state_name":"\u0627\u0633\u0645 \u0627\u0644\u0648\u0644\u0627\u064a\u0629","states":"\u062a\u0646\u0635 \u0639\u0644\u0649"},"subscribe":"\u0627\u0644\u0625\u0634\u062a\u0631\u0627\u0643","subscribed_plans":"\u0627\u0644\u062e\u0637\u0637 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629","subscribed_user":"\u062e\u0637\u0637 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0645\u0634\u062a\u0631\u0643","subscriber":"\u0645\u0634\u062a\u0631\u0643\u064a\u0646","subscription":{"active_until":"\u0646\u0634\u0637 \u062d\u062a\u0649","active_until_unlimited":"\u0646\u0634\u0637 \u062d\u062a\u0649 \u063a\u064a\u0631 \u0645\u062d\u062f\u0648\u062f","amount":"\u0645\u0642\u062f\u0627\u0631","buy_now":"\u0627\u0634\u062a\u0631\u064a \u0627\u0644\u0622\u0646","buy_product":"\u0634\u0631\u0627\u0621 \u0627\u0644\u0645\u0646\u062a\u062c","cancel_subscription":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","choose_plan":"\u0623\u062e\u062a\u0631 \u062e\u0637\u0629","current_expire":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u0645\u0646\u062a\u0647\u064a\u0629 \u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0629","current_plan":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629","currently_active":"\u0646\u0634\u0637 \u062d\u0627\u0644\u064a\u0627","end_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621","end_date_required":"\u062d\u0642\u0644 \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621 \u0645\u0637\u0644\u0648\u0628","expired":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0646\u062a\u0647\u062a \u0628\u0627\u0644\u0641\u0639\u0644 \u0641\u064a","expired_date":"\u0645\u0646\u062a\u0647\u064a \u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0629","free":"\u062d\u0631","has_already_been_subscribed":"\u0645\u0634\u062a\u0631\u0643 \u0628\u0627\u0644\u0641\u0639\u0644","has_been_subscribed":"\u062a\u0645 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","history":"\u0633\u062c\u0644 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","manage_subscription":"\u0625\u062f\u0627\u0631\u0629 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","no_plan_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u062e\u0637\u0629 \u0645\u062a\u0627\u062d\u0629","pay_or_switch_plan":"\u062e\u0637\u0629 \u0627\u0644\u062f\u0641\u0639 \/ \u0627\u0644\u062a\u0628\u062f\u064a\u0644","payable_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642","payment":"\u062f\u0641\u0639","plan_name":"\u0627\u0633\u0645 \u0627\u0644\u062e\u0637\u0629","plan_price":"\u0633\u0639\u0631 \u0627\u0644\u062e\u0637\u0629","proceed_to_payment":"\u0627\u0644\u0634\u0631\u0648\u0639 \u0641\u064a \u062f\u0641\u0639","purchase":"\u0634\u0631\u0627\u0621","remaining":"\u0645\u062a\u0628\u0642\u064a","remaining_balance":"\u0627\u0644\u0631\u0635\u064a\u062f \u0627\u0644\u0645\u062a\u0628\u0642\u064a","remaining_days":"\u0627\u0644\u0623\u064a\u0627\u0645 \u0627\u0644\u0645\u062a\u0628\u0642\u064a\u0629","renew_free_plan":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062c\u062f\u064a\u062f \/ \u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0645\u062c\u0627\u0646\u064a\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649","renew_plan":"\u062a\u062c\u062f\u064a\u062f \u0627\u0644\u062e\u0637\u0629","start_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0628\u062f\u0621","subscribed_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","subscribed_plan_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u062e\u0637\u0629 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","switch_plan":"\u062a\u0628\u062f\u064a\u0644 \u0627\u0644\u062e\u0637\u0629","total_days":"\u0645\u062c\u0645\u0648\u0639 \u0627\u0644\u0623\u064a\u0627\u0645","trial_plan":"\u062e\u0637\u0629 \u062a\u062c\u0631\u064a\u0628\u064a\u0629","upgrade_plan":"\u062e\u0637\u0629 \u0627\u0644\u062a\u0631\u0642\u064a\u0629","used_balance":"\u0627\u0644\u0645\u064a\u0632\u0627\u0646 \u0627\u0644\u0645\u0633\u062a\u0639\u0645\u0644","used_days":"\u0627\u0644\u0623\u064a\u0627\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0629"},"subscriptions":"\u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643\u0627\u062a","testimonial":"\u0627\u0644\u0634\u0647\u0627\u062f\u0627\u062a - \u0627\u0644\u062a\u0648\u0635\u064a\u0627\u062a","to_time":"\u0627\u0644\u0649 \u0648\u0642\u062a","tooltip":{"about_description":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0647\u0648 500 \u062d\u0631\u0641","about_title":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0647\u0648 100 \u062d\u0631\u0641","allowed_image":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","app_logo":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0628\u0645\u0642\u0627\u0633 90 \u00d7 60 \u0628\u0643\u0633\u0644","banner_title":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0647\u0648 34 \u062d\u0631\u0641\u064b\u0627","cancel_app_logo":"\u0625\u0644\u063a\u0627\u0621 \u0634\u0639\u0627\u0631 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","cancel_cover":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u063a\u0644\u0627\u0641","cancel_favicon_logo":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0645\u0641\u0636\u0644","cancel_image":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0635\u0648\u0631\u0629","cancel_profile":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","change_app_logo":"\u062a\u063a\u064a\u064a\u0631 \u0634\u0639\u0627\u0631 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","change_favicon_logo":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0623\u064a\u0642\u0648\u0646\u0629 \u0627\u0644\u0645\u0641\u0636\u0644\u0629","change_icon":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0627\u064a\u0642\u0648\u0646\u0629","copy":"\u0646\u0633\u062e \u0625\u0644\u0649 \u0627\u0644\u062d\u0627\u0641\u0638\u0629","cover":"\u062a\u0628\u062f\u064a\u0644 \u0627\u0644\u063a\u0637\u0627\u0621","custom_css":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0642\u062f\u0631\u0629 \u0639\u0644\u0649 \u0625\u0636\u0627\u0641\u0629 css \u0645\u062e\u0635\u0635 \u0644\u0643\u0644 VCard.","custom_fonts":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0642\u062f\u0631\u0629 \u0639\u0644\u0649 \u0625\u0636\u0627\u0641\u0629 \u062e\u0637\u0648\u0637 \u0645\u062e\u0635\u0635\u0629 \u0644\u0643\u0644 VCard.","custom_js":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0642\u062f\u0631\u0629 \u0639\u0644\u0649 \u0625\u0636\u0627\u0641\u0629 js \u0645\u062e\u0635\u0635\u0629 \u0644\u0643\u0644 VCard.","dark_mode":"\u0642\u0645 \u0628\u0627\u0644\u062a\u0628\u062f\u064a\u0644 \u0625\u0644\u0649 \u0627\u0644\u0648\u0636\u0639 \u0627\u0644\u062f\u0627\u0643\u0646","enable_affiliation":"\u0645\u0646 \u062e\u0644\u0627\u0644 \u062a\u0645\u0643\u064a\u0646 \u0647\u0630\u0627 \u060c \u0633\u064a\u0643\u0648\u0646 \u0627\u0631\u062a\u0628\u0627\u0637 \u0627\u0644\u0627\u0646\u062a\u0633\u0627\u0628 \u0645\u0631\u0626\u064a\u064b\u0627 \u0644\u062c\u0645\u064a\u0639 \u0628\u0637\u0627\u0642\u0627\u062a vcards \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643","enable_contact":"\u0645\u0646 \u062e\u0644\u0627\u0644 \u062a\u0645\u0643\u064a\u0646 \u0647\u0630\u0627 \u060c \u0633\u062a\u0643\u0648\u0646 \u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0645\u0631\u0626\u064a\u0629 \u0639\u0644\u0649 \u062c\u0645\u064a\u0639 \u0628\u0637\u0627\u0642\u0627\u062a Vcards \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 ","favicon_logo":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0628\u0645\u0642\u0627\u0633 16 \u00d7 16 \u0628\u0643\u0633\u0644","hide_branding":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0642\u062f\u0631\u0629 \u0639\u0644\u0649 \u0625\u062e\u0641\u0627\u0621 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629 \u0645\u0646 VCards.","hide_stickybar":"\u0645\u0646 \u062e\u0644\u0627\u0644 \u062a\u0645\u0643\u064a\u0646 \u0647\u0630\u0627 \u060c \u064a\u062a\u0645 \u0625\u062e\u0641\u0627\u0621 Vcards Sticky Buttons \u0639\u0644\u0649 \u062c\u0645\u064a\u0639 \u0628\u0637\u0627\u0642\u0627\u062a Vcards \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 ","home_image":"\u0623\u0641\u0636\u0644 \u062f\u0642\u0629 \u0644\u0647\u0630\u0627 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a \u0633\u062a\u0643\u0648\u0646","image":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0635\u0648\u0631\u0629","light_mode":"\u0642\u0645 \u0628\u0627\u0644\u062a\u0628\u062f\u064a\u0644 \u0625\u0644\u0649 \u0648\u0636\u0639 Light","password_protection":"\u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u062d\u0645\u0627\u064a\u0629 VCards.","product_image":"\u0623\u0641\u0636\u0644 \u062f\u0642\u0629 \u0644\u0647\u0630\u0627 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a \u0633\u062a\u0643\u0648\u0646 250x250","profile":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","remove_branding":"\u0641\u064a \u062d\u0627\u0644\u0629 \u0627\u0644\u062a\u0645\u0643\u064a\u0646 \u060c \u0644\u0646 \u062a\u0639\u0631\u0636 vcard \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629 \u0644\u0645\u0648\u0642\u0639\u0646\u0627 \u0639\u0644\u0649 \u0627\u0644\u0648\u064a\u0628.","script":"\u0623\u0636\u0641 \u0643\u0648\u062f JS \u0627\u0644\u0645\u062e\u0635\u0635 \u0628\u062f\u0648\u0646 \u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u0646\u0635\u064a","sub_text":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0647\u0648 60 \u062d\u0631\u0641","the_main_url":"\u0639\u0646\u0648\u0627\u0646 URL \u0627\u0644\u0631\u0626\u064a\u0633\u064a \u0627\u0644\u0630\u064a \u0633\u064a\u062a\u0645 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 vcard \u0645\u0646\u0647.","whatsapp_share":"\u0645\u0646 \u062e\u0644\u0627\u0644 \u062a\u0645\u0643\u064a\u0646 \u0647\u0630\u0627 \u060c \u0633\u064a\u0643\u0648\u0646 \u0632\u0631 WhatsApp Share \u0645\u0631\u0626\u064a\u064b\u0627 \u0639\u0644\u0649 \u062c\u0645\u064a\u0639 \u0628\u0637\u0627\u0642\u0627\u062a VCards \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643"},"translation_manager":"\u0645\u062f\u064a\u0631 \u0627\u0644\u062a\u0631\u062c\u0645\u0629","type_in_script":"\u0623\u062f\u062e\u0644 \u0643\u0648\u062f js \u062f\u0627\u062e\u0644 \u0639\u0644\u0627\u0645\u0627\u062a <script> <\/script>","user":{"account":"\u0627\u0644\u062d\u0633\u0627\u0628","account_setting":"\u0625\u0639\u062f\u0627\u062f\u062a \u0627\u0644\u062d\u0633\u0627\u0628","add_admin":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","add_user":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","admin_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","avatar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0631\u0645\u0632\u064a\u0629","change_language":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0644\u063a\u0629","change_password":"\u062a\u063a\u064a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_no":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","contact_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","current_password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629","edit_user":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0639\u0636\u0648","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_verified":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","female":"\u0623\u0646\u062b\u0649","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0627\u0648\u0644","full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","impersonate":"\u0627\u0646\u062a\u062d\u0627\u0644 \u0627\u0644\u0634\u062e\u0635\u064a\u0629","last_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0627\u0626\u0644\u0629","location":"\u0645\u0648\u0642\u0639","male":"\u0630\u0643\u0631","new_password":"\u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u062c\u062f\u064a\u062f\u0629","overview":"\u0645\u0644\u062e\u0635","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","phone":"\u0647\u0627\u062a\u0641","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","profile_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","registered_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u062a\u0633\u062c\u064a\u0644","return_to_admin":"\u0627\u0644\u0639\u0648\u062f\u0629 \u0625\u0644\u0649 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","save_changes":"\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a","setting":"\u062c\u0644\u0633\u0629","theme_change":"\u062a\u063a\u064a\u064a\u0631 \u0648\u0636\u0639 \u0627\u0644\u0633\u0645\u0629","user_details":"\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","your_message":"\u0631\u0633\u0627\u0644\u062a\u0643","your_name":"\u0627\u0633\u0645\u0643"},"users":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0648\u0646","vcard":{"add_blog":"\u0623\u0636\u0641 \u0645\u062f\u0648\u0646\u0629","add_gallery":"\u0623\u0636\u0641 \u0645\u0639\u0631\u0636","add_google_analytics":"\u0623\u0636\u0641 \u0634\u0641\u0631\u0629 Google Analytics \u0628\u062f\u0648\u0646 \u0639\u0644\u0627\u0645\u0629 <script>","add_product":"\u0623\u0636\u0641 \u0645\u0646\u062a\u062c","add_service":"\u0623\u0636\u0641 \u062e\u062f\u0645\u0629","add_testimonial":"\u0623\u0636\u0641 \u0634\u0647\u0627\u062f\u0629","advanced":"\u0645\u062a\u0642\u062f\u0645","affiliate_user":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0648\u0646 \u0627\u0644\u0645\u0646\u062a\u0633\u0628\u0648\u0646","alter_email_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0627\u0644\u0628\u062f\u064a\u0644","alter_mobile_number":"\u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641 \u0627\u0644\u0646\u0642\u0627\u0644 \u0627\u0644\u0628\u062f\u064a\u0644","alternate_email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0627\u0644\u0628\u062f\u064a\u0644","alternative_phone":"  \u0647\u0627\u062a\u0641 \u0628\u062f\u064a\u0644","appointments":"\u062a\u0639\u064a\u064a\u0646\u0627\u062a","back_color":"\u0644\u0648\u0646 \u0627\u0644\u062e\u0644\u0641\u064a\u0629","basic_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0623\u0633\u0627\u0633\u064a\u0629","blog_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u062f\u0648\u0646\u0629","blog_icon":"\u0631\u0645\u0632 \u0627\u0644\u0645\u062f\u0648\u0646\u0629","blogs":"\u0627\u0644\u0645\u062f\u0648\u0646\u0627\u062a","buisness_hours":"\u0633\u0627\u0639\u0627\u062a \u0627\u0644\u0639\u0645\u0644","business_hours":"\u0633\u0627\u0639\u0627\u062a \u0627\u0644\u0639\u0645\u0644","company":"\u0634\u0631\u0643\u0629","contact":"\u0627\u062a\u0635\u0627\u0644","copy_referral_link":"\u0627\u0646\u0633\u062e \u0631\u0627\u0628\u0637 \u0627\u0644\u0625\u062d\u0627\u0644\u0629","cover_image":"\u0635\u0648\u0631\u0629 \u0627\u0644\u063a\u0644\u0627\u0641","created_at":"\u0623\u0646\u0634\u0626\u062a \u0641\u064a","created_on":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0624\u0647\u0627 \u0639\u0644\u0649","custom_css":"\u0644\u063a\u0629 \u062a\u0646\u0633\u064a\u0642 \u0648\u064a\u0628 \u062d\u0633\u0628 \u0627\u0644\u0637\u0644\u0628","custom_fonts":"\u0627\u0644\u062e\u0637\u0648\u0637","custom_js":"\u0634\u0628\u064a\u0628\u0629 \u0645\u062e\u0635\u0635\u0629","date_of_birth":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0648\u0644\u0627\u062f\u0629","description":"\u0648\u0635\u0641","display_share_button":"Display share button","dob":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0648\u0644\u0627\u062f\u0629","download_my_qr_code":"\u062a\u0646\u0632\u064a\u0644 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0627\u0644\u062e\u0627\u0635 \u0628\u064a","download_vcard":"\u062a\u0646\u0632\u064a\u0644 VCard","duplicate_vcard":"\u0628\u0637\u0627\u0642\u0629 Vcard \u0645\u0643\u0631\u0631\u0629!","edit_blog":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u062f\u0648\u0646\u0629","edit_gallery":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0639\u0631\u0636","edit_product":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0646\u062a\u062c","edit_service":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062e\u062f\u0645\u0629","edit_testimonial":"\u062a\u062d\u0631\u064a\u0631 \u0634\u0647\u0627\u062f\u0629","edit_vcard":"\u062a\u062d\u0631\u064a\u0631 VCard","email_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u0649","enable_download_qr_code":"\u062a\u0641\u0639\u064a\u0644 \u062a\u0646\u0632\u064a\u0644 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","enable_enquiry_form":"\u062a\u0641\u0639\u064a\u0644 \u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0627\u0633\u062a\u0641\u0633\u0627\u0631","enter_password":"\u0623\u062f\u062e\u0644 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0627\u0648\u0644","flag":"\u0639\u0644\u064e\u0645","galleries":"\u0627\u0644\u0645\u0639\u0627\u0631\u0636","gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","google_analytics":"\u062a\u062d\u0644\u064a\u0644\u0627\u062a \u0643\u0648\u0643\u0644","google_config":"\u062a\u0643\u0648\u064a\u0646 \u062c\u0648\u062c\u0644","header":"\u063a\u0637\u0633\u0629","home_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0646\u0632\u0644","image":"\u0635\u0648\u0631\u0629","is_manual_payment":"\u062f\u0644\u064a\u0644 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a \u0642\u064a\u062f \u0627\u0644\u062a\u0634\u063a\u064a\u0644","job_title":"\u0627\u0644\u0645\u0633\u0645\u0649 \u0627\u0644\u0648\u0638\u064a\u0641\u064a","language_enable":"\u062a\u0645 \u062a\u0645\u0643\u064a\u0646 \u0627\u0644\u0644\u063a\u0629","last_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0627\u0626\u0644\u0629","last_updated":"\u0622\u062e\u0631 \u062a\u062d\u062f\u064a\u062b","location":"\u0645\u0648\u0642\u0639","manage-section":"\u0625\u062f\u0627\u0631\u0629 \u0627\u0644\u0642\u0633\u0645","manual_payment_guide":"\u062f\u0644\u064a\u0644 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","map":"\u062e\u0631\u064a\u0637\u0629","meta_description":"\u0645\u064a\u062a\u0627 \u0627\u0644\u0648\u0635\u0641","meta_keyword":"\u0643\u0644\u0645\u0629 \u0645\u064a\u062a\u0627","mobile_number":"\u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641 \u0627\u0644\u0645\u062d\u0645\u0648\u0644","new_blog":"\u0645\u062f\u0648\u0646\u0629 \u062c\u062f\u064a\u062f\u0629","new_gallery":"\u0645\u0639\u0631\u0636 \u062c\u062f\u064a\u062f","new_product":"\u0645\u0646\u062a\u062c \u062c\u062f\u064a\u062f","new_service":"\u062e\u062f\u0645\u0629 \u062c\u062f\u064a\u062f\u0629","new_testimonial":"\u0634\u0647\u0627\u062f\u0629 \u062c\u062f\u064a\u062f\u0629","new_vcard":"\u062c\u062f\u064a\u062f VCard","occupation":"\u0627\u0644\u0627\u062d\u062a\u0644\u0627\u0644","order_at":"\u0637\u0644\u0628 \u0641\u064a","our_service":"\u062e\u062f\u0645\u0627\u062a\u0646\u0627","payment_config":"\u062a\u0643\u0648\u064a\u0646 \u0627\u0644\u062f\u0641\u0639","preview_url":"\u0645\u0639\u0627\u064a\u0646\u0629 URL","privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","product":"\u0645\u0646\u062a\u062c","product_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0646\u062a\u062c","product_icon":"\u0631\u0645\u0632 \u0627\u0644\u0645\u0646\u062a\u062c","product_name":"\u0627\u0633\u0645 \u0627\u0644\u0645\u0646\u062a\u062c","product_transection":"\u0645\u0639\u0627\u0645\u0644\u0627\u062a \u0627\u0644\u0645\u0646\u062a\u062c","products":"\u0645\u0646\u062a\u062c\u0627\u062a","profile_image":"\u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","qr_code":"\u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","qr_code_download_size":"\u062d\u062c\u0645 \u062a\u0646\u0632\u064a\u0644 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","qrcode-customize":"\u062a\u062e\u0635\u064a\u0635 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","qrcode_color":"\u0644\u0648\u0646 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","qrcode_customize":"\u062a\u062e\u0635\u064a\u0635 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","qrcode_eye_style":"\u062d\u062f\u062f \u0646\u0645\u0637 \u0627\u0644\u0639\u064a\u0646","qrcode_style":"\u062d\u062f\u062f \u0627\u0644\u0646\u0645\u0637","remove_branding":"\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629","select_template":"\u062d\u062f\u062f \u0642\u0627\u0644\u0628","send_message":"\u0623\u0631\u0633\u0644 \u0631\u0633\u0627\u0644\u0629","seo":"\u062a\u062d\u0633\u064a\u0646 \u0645\u062d\u0631\u0643\u0627\u062a \u0627\u0644\u0628\u062d\u062b","service_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u062e\u062f\u0645\u0629","service_icon":"\u0631\u0645\u0632 \u0627\u0644\u062e\u062f\u0645\u0629","services":"\u062e\u062f\u0645\u0627\u062a","share":"\u0634\u0627\u0631\u0643","share_my_vcard":"\u0645\u0634\u0627\u0631\u0643\u0629 My VCard","show_qr_code":"\u0625\u0638\u0647\u0627\u0631 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629","site_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0648\u0642\u0639","social_links":"\u0631\u0648\u0627\u0628\u0637 \u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629","stats":"\u0627\u062d\u0635\u0627\u0626\u064a\u0627\u062a","status":"\u062d\u0627\u0644\u0629","template":"\u0642\u0648\u0627\u0644\u0628 VCard","templates":"\u0642\u0648\u0627\u0644\u0628 VCard","term-condition":"\u0644\u0628\u0646\u0648\u062f \u0648 \u0627\u0644\u0638\u0631\u0648\u0641","term-policy":"\u0633\u064a\u0627\u0633\u0627\u062a \u0627\u0644\u0634\u0631\u0648\u0637","term_condition":"\u0627\u0644\u0628\u0646\u0648\u062f \u0648 \u0627\u0644\u0638\u0631\u0648\u0641","term_policy":"\u0633\u064a\u0627\u0633\u0627\u062a \u0627\u0644\u0634\u0631\u0648\u0637","testimonial":"\u0627\u0644\u0634\u0647\u0627\u062f\u0627\u062a - \u0627\u0644\u062a\u0648\u0635\u064a\u0627\u062a","testimonial_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0634\u0647\u0627\u062f\u0629","testimonials":"\u0627\u0644\u0634\u0647\u0627\u062f\u0627\u062a - \u0627\u0644\u062a\u0648\u0635\u064a\u0627\u062a","theme_config":"\u062a\u0643\u0648\u064a\u0646 \u0627\u0644\u0645\u0648\u0636\u0648\u0639","url_alias":"URL \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062a\u0639\u0627\u0631","user":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0648\u0646","user_name":"\u0627\u0633\u0645 \u0627\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","vcard":"\u0628\u0637\u0627\u0642\u0629 V","vcard_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0628\u0637\u0627\u0642\u0629 VCards","vcard_is_active":"Vcard \u0646\u0634\u0637","vcard_name":"\u0627\u0633\u0645 VCard","vcard_service":"\u062e\u062f\u0645\u0629 VCard"},"vcard_11":{"Latest_post":"\u0622\u062e\u0631 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a","contact_detail":"\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0645\u062a\u0635\u0644","get_in_touch":"\u0627\u0628\u0642\u0649 \u0639\u0644\u0649 \u062a\u0648\u0627\u0635\u0644","my_email":"\u0628\u0631\u064a\u062f\u064a \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","my_phones":"\u0647\u0648\u0627\u062a\u0641\u064a","provide_service":"\u062a\u0642\u062f\u064a\u0645 \u0627\u0644\u062e\u062f\u0645\u0627\u062a","read_more":"\u0627\u0642\u0631\u0623 \u0623\u0643\u062b\u0631"},"vcards":"\u0628\u0637\u0627\u0642\u0627\u062a","vcards_template":{"image":"\u0635\u0648\u0631\u0629","used_count":"\u0639\u062f\u062f \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646"},"vcards_templates":"\u0642\u0648\u0627\u0644\u0628 VCards","virtual_backgrounds":"\u0627\u0644\u062e\u0644\u0641\u064a\u0627\u062a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","wait_for_apporove_of_cash_payment_by_admin":"\u0637\u0644\u0628 \u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0629 \u0627\u0644\u064a\u062f\u0648\u064a\u0629 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0645\u0639\u0644\u0642.","weekdays":{"fri":"\u0627\u0644\u0627\u0628","mon":"\u0645","sat":"\u0633","sun":"\u0633","thu":"\u062a\u064a","tue":"\u062a\u064a","wed":"\u062f\u0628\u0644\u064a\u0648"},"your":"\u0644\u0643"},"ar.pagination":{"next":"\u0627\u0644\u062a\u0627\u0644\u064a \"","previous":"\" \u0633\u0627\u0628\u0642"},"ar.passwords":{"reset":"\u062a\u0645 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643!","sent":"\u0644\u0642\u062f \u0623\u0631\u0633\u0644\u0646\u0627 \u0639\u0628\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643!","throttled":"\u064a\u0631\u062c\u0649 \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631 \u0642\u0628\u0644 \u0625\u0639\u0627\u062f\u0629 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629.","token":"\u0631\u0645\u0632 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0647\u0630\u0627 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","user":"\u0644\u0627 \u064a\u0645\u0643\u0646\u0646\u0627 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0647\u0630\u0627."},"ar.validation":{"accepted":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0642\u0628\u0648\u0644\u0647.","active_url":"The :attribute \u0644\u064a\u0633 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d\u064b\u0627.","after":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0628\u0639\u062f: \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","after_or_equal":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0628\u0639\u062f: \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0623\u0648 \u0645\u0633\u0627\u0648\u064a\u064b\u0627 \u0644\u0647.","alpha":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0641\u0642\u0637.","alpha_dash":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0641\u0642\u0637 \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0648\u0623\u0631\u0642\u0627\u0645 \u0648\u0634\u0631\u0637\u0627\u062a \u0648\u0634\u0631\u0637\u0627\u062a \u0633\u0641\u0644\u064a\u0629.","alpha_num":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0648\u0623\u0631\u0642\u0627\u0645 \u0641\u0642\u0637.","array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0635\u0641\u0648\u0641\u0629.","attributes":{"email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","message":"\u0627\u0644\u0631\u0633\u0627\u0644\u0629","name":"\u0627\u0633\u0645","phone":"\u0627\u0644\u0647\u0627\u062a\u0641","service_url":"Service URL"},"before":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0642\u0628\u0644: \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","before_or_equal":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u064a\u0633\u0628\u0642 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a: \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","between":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0628\u064a\u0646: min \u0648: max \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0628\u064a\u0646: min \u0648: max \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0628\u064a\u0646: min \u0648: max.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0628\u064a\u0646: min \u0648: max \u0645\u0646 \u0627\u0644\u0623\u062d\u0631\u0641."},"boolean":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062d\u0642\u0644 \u0635\u062d\u064a\u062d\u064b\u0627 \u0623\u0648 \u062e\u0637\u0623.","confirmed":"\u0627\u0644 :attribute \u0627\u0644\u062a\u0623\u0643\u064a\u062f \u063a\u064a\u0631 \u0645\u062a\u0637\u0627\u0628\u0642.","coupon_code":{"expired":"\u0627\u0646\u062a\u0647\u062a \u0635\u0644\u0627\u062d\u064a\u0629 \u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629","not_found":"\u0631\u0645\u0632 \u0627\u0644\u0642\u0633\u064a\u0645\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f"},"current_password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.","custom":{"attribute-name":{"rule-name":"\u0631\u0633\u0627\u0644\u0629 \u0645\u062e\u0635\u0635\u0629"}},"date":"\u0627\u0644 :attribute \u0647\u0630\u0627 \u0644\u064a\u0633 \u062a\u0627\u0631\u064a\u062e \u0635\u062d\u064a\u062d.","date_equals":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0645\u0633\u0627\u0648\u064a\u064b\u0627 \u0644\u0640: \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","date_format":"\u0627\u0644 :attribute \u0644\u0627 \u064a\u062a\u0637\u0627\u0628\u0642 \u0645\u0639 \u0627\u0644\u062a\u0646\u0633\u064a\u0642: format.","different":"\u0627\u0644 :attribute \u0648: \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0622\u062e\u0631 \u0645\u062e\u062a\u0644\u0641\u064b\u0627.","digits":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646: \u0623\u0631\u0642\u0627\u0645.","digits_between":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0628\u064a\u0646: min \u0648: max \u0623\u0631\u0642\u0627\u0645.","dimensions":"\u0627\u0644 :attribute \u0623\u0628\u0639\u0627\u062f \u0627\u0644\u0635\u0648\u0631\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","distinct":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0644\u0647 \u0642\u064a\u0645\u0629 \u0645\u0643\u0631\u0631\u0629.","email":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0635\u0627\u0644\u062d.","ends_with":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0646\u062a\u0647\u064a \u0628\u0648\u0627\u062d\u062f \u0645\u0645\u0627 \u064a\u0644\u064a: \u0627\u0644\u0642\u064a\u0645.","exists":"\u0627\u0644 \u0627\u0644\u0645\u062d\u062f\u062f :attribute \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641\u064b\u0627.","filled":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0644\u0644\u062d\u0642\u0644 \u0642\u064a\u0645\u0629.","gt":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0643\u062b\u0631 \u0645\u0646: \u0639\u0646\u0627\u0635\u0631 \u0642\u064a\u0645\u0629.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646: \u0627\u0644\u0642\u064a\u0645\u0629 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646: value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"gte":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646: \u0639\u0646\u0627\u0635\u0631 \u0642\u064a\u0645\u0629 \u0623\u0648 \u0623\u0643\u062b\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a: \u0627\u0644\u0642\u064a\u0645\u0629 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u062a\u0633\u0627\u0648\u064a: value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"image":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0635\u0648\u0631\u0629.","in":"\u0627\u0644 \u0627\u0644\u0645\u062d\u062f\u062f :attribute \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","in_array":"\u0627\u0644 :attribute \u0644\u0627 \u064a\u0648\u062c\u062f \u0645\u062c\u0627\u0644 \u0641\u064a: \u0623\u062e\u0631\u0649.","integer":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0635\u062d\u064a\u062d\u0627.","ip":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 IP \u0635\u0627\u0644\u062d\u064b\u0627.","ipv4":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 IPv4 \u0635\u0627\u0644\u062d\u064b\u0627.","ipv6":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 IPv6 \u0635\u0627\u0644\u062d\u064b\u0627.","json":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0633\u0644\u0633\u0644\u0629 JSON \u0635\u0627\u0644\u062d\u0629.","lt":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0642\u0644 \u0645\u0646: \u0642\u064a\u0645\u0629 \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646: value \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646: value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"lte":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0643\u062b\u0631 \u0645\u0646: \u0639\u0646\u0627\u0635\u0631 \u0642\u064a\u0645\u0629.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a: \u0627\u0644\u0642\u064a\u0645\u0629 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0635\u063a\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a: value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"max":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0643\u062b\u0631 \u0645\u0646: \u0643\u062d\u062f \u0623\u0642\u0635\u0649 \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646: \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a \u0643\u062d\u062f \u0623\u0642\u0635\u0649.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646: max.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646: \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0645\u0646 \u0627\u0644\u0623\u062d\u0631\u0641."},"mimes":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: \u0627\u0644\u0642\u064a\u0645.","mimetypes":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: \u0627\u0644\u0642\u064a\u0645.","min":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 \u0639\u0644\u0649: min \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644: \u062f\u0642\u064a\u0642\u0629 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644: min.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644: \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u062f\u0646\u0649 \u0645\u0646 \u0627\u0644\u0623\u062d\u0631\u0641."},"multiple_of":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0646 \u0645\u0636\u0627\u0639\u0641\u0627\u062a: \u0627\u0644\u0642\u064a\u0645\u0629.","not_in":"\u0627\u0644 \u0627\u0644\u0645\u062d\u062f\u062f :attribute \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","not_regex":"\u0627\u0644 :attribute \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0631\u0642\u0645\u0627.","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.","present":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062d\u0642\u0644 \u0645\u0648\u062c\u0648\u062f\u064b\u0627.","prohibited":"\u0627\u0644 :attribute \u0627\u0644\u0645\u062c\u0627\u0644 \u0645\u062d\u0638\u0648\u0631.","prohibited_if":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u062d\u0638\u0648\u0631 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0622\u062e\u0631 \u0647\u0648: \u0627\u0644\u0642\u064a\u0645\u0629.","prohibited_unless":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u062d\u0638\u0648\u0631 \u0645\u0627 \u0644\u0645: \u0627\u0644\u0622\u062e\u0631 \u0641\u064a: \u0627\u0644\u0642\u064a\u0645.","regex":"\u0627\u0644 :attribute \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","required":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.","required_if":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0622\u062e\u0631 \u0647\u0648: \u0627\u0644\u0642\u064a\u0645\u0629.","required_unless":"\u0627\u0644 :attribute \u0645\u0637\u0644\u0648\u0628 \u0627\u0644\u062d\u0642\u0644 \u0645\u0627 \u0644\u0645: \u0627\u0644\u0622\u062e\u0631 \u0641\u064a: \u0627\u0644\u0642\u064a\u0645.","required_with":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0642\u064a\u0645 \u0645\u0648\u062c\u0648\u062f\u0629.","required_with_all":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0642\u064a\u0645 \u0645\u0648\u062c\u0648\u062f\u0629.","required_without":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0642\u064a\u0645 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629.","required_without_all":"\u0627\u0644 :attribute \u064a\u0643\u0648\u0646 \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628\u064b\u0627 \u0641\u064a \u062d\u0627\u0644\u0629 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0623\u064a \u0645\u0646: \u0627\u0644\u0642\u064a\u0645.","same":"\u0627\u0644 :attribute \u0648 :other \u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0637\u0627\u0628\u0642.","size":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649: \u0639\u0646\u0627\u0635\u0631 \u0627\u0644\u062d\u062c\u0645.","file":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0648\u0623\u0646 :size \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646: \u0627\u0644\u062d\u062c\u0645.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646: \u0623\u062d\u0631\u0641 \u0627\u0644\u062d\u062c\u0645."},"starts_with":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0628\u062f\u0623 \u0628\u0648\u0627\u062d\u062f \u0645\u0645\u0627 \u064a\u0644\u064a: \u0627\u0644\u0642\u064a\u0645.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0633\u0644\u0633\u0644\u0629.","timezone":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0645\u0646\u0637\u0642\u0629 \u0632\u0645\u0646\u064a\u0629 \u0635\u0627\u0644\u062d\u0629.","unique":"\u0627\u0644 :attribute \u0644\u0642\u062f \u0627\u062a\u062e\u0630\u062a \u0628\u0627\u0644\u0641\u0639\u0644.","uploaded":"\u0627\u0644 :attribute \u0641\u0634\u0644 \u0627\u0644\u062a\u062d\u0645\u064a\u0644.","url":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d\u064b\u0627.","uuid":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 UUID \u0635\u0627\u0644\u062d\u064b\u0627."},"bg.cookie-consent::texts":{"agree":"\u041f\u0440\u0438\u0435\u043c\u0430\u043c","message":"\u0422\u043e\u0437\u0438 \u0441\u0430\u0439\u0442 \u0438\u0437\u043f\u043e\u043b\u0437\u0432\u0430 \u0431\u0438\u0441\u043a\u0432\u0438\u0442\u043a\u0438, \u0437\u0430 \u0434\u0430 \u043f\u043e\u0434\u043e\u0431\u0440\u0438 \u0432\u0430\u0448\u0435\u0442\u043e \u043f\u043e\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u0441\u043a\u043e \u0438\u0437\u0436\u0438\u0432\u044f\u0432\u0430\u043d\u0435."},"bg.cookieConsent::texts":{"agree":"\u041f\u0440\u0438\u0435\u043c\u0430\u043c","message":"\u0422\u043e\u0437\u0438 \u0441\u0430\u0439\u0442 \u0438\u0437\u043f\u043e\u043b\u0437\u0432\u0430 \u0431\u0438\u0441\u043a\u0432\u0438\u0442\u043a\u0438, \u0437\u0430 \u0434\u0430 \u043f\u043e\u0434\u043e\u0431\u0440\u0438 \u0432\u0430\u0448\u0435\u0442\u043e \u043f\u043e\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u0441\u043a\u043e \u0438\u0437\u0436\u0438\u0432\u044f\u0432\u0430\u043d\u0435."},"bn.cookie-consent::texts":{"agree":"\u0995\u09c1\u0995\u09bf \u09ac\u09cd\u09af\u09ac\u09b9\u09be\u09b0\u09c7\u09b0 \u0985\u09a8\u09c1\u09ae\u09a4\u09bf \u09a6\u09bf\u09a8","message":"\u098f\u0987 \u09b8\u09be\u0987\u099f\u09c7 \u0995\u09c1\u0995\u09bf \u09ac\u09cd\u09af\u09ac\u09b9\u09be\u09b0\u09c7\u09b0 \u0985\u09a8\u09c1\u09ae\u09a4\u09bf \u09aa\u09cd\u09b0\u09a6\u09be\u09a8 \u0995\u09b0\u09be\u09b0 \u09ae\u09be\u09a7\u09cd\u09af\u09ae\u09c7 \u0986\u09aa\u09a8\u09be\u09b0 \u0985\u09ad\u09bf\u099c\u09cd\u099e\u09a4\u09be \u0989\u09a8\u09cd\u09a8\u09a4 \u0995\u09b0\u09be \u09b9\u09ac\u09c7\u09c7\u0964"},"ca.livewire-tables::strings":{"All":"Tot","All Columns":"Totes les columnes","Applied Filters":"Filtres Aplicats","Applied Sorting":"Ordenaci\u00f3 Aplicada","Bulk Actions":"Accions Massives","Clear":"Esborra","Columns":"Columnes","Debugging Values":"Valors de depuraci\u00f3","Deselect All":"Deselecciona tot","Done Reordering":"Reordenaci\u00f3 finalitzada","Filters":"Filtres","No":"No","No items found. Try to broaden your search.":"No s'han trobat elements. Intenti ampliar la cerca.","Remove filter option":"Elimina opci\u00f3 de filtre","Remove sort option":"Elimina opci\u00f3 d'ordenaci\u00f3","Reorder":"Reordena","Search":"Cerca","Select All":"Selecciona tot","Showing":"Mostrant","Yes":"S\u00ed","You are currently selecting all":"Actualment est\u00e0 seleccionant tot","You are not connected to the internet.":"No est\u00e0 conectat a Internet.","You have selected":"Ha seleccionat","of":"de","results":"resultats","row":"fila","rows":"files","rows, do you want to select all":"files, vol seleccionar totes","to":"a"},"cs.cookie-consent::texts":{"agree":"Souhlas\u00edm","message":"Tato str\u00e1nka pou\u017e\u00edv\u00e1 cookies na vylep\u0161en\u00ed va\u0161eho u\u017eivatelsk\u00e9ho z\u00e1\u017eitku."},"cs.cookieConsent::texts":{"agree":"Souhlas\u00edm","message":"Tato str\u00e1nka pou\u017e\u00edv\u00e1 cookies na vylep\u0161en\u00ed va\u0161eho u\u017eivatelsk\u00e9ho z\u00e1\u017eitku."},"da.cookie-consent::texts":{"agree":"Tillad cookies","message":"Din oplevelse p\u00e5 dette websted vil blive forbedret ved at tillade cookies."},"da.cookieConsent::texts":{"agree":"Tillad cookies","message":"Din oplevelse p\u00e5 dette websted vil blive forbedret ved at tillade cookies."},"da.livewire-tables::strings":{"All":"Alle","All Columns":"Alle kolonner","Applied Filters":"Anvendte filtre","Applied Sorting":"Anvendt sortering","Bulk Actions":"Massehandlinger","Clear":"Ryd","Columns":"Kolonner","Debugging Values":"Debugging-v\u00e6rdier","Deselect All":"Frav\u00e6lg alle","Done Reordering":"F\u00e6rdig med omorganisering","Filters":"Filtre","No":"Nej","No items found. Try to broaden your search.":"Ingen elementer fundet. Pr\u00f8v at udvide din s\u00f8gning.","Remove filter option":"Fjern filtermulighed","Remove sort option":"Fjern sorteringsmulighed","Reorder":"Omorganis\u00e9r","Search":"S\u00f8g","Select All":"V\u00e6lg alle","Showing":"Viser","Yes":"Ja","You are currently selecting all":"Du v\u00e6lger i \u00f8jeblikket alle","You are not connected to the internet.":"Du er ikke forbundet til internettet.","You have selected":"Du har valgt","of":"af","results":"resultater","row":"r\u00e6kke","rows":"r\u00e6kker","rows, do you want to select all":"r\u00e6kker, vil du v\u00e6lge alle","to":"til"},"de.auth":{"about":"Etwa","account_deactivate":"Ihr Konto ist derzeit inaktiv. Bitte wenden Sie sich an den Administrator.","app":{"create":"Erstellen","export":"Export","lock_account":"Account sperren","member_since":"Mitglied seit","messages":"Mitteilungen","online":"Online","print":"Drucken","profile":"Profile","reload":"Neu laden","reset":"Zur\u00fccksetzen","search":"Suche","settings":"Einstellungen"},"choose_a_plan_that's_right_for_you":"W\u00e4hlen Sie einen Plan, der zu Ihnen passt","confirm_password":"Kennwort best\u00e4tigen","contact":"Kontakt","copyright_by":"Urheberrecht von","email":"Email","email_verify":"Bitte \u00fcberpr\u00fcfen Sie Ihre E-Mail-Adresse, bevor Sie sich anmelden.","emails":{"password":{"reset_link":"Klicken Sie hier, um Ihr Passwort zur\u00fcckzusetzen"}},"failed":"Diese Anmeldeinformationen stimmen nicht mit unseren Aufzeichnungen \u00fcberein.","features":"Merkmale","forgot_password":{"send_pwd_reset":"Link zum Zur\u00fccksetzen des Passworts senden","title":"Geben Sie die E-Mail-Adresse ein, um das Passwort zur\u00fcckzusetzen"},"full_name":"Vollst\u00e4ndiger Name","get_started":"Loslegen","home":"Heim","let's_hear_what_they_say":"Lass uns h\u00f6ren, was sie sagen","login":{"forgot_password":"Ich habe mein Passwort vergessen","register_membership":"Registrieren Sie eine neue Mitgliedschaft","title":"Melden Sie sich an, um Ihre Sitzung zu starten"},"modern_&_powerful_interface":"Moderne und leistungsstarke Benutzeroberfl\u00e4che","password":"Passwort","pricing":"Preisgestaltung","register":"Registrieren","registration":{"have_membership":"Ich habe bereits eine Mitgliedschaft","i_agree":"Ich stimme zu","terms":"die Bedingungen","title":"Registrieren Sie eine neue Mitgliedschaft"},"remember_me":"Behalte mich in Erinnerung","reset_password":{"reset_pwd_btn":"Passwort zur\u00fccksetzen","title":"Setze dein Passwort zur\u00fcck"},"sign_in":"Anmelden","sign_out":"Ausloggen","sign_up":"Anmeldung","stories_from_our_customers":"Geschichten von unseren Kunden","subscribe_here":"Abonnieren Sie hier","throttle":"Zu viele Anmeldeversuche. Bitte versuchen Sie es in :Sekunden Sekunden erneut."},"de.cookie-consent::texts":{"agree":"Akzeptieren","message":"Diese Seite verwendet Cookies um das Nutzererlebnis zu steigern."},"de.cookieConsent::texts":{"agree":"Akzeptieren","message":"Diese Seite verwendet Cookies um das Nutzererlebnis zu steigern."},"de.crud":{"action":"Aktion","add_new":"Neue hinzuf\u00fcgen","are_you_sure":"Bist du sicher?","back":"Zur\u00fcck","cancel":"Abbrechen","created_at":"Hergestellt in","deleted_at":"Gel\u00f6scht um","detail":"Detail","edit":"Bearbeiten","id":"Ausweis","save":"Speichern","updated_at":"Aktualisiert am"},"de.livewire-tables::strings":{"All":"Alle","Applied Filters":"Angewendete Filter","Applied Sorting":"Angewendete Sortierung","Bulk Actions":"Aktionen","Clear":"Zur\u00fccksetzen","Columns":"Spalten","Done Reordering":"Sortieren abgeschlossen","Filters":"Filter","No items found. Try to broaden your search.":"Es gibt keine Ergebnisse\/Eintr\u00e4ge. Versuche die Suche zu erweitern.","Remove filter option":"Entferne Filterauswahl","Remove sort option":"Entferne Sortierauswahl","Reorder":"erneut Sortieren","Search":"Suche","Select All":"Alle ausw\u00e4hlen","Show":"Show","Showing":"Anzeigen","Unselect All":"Alle abw\u00e4hlen","You are currently selecting all":"Es sind schon alle ausgew\u00e4hlt","You are not connected to the internet.":"Es liegt keine Verbindung zum Internet vor.","You have selected":"Es sind ausgew\u00e4hlt","of":"von","results":"Ergebnisse","rows":"Zeilen","rows, do you want to select all":"Zeilen, sollen alle ausgew\u00e4hlt werden","to":"nach"},"de.messages":{"Business_Beacon":"Business Beacon vCard","CEO\/CXO":"vCard f\u00fcr Unternehmens-CEOs\/CXOs","Clean_Canvas":"Bereinigen Sie die Canvas-vCard","Corporate_Classic":"Corporate Classic vCard","Corporate_Connect":"Corporate Connect vCard","Corporate_Identity":"Corporate Identity vCard","Culinary_Food_Services":"vCard f\u00fcr kulinarische und gastronomische Dienstleistungen","Event_Management":"Event-Management-vCard","Executive_Profile":"Executive-Profil vCard","Fashion_Beauty":"Mode- und Beauty-vCard","Gym":"Fitnessstudio vCard","Hospital":"Krankenhaus-vCard","Lawyer":"Anwalt vCard","Manually":"Manuell","Modern_Edge":"Moderne Edge vCard","Paypal":"Paypal","Portfolio":"Portfolio-vCard","Pro_Network":"Pro Network vCard","Professional":"Professionelle vCard","Programmer":"Programmierer vCard","Razorpay":"Razorpay","Receive_latest_news_update_and_many_other_things_every_week":"Erhalten Sie jede Woche die neuesten Nachrichten, Updates und viele andere Dinge. ","Salon":"Salon-vCard","Simple_Contact":"Einfache Kontakt-vCard","Social_Media":"vCard f\u00fcr Social-Media-Influencer","Stripe":"Streifen","Subscribe_Our_Newsletter":"Abonnieren Sie unseren Newsletter","about_us":{"about_us":"\u00dcber uns","description":"Beschreibung","image":"\u00dcber Bild","title":"Titel"},"admin":{"add_admin":"Administrator hinzuf\u00fcgen","admin":"Administratorin","admin_created_successfully":"Admin erfolgreich erstellt.","admin_delete_successfully":"Der Administrator wurde erfolgreich gel\u00f6scht.","admin_details":"Admin-Details","admin_updated_successfully":"Admin erfolgreich aktualisiert.","avatar":"Benutzerbild","confirm_password":"Kennwort best\u00e4tigen","contact_number":"Kontakt Nummer","edit_admin":"Admin bearbeiten","email":"Email","female":"Weiblich","first_name":"Vorname","full_name":"Vollst\u00e4ndiger Name","gender":"Geschlecht","last_name":"Nachname","male":"M\u00e4nnlich","not_allowed_to_access":"Anscheinend sind Sie nicht berechtigt, auf diesen Datensatz zuzugreifen.","password":"Passwort","profile":"Profil","profile_details":"Profildetails"},"admins":"Admins","affiliation":{"affiliate_note":"Hinweis: Ihre Affiliate-Links werden unten auf Ihrer VCards-Seite angezeigt. Wenn sich jemand hier\u00fcber registriert und anschlie\u00dfend ein Abonnement kauft, werden Sie mit einem Betrag von belohnt","affiliated_by":"Zugeh\u00f6rig von","affiliation_transaction":"Zugeh\u00f6rigkeitstransaktionen","affiliation_withdraw_detail":"Affiliation Austrittsdetail","affiliations":"Zugeh\u00f6rigkeiten","approval_status":"Freigabestand","approve":"Genehmigen","approve_withdraw_request":"Abhebungsantrag genehmigen","approved":"Zugelassen","cash_payment":"Barzahlungen","current_amount":"Aktueller Betrag","reject":"Ablehnen","reject_withdraw_request":"Abhebungsanforderung ablehnen","rejected":"Abgelehnt","rejection_note":"Ablehnungshinweis","total_affiliation_amount":"Gesamtzugeh\u00f6rigkeitsbetrag","verify_paypal_email":"PayPal-E-Mail verifizieren","withdraw_amount":"Betrag beheben","withdrawal":"R\u00fcckzug"},"allowed_file_types":"Erlaubte Dateitypen: png, jpg, jpeg.","analytic":{"vcard_analytic":"Vcard-Analyse"},"analytics":{"browsers":"Browser","countries":"L\u00e4nder","devices":"Ger\u00e4te","languages":"Sprachen","os":"Betriebssysteme","overview":"\u00dcberblick","see_all":"Alles sehen","view_more":"Mehr sehen","visitors":"Besucher"},"appointment":{"appointment":"Termin","appointment_details":"Termindetails","appointment_type":"Terminart:","calendar":"Kalender","ends":"Termin endet","free":"Frei","paid":"Bezahlt","starts":"Termin beginnt"},"appointments":"Termine","business":{"business_hours":"\u00d6ffnungszeiten","end_time":"Endzeit","fri":"Fr","mon":"Mo","sat":"Sa","start_time":"Startzeit","sun":"Sonntag","thu":"Sammeln","tue":"Di","wed":"Heiraten"},"by_signing_up_you_agree_to_our":"Mit der Anmeldung stimmen Sie unseren zu","cash_payment":"Barzahlungen","city":{"cities":"St\u00e4dte","city":"Stadt","city_name":"Stadtname","edit_city":"Stadt bearbeiten","new_city":"Neue Stadt","no_city_available":"Keine Stadt verf\u00fcgbar","no_city_found":"Keine Stadt gefunden","state_name":"Staatsnamee"},"common":{"Yes_Change":"ja \u00e4ndern","action":"Aktion","active":"Aktiv","add":"Hinzuf\u00fcgen","add_virtual_background":"Virtuellen Hintergrund hinzuf\u00fcgen","allow_cookies":"Cookies zulassen","already_have_an_account":"Sie haben bereits ein Konto","apply":"Sich bewerben","apply_changes":"Wenden Sie diese \u00c4nderungen an","are_you_completed":"M\u00f6chten Sie diesen Status wirklich \u00e4ndern?","are_you_sure":"M\u00f6chten Sie dies wirklich l\u00f6schen?","are_you_sure_dublicate_vcard":"M\u00f6chten Sie wirklich ein Duplikat dieser VCard erstellen?","back":"Zur\u00fcck","back_subscription":"Zur\u00fcck zu Abonnements","cancel":"Abbrechen","captcha_enable":"Aktivieren Sie Google Captcha","closed":"Abgeschlossen","completed":"abgeschlossen","cookie_banner_enabled":"Cookie-Banner aktivieren","cookie_msg":"Ihre Erfahrung auf dieser Website wird durch das Zulassen von Cookies verbessert.","create_an_account":"Ein Konto erstellen","currency_position":"W\u00e4hrungsposition","custom":"Brauch","declined":"Abfall","default_country_code":"Standard-L\u00e4ndercode","delete":"L\u00f6schen","deleted":"Gel\u00f6scht","description":"Beschreibung","details":"Einzelheiten","discard":"Verwerfen","download":"Download","duplicate":"Duplizieren!","duplicate_vcard_create":"Doppelte VCard erfolgreich erstellt","edit":"Bearbeiten","email":"Email","enable_cookie_banner":"Cookie-Banner aktivieren","enable_page":"Landingpage aktivieren","enable_register":"Aktivieren Sie die Registrierung","enable_validation":"Validierung aktivieren","enquiry":"Anfragen","error":"Fehler","filter":"Filter","forgot_password":"Passwort vergessen","forgot_your_password":"Passwort vergessen","from":"Aus","has_been_completed":"Wurde vervollst\u00e4ndigt.","has_been_deleted":"wurde gel\u00f6scht.","icon":"Symbol","inactive":"Inaktiv","infyvcard":"InfyVcard","is_active":"Ist aktiv","link":"Verkn\u00fcpfung","loading":"Wird geladen...","login":"Anmeldung","logout":"Ausloggen","message":"Nachricht","name":"Name","new_here":"Neu hier","no":"Nein, Abbrechen","no_data_available":"Keine Daten verf\u00fcgbar","notUsed":"Noch nicht verwendet","ok":"In Ordnung","payment_methods":"Bezahlverfahren","paypal_email":"Paypal Email","pending":"Ausstehend","phone":"Telefon","phone_validation":"Telefonnummernvalidierung","please_wait":"Warten Sie mal...","price":"Preis","product_url":"Produkt-URL","register":"Registrieren","register_enable":"Registrierung aktivieren","remember_me":"Behalte mich in Erinnerung","reset":"Zur\u00fccksetzen","save":"Speichern","service_url":"Dienst-URL","show_currency_behind":"W\u00e4hrung dahinter anzeigen","sign_in_here":"Hier anmelden","status":"Status","sub_text":"Untertext","subject":"Gegenstand","submit":"einreichen","subscription":"Subscription","successful":"Erfolgreich","to":"Zu","today":"Heute","today_appointments":"Heute Termine","today_enquiry":"Heute Anfragen","total__active_vcards":"Gesamtzahl aktiver Karten","total__deactive_vcards":"Gesamtzahl der deaktivierten VCards","total_active_users":"Gesamtzahl aktiver Benutzer","total_amount":"Gesamtmenge","total_deactive_users":"Gesamtzahl inaktiver Benutzer","total_plans":"Gesamtpl\u00e4ne","total_users":"Benutzer insgesamt","total_vcards":"VCards insgesamt","type":"Art","unavailable":"Nicht verf\u00fcgbar","upload_file":"Datei hochladen","user":"Benutzer","view":"Aussicht","virtual_note":"Hinweis: Virtual Backgrounds stellt Ihnen Visitenkartenbilder zur Verf\u00fcgung, in die Ihr Logo, Ihr Name, Ihre Adresse und Ihre Telefonnummer geschrieben werden. Wir exportieren horizontale und vertikale virtuelle Hintergr\u00fcnde in Standardgr\u00f6\u00dfen. Dies ist n\u00fctzlich, wenn Sie Ihre NFC-Karte entwerfen m\u00f6chten. Sie k\u00f6nnen diese Bilder direkt an NFC-Drucker weitergeben. Sie k\u00f6nnen dies auch direkt mit Ihren Freunden teilen oder es als Profil-\/Titelbild festlegen.","yes":"Ja, l\u00f6schen","yes_duplicate":"Ja, duplizieren!"},"contact_us":{"contact":"Kontaktiere uns","contact_us":"Anfragen","inquries":"Anfragen","message":"Nachricht","send_message":"Nachricht senden"},"copy_text":"Kopieren","country":{"countries":"L\u00e4nder","country":"Land","country_name":"L\u00e4ndername","edit_country":"Land bearbeiten","new_country":"Neues Land","no_country_available":"Kein Land verf\u00fcgbar","no_country_found":"Kein Land gefunden","phone_code":"Telefoncode","short_code":"Kurzcode"},"coupon_code":{"add_coupon_code":"Gutscheincode hinzuf\u00fcgen","apply_here":"Hier bewerben","coupon_code":"Gutscheincode","coupon_code_applied":"Gutscheincode erfolgreich angewendet.","coupon_code_created":"Gutscheincode erfolgreich erstellt.","coupon_code_percent_validation":"Der Coupon-Rabatt sollte nicht mehr als 100 % betragen.","coupon_code_status_updated":"Gutscheincode-Status erfolgreich aktualisiert.","coupon_code_updated":"Gutscheincode erfolgreich aktualisiert.","coupon_codes":"Gutscheincodes","coupon_discount":"Gutscheinrabatt","coupon_name":"Gutscheinname","coupon_type":"Gutscheintyp","edit_coupon_code":"Gutscheincode bearbeiten","enter_coupon_code":"Gutschein-Code eingeben","enter_coupon_discount":"Gutscheinrabatt eingeben","enter_coupon_name":"Gutscheinname eingeben","expire_at":"Ablaufen um","fixed":"Fester Typ","flat":"Wohnung","have_a_coupon_code":"Haben sie einen Gutscheincode ?","percentage":"Prozentsatz","remove":"Entfernen"},"create_vcard":"Erstellen Sie Ihre VCard","create_your_business_digital_card_with_lots_of_information":"Erstellen Sie Ihre digitale Visitenkarte mit vielen Informationen","currency":{"currencies":"W\u00e4hrungen","currency_code":"W\u00e4hrungscode","currency_icon":"W\u00e4hrungssymbol"},"dashboard":"Dashboard","date":"Datum","deactivate":"Deaktivieren","e_card":{"add_ecard":"E-Karte hinzuf\u00fcgen","ecard":"E-Karte","ecard_info":"Das Bild muss eine Pixelgr\u00f6\u00dfe von 150 x 150 haben","ecard_logo":"E-Card-Logo","ecards":"E-Karten"},"edit_subscription":"Abonnementplan bearbeiten","email_not_found":"Wir k\u00f6nnen keinen Benutzer mit dieser E-Mail-Adresse finden","email_password_reset_link":"Link zum Zur\u00fccksetzen des Passworts per E-Mail","enquiry":"Anfragen","enquiry_detail":"Einzelheiten der Anfrage","expire_in":"Der Plan ist in K\u00fcrze abgelaufen","extra_scripts":"Zus\u00e4tzliche Skripte","feature":{"affiliation":"Zugeh\u00f6rigkeit","analytics":"Analytik","appointments":"Termine","blog":"Bloggen","custom_css":"Benutzerdefinierte CSS","custom_fonts":"Benutzerdefinierte Schriftarten","custom_js":"Benutzerdefiniertes JS","custom_qrcode":"Benutzerdefinierter QR-Code","description":"Beschreibung","edit_feature":"Funktion bearbeiten","enquiry_form":"Anfrageformular","feature_image":"Feature-Bild","gallery":"Galerie","hide_branding":"Branding ausblenden","image":"Bild","name":"Name","password":"Passwortschutz","products":"Produkte","products_services":"Dienstleistungen","seo":"Suchmaschinenoptimierung","social_links":"Soziale Verbindungen","testimonials":"Referenzen"},"features":"Merkmale","flash":{"about_us_create":"\u00dcber uns erfolgreich gespeichert.","can_not_change_time_format":"F\u00fcr dieses Zeitformat ist bereits ein Termin gebucht","city_create":"Stadt erfolgreich gespeichert.","city_update":"Stadt erfolgreich aktualisiert.","country_create":"Land erfolgreich gespeichert.","country_update":"Land erfolgreich aktualisiert.","country_used":"Land bereits verwendet","create_blog":"VCard-Blog erfolgreich erstellt.","create_front_testimonial":"Testimonial erfolgreich erstellt.","create_product":"VCard-Produkt erfolgreich erstellt.","create_service":"VCard-Dienst erfolgreich erstellt.","create_testimonial":"VCard-Testimonial erfolgreich erstellt.","current_invalid":"Aktuelles Passwort ist ung\u00fcltig.","database_upgrade_succesfully":"Ihre Datenbank wurde erfolgreich aktualisiert","decription_is_required":"Das Beschreibungsfeld ist erforderlich","feature_update":"Funktion erfolgreich aktualisiert.","front_cms":"Front-CMS erfolgreich aktualisiert.","language_update":"Sprache erfolgreich aktualisiert.","mobile_validation":"Mobile Validierung erfolgreich aktualisiert.","name_is_required":"Das Namensfeld ist erforderlich","password_update":"Passwort erfolgreich aktualisiert.","plan_create":"Plan erfolgreich erstellt.","plan_default":"Standardplan erfolgreich ge\u00e4ndert.","plan_status":"Planstatus erfolgreich aktualisiert","plan_update":"Plan erfolgreich aktualisiert.","reactive_account":"Reaktivieren Sie Ihr Konto von Mail.","setting_update":"Einstellungen erfolgreich aktualisiert.","social_links_img_is_required":"Soziale Links Bild ist erforderlich","social_links_is_required":"Soziale Verbindungen sind erforderlich","state_create":"Zustand erfolgreich gespeichert.","state_update":"Zustand erfolgreich aktualisiert.","state_used":"Zustand bereits gebraucht","success_theme_update":"Theme erfolgreich aktualisiert","update_blog":"VCard-Blog erfolgreich aktualisiert.","update_front_testimonial":"Testimonial erfolgreich aktualisiert.","update_product":"VCard-Produkt erfolgreich aktualisiert.","update_service":"VCard-Dienst erfolgreich aktualisiert.","update_testimonial":"VCard-Testimonial erfolgreich aktualisiert.","user_create":"Benutzer erfolgreich erstellt.","user_profile":"Benutzerprofil erfolgreich aktualisiert.","user_status":"Benutzerstatus erfolgreich aktualisiert","user_update":"Benutzer erfolgreich aktualisiert.","vcard_create":"VCard erfolgreich erstellt.","vcard_delete":"VCard erfolgreich gel\u00f6scht.","vcard_retrieve":"VCard erfolgreich abgerufen","vcard_status":"VCard-Status erfolgreich aktualisiert","vcard_update":"Erfolgreich geupdated.","verified_email":"E-Mail erfolgreich verifiziert"},"font":{"font_family":"Schriftfamilie","font_size":"Schriftgr\u00f6\u00dfe","font_size_in_px":"Schriftgr\u00f6\u00dfe in Pixel","fonts":"Schriftarten","px":"px"},"form":{"DOB":"Geburtsdatum eingeben","allowed_vcard":"Geben Sie die Anzahl zul\u00e4ssiger Vcards ein","blog":"Geben Sie den Blog-Namen ein","c_password":"Best\u00e4tige das Passwort","company":"Geben Sie den Firmennamen ein","contact":"Telefonnummer","css":"Geben Sie benutzerdefiniertes CSS ein","description":"Geben Sie die Beschreibung Ihrer VCard ein","designation":"Bezeichnung eingeben","email":"E-Mail Adresse eingeben","enter_email":"Email eingeben","enter_name":"Name eingeben","enter_phone":"Geben Sie Telefon ein","enter_trial":"Geben Sie Probetage ein","f_name":"Bitte Vornamen eingeben","facebook":"Facebook URL","first_name":"Vorname","google_analytics":"Google Analytics-Code","home_title":"Geben Sie den Home-Titel ein","instagram":"Instagram-URL","job":"Stellenbezeichnung eingeben","js":"Geben Sie benutzerdefinierte Js ein","l_name":"Nachnamen eingeben","last_name":"Familienname, Nachname","linkedin":"LinkedIn-URL","location":"Gib deinen Standort an","location_url":"Geben Sie Ihre Standort-URL ein","mail":"Email","meta_description":"Geben Sie die Meta-Beschreibung ein","meta_keyword":"Geben Sie das Meta-Schl\u00fcsselwort ein","my_vcard_url":"meine-vcard-seiten-url","occupation":"Beruf eingebenn","password":"Passwort","phone":"Telefonnummer eingeben","pick_date":"Suche dir einen Termin aus","pinterest":"Pinterest-URL","plan_name":"Plannamen eingeben","price":"Preis eingeben","product":"Geben Sie den Produktnamen eine","product_url":"Geben Sie die Produkt-URL ein","reddit":"Reddit-URL","select_country":"Land ausw\u00e4hlen","select_currency":"W\u00e4hrung w\u00e4hlen","select_state":"Staat w\u00e4hlen","service":"Geben Sie den Dienstnamen ein","service_url":"Dienst-URL eingeben","short_description":"Kurzbeschreibung eingeben","site_title":"Geben Sie den Seitentitel ein","testimonial":"Geben Sie den Testimonial-Namen ein","tiktok":"Klicken Sie auf die URL","tumblr":"Tumblr-URL","twitter":"Twitter-URL","type_message":"Geben Sie hier eine Nachricht ein...","vcard_name":"Geben Sie den VCard-Namen eine","website":"Webadresse","whatsapp":"WhatsApp-URL","your_email":"E-Mail-Addresse","your_name":"Dein Name","youtube":"Youtube-URL"},"from_time":"Von Zeit","front":{"enter_your_email":"Geben sie ihre E-Mail Adresse ein","enter_your_message":"Gib deine Nachricht ein","enter_your_name":"Gib deinen Namen ein","your_email_address":"Ihre E-Mail-Adresse"},"front_cms":{"banner":"Bannerbild","description":"Beschreibung","front_cms":"Front-CMS","title":"Titel"},"gallery":{"gallery_name":"Galerien","image":"Bild","type":"Typ","youtube":"Youtube"},"hour":"Stunde","language":"Sprache","languages":{"edit_language":"Sprache bearbeiten","edit_translation":"Editar traducci\u00f3n","iso_code":"ISO-CODE","language":"Sprache","languages":"Sprachen","new_language":"Neue Sprache","translation":"\u00dcbersetzung"},"made_by":"Hergestellt von","made_by_url":"Erstellt von URL","mail":{"action_required":"Wenn Sie kein Konto erstellt haben, sind keine weiteren Ma\u00dfnahmen erforderlich.","appointment_time":"Termin: ","approved_successfully":"Ihr Termin wurde am erfolgreich genehmigt","attachment":"Anhang","between":"zwischen","book_appointment":"Hier ist ein Anfragedetail","book_successfully":"Ihr Termin wurde erfolgreich gebucht auf","booked_appointment_with_you":"gebuchten Termin bei Ihnen","email":"Email: ","hello":"Hallo,","hello!":"Hallo!","here_is_enquiry":"Hier ist ein Anfragedetail","messages":"Nachricht: ","name":"Name: ","new_manual_payment_request":"Neue manuelle Zahlungsanforderung","new_nfc_order":"Sie haben eine neue NFC-Bestellung erhalten von","notes":"Anmerkungen","password_change":"Ihr Passwort wurde vom Administrator ge\u00e4ndert ","please_click":"Bitte klicken Sie auf die Schaltfl\u00e4che unten, um Ihre E-Mail-Adresse zu best\u00e4tigen.","please_contact_your_admin":"Bitte wenden Sie sich an den Administrator, um ein neues Passwort zu erhalten. ","regard":"Gr\u00fc\u00dfe,","slot_text":"Wenn Sie Probleme beim Klicken auf die Schaltfl\u00e4che \u201eE-Mail-Adresse best\u00e4tigen\u201c haben, kopieren Sie die folgende URL und f\u00fcgen Sie sie in Ihren Webbrowser ein:","thanks_regard":"Danke & Gr\u00fc\u00dfe,","vcard_name":"VCard-Name: ","verify_email":"Email Adresse best\u00e4tigen","whoops":"Hoppla!"},"make_appointment":"Einen Termin machen","make_appointments":"Einen Termin machen","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Juli","jun":"Jun","mar":"Besch\u00e4digen","may":"Kann","nov":"Nov","oct":"Okt","sep":"Sep"},"nfc":{"Add_NFC_card_photos_and_set_prices":"F\u00fcgen Sie NFC-Kartenfotos hinzu und legen Sie Preise fest.","Admin_Guide":"Admin-Leitfaden: Verkauf von NFC-Karten","Browse_and_select_an_NFC_card":"Durchsuchen und w\u00e4hlen Sie eine NFC-Karte aus.","Cancelled":"Abgesagt","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"W\u00e4hlen Sie Ihre vCard. Die URL dieser vCard wird auf die NFC-Karte geschrieben.","Confirm_the_order_and_make_a_payment":"Best\u00e4tigen Sie die Bestellung und t\u00e4tigen Sie eine Zahlung.","Create_or_log_in_to_your_account":"Erstellen Sie ein Konto oder melden Sie sich an.","Delivered":"Geliefert","Dispatch_the_NFC_cards_to_users":"Versenden Sie die NFC-Karten an Benutzer.","How_it_works":"Wie funktioniert es?","Log_in_to_the_Admin_Dashboard":"Melden Sie sich im Admin-Dashboard an.","Pending":"Ausstehend","Ready To Ship":"Versandfertig","Receive_and_enjoy_your_NFC_card":"Erhalten Sie und genie\u00dfen Sie Ihre NFC-Karte.","Review_user_orders":"\u00dcberpr\u00fcfen Sie Benutzerbestellungen","Shipped":"Ausgeliefert","User_Guide":"Benutzerhandbuch: Kaufen und Anpassen von NFC-Karten","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"Warten Sie, bis der Administrator die URL schreibt und die Karte versendet.","Write_the_user_provided_URL_to_NFC_cards":"Schreiben Sie die vom Benutzer bereitgestellte URL auf NFC-Karten.","add_nfc_card":"NFC-Karte hinzuf\u00fcgen","all":"Alle","cancel":"Abgesagt","card_can_not_deleted":"Die Karte kann nicht gel\u00f6scht werden, da sie mit Kundenbestellungen verkn\u00fcpft ist.","card_type":"Speicherkarten-Typ","company_name":"Name der Firma","designation":"Bezeichnung","edit_nfc_card":"NFC-Karte bearbeiten","enter_address":"Adresse eingeben","failed":"Fehlgeschlagen","logo":"Logo","my_nfc_cards":"Meine NFC-Karten","new_nfc_card":"Neue NFC-Karte","nfc":"NFC","nfc_card":"NFC-Karte","nfc_card_created_success":"NFC-Karte erfolgreich erstellt","nfc_card_deleted_success":"NFC-Karte erfolgreich gel\u00f6scht","nfc_card_order_details":"Bestelldetails f\u00fcr NFC-Karten","nfc_card_orders":"Bestellungen von NFC-Karten","nfc_card_type":"NFC-Kartentyp","nfc_card_types":"NFC-Kartentypen","nfc_card_updated_success":"NFC-Karte erfolgreich aktualisiert","nfc_image":"Kartenbild","nfc_image_required":"Das Feld \u201eNFC-Bild\u201c ist erforderlich.","order":"Befehl","order_nfc":"Bestellen Sie NFC","order_nfc_card":"NFC-Karte bestellen","order_placed_success":"Bestellung erfolgreich aufgegeben","order_status":"Bestellstatus","order_status_update_success":"Bestellstatus erfolgreich aktualisiert","orders":"Auftr\u00e4ge","orders_count":"Bestellungen z\u00e4hlen","paid":"Bezahlt","payment_status":"Zahlungsstatus","payment_status_update_success":"Zahlungsstatus erfolgreich aktualisiert","pending":"Ausstehend","razorpay_session_success":"RazorPay-Sitzung erfolgreich erstellt","required_vcard":"Bitte w\u00e4hlen Sie Vcard aus","select_card":"Bitte w\u00e4hlen Sie den Kartentyp aus","select_vcard":"W\u00e4hlen Sie vCard","sell_nfc_cards":"Verkaufe NFC-Karten","your_order_status_changed":"Ihr Bestellstatus hat sich ge\u00e4ndert"},"no_data":"Keine Daten verf\u00fcgbar","no_matching_records_found":"Keine \u00fcbereinstimmenden Aufzeichnungen gefunden","notification":{"mark_all_as_read":"Alles als gelesen markieren","notifications":"Benachrichtigungen","you_don`t_have_any_new_notification":"Sie haben keine neue Benachrichtigung"},"payment":{"cancelled":"STORNIERT","payment":"ZAHLUNG","payment_cancel":"Zahlung stornieren","payment_success":"Zahlungserfolg","payment_successful":"Bezahlung erfolgreich"},"payment_method":"Zahlungsmethode","payment_type":"Zahlungsart","placeholder":{"12_hour":"12 Stunden","24_hour":"24 Stunden","address_field":"Das Feld Adressfeld ist erforderlich.","agree_term":"Sie m\u00fcssen den Allgemeinen Gesch\u00e4ftsbedingungen zustimmen.","all_rights_reserve":"Alle Rechte vorbehalten","app_name_required":"Das Feld App-Name ist erforderlich","appointment_created":"Termin erfolgreich erstellt.","cannot_switch_to_zero":"Kann nicht zum Zero-Plan wechseln, wenn eine Testversion verf\u00fcgbar ist \/ einen bezahlten Plan hat, der derzeit aktiv ist","choose_one_template":"W\u00e4hlen Sie eine beliebige Vorlage aus","copied_successfully":"Erfolgreich kopiert..","de_active":"Deaktiv","default_plan_can_not_be_delete":"Standardplan kann nicht gel\u00f6scht werden","email_already_subscribed":"Die E-Mail wurde bereits abonniert.","email_verification":"Ihr Profil wurde aktualisiert. Wir haben Ihnen eine Verifizierungsmail gesendet. Bitte \u00fcberpr\u00fcfen Sie Ihre ge\u00e4nderte E-Mail.","enquiry_sent":"Anfrage erfolgreich gesendet.","enter_valid_email":"Bitte eine g\u00fcltige E-Mail-Adresse eintragen.","enter_your_email_to_reset":"Geben Sie Ihre E-Mail-Adresse ein, um Ihr Passwort zur\u00fcckzusetzen.","favicon_invalid":"Das Favicon hat ung\u00fcltige Bildabmessungen.","first_name_required":"Das Feld Vorname ist erforderlich.","forgot_your_password_no_problem":"Haben Sie Ihr Passwort vergessen? Kein Problem. Teilen Sie uns einfach Ihre E-Mail-Adresse mit und wir senden Ihnen per E-Mail einen Link zum Zur\u00fccksetzen des Passworts, mit dem Sie ein neues ausw\u00e4hlen k\u00f6nnen.","gallery_created":"Galerie erfolgreich erstellt.","gallery_updated":"Galerie erfolgreich aktualisiert.","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_number":"Ung\u00fcltige Nummer","lang_already_exists":" Sprache existiert bereits.","language_save":"Sprache erfolgreich gespeichert.","last_name_required":"Das Feld \u201eNachname\u201c ist erforderlich.","last_week":"Last Week","login_via_facebook":"Einloggen \u00fcber Facebook","login_via_google":"Anmeldung \u00fcber Google","message_sent":"Nachricht erfolgreich gesendet.","multi_templates":"Es sind mehrere Vorlagen erforderlich","paid_appointment_cant_delete":"Bezahlter Termin Kann nicht gel\u00f6scht werden","password_character":"Das Passwort muss mindestens 8 Zeichen lang sein.","password_invalid":"Passwort ist ung\u00fcltig","password_is_correct":"Passwort ist korrekt","password_must_match":"Passwort und Passwortbest\u00e4tigung m\u00fcssen \u00fcbereinstimmen.","passwords":"Das Passwortfeld ist erforderlich.","payment_cancel":"Ihre Zahlung wurde storniert","payment_done":"Zahlung erfolgreich durchgef\u00fchrt.","payment_not_complete":"Zahlung nicht abgeschlossen","payment_received":"Zahlung erfolgreich erhalten.","paypal_created":"Paypal-Sitzung erfolgreich erstellt.","paypal_key":"Paypal-Schl\u00fcsselfeld ist erforderlich.","paypal_mode":"Das Feld f\u00fcr den Paypal-Modus ist erforderlich.","paypal_secret":"Paypal-Geheimfeld ist erforderlich.","phone_number_required":"Das Feld Telefonnummer ist erforderlich.","plan_already_used":"Plan bereits in gebraucht","plan_expire_notification":"Das Feld Planablaufbenachrichtigung ist erforderlich.","please_add_payment_credentials":"Bitte Zahlungsdaten hinzuf\u00fcgen","privacy_policy":"Die Datenschutzerkl\u00e4rung ist erforderlich.","product_purchase":"Produkt erfolgreich gekauft.","purchased_plan":"Sie kaufen diesen Plan erfolgreich.","receive_latest_news":"Erhalten Sie jede Woche die neuesten Nachrichten, Updates und viele andere Dinge.","registered_success":"Sie haben sich erfolgreich registriert, aktivieren Sie Ihr Konto per Mail.","required_captcha":"Bitte \u00fcberpr\u00fcfen Sie das Captcha","role_created":"Rolle erfolgreich erstellt.","select_hour":"Bitte w\u00e4hlen Sie Datum oder Stunde aus","select_one_or_more":"W\u00e4hlen Sie eine oder mehrere Funktionen aus, die erforderlich sind","short_code_only_alpha":"Der Kurzcode darf nur Buchstaben enthalten.","stripe_created":"Stripe-Sitzung erfolgreich erstellt..","stripe_key":"Stripe-Schl\u00fcsselfeld ist erforderlich.","stripe_secret":"Stripe-Secret-Feld ist erforderlich.","subscribed_plan":"Sie haben diesen Plan erfolgreich abonniert.","subscribed_plan_wait":"Sie haben diesen Plan erfolgreich abonniert, warten aber auf die Best\u00e4tigung des Administrators","subscribed_successfully":"Erfolgreich abonniert.","subscription_date_updated":"Abonnementdatum erfolgreich aktualisiert.","successfully_verified":"Sie haben Ihre E-Mail erfolgreich best\u00e4tigt, bitte melden Sie sich an.","the_term_conditions":"Die Allgemeinen Gesch\u00e4ftsbedingungen sind erforderlich.","there_is_not_available_slot":"F\u00fcr das angegebene Datum sind keine Slots verf\u00fcgbar","this_currency_is_not_supported":"Diese W\u00e4hrung wird von PayPal f\u00fcr Zahlungen nicht unterst\u00fctzt.","this_week":"This Week","time_format":"Zeitformat","too_long":"Zu lang","too_short":"Zu kurz","unable_to_process_payment":"Die Zahlung kann derzeit nicht verarbeitet werden. Versuchen Sie es sp\u00e4ter noch einmal.","upload_required":"Das Datei-Upload-Feld ist erforderlich.","valid_number":"G\u00fcltige Nummer","we_could_not_fb_id":"Wir konnten keine E-Mail-Adresse in Ihrem Facebook-Konto finden","withdrawal_request_send":"Auszahlungsantrag erfolgreich genehmigt.","your_mail_already_verified":"Ihre E-Mail wurde bereits verifiziert, bitte melden Sie sich an."},"plan":{"We'll_never_share_your_email_with_anyone_else":"Wir geben Ihre E-Mail-Adresse niemals an Dritte weiter.","additional_domains":"Zus\u00e4tzliche Dom\u00e4nen","affiliation":"Zugeh\u00f6rigkeiten","analytics":"Analytik","blog":"Blogs","currency":"W\u00e4hrung","custom_css":"Benutzerdefinierte CSS","custom_fields":"Benutzerdefinierte Felder","custom_js":"Benutzerdefiniertes JS","custom_qrcode":"Benutzerdefinierter QR-Code","days":"Tage","default_Plan":"Standardplan","description":"Beschreibung","domains_limit":"Domains-Limit","duration":"Dauer","duration_months":"Dauer Monate","duration_years":"Dauer Jahre","edit_plan":"Plan bearbeiten","email_address":"E-Mail-Adresse","enquiry_form":"Anfrageformular","features":"Merkmale","frequency":"Frequenz","gallery":"Galerie","hide_branding":"Branding ausblenden","is_trial":"Ist Versuch","make_default":"Machen Standard","monthly":"Monatlich","months":"Monate","multi_templates":"Multi-Vorlagen","new_plan":"Neuer Plan","no_of_vcards":"Anzahl der VCards","password_protection":"Passwortschutz","plan":"Planen","plan_type":"Plantyp","portfolio":"Portfolio","price":"Preis","products":"Produkte","products_&_services":"Produkte","qrcode":"QR-Code","remaining_balance":"Restguthaben von Prev. Planen","select_all_feature":"W\u00e4hlen Sie Alle Funktionen aus","select_plan":"Plan ausw\u00e4hlen","sendemail":"E-Mail senden","sendinvite":"Sende Einladung","seo":"Suchmaschinenoptimierung","services":"Dienstleistungen","status":"Status","testimonials":"Referenzen","total_custom_domains_limit":"Gesamtlimit f\u00fcr benutzerdefinierte Dom\u00e4nen","trial_days":"Schnuppertage","unlimited":"Unbegrenzt","valid_upto":"G\u00fcltig bis","what_s_in_startup_plan":"Was steht im Gr\u00fcndungsplan?","yearly":"J\u00e4hrlich","years":"Jahre"},"plan_expire":"Plan ist abgelaufen. Bitte w\u00e4hlen Sie einen Plan, um den Dienst fortzusetzen.","plan_expire_notification":"Planablaufbenachrichtigung (in Tagen)","plans":"Pl\u00e4ne","product_details":"Details zur Produktbestellung","product_orders":"Produktbestellungen","resend_verification_email":"Best\u00e4tigungsmail erneut senden","reset_password":"Passwort zur\u00fccksetzen","role":{"edit_role":"Rolle bearbeiten","name":"Name","new_role":"Neue Rolle","permissions":"Berechtigungen","role_permissions":"Rollenberechtigungen","select_all_permissions":"W\u00e4hlen Sie Alle Berechtigungen aus"},"roles":"Rollen","sadmin_dashboard":{"contact":"Kontakt Nr","day":"Tag","email":"Email","income":"Einkommen","month":"Monat","name":"Name","plans_by_users":"Pl\u00e4ne von Benutzern","recent_users_registration":"Registrierung der letzten Benutzer","registered_on":"Registriert auf","week":"Woche"},"select_payment_type":"W\u00e4hlen Sie Zahlungsgateway aus","services":"Dienstleistungen","setting":{"add_contact":"Als Kontakt hinzuf\u00fcgen","address":"Adresse","affiliation_amount":"Zugeh\u00f6rigkeitsbetrag","affiliation_withdraw":"Zugeh\u00f6rigkeit entzieht","app_logo":"App-Logo","app_name":"App Name","clinic_name":"Klinikname","contact_information":"Kontaktinformation","credentials":"Referenzen","currency":"W\u00e4hrung","currency_settings":"W\u00e4hrungseinstellungen","default_currency_format":"Standard-W\u00e4hrungsformat","default_language":"Standardsprache","disable_landing_page":"Landingpage deaktivieren","enable_addcontact":"Aktivieren Sie \u201eZum Kontakt hinzuf\u00fcgen\u201c.","enable_affiliation":"Zugeh\u00f6rigkeit aktivieren","enable_contact":"Kontakt aktivieren","favicon":"Favicon","front_page_enable":"Vorderseite aktivieren","general":"Allgemein","general_details":"Allgemeine Einzelheiten","hide_stickybar":"vCard Sticky Bar ausblenden","location_url":"Standort-URL","manually":"Manuell","note":"Hinweis: Der Name des hochgeladenen Symbols sollte \u201eWeChat.png\u201c \/ \u201eTumbler.png\u201c \/ \u201eXXX.png\u201c lauten. Beim Herunterladen der .vcf-Datei wird dieser Name als Bezeichnung verwendet.","paypal":"Paypal","paypal_client_id":"Paypal-Kunden-ID","paypal_key":"Paypal-Schl\u00fcssel","paypal_mode":"Paypal-Modus","paypal_payout_email":"Paypal-Auszahlungs-E-Mail","paypal_secret":"Paypal-Geheimnis","postal_code":"Postleitzahl","prefix":"Pr\u00e4fix","razorpay":"Razorpay","razorpay_key":"Razorpay-Schl\u00fcssel","razorpay_secret":"Razorpay-Geheimnis","select_currency":"W\u00e4hrung w\u00e4hlen","setting":"Einstellung","shipping_address":"Lieferanschrift","specialities":"Spezialit\u00e4ten","stripe":"Streifen","stripe_key":"Stripe-Schl\u00fcssel","stripe_secret":"Stripe-Geheimnis","upgrade_database":"Datenbank aktualisieren","user_default_language":"Standardsprache des Benutzers","whatsapp_share":"WhatsApp-Freigabe","withdraw_transactions":"Transaktionen abheben","withdrawals":"Abhebungen","wp_number":"Geben Sie die Telefonnummer ein."},"settings":"Einstellungen","sign_out":"Austragen","social":{"Facebook":"Facebook","Instagram":"Instagram","Linkedin":"Linkedin","Pinterest":"Pinterest","Reddit":"Reddit","Share_on_email":"Per E-Mail teilen","Share_on_facebook":"Auf Facebook teilen","Share_on_linkedin":"Auf LinkedIn teilen","Share_on_pinterest":"Auf Pinterest teilen","Share_on_reddit":"Auf Reddit teilen","Share_on_twitter":"Auf Twitter teilen","Share_on_whatsapp":"Auf WhatsApp teilen","Tiktok":"Tick \u200b\u200bTack","Tumblr":"Tumblr","Twitter":"Twitter","Whatsapp":"Whatsapp","Youtube":"Youtube","map":"Karte","social_links":"Soziale Links - Website","website":"Webseite"},"state":{"country_name":"L\u00e4ndername","edit_state":"Status bearbeiten","new_state":"Neue State","no_state_available":"Kein Bundesland verf\u00fcgbar","no_state_found":"Kein Zustand gefunden","state":"Zustand","state_name":"Staatsname","states":"Zust\u00e4nde"},"subscribe":"Abonnieren","subscribed_plans":"Abonnierte Pl\u00e4ne","subscribed_user":"Abonnierte Benutzerpl\u00e4ne","subscriber":"Abonnentinnen","subscription":{"active_until":"Aktiv bis","active_until_unlimited":"Aktiv bis Unbegrenzt","amount":"H\u00f6he","buy_now":"Kaufe jetzt","buy_product":"Produkt kaufen","cancel_subscription":"Abonnement k\u00fcndigen","choose_plan":"W\u00e4hlen Sie einen Plan","current_expire":"Aktuell abgelaufener Plan","current_plan":"Derzeitiger Plan","currently_active":"Im Moment aktiv","end_date":"Endtermin","end_date_required":"Das Feld \u201eEnddatum\u201c ist erforderlich","expired":"Plan ist bereits abgelaufen am","expired_date":"Ablaufdatum","free":"Kostenlos","has_already_been_subscribed":"ist bereits abonniert","has_been_subscribed":"wurde abonniert","history":"Abonnementverlauf","manage_subscription":"Abonnement verwalten","no_plan_available":"Kein Plan verf\u00fcgbar","pay_or_switch_plan":"Bezahlen \/ Plan wechseln","payable_amount":"Bezahlbarer Betrag","payment":"Zahlung","plan_name":"Planname","plan_price":"Planpreis","proceed_to_payment":"Weiter zur Zahlung","purchase":"Kaufen","remaining":"Verbleibend","remaining_balance":"Restbetrag","remaining_days":"Verbleibende Tage","renew_free_plan":"Der kostenlose Plan kann nicht verl\u00e4ngert\/erneut gew\u00e4hlt werden","renew_plan":"Plan erneuern","start_date":"Startdatum","subscribed_date":"Abonniertes Datum","subscribed_plan_details":"Details zum abonnierten Plan","switch_plan":"Plan wechseln","total_days":"Die Summe an Tagen","trial_plan":"Versuchsplan","upgrade_plan":"Upgrade-Plan","used_balance":"Gebrauchtes Guthaben","used_days":"Gebrauchte Tage"},"subscriptions":"Abonnements","testimonial":"Referenzen","to_time":"zur Zeit","tooltip":{"about_description":"Maximal 500 Zeichen erlaubt","about_title":"Maximal 100 Zeichen erlaubt","allowed_image":"Erlaubte Dateitypen: png, jpg, jpeg.","app_logo":"Das Bild muss Pixel 90 x 60 haben","banner_title":"Maximal 34 Zeichen erlaubt","cancel_app_logo":"App-Logo abbrechen","cancel_cover":"Abdeckung k\u00fcndigen","cancel_favicon_logo":"Favicon abbrechen","cancel_image":"Bild abbrechen","cancel_profile":"Profil k\u00fcndigen","change_app_logo":"App-Logo \u00e4ndern","change_favicon_logo":"Favicon \u00e4ndern","change_icon":"Icon \u00e4ndern","copy":"In die Zwischenablage kopieren","cover":"Abdeckung \u00e4ndern","custom_css":"Aktivieren Sie die M\u00f6glichkeit, benutzerdefiniertes CSS f\u00fcr jede VCard hinzuzuf\u00fcgen.","custom_fonts":"Aktivieren Sie die M\u00f6glichkeit, benutzerdefinierte Schriftarten f\u00fcr jede VCard hinzuzuf\u00fcgen.","custom_js":"Aktivieren Sie die M\u00f6glichkeit, benutzerdefinierte js f\u00fcr jede VCard hinzuzuf\u00fcgen.","dark_mode":"Wechseln Sie in den dunklen Modus","enable_affiliation":"Wenn Sie dies aktivieren, wird der Zugeh\u00f6rigkeitslink f\u00fcr alle Ihre VCards sichtbar","enable_contact":"Wenn Sie dies aktivieren, werden die Kontaktdaten auf allen Ihren Vcards sichtbar sein ","favicon_logo":"Das Bild muss 16 x 16 Pixel gro\u00df sein","hide_branding":"Aktivieren Sie die M\u00f6glichkeit, das Branding vor den VCards auszublenden.","hide_stickybar":"Wenn Sie dies aktivieren, werden die Vcards Sticky Buttons auf allen Ihren Vcards ausgeblendet","home_image":"Die beste Aufl\u00f6sung f\u00fcr dieses Profil ist","image":"Bild \u00e4ndern","light_mode":"Wechseln Sie in den Light-Modus","password_protection":"Aktivieren Sie den Zugriff auf passwortgesch\u00fctzte VCards.","product_image":"Die beste Aufl\u00f6sung f\u00fcr dieses Profil ist 250 x 250","profile":"Profil \u00e4ndern","remove_branding":"Wenn aktiviert, zeigt die vcard nicht das Branding unserer Website.","script":"F\u00fcgen Sie benutzerdefinierten JS-Code ohne Skript-Tag hinzu","sub_text":"Maximal 60 Zeichen erlaubt","the_main_url":"Die Haupt-URL, von der aus auf Ihre vcard zugegriffen werden kann.","whatsapp_share":"Wenn Sie dies aktivieren, wird die WhatsApp-Share-Schaltfl\u00e4che auf allen Ihren VCards sichtbar"},"translation_manager":"\u00dcbersetzungsmanager","type_in_script":"Geben Sie js-Code in das Tag <script><\/script> ein","user":{"account":"Konto","account_setting":"Account Einstellungen","add_admin":"Administrator hinzuf\u00fcgen","add_user":"Benutzer hinzuf\u00fcgen","admin_details":"Admin-Details","avatar":"Benutzerbild","change_language":"Sprache \u00e4ndern","change_password":"Kennwort \u00e4ndern","confirm_password":"Kennwort best\u00e4tigen","contact_no":"Kontakt Nr","contact_number":"Kontakt Nummer","current_password":"Jetziges Passwort","edit_user":"Benutzer bearbeiten","email":"Email","email_verified":"Email \u00fcberpr\u00fcft","female":"Weiblich","first_name":"Vorname","full_name":"Vollst\u00e4ndiger Name","impersonate":"Imitieren","last_name":"Nachname","location":"Ort","male":"M\u00e4nnlich","new_password":"Neues Passwort","overview":"\u00dcberblick","password":"Passwort","phone":"Telefon","profile":"Profil","profile_details":"Profildetails","registered_date":"Eingetragenes Datum","return_to_admin":"Kehren Sie zu Admin zur\u00fcck","save_changes":"\u00c4nderungen speichern","setting":"Einstellung","theme_change":"\u00c4ndern des Themenmodus","user_details":"Nutzerdetails","your_message":"Deine Nachricht","your_name":"Dein Name"},"users":"Benutzer","vcard":{"add_blog":"Blog hinzuf\u00fcgen","add_gallery":"Galerie hinzuf\u00fcgen","add_google_analytics":"F\u00fcgen Sie Google Analytics-Code ohne <script>-Tag hinzu","add_product":"Produkt hinzuf\u00fcgen","add_service":"Dienst hinzuf\u00fcgen","add_testimonial":"Erfahrungsbericht hinzuf\u00fcgen","advanced":"Fortschrittlich","affiliate_user":"Affiliate-Benutzer","alter_email_address":"Alternative E-Mail-Adresse","alter_mobile_number":"Alternative Mobiltelefon Nummer","alternate_email":"Alternative E-mail","alternative_phone":"Alternatives Telefon","appointments":"Termine","back_color":"Hintergrundfarbe","basic_details":"Grundlegende Details","blog_details":"Blog-Details","blog_icon":"Blog-Symbol","blogs":"Blogs","buisness_hours":"\u00d6FFNUNGSZEITEN","business_hours":"\u00d6ffnungszeiten","company":"Begleitung","contact":"Kontakt","copy_referral_link":"Empfehlungslink kopieren","cover_image":"Titelbild","created_at":"Hergestellt in","created_on":"Erstellt am","custom_css":"Benutzerdefinierte CSS","custom_fonts":"Schriftarten","custom_js":"Benutzerdefiniertes JS","date_of_birth":"Geburtsdatum","description":"Beschreibung","display_share_button":"Share-Button anzeigen","dob":"Geburtsdatum","download_my_qr_code":"QR-Code herunterladen","download_vcard":"VCard herunterladen","duplicate_vcard":"Vcard duplizieren!","edit_blog":"Blog bearbeiten","edit_gallery":"Galerie bearbeiten","edit_product":"Produkt bearbeiten","edit_service":"Dienst bearbeiten","edit_testimonial":"Testimonial bearbeiten","edit_vcard":"VCard bearbeiten","email_address":"E-Mail-Addresse","enable_download_qr_code":"QR-Code herunterladen aktivieren","enable_enquiry_form":"Anfrageformular aktivieren","enter_password":"Passwort eingeben","first_name":"Vorname","flag":"Flagge","galleries":"Galerien","gallery":"Galerie","google_analytics":"Google Analytics","google_config":"Google-Konfiguration","header":"Header","home_title":"Startseite Titel","image":"Bild","is_manual_payment":"Ist Handbuch zur manuellen Zahlung aktiviert","job_title":"Berufsbezeichnung","language_enable":"Sprache aktivieren","last_name":"Nachname","last_updated":"Zuletzt aktualisiert","location":"Ort","manage-section":"Abschnitt verwalten","manual_payment_guide":"Manueller Zahlungsleitfaden","map":"Karte","meta_description":"Meta-Beschreibung","meta_keyword":"Meta-Schl\u00fcsselwort","mobile_number":"Handy Nummer","new_blog":"Neuer Blog","new_gallery":"Neue Galerie","new_product":"Neues Produkt","new_service":"Neuer Dienst","new_testimonial":"Neues Zeugnis","new_vcard":"Neue VCard","occupation":"Beruf","order_at":"Bestellt bei","our_service":"Unsere Dienstleistungen","payment_config":"Zahlungskonfiguration","preview_url":"Vorschau-URL","privacy_policy":"Datenschutz-Bestimmungen","product":"Produkt","product_details":"Produktdetails","product_icon":"Produktsymbol","product_name":"Produktname","product_transection":"Produkttransaktionen","products":"Produkte","profile_image":"Profilbild","qr_code":"QR Code","qr_code_download_size":"Gr\u00f6\u00dfe des QR-Code-Downloads","qrcode-customize":"Passen Sie den QR-Code an","qrcode_color":"QR-Code-Farbe","qrcode_customize":"Passen Sie den QR-Code an","qrcode_eye_style":"W\u00e4hlen Sie Augenstil","qrcode_style":"W\u00e4hlen Sie Stil aus","remove_branding":"Branding entfernen","select_template":"Vorlage ausw\u00e4hlen","send_message":"Nachricht senden","seo":"Suchmaschinenoptimierung","service_details":"Servicedetails","service_icon":"Service-Symbol","services":"Dienstleistungen","share":"Teilen","share_my_vcard":"Meine VCard teilen","show_qr_code":"QR-Code anzeigen","site_title":"Seitentitel","social_links":"Soziale Verbindungen","stats":"Statistiken","status":"Status","template":"VCard-Vorlagen","templates":"VCard-Vorlagen","term-condition":"Terms & Bedingungen","term-policy":"Bedingungen & Richtlinien","term_condition":"erms & Bedingungen","term_policy":"Bedingungen & Richtlinien","testimonial":"Zeugnis","testimonial_details":"Testimonial-Details","testimonials":"Referenzen","theme_config":"Theme-Konfiguration","url_alias":"Alias-URL","user":"Benutzer","user_name":"Nutzername","vcard":"V-Karte","vcard_details":"VCard-Details","vcard_is_active":"Vcard ist aktiv","vcard_name":"VCard-Name","vcard_service":"VCard-Service"},"vcard_11":{"Latest_post":"Neueste Beitr\u00e4ge","contact_detail":"Kontaktdetails","get_in_touch":"In Kontakt kommen","my_email":"Meine E-Mail","my_phones":"Meine Telefone","provide_service":"Erbringung von Dienstleistungen","read_more":"Weiterlesen"},"vcards":"Visitenkarten","vcards_template":{"image":"Bild","used_count":"Gebrauchte Anzahl"},"vcards_templates":"VCards-Vorlagen","virtual_backgrounds":"Virtuelle Hintergr\u00fcnde","wait_for_apporove_of_cash_payment_by_admin":"Ihre manuelle Transaktionsanforderung steht aus.","weekdays":{"fri":"FR","mon":"MO","sat":"Sa","sun":"SONNE","thu":"DO","tue":"DI","wed":"HEIRATEN"},"your":"Dein"},"de.pagination":{"next":"Weiter &raquo;","previous":"&laquo; Vorherige"},"de.passwords":{"reset":"Dein Passwort wurde zur\u00fcck gesetzt!","sent":"Wir haben Ihren Link zum Zur\u00fccksetzen des Passworts per E-Mail gesendet!","throttled":"Bitte warten Sie, bevor Sie es erneut versuchen.","token":"Dieses Token zum Zur\u00fccksetzen des Passworts ist ung\u00fcltig.","user":"Wir k\u00f6nnen keinen Benutzer mit dieser E-Mail-Adresse finden."},"de.validation":{"accepted":"Der :attribute must be accepted.","active_url":"Der :attribute ist keine g\u00fcltige URL.","after":"Der :attribute muss ein Datum nach :date sein.","after_or_equal":"Der :attribute muss ein Datum nach oder gleich :date sein.","alpha":"Der :attributedarf nur Buchstaben enthalten.","alpha_dash":"Der :attribute d\u00fcrfen nur Buchstaben, Ziffern, Bindestriche und Unterstriche enthalten.","alpha_num":"Der :attribute darf nur Buchstaben und Zahlen enthalten.","array":"Der :attribute muss ein Array sein.","attributes":{"email":"E-Mail","message":"Nachricht","name":"Name","phone":"Telefon","service_url":"Service URL"},"before":"Der :attribute muss ein Datum vor :date sein.","before_or_equal":"Der :attribute must be a date before or equal to :date.","between":{"array":"Der :attribute muss zwischen :min und :max Elemente enthalten.","file":"Der :attribute muss zwischen :min und :max Kilobyte liegen.","numeric":"Der :attribute muss zwischen :min und :max liegen.","string":"Der :attribute muss zwischen :min und :max Zeichen liegen."},"boolean":"Der :attribute Feld muss wahr oder falsch sein.","confirmed":"Der :attribute Best\u00e4tigung stimmt nicht \u00fcberein.","coupon_code":{"expired":"Dieser Gutscheincode ist abgelaufen","not_found":"Gutscheincode nicht gefunden"},"current_password":"Das Passwort ist inkorrekt.","custom":{"attribute-name":{"rule-name":"benutzerdefinierte Nachrichte"}},"date":"Der :attribute ist kein g\u00fcltiges Datum.","date_equals":"Der :attribute muss ein Datum gleich :date sein.","date_format":"Der :attribute passt nicht zum Format :format.","different":"Der :attribute und :other muss anders sein.","digits":"Der :attribute muss sein: Ziffern Ziffern.","digits_between":"Der :attribute muss zwischen :min und :max Ziffern liegen.","dimensions":"Der :attribute has invalid image dimensions.","distinct":"Der :attribute Feld hat einen doppelten Wert.","email":"Der :attribute muss eine g\u00fcltige E-Mail-Adresse sein.","ends_with":"Der :attribute muss mit einem der folgenden enden: :values.","exists":"Der ausgew\u00e4hlt :attribute ist ung\u00fcltig.","file":"Der :attribute muss eine Datei sein.","filled":"Der :attribute Feld muss einen Wert haben.","gt":{"array":"Der :attribute muss mehr als :value-Elemente haben.","file":"Der :attribute muss gr\u00f6\u00dfer als :value Kilobyte sein.","numeric":"Der :attribute muss gr\u00f6\u00dfer als :value sein.","string":"Der :attribute muss gr\u00f6\u00dfer als :value Zeichen sein."},"gte":{"array":"Der :attribute Muss haben: Wertgegenst\u00e4nde oder mehr.","file":"Der :attribute muss gr\u00f6\u00dfer oder gleich :value Kilobyte sein.","numeric":"Der :attribute muss gr\u00f6\u00dfer oder gleich :value sein.","string":"Der :attribute muss gr\u00f6\u00dfer oder gleich :value Zeichen sein."},"image":"Der :attribute muss ein Bild sein.","in":"Der ausgew\u00e4hlt :attribute ist ung\u00fcltig.","in_array":"Der :attribute Feld existiert nicht in :other.","integer":"Der :attribute muss eine ganze Zahl sein.","ip":"Der :attribute muss eine g\u00fcltige IP-Adresse sein.","ipv4":"Der :attribute muss eine g\u00fcltige IPv4-Adresse sein.","ipv6":"Der :attribute muss eine g\u00fcltige IPv6-Adresse sein.","json":"Der :attribute muss eine g\u00fcltige JSON-Zeichenfolge sein.","lt":{"array":"Der :attribute muss weniger als :value Elemente haben.","file":"Der :attribute muss kleiner als :value Kilobyte sein.","numeric":"Der :attribute muss kleiner als :value sein.","string":"Der :attribute muss weniger als :value Zeichen sein."},"lte":{"array":"Der :attribute darf nicht mehr als :value-Elemente haben.","file":"Der :attribute muss kleiner oder gleich :value Kilobyte sein.","numeric":"Der :attribute muss kleiner oder gleich :value sein.","string":"Der :attribute muss kleiner oder gleich :value Zeichen sein."},"max":{"array":"Der :attribute darf nicht mehr als :max Elemente enthalten.","file":"Der :attribute darf nicht gr\u00f6\u00dfer als :max Kilobyte sein.","numeric":"Der :attribute darf nicht gr\u00f6\u00dfer als :max sein.","string":"Der :attribute darf nicht gr\u00f6\u00dfer als :max Zeichen sein."},"mimes":"Der :attribute muss eine Datei vom Typ sein: :Werte.","mimetypes":"Der :attribute muss eine Datei vom Typ sein: :Werte.","min":{"array":"Der :attribute muss mindestens :min Elemente haben.","file":"Der :attribute muss mindestens :min Kilobyte sein.","numeric":"Der :attribute muss mindestens :min.","string":"Der :attribute muss mindestens :min Zeichen lang sein."},"multiple_of":"Der :attribute muss ein Vielfaches von :value sein.","not_in":"Der ausgew\u00e4hlt :attribute ist ung\u00fcltig.","not_regex":"Der :attribute Format ist ung\u00fcltig.","numeric":"Der :attribute muss eine Nummer sein.","password":"Das Passwort ist inkorrekt.","present":"Der :attribute Feld muss vorhanden sein.","prohibited":"Der :attribute Feld ist verboten.","prohibited_if":"Der :attribute Feld ist verboten, wenn :other :value ist.","prohibited_unless":"Der :attribute -Feld ist verboten, es sei denn, :other ist in :values enthalten.","regex":"Der :attribute Format ist ung\u00fcltig.","required":"Der :attribute Feld ist erforderlich.","required_if":"Der :attribute Feld ist erforderlich, wenn :other :value ist.","required_unless":"Der :attribute Feld ist erforderlich, es sei denn :other steht in :values.","required_with":"Der :attribute Feld ist erforderlich, wenn :values vorhanden ist.","required_with_all":"Der :attribute Feld ist erforderlich, wenn :values vorhanden sind.","required_without":"Der :attribute Feld ist erforderlich, wenn :values nicht vorhanden ist.","required_without_all":"Der :attribute Das Feld ist erforderlich, wenn keiner der :Werte vorhanden ist.","same":"Der :attribute und :other m\u00fcssen \u00fcbereinstimmen.","size":{"array":"Der :attribute muss enthalten: Gr\u00f6\u00dfe Artikel.","file":"Der :attribute muss :size Kilobyte sein.","numeric":"Der :attribute muss sein: gr\u00f6\u00dfe.","string":"Der :attribute muss :size Zeichen sein."},"starts_with":"Der :attribute muss mit einem der folgenden Werte beginnen: :values.","string":"Der :attribute muss eine Zeichenfolge sein.","timezone":"Der :attribute muss eine g\u00fcltige Zeitzone seine.","unique":"Der :attribute wurde bereits \u00fcbernommen.","uploaded":"Der :attribute konnte nicht hochgeladen werden.","url":"Der :attribute muss eine g\u00fcltige URL sein.","uuid":"Der :attribute muss eine g\u00fcltige UUID sein."},"el.cookie-consent::texts":{"agree":"\u0391\u03c0\u03bf\u03b4\u03bf\u03c7\u03ae","message":"\u0397 \u03b9\u03c3\u03c4\u03bf\u03c3\u03b5\u03bb\u03af\u03b4\u03b1 \u03bc\u03b1\u03c2 \u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03b9\u03b5\u03af cookies \u03b3\u03b9\u03b1 \u03bd\u03b1 \u03b2\u03b5\u03bb\u03c4\u03b9\u03ce\u03c3\u03b5\u03b9 \u03c4\u03b7\u03bd \u03b5\u03bc\u03c0\u03b5\u03b9\u03c1\u03af\u03b1 \u03c0\u03b5\u03c1\u03b9\u03ae\u03b3\u03b7\u03c3\u03ae\u03c2 \u03c3\u03b1\u03c2."},"el.cookieConsent::texts":{"agree":"\u0391\u03c0\u03bf\u03b4\u03bf\u03c7\u03ae","message":"\u0397 \u03b9\u03c3\u03c4\u03bf\u03c3\u03b5\u03bb\u03af\u03b4\u03b1 \u03bc\u03b1\u03c2 \u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03b9\u03b5\u03af cookies \u03b3\u03b9\u03b1 \u03bd\u03b1 \u03b2\u03b5\u03bb\u03c4\u03b9\u03ce\u03c3\u03b5\u03b9 \u03c4\u03b7\u03bd \u03b5\u03bc\u03c0\u03b5\u03b9\u03c1\u03af\u03b1 \u03c0\u03b5\u03c1\u03b9\u03ae\u03b3\u03b7\u03c3\u03ae\u03c2 \u03c3\u03b1\u03c2."},"en.auth":{"about":"About","account_deactivate":"Your account is currently inactive, Please contact to administrator.","app":{"create":"Create","export":"Export","lock_account":"Lock Account","member_since":"Member since","messages":"Messages","online":"Online","print":"Print","profile":"Profile","reload":"Reload","reset":"Reset","search":"Search","settings":"Settings"},"choose_a_plan_that's_right_for_you":"Choose a plan that's right for you","confirm_password":"Confirm Password","contact":"Contact","copyright_by":"Copyright by","email":"Email","email_verify":"Please verify your email before login.","emails":{"password":{"reset_link":"Click here to reset your password"}},"failed":"These credentials do not match our records.","features":"Features","forgot_password":{"send_pwd_reset":"Send Password Reset Link","title":"Enter Email to reset password"},"full_name":"Full Name","get_started":"Get Started","home":"Home","let's_hear_what_they_say":"Let's Hear What They Say","login":{"forgot_password":"I forgot my password","register_membership":"Register a new membership","title":"Sign in to start your session"},"modern_&_powerful_interface":"Modern & Powerful Interface","password":"Password","pricing":"Pricing","register":"Register","registration":{"have_membership":"I already have a membership","i_agree":"I agree to","terms":"the terms","title":"Register a new membership"},"remember_me":"Remember Me","reset_password":{"reset_pwd_btn":"Reset Password","title":"Reset your password"},"sign_in":"Sign In","sign_out":"Sign out","sign_up":"Sign Up","stories_from_our_customers":"Stories From Our Customers","subscribe_here":"Subscribe here","throttle":"Too many login attempts. Please try again in :seconds seconds."},"en.cookie-consent::texts":{"agree":"Allow cookies","message":"Your experience on this site will be improved by allowing cookies."},"en.cookieConsent::texts":{"agree":"Allow cookies","message":"Your experience on this site will be improved by allowing cookies."},"en.crud":{"action":"Action","add_new":"Add New","are_you_sure":"Are you sure?","back":"Back","cancel":"Cancel","created_at":"Created At","deleted_at":"Deleted At","detail":"Detail","edit":"Edit","id":"Id","save":"Save","updated_at":"Updated At"},"en.livewire-tables::strings":{"All":"All","Applied Filters":"Applied Filters","Applied Sorting":"Applied Sorting","Bulk Actions":"Bulk Actions","Clear":"Clear","Columns":"Columns","Done Reordering":"Done Reordering","Filters":"Filters","No items found. Try to broaden your search.":"No items found. Try to broaden your search.","Remove filter option":"Remove filter option","Remove sort option":"Remove sort option","Reorder":"Reorder","Search":"Search","Select All":"Select All","Show":"Show","Showing":"Showing","Unselect All":"Unselect All","You are currently selecting all":"You are currently selecting all","You are not connected to the internet.":"You are not connected to the internet.","You have selected":"You have selected","of":"of","results":"results","rows":"rows","rows, do you want to select all":"rows, do you want to select all","to":"to"},"en.messages":{"Business_Beacon":"Business Beacon vCard","CEO\/CXO":"Corporate CEOs\/CXOs vCard","Clean_Canvas":"Clean Canvas vCard","Corporate_Classic":"Corporate Classic vCard","Corporate_Connect":"Corporate Connect vCard","Corporate_Identity":"Corporate Identity vCard","Culinary_Food_Services":"Culinary and Food Services vCard","Event_Management":"Event Management vCard","Executive_Profile":"Executive Profile vCard","Fashion_Beauty":"Fashion and Beauty vCard","Gym":"Gym vCard","Hospital":"Hospital vCard","Lawyer":"Lawyer vCard","Manually":"Manually","Modern_Edge":"Modern Edge vCard","Paypal":"Paypal","Portfolio":"Portfolio vCard","Pro_Network":"Pro Network vCard","Professional":"Professional vCard","Programmer":"Programmer vCard","Razorpay":"Razorpay","Receive_latest_news_update_and_many_other_things_every_week":"Receive latest news, update, and many other things every week.","Salon":"Salon vCard","Simple_Contact":"Simple Contact vCard","Social_Media":"Social Media Influencers vCard","Stripe":"Stripe","Subscribe_Our_Newsletter":"Subscribe Our Newsletter","about_us":{"about_us":"About Us","description":"Description","image":"About Image","title":"Title"},"admin":{"add_admin":"Add Admin","admin":"Admin","admin_created_successfully":"Admin Created Successfully.","admin_details":"Admin Details","admin_updated_successfully":"Admin Updated Successfully.","avatar":"Avatar","confirm_password":"Confirm Password","contact_number":"Contact Number","edit_admin":"Edit Admin","email":"Email","female":"Female","first_name":"First Name","full_name":"Full Name","gender":"Gender","last_name":"Last Name","male":"Male","password":"Password","profile":"Profile","profile_details":"Profile Details"},"admins":"Admins","affiliation":{"affiliate_note":"Note: Your affiliate links will be displayed at the bottom of your vCards page. When someone registers through your link and then purchases a subscription, you will be rewarded with","affiliated_by":"Affiliated By","affiliation_transaction":"Affiliation Transactions","affiliation_withdraw_detail":"Affiliation Withdraw Details","affiliations":"Affiliations","approval_status":"Approval Status","approve":"Approve","approve_withdraw_request":"Approve Withdraw Request","approved":"Approved","cash_payment":"Cash Payment","current_amount":"Current Amount","reject":"Reject","reject_withdraw_request":"Reject Withdraw Request","rejected":"Rejected","rejection_note":"Rejection Note","total_affiliation_amount":"Total Affiliation Amount","verify_paypal_email":"Verify Paypal Email","withdraw_amount":"Withdraw Amount","withdrawal":"Withdrawal"},"allowed_file_types":"Allowed file types: png, jpg, jpeg.","analytic":{"vcard_analytic":"Vcard Analytic"},"analytics":{"browsers":"Browsers","countries":"Countries","devices":"Devices","languages":"Languages","os":"Operating Systems","overview":"Overview","see_all":"See All","view_more":"View More","visitors":"Visitors"},"appointment":{"appointment":"Appointment","appointment_details":"Appointment Details","appointment_type":"Appointment Type :","calendar":"Calendar","ends":"Appointment Ends","free":"Free","paid":"Paid","starts":"Appointment Starts"},"appointments":"Appointments","business":{"business_hours":"Business Hours","end_time":"End Time","fri":"Friday","mon":"Monday","sat":"Saturday","start_time":"Start Time","sun":"Sunday","thu":"Thursday","tue":"Tuesday","wed":"Wednesday"},"by_signing_up_you_agree_to_our":"By signing up you agree to our","cash_payment":"Cash Payments","city":{"cities":"Cities","city":"City","city_name":"City Name","edit_city":"Edit City","new_city":"New City","no_city_available":"No City Available","no_city_found":"No City Found","state_name":"State Name"},"common":{"Yes_Change":"Yes, Approve","action":"Action","active":"Active","add":"Add","add_virtual_background":"Add Virtual Background","allow_cookies":"Allow cookies","already_have_an_account":"Already have an account","apply":"Apply","apply_changes":"Apply this Changes","are_you_completed":"Are you sure, you want to approve this ?","are_you_sure":"Are you sure want to delete this","are_you_sure_dublicate_vcard":"Are you sure want to create duplicate  this VCard ?","back":"Back","back_subscription":"Back to Subscriptions","cancel":"Cancel","captcha_enable":"Enable Google Captcha","closed":"Closed","completed":"Completed","cookie_banner_enabled":"Cookie Banner Enable","cookie_msg":"Your experience on this site will be improved by allowing cookies.","create_an_account":"Create an Account","currency_position":"Currency Position","custom":"Custom","declined":"Decline","default_country_code":"Default Country Code","delete":"Delete","deleted":"Deleted","description":"Description","details":"Details","discard":"Discard","download":"Download","duplicate":"Duplicate !","duplicate_vcard_create":"Duplicate Vcard created successfully","edit":"Edit","email":"Email","enable_cookie_banner":"Enable Cookie Banner","enable_page":"Enable Landing Page","enable_register":"Enable Registration","enable_validation":"Enable validation","enquiry":"Enquiries","error":"Error","filter":"Filter","forgot_password":"Forgot Password","forgot_your_password":"Forgot your password","from":"From","has_been_completed":"has been completed.","has_been_deleted":"has been deleted.","icon":"Icon","inactive":"Inactive","infyvcard":"InfyVcard","is_active":"Is Active","link":"Link","loading":"Loading...","login":"Login","logout":"Logout","message":"Message","name":"Name","new_here":"New Here","no":"No, Cancel","no_data_available":"No Data Available","notUsed":"Not used yet","ok":"Ok","payment_methods":"Payment Method","paypal_email":"Paypal Email","pending":"Pending","phone":"Phone","phone_validation":"Phone Number validation","please_wait":"Please wait...","price":"Price","product_url":"Product URL","register":"Register","register_enable":"Registration Enable","remember_me":"Remember me","reset":"Reset","save":"Save","selected":"Selected","service_url":"Service URL","show_currency_behind":"Show Currency Behind","sign_in_here":"Sign in here","status":"Status","sub_text":"Sub Text","subject":"Subject","submit":"Submit","successful":"Successful","this_week":"The Week","title":"Title","to":"To","today":"Today","today_appointments":"Today Appointments","today_enquiry":"Today Enquiries","total__active_vcards":"Total Active VCards","total__deactive_vcards":"Total Deactivated VCards","total_active_users":"Total Active Users","total_amount":"Total Amount","total_deactive_users":"Total DeActive Users","total_plans":"Total Plans","total_users":"Total Users","total_vcards":"Total VCards","type":"Type","unavailable":"Unavailable","upload_file":"Upload File","user":"User","view":"View","virtual_note":"Note : Virtual Backgrounds will give you the business card images in which your logo, name, address, and phone will be written. we are exporting standard sizes of horizontal and vertical virtual backgrounds, which will be useful when you want to design your NFC card, you can directly give these images to NFC printing handlers. Also, you can share this with your friends too directly or set it as a profile\/cover image.","yes":"Yes, Delete!","yes_duplicate":"Yes Duplicate!"},"completed":"Completed","contact_us":{"contact":"Contact","contact_us":"Enquiries","inquries":"Inquiries","message":"Message","send_message":"Send Message"},"copy_text":"Copy","country":{"countries":"Countries","country":"Country","country_name":"Country Name","edit_country":"Edit Country","new_country":"New Country","no_country_available":"No Country Available","no_country_found":"No Country Found","phone_code":"Phone Code","short_code":"Short Code"},"coupon_code":{"add_coupon_code":"Add Coupon Code","apply_here":"Apply here","coupon_code":"Coupon Codes","coupon_code_applied":"Coupon Code applied Successfully.","coupon_code_created":"Coupon Code created successfully.","coupon_code_percent_validation":"Coupon discount should not be more than 100%.","coupon_code_status_updated":"Coupon Code status updated successfully.","coupon_code_updated":"Coupon Code updated successfully.","coupon_codes":"Coupon Codes","coupon_discount":"Coupon Discount","coupon_name":"Coupon Name","coupon_type":"Coupon Type","edit_coupon_code":"Edit Coupon Code","enter_coupon_code":"Enter Coupon Code","enter_coupon_discount":"Enter Coupon Discount","enter_coupon_name":"Enter Coupon Name","expire_at":"Expire At","fixed":"Fixed Type","flat":"Flat","have_a_coupon_code":"Have a Coupon Code?","percentage":"Percentage","remove":"Remove"},"create_vcard":"Create Your VCard","create_your_business_digital_card_with_lots_of_information":"Create your business digital card with lots of information","currency":{"currencies":"Currencies","currency_code":"Currency Code","currency_icon":"Currency Icon"},"dashboard":"Dashboard","date":"Date","deactivate":"Deactivate","e_card":{"add_ecard":"Add E-card","ecard":"E-card","ecard_info":"The image must be of pixel 150 x 150","ecard_logo":"E-card logo","ecards":"E-cards"},"edit_subscription":"Edit Subscription Plan","email_not_found":"We can't find a user with that email address","email_password_reset_link":"Email Password Reset Link","enquiry":"Enquiries","enquiry_detail":"Enquiry Details","expire_in":"Plan is about to expired in","extra_scripts":"Extra Scripts","feature":{"affiliation":"Affiliation","analytics":"Analytics","appointments":"Appointments","blog":"Blog","custom_css":"Custom CSS","custom_fonts":"Custom Fonts","custom_js":"Custom JS","custom_qrcode":"Custom QR Code","description":"Description","edit_feature":"Edit Feature","enquiry_form":"Enquiry Form","feature_image":"Feature Image","gallery":"Gallery","hide_branding":"Hide Branding","image":"Image","name":"Name","order_nfc_card":"Order NFC Card","password":"Password Protection","products":"Products","products_services":"Services","seo":"SEO","social_links":"Social Links","testimonials":"Testimonials"},"flash":{"about_us_create":"About Us saved successfully.","can_not_change_time_format":"Appointment is already booked for this time format.","city_create":"City saved successfully.","city_update":"City updated successfully.","country_create":"Country saved successfully.","country_update":"Country updated successfully.","country_used":"Country already in used","create_blog":"VCard blog created successfully.","create_front_testimonial":"Testimonial created successfully.","create_product":"VCard product created successfully.","create_service":"VCard service created successfully.","create_testimonial":"VCard testimonial created successfully.","current_invalid":"Current password is invalid.","database_upgrade_succesfully":"Your database upgraded successfully","decription_is_required":"The description field is required","feature_update":"Feature updated successfully.","front_cms":"Front CMS updated successfully.","language_update":"Language updated successfully.","mobile_validation":"Mobile validation updated successfully.","name_is_required":"The name field is required","password_update":"Password updated successfully.","payment_status_update":"Payment Status Updated Successfully","plan_create":"Plan created successfully.","plan_default":"Default plan changed successfully.","plan_status":"Plan status updated successfully","plan_update":"Plan updated successfully.","reactive_account":"Reactivate your account from mail.","setting_update":"Settings updated successfully.","social_links_img_is_required":"Social links Image is required.","social_links_is_required":"Social links is required.","state_create":"State saved successfully.","state_update":"State updated successfully.","state_used":"State already in used","success_theme_update":"Theme Updated Successfully","update_blog":"VCard blog updated successfully.","update_front_testimonial":"Testimonial updated successfully.","update_product":"VCard product updated successfully.","update_service":"VCard service updated successfully.","update_testimonial":"VCard testimonial updated successfully.","user_create":"User created successfully.","user_profile":"User profile updated successfully.","user_status":"User status updated successfully","user_update":"User updated successfully.","vcard_create":"VCard created successfully.","vcard_delete":"VCard deleted successfully.","vcard_retrieve":"VCard retrieved successfully","vcard_status":"VCard status updated successfully","vcard_update":"updated successfully.","verified_email":"Email verified successfully"},"font":{"font_family":"Font Family","font_size":"Font Size","font_size_in_px":"Font size in px","fonts":"Fonts","px":"px"},"form":{"DOB":"Enter Date of Birth","allowed_vcard":"Enter No of Vcards Allowed","blog":"Enter Blog Name","c_password":"Confirm Password","company":"Enter Company Name","contact":"Phone Number","css":"Enter Custom Css","description":"Enter Description of Your VCard","designation":"Enter Designation","email":"Enter Email Address","enter_email":"Enter Email","enter_name":"Enter Name","enter_phone":"Enter Phone","enter_trial":"Enter Trial Days","f_name":"Enter First Name","facebook":"Facebook URL","first_name":"First Name","google_analytics":"Google Analytics Code","home_title":"Enter Home Title","instagram":"Instagram URL","job":"Enter Job Title","js":"Enter Custom Js","l_name":"Enter Last Name","last_name":"Last Name","linkedin":"LinkedIn URL","location":"Enter Your Location","location_url":"Enter Your Location URL","mail":"Email","meta_description":"Enter Meta Description","meta_keyword":"Enter Meta Keyword","my_vcard_url":"my-vcard-page-url","occupation":"Enter Occupation","password":"Password","phone":"Enter Phone Number","pick_date":"Pick a Date","pinterest":"Pinterest URL","plan_name":"Enter Plan Name","price":"Enter Price","product":"Enter Product Name","product_url":"Enter Product URL","reddit":"Reddit URL","select_country":"Select Country","select_currency":"Select Currency","select_state":"Select State","service":"Enter Service Name","service_url":"Enter Service URL","short_description":"Enter Short Description","site_title":"Enter Site Title","testimonial":"Enter Testimonial Name","tiktok":"Tiktok URL","tumblr":"Tumblr URL","twitter":"Twitter URL","type_message":"Type a message here...","vcard_name":"Enter VCard Name","website":"WebSite URL","whatsapp":"Whatsapp URL","your_email":"Email Address","your_name":"Your Name","youtube":"Youtube URL"},"from_time":"From Time","front":{"enter_your_email":"Enter Your Email","enter_your_message":"Enter Your Message","enter_your_name":"Enter Your Name","your_email_address":"Your Email Address"},"front_cms":{"banner":"Banner Image","description":"Description","front_cms":"Front CMS","title":"Title"},"gallery":{"gallery_name":"Galleries","image":"Image","type":"Type","youtube":"Youtube"},"hour":"Hour","language":"Language","languages":{"edit_language":"Edit Language","edit_translation":"Edit Translation","iso_code":"ISO CODE","language":"Language","languages":"Languages","new_language":"New Language","translation":"Translation"},"made_by":"Made By","made_by_url":"Made By Url","mail":{"action_required":"If you did not create an account, no further action is required.","appointment_time":"Appointment Time","approved_successfully":"Your appointment approved successfully on","attachment":"Attachment","between":"between","book_appointment":"Book Appointment","book_successfully":"Your appointment booked successfully on","booked_appointment_with_you":"booked appointment with you","email":"Email:","hello":"Hello,","hello!":"Hello!","here_is_enquiry":"Here is a Enquiry Detail","messages":"Message:","name":"Name:","new_manual_payment_request":"New Manual Payment Request","new_nfc_order":"You have Recived New Nfc Order from","notes":"Notes","password_change":"Your password has been changed by the administrator","please_click":"Please click the button below to verify your email address.","please_contact_your_admin":"Please contact the administrator for getting a new password.","please_follow":"Please follow below step to paid manually.","regard":"Regards,","slot_text":"If you're having trouble clicking the \"Verify Email Address\" button, copy and paste the URL below into your web browser:","thank_you_chose":"You have selected manual payment guide","thanks_regard":"Thanks & Regards,","vcard_name":"VCard Name:","verify_email":"Verify Email Address","whoops":"Whoops!"},"make_appointment":"Make Appointment","make_appointments":"Make an Appointment","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Jul","jun":"Jun","mar":"Mar","may":"May","nov":"Nov","oct":"Oct","sep":"Sep"},"nfc":{"Add_NFC_card_photos_and_set_prices":"Add NFC card photos and set prices.","Admin_Guide":"Admin Guide : Selling NFC Cards","Browse_and_select_an_NFC_card":"Browse and select an NFC card.","Cancelled":"Cancelled","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"Choose your vCard, URL of that vCard will be written to NFC card.","Confirm_the_order_and_make_a_payment":"Confirm the order and make a payment.","Create_or_log_in_to_your_account":"Create or log in to your account.","Delivered":"Delivered","Dispatch_the_NFC_cards_to_users":"Dispatch the NFC cards to users.","How_it_works":"How it works ?","Log_in_to_the_Admin_Dashboard":"Log in to the Admin Dashboard.","Pending":"Pending","Ready To Ship":"Ready To Ship","Receive_and_enjoy_your_NFC_card":"Receive and enjoy your NFC card.","Review_user_orders":"Review user orders","Shipped":"Shipped","User_Guide":"User Guide: Buying and Customizing NFC Cards","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"Wait for the admin to write the URL and dispatch the card.","Write_the_user_provided_URL_to_NFC_cards":"Write the user-provided URL to NFC cards.","add_nfc_card":"Add NFC Card","all":"All","cancel":"Cancelled","card_can_not_deleted":"Card cannot be deleted as it's linked to customer orders.","card_type":"Card Type","company_name":"Company Name","designation":"Designation","edit_nfc_card":"Edit NFC Card","enter_address":"Enter Address","failed":"Failed","logo":"Logo","my_nfc_cards":"My NFC Cards","new_nfc_card":"New NFC Card","nfc":"NFC","nfc_card":"NFC Card","nfc_card_created_success":"NFC card Created Successfully","nfc_card_deleted_success":"NFC card Deleted Successfully","nfc_card_order_details":"NFC Card Order Details","nfc_card_orders":"NFC Card Orders","nfc_card_type":"NFC Card Type","nfc_card_types":"NFC Card Types","nfc_card_updated_success":"NFC card Updated Successfully","nfc_image":"Card Image","nfc_image_required":"The NFC Image field is required","order":"Order","order_nfc":"Order NFC","order_placed_success":"Order Placed Successfully","order_status":"Order Status","order_status_update_success":"Order Status Updated Successfully","orders":"Orders","orders_count":"Orders Count","paid":"Paid","payment_status":"Payment Status","payment_status_update_success":"Payment Status Updated Successfully","pending":"Pending","razorpay_session_success":"RazorPay Session Created Sucessfully","required_vcard":"Please Select Vcard","select_card":"Please Select Card Type","select_vcard":"Select vCard","sell_nfc_cards":"Sell NFC Cards","your_order_status_changed":"Your Order Status Changed"},"no_data":"No Data Available","no_matching_records_found":"No matching records found","notification":{"mark_all_as_read":"Mark All As Read","notifications":"Notifications","you_don`t_have_any_new_notification":"You don`t have any new notification"},"paid_amount_can't_deleted":"Paid Appointment Can't be delete","payment":{"cancelled":"CANCELLED","payment":"PAYMENT","payment_cancel":"Payment Cancel","payment_success":"Payment Success","payment_successful":"Payment Successful"},"payment_method":"Payment Method","payment_type":"Payment Type","placeholder":{"12_hour":"12 Hour","24_hour":"24 Hour","address_field":"Address Field field is required.","agree_term":"You must agreed to Terms and conditions.","all_rights_reserve":"All Rights Reserved","app_name_required":"App Name field is required","appointment_created":"Appointment created successfully.","cannot_switch_to_zero":"Cannot switch to zero plan if trial is available \/ having a paid plan which is currently active","choose_one_template":"Choose any one template","copied_successfully":"Link copied successfully.","de_active":"DeActive","default_plan_can_not_be_delete":"Default plan can not be deleted.","email_already_subscribed":"The email has already subscribed.","email_verification":"Your profile has been updated. We have sent to you a verification mail. Please verify your changed mail.","enquiry_sent":"Enquiry send successfully.","enter_valid_email":"Please enter valid Email.","enter_your_email_to_reset":"Enter your email to reset your password.","favicon_invalid":"The favicon has invalid image dimensions.","first_name_required":"First Name field is required.","forgot_your_password_no_problem":"Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.","gallery_created":"Gallery created successfully.","gallery_updated":"Gallery updated successfully.","invalid_country_code":"Invalid country code","invalid_number":"Invalid Number","lang_already_exists":"Language already exists.","language_save":"Language saved successfully.","last_name_required":"Last Name field is required.","last_week":"Last Week","login_via_facebook":"Login via Facebook","login_via_google":"Login via Google","message_sent":"Message send successfully.","multi_templates":"Multi templates is required","paid_appointment_cant_delete":"Paid Appointment Can't be delete","password_character":"The password must be at least 8 characters.","password_invalid":"Password is Invalid","password_is_correct":"Password is correct","password_must_match":"The password and password confirmation must match.","passwords":"The passwords field is required.","payment_cancel":"Your Payment is Cancelled","payment_done":"Payment successfully done.","payment_not_complete":"Payment Not Completed","payment_received":"Payment Received successfully.","paypal_created":"Paypal session created successfully.","paypal_key":"Paypal key field is required.","paypal_mode":"Paypal mode field is required.","paypal_secret":"Paypal secret field is required.","phone_number_required":"Phone Number field is required.","plan_already_used":"Plan already in used","plan_expire_notification":"Plan Expire Notification field is required.","please_add_payment_credentials":"Please add payment credentials.","privacy_policy":"The Privacy Policy is required.","product_purchase":"Product purchased successfully.","purchased_plan":"You purchase this plan successfully.","receive_latest_news":"Receive latest news, update, and many other things every week.","registered_success":"You have registered successfully, Activate your account from mail.","required_captcha":"Please Verify Captcha","role_created":"Role created successfully.","select_hour":"Please Select Date Or Hour","select_one_or_more":"Select one or more Feature is required","short_code_only_alpha":"The short code must only alphabet letters.","stripe_created":"Stripe session created successfully.","stripe_key":"Stripe key field is required.","stripe_secret":"Stripe secret field is required.","subscribed_plan":"You subscribed this plan successfully.","subscribed_plan_wait":"You subscribed this plan successfully but wait for confirmation from Admin","subscribed_successfully":"Subscribed Successfully.","subscription_date_updated":"Subscription date successfully updated.","successfully_verified":"You have successfully verified your mail, please login.","the_term_conditions":"The Terms & Conditions is required.","there_is_not_available_slot":"There is no available slots on given date","this_currency_is_not_supported":"This currency is not supported by PayPal for making payments.","this_week":"This Week","time_format":"Time Format","too_long":"Too long","too_short":"Too short","unable_to_process_payment":"Unable to process the payment at the moment. Try again later.","upload_required":"The file upload field is required.","valid_number":"Valid Number","we_could_not_fb_id":"We couldn't find email address in your Facebook account","withdrawal_request_send":"Withdrawal request Approved successfully.","your_mail_already_verified":"Your mail is already verified, please login."},"plan":{"We'll_never_share_your_email_with_anyone_else":"We'll never share your email with anyone else.","additional_domains":"Additional Domains","affiliation":"Affiliations","analytics":"Analytics","blog":"Blogs","currency":"Currency","custom_css":"Custom CSS","custom_fields":"Custom Fields","custom_js":"Custom JS","custom_qrcode":"Custom QR-Code","days":"Days","default_Plan":"Default Plan","description":"Description","domains_limit":"Domains Limit","duration":"Duration","duration_months":"Duration Months","duration_years":"Duration Years","edit_plan":"Edit Plan","email_address":"Email Address","enquiry_form":"Enquiry Form","features":"Features","frequency":"Frequency","gallery":"Gallery","hide_branding":"Hide Branding","is_trial":"Is Trial","language":"Language","make_default":"Make Default","monthly":"Monthly","months":"Months","multi_templates":"Multi Templates","new_plan":"New Plan","no_of_vcards":"No of VCards","password_protection":"Password Protection","plan":"Plan","plan_type":"Plan Type","portfolio":"Portfolio","price":"Price","products":"Products","qrcode":"QR Code","remaining_balance":"Remaining Balance of Prev. Plan","select_all_feature":"Select All Feature","select_plan":"Select Plan","sendemail":"Send Email","sendinvite":"Send Invite","seo":"SEO","services":"Services","status":"Status","testimonials":"Testimonials","total_custom_domains_limit":"Total Custom Domains Limit","trial_days":"Trial Days","unlimited":"Unlimited","valid_upto":"Valid Upto","what_s_in_startup_plan":"What's in Startup plan?","yearly":"Yearly","years":"Years"},"plan_expire":"Plan is expired. Please choose a plan to continue the service.","plan_expire_notification":"Plan Expire Notification (in Days)","plans":"Plans","product_details":"Product Order Details","product_orders":"Product Orders","resend_verification_email":"Resend Verification Email","reset_password":"Reset Password","role":{"edit_role":"Edit Role","name":"Name","new_role":"New Role","permissions":"Permissions","role_permissions":"Role Permissions","select_all_permissions":"Select All Permissions"},"roles":"Roles","sadmin_dashboard":{"contact":"Contact No","day":"Day","email":"Email","income":"Income","month":"Month","name":"Name","plans_by_users":"Plans by Users","recent_users_registration":"Recent Users Registration","registered_on":"Registered On","week":"Week"},"save":"Save","select_payment_type":"Select Payment Gateway","services":"Services","setting":{"add_contact":"Add to contact","address":"Address","affiliation_amount":"Affiliation Amount","affiliation_withdraw":"Affiliation withdraws","app_logo":"App Logo","app_name":"App Name","clinic_name":"Clinic Name","contact_information":"Contact Information","credential":"Credentials","credentials":"Credentials","currency":"Currency","currency_settings":"Currency Settings","default_currency_format":"Default Currency Format","default_language":"Default Language","disable_landing_page":"Disable Landing Page","enable_addcontact":"Enable Add to contact","enable_affiliation":"Enable Affiliation","enable_contact":"Enable Contact","favicon":"Favicon","front_page_enable":"Front Page Enable","general":"General","general_details":"General Details","hide_stickybar":"Hide vCard Sticky Bar","location_url":"Location URL","manually":"Manually","note":"Note : Uploaded icon name should be \"WeChat.png\" \/ \"Tumbler.png\" \/ \"XXX.png\", while downloading .vcf file that name will be used as label.","paypal":"Paypal","paypal_client_id":"Paypal Client Id","paypal_key":"Paypal key","paypal_mode":"Paypal Mode","paypal_payout_email":"Paypal Payout Email","paypal_secret":"Paypal Secret","postal_code":"Postal Code","prefix":"Prefix","privacy&policy":"Privacy Policy","razorpay":"Razorpay","razorpay_key":"Razorpay Key","razorpay_secret":"Razorpay Secret","select_currency":"Select Currency","setting":"Setting","shipping_address":"Shipping Address","specialities":"Specialities","stripe":"Stripe","stripe_key":"Stripe key","stripe_secret":"Stripe Secret","upgrade_database":"Upgrade Database","user_default_language":"User Default Language","whatsapp_share":"WhatsApp Share","withdraw_transactions":"Withdraw Transactions","withdrawals":"Withdrawals","wp_number":"Enter Phone No."},"settings":"Settings","sign_out":"Sign Out","social":{"Facebook":"Facebook","Instagram":"Instagram","Linkedin":"Linkedin","Pinterest":"Pinterest","Reddit":"Reddit","Share_on_email":"Share on Email","Share_on_facebook":"Share on Facebook","Share_on_linkedin":"Share on Linkedin","Share_on_pinterest":"Share on Pinterest","Share_on_reddit":"Share on Reddit","Share_on_twitter":"Share on Twitter","Share_on_whatsapp":"Share on Whatsapp","Tiktok":"Tiktok","Tumblr":"Tumblr","Twitter":"Twitter","Whatsapp":"Whatsapp","Youtube":"Youtube","map":"Map","social_links":"Social links - Website","website":"Website"},"state":{"country_name":"Country Name","edit_state":"Edit State","new_state":"New State","no_state_available":"No State Available","no_state_found":"No State Found","state":"State","state_name":"State Name","states":"States"},"subscribe":"Subscribe","subscribed_plans":"Subscribed Plans","subscribed_user":"Subscribed User Plans","subscriber":"Subscribers","subscription":{"active_until":"Active till","active_until_unlimited":"Active till Unlimited","amount":"Amount","buy_now":"Buy Now","buy_product":"Buy Product","cancel_subscription":"Cancel Subscription","choose_plan":"Choose Plan","current_expire":"Current Expired Plan","current_plan":"Current Plan","currently_active":"Currently Active","end_date":"End Date","end_date_required":"End date field is required","expired":"Plan is Already Expired on","expired_date":"Expired date","free":"Free","has_already_been_subscribed":"is already subscribed","has_been_subscribed":"has been subscribed","history":"Subscription History","manage_subscription":"Manage Subscription","no_plan_available":"No Plan Available","pay_or_switch_plan":"Pay \/ Switch Plan","payable_amount":"Payable Amount","payment":"Payment","plan_name":"Plan Name","plan_price":"Plan Price","proceed_to_payment":"Proceed to Payment","purchase":"Purchase","remaining":"Remaining","remaining_balance":"Remaining Balance","remaining_days":"Remaining Days","renew_free_plan":"Free Plan cannot be renewed\/chosen again","renew_plan":"Renew Plan","start_date":"Start Date","subscribed_date":"Subscribed Date","subscribed_plan_details":"Subscribed Plan Details","switch_plan":"Switch Plan","total_days":"Total Days","trial_plan":"Trial Plan","upgrade_plan":"Upgrade Plan","used_balance":"Used Balance","used_days":"Used Days"},"subscriptions":"Subscriptions","testimonial":"Testimonials","to_time":"To time","tooltip":{"about_description":"Maximum 500 character allowed","about_title":"Maximum 100 character allowed","allowed_image":"Allowed file types: png, jpg, jpeg.","app_logo":"The image must be of pixel 90 x 60","banner_title":"Maximum 34 character allowed","cancel_app_logo":"Cancel app logo","cancel_cover":"Cancel Cover","cancel_favicon_logo":"Cancel favicon","cancel_image":"Cancel Image","cancel_profile":"Cancel Profile","change_app_logo":"Change app logo","change_favicon_logo":"Change favicon","change_icon":"Change Icon","copy":"Copy to clipboard","cover":"Change Cover Image","custom_css":"Enable ability to add custom css for each VCard.","custom_fonts":"Enable ability to add custom fonts for each VCard.","custom_js":"Enable ability to add custom js for each VCard.","dark_mode":"Switch to Dark mode","enable_affiliation":"By enabling this, the affiliation link will be visible on all your VCards","enable_contact":"By enabling this the contact details will be visible on all your Vcards ","favicon_logo":"The image must be of pixel 16 x 16","hide_branding":"Enable ability to hide the branding from the VCards.","hide_stickybar":"By enabling this the hide Vcards Sticky Buttons on all your Vcards ","home_image":"Best resolution for this profile will be","image":"Change Image","light_mode":"Switch to Light mode","password_protection":"Enable access to password protect VCards.","product_image":"Best resolution for this profile will be 250x250","profile":"Change Profile","remove_branding":"If enabled, the vcard won't show the branding of our website.","script":"Add custom JS code without script tag","sub_text":"Maximum 60 character allowed","the_main_url":"The main URL that your vcard is going to be able accessed from.","whatsapp_share":"By enabling this, the WhatsApp Share button will be visible on all your VCards"},"translation_manager":"Translation Manager","type_in_script":"Type js code inside the  tag","user":{"account":"Account","account_setting":"Account Settings","add_admin":"Add Admin","add_user":"Add User","admin_details":"Admin Details","avatar":"Avatar","change_language":"Change Language","change_password":"Change Password","confirm_password":"Confirm Password","contact_no":"Contact No","contact_number":"Contact Number","current_password":"Current Password","edit_user":"Edit User","email":"Email","email_verified":"Email Verified","female":"Female","first_name":"First Name","full_name":"Full Name","impersonate":"Impersonate","last_name":"Last Name","location":"Location","male":"Male","new_password":"New Password","overview":"Overview","password":"Password","phone":"Phone","profile":"Profile","profile_details":"Profile Details","registered_date":"Registered Date","return_to_admin":"Return to Admin","save_changes":"Save Changes","setting":"Setting","theme_change":"Theme Mode Change","user_details":"User Details","your_message":"Your Message","your_name":"Your Name"},"users":"Users","vcard":{"add_blog":"Add Blog","add_gallery":"Add Gallery","add_google_analytics":"Add Google Analytics code without","add_product":"Add Product","add_service":"Add Service","add_testimonial":"Add Testimonial","advanced":"Advanced","affiliate_user":"Affiliate Users","alter_email_address":"Alternate E-mail address","alter_mobile_number":"Alternate Mobile Number","alternate_email":"Alternate Email","alternative_phone":"Alternate Phone","appointments":"Appointments","back_color":"Background Color","basic_details":"Basic Details","basics":"Basics","blog_details":"Blog Details","blog_icon":"Blog Icon","blogs":"Blogs","buisness_hours":"BUSINESS HOURS","business-hours":"Business Hours","business_hours":"Business Hours","company":"Company","contact":"Contact","copy_referral_link":"Copy Referral Link","cover_image":"Cover Image","created_at":"Created At","created_on":"Created on","custom-fonts":"Fonts","custom_css":"Custom CSS","custom_fonts":"Fonts","custom_js":"Custom JS","date_of_birth":"Date Of Birth","default_language":"Default Language","description":"Description","display_share_button":"Display share button","dob":"Date of Birth","download_my_qr_code":"Download My QR Code","download_vcard":"Download VCard","duplicate_vcard":"Duplicate Vcard !","ecard_logo":"E-card Logo","edit_blog":"Edit Blog","edit_gallery":"Edit Gallery","edit_product":"Edit Product","edit_service":"Edit Service","edit_testimonial":"Edit Testimonial","edit_vcard":"Edit VCard","email_address":"E-mail address","enable_download_qr_code":"Enable Download QR Code","enable_enquiry_form":"Enable Enquiry Form","enter_password":"Enter Password","first_name":"First Name","flag":"Flag","galleries":"Galleries","gallery":"Gallery","google_analytics":"Google Analytics","google_config":"Google Configuration","header":"Header","home_title":"Home Title","image":"Image","is_manual_payment":"Is Manual Payment Guide On","job_title":"Job Title","language_enable":"Language Enable","last_name":"Last Name","last_updated":"Last Updated","location":"Location","manage-section":"Manage Section","manual_payment_guide":"Manual Payment Guide","map":"Map","meta_description":"Meta Description","meta_keyword":"Meta Keyword","mobile_number":"Mobile Number","new_blog":"New Blog","new_gallery":"New Gallery","new_product":"New Product","new_service":"New Service","new_testimonial":"New Testimonial","new_vcard":"New VCard","occupation":"Occupation","order_at":"Ordered At","our_service":"Our Services","payment_config":"Payment Configuration","preview_url":"Preview URL","privacy-policy":"Privacy Policy","privacy_policy":"Privacy Policy","product":"Product","product_details":"Product Details","product_icon":"Product Icon","product_name":"Product Name","product_transection":"Product Transactions","products":"Products","profile_image":"Profile Image","qr_code":"QR Code","qr_code_download_size":"QR Code download size","qrcode-customize":"Customize QR Code","qrcode_color":"QR-Code Color","qrcode_customize":"Customize QR Code","qrcode_eye_style":"Select Eye Style","qrcode_style":"Select Style","remove_branding":"Remove branding","select_template":"Select Template","send_message":"Send Message","seo":"SEO","service_details":"Service Details","service_icon":"Service Icon","services":"Services","share":"Share","share_my_vcard":"Share My VCard","show_qr_code":"Show QR Code","site_title":"Site Title","social-links":"Social links","social_links":"Social links","stats":"Stats","status":"Status","template":"vCard Templates","templates":"vCard Templates","term-condition":"Terms & Conditions","term-policy":"Terms & Policies","term_condition":"Terms & Conditions","term_policy":"Terms & Policies","testimonial":"Testimonial","testimonial_details":"Testimonial Details","testimonials":"Testimonials","theme_config":"Theme Configuration","url_alias":"URL Alias","user":"Users","user_name":"User Name","vcard":"VCard","vcard_details":"VCard Details","vcard_is_active":"Vcard is active","vcard_name":"VCard Name","vcard_service":"VCard Service"},"vcard_11":{"Latest_post":"Latest Posts","contact_detail":"Contact Details","get_in_touch":"Get in Touch","my_email":"My Emails","my_phones":"My Phones","provide_service":"Provide Services","read_more":"Read More"},"vcards":"VCards","vcards_template":{"image":"Image","used_count":"Used Count"},"vcards_templates":"vCard Templates","virtual_backgrounds":"Virtual Backgrounds","wait_for_apporove_of_cash_payment_by_admin":"Your Manual Transaction Request Is Pending.","weekdays":{"fri":"FRI","mon":"MON","sat":"SAT","sun":"SUN","thu":"THU","tue":"TUE","wed":"WED"},"your":"Your"},"en.pagination":{"next":"Next &raquo;","previous":"&laquo; Previous"},"en.passwords":{"reset":"Your password has been reset!","sent":"We have emailed your password reset link!","throttled":"Please wait before retrying.","token":"This password reset token is invalid.","user":"We cannot find a user with that email address."},"en.validation":{"accepted":"The :attribute must be accepted.","accepted_if":"The :attribute must be accepted when :other is :value.","active_url":"The :attribute is not a valid URL.","after":"The :attribute must be a date after :date.","after_or_equal":"The :attribute must be a date after or equal to :date.","alpha":"The :attribute must only contain letters.","alpha_dash":"The :attribute must only contain letters, numbers, dashes and underscores.","alpha_num":"The :attribute must only contain letters and numbers.","array":"The :attribute must be an array.","attributes":{"email":"Email","message":"Message","name":"Name","phone":"Phone","service_url":"Service URL"},"before":"The :attribute must be a date before :date.","before_or_equal":"The :attribute must be a date before or equal to :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","coupon_code":{"expired":"This coupon code is expired","not_found":"Coupon Code not found"},"current_password":"The password is incorrect.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"The :attribute is not a valid date.","date_equals":"The :attribute must be a date equal to :date.","date_format":"The :attribute does not match the format :format.","declined":"The :attribute must be declined.","declined_if":"The :attribute must be declined when :other is :value.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","doesnt_end_with":"The :attribute may not end with one of the following: :values.","doesnt_start_with":"The :attribute may not start with one of the following: :values.","email":"The :attribute must be a valid email address.","ends_with":"The :attribute must end with one of the following: :values.","enum":"The selected :attribute is invalid.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal to :value kilobytes.","numeric":"The :attribute must be greater than or equal to :value.","string":"The :attribute must be greater than or equal to :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal to :value kilobytes.","numeric":"The :attribute must be less than or equal to :value.","string":"The :attribute must be less than or equal to :value characters."},"mac_address":"The :attribute must be a valid MAC address.","max":{"array":"The :attribute must not have more than :max items.","file":"The :attribute must not be greater than :max kilobytes.","numeric":"The :attribute must not be greater than :max.","string":"The :attribute must not be greater than :max characters."},"max_digits":"The :attribute must not have more than :max digits.","mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"min_digits":"The :attribute must have at least :min digits.","multiple_of":"The :attribute must be a multiple of :value.","not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","password":{"letters":"The :attribute must contain at least one letter.","mixed":"The :attribute must contain at least one uppercase and one lowercase letter.","numbers":"The :attribute must contain at least one number.","symbols":"The :attribute must contain at least one symbol.","uncompromised":"The given :attribute has appeared in a data leak. Please choose a different :attribute."},"present":"The :attribute field must be present.","prohibited":"The :attribute field is prohibited.","prohibited_if":"The :attribute field is prohibited when :other is :value.","prohibited_unless":"The :attribute field is prohibited unless :other is in :values.","prohibits":"The :attribute field prohibits :other from being present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_array_keys":"The :attribute field must contain entries for: :values.","required_if":"The :attribute field is required when :other is :value.","required_if_accepted":"The :attribute field is required when :other is accepted.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values are present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"starts_with":"The :attribute must start with one of the following: :values.","string":"The :attribute must be a string.","timezone":"The :attribute must be a valid timezone.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","url":"The :attribute must be a valid URL.","uuid":"The :attribute must be a valid UUID."},"eo.cookie-consent::texts":{"agree":"Akcepti kuketojn","message":"Tiu \u0109i retejo uzas kuketojn por plibonigi vian sperton."},"eo.cookieConsent::texts":{"agree":"Akcepti kuketojn","message":"Tiu \u0109i retejo uzas kuketojn por plibonigi vian sperton."},"es.auth":{"about":"Acerca de","account_deactivate":"Su cuenta est\u00e1 actualmente inactiva, comun\u00edquese con el administrador.","app":{"create":"Crear","export":"Exportar","lock_account":"Bloquear cuenta","member_since":"Miembro desde","messages":"Mensajes","online":"En l\u00ednea","print":"Impresi\u00f3n","profile":"Perfil","reload":"Recargar","reset":"Reiniciar","search":"B\u00fasqueda","settings":"Ajustes"},"choose_a_plan_that's_right_for_you":"Elija un plan adecuado para usted","confirm_password":"Confirmar contrase\u00f1a","contact":"Contacto","copyright_by":"derechos reservados por","email":"Correo electr\u00f3nico","email_verify":"Por favor, verifique su correo electr\u00f3nico antes de iniciar sesi\u00f3n.","emails":{"password":{"reset_link":"Haga clic aqu\u00ed para restablecer la contrase\u00f1a"}},"failed":"Estas credenciales no coinciden con nuestros registros.","features":"Caracter\u00edsticas","forgot_password":{"send_pwd_reset":"Enviar enlace de restablecimiento de contrase\u00f1a","title":"Ingrese el correo electr\u00f3nico para restablecer la contrase\u00f1a"},"full_name":"Nombre completo","get_started":"Empezar","home":"Casa","let's_hear_what_they_say":"Escuchemos lo que dicen","login":{"forgot_password":"Olvid\u00e9 mi contrase\u00f1a","register_membership":"Registrar una nueva membres\u00eda","title":"Inicia sesi\u00f3n para iniciar tu sesi\u00f3n"},"modern_&_powerful_interface":"Interfaz moderna y potente","password":"Contrase\u00f1a","pricing":"Precios","register":"Registrarse","registration":{"have_membership":"ya tengo una membresia","i_agree":"estoy de acuerdo con","terms":"los t\u00e9rminos","title":"Registrar una nueva membres\u00eda"},"remember_me":"Recu\u00e9rdame","reset_password":{"reset_pwd_btn":"Restablecer la contrase\u00f1a","title":"Restablecer su contrase\u00f1a"},"sign_in":"Iniciar sesi\u00f3n","sign_out":"desconectar","sign_up":"Inscribirse","stories_from_our_customers":"Historias de nuestras clientes","subscribe_here":"Suscr\u00edbete aqu\u00ed","throttle":"Demasiados intentos de inicio de sesi\u00f3n. Vuelva a intentarlo en :segundos segundos."},"es.cookie-consent::texts":{"agree":"Aceptar","message":"Su experiencia en este sitio ser\u00e1 mejorada con el uso de cookies."},"es.cookieConsent::texts":{"agree":"Aceptar","message":"Su experiencia en este sitio ser\u00e1 mejorada con el uso de cookies."},"es.crud":{"action":"Acci\u00f3n","add_new":"Agregar nuevo","are_you_sure":"Estas seguro","back":"atr\u00e1s","cancel":"Cancelar","created_at":"Creado en","deleted_at":"Eliminado en","detail":"Detail","edit":"Editar","id":"Identificaci\u00f3n","save":"Ahorrar","updated_at":"Actualizado en"},"es.livewire-tables::strings":{"All":"Todo","Applied Filters":"Filtros Aplicados","Applied Sorting":"Ordenamiento Aplicado","Bulk Actions":"Acciones Masivas","Clear":"Borrar","Columns":"Columnas","Done Reordering":"Reordenamiento finalizado","Filters":"Filtros","No items found. Try to broaden your search.":"No se encontraron elementos. Intente ampliar la b\u00fasqueda.","Remove filter option":"Remover opci\u00f3n de filtro","Remove sort option":"Remover opci\u00f3n de ordenamiento","Reorder":"Reordenar","Search":"Buscar","Select All":"Seleccionar todo","Show":"Mostrar","Showing":"Mostrando","Unselect All":"Deseleccionar todo","You are currently selecting all":"Actualmente est\u00e1 seleccionando todo","You are not connected to the internet.":"No est\u00e1 conectado a Internet.","You have selected":"Ha seleccionado","of":"de","results":"resultados","row":"fila","rows":"filas","rows, do you want to select all":"filas, desea seleccionar todas","to":"a"},"es.messages":{"Business_Beacon":"vCard de baliza empresarial","CEO\/CXO":"vCard para directores ejecutivos y CXO corporativos","Clean_Canvas":"vCard de lienzo limpio","Corporate_Classic":"vCard cl\u00e1sica corporativa","Corporate_Connect":"vCard de conexi\u00f3n corporativa","Corporate_Identity":"vCard de Identidad Corporativa","Culinary_Food_Services":"vCard para servicios culinarios y alimentarios","Event_Management":"vCard de gesti\u00f3n de eventos","Executive_Profile":"vCard de perfil ejecutivo","Fashion_Beauty":"vCard Moda y Belleza","Gym":"vCard de gimnasio","Hospital":"Tarjeta virtual hospitalaria","Lawyer":"Tarjeta vCard de abogado","Manually":"A mano","Modern_Edge":"vCard de borde moderno","Paypal":"Paypal","Portfolio":"Portafolio vCard","Pro_Network":"vCard de red profesional","Professional":"Tarjeta virtual profesional","Programmer":"Programador vCard","Razorpay":"pago de afeitar","Receive_latest_news_update_and_many_other_things_every_week":"Reciba las \u00faltimas noticias, actualizaciones y muchas otras cosas cada semana.","Salon":"Sal\u00f3n vCard","Simple_Contact":"vCard de contacto simple","Social_Media":"vCard para personas influyentes en las redes sociales","Stripe":"Raya","Subscribe_Our_Newsletter":"Suscr\u00edbete a nuestro bolet\u00edn","about_us":{"about_us":"Sobre nosotros","description":"Descripci\u00f3n","image":"Acerca de la imagen","title":"T\u00edtulo"},"admin":{"add_admin":"Agregar administrador","admin":"Administradora","admin_created_successfully":"Administrador creado con \u00e9xito.","admin_delete_successfully":"El administrador elimin\u00f3 con \u00e9xito.","admin_details":"Detalles del administrador","admin_updated_successfully":"Administrador actualizado con \u00e9xito.","avatar":"Avatar","confirm_password":"Confirmar contrase\u00f1a","contact_number":"N\u00famero de contacto","edit_admin":"Editar administrador","email":"Correo electr\u00f3nico","female":"Mujer","first_name":"Primer nombre","full_name":"Nombre completo","gender":"G\u00e9nero","last_name":"Apellido","male":"Masculino","not_allowed_to_access":"Parece que no tienes permiso para acceder a este registro.","password":"Contrase\u00f1a","profile":"Perfil","profile_details":"Detalles del perfil"},"admins":"administradores","affiliation":{"affiliate_note":"Nota: Sus enlaces de afiliado se mostrar\u00e1n en su p\u00e1gina de vcards en la parte inferior. Cuando alguien se registre a trav\u00e9s de esto y compre una suscripci\u00f3n despu\u00e9s de eso, ser\u00e1 recompensado con una cantidad de","affiliated_by":"Afiliado por","affiliation_transaction":"Transacciones de afiliaci\u00f3n","affiliation_withdraw_detail":"Detalle de Retiro de Afiliaci\u00f3n","affiliations":"Afiliaciones","approval_status":"Estado de aprobaci\u00f3n","approve":"Aprobar","approve_withdraw_request":"Aprobar solicitud de retiro","approved":"Aprobado","cash_payment":"Pagos en efectivo","current_amount":"Cantidad actual","reject":"Rechazar","reject_withdraw_request":"Rechazar solicitud de retiro","rejected":"Rechazado","rejection_note":"Nota de rechazo","total_affiliation_amount":"Cantidad Total de Afiliaci\u00f3n","verify_paypal_email":"Verificar correo electr\u00f3nico de Paypal","withdraw_amount":"Importe a retirar","withdrawal":"Retiro"},"allowed_file_types":"Tipos de archivos permitidos: png, jpg, jpeg.","analytic":{"vcard_analytic":"Anal\u00edtica de tarjeta virtual"},"analytics":{"browsers":"navegadores","countries":"Los paises","devices":"Dispositivos","languages":"Idiomas","os":"Sistemas operativos","overview":"Visi\u00f3n de conjunto","see_all":"Ver todo","view_more":"Ver m\u00e1s","visitors":"Visitantes"},"appointment":{"appointment":"Cita","appointment_details":"Detalles de la cita","appointment_type":"Tipo de cita:","calendar":"Calendario","ends":"Finaliza la cita","free":"Gratis","paid":"Pagada","starts":"Comienza la cita"},"appointments":"equipo","business":{"business_hours":"Horas de trabajo","end_time":"Hora de finalizaci\u00f3n","fri":"Vie","mon":"Lun","sat":"Se sent\u00f3","start_time":"Hora de inicio","sun":"Domingo","thu":"Recoger","tue":"mar","wed":"casarse"},"by_signing_up_you_agree_to_our":"Al registrarse, aceptas nuestra","cash_payment":"Pagos en efectivo","city":{"cities":"Ciudades","city":"Ciudad","city_name":"Nombre de la ciudad","edit_city":"Editar ciudad","new_city":"Ciudad Nueva","no_city_available":"Ninguna ciudad disponible","no_city_found":"No se encontr\u00f3 ninguna ciudad","state_name":"Nombre del Estado"},"common":{"Yes_Change":"si, cambia","action":"Acci\u00f3n","active":"Activo","add":"Agregar","add_virtual_background":"Agregar fondo virtual","allow_cookies":"Permitir cookies","already_have_an_account":"Ya tienes una cuenta","apply":"Aplicar","apply_changes":"Aplicar estos cambios","are_you_completed":"\u00bfEst\u00e1 seguro de que desea cambiar este estado?","are_you_sure":"\u00bfEst\u00e1s seguro de que quieres eliminar esto?","are_you_sure_dublicate_vcard":"\u00bfEst\u00e1 seguro de que desea crear un duplicado de esta VCard?","back":"atr\u00e1s","back_subscription":"Volver a Suscripciones","cancel":"Cancelar","captcha_enable":"Habilitar Captcha de Google","closed":"Cerrada","completed":"acabado","cookie_banner_enabled":"Habilitar banner de cookies","cookie_msg":"Su experiencia en este sitio mejorar\u00e1 al permitir las cookies.","create_an_account":"Crea una cuenta","currency_position":"Posici\u00f3n de moneda","custom":"Disfraz","declined":"Rechazar","default_country_code":"C\u00f3digo de pa\u00eds predeterminado","delete":"Borrar","deleted":"Eliminado","description":"Descripci\u00f3n","details":"Detalles","discard":"Descarte","download":"Descargar","duplicate":"Duplicada","duplicate_vcard_create":"Vcard duplicada creada exitosamente","edit":"Editar","email":"Correo electr\u00f3nico","enable_cookie_banner":"Habilitar banner de cookies","enable_page":"Habilitar p\u00e1gina de destino","enable_register":"Habilitar registro","enable_validation":"Habilitar validaci\u00f3n","enquiry":"Consultas","error":"Error","filter":"Filtrar","forgot_password":"Has olvidado tu contrase\u00f1a","forgot_your_password":"Olvidaste tu contrase\u00f1a","from":"De","has_been_completed":"se ha completado.","has_been_deleted":"ha sido eliminado.","icon":"Icono","inactive":"Inactivo","infyvcard":"InfyVcard","is_active":"Est\u00e1 activo","link":"Enlace","loading":"Cargando...","login":"Acceso","logout":"Cerrar sesi\u00f3n","message":"Mensaje","name":"Nombre","new_here":"Nuevo aqui","no":"no, cancelar","no_data_available":"Datos no disponibles","notUsed":"No usado todav\u00eda","ok":"OK","payment_methods":"M\u00e9todo de pago","paypal_email":"E-mail de Paypal","pending":"Pendiente","phone":"Tel\u00e9fono","phone_validation":"Validaci\u00f3n del n\u00famero de tel\u00e9fono","please_wait":"Espere por favor...","price":"Precio","product_url":"URL del producto","register":"Registrarse","register_enable":"Habilitar registro","remember_me":"Recu\u00e9rdame","reset":"Reiniciar","save":"Ahorrar","service_url":"URL del servicio","show_currency_behind":"Mostrar moneda detr\u00e1s","sign_in_here":"Firme aqu\u00ed","status":"Estado","sub_text":"Trasfondo","subject":"Sujeto","submit":"Entregar","successful":"Exitosa","to":"A","today":"Este Dia","today_appointments":"Citas de hoy","today_enquiry":"Consultas de hoy","total__active_vcards":"Total de tarjetas activas","total__deactive_vcards":"Total de VCards desactivadas","total_active_users":"Usuarios activos totales","total_amount":"Cantidad total","total_deactive_users":"Usuarios inactivos totales","total_plans":"Planes totales","total_users":"Total de usuarios","total_vcards":"Tarjetas virtuales totales","type":"Escribe","unavailable":"Indisponible","upload_file":"Upload File","user":"Usuaria","view":"Vista","virtual_note":"Nota: los fondos virtuales le dar\u00e1n las im\u00e1genes de la tarjeta de presentaci\u00f3n en las que se escribir\u00e1 su logotipo, nombre, direcci\u00f3n y tel\u00e9fono. estamos exportando tama\u00f1os est\u00e1ndar de fondos virtuales horizontales y verticales, que ser\u00e1n \u00fatiles cuando desee dise\u00f1ar su tarjeta NFC, puede entregar estas im\u00e1genes directamente a los controladores de impresi\u00f3n NFC. Adem\u00e1s, tambi\u00e9n puede compartir esto con sus amigos directamente o configurarlo como una imagen de perfil\/portada.","yes":"S\u00ed, Eliminar","yes_duplicate":"\u00a1S\u00ed, duplicado!"},"contact_us":{"contact":"Contacta con nosotros","contact_us":"Consultas","inquries":"Consultas","message":"Mensaje","send_message":"Enviar mensaje"},"copy_text":"Copiar","country":{"countries":"Los paises","country":"Pa\u00eds","country_name":"Nombre del pa\u00eds","edit_country":"Editar pa\u00eds","new_country":"Nuevo pa\u00eds","no_country_available":"Ning\u00fan pa\u00eds disponible","no_country_found":"Ning\u00fan pa\u00eds encontrado","phone_code":"C\u00f3digo de tel\u00e9fono","short_code":"C\u00f3digo corto"},"coupon_code":{"add_coupon_code":"A\u00f1adir c\u00f3digo de cup\u00f3n","apply_here":"Aplicar aqu\u00ed","coupon_code":"C\u00f3digo promocional","coupon_code_applied":"C\u00f3digo de cup\u00f3n aplicado correctamente.","coupon_code_created":"C\u00f3digo de cup\u00f3n creado exitosamente.","coupon_code_percent_validation":"El descuento del cup\u00f3n no debe ser superior al 100%.","coupon_code_status_updated":"El estado del c\u00f3digo de cup\u00f3n se actualiz\u00f3 correctamente.","coupon_code_updated":"C\u00f3digo de cup\u00f3n actualizado exitosamente.","coupon_codes":"C\u00f3digos de cup\u00f3n","coupon_discount":"Cup\u00f3n de descuento","coupon_name":"Nombre del cup\u00f3n","coupon_type":"Tipo de cup\u00f3n","edit_coupon_code":"Editar c\u00f3digo de cup\u00f3n","enter_coupon_code":"Introduce el c\u00f3digo de cup\u00f3n","enter_coupon_discount":"Ingresar cup\u00f3n de descuento","enter_coupon_name":"Ingrese el nombre del cup\u00f3n","expire_at":"Caducar en","fixed":"Tipo fijo","flat":"Plana","have_a_coupon_code":"Tiene un c\u00f3digo de cup\u00f3n ?","percentage":"Porcentaje","remove":"Eliminar"},"create_vcard":"Crea tu tarjeta virtual","create_your_business_digital_card_with_lots_of_information":"Crea tu tarjeta digital de empresa con mucha informaci\u00f3n","currency":{"currencies":"Monedas","currency_code":"C\u00f3digo de moneda","currency_icon":"Icono de moneda"},"dashboard":"Tableros","date":"fecha","deactivate":"Desactivar","e_card":{"add_ecard":"A\u00f1adir tarjeta electr\u00f3nica","ecard":"tarjeta electr\u00f3nica","ecard_info":"La imagen debe ser de p\u00edxel 150 x 150.","ecard_logo":"Logotipo de la tarjeta electr\u00f3nica","ecards":"Tarjetas electr\u00f3nicas"},"edit_subscription":"Editar plan de suscripci\u00f3n","email_not_found":"No podemos encontrar un usuario con esa direcci\u00f3n de correo electr\u00f3nico.","email_password_reset_link":"Enlace de restablecimiento de contrase\u00f1a de correo electr\u00f3nico","enquiry":"Consultas","enquiry_detail":"Detalles de la consulta","expire_in":"El plan est\u00e1 a punto de expirar en","extra_scripts":"Guiones adicionales","feature":{"affiliation":"Afiliaci\u00f3n","analytics":"Anal\u00edtica","appointments":"Equipo","blog":"Blog","custom_css":"CSS personalizado","custom_fonts":"Fuentes personalizadas","custom_js":"JS personalizado","custom_qrcode":"C\u00f3digo QR personalizado","description":"Descripci\u00f3n","edit_feature":"Editar caracter\u00edstica","enquiry_form":"Formulario de Consulta","feature_image":"Imagen destacada","gallery":"Galer\u00eda","hide_branding":"Ocultar marca","image":"Imagen","name":"Nombre","order_nfc_card":"Solicitar tarjeta NFC","password":"Protecci\u00f3n de contrase\u00f1a","products":"Productos","products_services":"Servicios","seo":"Optimizaci\u00f3n de motores de b\u00fasqueda","social_links":"v\u00ednculos sociales","testimonials":"Testimonios"},"features":"Caracter\u00edsticas","flash":{"about_us_create":"Sobre nosotros guardado con \u00e9xito.","can_not_change_time_format":"La cita ya est\u00e1 reservada para este formato de hora","city_create":"Ciudad guardada con \u00e9xitoy.","city_update":"Ciudad actualizada correctamente.","country_create":"Pa\u00eds guardado con \u00e9xito.","country_update":"Pa\u00eds actualizado con \u00e9xito.","country_used":"Pa\u00eds ya en uso","create_blog":"Blog de VCard creado con \u00e9xito.","create_front_testimonial":"Testimonio creado con \u00e9xito.","create_product":"Producto VCard creado con \u00e9xito.","create_service":"Servicio VCard creado con \u00e9xito.","create_testimonial":"Testimonio de VCard creado con \u00e9xito.","current_invalid":"La contrase\u00f1a actual no es v\u00e1lida.","database_upgrade_succesfully":"Su base de datos se actualiz\u00f3 exitosamente","decription_is_required":"El campo de descripci\u00f3n es obligatorio.","feature_update":"Caracter\u00edstica actualizada con \u00e9xito.","front_cms":"Front CMS actualizado con \u00e9xito.","language_update":"Idioma actualizado correctamente.","mobile_validation":"La validaci\u00f3n m\u00f3vil se actualiz\u00f3 con \u00e9xito","name_is_required":"El campo de nombre es obligatorio.","password_update":"Contrase\u00f1a actualizada exitosamente.","plan_create":"Plan creado con \u00e9xito.","plan_default":"El plan predeterminado se cambi\u00f3 con \u00e9xito.","plan_status":"Estado del plan actualizado con \u00e9xito","plan_update":"Plan actualizado correctamente.","reactive_account":"Reactiva tu cuenta desde el correo.","setting_update":"Configuraci\u00f3n actualizada con \u00e9xito.","social_links_img_is_required":"Se requiere imagen de enlaces sociales","social_links_is_required":"se requieren enlaces sociales","state_create":"Estado guardado correctamente.","state_update":"Estado actualizado correctamente.","state_used":"Estado ya en uso","success_theme_update":"Tema actualizado exitosamente","update_blog":"Blog de VCard actualizado con \u00e9xito.","update_front_testimonial":"Testimonio actualizado con \u00e9xito.","update_product":"Producto VCard actualizado con \u00e9xito.","update_service":"Servicio de VCard actualizado con \u00e9xito.","update_testimonial":"Testimonio de VCard actualizado con \u00e9xito.","user_create":"Usuario creado con \u00e9xito.","user_profile":"Perfil de usuario actualizado con \u00e9xito.","user_status":"Estado de usuario actualizado con \u00e9xito","user_update":"Usuario actualizado con \u00e9xito.","vcard_create":"VCard creado con \u00e9xito.","vcard_delete":"VCard eliminado exitosamente.","vcard_retrieve":"VCard recuperado con \u00e9xito","vcard_status":"Estado de VCard actualizado con \u00e9xito","vcard_update":"actualizado con \u00e9xito.","verified_email":"Correo electr\u00f3nico verificado con \u00e9xito"},"font":{"font_family":"Familia tipogr\u00e1fica","font_size":"Tama\u00f1o de fuente","font_size_in_px":"Tama\u00f1o de fuente en p\u00edxeles","fonts":"fuentes","px":"p\u00edxeles"},"form":{"DOB":"Ingrese fecha de nacimiento","allowed_vcard":"Ingrese el n\u00famero de Vcards permitidos","blog":"Ingrese el nombre del blog","c_password":"Confirmar contrase\u00f1a","company":"Introduzca el nombre de la empresa","contact":"N\u00famero de tel\u00e9fono","css":"Ingrese CSS personalizado","description":"Ingrese la descripci\u00f3n de su VCard","designation":"Ingrese la designaci\u00f3n","email":"Introduzca la direcci\u00f3n de correo electr\u00f3nico","enter_email":"Ingrese correo electr\u00f3nico","enter_name":"Ingrese su nombre","enter_phone":"Introducir tel\u00e9fono","enter_trial":"Introducir d\u00edas de prueba","f_name":"Ingrese el nombre","facebook":"Facebook URL","first_name":"Primer nombre","google_analytics":"C\u00f3digo de Google Analytics","home_title":"Ingrese el t\u00edtulo de la casa","instagram":"URL de Instagram","job":"Ingrese el t\u00edtulo del trabajo","js":"Ingrese J personalizados","l_name":"Introduzca el apellido","last_name":"Apellido","linkedin":"URL de LinkedIn","location":"Ingresa tu ubicaci\u00f3n","location_url":"Ingrese la URL de su ubicaci\u00f3n","mail":"Correo electr\u00f3nico","meta_description":"Introduce la meta descripci\u00f3n","meta_keyword":"Introduzca la metapalabra clave","my_vcard_url":"Mi-vcard-pagina-url","occupation":"Ingrese Ocupaci\u00f3n","password":"Clave","phone":"Ingresa n\u00famero telef\u00f3nico","pick_date":"Elija una fecha","pinterest":"URL de Pinterest","plan_name":"Ingrese el nombre del plan","price":"Introducir precio","product":"Introduzca el nombre del producto","product_url":"Introduzca la URL del producto","reddit":"URL de Reddit","select_country":"Seleccionar pa\u00eds","select_currency":"Seleccione el tipo de moneda","select_state":"Seleccione estado","service":"Ingrese el nombre del servicio","service_url":"Ingrese la URL del servicio","short_description":"Introduzca una breve descripci\u00f3n","site_title":"Ingrese el t\u00edtulo del sitio","testimonial":"Ingrese el nombre del testimonio","tiktok":"Haga clic en la URL","tumblr":"URL de Tumblr","twitter":"URL de Twitter","type_message":"Escriba un mensaje aqu\u00ed...","vcard_name":"Ingrese el nombre de la tarjeta virtual","website":"URL del sitio web","whatsapp":"URL de Whatsapp","your_email":"Direcci\u00f3n de correo electr\u00f3nico","your_name":"Su nombre","youtube":"URL de Youtube"},"from_time":"De vez","front":{"enter_your_email":"Introduce tu correo electr\u00f3nico","enter_your_message":"Ingrese su mensaje","enter_your_name":"Introduzca su nombre","your_email_address":"Su direcci\u00f3n de correo electr\u00f3nico"},"front_cms":{"banner":"Imagen de la pancarta","description":"Descripci\u00f3n","front_cms":"CMS frontal","title":"T\u00edtulo"},"gallery":{"gallery_name":"galer\u00edas","image":"Imagen","type":"Escribe","youtube":"Youtube"},"hour":"Hora","language":"Idioma","languages":{"edit_language":"Editar idioma","edit_translation":"Editar traducci\u00f3n","iso_code":"C\u00d3DIGO ISO","language":"idioma","languages":"idiomas","new_language":"Nuevo idioma","translation":"Traducci\u00f3n"},"made_by":"Hecho por","made_by_url":"Hecho por Url","mail":{"action_required":"Si no cre\u00f3 una cuenta, no se requiere ninguna otra acci\u00f3n.","appointment_time":"Hora de la cita: ","approved_successfully":"Tu cita aprobada con \u00e9xito el","attachment":"Archivo adjunto","between":"Entre","book_appointment":"Reservar una cita","book_successfully":"Tu cita reservada con \u00e9xito el","booked_appointment_with_you":"cita reservada con usted","email":"Correo electr\u00f3nico: ","hello":"Hola,","hello!":"\u00a1Hola!","here_is_enquiry":"Aqu\u00ed hay un detalle de consulta","messages":"Mensaje: ","name":"Nombre: ","new_manual_payment_request":"Nueva solicitud de pago manual","new_nfc_order":"Ha recibido un nuevo pedido Nfc de","notes":"notas","password_change":"Su contrase\u00f1a ha sido cambiada por el administrador ","please_click":"Haga clic en el bot\u00f3n de abajo para verificar su direcci\u00f3n de correo electr\u00f3nico.","please_contact_your_admin":"P\u00f3ngase en contacto con el administrador para obtener una nueva contrase\u00f1a. ","regard":"Saludos,","slot_text":"Si tiene problemas para hacer clic en el bot\u00f3n \"Verificar direcci\u00f3n de correo electr\u00f3nico\", copie y pegue la siguiente URL en su navegador web:","thanks_regard":"Gracias y Saludos,","vcard_name":"Nombre de la tarjeta virtual: ","verify_email":"Confirme su direcci\u00f3n de correo electr\u00f3nico","whoops":"\u00a1Vaya!"},"make_appointment":"Concertar cita","make_appointments":"Haga una cita","months":{"apr":"Abr","aug":"Ago","dec":"Dic","feb":"Feb","jan":"Ene","jul":"Jul","jun":"Jun","mar":"Mar","may":"Mayo","nov":"Nov","oct":"Oct","sep":"Sep"},"nfc":{"Add_NFC_card_photos_and_set_prices":"Agregar fotos de las tarjetas NFC y establecer precios.","Admin_Guide":"Gu\u00eda del Administrador: Venta de Tarjetas NFC","Browse_and_select_an_NFC_card":"Navegar y seleccionar una tarjeta NFC.","Cancelled":"Cancelada","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"Elija su vCard, la URL de esa vCard se escribir\u00e1 en la tarjeta NFC.","Confirm_the_order_and_make_a payment":"Confirmar el pedido y realizar el pago.","Create_or_log_in_to_your_account":"Crear o iniciar sesi\u00f3n en tu cuenta.","Delivered":"Entregado","Dispatch_the_NFC_cards_to_users":"Enviar las tarjetas NFC a los usuarios.","How_it_works":"C\u00f3mo funciona?","Log_in_to_the_Admin_Dashboard":"Iniciar sesi\u00f3n en el Panel de Administraci\u00f3n.","Pending":"Pendiente","Ready To Ship":"Listo para enviar","Receive_and enjoy your NFC card":"Recibir y disfrutar tu tarjeta NFC.","Review_user_orders":"Revisar pedidos de usuarios","Shipped":"Enviado","User_Guide":"Gu\u00eda del Usuario: Compra y Personalizaci\u00f3n de Tarjetas NFC","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"Esperar a que el administrador escriba la URL y env\u00ede la tarjeta.","Write_the_user_provided_URL_to_NFC_cards":"Escribir la URL proporcionada por el usuario en las tarjetas NFC.","add_nfc_card":"Agregar tarjeta NFC","all":"Toda","cancel":"Cancelada","card_can_not_deleted":"La tarjeta no se puede eliminar ya que est\u00e1 vinculada a los pedidos de los clientes.","card_type":"Tipo de tarjeta","company_name":"nombre de empresa","designation":"Designaci\u00f3n","edit_nfc_card":"Editar tarjeta NFC","enter_address":"Ingresa la direccion","failed":"Fallida","logo":"Logo","my_nfc_cards":"Mis tarjetas NFC","new_nfc_card":"Nueva tarjeta NFC","nfc":"NFC","nfc_card":"Tarjeta NFC","nfc_card_created_success":"Tarjeta NFC creada con \u00e9xito","nfc_card_deleted_success":"Tarjeta NFC eliminada correctamente","nfc_card_order_details":"Detalles del pedido de tarjeta NFC","nfc_card_orders":"Pedidos de tarjeta NFC","nfc_card_type":"Tipo de tarjeta NFC","nfc_card_types":"Tipos de tarjetas NFC","nfc_card_updated_success":"Tarjeta NFC actualizada correctamente","nfc_image":"Imagen de la tarjeta","nfc_image_required":"El campo Imagen NFC es obligatorio.","order":"orden","order_nfc":"Orden NFC","order_placed_success":"Pedido realizado con \u00e9xito","order_status":"Estado del pedido","order_status_update_success":"Estado del pedido actualizado correctamente","orders":"Pedidos","orders_count":"Recuento de pedidos","paid":"Pagado","payment_status":"Estado de pago","payment_status_update_success":"Estado de pago actualizado exitosamente","pending":"Pendiente","razorpay_session_success":"La sesi\u00f3n de RazorPay se cre\u00f3 correctamente","required_vcard":"Por favor seleccione Vcard","select_card":"Por favor seleccione el tipo de tarjeta","select_vcard":"Seleccione tarjeta virtual","sell_nfc_cards":"Vender Tarjetas NFC","your_order_status_changed":"El estado de su pedido cambi\u00f3"},"no_data":"Datos no disponibles","no_matching_records_found":"No se encontraron registros coincidentes","notification":{"mark_all_as_read":"Marcar todo como leido","notifications":"Notificaciones","you_don`t_have_any_new_notification":"No tienes ninguna notificaci\u00f3n nueva"},"payment":{"cancelled":"CANCELADO","payment":"PAGO","payment_cancel":"Pago Cancelar","payment_success":"pago exitoso","payment_successful":"Pago exitoso"},"payment_method":"M\u00e9todo de pago","payment_type":"Tipo de pago","placeholder":{"12_hour":"12 horas","24_hour":"24 horas","address_field":"El campo Campo de direcci\u00f3n es obligatorio.","agree_term":"Debe estar de acuerdo con los T\u00e9rminos y condiciones.","all_rights_reserve":"Reservados todos los derechos","app_name_required":"El campo Nombre de la aplicaci\u00f3n es obligatorio","appointment_created":"Cita creada con \u00e9xito.","cannot_switch_to_zero":"No se puede cambiar al plan cero si hay una versi\u00f3n de prueba disponible\/tiene un plan pago que est\u00e1 actualmente activo","choose_one_template":"Elija cualquier plantilla","copied_successfully":"Copiado con \u00e9xito.","de_active":"Desactivado","default_plan_can_not_be_delete":"No se puede eliminar el plan predeterminado","email_already_subscribed":"El correo electr\u00f3nico ya se ha suscrito.","email_verification":"Tu perfil ha sido actualizado. Le hemos enviado un correo de verificaci\u00f3n. Verifica tu correo modificado.","enquiry_sent":"Consulta enviada con \u00e9xito.","enter_valid_email":"Por favor introduzca un correo electr\u00f3nico v\u00e1lido.","enter_your_email_to_reset":"Ingrese su correo electr\u00f3nico para restablecer su contrase\u00f1a.","favicon_invalid":"El favicon tiene dimensiones de imagen no v\u00e1lidas.","first_name_required":"El campo Nombre es obligatorio.","forgot_your_password_no_problem":"\u00bfOlvidaste tu contrase\u00f1a? No hay problema. Simplemente h\u00e1ganos saber su direcci\u00f3n de correo electr\u00f3nico y le enviaremos un enlace de restablecimiento de contrase\u00f1a que le permitir\u00e1 elegir una nueva.","gallery_created":"Galer\u00eda creada con \u00e9xito.","gallery_updated":"Galer\u00eda actualizada con \u00e9xito.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","lang_already_exists":" El lenguaje ya existe.","language_save":"Idioma guardado con \u00e9xito.","last_name_required":"El campo Apellido es obligatorio.","last_week":"La semana pasada","login_via_facebook":"Iniciar sesi\u00f3n a trav\u00e9s de Facebo","login_via_google":"Iniciar sesi\u00f3n a trav\u00e9s de Google","message_sent":"Mensaje enviado exitosamente.","multi_templates":"Se requieren varias plantillas","paid_appointment_cant_delete":"La cita pagada no se puede eliminar","password_character":"La contrase\u00f1a debe tener al menos 8 caracteres.","password_invalid":"La contrase\u00f1a no es v\u00e1lida","password_is_correct":"la contrase\u00f1a es correcta","password_must_match":"La contrase\u00f1a y la confirmaci\u00f3n de la contrase\u00f1a deben coincidir.","passwords":"El campo de contrase\u00f1as es obligatorio.","payment_cancel":"Su pago est\u00e1 cancelado","payment_done":"Pago realizado con \u00e9xito.","payment_not_complete":"Pago no completado","payment_received":"Pago recibido con \u00e9xito.","paypal_created":"Sesi\u00f3n de Paypal creada con \u00e9xito.","paypal_key":"El campo clave de Paypal es obligatorio.","paypal_mode":"El campo de modo Paypal es obligatorio.","paypal_secret":"El campo secreto de Paypal es obligatorio.","phone_number_required":"El campo N\u00famero de tel\u00e9fono es obligatorio.","plan_already_used":"Plan ya en uso","plan_expire_notification":"El campo de notificaci\u00f3n de caducidad del plan es obligatorio.","please_add_payment_credentials":"Por favor agregue las credenciales de pago","privacy_policy":"La Pol\u00edtica de privacidad es obligatoria.","product_purchase":"Producto comprado exitosamente.","purchased_plan":"Usted compra este plan con \u00e9xito.","receive_latest_news":"Reciba las \u00faltimas noticias, actualizaciones y muchas otras cosas cada semana.","registered_success":"Vous vous \u00eates inscrit avec succ\u00e8s, activez votre compte par e-mail.","required_captcha":"Por favor verifique el captcha","role_created":"Rol creado con \u00e9xito.","select_hour":"Seleccione la fecha o la hora","select_one_or_more":"Seleccione una o m\u00e1s caracter\u00edsticas requeridas","short_code_only_alpha":"El c\u00f3digo corto solo debe contener letras del alfabeto.","stripe_created":"La sesi\u00f3n de Stripe se cre\u00f3 correctamente.","stripe_key":"El campo de clave de franja es obligatorio.","stripe_secret":"El campo de secreto de banda es obligatorio.","subscribed_plan":"Te suscribiste a este plan con \u00e9xito.","subscribed_plan_wait":"Se suscribi\u00f3 a este plan con \u00e9xito pero espera la confirmaci\u00f3n del administrador","subscribed_successfully":"Suscrito con \u00e9xito.","subscription_date_updated":"Date d'abonnement mise \u00e0 jour avec succ\u00e8s.","successfully_verified":"Ha verificado con \u00e9xito su correo, por favor inicie sesi\u00f3n.","the_term_conditions":"Los T\u00e9rminos y Condiciones son obligatorios.","there_is_not_available_slot":"No hay espacios disponibles en la fecha dada","this_currency_is_not_supported":"PayPal no admite esta moneda para realizar pagos.","this_week":"Esta semana","time_format":"Formato de tiempo","too_long":"Demasiado largo","too_short":"Demasiado corto","unable_to_process_payment":"No se puede procesar el pago en este momento. Vuelva a intentarlo m\u00e1s tarde.","upload_required":"El campo de carga de archivos es obligatorio.","valid_number":"N\u00famero v\u00e1lido","we_could_not_fb_id":"No pudimos encontrar la direcci\u00f3n de correo electr\u00f3nico en tu cuenta de Facebook","withdrawal_request_send":"Solicitud de retiro Aprobada con \u00e9xito.","your_mail_already_verified":"Su correo ya est\u00e1 verificado, por favor inicie sesi\u00f3n."},"plan":{"We'll_never_share_your_email_with_anyone_else":"Nunca compartiremos su correo electr\u00f3nico con nadie m\u00e1s.","additional_domains":"Dominios adicionales","affiliation":"afiliaciones","analytics":"Anal\u00edtica","blog":"Blogs","currency":"Divisa","custom_css":"CSS personalizado","custom_fields":"Campos Personalizados","custom_js":"JS personalizado","custom_qrcode":"C\u00f3digo QR personalizado","days":"D\u00edas","default_Plan":"Plan predeterminado","description":"Descripci\u00f3n","domains_limit":"L\u00edmite de dominios","duration":"Duraci\u00f3n","duration_months":"Duraci\u00f3n Meses","duration_years":"Duraci\u00f3n A\u00f1os","edit_plan":"Editar plan","email_address":"Direcci\u00f3n de correo electr\u00f3nico","enquiry_form":"Formulario de Consulta","features":"Caracter\u00edsticas","frequency":"Frecuencia","gallery":"Galer\u00eda","hide_branding":"Ocultar marca","is_trial":"es prueba","make_default":"Hacer por defecto","monthly":"Mensual","months":"Meses","multi_templates":"Plantillas M\u00faltiples","new_plan":"Nuevo plan","no_of_vcards":"N\u00famero de tarjetas virtuales","password_protection":"Protecci\u00f3n de contrase\u00f1a","plan":"Plan","plan_type":"Tipo de plan","portfolio":"portafolio","price":"Precio","products":"Productos","products_&_services":"productos y servicios","qrcode":"C\u00f3digo QR","remaining_balance":"Saldo restante de Prev. Plan","select_all_feature":"Seleccionar todas las funciones","select_plan":"Seleccionar Plan","sendemail":"Enviar correo electr\u00f3nico","sendinvite":"Enviar invitaci\u00f3n","seo":"Optimizaci\u00f3n de motores de b\u00fasqueda","services":"Servicios","status":"estado","testimonials":"Testimonios","total_custom_domains_limit":"L\u00edmite total de dominios personalizados","trial_days":"D\u00edas de prueba","unlimited":"Ilimitado","valid_upto":"V\u00e1lida hasta","what_s_in_startup_plan":"\u00bfQu\u00e9 hay en el plan de inicio?","yearly":"Anual","years":"A\u00f1os"},"plan_expire":"El plan est\u00e1 vencido. Elija un plan para continuar con el servicio.","plan_expire_notification":"Notificaci\u00f3n de caducidad del plan (en d\u00edas)","plans":"planes","product_details":"Detalles del pedido del producto","product_orders":"Pedidos de productos","resend_verification_email":"Reenviar correo electr\u00f3nico de verificaci\u00f3n","reset_password":"Restablecer la contrase\u00f1a","role":{"edit_role":"Editar rol","name":"Nombre","new_role":"Nuevo rol","permissions":"permisos","role_permissions":"Permisos de rol","select_all_permissions":"Seleccionar todos los permisos"},"roles":"roles","sadmin_dashboard":{"contact":"N\u00famero de contacto","day":"D\u00eda","email":"Correo electr\u00f3nico","income":"ingreso","month":"Mi","name":"Nombre","plans_by_users":"Planes por Usuarios","recent_users_registration":"Registro de usuarios recientes","registered_on":"Registrado en","week":"Semana"},"save":"Save","select_payment_type":"Seleccionar pasarela de pago","services":"Servicios","setting":{"add_contact":"Agregar a contacto","address":"Habla a","affiliation_amount":"Cantidad de afiliaci\u00f3n","affiliation_withdraw":"Retirada de afiliaci\u00f3n","app_logo":"Logotipo de la aplicaci\u00f3n","app_name":"Nombre de la aplicaci\u00f3n","clinic_name":"Nombre de la cl\u00ednica","contact_information":"Informaci\u00f3n del contacto","credentials":"cartas credenciales","currency":"Divisa","currency_settings":"Configuraci\u00f3n de moneda","default_currency_format":"Formato de moneda predeterminado","default_language":"Idioma predeterminado","disable_landing_page":"Deshabilitar p\u00e1gina de destino","enable_addcontact":"Habilitar Agregar al contacto","enable_affiliation":"Habilitar afiliaci\u00f3n","enable_contact":"Habilitar contacto","favicon":"icono de favoritos","front_page_enable":"Habilitar p\u00e1gina principal","general":"General","general_details":"Detalles generales","hide_stickybar":"Ocultar barra adhesiva vCard","location_url":"URL de ubicaci\u00f3n","manually":"A mano","note":"Nota: el nombre del \u00edcono cargado debe ser \"WeChat.png\" \/ \"Tumbler.png\" \/ \"XXX.png\", mientras se descarga el archivo .vcf, ese nombre se usar\u00e1 como etiqueta.","paypal":"PayPal","paypal_client_id":"ID de cliente de Paypal","paypal_key":"Clave de PayPal","paypal_mode":"Modo Paypal","paypal_payout_email":"Correo electr\u00f3nico de pago de Paypal","paypal_secret":"Secreto de Paypal","postal_code":"C\u00f3digo postal","prefix":"Prefijo","razorpay":"maquinilla de afeitar","razorpay_key":"Clave Razorpay","razorpay_secret":"Secreto de Razorpay","select_currency":"Seleccione el tipo de moneda","setting":"Ajuste","shipping_address":"Direcci\u00f3n de env\u00edo","specialities":"Especialidades","stripe":"Raya","stripe_key":"tecla de rayas","stripe_secret":"Secreto de rayas","upgrade_database":"Actualizar base de datos","user_default_language":"Idioma predeterminado del usuario","whatsapp_share":"WhatsApp Compartir","withdraw_transactions":"Retirar Transacciones","withdrawals":"Retiros","wp_number":"Ingrese el n\u00famero de tel\u00e9fono"},"settings":"Ajustes","sign_out":"Desconectar","social":{"Facebook":"Facebook","Instagram":"Instagram","Linkedin":"LinkedIn","Pinterest":"Pinterest","Reddit":"Reddit","Share_on_email":"Compartir por correo electr\u00f3nico","Share_on_facebook":"Compartir en Facebook","Share_on_linkedin":"Compartir en Linkedin","Share_on_pinterest":"Compartir en Pinterest","Share_on_reddit":"Compartir en Reddit","Share_on_twitter":"Compartir en Twitter","Share_on_whatsapp":"Compartir en whatsapp","Tiktok":"Tik Tok","Tumblr":"Tumblr","Twitter":"Gorjeo","Whatsapp":"Whatsapp","Youtube":"YouTube","map":"Mapa","social_links":"Enlaces sociales - Sitio web","website":"Sitio web"},"state":{"country_name":"Nombre del pa\u00eds","edit_state":"Editar estado","new_state":"nuevo estado","no_state_available":"Ning\u00fan estado disponible","no_state_found":"No se encontr\u00f3 ning\u00fan estado","state":"Expresar","state_name":"Nombre del Estado","states":"estados"},"subscribe":"Suscribir","subscribed_plans":"Planes Suscritos","subscribed_user":"Planes de usuario suscrito","subscriber":"Suscriptoras","subscription":{"active_until":"Activo hasta","active_until_unlimited":"Activo hasta ilimitado","amount":"Monto","buy_now":"Comprar ahora","buy_product":"Comprar producto","cancel_subscription":"Cancelar suscripci\u00f3n","choose_plan":"Elija Plan","current_expire":"Plan actual vencido","current_plan":"Plan actual","currently_active":"Actualmente activo","end_date":"Fecha final","end_date_required":"El campo de fecha de finalizaci\u00f3n es obligatorio","expired":"El plan ya venci\u00f3 el","expired_date":"Fecha de vencimiento","free":"Gratis","has_already_been_subscribed":"ya est\u00e1 suscrito","has_been_subscribed":"ha sido suscrito","history":"Historial de suscripciones","manage_subscription":"Administrar suscripci\u00f3n","no_plan_available":"Ning\u00fan plan disponible","pay_or_switch_plan":"Pagar\/Cambiar Plan","payable_amount":"Cantidad a pagar","payment":"Pago","plan_name":"Nombre del plan","plan_price":"Precio del plan","proceed_to_payment":"Proceder al pago","purchase":"Compra","remaining":"Restante","remaining_balance":"Balance restante","remaining_days":"D\u00edas restantes","renew_free_plan":"El plan gratuito no se puede renovar\/elegir de nuevo","renew_plan":"Plan Renovar","start_date":"Fecha de inicio","subscribed_date":"Fecha de suscripci\u00f3n","subscribed_plan_details":"Detalles del plan suscrito","switch_plan":"cambiar de plan","total_days":"D\u00edas totales","trial_plan":"Plan de prueba","upgrade_plan":"Plan de actualizaci\u00f3n","used_balance":"Saldo usado","used_days":"D\u00edas utilizados"},"subscriptions":"Suscripciones","testimonial":"Testimonios","to_time":"To time","tooltip":{"about_description":"M\u00e1ximo de 500 caracteres permitidos","about_title":"M\u00e1ximo de 100 caracteres permitidos","allowed_image":"Tipos de archivos permitidos: png, jpg, jpeg.","app_logo":"La imagen debe ser de pixel 90 x 60","banner_title":"M\u00e1ximo de 34 caracteres permitidos","cancel_app_logo":"Cancelar logotipo de la aplicaci\u00f3n","cancel_cover":"Cancelar Cobertura","cancel_favicon_logo":"Cancelar icono de favorito","cancel_image":"Cambiar imagen","cancel_profile":"Cancelar perfil","change_app_logo":"Cambiar el logotipo de la aplicaci\u00f3n","change_favicon_logo":"Cambiar icono de favorito","change_icon":"cambiar el \u00edcono","copy":"Copiar al portapapeles","cover":"Cubierta de cambio","custom_css":"Habilite la capacidad de agregar css personalizado para cada VCard.","custom_fonts":"Habilite la capacidad de agregar fuentes personalizadas para cada VCard.","custom_js":"Habilite la capacidad de agregar js personalizados para cada VCard.","dark_mode":"Cambiar al modo oscuro","enable_affiliation":"Al habilitar esto, el enlace de afiliaci\u00f3n ser\u00e1 visible para todos sus vcards","enable_contact":"Al habilitar esto, los detalles de contacto ser\u00e1n visibles en todas sus Vcards ","favicon_logo":"La imagen debe ser de pixel 16 x 16","hide_branding":"Habilite la capacidad de ocultar la marca de las VCards.","hide_stickybar":"Al habilitar esto, los botones adhesivos de Vcards se ocultan en todas sus Vcards","home_image":"La mejor resoluci\u00f3n para este perfil ser\u00e1","image":"Cambiar imagen","light_mode":"Cambiar al modo de luz","password_protection":"Habilitar el acceso a proteger con contrase\u00f1a VCards.","product_image":"La mejor resoluci\u00f3n para este perfil ser\u00e1 250x2500","profile":"Cambiar el perfil","remove_branding":"Si est\u00e1 habilitado, la vcard no mostrar\u00e1 la marca de nuestro sitio web.","script":"Agregar c\u00f3digo JS personalizado sin etiqueta de script","sub_text":"M\u00e1ximo de 60 caracteres permitidos","the_main_url":"La URL principal desde la que se podr\u00e1 acceder a su vcard.","whatsapp_share":"Al habilitar esto, el bot\u00f3n Compartir de WhatsApp estar\u00e1 visible en todas sus VCards"},"translation_manager":"Gerente de traducci\u00f3n","type_in_script":"Escriba el c\u00f3digo js dentro de la etiqueta <script><\/script>","user":{"account":"Cuenta","account_setting":"Configuraciones de la cuenta","add_admin":"Agregar administrador","add_user":"Agregar usuario","admin_details":"Detalles del administrador","avatar":"Avatar","change_language":"Cambiar idioma","change_password":"Cambia la contrase\u00f1a","confirm_password":"Confirmar contrase\u00f1a","contact_no":"N\u00famero de contacto","contact_number":"N\u00famero de contacto","current_password":"contrase\u00f1a actual","edit_user":"editar usuario","email":"Correo electr\u00f3nico","email_verified":"Correo verificado","female":"Mujer","first_name":"Primer nombre","full_name":"Nombre completo","impersonate":"Personificar","last_name":"Apellido","location":"Ubicaci\u00f3n","male":"Masculino","new_password":"Nueva contrase\u00f1a","overview":"Descripci\u00f3n general","password":"Contrase\u00f1a","phone":"Tel\u00e9fono","profile":"Perfil","profile_details":"detalles del perfil","registered_date":"La fecha registrada","return_to_admin":"Volver a administraci\u00f3n","save_changes":"Guardar cambios","setting":"Ajuste","theme_change":"Cambio de modo de temae","user_details":"Detalles de usuario","your_message":"Tu mensaje","your_name":"Tu nombre"},"users":"Usuarios","vcard":{"add_blog":"A\u00f1adir Blog","add_gallery":"A\u00f1adir galer\u00eda","add_google_analytics":"Agregue el c\u00f3digo de Google Analytics sin la etiqueta <script>","add_product":"Agregar producto","add_service":"Agregar servicio","add_testimonial":"A\u00f1adir Testimonio","advanced":"Avanzado","affiliate_user":"Usuarios Afiliados","alter_email_address":"ADirecci\u00f3n de correo electr\u00f3nico alternativo","alter_mobile_number":"N\u00famero de m\u00f3vil alternativo","alternate_email":"Correo electr\u00f3nico alternativo","alternative_phone":"Tel\u00e9fono alternativo","appointments":"Equipo","back_color":"Color de fondo","basic_details":"Detalles b\u00e1sicos","blog_details":"Detalles del blog","blog_icon":"Icono de blog","blogs":"Blogs","buisness_hours":"HORA DE TRABAJO","business-hours":"Horas de trabajo","business_hours":"Horas de trabajo","company":"Compa\u00f1\u00eda","contact":"Contacto","copy_referral_link":"Copiar enlace de referencia","cover_image":"Imagen de portada","created_at":"Creado en","created_on":"Creado en","custom-fonts":"fuentes","custom_css":"CSS personalizado","custom_fonts":"fuentes","custom_js":"JS personalizado","date_of_birth":"Fecha de nacimiento","description":"Descripci\u00f3n","display_share_button":"Mostrar bot\u00f3n de compartir","dob":"Fecha de nacimiento","download_my_qr_code":"Descargar Mi C\u00f3digo QR","download_vcard":"Descargar tarjeta virtual","duplicate_vcard":"Vcard duplicada!","edit_blog":"Editar blog","edit_gallery":"Editar galer\u00eda","edit_product":"Editar producto","edit_service":"Editar servicio","edit_testimonial":"Editar testimonio","edit_vcard":"Editar tarjeta virtual","email_address":"Direcci\u00f3n de correo electr\u00f3nico","enable_download_qr_code":"Habilitar Descargar C\u00f3digo QR","enable_enquiry_form":"Habilitar formulario de consulta","enter_password":"Introducir la contrase\u00f1a","first_name":"Primer nombre","flag":"Bandera","galleries":"Galer\u00edas","gallery":"Galer\u00eda","google_analytics":"Google analitico","google_config":"Configuraci\u00f3n de Google","header":"Encabezamiento","home_title":"T\u00edtulo de la casa","image":"Imagen","is_manual_payment":"\u00bfEst\u00e1 activada la gu\u00eda de pago manual?","job_title":"T\u00edtulo profesional","language_enable":"habilitar idioma","last_name":"Apellido","last_updated":"\u00daltima actualizaci\u00f3n","location":"Ubicaci\u00f3n","manage-section":"Administrar secci\u00f3n","manual_payment_guide":"Gu\u00eda de pago manual","map":"Mapa","meta_description":"Metadescripci\u00f3n","meta_keyword":"Metapalabra clave","mobile_number":"N\u00famero de tel\u00e9fono m\u00f3vilr","new_blog":"nuevo blog","new_gallery":"Nueva galer\u00eda","new_product":"Nuevo producto","new_service":"Nuevo servicio","new_testimonial":"Nuevo Testimonio","new_vcard":"Nueva tarjeta virtual","occupation":"Ocupaci\u00f3n","order_at":"Ordenado en","our_service":"Nuestros servicios","payment_config":"Configuraci\u00f3n de pago","preview_url":"URL de vista previa","privacy_policy":"Pol\u00edtica de privacidad","product":"Producto","product_details":"Detalles de producto","product_icon":"\u00cdcono de producto","product_name":"nombre del producto","product_transection":"Transacciones de productos","products":"productos","profile_image":"Imagen de perfil","qr_code":"C\u00f3digo QR","qr_code_download_size":"Tama\u00f1o de descarga del c\u00f3digo QR","qrcode-customize":"Personalizar c\u00f3digo QR","qrcode_color":"Color del c\u00f3digo QR","qrcode_customize":"Personalizar c\u00f3digo QR","qrcode_eye_style":"Seleccionar estilo de ojos","qrcode_style":"Seleccionar estilo","remove_branding":"Eliminar marca","select_template":"Seleccionar plantilla","send_message":"Enviar mensaje","seo":"Optimizaci\u00f3n de motores de b\u00fasqueda","service_details":"Detalles del servicio","service_icon":"Icono de servicio","services":"Servicios","share":"Cuota","share_my_vcard":"Compartir mi tarjeta virtual","show_qr_code":"Mostrar c\u00f3digo QR","site_title":"T\u00edtulo del sitio","social-links":"V\u00ednculos sociales","social_links":"V\u00ednculos sociales","stats":"Estad\u00edsticas","status":"Estado","template":"Plantillas de tarjetas virtuales","term-condition":"T\u00e9rminos y condiciones","term-policy":"Pol\u00edtica de condiciones","term_condition":"T\u00e9rminos y condiciones","term_policy":"Pol\u00edtica de condiciones","testimonial":"Testimonial","testimonial_details":"Detalles del testimonio","testimonials":"Testimonios","theme_config":"Configuraci\u00f3n del tema","url_alias":"URL de alias","user":"Usuarios","user_name":"Nombre de usuario","vcard":"Tarjeta virtual","vcard_details":"Detalles de la tarjeta virtual","vcard_is_active":"Vcard est\u00e1 activo","vcard_name":"Nombre de la tarjeta virtual","vcard_service":"Servicio de tarjeta virtual"},"vcard_11":{"Latest_post":"\u00faltimas publicaciones","contact_detail":"Detalles de contacto","get_in_touch":"Ponerse en contacto","my_email":"Mi email","my_phones":"Mis tel\u00e9fonos","provide_service":"Proporcionar servicios","read_more":"Lee mas"},"vcards":"Tarjetas virtuales","vcards_template":{"image":"Imagen","used_count":"Conteo usado"},"vcards_templates":"Plantillas de tarjetas virtuales","virtual_backgrounds":"Fondos virtuales","wait_for_apporove_of_cash_payment_by_admin":"Su solicitud de transacci\u00f3n manual est\u00e1 pendiente.","weekdays":{"fri":"VIE","mon":"LUN","sat":"Se sent\u00f3","sun":"SOL","thu":"JUE","tue":"MAR","wed":"CASARSE"},"your":"Tu"},"es.pagination":{"next":"Siguiente &raquo;","previous":"&laquo; Anterior"},"es.passwords":{"reset":"\u00a1Tu contrase\u00f1a ha sido restablecida!","sent":"\u00a1Le hemos enviado por correo electr\u00f3nico su enlace de restablecimiento de contrase\u00f1a!","throttled":"Espere antes de volver a intentarlo.","token":"Este token de restablecimiento de contrase\u00f1a no es v\u00e1lido.","user":"No podemos encontrar un usuario con esa direcci\u00f3n de correo electr\u00f3nico."},"es.validation":{"accepted":"El :attribute debe ser aceptado.","active_url":"El :attribute no es una URL v\u00e1lida.","after":"El :attribute debe ser una fecha posterior a :date.","after_or_equal":"El :attribute debe ser una fecha posterior o igual a :fecha.","alpha":"El :attribute solo debe contener letras.","alpha_dash":"El :attribute solo debe contener letras, n\u00fameros, guiones y guiones bajos.","alpha_num":"El :attribute solo debe contener letras y n\u00fameros.","array":"El :attribute debe ser una matriz.","attributes":{"email":"Correo electr\u00f3nico","message":"Mensaje","name":"Nombre","phone":"Tel\u00e9fono","service_url":"Service URL"},"before":"El :attribute debe ser una fecha anterior a :fecha.","before_or_equal":"El :attribute debe ser una fecha anterior o igual a :fecha.","between":{"array":"El :attribute debe tener entre :min y :max elementos.","file":"El :attribute debe estar entre :min y :max kilobytes.","numeric":"El :attribute debe estar entre :min y :max.","string":"El :attribute debe estar entre :min y :max caracteres."},"boolean":"El :attribute el campo debe ser verdadero o falso.","confirmed":"El :attribute la confirmaci\u00f3n no coincide.","coupon_code":{"expired":"Este c\u00f3digo de cup\u00f3n ha caducado","not_found":"C\u00f3digo de cup\u00f3n no encontrado"},"current_password":"El contrase\u00f1a es incorrecta.","custom":{"attribute-name":{"rule-name":"mensaje personalizado"}},"date":"El :attribute no es una fecha v\u00e1lida.","date_equals":"El :attribute debe ser una fecha igual a :fecha.","date_format":"El :attribute no coincide con el formato :formato.","different":"El :attribute y :otro debe ser diferente.","digits":"El :attribute debe ser :d\u00edgitos d\u00edgitos.","digits_between":"El :attribute debe estar entre :min y :max d\u00edgitos.","dimensions":"El :attribute tiene dimensiones de imagen no v\u00e1lidas.","distinct":"El :attribute el campo tiene un valor duplicado.","email":"El :attribute Debe ser una direcci\u00f3n de correo electr\u00f3nico v\u00e1lida.","ends_with":"El :attribute debe terminar con uno de los siguientes: :valores.","exists":"El seleccionado :attribute Es invalido.","file":"El :attribute debe ser un archivo.","filled":"El :attribute el campo debe tener un valor.","gt":{"array":"El :attribute debe tener m\u00e1s de :elementos de valor.","file":"El :attribute debe ser mayor que :value kilobytes.","numeric":"El :attribute debe ser mayor que :valor.","string":"El :attribute must be greater than :value characters."},"gte":{"array":"El :attribute debe tener: elementos de valor o m\u00e1s.","file":"El :attribute debe ser mayor o igual que :value kilobytes.","numeric":"El :attribute debe ser mayor o igual que :valor.","string":"El :attribute debe ser mayor o igual que :value caracteres."},"image":"El :attribute debe ser una imagen.","in":"El seleccionado :attribute Es invalido.","in_array":"El :attribute el campo no existe en: otro.","integer":"El :attribute debe ser un entero.","ip":"El :attribute debe ser una direcci\u00f3n IP v\u00e1lida.","ipv4":"El :attribute debe ser una direcci\u00f3n IPv4 v\u00e1lida.","ipv6":"El :attribute debe ser una direcci\u00f3n IPv6 v\u00e1lida.","json":"El :attribute debe ser una cadena JSON v\u00e1lida.","lt":{"array":"El :attribute debe tener menos de :elementos de valor.","file":"El :attribute debe ser menor que :valor kilobytes.","numeric":"El :attribute debe ser menor que :valor.","string":"El :attribute debe ser menor que :valor caracteres."},"lte":{"array":"El :attribute no debe tener m\u00e1s de :elementos de valor.","file":"El :attribute must be less than or equal :value kilobytes.","numeric":"El :attribute debe ser menor o igual que: valor.","string":"El :attribute debe ser menor o igual que :value caracteres."},"max":{"array":"El :attribute no debe tener m\u00e1s de: elementos m\u00e1ximos.","file":"El :attribute no debe ser mayor que :max kilobytes.","numeric":"El :attribute must not be greater than :max.","string":"El :attribute no debe ser mayor que :max caracteres."},"mimes":"El :attribute debe ser un archivo de tipo: :valores.","mimetypes":"El :attribute debe ser un archivo de tipo: :valores.","min":{"array":"El :attribute debe tener al menos :min elementos.","file":"El :attribute debe tener al menos :min kilobytes.","numeric":"El :attribute debe ser al menos :min.","string":"El :attribute debe tener al menos :min caracteres."},"multiple_of":"El :attribute debe ser un m\u00faltiplo de: valor.","not_in":"El seleccionado :attribute Es invalido.","not_regex":"El :attribute el formato no es v\u00e1lido.","numeric":"El :attribute Tiene que ser un n\u00famero.","password":"El contrase\u00f1a es incorrecta.","present":"El :attribute el campo debe estar presente.","prohibited":"El :attribute el campo est\u00e1 prohibido.","prohibited_if":"El :attribute el campo est\u00e1 prohibido cuando :otro es :valor.","prohibited_unless":"El :attribute el campo est\u00e1 prohibido a menos que :otro est\u00e9 en :valores.","regex":"El :attribute el formato no es v\u00e1lido.","required":"El :attribute Se requiere campo.","required_if":"El :attribute el campo es obligatorio cuando :otro es :valor.","required_unless":"El :attribute el campo es obligatorio a menos que :otro est\u00e9 en :valores.","required_with":"El :attribute el campo es obligatorio cuando :valores est\u00e1 presente.","required_with_all":"El :attribute el campo es obligatorio cuando :values \u200b\u200best\u00e1n presentes.","required_without":"El :attribute El campo es obligatorio cuando :valores no est\u00e1 presente.","required_without_all":"El :attribute el campo es obligatorio cuando ninguno de los valores est\u00e1 presente.","same":"El :attribute Y: otro debe coincidir.","size":{"array":"El :attribute debe contener: elementos de tama\u00f1o.","file":"El :attribute debe ser :tama\u00f1o kilobytes.","numeric":"El :attribute debe ser: tama\u00f1o.","string":"El :attribute debe ser :caracteres de tama\u00f1o."},"starts_with":"El :attribute debe comenzar con uno de los siguientes: :valores.","string":"El :attribute debe ser una cadena.","timezone":"El :attribute debe ser una zona horaria v\u00e1lida.","unique":"El :attribute ya se ha tomado.","uploaded":"El :attribute no se pudo cargar.","url":"El :attribute debe ser una URL v\u00e1lida.","uuid":"El :attribute debe ser un UUID v\u00e1lido."},"et.cookie-consent::texts":{"agree":"Sain aru","message":"Sellel veebilehel on kasutusel cookies-failid teie kasutajaliidese parandamiseks."},"et.cookieConsent::texts":{"agree":"Sain aru","message":"Sellel veebilehel on kasutusel cookies-failid teie kasutajaliidese parandamiseks."},"fr.auth":{"about":"A propos","account_deactivate":"Votre compte est actuellement inactif, veuillez contacter l'administrateur.","app":{"create":"Cr\u00e9er","export":"Exportation","lock_account":"Verrouiller le compte","member_since":"Membre depuis","messages":"messages","online":"En ligne","print":"Imprimer","profile":"Profil","reload":"Recharger","reset":"R\u00e9initialiser","search":"Chercher","settings":"R\u00e9glages"},"choose_a_plan_that's_right_for_you":"Choisissez un forfait qui vous convient","confirm_password":"Confirmez le mot de passe","contact":"Contacter","copyright_by":"Droit d'auteur par","email":"E-mail","email_verify":"Veuillez v\u00e9rifier votre e-mail avant de vous connecter.","emails":{"password":{"reset_link":"Cliquez ici pour r\u00e9initialiser votre mot de passe"}},"failed":"Ces informations d'identification ne correspondent pas \u00e0 nos dossiers.","features":"Caract\u00e9ristiques","forgot_password":{"send_pwd_reset":"Envoyer le lien de r\u00e9initialisation du mot de passe","title":"Entrez l'e-mail pour r\u00e9initialiser le mot de passe"},"full_name":"Nom complet","get_started":"Commencer","home":"Accueil","let's_hear_what_they_say":"\u00c9coutons ce qu'ils disent","login":{"forgot_password":"j'ai oubli\u00e9 mon mot de passe","register_membership":"Enregistrez une nouvelle adh\u00e9sion","title":"Connectez-vous pour d\u00e9marrer votre session"},"modern_&_powerful_interface":"Interface moderne et puissante","password":"Mot de passe","pricing":"Tarification","register":"S'inscrire","registration":{"have_membership":"J'ai d\u00e9j\u00e0 un abonnement","i_agree":"Je suis d'accord pour","terms":"les termes","title":"Enregistrez une nouvelle adh\u00e9sion"},"remember_me":"Souviens-toi de moi","reset_password":{"reset_pwd_btn":"Reset Password","title":"r\u00e9initialisez votre mot de passe"},"sign_in":"S'identifier","sign_out":"signer out","sign_up":"S'inscrire","stories_from_our_customers":"Histoires de nos clientss","subscribe_here":"Abonnez-vous ici","throttle":"Trop de tentatives de connexion. Veuillez r\u00e9essayer dans : secondes secondes."},"fr.cookie-consent::texts":{"agree":"Accepter","message":"Ce site n\u00e9cessite l'autorisation de cookies pour fonctionner correctement."},"fr.cookieConsent::texts":{"agree":"Accepter","message":"Ce site n\u00e9cessite l'autorisation de cookies pour fonctionner correctement."},"fr.crud":{"action":"action","add_new":"Ajouter nouveau","are_you_sure":"Es-tu s\u00fbr?","back":"Retour","cancel":"Annuler","created_at":"Cr\u00e9\u00e9 \u00e0","deleted_at":"Supprim\u00e9 \u00e0","detail":"D\u00e9tail","edit":"\u00c9diter","id":"Identifiant","save":"Sauvegarder","updated_at":"Mis \u00e0 jour \u00e0"},"fr.livewire-tables::strings":{"All":"Toute","Applied Filters":"Filtres Appliqu\u00e9s","Applied Sorting":"Tri appliqu\u00e9","Bulk Actions":"Actions en vrac","Clear":"D\u00e9gager","Filters":"Filtres","Remove filter option":"Supprimer l'option de filtre","Remove sort option":"Supprimer l'option de tri","Search":"Chercher","Select All":"Tout s\u00e9lectionner","Show":"Montrer","Showing":"Montrant","Unselect All":"Tout d\u00e9selectionner","You are currently selecting all":"Vous s\u00e9lectionnez actuellement tous","You are not connected to the internet.":"Vous n'\u00eates pas connect\u00e9 \u00e0 Internet.","You have selected":"Vous avez s\u00e9lectionn\u00e9","of":"de","results":"r\u00e9sultats","rows":"Lignes","rows, do you want to select all":"lignes, voulez-vous tout s\u00e9lectionner","to":"pour"},"fr.messages":{"Business_Beacon":"vCard de balise d'entreprise","CEO\/CXO":"vCard des PDG\/CXO d'entreprise","Clean_Canvas":"Nettoyer la vCard de la toile","Corporate_Classic":"vCard Classique d'Entreprise","Corporate_Connect":"vCard Connexion Entreprise","Corporate_Identity":"vCard d'identit\u00e9 d'entreprise","Culinary_Food_Services":"vCard des services culinaires et alimentaires","Event_Management":"vCard de gestion d'\u00e9v\u00e9nements","Executive_Profile":"vCard du profil ex\u00e9cutif","Fashion_Beauty":"vCard Mode et Beaut\u00e9","Gym":"vCard de salle de sport","Hospital":"vCard de l'h\u00f4pital","Lawyer":"vCard avocat","Manually":"Manuellement","Modern_Edge":"vCard bord moderne","Paypal":"Pay Pal","Portfolio":"vCard du portefeuille","Pro_Network":"vCard du r\u00e9seau professionnel","Professional":"vCard professionnelle","Programmer":"vCard du programmeur","Razorpay":"Rasoirpay","Receive_latest_news_update_and_many_other_things_every_week":"Recevez les derni\u00e8res nouvelles, mises \u00e0 jour et bien d\u2019autres choses chaque semaine.","Salon":"Carte virtuelle du salon","Simple_Contact":"vCard de contact simple","Social_Media":"vCard des influenceurs des m\u00e9dias sociaux","Stripe":"Bande","Subscribe_Our_Newsletter":"Abonnez-vous \u00e0 notre newsletter","about_us":{"about_us":"\u00c0 propos de nous","description":"La description","image":"\u00c0 propos de l'image","title":"Titre"},"admin":{"add_admin":"Ajouter un administrateur","admin":"Administratrice","admin_created_successfully":"Administrateur cr\u00e9\u00e9 avec succ\u00e8s.","admin_delete_successfully":"Admin supprim\u00e9 avec succ\u00e8s.","admin_details":"D\u00e9tails de l'administrateur","admin_updated_successfully":"Admin mis \u00e0 jour avec succ\u00e8s.","avatar":"Avatar","confirm_password":"Confirmez le mot de passe","contact_number":"Num\u00e9ro de contact","edit_admin":"Modifier l\\administrateur","email":"E-mail","female":"Femelle","first_name":"Pr\u00e9nom","full_name":"Nom complet","gender":"Le genre","last_name":"Nom de famille","male":"Homme","not_allowed_to_access":"Apparemment, vous n'\u00eates pas autoris\u00e9 \u00e0 acc\u00e9der \u00e0 cet enregistrement.","password":"Mot de passe","profile":"Profil","profile_details":"Profile Details"},"admins":"Administrateurs","affiliation":{"affiliate_note":"Attention : vos d\u00e9tails d'affiliation seront publi\u00e9s sur votre page vcards en bas. Si vous vous inscrivez via cella et obtenez un abonnement apr\u00e8s cella, vous serez r\u00e9compens\u00e9 d'un montant de","affiliated_by":"Affili\u00e9 par","affiliation_transaction":"Op\u00e9rations d'affiliation","affiliation_withdraw_detail":"D\u00e9tail du retrait de l'affiliation","affiliations":"Affiliations","approval_status":"Statut approuv\u00e9","approve":"Approuver","approve_withdraw_request":"Approuver la demande de retrait","approved":"Approuv\u00e9","cash_payment":"Paiement en \u00e9sp\u00e8ces","current_amount":"Montant actuel","reject":"Rejeter","reject_withdraw_request":"Rejeter la demande de retrait","rejected":"Rejet\u00e9","rejection_note":"Note de rejet","total_affiliation_amount":"Montant total de l'affiliation","verify_paypal_email":"V\u00e9rifier l'e-mail Paypal","withdraw_amount":"Retirer le montant","withdrawal":"Retrait"},"allowed_file_types":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","analytic":{"vcard_analytic":"Vcard analytique"},"analytics":{"browsers":"navegadores","countries":"Los paises","devices":"Dispositivos","languages":"Idiomas","os":"Sistemas operativos","overview":"Aper\u00e7u","see_all":"Voir tout","view_more":"Voir plus","visitors":"Visiteurs"},"appointment":{"appointment":"Rendez-vous","appointment_details":"D\u00e9tails du rendez-vous","appointment_type":"Type de rendez-vous :","calendar":"Calendrier","ends":"Le rendez-vous se termine","free":"Libre","paid":"Pay\u00e9","starts":"Le rendez-vous commence"},"appointments":"rendez-vous","business":{"business_hours":"Heures de travail","end_time":"Heure de fin","fri":"ven","mon":"lun","sat":"Sam","start_time":"Heure de d\u00e9but","sun":"Dimanche","thu":"Thu","tue":"Mar","wed":"mer"},"by_signing_up_you_agree_to_our":"En vous inscrivant, vous acceptez nos","cash_payment":"Paiement en \u00e9sp\u00e8ces","city":{"cities":"Villes","city":"Ville","city_name":"Nom de Ville","edit_city":"Modifier la ville","new_city":"Nouvelle ville","no_city_available":"Aucune ville disponible","no_city_found":"Aucune ville trouv\u00e9e","state_name":"State Name"},"common":{"Yes_Change":"Oui, change","action":"action","active":"Actif","add":"Ajouter","add_virtual_background":"Ajouter un arri\u00e8re-plan virtuel","allow_cookies":"Autorise les cookies","already_have_an_account":"Vous avez d\u00e9j\u00e0 un compte","apply":"Appliquer","apply_changes":"Appliquer ces changements","are_you_completed":"Voulez-vous vraiment modifier ce statut\u00a0?","are_you_sure":"Voulez-vous vraiment supprimer ce","are_you_sure_dublicate_vcard":"\u00cates-vous s\u00fbr de vouloir cr\u00e9er une copie de cette VCard\u00a0?","back":"Retour","back_subscription":"Retour aux abonnements","cancel":"Annuler","captcha_enable":"Activer Google Captcha","closed":"Ferm\u00e9","completed":"compl\u00e9t\u00e9","cookie_banner_enabled":"Activer la banni\u00e8re de cookies","cookie_msg":"Votre exp\u00e9rience sur ce site sera am\u00e9lior\u00e9e en autorisant les cookies.","create_an_account":"Cr\u00e9er un compte","currency_position":"Position de la devise","custom":"Personnalis\u00e9","declined":"D\u00e9clin","default_country_code":"Code pays par d\u00e9faut","delete":"Supprimer","deleted":"Supprim\u00e9","description":"La description","details":"Details","discard":"Jeter","download":"T\u00e9l\u00e9charger","duplicate":"Dupliquer !","duplicate_vcard_create":"Vcard en double cr\u00e9\u00e9e avec succ\u00e8s","edit":"\u00c9diter","email":"E-mail","enable_cookie_banner":"Activer la banni\u00e8re de cookies","enable_page":"Activer la page de destination","enable_register":"Activer l'inscription","enable_validation":"Activer la validation","enquiry":"Demandes","error":"Erreur","filter":"Filtre","forgot_password":"Mot de passe oubli\u00e9","forgot_your_password":"Mot de passe oubli\u00e9","from":"De","has_been_completed":"a \u00e9t\u00e9 compl\u00e9t\u00e9.","has_been_deleted":"a \u00e9t\u00e9 supprim\u00e9.","icon":"Ic\u00f4ne","inactive":"Inactif","infyvcard":"InfyVcard","is_active":"C'est actif","link":"Lien","loading":"Chargement...","login":"Connexion","logout":"Se d\u00e9connecter","message":"Message","name":"Nom","new_here":"Nouveau ici","no":"Non, Annuler","no_data_available":"Pas de donn\u00e9es disponibles","notUsed":"Pas encore utilis\u00e9","ok":"D'accord","payment_methods":"Mode de paiement","paypal_email":"Email Paypal","pending":"En attente","phone":"T\u00e9l\u00e9phoner","phone_validation":"Validation du num\u00e9ro de t\u00e9l\u00e9phone","please_wait":"S'il vous pla\u00eet, attendez...","price":"Prix","product_url":"URL du produit","register":"S'inscrire","register_enable":"Activation de l'enregistrement","remember_me":"Souviens-toi de moi","reset":"R\u00e9initialiser","save":"Sauvegarder","service_url":"URL des services","show_currency_behind":"Afficher la devise derri\u00e8re","sign_in_here":"Se connecter ici","status":"Statut","sub_text":"Sous-texte","subject":"Sujet","submit":"Soumettre","successful":"Couronn\u00e9 de succ\u00e8s","to":"\u00c0","today":"Aujourd'hui","today_appointments":"Rendez-vous aujourd'hui","today_enquiry":"Demandes aujourd'hui","total__active_vcards":"Cartes actives totales","total__deactive_vcards":"Total des VCards d\u00e9sactiv\u00e9es","total_active_users":"Nombre total d'utilisateurs actifs","total_amount":"Montant total","total_deactive_users":"Nombre total d'utilisateurs d\u00e9sactiv\u00e9s","total_plans":"Nombre total de forfaits","total_users":"Nombre total d'utilisateurs","total_vcards":"Total des VCards","type":"Taper","unavailable":"Indisponible","upload_file":"T\u00e9l\u00e9verser un fichier","user":"Utilisatrice","view":"Voir","virtual_note":"'Remarque : Les arri\u00e8re-plans virtuels vous donneront les images de carte de visite dans lesquelles votre logo, votre nom, votre adresse et votre t\u00e9l\u00e9phone seront \u00e9crits. nous exportons des tailles standard d'arri\u00e8re-plans virtuels horizontaux et verticaux, ce qui sera utile lorsque vous souhaitez concevoir votre carte NFC, vous pouvez directement donner ces images aux gestionnaires d'impression NFC. En outre, vous pouvez \u00e9galement le partager directement avec vos amis ou le d\u00e9finir comme image de profil\/couverture.'","yes":"Oui, supprimer\u00a0!","yes_duplicate":"Oui, en double\u00a0!"},"contact_us":{"contact":"Nous contacter","contact_us":"Demandes","inquries":"Demandes","message":"Message","send_message":"Envoyer le message"},"copy_text":"Copie","country":{"countries":"Des pays","country":"Pays","country_name":"Nom du pays","edit_country":"Modifier le pays","new_country":"Nouveau pays","no_country_available":"Aucun pays disponible","no_country_found":"Aucun pays trouv\u00e9d","phone_code":"Indicatif t\u00e9l\u00e9phonique","short_code":"Petit code"},"coupon_code":{"add_coupon_code":"Ajouter un code promo","apply_here":"Appliquer ici","coupon_code":"Code promo","coupon_code_applied":"Code promo appliqu\u00e9 avec succ\u00e8s.","coupon_code_created":"Code promo cr\u00e9\u00e9 avec succ\u00e8s.","coupon_code_percent_validation":"La remise sur le coupon ne doit pas d\u00e9passer 100 %.","coupon_code_status_updated":"Le statut du code promo a \u00e9t\u00e9 mis \u00e0 jour avec succ\u00e8s.","coupon_code_updated":"Code promo mis \u00e0 jour avec succ\u00e8s.","coupon_codes":"Codes coupon","coupon_discount":"Coupon de r\u00e9duction","coupon_name":"Nom du coupon","coupon_type":"Type de coupon","edit_coupon_code":"Modifier le code promo","enter_coupon_code":"Entrer le code de r\u00e9duction","enter_coupon_discount":"Entrez le coupon de r\u00e9duction","enter_coupon_name":"Entrez le nom du coupon","expire_at":"Expire \u00e0","fixed":"Type fixe","flat":"Plate","have_a_coupon_code":"Vous avez un code promo ?","percentage":"Pourcentage","remove":"Retirer"},"create_vcard":"Cr\u00e9ez votre VCard","create_your_business_digital_card_with_lots_of_information":"Cr\u00e9ez votre carte num\u00e9rique professionnelle avec de nombreuses informations","currency":{"currencies":"Devises","currency_code":"Code de devise","currency_icon":"Ic\u00f4ne de devise"},"dashboard":"Tableaux de bord","date":"Date","deactivate":"D\u00e9sactiver","e_card":{"add_ecard":"Ajouter une carte \u00e9lectronique","ecard":"Carte \u00e9lectronique","ecard_info":"L'image doit \u00eatre de pixel 150 x 150","ecard_logo":"Logo de la carte \u00e9lectronique","ecards":"E-cartes"},"edit_subscription":"Modifier le plan d'abonnement","email_not_found":"Nous ne trouvons pas d'utilisateur avec cette adresse e-mail","email_password_reset_link":"Lien de r\u00e9initialisation du mot de passe par e-mail","enquiry":"Demandes","enquiry_detail":"D\u00e9tails de la demande","expire_in":"Le plan est sur le point d'expirer dans","extra_scripts":"Sc\u00e9narios suppl\u00e9mentaires","feature":{"affiliation":"Affiliation","analytics":"Analytique","appointments":"Rendez-vous","blog":"Blog","custom_css":"CSS personnalis\u00e9","custom_fonts":"Custom Fonts","custom_js":"JavaScript personnalis\u00e9","custom_qrcode":"Code QR personnalis\u00e9","description":"La description","edit_feature":"Modifier la fonctionnalit\u00e9","enquiry_form":"formulaire","feature_image":"Image caract\u00e9ristique","gallery":"Gallery","hide_branding":"Masquer la marque","image":"Image","name":"Nom","order_nfc_card":"Commander une carte NFC","password":"Mot de passe de protection","products":"Des produits","products_services":"Prestations de service","seo":"r\u00e9f\u00e9rencement","social_links":"Liens sociaux","testimonials":"T\u00e9moignages"},"features":"Caract\u00e9ristiques","flash":{"about_us_create":"\u00c0 propos de nous enregistr\u00e9 avec succ\u00e8s.","can_not_change_time_format":"Le rendez-vous est d\u00e9j\u00e0 pris pour ce format horaire","city_create":"Ville enregistr\u00e9e avec succ\u00e8s.","city_update":"Ville mise \u00e0 jour avec succ\u00e8s.","country_create":"Pays enregistr\u00e9 avec succ\u00e8s.","country_update":"Pays mis \u00e0 jour avec succ\u00e8s.","country_used":"Pays d\u00e9j\u00e0 utilis\u00e9","create_blog":"Blog VCard cr\u00e9\u00e9 avec succ\u00e8s.","create_front_testimonial":"T\u00e9moignage cr\u00e9\u00e9 avec succ\u00e8s.","create_product":"Produit VCard cr\u00e9\u00e9 avec succ\u00e8s.","create_service":"Service VCard cr\u00e9\u00e9 avec succ\u00e8s.","create_testimonial":"T\u00e9moignage VCard cr\u00e9\u00e9 avec succ\u00e8s.","current_invalid":"Le mot de passe actuel n'est pas valide","database_upgrade_succesfully":"Votre base de donn\u00e9es a \u00e9t\u00e9 mise \u00e0 niveau avec succ\u00e8s","decription_is_required":"Le champ de description est obligatoire","feature_update":"Fonctionnalit\u00e9 mise \u00e0 jour avec succ\u00e8s.","front_cms":"Front CMS mis \u00e0 jour avec succ\u00e8s.","language_update":"Langue mise \u00e0 jour avec succ\u00e8s.","mobile_validation":"Validation mobile mise \u00e0 jour avec succ\u00e8s.","name_is_required":"Il est requis de compl\u00e9ter le champ correspondant au nom","password_update":"Mot de passe mis \u00e0 jour avec succ\u00e8s.","plan_create":"Plan cr\u00e9\u00e9 avec succ\u00e8s.","plan_default":"Le plan par d\u00e9faut a \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s.","plan_status":"Statut du plan mis \u00e0 jour avec succ\u00e8s","plan_update":"Plan mis \u00e0 jour avec succ\u00e8s.","reactive_account":"R\u00e9activez votre compte \u00e0 partir du courrier.","setting_update":"Param\u00e8tres mis \u00e0 jour avec succ\u00e8s.","social_links_img_is_required":"Limage des liens sociaux est requise","social_links_is_required":"les liens sociaux sont requis","state_create":"\u00c9tat enregistr\u00e9 avec succ\u00e8s.","state_update":"\u00c9tat mis \u00e0 jour avec succ\u00e8s.","state_used":"\u00c9tat d\u00e9j\u00e0 utilis\u00e9","success_theme_update":"Th\u00e8me mis \u00e0 jour avec succ\u00e8s","update_blog":"Blog VCard mis \u00e0 jour avec succ\u00e8s.","update_front_testimonial":"T\u00e9moignage mis \u00e0 jour avec succ\u00e8s.","update_product":"Produit VCard mis \u00e0 jour avec succ\u00e8s.","update_service":"Service VCard mis \u00e0 jour avec succ\u00e8s.","update_testimonial":"T\u00e9moignage VCard mis \u00e0 jour avec succ\u00e8s.","user_create":"Utilisateur cr\u00e9\u00e9 avec succ\u00e8s.","user_profile":"Profil utilisateur mis \u00e0 jour avec succ\u00e8s.","user_status":"Le statut de l'utilisateur a \u00e9t\u00e9 mis \u00e0 jour avec succ\u00e8s","user_update":"Utilisateur mis \u00e0 jour avec succ\u00e8s.","vcard_create":"VCard cr\u00e9\u00e9 avec succ\u00e8s.","vcard_delete":"VCard supprim\u00e9e avec succ\u00e8s.","vcard_retrieve":"VCard r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s","vcard_status":"Statut de la VCard mis \u00e0 jour avec succ\u00e8s","vcard_update":"Mis \u00e0 jour avec succ\u00e9s.","verified_email":"Courriel v\u00e9rifi\u00e9 avec succ\u00e8s"},"font":{"font_family":"Famille de polices","font_size":"Taille de police","font_size_in_px":"Taille de la police en pixels","fonts":"Polices","px":"pixels"},"form":{"DOB":"Entrer date de naissance","allowed_vcard":"Entrez le nombre de Vcards autoris\u00e9es","blog":"Entrez le nom du blog","c_password":"Confirmez le mot de passe","company":"Entrez le nom de l'entreprise","contact":"Num\u00e9ro de t\u00e9l\u00e9phone","css":"Entrez le CSS personnalis\u00e9","description":"Entrez la description de votre VCard","designation":"Entrez la d\u00e9signation","email":"Entrer l'adresse e-mail","enter_email":"Entrez l'e-mail","enter_name":"Entrez le nom","enter_phone":"Entrez le t\u00e9l\u00e9phone","enter_trial":"Entrez les jours d'essai","f_name":"Entrez votre pr\u00e9nom","facebook":"L'adresse URL de Facebook","first_name":"Pr\u00e9nom","google_analytics":"Code Google Analytics","home_title":"Entrez le titre de la maison","instagram":"URL Instagram","job":"Entrez le titre du poste","js":"Entrez des Js personnalis\u00e9s","l_name":"Entrer le nom de famille","last_name":"Nom de famille","linkedin":"URL LinkedIn","location":"Entrez votre position","location_url":"Entrez l'URL de votre emplacement","mail":"E-mail","meta_description":"Entrez la m\u00e9ta description","meta_keyword":"Entrez le m\u00e9ta-mot-cl\u00e9","my_vcard_url":"URL de ma page vcard","occupation":"Entrez la profession","password":"Mot de passe","phone":"Entrez le num\u00e9ro de t\u00e9l\u00e9phone","pick_date":"Choisis une date","pinterest":"URL Pinterest","plan_name":"Entrez le nom du r\u00e9gime","price":"Entrez le prix","product":"Entrez le nom du produit","product_url":"Entrez l'URL du produit","reddit":"URL Reddit","select_country":"Choisissez le pays","select_currency":"S\u00e9lectionnez la devise","select_state":"S\u00e9lectionnez l'\u00e9tat","service":"Entrez le nom du service","service_url":"Entrez l'URL du service","short_description":"Entrez une courte description","site_title":"Entrez le titre du site","testimonial":"Entrez le nom du t\u00e9moignage","tiktok":"Cliquez sur l'url","tumblr":"URL de Tumblr","twitter":"Twitter URL","type_message":"Tapez un message ici...","vcard_name":"Entrez le nom de la carte virtuelle","website":"URL de site web","whatsapp":"URL WhatsApp","your_email":"Adresse e-mail","your_name":"votre nom","youtube":"URL YouTube"},"from_time":"De temps","front":{"enter_your_email":"Entrer votre Email","enter_your_message":"Entrez votre message","enter_your_name":"Entrez votre nom","your_email_address":"Votre adresse email"},"front_cms":{"banner":"Image de la banni\u00e8re","description":"La description","front_cms":"CMS avant","title":"Titre"},"gallery":{"gallery_name":"Galeries","image":"Image","type":"Taper","youtube":"Youtube"},"hour":"Heure","language":"Langue","languages":{"edit_language":"Modifier la langue","edit_translation":"Editar tradu\u00e7\u00e3o","iso_code":"CODE ISO","language":"Langue","languages":"langages","new_language":"Nouveau langage","translation":"Traduction"},"made_by":"Faite par","made_by_url":"R\u00e9alis\u00e9 par Url","mail":{"action_required":"Si vous n'avez pas cr\u00e9\u00e9 de compte, aucune autre action n'est requise.","appointment_time":"Heure de rendez-vous : ","approved_successfully":"Votre rendez-vous a \u00e9t\u00e9 approuv\u00e9 avec succ\u00e8s le","attachment":"Attachement","between":"entre","book_appointment":"Prendre rendez-vous","book_successfully":"Votre rendez-vous pris avec succ\u00e8s le","booked_appointment_with_you":"rendez-vous pris avec vous","email":"E-mail: ","hello":"Bonjour,","hello!":"Bonjour!","here_is_enquiry":"Voici un d\u00e9tail de l'enqu\u00eate","messages":"Message: ","name":"Nom: ","new_manual_payment_request":"Nouvelle demande de paiement manuel","new_nfc_order":"Vous avez re\u00e7u une nouvelle commande NFC de","notes":"Remarques","please_click":"Veuillez cliquer sur le bouton ci-dessous pour v\u00e9rifier votre adresse e-mail.","regard":"Salutations,","slot_text":"Si vous rencontrez des difficult\u00e9s pour cliquer sur le bouton \u00ab\u00a0V\u00e9rifier l'adresse e-mail\u00a0\u00bb, copiez et collez l'URL ci-dessous dans votre navigateur Web:","thanks_regard":"Merci & Cordialement,","vcard_name":"Nom de la carte virtuelle: ","verify_email":"V\u00e9rifier l'adresse e-mail","whoops":"Oups!"},"make_appointment":"Prendre un rendez-vous","make_appointments":"Prendre rendez-vous","months":{"apr":"Avr","aug":"Ao\u00fbt","dec":"D\u00e9c","feb":"F\u00e9v","jan":"Jan","jul":"Juil","jun":"Juin","mar":"Mar","may":"Peut","nov":"Nov","oct":"Oct","sep":"Sep"},"nfc":{"Add_NFC_card_photos_and_set_prices":"Ajoutez des photos de cartes NFC et fixez les prix.","Admin_Guide":"Guide de l'administrateur : Vente de cartes NFC","Browse_and_select_an_NFC_card":"Parcourez et s\u00e9lectionnez une carte NFC.","Cancelled":"Annul\u00e9","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"Choisissez votre vCard, l'URL de cette vCard sera \u00e9crite sur la carte NFC.","Confirm_the_order_and_make_a_payment":"Confirmez la commande et effectuez un paiement.","Create_or_log_in_to_your_account":"Cr\u00e9ez un compte ou connectez-vous \u00e0 votre compte.","Delivered":"Livr\u00e9","Dispatch_the_NFC_cards_to_users":"Exp\u00e9diez les cartes NFC aux utilisateurs.","How_it_works":"Comment \u00e7a fonctionne ?","Log_in_to_the_Admin_Dashboard":"Connectez-vous au tableau de bord de l'administrateur.","Pending":"En attente","Ready To Ship":"Pr\u00eat pour l'exp\u00e9dition","Receive_and enjoy your NFC card":"Recevez et profitez de votre carte NFC.","Review_user_orders":"Examiner les commandes des utilisateurs","Shipped":"Exp\u00e9di\u00e9","User_Guide":"Guide de l'utilisateur : Achat et personnalisation des cartes NFC","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"Attendez que l'administrateur \u00e9crive l'URL et exp\u00e9die la carte.","Write_the_user_provided_URL_to_NFC_cards":"\u00c9crivez l'URL fournie par l'utilisateur sur les cartes NFC.","add_nfc_card":"Ajouter une carte NFC","all":"Toute","cancel":"Annul\u00e9","card_can_not_deleted":"La carte ne peut pas \u00eatre supprim\u00e9e car elle est li\u00e9e aux commandes des clients.","card_type":"Type de carte","company_name":"Nom de l'entreprise","designation":"D\u00e9signation","edit_nfc_card":"Modifier la carte NFC","enter_address":"Entrer l'adresse","failed":"\u00c9chou\u00e9","logo":"Logo","my_nfc_cards":"Mes cartes NFC","new_nfc_card":"Nouvelle carte NFC","nfc":"NFC","nfc_card":"Carte NFC","nfc_card_created_success":"Carte NFC cr\u00e9\u00e9e avec succ\u00e8s","nfc_card_deleted_success":"Carte NFC supprim\u00e9e avec succ\u00e8s","nfc_card_order_details":"D\u00e9tails de la commande de carte NFC","nfc_card_orders":"Commandes de cartes NFC","nfc_card_type":"Type de carte NFC","nfc_card_types":"Types de cartes NFC","nfc_card_updated_success":"Carte NFC mise \u00e0 jour avec succ\u00e8s","nfc_image":"Image de la carte","nfc_image_required":"Le champ Image NFC est obligatoire.","order":"commande","order_nfc":"Commander NFC","order_placed_success":"Commande pass\u00e9e avec succ\u00e8s","order_status":"Statut de la commande","order_status_update_success":"Statut de la commande mis \u00e0 jour avec succ\u00e8s","orders":"Ordres","orders_count":"Nombre de commandes","paid":"Pay\u00e9","payment_status":"Statut de paiement","payment_status_update_success":"Statut de paiement mis \u00e0 jour avec succ\u00e8s","pending":"En attente","razorpay_session_success":"Session RazorPay cr\u00e9\u00e9e avec succ\u00e8s","required_vcard":"Veuillez s\u00e9lectionner la Vcard","select_card":"Veuillez s\u00e9lectionner le type de carte","select_vcard":"S\u00e9lectionnez une vCard","sell_nfc_cards":"Vendre des cartes NFC","your_order_status_changed":"Le statut de votre commande a chang\u00e9"},"no_data":"Pas de donn\u00e9es disponibles","no_matching_records_found":"Aucun enregistrements correspondants trouv\u00e9s","notification":{"mark_all_as_read":"Tout marquer comme lu","notifications":"Avis","you_don`t_have_any_new_notification":"Vous n'avez aucune nouvelle notification"},"payment":{"cancelled":"ANNUL\u00c9","payment":"PAIEMENT","payment_cancel":"Annuler le paiement","payment_success":"Succ\u00e8s du paiement","payment_successful":"Paiement r\u00e9ussi"},"payment_method":"Mode de paiement","payment_type":"Type de paiement","placeholder":{"12_hour":"12 heures","24_hour":"24 heures","address_field":"Le champ Champ d'adresse est obligatoire.","agree_term":"Vous devez accepter les termes et conditions.","all_rights_reserve":"Tous les droits sont r\u00e9serv\u00e9s","app_name_required":"Le champ Nom de l'application est obligatoire","appointment_created":"Rendez-vous cr\u00e9\u00e9 avec succ\u00e8s.","cannot_switch_to_zero":"Impossible de passer au plan z\u00e9ro si l'essai est disponible\/ayant un plan payant qui est actuellement actif","choose_one_template":"Choisissez n'importe quel mod\u00e8le","copied_successfully":"Copi\u00e9 avec succ\u00e8s.","de_active":"D\u00e9sactiver","default_plan_can_not_be_delete":"Le plan par d\u00e9faut ne peut pas \u00eatre supprim\u00e9","email_already_subscribed":"L'e-mail est d\u00e9j\u00e0 inscrit.","email_verification":"Votre profil a \u00e9t\u00e9 mis a jour. Nous vous avons envoy\u00e9 un e-mail de v\u00e9rification. Veuillez v\u00e9rifier votre courrier modifi\u00e9.","enquiry_sent":"Enqu\u00eate envoy\u00e9e avec succ\u00e8s.","enter_valid_email":"Veuillez saisir un e-mail valide.","enter_your_email_to_reset":"Entrez votre e-mail pour r\u00e9initialiser votre mot de passe.","favicon_invalid":"Le favicon a des dimensions d'image non valides.","first_name_required":"Le champ Pr\u00e9nom est obligatoire.","forgot_your_password_no_problem":"Mot de passe oubli\u00e9? Aucun probl\u00e8me. Indiquez-nous simplement votre adresse e-mail et nous vous enverrons par e-mail un lien de r\u00e9initialisation de mot de passe qui vous permettra d'en choisir un nouveau.","gallery_created":"Galerie cr\u00e9\u00e9e avec succ\u00e8s","gallery_updated":"Galerie mise \u00e0 jour avec succ\u00e8s.","invalid_country_code":"Code pays invalide","invalid_number":"Num\u00e9ro invalide","lang_already_exists":" La langue existe d\u00e9j\u00e0.","language_save":"Langue enregistr\u00e9e avec succ\u00e8s.","last_name_required":"Le champ Nom de famille est obligatoire.","last_week":"La semaine derni\u00e8re","login_via_facebook":"Connectez-vous via Facebook","login_via_google":"Connectez-vous via Google","message_sent":"Message envoy\u00e9 avec succ\u00e8s.","multi_templates":"Plusieurs mod\u00e8les sont requis","paid_appointment_cant_delete":"Rendez-vous payant ne peut pas \u00eatre supprim\u00e9","password_character":"Le mot de passe doit comporter au moins 8 caract\u00e8res.","password_invalid":"Le mot de passe est invalide","password_is_correct":"Le mot de passe est correct","password_must_match":"Le mot de passe et la confirmation du mot de passe doivent correspondre.","passwords":"Le champ des mots de passe est obligatoire.","payment_cancel":"Votre paiement est annul\u00e9","payment_done":"Paiement effectu\u00e9 avec succ\u00e8s.","payment_not_complete":"Paiement non effectu\u00e9","payment_received":"Paiement re\u00e7u avec succ\u00e8s.","paypal_created":"Session Paypal cr\u00e9\u00e9e avec succ\u00e8s.","paypal_key":"Le champ cl\u00e9 Paypal est obligatoire.","paypal_mode":"Le champ Mode Paypal est obligatoire.","paypal_secret":"Le champ secret Paypal est obligatoire.","phone_number_required":"Le champ Num\u00e9ro de t\u00e9l\u00e9phone est obligatoire.","plan_already_used":"Plan d\u00e9j\u00e0 utilis\u00e9","plan_expire_notification":"Le champ Notification d'expiration du plan est obligatoire.","please_add_payment_credentials":"Veuillez ajouter des identifiants de paiement","privacy_policy":"La politique de confidentialit\u00e9 est obligatoire.","product_purchase":"Produit achet\u00e9 avec succ\u00e8s.","purchased_plan":"Rendez-vous cr\u00e9\u00e9 avec succ\u00e8s.","receive_latest_news":"Recevez les derni\u00e8res nouvelles, mises \u00e0 jour et bien d'autres choses chaque semaine.","registered_success":"Vous vous \u00eates inscrit avec succ\u00e8s, activez votre compte par e-mail.","required_captcha":"L\u00fctfen Captcha'y\u0131 Do\u011frulay\u0131n","role_created":"R\u00f4le cr\u00e9\u00e9 avec succ\u00e8s.","select_hour":"Veuillez s\u00e9lectionner la date ou l'heure","select_one_or_more":"S\u00e9lectionnez une ou plusieurs fonctionnalit\u00e9(s) requise(s)","short_code_only_alpha":"Le code abr\u00e9g\u00e9 ne doit contenir que des lettres de l'alphabet.","stripe_created":"Session Stripe cr\u00e9\u00e9e avec succ\u00e8s..","stripe_key":"Le champ cl\u00e9 Stripe est obligatoire.","stripe_secret":"Le champ Stripe secret est obligatoire.","subscribed_plan":"Vous avez souscrit \u00e0 ce plan avec succ\u00e8s.","subscribed_plan_wait":"Vous avez souscrit \u00e0 ce plan avec succ\u00e8s, mais attendez la confirmation de l'administrateur","subscribed_successfully":"Abonn\u00e9 avec succ\u00e8s.","subscription_date_updated":"Date d'abonnement mise \u00e0 jour avec succ\u00e8s.","successfully_verified":"Vous avez v\u00e9rifi\u00e9 votre courrier avec succ\u00e8s, veuillez vous connecter.","the_term_conditions":"Les conditions g\u00e9n\u00e9rales sont obligatoires.","there_is_not_available_slot":"Il n'y a pas de cr\u00e9neaux disponibles \u00e0 la date indiqu\u00e9e","this_currency_is_not_supported":"Cette devise n'est pas prise en charge par PayPal pour effectuer des paiements.","this_week":"Cette semaine","time_format":"Format de l'heure","too_long":"Trop long","too_short":"Trop court","unable_to_process_payment":"Impossible de traiter le paiement pour le moment. R\u00e9essayez plus tard.","upload_required":"Le champ de t\u00e9l\u00e9chargement de fichier est obligatoire.","valid_number":"Nombre valide","we_could_not_fb_id":"Nous n'avons pas pu trouver l'adresse e-mail dans votre compte Facebook","withdrawal_request_send":"Demande de retrait approuv\u00e9e avec succ\u00e8s.","your_mail_already_verified":"Votre e-mail est d\u00e9j\u00e0 v\u00e9rifi\u00e9, veuillez vous connecter."},"plan":{"We'll_never_share_your_email_with_anyone_else":"Nous ne partagerons jamais votre e-mail avec quelqu'un d'autre.","additional_domains":"Domaines suppl\u00e9mentaires","affiliation":"Affiliations","analytics":"Analytique","blog":"Blogues","currency":"Currency","custom_css":"CSS personnalis\u00e9","custom_fields":"Les champs personnalis\u00e9s","custom_js":"JavaScript personnalis\u00e9","custom_qrcode":"Code QR personnalis\u00e9","days":"Jours","default_Plan":"Forfait par d\u00e9faut","description":"La description","domains_limit":"Limite de domaines","duration":"Dur\u00e9e","duration_months":"Dur\u00e9e Mois","duration_years":"Dur\u00e9e Ann\u00e9es","edit_plan":"Modifier le forfait","email_address":"Adresse e-mail","enquiry_form":"formulaire","features":"Caract\u00e9ristiques","frequency":"La fr\u00e9quence","gallery":"Galerie","hide_branding":"Masquer la marque","is_trial":"Est le proc\u00e8s","make_default":"Faire d\u00e9faut","monthly":"Mensuel","months":"Mois","multi_templates":"Mod\u00e8les multiples","new_plan":"Nouveau plan","no_of_vcards":"Nombre de VCards","password_protection":"Mot de passe de protection","plan":"Planifier","plan_type":"Type de r\u00e9gime","portfolio":"Portefeuille","price":"Prix","products":"Des produits","products_&_services":"Produits","qrcode":"QR Code","remaining_balance":"Solde restant de Prev. Planifier","select_all_feature":"S\u00e9lectionner toutes les fonctionnalit\u00e9s","select_plan":"S\u00e9lectionnez le plan","sendemail":"Envoyer un e-mail","sendinvite":"Envoyer une invitation","seo":"r\u00e9f\u00e9rencement","services":"prestations de service","status":"Statut","testimonials":"T\u00e9moignages","total_custom_domains_limit":"Limite totale des domaines personnalis\u00e9s","trial_days":"Est le proc\u00e8s","unlimited":"Illimit\u00e9","valid_upto":"Valable jusqu'au","what_s_in_startup_plan":"Qu'y a-t-il dans le plan de d\u00e9marrage\u00a0?","yearly":"Annuel","years":"Ans"},"plan_expire":"Le forfait est expir\u00e9. Veuillez choisir un plan pour continuer le service.","plan_expire_notification":"Notification d'expiration du plan (en jours)","plans":"Des plans","product_details":"D\u00e9tails de la commande du produit","product_orders":"Commandes de produits","resend_verification_email":"Renvoyer l'e-mail de v\u00e9rification","reset_password":"r\u00e9initialiser le mot de passe","role":{"edit_role":"Modifier le r\u00f4le","name":"Nom","new_role":"Nouveau r\u00f4le","permissions":"Permissions","role_permissions":"Autorisations de r\u00f4le","select_all_permissions":"S\u00e9lectionner toutes les autorisations"},"roles":"Les r\u00f4les","sadmin_dashboard":{"contact":"N\u00b0 de contact","day":"Jour","email":"E-mail","income":"le revenu","month":"Mois","name":"Nom","plans_by_users":"Plans par utilisateurs","recent_users_registration":"Enregistrement des utilisateurs r\u00e9cents","registered_on":"Inscrit le","week":"La semaine"},"save":"Save","select_payment_type":"S\u00e9lectionnez la passerelle de paiement","services":"Prestations de service","setting":{"add_contact":"Ajouter aux contacts","address":"Adresse","affiliation_amount":"Montant d'affiliation","affiliation_withdraw":"L'affiliation se retire","app_logo":"Logo de l'application","app_name":"Nom de l'application","clinic_name":"Nom de la clinique","contact_information":"Coordonn\u00e9es","credentials":"Identifiants","currency":"Currency","currency_settings":"Param\u00e8tres de devise","default_currency_format":"Format de devise par d\u00e9faut","default_language":"Langage par d\u00e9faut","disable_landing_page":"D\u00e9sactiver la page de destination","enable_addcontact":"Activer Ajouter au contact","enable_affiliation":"Activer l'affiliation","enable_contact":"Activer les contacts","favicon":"Ic\u00f4ne de favori","front_page_enable":"Activer la page d'accueil","general":"G\u00e9n\u00e9ral","general_details":"D\u00e9tail g\u00e9n\u00e9rals","hide_stickybar":"Masquer la barre collante vCard","location_url":"URL de l'emplacement","manually":"Manuellement","note":"Remarque\u00a0: Le nom de l'ic\u00f4ne t\u00e9l\u00e9charg\u00e9e doit \u00eatre 'WeChat.png' \/ 'Tumbler.png' \/ 'XXX.png', lors du t\u00e9l\u00e9chargement du fichier .vcf, ce nom sera utilis\u00e9 comme \u00e9tiquette.","paypal":"Pay Pal","paypal_client_id":"Identifiant client Paypal","paypal_key":"Cl\u00e9 Paypal","paypal_mode":"Mode Paypal","paypal_payout_email":"E-mail de paiement Paypal","paypal_secret":"Secret Paypal","postal_code":"code postal","prefix":"Pr\u00e9fixe","razorpay":"Razorpay","razorpay_key":"Cl\u00e9 Razorpay","razorpay_secret":"Secret Razorpay","select_currency":"S\u00e9lectionnez la devise","setting":"R\u00e9glage","shipping_address":"adresse de livraison","specialities":"Sp\u00e9cialit\u00e9s","stripe":"Bande","stripe_key":"Cl\u00e9 \u00e0 rayures","stripe_secret":"Secret de la rayure","upgrade_database":"Mettre \u00e0 niveau la base de donn\u00e9es","user_default_language":"Langue par d\u00e9faut de l'utilisateur","whatsapp_share":"Partager WhatsApp","withdraw_transactions":"Retirer des transactions","withdrawals":"Retraits","wp_number":"Entrez le num\u00e9ro de t\u00e9l\u00e9phone."},"settings":"R\u00e9glages","sign_out":"Se d\u00e9connecter","social":{"Facebook":"Facebook","Instagram":"Instagram","Linkedin":"Linkedin","Pinterest":"Pinterest","Reddit":"Reddit","Share_on_email":"Partager par e-mail","Share_on_facebook":"Partager sur Facebook","Share_on_linkedin":"Partager sur Linkedin","Share_on_pinterest":"Partager sur Pinterest","Share_on_reddit":"Partager sur Reddit","Share_on_twitter":"Partager sur Twitter","Share_on_whatsapp":"Partager sur Whatsapp","Tiktok":"TIC Tac","Tumblr":"Tumblr","Twitter":"Twitter","Whatsapp":"Whatsapp","Youtube":"Youtube","map":"Carte","social_links":"Liens sociaux - Site Web","website":"Site Internet"},"state":{"country_name":"Nom du pays","edit_state":"Modifier l'\u00e9tat","new_state":"Nouvel \u00e9tat","no_state_available":"Aucun \u00e9tat disponible","no_state_found":"Aucun \u00e9tat trouv\u00e9","state":"\u00c9tat","state_name":"Nom d'\u00e9tat","states":"\u00c9tats"},"subscribe":"S'abonner","subscribed_plans":"Forfaits souscrits","subscribed_user":"Plans d'utilisateurs abonn\u00e9s","subscriber":"Les abonn\u00e9s","subscription":{"active_until":"Jusqu'\u00e0 actif","active_until_unlimited":"Actif jusqu'\u00e0 illimit\u00e9","amount":"Montant","buy_now":"Acheter maintenant","buy_product":"Acheter un produit","cancel_subscription":"Annuler l'abonnement","choose_plan":"Choisissez un forfait","current_expire":"Plan expir\u00e9 actuel","current_plan":"Plan actuel","currently_active":"Actuellement actif","end_date":"Date de fin","end_date_required":"Le champ Date de fin est obligatoire","expired":"Le plan est d\u00e9j\u00e0 expir\u00e9 le","expired_date":"Date d'expiration","free":"Lib\u00e9rer","has_already_been_subscribed":"est d\u00e9j\u00e0 abonn\u00e9","has_been_subscribed":"a \u00e9t\u00e9 abonn\u00e9","history":"Historique des abonnements","manage_subscription":"G\u00e9rer l'abonnement","no_plan_available":"Aucun forfait disponible","pay_or_switch_plan":"Payer\/changer de forfait","payable_amount":"Montant payable","payment":"Paiement","plan_name":"Nom du r\u00e9gime","plan_price":"Prix \u200b\u200bdu forfait","proceed_to_payment":"Proc\u00e9der au paiement","purchase":"Acheter","remaining":"Restant","remaining_balance":"Solde restant","remaining_days":"Jours restants","renew_free_plan":"Le plan gratuit ne peut pas \u00eatre renouvel\u00e9\/choisi \u00e0 nouveau","renew_plan":"Renouveler le forfait","start_date":"Date de d\u00e9but","subscribed_date":"Date d'inscription","subscribed_plan_details":"D\u00e9tails du plan souscrit","switch_plan":"Changer de forfait","total_days":"Nombre total de jours","trial_plan":"Programme d'essai","upgrade_plan":"Plan de mise \u00e0 niveau","used_balance":"Solde utilis\u00e9","used_days":"Jours d'utilisation"},"subscriptions":"Abonnements","testimonial":"T\u00e9moignages","to_time":"au temps","tooltip":{"about_description":"Maximum de 500\u00a0caract\u00e8res autoris\u00e9s","about_title":"Maximum 100 caract\u00e8res autoris\u00e9s","allowed_image":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","app_logo":"L'image doit \u00eatre de pixel 90 x 60","banner_title":"34 caract\u00e8res maximum autoris\u00e9s","cancel_app_logo":"Annuler le journal de l'application","cancel_cover":"Annuler la couverture","cancel_favicon_logo":"Annuler le favori","cancel_image":"Changer l'image","cancel_profile":"Annuler le profil","change_app_logo":"Changer le logo de l'application","change_favicon_logo":"Changer de favicon","change_icon":"changer d'ic\u00f4ne","copy":"Copier dans le presse-papier","cover":"Changer de couverture","custom_css":"Activer la possibilit\u00e9 d'ajouter du CSS personnalis\u00e9 pour chaque VCard.","custom_fonts":"Activer la possibilit\u00e9 d'ajouter des polices personnalis\u00e9es pour chaque VCard.","custom_js":"Activer la possibilit\u00e9 d'ajouter des js personnalis\u00e9s pour chaque VCard.","dark_mode":"Passer en mode sombre","enable_affiliation":"En l'activant, le lien d'affiliation sera visible par toutes vos vcards","enable_contact":"En activant cela, les coordonn\u00e9es seront visibles sur toutes vos Vcards","favicon_logo":"L'image doit \u00eatre de pixel 16 x 16","hide_branding":"Activer la possibilit\u00e9 de masquer la marque de la VCards.","hide_stickybar":"En activant ceci, les boutons collants des Vcards se cachent sur toutes vos Vcards","home_image":"La meilleure r\u00e9solution pour ce profil sera","image":"Changer l'image","light_mode":"Passer en mode lumi\u00e8re","password_protection":"Activer l'acc\u00e8s aux cartes virtuelles prot\u00e9g\u00e9es par mot de passe.","product_image":"La meilleure r\u00e9solution pour ce profil sera 250x250","profile":"Change de profil","remove_branding":"Si elle est activ\u00e9e, la vcard n'affichera pas la marque de notre site Web.","script":"Ajouter du code JS personnalis\u00e9 sans balise de script","sub_text":"Maximum 60 caract\u00e8res autoris\u00e9s","the_main_url":"L'URL principale \u00e0 partir de laquelle votre vcard pourra acc\u00e9der.","whatsapp_share":"En activant cela, le bouton WhatsApp Share sera visible sur toutes vos VCards"},"translation_manager":"Responsable de la traduction","type_in_script":"Tapez le code js dans la balise <script><\/script>","user":{"account":"Compte","account_setting":"Param\u00e8tres du compte","add_admin":"Ajouter un administrateur","add_user":"Ajouter un utilisateur","admin_details":"D\u00e9tails de l'administrateur","avatar":"Avatar","change_language":"Changer de langue","change_password":"Changer le mot de passe","confirm_password":"Confirmez le mot de passe","contact_no":"N\u00b0 de contact","contact_number":"Num\u00e9ro de contact","current_password":"Mot de passe actuel","edit_user":"Modifier l'utilisateur","email":"E-mail","email_verified":"Email verifi\u00e9","female":"Femelle","first_name":"Pr\u00e9nom","full_name":"Nom complet","impersonate":"Imiter","last_name":"Nom de famille","location":"Emplacement","male":"M\u00e2le","new_password":"nouveau mot de passe","overview":"Aper\u00e7u","password":"Mot de passe","phone":"T\u00e9l\u00e9phoner","profile":"Profil","profile_details":"D\u00e9tails du profil","registered_date":"Date d'enregistrement","return_to_admin":"Retour \u00e0 l'administrateur","save_changes":"Sauvegarder les modifications","setting":"Setting","theme_change":"Changement de mode de th\u00e8me","user_details":"D\u00e9tails de l'utilisateur","your_message":"Votre message","your_name":"votre nom"},"users":"utilisateurs","vcard":{"add_blog":"Ajouter un blog","add_gallery":"Ajouter une galerie","add_google_analytics":"Ajouter le code Google Analytics sans balise <script>","add_product":"Ajouter un produit","add_service":"Ajouter un service","add_testimonial":"Ajouter un t\u00e9moignage","advanced":"Avanc\u00e9e","affiliate_user":"Utilisateurs affili\u00e9s","alter_email_address":"Adresse e-mail de rechange","alter_mobile_number":"Num\u00e9ro de portable alternatif","alternate_email":"E-mail secondaire","alternative_phone":" Autre num\u00e9ro de t\u00e9l\u00e9phone","appointments":"Rendez-vous","back_color":"Couleur de l'arri\u00e8re plan","basic_details":"Basic Details","blog_details":"D\u00e9tails du blog","blog_icon":"Ic\u00f4ne de blog","blogs":"Blogues","buisness_hours":"HEURE DE TRAVAILS","business-hours":"Heures de travail","business_hours":"Heures de travail","company":"Soci\u00e9t\u00e9","contact":"Contact","copy_referral_link":"Copier le lien de parrainage","cover_image":"Image de couverture","created_at":"A cr\u00e9\u00e9 unt","created_on":"Cr\u00e9\u00e9 sur","custom-fonts":"Polices","custom_css":"CSS personnalis\u00e9","custom_fonts":"Polices","custom_js":"JavaScript personnalis\u00e9","date_of_birth":"Date de naissance","description":"La description","display_share_button":"Display share button","dob":"Date de naissance","download_my_qr_code":"T\u00e9l\u00e9charger mon code QR","download_vcard":"T\u00e9l\u00e9charger la VCard","duplicate_vcard":"Vcard en double\u00a0!","edit_blog":"Modifier le blog","edit_gallery":"Modifier la galerie","edit_product":"Modifier le produit","edit_service":"Modifier le service","edit_testimonial":"Edit Testimonial","edit_vcard":"Modifier la carte virtuelle","email_address":"Adresse e-mail","enable_download_qr_code":"Activer le t\u00e9l\u00e9chargement du code QR","enable_enquiry_form":"Activer le formulaire de demande","enter_password":"Entrer le mot de passe","first_name":"Pr\u00e9nom","flag":"Drapeau","galleries":"Galeries","gallery":"Galerie","google_analytics":"Google Analytics","google_config":"Param\u00e9trage Google","header":"Ent\u00eate","home_title":"Titre de la maison","image":"Image","is_manual_payment":"Est-ce que le guide de paiement manuel est activ\u00e9","job_title":"Titre d'emploi","language_enable":"langue activ\u00e9e","last_name":"Nom de famille","last_updated":"Derni\u00e8re mise \u00e0 jour","location":"Emplacement","manage-section":"G\u00e9rer la rubrique","manual_payment_guide":"Guide de paiement manuel","map":"Carte","meta_description":"Meta Description","meta_keyword":"M\u00e9ta-mot cl\u00e9","mobile_number":"Num\u00e9ro de portable","new_blog":"Nouveau blogue","new_gallery":"Nouvelle galerie","new_product":"Nouveau produit","new_service":"Nouveau Service","new_testimonial":"Nouveau t\u00e9moignage","new_vcard":"Nouvelle carte virtuelle","occupation":"Occupation","order_at":"Command\u00e9 \u00e0","our_service":"Nos services","payment_config":"Param\u00e9trage du paiement","preview_url":"URL d'aper\u00e7u","privacy_policy":"Politique de confidentialit\u00e9","product":"Produit","product_details":"Ic\u00f4ne du produit","product_icon":"Ic\u00f4ne du produit","product_name":"Nom du produit","product_transection":"Transactions de produits","products":"Des produits","profile_image":"Image de profil","qr_code":"QR Code","qr_code_download_size":"Taille de t\u00e9l\u00e9chargement du code QR","qrcode-customize":"Personnaliser le code QR","qrcode_color":"Couleur du code QR","qrcode_customize":"Personnaliser le code QR","qrcode_eye_style":"S\u00e9lectionnez le style des yeux","qrcode_style":"S\u00e9lectionnez Style","remove_branding":"Supprimer la marque","select_template":"S\u00e9lectionnez un mod\u00e8lee","send_message":"Envoyer le message","seo":"R\u00e9f\u00e9rencement","service_details":"D\u00e9tails des services","service_icon":"Ic\u00f4ne Service","services":"Prestations de service","share":"Partager","share_my_vcard":"Partager ma VCard","show_qr_code":"Afficher le code QR","site_title":"Titre du site","social-links":"Liens sociaux","social_links":"Liens sociaux","stats":"Statistiques","status":"Statut","template":"Mod\u00e8les de VCard","templates":"Mod\u00e8les de VCard","term-condition":"termes et conditions","term-policy":"Termes et politiques","term_condition":"termes et conditions","term_policy":"Termes et politiques","testimonial":"T\u00e9moignage","testimonial_details":"D\u00e9tails du t\u00e9moignage","testimonials":"T\u00e9moignages","theme_config":"Configuration du th\u00e8me","url_alias":"URL d'alias","user":"Utilisateurs","user_name":"Nom d'utilisateur","vcard":"carte virtuelle","vcard_details":"VCard Details","vcard_is_active":"La vcard est active","vcard_name":"Nom de la carte virtuelle","vcard_service":"Service VCard"},"vcard_11":{"Latest_post":"Derniers messages","contact_detail":"D\u00e9tails du contact","get_in_touch":"Entrer en contact","my_email":"Mon email","my_phones":"Mes t\u00e9l\u00e9phones","provide_service":"Fournir des services","read_more":"Lire la suite"},"vcards":"VCards","vcards_template":{"image":"Image","used_count":"Nombre d'occasions"},"vcards_templates":"Mod\u00e8les de cartes virtuelles","virtual_backgrounds":"Arri\u00e8re-plans virtuels","wait_for_apporove_of_cash_payment_by_admin":"Votre demande de transaction manuelle est en attente.","weekdays":{"fri":"VEN","mon":"LUN","sat":"Assis","sun":"SOLEIL","thu":"JEU","tue":"MAR","wed":"\u00c9POUSER"},"your":"Ton"},"fr.pagination":{"next":"Suivant &raquo;","previous":"&laquo; Pr\u00e9c\u00e9dent"},"fr.passwords":{"reset":"Votre mot de passe a \u00e9t\u00e9 r\u00e9initialis\u00e9!","sent":"Nous avons envoy\u00e9 votre lien de r\u00e9initialisation de mot de passe par e-mail\u00a0!","throttled":"Veuillez patienter avant de r\u00e9essayer.","token":"Ce jeton de r\u00e9initialisation de mot de passe n'est pas valide.","user":"Nous ne trouvons pas d'utilisateur avec cette adresse e-mail."},"fr.validation":{"accepted":"Le :attribute doit \u00eatre accept\u00e9.","active_url":"Le :attribute n'est pas une URL valide.","after":"Le :attribute doit \u00eatre une date apr\u00e8s :date.","after_or_equal":"Le :attribute doit \u00eatre une date post\u00e9rieure ou \u00e9gale \u00e0 :date.","alpha":"Le :attribute ne doit contenir que des lettres.","alpha_dash":"Le :attribute must only contain letters, numbers, dashes and underscores.","alpha_num":"Le :attribute ne doit contenir que des lettres et des chiffres.","array":"Le :attribute doit \u00eatre un tableau.","attributes":{"email":"Email","message":"Message","name":"Nom","phone":"T\u00e9l\u00e9phone","service_url":"Service URL"},"before":"Le :attribute doit \u00eatre une date avant :date.","before_or_equal":"Le :attribute doit \u00eatre une date ant\u00e9rieure ou \u00e9gale \u00e0 :date.","between":{"array":"Le :attribute doit avoir entre :min et :max \u00e9l\u00e9ments.","file":"Le :attribute doit \u00eatre compris entre :min et :max kilo-octets.","numeric":"Le :attribute doit \u00eatre compris entre :min et :max.","string":"Le :attribute doit \u00eatre compris entre :min et :max caract\u00e8res."},"boolean":"Le :attribute champ doit \u00eatre vrai ou faux.","confirmed":"Le :attribute la confirmation ne correspond pas.","coupon_code":{"expired":"Ce code promo est expir\u00e9","not_found":"Code promo introuvable"},"current_password":"Le mot de passe est incorrect.","custom":{"attribute-name":{"rule-name":"message personnalis\u00e9"}},"date":"Le :attribute is not a valid date.","date_equals":"Le :attribute doit \u00eatre une date \u00e9gale \u00e0 :date.","date_format":"Le :attribute ne correspond pas au format :format.","different":"Le :attribute et :other must be different.","digits":"Le :attribute doit \u00eatre :chiffres chiffres.","digits_between":"Le :attribute doit \u00eatre compris entre :min et :max chiffres.","dimensions":"Le :attribute a des dimensions d'image non valides","distinct":"Le :attribute le champ a une valeur en double.","email":"Le :attribute doit \u00eatre une adresse e-mail valides.","ends_with":"The :attribute must end with one of the following: :values.","exists":"Le choisi :attribute est invalide.","file":"Le :attribute doit \u00eatre un fichier.","filled":"Le :attribute le champ doit avoir une valeur.","gt":{"array":"Le :attribute doit avoir plus de :value \u00e9l\u00e9ments.","file":"Le :attribute doit \u00eatre sup\u00e9rieur \u00e0 :value kilo-octets.","numeric":"Le :attribute doit \u00eatre sup\u00e9rieur \u00e0 :value.","string":"Le :attribute doit \u00eatre sup\u00e9rieur \u00e0 :value personnages."},"gte":{"array":"Le :attribute must have :value articles ou plus.","file":"Le :attribute doit \u00eatre sup\u00e9rieur ou \u00e9gal :value kilo-octets.","numeric":"Le :attribute doit \u00eatre sup\u00e9rieur ou \u00e9gal :value.","string":"Le :attribute doit \u00eatre sup\u00e9rieur ou \u00e9gal :value personnages."},"image":"Le :attribute doit \u00eatre une image.","in":"Le choisi :attribute est invalide.","in_array":"Le :attribute le champ n'existe pas dans :other.","integer":"Le :attribute Doit \u00eatre un entier.","ip":"Le :attribute doit \u00eatre une adresse IP valide.","ipv4":"Le :attribute doit \u00eatre une adresse IPv4 valide.","ipv6":"Le :attribute doit \u00eatre une adresse IPv6 valide.","json":"Le :attribute doit \u00eatre une cha\u00eene JSON valide.","lt":{"array":"Le :attribute doit avoir moins de :value \u00e9l\u00e9ments.","file":"Le :attribute doit \u00eatre inf\u00e9rieur \u00e0 :value kilobytes.","numeric":"Le :attribute doit \u00eatre inf\u00e9rieur \u00e0 :value.","string":"Le :attribute doit \u00eatre inf\u00e9rieur \u00e0 :value personnages."},"lte":{"array":"Le :attribute ne doit pas avoir plus de :value \u00e9l\u00e9ments.","file":"Le :attribute must be less than or equal :value kilo-octets.","numeric":"Le :attribute must be less than or equal :value.","string":"Le :attribute doit \u00eatre inf\u00e9rieur ou equal :value personnages."},"max":{"array":"Le :attribute ne doit pas avoir plus de :max \u00e9l\u00e9ments.","file":"Le :attribute ne doit pas \u00eatre sup\u00e9rieur \u00e0 :max kilobytes.","numeric":"Le :attribute ne doit pas \u00eatre sup\u00e9rieur \u00e0 :max.","string":"Le :attribute ne doit pas \u00eatre sup\u00e9rieur \u00e0 :max personnages."},"mimes":"Le :attribute doit \u00eatre un fichier de taper: :values.","mimetypes":"Le :attribute doit \u00eatre un fichier de type: :values.","min":{"array":"Le :attribute doit avoir au moins :min \u00e9l\u00e9ments.","file":"Le :attribute doit \u00eatre au moins :min kilo-octets.","numeric":"Le :attribute doit \u00eatre au moins :min.","string":"Le :attribute doit contenir au moins :min caract\u00e8res."},"multiple_of":"Le :attribute doit \u00eatre un multiple de :value.","not_in":"Le choisi :attribute is invalid.","not_regex":"Le :attribute le format n'est pas valide.","numeric":"Le :attribute doit \u00eatre un nombre.","password":"Le password is incorrect.","present":"Le :attribute field must be present.","prohibited":"Le :attribute le terrain est interdit.","prohibited_if":"Le :attribute le champ est interdit lorsque :other vaut :value.","prohibited_unless":"Le :attribute le champ est interdit sauf si :other est dans :values.","regex":"Le :attribute format is invalid.","required":"Le :attribute Champ requis.","required_if":"Le :attribute champ est obligatoire lorsque :other vaut :value.","required_unless":"Le :attribute champ est obligatoire sauf si :other est dans :values.","required_with":"Le :attribute field is required when :values is present.","required_with_all":"Le :attribute le champ est obligatoire lorsque :des valeurs sont pr\u00e9sentes.","required_without":"Le :attribute field is required when :values is not present.","required_without_all":"Le :attributele champ est obligatoire lorsqu'aucune des :valeurs n'est pr\u00e9sente.","same":"Le :attribute et : autre doit correspondre.","size":{"array":"Le :attribute doit contenir :size \u00e9l\u00e9ments.","file":"Le :attribute doit \u00eatre :size kilo-octets.","numeric":"Le :attribute doit \u00eatre :size.","string":"Le :attribute doit \u00eatre :size personnages."},"starts_with":"Le :attribute doit commencer par l'un des \u00e9l\u00e9ments suivants: :values.","string":"Le :attribute doit \u00eatre une cha\u00eene.","timezone":"Le :attribute doit \u00eatre un fuseau horaire valide.","unique":"Le :attribute a d\u00e9j\u00e0 \u00e9t\u00e9 pris.","uploaded":"Le :attribute \u00e9chec du t\u00e9l\u00e9chargement.","url":"Le :attribute doit \u00eatre une URL valide.","uuid":"Le :attribute doit \u00eatre un UUID valide."},"hu.cookie-consent::texts":{"agree":"S\u00fctik enged\u00e9lyez\u00e9se","message":"A megfelel\u0151 \u00e9lm\u00e9ny biztos\u00edt\u00e1s\u00e1hoz s\u00fctikre van sz\u00fcks\u00e9g."},"hu.cookieConsent::texts":{"agree":"S\u00fctik enged\u00e9lyez\u00e9se","message":"A megfelel\u0151 \u00e9lm\u00e9ny biztos\u00edt\u00e1s\u00e1hoz s\u00fctikre van sz\u00fcks\u00e9g."},"id.cookie-consent::texts":{"agree":"Izinkan Cookies","message":"Pengalaman anda pada situs ini akan meningkat dengan cara mengizinkan cookies."},"id.cookieConsent::texts":{"agree":"Izikan Cookies","message":"Pengalaman anda pada situs ini akan meningkat dengan cara mengizinkan cookies."},"id.livewire-tables::strings":{"All":"Semua","All Columns":"Semua Kolom","Applied Filters":"Filter Diterapkan","Applied Sorting":"Penyortiran Diterapkan","Bulk Actions":"Aksi","Clear":"Bersihkan","Columns":"Kolom","Debugging Values":"Nilai Debug","Deselect All":"Batalkan Semua Pilihan","Done Reordering":"Selesai Mengurutkan Ulang","Filters":"Filter","No":"Tidak","No items found. Try to broaden your search.":"Tidak ada data yang ditemukan. Cobalah untuk memperluas pencarian Anda.","Remove filter option":"Hapus opsi filter","Remove sort option":"Hapus opsi pengurutan","Reorder":"Urutkan ulang","Search":"Cari","Select All":"Pilih Semua","Showing":"Menampilkan","Yes":"Ya","You are currently selecting all":"Anda sedang memilih semua","You are not connected to the internet.":"Anda sedang tidak terhubung ke internet.","You have selected":"Anda telah memilih","of":"dari","results":"hasil","row":"baris","rows":"baris","rows, do you want to select all":"baris, apakah Anda ingin memilih semua?","to":"ke"},"it.cookie-consent::texts":{"agree":"Consenti i cookies","message":"Questo sito utilizza i cookies per offrire un'esperienza migliore all'utente."},"it.cookieConsent::texts":{"agree":"Consenti i cookies","message":"Questo sito utilizza i cookies per offrire un'esperienza migliore all'utente."},"it.livewire-tables::strings":{"All":"Tutti","Applied Filters":"Filtri Applicati","Applied Sorting":"Ordinamento Applicato","Bulk Actions":"Azioni di Gruppo","Clear":"Pulisci","Columns":"Colonne","Done Reordering":"Ordinamento Terminato","Filters":"Filtri","No items found. Try to broaden your search.":"Nessun risultato trovato. Prova ad ampliare la tua ricerca.","Remove filter option":"Rimuovi filtro","Remove sort option":"Rimuovi ordinamento","Reorder":"Riordina","Search":"Cerca","Select All":"Seleziona Tutto","Showing":"Visualizzati","Unselect All":"Deseleziona tutto","You are currently selecting all":"Stai selezionando tutto","You are not connected to the internet.":"Non sei connesso a internet","You have selected":"Hai selezionato","of":"di","results":"risultati","rows":"righe","rows, do you want to select all":"righe, vuoi selezionarle tutte","to":"a"},"kr.cookie-consent::texts":{"agree":"\ucfe0\ud0a4 \ud5c8\uc6a9","message":"\ubcf4\ub2e4 \ub098\uc740 \uc0ac\uc6a9\uc790 \uacbd\ud5d8\uc744 \uc704\ud574 \ucfe0\ud0a4\ub97c \ud5c8\uc6a9\ud574 \uc8fc\uc2ed\uc2dc\uc694."},"kr.cookieConsent::texts":{"agree":"\ucfe0\ud0a4 \ud5c8\uc6a9","message":"\ubcf4\ub2e4 \ub098\uc740 \uc0ac\uc6a9\uc790 \uacbd\ud5d8\uc744 \uc704\ud574 \ucfe0\ud0a4\ub97c \ud5c8\uc6a9\ud574 \uc8fc\uc2ed\uc2dc\uc694."},"mk.cookie-consent::texts":{"agree":"\u0414\u043e\u0437\u0432\u043e\u043b\u0438","message":"\u0412\u0430\u0448\u0435\u0442\u043e \u0438\u0441\u043a\u0443\u0441\u0442\u0432\u043e \u043d\u0430 \u043e\u0432\u0430\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u045c\u0435 \u0441\u0435 \u043f\u043e\u0434\u043e\u0431\u0440\u0438 \u0441\u043e \u0434\u043e\u0437\u0432\u043e\u043b\u0443\u0432\u0430\u045a\u0435 \u043a\u043e\u043b\u0430\u0447\u0438\u045a\u0430"},"mk.cookieConsent::texts":{"agree":"\u0414\u043e\u0437\u0432\u043e\u043b\u0438","message":"\u0412\u0430\u0448\u0435\u0442\u043e \u0438\u0441\u043a\u0443\u0441\u0442\u0432\u043e \u043d\u0430 \u043e\u0432\u0430\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u045c\u0435 \u0441\u0435 \u043f\u043e\u0434\u043e\u0431\u0440\u0438 \u0441\u043e \u0434\u043e\u0437\u0432\u043e\u043b\u0443\u0432\u0430\u045a\u0435 \u043a\u043e\u043b\u0430\u0447\u0438\u045a\u0430"},"ms.livewire-tables::strings":{"All":"Semua","All Columns":"Semua Lajur","Applied Filters":"Tapisan Digunakan","Applied Sorting":"Susunan Digunakan","Bulk Actions":"Tindakan Pukal","Clear":"Kosongkan","Columns":"Kolum","Debugging Values":"Menyahpepijat Nilai","Deselect All":"Nyahpilih semua","Done Reordering":"Selesai Menyusun Semula","Filters":"Tapisan","No":"Tidak","No items found. Try to broaden your search.":"Tiada data ditemui. Sila perluaskan carian anda","Remove filter option":"Keluarkan pilihan tapisan","Remove sort option":"Keluarkan pilihan sususan","Reorder":"menyusun semula","Search":"Carian","Select All":"Pilih Semua","Showing":"Menunjukkan","Yes":"ya","You are currently selecting all":"Anda sedang memilih semua","You are not connected to the internet.":"Anda tidak disambungkan ke internet.","You have selected":"Anda telah memilih","of":"daripada","results":"keputusan","row":"barisan","rows":"barisan","rows, do you want to select all":"barisan, adakah anda mahu pilih semua?","to":"ke"},"nb.cookie-consent::texts":{"agree":"Tillat informasjonskapsler","message":"Din opplevelse p\u00e5 dette nettstedet vil bli forbedret ved \u00e5 tillate informasjonskapsler (cookies)."},"nb.cookieConsent::texts":{"agree":"Jeg forst\u00e5r","message":"Vi bruker informasjonskapsler (cookies) som lagres i nettleseren din n\u00e5r du bes\u00f8ker nettsiden v\u00e5r. Ved \u00e5 fortsette \u00e5 bes\u00f8ke nettsiden v\u00e5r eller bruke tjenestene v\u00e5re, godtar du at vi bruker informasjonskapsler."},"nl.cookie-consent::texts":{"agree":"Sta cookies toe","message":"Uw ervaring op deze site wordt verbeterd door het gebruik van cookies."},"nl.cookieConsent::texts":{"agree":"Sta cookies toe","message":"Uw ervaring op deze site wordt verbeterd door het gebruik van cookies."},"nl.livewire-tables::strings":{"All":"Alle","All Columns":"Alle kolommen","Applied Filters":"Toegepaste filters","Applied Sorting":"Toegepaste sortering","Bulk Actions":"Bulkacties","Clear":"Wissen","Columns":"Kolommen","Debugging Values":"Debugging waarden","Deselect All":"Alles deselecteren","Done Reordering":"Hersortering voltooid","Filters":"Filters","No":"Nee","No items found. Try to broaden your search.":"Geen items gevonden. Probeer uw zoekopdracht te verfijnen.","Remove filter option":"Filteroptie verwijderen","Remove sort option":"Sorteeroptie verwijderen","Reorder":"Hersorteren","Search":"Zoeken","Select All":"Alles selecteren","Select All On Page":"Alles op pagina selecteren","Showing":"Toont","Yes":"Ja","You are currently selecting all":"U selecteerde alle","You are not connected to the internet.":"U bent niet verbonden met het internet.","You have selected":"U selecteerde","of":"van","results":"resultaten","row":"rijen","rows":"rijen","rows, do you want to select all":"rijen, wilt u alles selecteren","to":"tot"},"oc.cookie-consent::texts":{"agree":"Autorizar los cookies","message":"V\u00f2stra experi\u00e9ncia sul site ser\u00e0 melhora en autorizant los cookies."},"pl.cookie-consent::texts":{"agree":"Zezwalaj na cookie","message":"Twoje do\u015bwiadczenia na tej witrynie b\u0119d\u0105 lepsze dzi\u0119ki cookies."},"pl.cookieConsent::texts":{"agree":"Zezwalaj na cookie","message":"Twoje do\u015bwiadczenia na tej witrynie b\u0119d\u0105 lepsze dzi\u0119ki cookies."},"pt.auth":{"about":"Cerca de","account_deactivate":"Sua conta est\u00e1 inativa no momento, entre em contato com o administrador.","app":{"create":"Crio","export":"Exportar","lock_account":"Bloquear conta","member_since":"Membro desde","messages":"Mensagens","online":"Conectados","print":"Imprimir","profile":"Perfil","reload":"recarregar","reset":"Redefinir","search":"Procurar","settings":"Configura\u00e7\u00f5es"},"choose_a_plan_that's_right_for_you":"Escolha um plano certo para voc\u00ea","confirm_password":"Confirme a Senha","contact":"Contato","copyright_by":"direitos autorais por","email":"E-mail","email_verify":"Por favor, verifique seu e-mail antes de fazer login.","emails":{"password":{"reset_link":"Clique aqui para redefinir sua senha"}},"failed":"Essas credenciais n\u00e3o correspondem aos nossos registros.","features":"Recursos","forgot_password":{"send_pwd_reset":"Enviar link de redefini\u00e7\u00e3o de senha","title":"Digite o e-mail para redefinir a senha"},"full_name":"Nome completo","get_started":"Iniciar","home":"Casa","let's_hear_what_they_say":"Vamos ouvir o que eles dizem","login":{"forgot_password":"Esqueci a minha senha","register_membership":"Registre uma nova associa\u00e7\u00e3o","title":"Fa\u00e7a login para iniciar sua sess\u00e3o"},"modern_&_powerful_interface":"Interface moderna e poderosa","password":"Senha","pricing":"Pre\u00e7os","register":"Registro","registration":{"have_membership":"Eu j\u00e1 tenho uma ades\u00e3o","i_agree":"eu concordo","terms":"os termos","title":"Registre um novo membroship"},"remember_me":"Lembre de mim","reset_password":{"reset_pwd_btn":"Redefinir senha","title":"Redefinir sua senha"},"sign_in":"Entrar","sign_out":"Sair","sign_up":"Inscrever-se","stories_from_our_customers":"Hist\u00f3rias de nossos clientes","subscribe_here":"Inscreva-se aqui","throttle":"Muitas tentativas de login. Por favor, tente novamente em: segundos segundos."},"pt.cookie-consent::texts":{"agree":"Aceitar","message":"Este site utiliza cookies. Ao navegar no site estar\u00e1 a consentir a sua utiliza\u00e7\u00e3o."},"pt.cookieConsent::texts":{"agree":"Aceitar","message":"Este site utiliza cookies. Ao navegar no site estar\u00e1 a consentir a sua utiliza\u00e7\u00e3o."},"pt.crud":{"action":"A\u00e7ao","add_new":"Add New","are_you_sure":"Tem certeza?","back":"Costas","cancel":"Cancelar","created_at":"Criado em","deleted_at":"Exclu\u00eddo em","detail":"Detalhe","edit":"Editar","id":"Eu ia","save":"Salve","updated_at":"Atualizado em"},"pt.livewire-tables::strings":{"All":"Tudo","Applied Filters":"Filtros Aplicados","Applied Sorting":"Ordena\u00e7\u00e3o Aplicada","Bulk Actions":"A\u00e7\u00f5es Massivas","Clear":"Limpar","Columns":"Colunas","Done Reordering":"Ordeana\u00e7\u00e3o finalizada","Filters":"Filtros","No items found. Try to broaden your search.":"Nenhum resultado encontrado. Tente ampliar a sua pesquisa.","Remove filter option":"Remover op\u00e7\u00e3o de filtro","Remove sort option":"Remover op\u00e7\u00e3o de ordena\u00e7\u00e3o","Reorder":"Reordenar","Search":"Pesquisar","Select All":"Seleccionar Tudo","Show":"Mostrar","Showing":"A mostrar","Unselect All":"Desmarcar Tudo","You are currently selecting all":"Atualmente est\u00e1 a selecionar tudo","You are not connected to the internet.":"N\u00e3o est\u00e1 ligado \u00e0 internet.","You have selected":"Selecionou","of":"de","results":"resultados","row":"linha","rows":"linhas","rows, do you want to select all":"linhas, pretende selecionar tudo","to":"a"},"pt.messages":{"Business_Beacon":"Business Beacon vCard","CEO\/CXO":"vCard de CEOs\/CXOs corporativos","Clean_Canvas":"Limpar tela vCard","Corporate_Classic":"vCard Cl\u00e1ssico Corporativo","Corporate_Connect":"vCard de conex\u00e3o corporativa","Corporate_Identity":"vCard de Identidade Corporativa","Culinary_Food_Services":"vCard de servi\u00e7os culin\u00e1rios e alimentares","Event_Management":"vCard de gerenciamento de eventos","Executive_Profile":"Perfil Executivo vCard","Fashion_Beauty":"Moda e Beleza vCard","Gym":"vCard de academia","Hospital":"vCard Hospitalar","Lawyer":"Advogado vCard","Manually":"Manualmente","Modern_Edge":"vCard Modern Edge","Paypal":"PayPal","Portfolio":"Portf\u00f3lio vCard","Pro_Network":"vCard de rede profissional","Professional":"vCard profissional","Programmer":"Programador vCard","Razorpay":"Razorpay","Receive_latest_news_update_and_many_other_things_every_week":"Receba as \u00faltimas not\u00edcias, atualiza\u00e7\u00f5es e muitas outras coisas todas as semanas.","Salon":"Sal\u00e3o vCard","Simple_Contact":"vCard de contato simples","Social_Media":"vCard de influenciadores de m\u00eddia social","Stripe":"Listra","Subscribe_Our_Newsletter":"Assine nossa newsletter","about_us":{"about_us":"Sobre n\u00f3s","description":"Descri\u00e7\u00e3o","image":"Sobre a imagem","title":"T\u00edtulo"},"admin":{"add_admin":"Adicionar administrador","admin":"Administrador","admin_created_successfully":"Administrador criado com sucesso.","admin_delete_successfully":"Administrador exclu\u00eddo com sucesso.","admin_details":"Detalhes do administrador","admin_updated_successfully":"Administrador atualizado com sucesso.","avatar":"Avatar","confirm_password":"Confirme a Senha","contact_number":"N\u00famero de contato","edit_admin":"Editar administrador","email":"E-mail","female":"F\u00eamea","first_name":"Primeiro nome","full_name":"Nome completo","gender":"G\u00eanero","last_name":"\u00daltimo nome","male":"Macho","not_allowed_to_access":"Parece que voc\u00ea n\u00e3o tem permiss\u00e3o para acessar este registro.","password":"Senha","profile":"Perfil","profile_details":"Detalhes de perfil"},"admins":"Administradores","affiliation":{"affiliate_note":"Observa\u00e7\u00e3o: os detalhes de sua afilia\u00e7\u00e3o ser\u00e3o publicados em sua p\u00e1gina vcards en bas. Se voc\u00ea se registrar via cella e obter uma assinatura ap\u00f3s o cella, voc\u00ea ser\u00e1 recompensado no valor de","affiliated_by":"Afiliado por","affiliation_transaction":"Transa\u00e7\u00e3o de afilia\u00e7\u00e3o","affiliation_withdraw_detail":"Detalhe de Retirada de Afilia\u00e7\u00e3o","affiliations":"Afilia\u00e7\u00f5es","approval_status":"Status de aprova\u00e7\u00e3o","approve":"Aprovar","approve_withdraw_request":"Aprovar solicita\u00e7\u00e3o de saque","approved":"Aprovado","cash_payment":"Pagamentos em esp\u00e9cie","current_amount":"Valor atual","reject":"Rejeitar","reject_withdraw_request":"Rejeitar Pedido de Retirada","rejected":"Rejeitado","rejection_note":"Nota de rejei\u00e7\u00e3o","total_affiliation_amount":"Valor total da afilia\u00e7\u00e3o","verify_paypal_email":"Verificar e-mail do Paypal","withdraw_amount":"Retirar montante","withdrawal":"Cancelamento"},"allowed_file_types":"Tipos de arquivo permitidos: png, jpg, jpeg.","analytic":{"vcard_analytic":"Vcard anal\u00edtico"},"analytics":{"browsers":"Navegadores","countries":"Pa\u00edses","devices":"Dispositivos","languages":"l\u00ednguas","os":"Sistemas operacionais","overview":"Vis\u00e3o geral","see_all":"Ver tudo","view_more":"Veja mais","visitors":"Visitantes"},"appointment":{"appointment":"Encontro","appointment_details":"Detalhes do compromisso","appointment_type":"Tipo de compromisso:","calendar":"Calend\u00e1rio","ends":"Compromisso termina","free":"Livre","paid":"Paga","starts":"In\u00edcio do compromisso"},"appointments":"compromissos","business":{"business_hours":"Hor\u00e1rio comercial","end_time":"Fim do tempo","fri":"Sex","mon":"seg","sat":"Sentado","start_time":"Hora de in\u00edcio","sun":"Domingo","thu":"Coletar","tue":"ter","wed":"Casar"},"by_signing_up_you_agree_to_our":"Ao se inscrever voc\u00ea concorda com nossos","cash_payment":"Pagamentos em esp\u00e9cie","city":{"cities":"Cidades","city":"Cidade","city_name":"Nome da Cidade","edit_city":"Editar cidade","new_city":"Nova cidade","no_city_available":"Nenhuma cidade dispon\u00edvel","no_city_found":"Nenhuma cidade encontrada","state_name":"Nome do Estado"},"common":{"Yes_Change":"sim, muda","action":"A\u00e7\u00e3o","active":"Ativo","add":"Adicionar","add_virtual_background":"Adicionar fundo virtual","allow_cookies":"Permitir cookies","already_have_an_account":"J\u00e1 tem uma conta","apply":"Aplicar","apply_changes":"Aplicar essas altera\u00e7\u00f5es","are_you_completed":"Tem certeza de que deseja alterar este status?","are_you_sure":"Tem certeza de que deseja excluir isso","are_you_sure_dublicate_vcard":"Tem certeza de que deseja duplicar este VCard?","back":"Costas","back_subscription":"Voltar para Assinaturas","cancel":"Cancelar","captcha_enable":"Habilitar Google Captcha","closed":"Fechados","completed":"conclu\u00eddo","cookie_banner_enabled":"Ativar banner de cookies","cookie_msg":"Sua experi\u00eancia neste site ser\u00e1 melhorada ao permitir cookies.","create_an_account":"Crie a sua conta aqui","currency_position":"Posi\u00e7\u00e3o da moeda","custom":"Personalizado","declined":"Decl\u00ednio","default_country_code":"C\u00f3digo de pa\u00eds padr\u00e3o","delete":"Excluir","deleted":"Exclu\u00eddo","description":"Descri\u00e7\u00e3o","details":"Detalhes","discard":"Descartar","download":"Download","duplicate":"Duplicado !","duplicate_vcard_create":"Vcard duplicado criado com sucesso","edit":"Editar","email":"E-mail","enable_cookie_banner":"Ativar banner de cookies","enable_page":"Ativar p\u00e1gina de destino","enable_register":"Ativar registro","enable_validation":"Ativar valida\u00e7\u00e3o","enquiry":"Inqu\u00e9ritos","error":"\u041e\u0448\u0438\u0431\u043a\u0430","filter":"Filtro","forgot_password":"Esqueceu a senha","forgot_your_password":"Esqueceu sua senha","from":"A partir de","has_been_completed":"Ele foi conclu\u00eddo.","has_been_deleted":"foi deletado.","icon":"\u00cdcone","inactive":"Inativo","infyvcard":"InfyVcard","is_active":"Est\u00e1 ativo","link":"Link","loading":"Carregando...","login":"Conecte-se","logout":"Sair","message":"Mensagem","name":"Nome","new_here":"Novo aqui","no":"N\u00e3o, Cancelar","no_data_available":"Nenhum dado dispon\u00edvel","notUsed":"Ainda n\u00e3o usado","ok":"OK","payment_methods":"Forma de pagamento","paypal_email":"Email do Paypal","pending":"Pendente","phone":"Telefone","phone_validation":"Valida\u00e7\u00e3o do n\u00famero de telefone","please_wait":"Por favor, aguarde......","price":"Pre\u00e7o","product_url":"URL do produto","register":"Registro","register_enable":"Habilitar registro","remember_me":"Lembre de mim","reset":"Redefinir","save":"Salve","service_url":"URL do servi\u00e7o","show_currency_behind":"Mostrar moeda atr\u00e1s","sign_in_here":"Fa\u00e7a login aqui","status":"Status","sub_text":"Sub-texto","subject":"Sujeito","submit":"Enviar","successful":"Bem-sucedida","to":"Para","today":"Hoje","today_appointments":"Compromissos de hoje","today_enquiry":"Consultas de hoje","total__active_vcards":"Total de cart\u00f5es ativos","total__deactive_vcards":"Total de VCards desativados","total_active_users":"Total de usu\u00e1rios ativos","total_amount":"Montante total","total_deactive_users":"Total de usu\u00e1rios desativados","total_plans":"Planos totais","total_users":"Total de usu\u00e1rios","total_vcards":"Total de VCcards","type":"Tipo","unavailable":"Indispon\u00edvel","upload_file":"Upload File","user":"Do utilizador","view":"Visualizar","virtual_note":"Nota: Fundos virtuais fornecer\u00e3o as imagens do cart\u00e3o de visita em que seu logotipo, nome, endere\u00e7o e telefone ser\u00e3o escritos. estamos exportando tamanhos padr\u00e3o de planos de fundo virtuais horizontais e verticais, o que ser\u00e1 \u00fatil quando voc\u00ea deseja projetar seu cart\u00e3o NFC, voc\u00ea pode fornecer essas imagens diretamente aos manipuladores de impress\u00e3o NFC. Al\u00e9m disso, voc\u00ea pode compartilhar isso com seus amigos diretamente ou defini-lo como uma imagem de perfil\/capa.","yes":"Sim, Excluir","yes_duplicate":"Sim, duplicado!"},"contact_us":{"contact":"Entre em contato conosco","contact_us":"Inqu\u00e9ritos","inquries":"Inqu\u00e9ritos","message":"Mensagem","send_message":"Enviar mensagem"},"copy_text":"c\u00f3pia de","country":{"countries":"Pa\u00edses","country":"Pa\u00eds","country_name":"Nome do pa\u00eds","edit_country":"Editar pa\u00eds","new_country":"Novo pa\u00eds","no_country_available":"Nenhum pa\u00eds dispon\u00edvel","no_country_found":"Nenhum pa\u00eds encontrado","phone_code":"C\u00f3digo do telefone","short_code":"C\u00f3digo curto"},"coupon_code":{"add_coupon_code":"Adicionar c\u00f3digo de cupom","apply_here":"Candidate-se aqui","coupon_code":"C\u00f3digo do cupom","coupon_code_applied":"C\u00f3digo do cupom aplicado com sucesso.","coupon_code_created":"C\u00f3digo do cupom criado com sucesso.","coupon_code_percent_validation":"O desconto do cupom n\u00e3o deve ser superior a 100%.","coupon_code_status_updated":"Status do c\u00f3digo do cupom atualizado com sucesso.","coupon_code_updated":"C\u00f3digo do cupom atualizado com sucesso.","coupon_codes":"C\u00f3digos de cupom","coupon_discount":"Cupom de desconto","coupon_name":"Nome do cupom","coupon_type":"Tipo de cupom","edit_coupon_code":"Editar c\u00f3digo de cupom","enter_coupon_code":"Digite o c\u00f3digo do cupom","enter_coupon_discount":"Digite cupom de desconto","enter_coupon_name":"Digite o nome do cupom","expire_at":"Expirar em","fixed":"Tipo Fixo","flat":"Plano","have_a_coupon_code":"Tem um c\u00f3digo de cupom?","percentage":"Percentagem","remove":"Remover"},"create_vcard":"Crie seu VCard","create_your_business_digital_card_with_lots_of_information":"Crie o seu cart\u00e3o digital de neg\u00f3cios com muita informa\u00e7\u00e3o","currency":{"currencies":"Moedas","currency_code":"C\u00f3digo da moeda","currency_icon":"\u00cdcone de moeda"},"dashboard":"Pain\u00e9is","date":"encontro","deactivate":"Desativar","e_card":{"add_ecard":"Adicionar cart\u00e3o eletr\u00f4nico","ecard":"cart\u00e3o eletr\u00f4nico","ecard_info":"A imagem deve ter pixel 150 x 150","ecard_logo":"logotipo do cart\u00e3o eletr\u00f4nico","ecards":"Cart\u00f5es Eletr\u00f4nicos"},"edit_subscription":"Editar plano de assinatura","email_not_found":"N\u00e3o conseguimos encontrar um usu\u00e1rio com esse endere\u00e7o de e-mail","email_password_reset_link":"Link de redefini\u00e7\u00e3o de senha de e-mail","enquiry":"Inqu\u00e9ritos","enquiry_detail":"Detalhes da consulta","expire_in":"O plano est\u00e1 prestes a expirar em","extra_scripts":"Scripts Extras","feature":{"affiliation":"Afilia\u00e7\u00e3o","analytics":"An\u00e1lise","appointments":"Compromissos","blog":"Blogue","custom_css":"CSS customizado","custom_fonts":"Fontes personalizadas","custom_js":"JS personalizado","custom_qrcode":"C\u00f3digo QR personalizado","description":"Descri\u00e7\u00e3o","edit_feature":"Editar recurso","enquiry_form":"Formul\u00e1rio de consulta","feature_image":"Imagem do recurso","gallery":"Galeria","hide_branding":"Ocultar marca","image":"Imagem","name":"Nome","order_nfc_card":"Encomendar cart\u00e3o NFC","password":"Prote\u00e7\u00e3o de senha","products":"Produtos","products_services":"Servi\u00e7os","seo":"Motor de Otimiza\u00e7\u00e3o de Busca","social_links":"Links sociais","testimonials":"Depoimentos"},"features":"Recursos","flash":{"about_us_create":"Sobre n\u00f3s salvo com sucesso.","can_not_change_time_format":"O compromisso j\u00e1 est\u00e1 agendado para este formato de hor\u00e1rio","city_create":"Cidade salva com sucesso.","city_update":"Cidade atualizada com sucesso.","country_create":"Pa\u00eds salvo com sucesso.","country_update":"Pa\u00eds atualizado com sucesso.","country_used":"Pa\u00eds j\u00e1 usado","create_blog":"Blog VCard criado com sucesso.","create_front_testimonial":"Testemunho criado com sucesso.","create_product":"Produto VCard criado com sucesso.","create_service":"Servi\u00e7o VCard criado com sucesso.","create_testimonial":"Depoimento VCard criado com sucesso.","current_invalid":"A senha atual \u00e9 inv\u00e1lida.","database_upgrade_succesfully":"Seu banco de dados foi atualizado com sucesso","decription_is_required":"O campo de descri\u00e7\u00e3o \u00e9 obrigat\u00f3rio","feature_update":"Recurso atualizado com sucesso.","front_cms":"Front CMS atualizado com sucesso.","language_update":"Idioma atualizado com sucesso.","mobile_validation":"Valida\u00e7\u00e3o m\u00f3vel atualizada com sucesso.","name_is_required":"O campo nome \u00e9 obrigat\u00f3rio","password_update":"Senha atualizada com sucesso.","plan_create":"Plano criado com sucesso.","plan_default":"Plano padr\u00e3o alterado com sucesso.","plan_status":"Status do plano atualizado com sucesso","plan_update":"Plano atualizado com sucesso.","reactive_account":"Reative sua conta do e-mail.","setting_update":"Configura\u00e7\u00f5es atualizadas com sucesso.","social_links_img_is_required":"A imagem de links sociais \u00e9 obrigat\u00f3ria","social_links_is_required":"links sociais s\u00e3o obrigat\u00f3rios","state_create":"Estado salvo com sucesso.","state_update":"Estado atualizado com sucesso.","state_used":"Estado j\u00e1 em uso","success_theme_update":"Tema atualizado com sucesso","update_blog":"Blog VCard atualizado com sucesso.","update_front_testimonial":"Testimonial updated successfully.","update_product":"Produto VCard atualizado com sucesso.","update_service":"Servi\u00e7o VCard atualizado com sucesso.","update_testimonial":"Depoimento VCard atualizado com sucesso.","user_create":"Usu\u00e1rio criado com sucesso.","user_profile":"Perfil de usu\u00e1rio atualizado com sucesso.","user_status":"Status do usu\u00e1rio atualizado com sucesso","user_update":"Usu\u00e1rio atualizado com sucesso.","vcard_create":"VCard criado com sucesso.","vcard_delete":"VCard exclu\u00eddo com sucesso.","vcard_retrieve":"VCard recuperado com sucesso","vcard_status":"Status do VCard atualizado com sucesso","vcard_update":"Atualizado com sucesso.","verified_email":"E-mail verificado com sucesso"},"font":{"font_family":"Fam\u00edlia de fontes","font_size":"Tamanho da fonte","font_size_in_px":"Tamanho da fonte em pixels","fonts":"Fonts","px":"px"},"form":{"DOB":"Digite a data de nascimento","allowed_vcard":"Digite o n\u00ba de Vcards permitidos","blog":"Digite o nome do blog","c_password":"Confirme a Senha","company":"Digite o nome da empresa","contact":"N\u00famero de telefone","css":"Insira CSS personalizado","description":"Insira a descri\u00e7\u00e3o do seu VCard","designation":"Insira a designa\u00e7\u00e3o","email":"Insira o endere\u00e7o de e-mail","enter_email":"Digite o e-mail","enter_name":"Insira o nome","enter_phone":"Digite o telefone","enter_trial":"Insira os dias de teste","f_name":"Introduza o primeiro nome","facebook":"URL Facebook","first_name":"Primeiro nome","google_analytics":"C\u00f3digo do Google Analytics","home_title":"Insira o t\u00edtulo inicial","instagram":"URL do Instagram","job":"Digite o cargo","js":"Insira Js personalizados","l_name":"Insira o \u00faltimo nomee","last_name":"\u00daltimo nome","linkedin":"URL do LinkedIn","location":"Digite a sua localiza\u00e7\u00e3o","location_url":"Insira o URL do seu local","mail":"E-mail","meta_description":"Insira a meta descri\u00e7\u00e3o","meta_keyword":"Insira a meta-palavra-chave","my_vcard_url":"meu-vcard-page-url","occupation":"Digite a Ocupa\u00e7\u00e3o","password":"Senha","phone":"Digite o n\u00famero de telefone","pick_date":"Escolha uma data","pinterest":"URL do Pinterest","plan_name":"Digite o nome do plano","price":"Insira o pre\u00e7o","product":"Digite o nome do produto","product_url":"Insira o URL do produto","reddit":"URL do Reddit","select_country":"Selecione o pais","select_currency":"Escolha a moeda","select_state":"Selecionar estado","service":"Digite o nome do servi\u00e7o","service_url":"Insira o URL do servi\u00e7o","short_description":"Insira uma breve descri\u00e7\u00e3o","site_title":"Digite o t\u00edtulo do site","testimonial":"Digite o nome do depoimento","tiktok":"Clique na URL","tumblr":"URL do Tumblr","twitter":"URL do Twitter","type_message":"Digite uma mensagem aqui...","vcard_name":"Digite o nome do VCard","website":"URL do site","whatsapp":"URL do Whatsapp","your_email":"Endere\u00e7o de e-mail","your_name":"Seu nome","youtube":"URL do Youtube"},"from_time":"De tempos","front":{"enter_your_email":"Digite seu e-mail","enter_your_message":"Digite sua mensagem","enter_your_name":"Digite seu nome","your_email_address":"Seu endere\u00e7o de email"},"front_cms":{"banner":"Imagem da faixa","description":"Descri\u00e7\u00e3o","front_cms":"CMS frontal","title":"T\u00edtulo"},"gallery":{"gallery_name":"Galeries","image":"Imagem","type":"Modelo","youtube":"Youtube"},"hour":"Hora","language":"L\u00edngua","languages":{"edit_language":"Editar idioma","edit_translation":"Editar tradu\u00e7\u00e3o","iso_code":"C\u00d3DIGO ISO","language":"L\u00edngua","languages":"l\u00ednguas","new_language":"Nova linguagem","translation":"Tradu\u00e7\u00e3o"},"made_by":"Feito por","made_by_url":"Feito por URL","mail":{"action_required":"Se voc\u00ea n\u00e3o criou uma conta, nenhuma a\u00e7\u00e3o adicional \u00e9 necess\u00e1ria.","appointment_time":"Hora do compromisso : ","approved_successfully":"Sua consulta foi aprovada com sucesso em","attachment":"Anexo","between":"entre","book_appointment":"Anota\u00e7\u00e3o de livro","book_successfully":"Seu compromisso reservado com sucesso em","booked_appointment_with_you":"agendado com voc\u00ea","email":"E-mail: ","hello":"Ol\u00e1,","hello!":"Ol\u00e1!","here_is_enquiry":"Aqui est\u00e1 um detalhe da consulta","messages":"Mensagem: ","name":"Nome: ","new_manual_payment_request":"Nova Solicita\u00e7\u00e3o de Pagamento Manual","new_nfc_order":"Voc\u00ea recebeu um novo pedido NFC de","notes":"Notas","password_change":"Sua senha foi alterada pelo administrador ","please_click":"Por favor, clique no bot\u00e3o abaixo para verificar seu endere\u00e7o de e-mail.","please_contact_your_admin":"Entre em contato com o administrador para obter uma nova senha.","regard":"Cumprimentos,","slot_text":"Se voc\u00ea estiver com problemas para clicar no bot\u00e3o \"Verificar endere\u00e7o de e-mail\", copie e cole o URL abaixo em seu navegador:","thanks_regard":"Obrigado e cumprimentos,","vcard_name":"Nome do VCard: ","verify_email":"Verificar endere\u00e7o de e-mail","whoops":"Opa!"},"make_appointment":"Marcar consulta","make_appointments":"Marque uma consulta","months":{"apr":"abril","aug":"agosto","dec":"dezembro","feb":"fevereiro","jan":"janeiro","jul":"julho","jun":"junho","mar":"mar\u00e7o","may":"Poderia","nov":"novembro","oct":"Outubro","sep":"setembro"},"nfc":{"Add_NFC_card_photos_and_set_prices":"Adicione fotos dos cart\u00f5es NFC e defina os pre\u00e7os.","Admin_Guide":"Guia do Administrador: Venda de Cart\u00f5es NFC","Browse_and_select_an_NFC_card":"Navegue e selecione um cart\u00e3o NFC.","Cancelled":"Cancelada","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"Escolha o seu vCard, o URL desse vCard ser\u00e1 gravado no cart\u00e3o NFC.","Confirm_the_order_and_make_a_payment":"Confirme o pedido e fa\u00e7a o pagamento.","Create_or_log_in_to_your_account":"Crie ou fa\u00e7a login na sua conta.","Delivered":"Entregue","Dispatch_the_NFC_cards_to_users":"Despache os cart\u00f5es NFC para os usu\u00e1rios.","How_it_works":"Como funciona?","Log_in_to_the_Admin_Dashboard":"Fa\u00e7a login no Painel de Administra\u00e7\u00e3o.","Pending":"Pendente","Ready To Ship":"Pronto para enviar","Receive_and enjoy your NFC card":"Receba e aproveite seu cart\u00e3o NFC.","Review_user_orders":"Rever pedidos de usu\u00e1rios","Shipped":"Enviado","User_Guide":"Guia do Usu\u00e1rio: Compra e Personaliza\u00e7\u00e3o de Cart\u00f5es NFC","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"Aguarde o administrador escrever a URL e despachar o cart\u00e3o.","Write_the_user_provided_URL_to_NFC_cards":"Escreva a URL fornecida pelo usu\u00e1rio nos cart\u00f5es NFC.","add_nfc_card":"Adicionar cart\u00e3o NFC","all":"Todos","cancel":"Cancelada","card_can_not_deleted":"O cart\u00e3o n\u00e3o pode ser exclu\u00eddo porque est\u00e1 vinculado a pedidos de clientes.","card_type":"Tipo de carta","company_name":"nome da empresa","designation":"Designa\u00e7\u00e3o","edit_nfc_card":"Editar cart\u00e3o NFC","enter_address":"Insira o endere\u00e7o","failed":"Fracassada","logo":"Logotipo","my_nfc_cards":"Meus cart\u00f5es NFC","new_nfc_card":"Novo cart\u00e3o NFC","nfc":"NFC","nfc_card":"Cart\u00e3o NFC","nfc_card_created_success":"Cart\u00e3o NFC criado com sucesso","nfc_card_deleted_success":"Cart\u00e3o NFC exclu\u00eddo com sucesso","nfc_card_order_details":"Detalhes do pedido do cart\u00e3o NFC","nfc_card_orders":"Pedidos de cart\u00e3o NFC","nfc_card_type":"Tipo de cart\u00e3o NFC","nfc_card_types":"Tipos de cart\u00e3o NFC","nfc_card_updated_success":"Cart\u00e3o NFC atualizado com sucesso","nfc_image":"Imagem do cart\u00e3o","nfc_image_required":"O campo Imagem NFC \u00e9 obrigat\u00f3rio.","order":"ordem","order_nfc":"Encomendar NFC","order_placed_success":"Pedido realizado com sucesso","order_status":"Status do pedido","order_status_update_success":"Status do pedido atualizado com sucesso","orders":"Pedidas","orders_count":"Contagem de pedidos","paid":"Pago","payment_status":"Status do pagamento","payment_status_update_success":"Status de pagamento atualizado com sucesso","pending":"Pendente","razorpay_session_success":"Sess\u00e3o RazorPay criada com sucesso","required_vcard":"Selecione Vcard","select_card":"Selecione o tipo de cart\u00e3o","select_vcard":"Selecione vCard","sell_nfc_cards":"Venda cart\u00f5es NFC","your_order_status_changed":"O status do seu pedido foi alterado"},"no_data":"Nenhum dado dispon\u00edvel","no_matching_records_found":"Nenhum registro correspondente encontrado","notification":{"mark_all_as_read":"Marcar tudo como lido","notifications":"Notifica\u00e7\u00f5es","you_don`t_have_any_new_notification":"Voc\u00ea n\u00e3o tem nenhuma nova notifica\u00e7\u00e3o"},"payment":{"cancelled":"CANCELADO","payment":"FORMA DE PAGAMENTO","payment_cancel":"Cancelamento de pagamento","payment_success":"Sucesso do pagamento","payment_successful":"Pagamento bem-sucedido"},"payment_method":"Forma de pagamento","payment_type":"Tipo de pagamento","placeholder":{"12_hour":"12 horas","24_hour":"24 horas","address_field":"O campo Campo de endere\u00e7o \u00e9 obrigat\u00f3rio.","agree_term":"Vous devez accepter les termes et conditions.","all_rights_reserve":"Todos os direitos reservados","app_name_required":"O campo Nome do aplicativo \u00e9 obrigat\u00f3rio","appointment_created":"Compromisso criado com sucesso.","cannot_switch_to_zero":"N\u00e3o \u00e9 poss\u00edvel mudar para o plano zero se a avalia\u00e7\u00e3o estiver dispon\u00edvel \/ se tiver um plano pago que esteja ativo no momento","choose_one_template":"Escolha qualquer modelo","copied_successfully":"Copiado com sucesso.","de_active":"Desativar","default_plan_can_not_be_delete":"Plano padr\u00e3o n\u00e3o pode ser exclu\u00eddo","email_already_subscribed":"O e-mail j\u00e1 est\u00e1 inscrito.","email_verification":"Seu perfil foi atualizado. Enviamos para voc\u00ea um e-mail de verifica\u00e7\u00e3o. Verifique seu e-mail alterado.","enquiry_sent":"Consulta enviada com sucesso.","enter_valid_email":"Por favor, digite um e-mail v\u00e1lido.","enter_your_email_to_reset":"Insira seu e-mail para redefinir sua senha.","favicon_invalid":"O favicon tem dimens\u00f5es de imagem inv\u00e1lidas.","first_name_required":"O campo Nome \u00e9 obrigat\u00f3rio.","forgot_your_password_no_problem":"Esqueceu sua senha? Sem problemas. Basta nos informar seu endere\u00e7o de e-mail e n\u00f3s lhe enviaremos um link de redefini\u00e7\u00e3o de senha que permitir\u00e1 que voc\u00ea escolha uma nova.","gallery_created":"Galeria criada com sucesso.","gallery_updated":"Galeria atualizada com sucesso.","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","lang_already_exists":" A linguagem j\u00e1 existe.","language_save":"Idioma salvo com sucesso.","last_name_required":"O campo Sobrenome \u00e9 obrigat\u00f3rio.","last_week":"Semana passada","login_via_facebook":"Entrar pelo Facebook","login_via_google":"Entrar pelo Google","message_sent":"Mensagem enviada com sucesso.","multi_templates":"V\u00e1rios modelos s\u00e3o obrigat\u00f3rios","paid_appointment_cant_delete":"Agendamento pago n\u00e3o pode ser exclu\u00eddo","password_character":"A senha deve ter pelo menos 8 caracteres.","password_invalid":"Senha \u00e9 inv\u00e1lida","password_is_correct":"A senha est\u00e1 correta","password_must_match":"A senha e a confirma\u00e7\u00e3o da senha devem corresponder.","passwords":"O campo de senhas \u00e9 obrigat\u00f3rio.","payment_cancel":"Seu pagamento foi cancelado","payment_done":"Pagamento realizado com sucesso.","payment_not_complete":"Pagamento n\u00e3o conclu\u00eddo","payment_received":"Pagamento recebido com sucesso.","paypal_created":"Sess\u00e3o Paypal criada com sucesso.","paypal_key":"O campo chave do Paypal \u00e9 obrigat\u00f3rio.","paypal_mode":"O campo do modo Paypal \u00e9 obrigat\u00f3rio.","paypal_secret":"O campo secreto do Paypal \u00e9 obrigat\u00f3rio.","phone_number_required":"O campo N\u00famero de telefone \u00e9 obrigat\u00f3rio.","plan_already_used":"Plano j\u00e1 em uso","plan_expire_notification":"O campo Notifica\u00e7\u00e3o de Expira\u00e7\u00e3o do Plano \u00e9 obrigat\u00f3rio.","please_add_payment_credentials":"Por favor, adicione credenciais de pagamento","privacy_policy":"A Pol\u00edtica de Privacidade \u00e9 necess\u00e1ria.","product_purchase":"Produto adquirido com sucesso.","purchased_plan":"Voc\u00ea compra este plano com sucesso.","receive_latest_news":"Receba as \u00faltimas not\u00edcias, atualiza\u00e7\u00f5es e muitas outras coisas toda semana.","registered_success":"Voc\u00ea se registrou com sucesso, ative sua conta do e-mail.","required_captcha":"Verifique o Captcha","role_created":"Fun\u00e7\u00e3o criada com sucesso.","select_hour":"Por favor, selecione a data ou hora","select_one_or_more":"Selecione um ou mais Recurso \u00e9 obrigat\u00f3rio","short_code_only_alpha":"\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u043a\u043e\u0434 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u0431\u0443\u043a\u0432 \u0430\u043b\u0444\u0430\u0432\u0438\u0442\u0430.","stripe_created":"Sess\u00e3o Stripe criada com sucesso.","stripe_key":"O campo chave de distribui\u00e7\u00e3o \u00e9 obrigat\u00f3rio.","stripe_secret":"O campo secreto de distribui\u00e7\u00e3o \u00e9 obrigat\u00f3rio.","subscribed_plan":"Voc\u00ea assinou este plano com sucesso.","subscribed_plan_wait":"Voc\u00ea assinou este plano com sucesso, mas aguarda a confirma\u00e7\u00e3o do administrador","subscribed_successfully":"Subscrito com sucesso.","subscription_date_updated":"Data de assinatura atualizada com sucesso.","successfully_verified":"Voc\u00ea verificou seu e-mail com sucesso, fa\u00e7a o login.","the_term_conditions":"Os Termos e Condi\u00e7\u00f5es s\u00e3o obrigat\u00f3rios.","there_is_not_available_slot":"N\u00e3o h\u00e1 vagas dispon\u00edveis em determinada data","this_currency_is_not_supported":"Esta moeda n\u00e3o \u00e9 suportada pelo PayPal para efetuar pagamentos.","this_week":"Essa semana","time_format":"Formato de hora","too_long":"Demasiado longo","too_short":"Curto demais","unable_to_process_payment":"N\u00e3o \u00e9 poss\u00edvel processar o pagamento no momento. Tente mais tarde.","upload_required":"O campo de upload de arquivo \u00e9 obrigat\u00f3rio.","valid_number":"N\u00famero v\u00e1lido","we_could_not_fb_id":"N\u00e3o foi poss\u00edvel encontrar o endere\u00e7o de e-mail em sua conta do Facebook","withdrawal_request_send":"Solicita\u00e7\u00e3o de saque Aprovada com sucesso.","your_mail_already_verified":"Seu e-mail j\u00e1 foi verificado, fa\u00e7a o login."},"plan":{"We'll_never_share_your_email_with_anyone_else":"Nunca compartilharemos seu e-mail com mais ningu\u00e9m.","additional_domains":"Dom\u00ednios adicionais","affiliation":"Afilia\u00e7\u00f5es","analytics":"An\u00e1lise","blog":"Blogues","currency":"Moeda","custom_css":"CSS customizado","custom_fields":"Os campos personalizados","custom_js":"JS personalizado","custom_qrcode":"C\u00f3digo QR personalizado","days":"Dias","default_Plan":"Plano padr\u00e3o","description":"Descri\u00e7\u00e3o","domains_limit":"Limite de dom\u00ednios","duration":"Dura\u00e7\u00e3o","duration_months":"Dura\u00e7\u00e3o Meses","duration_years":"Dura\u00e7\u00e3o Anos","edit_plan":"Editar plano","email_address":"Endere\u00e7o de email","enquiry_form":"Formul\u00e1rio de consulta","features":"Recursos","frequency":"Frequ\u00eancia","gallery":"Galeria","hide_branding":"Ocultar marca","is_trial":"Teste","make_default":"Tornar padr\u00e3o","monthly":"Por m\u00eas","months":"Meses","multi_templates":"V\u00e1rios modelos","new_plan":"Novo plano","no_of_vcards":"N\u00ba de VCards","password_protection":"Prote\u00e7\u00e3o de senha","plan":"Plano","plan_type":"Tipo de plano","portfolio":"Portf\u00f3lio","price":"Pre\u00e7o","products":"Produtos","products_&_services":"Produtos e servi\u00e7os","qrcode":"C\u00f3digo QR","remaining_balance":"Saldo Restante do Prev. Plano","select_all_feature":"Selecionar todos os recursos","select_plan":"Selecione o plano","sendemail":"Enviar email","sendinvite":"Mandar convite","seo":"Motor de Otimiza\u00e7\u00e3o de Busca","services":"Servi\u00e7os","status":"status","testimonials":"Depoimentos","total_custom_domains_limit":"Limite total de dom\u00ednios personalizados","trial_days":"Dias de teste","unlimited":"Ilimitado","valid_upto":"V\u00e1lido at\u00e9","what_s_in_startup_plan":"O que est\u00e1 no Plano Inicial?","yearly":"Anual","years":"Anos"},"plan_expire":"O plano expirou. Escolha um plano para continuar o servi\u00e7o.","plan_expire_notification":"Notifica\u00e7\u00e3o de expira\u00e7\u00e3o do plano (em dias)","plans":"Planos","product_details":"Detalhes do pedido do produto","product_orders":"Pedidos de produtos","resend_verification_email":"Reenviar email de verifica\u00e7\u00e3o","reset_password":"Redefinir senha","role":{"edit_role":"Editar fun\u00e7\u00e3o","name":"Nome","new_role":"Novo papel","permissions":"Permiss\u00f5es","role_permissions":"Permiss\u00f5es de fun\u00e7\u00e3o","select_all_permissions":"Selecionar todas as permiss\u00f5es"},"roles":"Fun\u00e7\u00f5es","sadmin_dashboard":{"contact":"N\u00ba de contato","day":"Dia","email":"E-mail","income":"renda","month":"M\u00eas","name":"Nome","plans_by_users":"Planos por usu\u00e1rios","recent_users_registration":"Registro de usu\u00e1rios recentes","registered_on":"Registrado em","week":"Semana"},"save":"Save","select_payment_type":"Selecione o gateway de pagamento","services":"Servi\u00e7os","setting":{"add_contact":"Adicionar aos contatos","address":"Endere\u00e7o","affiliation_amount":"Valor da afilia\u00e7\u00e3o","affiliation_withdraw":"Retirada de afilia\u00e7\u00e3o","app_logo":"Logotipo do aplicativo","app_name":"Nome do aplicativo","clinic_name":"Nome da Cl\u00ednica","contact_information":"Informa\u00e7\u00f5es de contato","credentials":"Credenciais","currency":"Moeda","currency_settings":"Configura\u00e7\u00f5es de moeda","default_currency_format":"Formato de moeda padr\u00e3o","default_language":"Idioma padr\u00e3o","disable_landing_page":"Desativar p\u00e1gina de destino","enable_addcontact":"Ativar Adicionar ao contato","enable_affiliation":"Ativar afilia\u00e7\u00e3o","enable_contact":"Ativar contato","favicon":"Favicon","front_page_enable":"Ativar p\u00e1gina inicial","general":"Em geral","general_details":"Detalhes Gerais","hide_stickybar":"Ocultar barra adesiva de vCard","location_url":"URL do local","manually":"manualmente","note":"Observa\u00e7\u00e3o: o nome do \u00edcone carregado deve ser \"WeChat.png\" \/ \"Tumbler.png\" \/ \"XXX.png\". Ao baixar o arquivo .vcf, esse nome ser\u00e1 usado como r\u00f3tulo","paypal":"Paypal","paypal_client_id":"ID do cliente Paypal","paypal_key":"Chave Paypal","paypal_mode":"Modo Paypal","paypal_payout_email":"E-mail de Pagamento Paypal","paypal_secret":"Segredo do Paypal","postal_code":"C\u00f3digo postal","prefix":"Prefixo","razorpay":"Razorpay","razorpay_key":"Chave Razorpay","razorpay_secret":"Segredo Razorpay","select_currency":"Escolha a moeda","setting":"Contexto","shipping_address":"Endere\u00e7o para envio","specialities":"Especialidades","stripe":"Listra","stripe_key":"Chave de faixa","stripe_secret":"Segredo da Faixa","upgrade_database":"Atualizar banco de dados","user_default_language":"Idioma padr\u00e3o do usu\u00e1rio","whatsapp_share":"Compartilhar WhatsApp","withdraw_transactions":"Retirar transa\u00e7\u00f5es","withdrawals":"Retiradas","wp_number":"Digite o n\u00famero do telefone"},"settings":"Configura\u00e7\u00f5es","sign_out":"Sair","social":{"Facebook":"Facebook","Instagram":"Instagram","Linkedin":"Linkedin","Pinterest":"Pinterest","Reddit":"Reddit","Share_on_email":"Compartilhar por e-mail","Share_on_facebook":"Compartilhar no Facebook","Share_on_linkedin":"Compartilhe no LinkedinLinkedin","Share_on_pinterest":"Compartilhe no Pinterest","Share_on_reddit":"Compartilhar no Reddit","Share_on_twitter":"Compartilhar no Twitter","Share_on_whatsapp":"Compartilhe no Whatsapp","Tiktok":"Tiktok","Tumblr":"Tumblr","Twitter":"Twitter","Whatsapp":"Whatsapp","Youtube":"Youtube","map":"Mapa","social_links":"Links sociais - Site","website":"Local na rede Internet"},"state":{"country_name":"Nome do pa\u00eds","edit_state":"Editar estado","new_state":"Novo estado","no_state_available":"Nenhum estado dispon\u00edvel","no_state_found":"Nenhum estado encontrado","state":"Estado","state_name":"Nome do Estado","states":"Estados"},"subscribe":"Se inscrever","subscribed_plans":"Planos Subscritos","subscribed_user":"Planos de usu\u00e1rios inscritos","subscriber":"Assinantes","subscription":{"active_until":"Ativo at\u00e9","active_until_unlimited":"Ativo at\u00e9 Ilimitado","amount":"Montante","buy_now":"Comprar agora","buy_product":"Comprar Produto","cancel_subscription":"Cancelar assinatura","choose_plan":"Escolha o plano","current_expire":"Plano Expirado Atual","current_plan":"Plano atual","currently_active":"Atualmente ativo","end_date":"Data final","end_date_required":"O campo de data de t\u00e9rmino \u00e9 obrigat\u00f3rio","expired":"O plano j\u00e1 expirou em","expired_date":"Data expirada","free":"Livre","has_already_been_subscribed":"j\u00e1 est\u00e1 inscrito","has_been_subscribed":"foi inscrito","history":"Hist\u00f3rico de assinaturas","manage_subscription":"Gerenciar assinatura","no_plan_available":"Nenhum plano dispon\u00edvel","pay_or_switch_plan":"Pagar \/ Mudar de Plano","payable_amount":"Valor a pagar","payment":"Pagamento","plan_name":"Nome do plano","plan_price":"Pre\u00e7o do plano","proceed_to_payment":"Prossiga para o pagamento","purchase":"Comprar","remaining":"Remanescente","remaining_balance":"Saldo remanescente","remaining_days":"Dias restantes","renew_free_plan":"O Plano Gratuito n\u00e3o pode ser renovado\/escolhido novamente","renew_plan":"Renovar Plano","start_date":"Data de in\u00edcio","subscribed_date":"Data de assinatura","subscribed_plan_details":"Detalhes do plano subscrito","switch_plan":"Mudar de plano","total_days":"Total de dias","trial_plan":"Plano de teste","upgrade_plan":"Plano de atualiza\u00e7\u00e3o","used_balance":"Saldo usado","used_days":"Dias usados"},"subscriptions":"Assinaturas","testimonial":"Depoimentos","to_time":"ao tempo","tooltip":{"about_description":"M\u00e1ximo de 500 caracteres permitidos","about_title":"M\u00e1ximo de 100 caracteres permitidos","allowed_image":"Tipos de arquivo permitidos: png, jpg, jpeg.","app_logo":"A imagem deve ser de pixel 90 x 60","banner_title":"M\u00e1ximo de 34 caracteres permitidos","cancel_app_logo":"Cancelar logotipo do aplicativo","cancel_cover":"Cancelar capa","cancel_favicon_logo":"Cancelar favicon","cancel_image":"Cancelar imagem","cancel_profile":"Cancelar perfil","change_app_logo":"Alterar logotipo do aplicativo","change_favicon_logo":"Alterar favicon","change_icon":"\u00edcone de mudan\u00e7a","copy":"Copiar para \u00e1rea de transfer\u00eancia","cover":"Alterar capa","custom_css":"Habilite a capacidade de adicionar CSS personalizado para cada VCard.","custom_fonts":"Habilite a capacidade de adicionar fontes personalizadas para cada VCard.","custom_js":"Habilite a capacidade de adicionar js personalizados para cada VCard.","dark_mode":"Mudar para o modo escuro","enable_affiliation":"Ao habilitar isso, o link de afilia\u00e7\u00e3o ficar\u00e1 vis\u00edvel para todos os seus vcards","enable_contact":"Ao habilitar isso, os detalhes de contato ficar\u00e3o vis\u00edveis em todos os seus Vcards ","favicon_logo":"A imagem deve ser de pixel 16 x 16","hide_branding":"Habilite a capacidade de ocultar a marca dos VCards.","hide_stickybar":"Ao habilitar isso, oculte os bot\u00f5es fixos dos Vcards em todos os seus Vcards ","home_image":"A melhor resolu\u00e7\u00e3o para este perfil ser\u00e1","image":"Alterar imagem","light_mode":"Mudar para o modo de luz","password_protection":"Habilite o acesso a VCards protegidos por senha.","product_image":"A melhor resolu\u00e7\u00e3o para este perfil ser\u00e1 250x250","profile":"Mudar perfil","remove_branding":"Se ativado, o vcard n\u00e3o mostrar\u00e1 a marca do nosso site.","script":"Adicionar c\u00f3digo JS personalizado sem tag de script","sub_text":"M\u00e1ximo de 60 caracteres permitidos","the_main_url":"A URL principal a partir da qual seu vcard poder\u00e1 ser acessado.","whatsapp_share":"Ao habilitar isso, o bot\u00e3o Compartilhar do WhatsApp ficar\u00e1 vis\u00edvel em todos os seus VCards"},"translation_manager":"Gerente de tradu\u00e7\u00e3o","type_in_script":"Digite o c\u00f3digo js dentro da tag <script><\/script>","user":{"account":"Conta","account_setting":"Configura\u00e7\u00f5es de Conta","add_admin":"Adicionar administrador","add_user":"Adicionar usu\u00e1rio","admin_details":"Detalhes do administrador","avatar":"Avatar","change_language":"Mudar idioma","change_password":"Alterar a senha","confirm_password":"Confirme a Senha","contact_no":"N\u00ba de contato","contact_number":"N\u00famero de contato","current_password":"Senha atual","edit_user":"Editar usu\u00e1rio","email":"E-mail","email_verified":"email verificado","female":"F\u00eamea","first_name":"Primeiro nome","full_name":"Nome completo","impersonate":"Personificar","last_name":"\u00daltimo nome","location":"Localiza\u00e7\u00e3o","male":"Macho","new_password":"Nova Senha","overview":"Vis\u00e3o geral","password":"Senha","phone":"Telefone","profile":"Perfil","profile_details":"Detalhes de perfil","registered_date":"Data de registro","return_to_admin":"Return to Admin","save_changes":"Salvar altera\u00e7\u00f5es","setting":"Contexto","theme_change":"Altera\u00e7\u00e3o do modo de tema","user_details":"Detalhes do usuario","your_message":"Sua mensagem","your_name":"Seu nome"},"users":"Comercial","vcard":{"add_blog":"Adicionar blog","add_gallery":"Adicionar galeria","add_google_analytics":"Adicione o c\u00f3digo do Google Analytics sem a tag <script>","add_product":"Adicionar produto","add_service":"Adicionar servi\u00e7o","add_testimonial":"Adicionar depoimento","advanced":"Avan\u00e7ado","affiliate_user":"Usu\u00e1rios afiliados","alter_email_address":"Endere\u00e7o de e-mail alternativo","alter_mobile_number":"N\u00famero de celular alternativo","alternate_email":"E-mail alternativo","alternative_phone":"  Telefone Alternativo","appointments":"Compromissos","back_color":"Cor de fundo","basic_details":"Detalhes b\u00e1sicos","blog_details":"Detalhes do blog","blog_icon":"\u00cdcone do blog","blogs":"Blogues","buisness_hours":"HOR\u00c1RIO DE TRABALHO","business-hours":"Hor\u00e1rio comercial","business_hours":"Hor\u00e1rio comercial","company":"Companhia","contact":"Contato","copy_referral_link":"Copiar link de refer\u00eancia","cover_image":"Imagem de capa","created_at":"Criado em","created_on":"Criado em","custom-fonts":"Fontes","custom_css":"CSS customizado","custom_fonts":"Fontes","custom_js":"JS personalizado","date_of_birth":"Data de nascimento","description":"Descri\u00e7\u00e3o","display_share_button":"Exibir bot\u00e3o de compartilhamento","dob":"Data de nascimento","download_my_qr_code":"Baixe Meu QR Code","download_vcard":"Baixar VCard","duplicate_vcard":"Vcard duplicado!","edit_blog":"Editar blog","edit_gallery":"Editar galeria","edit_product":"Editar produto","edit_service":"Editar servi\u00e7o","edit_testimonial":"Editar depoimento","edit_vcard":"Editar VCard","email_address":"Endere\u00e7o de e-mail","enable_download_qr_code":"Ativar download do c\u00f3digo QR","enable_enquiry_form":"Ative o formul\u00e1rio de solicita\u00e7\u00e3o","enter_password":"Digite a senha","first_name":"Primeiro nome","flag":"Bandeira","galleries":"Galerias","gallery":"Galeria","google_analytics":"Google Analytics","google_config":"Configura\u00e7\u00e3o do Google","header":"Cabe\u00e7alho","home_title":"T\u00edtulo inicial","image":"Imagem","is_manual_payment":"O guia de pagamento manual est\u00e1 ativado","job_title":"Cargo","language_enable":"ativar idioma","last_name":"\u00daltimo nome","last_updated":"Ultima atualiza\u00e7\u00e3o","location":"Localiza\u00e7\u00e3o","manage-section":"Gerenciar se\u00e7\u00e3o","manual_payment_guide":"Guia de Pagamento Manual","map":"Mapa","meta_description":"Meta Descri\u00e7\u00e3o","meta_keyword":"Meta-palavra-chave","mobile_number":"N\u00famero de celular","new_blog":"Novo blog","new_gallery":"Nova Galeria","new_product":"Novo produto","new_service":"Novo servi\u00e7o","new_testimonial":"Novo depoimento","new_vcard":"Novo VCard","occupation":"Ocupa\u00e7\u00e3o","order_at":"Encomendado em","our_service":"Nossos servi\u00e7os","payment_config":"Configura\u00e7\u00e3o de pagamento","preview_url":"URL de visualiza\u00e7\u00e3o","privacy_policy":"Pol\u00edtica de Privacidade","product":"produtos","product_details":"\u00cdcone do produto","product_icon":"\u00cdcone do produto","product_name":"Nome do Produto","product_transection":"Transa\u00e7\u00f5es de produtos","products":"Produtos","profile_image":"Imagem de perfil","qr_code":"QR Code","qr_code_download_size":"Tamanho do download do c\u00f3digo QR","qrcode-customize":"Personalizar c\u00f3digo QR","qrcode_color":"Cor do c\u00f3digo QR","qrcode_customize":"Personalizar c\u00f3digo QR","qrcode_eye_style":"Selecione o estilo de olho","qrcode_style":"Selecione o estilo","remove_branding":"Remover marca","select_template":"Select Template","send_message":"Send Message","seo":"Motor de Otimiza\u00e7\u00e3o de Busca","service_details":"Detalhes do servi\u00e7o","service_icon":"\u00cdcone de servi\u00e7o","services":"Servi\u00e7os","share":"Compartilhado","share_my_vcard":"Compartilhar meu VCard","show_qr_code":"Mostrar c\u00f3digo QR","site_title":"titulo do site","social-links":"Links sociais","social_links":"Links sociais","stats":"Estat\u00edsticos","status":"Status","template":"Modelos de VCard","templates":"Modelos de VCard","term-condition":"termos e Condi\u00e7\u00f5es","term-policy":"Termos policiais","term_condition":"termos e Condi\u00e7\u00f5es","term_policy":"Termos policiais","testimonial":"Testemunho","testimonial_details":"Detalhes do depoimento","testimonials":"Depoimentos","theme_config":"Configura\u00e7\u00e3o do tema","url_alias":"URL de alias","user":"Usu\u00e1rios","user_name":"Nome do usu\u00e1rio","vcard":"Cart\u00e3o V","vcard_details":"Detalhes do VCard","vcard_is_active":"Vcard est\u00e1 ativo","vcard_name":"Nome do cart\u00e3o VC","vcard_service":"Servi\u00e7o VCard"},"vcard_11":{"Latest_post":"\u00faltimas postagens","contact_detail":"Detalhes do contato","get_in_touch":"Entrar em contato","my_email":"Meu email","my_phones":"Meus telefones","provide_service":"Prestar servi\u00e7os","read_more":"consulte Mais informa\u00e7\u00e3o"},"vcards":"VCards","vcards_template":{"image":"Imagem","used_count":"Contagem de usados"},"vcards_templates":"Modelos de VCards","virtual_backgrounds":"Fundos virtuais","wait_for_apporove_of_cash_payment_by_admin":"Sua solicita\u00e7\u00e3o de transa\u00e7\u00e3o manual est\u00e1 pendente.","weekdays":{"fri":"SEX","mon":"SEG","sat":"Sentado","sun":"SOL","thu":"QUI","tue":"TER","wed":"QUA"},"your":"Seu"},"pt.pagination":{"next":"Pr\u00f3ximo &raquo;","previous":"&laquo; Anterior"},"pt.passwords":{"reset":"Sua senha foi alterada!","sent":"Enviamos o link de redefini\u00e7\u00e3o de senha por e-mail!","throttled":"Aguarde antes de tentar novamente.","token":"Este token de redefini\u00e7\u00e3o de senha \u00e9 inv\u00e1lido.","user":"N\u00e3o conseguimos encontrar um usu\u00e1rio com esse endere\u00e7o de e-mail."},"pt.validation":{"accepted":"O :attribute deve ser aceito.","active_url":"O :attribute n\u00e3o \u00e9 um URL v\u00e1lido.","after":"O :attribute deve ser uma data ap\u00f3s :date.","after_or_equal":"O :attribute deve ser uma data posterior ou igual a :date.","alpha":"O :attribute deve conter apenas letras.","alpha_dash":"O :attribute deve conter apenas letras, n\u00fameros, tra\u00e7os e sublinhados.","alpha_num":"O :attribute deve conter apenas letras e n\u00fameros.","array":"O :attribute deve ser uma matriz.","attributes":{"email":"Email","message":"Mensagem","name":"Nome","phone":"Telefone","service_url":"Service URL"},"before":"O :attribute deve ser uma data anterior a :date.","before_or_equal":"O :attribute deve ser uma data anterior ou igual a :date.","between":{"array":"O :attribute deve ter entre :min e :max itens.","file":"O :attribute deve estar entre :min e :max kilobytes.","numeric":"O :attribute deve estar entre :min e :max.","string":"O :attribute deve estar entre :min e :max caracteres."},"boolean":"O :attribute campo deve ser verdadeiro ou falso.","confirmed":"O :attribute confirma\u00e7\u00e3o n\u00e3o corresponde.","coupon_code":{"expired":"Este c\u00f3digo de cupom expirou","not_found":"C\u00f3digo do cupom n\u00e3o encontrado"},"current_password":"A senha est\u00e1 incorreta.","custom":{"attribute-name":{"rule-name":"mensagem personalizada"}},"date":"O :attribute n\u00e3o \u00e9 uma data v\u00e1lida.","date_equals":"O :attribute deve ser uma data igual a :date.","date_format":"O :attribute n\u00e3o corresponde ao formato :format.","different":"O :attribute e: outro deve ser diferente.","digits":"O :attribute deve ser: d\u00edgitos d\u00edgitos.","digits_between":"O :attribute deve estar entre :min e :max d\u00edgitos.","dimensions":"O :attribute tem dimens\u00f5es de imagem inv\u00e1lidas.","distinct":"O :attribute campo tem um valor duplicado.","email":"O :attribute Deve ser um endere\u00e7o de e-mail v\u00e1lido.","ends_with":"O :attribute deve terminar com um dos seguintes: :values.","exists":"O selecionado :attribute \u00e9 inv\u00e1lido.","file":"O :attribute deve ser um arquivo.","filled":"O :attribute campo deve ter um valor.","gt":{"array":"O :attribute deve ter mais de: itens de valor.","file":"O :attribute deve ser maior que :value kilobytes.","numeric":"O :attribute deve ser maior que :value.","string":"O :attribute deve ser maior que :value caracteres."},"gte":{"array":"O :attribute deve ter: itens de valor ou mais.","file":"O :attribute deve ser maior ou igual a :value kilobytes.","numeric":"O :attribute deve ser maior ou igual a :value.","string":"O :attribute deve ser maior ou igual a :value caracteres."},"image":"O :attribute must be an image.","in":"O selecionado :attribute \u00e9 inv\u00e1lido.","in_array":"O :attribute campo n\u00e3o existe em :other.","integer":"O :attribute deve ser um n\u00famero inteiro.","ip":"O :attribute deve ser um endere\u00e7o IP v\u00e1lido.","ipv4":"O :attribute deve ser um endere\u00e7o IPv4 v\u00e1lido.","ipv6":"O :attribute deve ser um endere\u00e7o IPv6 v\u00e1lido.","json":"O :attribute deve ser uma string JSON v\u00e1lida.","lt":{"array":"O :attribute deve ter menos de: itens de valor.","file":"O :attribute deve ser menor que :value kilobytes.","numeric":"O :attribute deve ser menor que :value.","string":"O :attribute deve ser menor que :value caracteres."},"lte":{"array":"O :attribute n\u00e3o deve ter mais de :value itens.","file":"O :attribute deve ser menor ou igual a :value kilobytes.","numeric":"O :attribute deve ser menor ou igual a :value.","string":"O :attribute deve ser menor ou igual a :value caracteres."},"max":{"array":"O :attribute n\u00e3o deve ter mais de :max itens.","file":"O :attribute n\u00e3o deve ser maior que :max kilobytes.","numeric":"O :attribute n\u00e3o deve ser maior que :max.","string":"O :attribute n\u00e3o deve ser maior que :max caracteres."},"mimes":"O :attribute deve ser um arquivo do tipo: :values.","mimetypes":"O :attribute deve ser um arquivo do tipo: :values.","min":{"array":"O :attribute deve ter pelo menos :min itens.","file":"O :attribute deve ter pelo menos :min kilobytes.","numeric":"O :attribute deve ser pelo menos :min.","string":"O :attribute deve ter pelo menos :min caracteres."},"multiple_of":"O :attribute deve ser um m\u00faltiplo de :value.","not_in":"O selecionado :attribute \u00e9 inv\u00e1lido.","not_regex":"O :attribute o formato \u00e9 inv\u00e1lido.","numeric":"O :attribute deve ser um n\u00famero.","password":"A senha est\u00e1 incorreta.","present":"O :attribute campo deve estar presente.","prohibited":"O :attribute campo \u00e9 proibido.","prohibited_if":"O :attribute campo \u00e9 proibido quando :other \u00e9 :value.","prohibited_unless":"O :attribute campo \u00e9 proibido a menos que :other esteja em :values.","regex":"O :attribute formato \u00e9 inv\u00e1lido.","required":"O :attribute campo \u00e9 obrigat\u00f3rio.","required_if":"O :attribute O campo \u00e9 obrigat\u00f3rio quando :other \u00e9 :value.","required_unless":"O :attribute campo \u00e9 obrigat\u00f3rio a menos que :other esteja em :values.","required_with":"O :attribute campo \u00e9 obrigat\u00f3rio quando :values est\u00e1 presente.","required_with_all":"O :attribute campo \u00e9 obrigat\u00f3rio quando :values est\u00e3o presentes.","required_without":"O :attribute campo \u00e9 obrigat\u00f3rio quando :values n\u00e3o est\u00e1 presente.","required_without_all":"O :attribute campo \u00e9 obrigat\u00f3rio quando nenhum dos :values est\u00e1 presente.","same":"O :attribute e: outro deve corresponder.","size":{"array":"O :attribute deve conter: itens de tamanho.","file":"O :attribute deve ser: tamanho kilobytes.","numeric":"O :attribute deve ser: tamanho.","string":"O :attribute deve ser: caracteres de tamanho."},"starts_with":"O :attribute deve come\u00e7ar com um dos seguintes: :values.","string":"O :attribute deve ser uma string.","timezone":"O :attribute deve ser um fuso hor\u00e1rio v\u00e1lido.","unique":"O :attribute j\u00e1 foi tomada.","uploaded":"O :attribute falha ao carregar.","url":"O :attribute deve ser um URL v\u00e1lido.","uuid":"O :attribute deve ser um UUID v\u00e1lido."},"pt_BR.livewire-tables::strings":{"All":"Tudo","Applied Filters":"Filtros aplicados","Applied Sorting":"Ordena\u00e7\u00e3o aplicada","Bulk Actions":"A\u00e7\u00f5es em massa","Clear":"Limpar","Columns":"Colunas","Debugging Values":"Valores de depura\u00e7\u00e3o","Deselect All":"Desmarcar Tudo","Done Reordering":"Ordena\u00e7\u00e3o finalizada","Filters":"Filtros","No":"N\u00e3o","No items found. Try to broaden your search.":"Nenhum resultado encontrado. Tente ampliar a sua pesquisa.","Remove filter option":"Remover op\u00e7\u00e3o de filtro","Remove sort option":"Remover op\u00e7\u00e3o de ordena\u00e7\u00e3o","Reorder":"Reordenar","Search":"Pesquisar","Select All":"Selecionar tudo","Showing":"Exibindo","Yes":"Sim","You are currently selecting all":"Voc\u00ea selecionou tudo","You are not connected to the internet.":"Voc\u00ea n\u00e3o est\u00e1 conectado na internet.","You have selected":"Voc\u00ea selecionou","of":"de","results":"resultados","row":"linha","rows":"linhas","rows, do you want to select all":"linhas, voc\u00ea deseja selecionar tudo?","to":"a"},"ro.cookie-consent::texts":{"agree":"Accept\u0103 cookie","message":"Experien\u021ba ta pe acest site va fi \u00eembun\u0103t\u0103\u021bit\u0103 dac\u0103 accepta\u021bi folosirea de cookie-uri."},"ro.cookieConsent::texts":{"agree":"Accept\u0103 cookie","message":"Experien\u021ba ta pe acest site va fi \u00eembun\u0103t\u0103\u021bit\u0103 dac\u0103 accepta\u021bi folosirea de cookie-uri."},"ru.auth":{"about":"\u041e","account_deactivate":"\u0412\u0430\u0448\u0430 \u0443\u0447\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u0430, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c.","app":{"create":"\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c","export":"\u042d\u043a\u0441\u043f\u043e\u0440\u0442","lock_account":"\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c","member_since":"\u0423\u0447\u0430\u0441\u0442\u043d\u0438\u043a \u0441","messages":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f","online":"\u043e\u043d\u043b\u0430\u0439\u043d","print":"\u0420\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","reload":"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c","reset":"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c","search":"\u041f\u043e\u0438\u0441\u043a","settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438"},"choose_a_plan_that's_right_for_you":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 \u0438\u043c\u0435\u043d\u043d\u043e \u0432\u0430\u043c","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","contact":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442","copyright_by":"\u0410\u0432\u0442\u043e\u0440\u0441\u043a\u043e\u0435 \u043f\u0440\u0430\u0432\u043e \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e","email_verify":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0441\u0432\u043e\u044e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0443\u044e \u043f\u043e\u0447\u0442\u0443 \u043f\u0435\u0440\u0435\u0434 \u0432\u0445\u043e\u0434\u043e\u043c \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0443.","emails":{"password":{"reset_link":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0437\u0434\u0435\u0441\u044c, \u0447\u0442\u043e\u0431\u044b \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c"}},"failed":"\u042d\u0442\u0438 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0430\u0448\u0438\u043c \u0437\u0430\u043f\u0438\u0441\u044f\u043c.","features":"\u0424\u0443\u043d\u043a\u0446\u0438\u0438","forgot_password":{"send_pwd_reset":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f","title":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b, \u0447\u0442\u043e\u0431\u044b \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c"},"full_name":"\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f","get_started":"\u041d\u0430\u0447\u0430\u0442\u044c","home":"\u0414\u043e\u043c\u043e\u0439","let's_hear_what_they_say":"\u0414\u0430\u0432\u0430\u0439\u0442\u0435 \u043f\u043e\u0441\u043b\u0443\u0448\u0430\u0435\u043c, \u0447\u0442\u043e \u043e\u043d\u0438 \u0433\u043e\u0432\u043e\u0440\u044f\u0442","login":{"forgot_password":"\u044f \u0437\u0430\u0431\u044b\u043b \u043c\u043e\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","register_membership":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0439\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u043e","title":"\u0412\u043e\u0439\u0434\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0447\u0430\u0442\u044c \u0441\u0435\u0430\u043d\u0441"},"modern_&_powerful_interface":"\u0421\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0438 \u043c\u043e\u0449\u043d\u044b\u0439 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441","password":"\u041f\u0430\u0440\u043e\u043b\u044c","pricing":"\u0426\u0435\u043d\u044b","register":"\u0440\u0435\u0433\u0438\u0441\u0442\u0440","registration":{"have_membership":"\u0423 \u043c\u0435\u043d\u044f \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u043e","i_agree":"\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u0435\u043d \u0441","terms":"\u0443\u0441\u043b\u043e\u0432\u0438\u044f","title":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0439\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u043e"},"remember_me":"\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u0435 \u043c\u0435\u043d\u044f","reset_password":{"reset_pwd_btn":"\u0421\u0431\u0440\u043e\u0441 \u043f\u0430\u0440\u043e\u043b\u044f","title":"\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c"},"sign_in":"\u0412\u043e\u0439\u0442\u0438","sign_out":"\u0432\u044b\u0445\u043e\u0434","sign_up":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f","stories_from_our_customers":"\u0418\u0441\u0442\u043e\u0440\u0438\u0438 \u043d\u0430\u0448\u0438\u0445 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432","subscribe_here":"\u041f\u043e\u0434\u043f\u0438\u0448\u0438\u0442\u0435\u0441\u044c \u0437\u0434\u0435\u0441\u044c","throttle":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0432\u0445\u043e\u0434\u0430. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u0447\u0435\u0440\u0435\u0437 :seconds \u0441\u0435\u043a\u0443\u043d\u0434."},"ru.cookie-consent::texts":{"agree":"\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c","message":"\u041d\u0430 \u044d\u0442\u043e\u043c \u0441\u0430\u0439\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u044b cookies \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430."},"ru.cookieConsent::texts":{"agree":"\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c","message":"\u041d\u0430 \u044d\u0442\u043e\u043c \u0441\u0430\u0439\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u044b cookies \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430."},"ru.crud":{"action":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435","add_new":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435","are_you_sure":"\u0423\u0432\u0435\u0440\u0435\u043d\u044b \u043b\u0438 \u0432\u044b?","back":"\u041d\u0430\u0437\u0430\u0434","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","created_at":"\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0432","deleted_at":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e \u0432","detail":"\u0414\u0435\u0442\u0430\u043b\u044c","edit":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c","id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440","save":"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c","updated_at":"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0432"},"ru.livewire-tables::strings":{"All":"\u0412\u0441\u0435","Applied Filters":"\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0435 \u0444\u0438\u043b\u044c\u0442\u0440\u044b","Applied Sorting":"\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043d\u0430\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430","Bulk Actions":"\u041c\u0430\u0441\u0441\u043e\u0432\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f","Clear":"\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c","Columns":"\u0421\u0442\u043e\u043b\u0431\u0446\u044b","Done Reordering":"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430","Filters":"\u0424\u0438\u043b\u044c\u0442\u0440\u044b","No items found. Try to broaden your search.":"\u041d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a.","Remove filter option":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440","Remove sort option":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438","Reorder":"\u041f\u0435\u0440\u0435\u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0438\u0442\u044c","Search":"\u041f\u043e\u0438\u0441\u043a","Select All":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435","Show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c","Showing":"\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u043e \u0441","Unselect All":"\u0421\u043d\u044f\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435","You are currently selecting all":"\u0412\u044b \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442\u0435 \u0432\u0441\u0435","You are not connected to the internet.":"\u0412\u044b \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u044b \u043a \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443","You have selected":"\u0412\u044b \u0432\u044b\u0431\u0440\u0430\u043b\u0438","of":"\u0438\u0437","results":"\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432","rows":"\u0440\u044f\u0434\u044b","rows, do you want to select all":"\u0440\u044f\u0434\u044b, \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435","to":"\u043f\u043e"},"ru.messages":{"Business_Beacon":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0411\u0438\u0437\u043d\u0435\u0441-\u043c\u0430\u044f\u043a\u0430","CEO\/CXO":"\u041a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0435 \u0433\u0435\u043d\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u0435 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0430 \/ CXO vCard","Clean_Canvas":"\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0445\u043e\u043b\u0441\u0442 vCard","Corporate_Classic":"\u041a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u0430\u044f \u043a\u043b\u0430\u0441\u0441\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430","Corporate_Connect":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 Corporate Connect","Corporate_Identity":"\u041a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u0430\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430","Culinary_Food_Services":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u043a\u0443\u043b\u0438\u043d\u0430\u0440\u0438\u0438 \u0438 \u043e\u0431\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0438\u0442\u0430\u043d\u0438\u044f","Event_Management":"vCard \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\u043c\u0438","Executive_Profile":"vCard \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f","Fashion_Beauty":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u043e \u043c\u043e\u0434\u0435 \u0438 \u043a\u0440\u0430\u0441\u043e\u0442\u0435","Gym":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0442\u0440\u0435\u043d\u0430\u0436\u0435\u0440\u043d\u043e\u0433\u043e \u0437\u0430\u043b\u0430","Hospital":"\u0411\u043e\u043b\u044c\u043d\u0438\u0447\u043d\u0430\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430","Lawyer":"\u0410\u0434\u0432\u043e\u043a\u0430\u0442 \u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430","Manually":"\u0412\u0440\u0443\u0447\u043d\u0443\u044e","Modern_Edge":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 Modern Edge","Paypal":"\u041f\u0430\u0439\u041f\u0430\u043b","Portfolio":"\u041f\u043e\u0440\u0442\u0444\u043e\u043b\u0438\u043e vCard","Pro_Network":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 Pro Network","Professional":"\u041f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430","Programmer":"\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0438\u0441\u0442 vCard","Razorpay":"\u0420\u0430\u0437\u043e\u0440\u043f\u0435\u0439","Receive_latest_news_update_and_many_other_things_every_week":"\u041f\u043e\u043b\u0443\u0447\u0430\u0439\u0442\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u0438, \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043c\u043d\u043e\u0433\u043e\u0435 \u0434\u0440\u0443\u0433\u043e\u0435 \u043a\u0430\u0436\u0434\u0443\u044e \u043d\u0435\u0434\u0435\u043b\u044e.","Salon":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0441\u0430\u043b\u043e\u043d\u0430","Simple_Contact":"\u041f\u0440\u043e\u0441\u0442\u0430\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430","Social_Media":"\u0412\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u043b\u0438\u044f\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043b\u0438\u0446 \u0432 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0435\u0442\u044f\u0445","Stripe":"\u041f\u043e\u043b\u043e\u0441\u0430","Subscribe_Our_Newsletter":"\u041f\u043e\u0434\u043f\u0438\u0448\u0438\u0442\u0435\u0441\u044c \u043d\u0430 \u043d\u0430\u0448\u0443 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443","about_us":{"about_us":"\u041e \u043d\u0430\u0441","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","image":"\u041e\u0431 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438","title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"},"admin":{"add_admin":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430","admin":"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440","admin_created_successfully":"\u0410\u0434\u043c\u0438\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","admin_delete_successfully":"\u0410\u0434\u043c\u0438\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","admin_details":"\u0414\u0430\u043d\u043d\u044b\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430","admin_updated_successfully":"\u0410\u0434\u043c\u0438\u043d \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","avatar":"\u0410\u0432\u0430\u0442\u0430\u0440","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","contact_number":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d","edit_admin":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e","female":"\u0416\u0435\u043d\u0441\u043a\u0438\u0439","first_name":"\u0418\u043c\u044f","full_name":"\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f","gender":"\u041f\u043e\u043b","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","male":"\u041c\u0443\u0436\u0441\u043a\u043e\u0439","not_allowed_to_access":"\u041f\u043e\u0445\u043e\u0436\u0435, \u0432\u0430\u043c \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u044d\u0442\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438.","password":"\u041f\u0430\u0440\u043e\u043b\u044c","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","profile_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u0440\u043e\u0444\u0438\u043b\u0435"},"admins":"\u0410\u0434\u043c\u0438\u043d\u044b","affiliation":{"affiliate_note":"\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435 \u0432\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u0430\u0448\u0435\u0439 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0438 \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0430 \u043d\u0430 \u0432\u0430\u0448\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 vcards en bas. \u0415\u0441\u043b\u0438 \u0432\u044b \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0435\u0442\u0435\u0441\u044c \u0447\u0435\u0440\u0435\u0437 Cella \u0438 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043f\u043e\u0441\u043b\u0435 Cella, \u0432\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u0435 \u0432\u043e\u0437\u043d\u0430\u0433\u0440\u0430\u0436\u0434\u0435\u043d\u0438\u0435 \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435","affiliated_by":"\u0410\u0444\u0444\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u043d","affiliation_transaction":"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f\u00bb","affiliation_withdraw_detail":"\u0434\u0435\u0442\u0430\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0432\u044b\u0432\u043e\u0434 \u0440\u0435\u0444\u0435\u0440\u0430\u043b\u0430","affiliations":"\u041f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0438","approval_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f","approve":"\u0423\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c","approve_withdraw_request":"\u0423\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043e\u0442\u0437\u044b\u0432","approved":"\u041e\u0434\u043e\u0431\u0440\u0435\u043d\u043d\u044b\u0439","cash_payment":"\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438","current_amount":"\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","reject":"\u041e\u0442\u043a\u043b\u043e\u043d\u044f\u0442\u044c","reject_withdraw_request":"\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0432\u044b\u0432\u043e\u0434 \u0441\u0440\u0435\u0434\u0441\u0442\u0432","rejected":"\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043d\u044b\u0439","rejection_note":"\u041e\u0442\u043a\u0430\u0437\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u043a\u0430","total_affiliation_amount":"\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u0430","verify_paypal_email":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0443\u044e \u043f\u043e\u0447\u0442\u0443 PayPal","withdraw_amount":"\u0421\u0443\u043c\u043c\u0430 \u0441\u043d\u044f\u0442\u0438\u044f","withdrawal":"\u0412\u044b\u0432\u043e\u0434"},"allowed_file_types":"\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","analytic":{"vcard_analytic":"\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u043a\u0430 \u0432\u0438\u0437\u0438\u0442\u043e\u043a"},"analytics":{"browsers":"\u0411\u0440\u0430\u0443\u0437\u0435\u0440\u044b","countries":"\u0421\u0442\u0440\u0430\u043d\u044b","devices":"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430","languages":"\u042f\u0437\u044b\u043a\u0438","os":"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b","overview":"\u041e\u0431\u0437\u043e\u0440","see_all":"\u0423\u0432\u0438\u0434\u0435\u0442\u044c \u0432\u0441\u0435","view_more":"\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435","visitors":"\u041f\u043e\u0441\u0435\u0442\u0438\u0442\u0435\u043b\u0438"},"appointment":{"appointment":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430","appointment_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0438","appointment_type":"\u0422\u0438\u043f \u0432\u0441\u0442\u0440\u0435\u0447\u0438:","calendar":"\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c","ends":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f","free":"\u0411\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e","paid":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0439","starts":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f"},"appointments":"\u0432\u0441\u0442\u0440\u0435\u0447\u0438","business":{"business_hours":"\u0427\u0430\u0441\u044b \u0440\u0430\u0431\u043e\u0442\u044b","end_time":"\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f","fri":"\u043f\u0442","mon":"\u043f\u043d","sat":"\u0421\u0438\u0434\u0435\u043b","start_time":"\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f","sun":"\u0412\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435","thu":"\u0421\u043e\u0431\u0438\u0440\u0430\u0442\u044c","tue":"\u0412\u0442","wed":"\u041c\u044b \u0431"},"by_signing_up_you_agree_to_our":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u044f\u0441\u044c, \u0432\u044b \u0441\u043e\u0433\u043b\u0430\u0448\u0430\u0435\u0442\u0435\u0441\u044c \u0441 \u043d\u0430\u0448\u0438\u043c\u0438","cash_payment":"\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438","city":{"cities":"\u0413\u043e\u0440\u043e\u0434\u0430","city":"\u0413\u043e\u0440\u043e\u0434","city_name":"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430","edit_city":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0433\u043e\u0440\u043e\u0434","new_city":"\u041d\u043e\u0432\u044b\u0439 \u0433\u043e\u0440\u043e\u0434","no_city_available":"\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0433\u043e\u0440\u043e\u0434\u043e\u0432","no_city_found":"\u0413\u043e\u0440\u043e\u0434 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d","state_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0442\u0430\u0442\u0430"},"common":{"Yes_Change":"\u0414\u0430, \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c","action":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435","active":"\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439","add":"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c","add_virtual_background":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u043d","allow_cookies":"\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0444\u0430\u0439\u043b\u044b cookie","already_have_an_account":"\u0423\u0436\u0435 \u0435\u0441\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442","apply":"\u041f\u043e\u0434\u0430\u0442\u044c \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u0435","apply_changes":"\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f","are_you_completed":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0441\u0442\u0430\u0442\u0443\u0441?","are_you_sure":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e","are_you_sure_dublicate_vcard":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u044d\u0442\u043e\u0439 \u043a\u0430\u0440\u0442\u044b VCard?","back":"\u041d\u0430\u0437\u0430\u0434","back_subscription":"\u041d\u0430\u0437\u0430\u0434 \u043a \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430\u043c","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","captcha_enable":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c Google \u041a\u0430\u043f\u0447\u0443","closed":"\u0417\u0430\u043a\u0440\u044b\u0442\u043e","completed":"\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0439","cookie_banner_enabled":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0431\u0430\u043d\u043d\u0435\u0440 cookie","cookie_msg":"\u0412\u0430\u0448 \u043e\u043f\u044b\u0442 \u043d\u0430 \u044d\u0442\u043e\u043c \u0441\u0430\u0439\u0442\u0435 \u0431\u0443\u0434\u0435\u0442 \u0443\u043b\u0443\u0447\u0448\u0435\u043d, \u0435\u0441\u043b\u0438 \u0432\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 cookie","create_an_account":"\u0417\u0430\u0432\u0435\u0441\u0442\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442","currency_position":"\u0412\u0430\u043b\u044e\u0442\u043d\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f","custom":"\u041e\u0431\u044b\u0447\u0430\u0439","declined":"\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c","default_country_code":"\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","details":"\u0414\u0435\u0442\u0430\u043b\u0438","discard":"\u041e\u0442\u043a\u0430\u0437\u0430\u0442\u044c\u0441\u044f","download":"\u0421\u043a\u0430\u0447\u0430\u0442\u044c","duplicate":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442!","duplicate_vcard_create":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 Vcard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","edit":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e","enable_cookie_banner":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0431\u0430\u043d\u043d\u0435\u0440 cookie","enable_page":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0446\u0435\u043b\u0435\u0432\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443","enable_register":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e","enable_validation":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443","enquiry":"\u0417\u0430\u043f\u0440\u043e\u0441\u044b","error":"\u041e\u0448\u0438\u0431\u043a\u0430","filter":"\u0424\u0438\u043b\u044c\u0442\u0440","forgot_password":"\u0417\u0430\u0431\u044b\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c","forgot_your_password":"\u0417\u0430\u0431\u044b\u043b\u0438 \u0412\u0430\u0448 \u043f\u0430\u0440\u043e\u043b\u044c","from":"\u0418\u0437","has_been_completed":"\u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0439.","has_been_deleted":"\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d.","icon":"\u0417\u043d\u0430\u0447\u043e\u043a","inactive":"\u041d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439","infyvcard":"InfyVcard","is_active":"\u0410\u043a\u0442\u0438\u0432\u0435\u043d","link":"\u0421\u0432\u044f\u0437\u044c","loading":"\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...","login":"\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f","logout":"\u0412\u044b\u0439\u0442\u0438","message":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","name":"\u0418\u043c\u044f","new_here":"\u041d\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u0439 \u0442\u0443\u0442","no":"\u041d\u0435\u0442, \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c","no_data_available":"\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b","notUsed":"\u0415\u0449\u0435 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f","ok":"\u0412 \u043f\u043e\u0440\u044f\u0434\u043a\u0435","payment_methods":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","paypal_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 PayPal","paypal_payout_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u0434\u043b\u044f \u0432\u044b\u043f\u043b\u0430\u0442 Paypal","pending":"\u0412 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0438","phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d","phone_validation":"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430","please_wait":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435...","price":"\u0426\u0435\u043d\u0430","product_url":"URL \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","register":"\u0440\u0435\u0433\u0438\u0441\u0442\u0440","register_enable":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e","remember_me":"\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u0435 \u043c\u0435\u043d\u044f","reset":"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c","save":"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c","service_url":"URL \u0441\u043b\u0443\u0436\u0431\u044b","show_currency_behind":"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443 \u043f\u043e\u0437\u0430\u0434\u0438","sign_in_here":"\u0412\u043e\u0439\u0442\u0438 \u0437\u0434\u0435\u0441\u044c","status":"\u0421\u0442\u0430\u0442\u0443\u0441","sub_text":"\u041f\u043e\u0434\u0442\u0435\u043a\u0441\u0442","subject":"\u041f\u0440\u0435\u0434\u043c\u0435\u0442","submit":"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0430 \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u0438\u0435","successful":"\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439","to":"\u041a","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","today_appointments":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f \u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f","today_enquiry":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f \u0417\u0430\u043f\u0440\u043e\u0441\u044b","total__active_vcards":"\u0412\u0441\u0435\u0433\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043a\u0430\u0440\u0442","total__deactive_vcards":"\u0412\u0441\u0435\u0433\u043e \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u0430\u0440\u0442 VCard","total_active_users":"\u0412\u0441\u0435\u0433\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439","total_amount":"\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430","total_deactive_users":"\u0412\u0441\u0435\u0433\u043e \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439","total_plans":"\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u043d\u043e\u0432","total_users":"\u0412\u0441\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439","total_vcards":"\u0412\u0441\u0435\u0433\u043e \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a","type":"\u0422\u0438\u043f","unavailable":"\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d","upload_file":"\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b","user":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c","view":"\u0412\u0438\u0434","virtual_note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435. \u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0444\u043e\u043d\u044b \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u044f\u0442 \u0432\u0430\u043c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0431\u0443\u0434\u0443\u0442 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u044b \u0432\u0430\u0448 \u043b\u043e\u0433\u043e\u0442\u0438\u043f, \u0438\u043c\u044f, \u0430\u0434\u0440\u0435\u0441 \u0438 \u0442\u0435\u043b\u0435\u0444\u043e\u043d. \u043c\u044b \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0433\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0438 \u0432\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u0444\u043e\u043d\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u043b\u0435\u0437\u043d\u044b, \u043a\u043e\u0433\u0434\u0430 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0432\u043e\u044e \u043a\u0430\u0440\u0442\u0443 NFC, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e \u043f\u0435\u0440\u0435\u0434\u0430\u0442\u044c \u044d\u0442\u0438 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c \u043f\u0435\u0447\u0430\u0442\u0438 NFC. \u041a\u0440\u043e\u043c\u0435 \u0442\u043e\u0433\u043e, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e \u043f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u044d\u0442\u0438\u043c \u0441\u043e \u0441\u0432\u043e\u0438\u043c\u0438 \u0434\u0440\u0443\u0437\u044c\u044f\u043c\u0438 \u0438\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0435\u0433\u043e \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0444\u0438\u043b\u044f \/ \u043e\u0431\u043b\u043e\u0436\u043a\u0438.","yes":"\u0414\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u044c!","yes_duplicate":"\u0414\u0430, \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442!"},"contact_us":{"contact":"\u0421\u0432\u044f\u0437\u0430\u0442\u044c\u0441\u044f \u0441 \u043d\u0430\u043c\u0438","contact_us":"\u0417\u0430\u043f\u0440\u043e\u0441\u044b","inquries":"\u0417\u0430\u043f\u0440\u043e\u0441\u044b","message":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","send_message":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"},"copy_text":"\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c","country":{"countries":"\u0421\u0442\u0440\u0430\u043d\u044b","country":"\u0421\u0442\u0440\u0430\u043d\u0430","country_name":"\u0418\u043c\u044f \u0441\u0442\u0440\u0430\u043d\u044b","edit_country":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0443","new_country":"\u041d\u043e\u0432\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0430","no_country_available":"\u0421\u0442\u0440\u0430\u043d\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430","no_country_found":"\u0421\u0442\u0440\u0430\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430","phone_code":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u044b\u0439 \u043a\u043e\u0434","short_code":"\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u043d\u043e\u043c\u0435\u0440"},"coupon_code":{"add_coupon_code":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430","apply_here":"\u041f\u043e\u0434\u0430\u0442\u044c \u0437\u0430\u044f\u0432\u043a\u0443 \u0437\u0434\u0435\u0441\u044c","coupon_code":"\u043a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430","coupon_code_applied":"\u041a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d.","coupon_code_created":"\u041a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","coupon_code_percent_validation":"\u0421\u043a\u0438\u0434\u043a\u0430 \u043f\u043e \u043a\u0443\u043f\u043e\u043d\u0443 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 100%.","coupon_code_status_updated":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043a\u043e\u0434\u0430 \u043a\u0443\u043f\u043e\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","coupon_code_updated":"\u041a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","coupon_codes":"\u041a\u043e\u0434\u044b \u043a\u0443\u043f\u043e\u043d\u043e\u0432","coupon_discount":"\u041a\u0443\u043f\u043e\u043d\u043d\u0430\u044f \u0441\u043a\u0438\u0434\u043a\u0430","coupon_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0443\u043f\u043e\u043d\u0430","coupon_type":"\u0422\u0438\u043f \u043a\u0443\u043f\u043e\u043d\u0430","edit_coupon_code":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430","enter_coupon_code":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430","enter_coupon_discount":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u0443\u043f\u043e\u043d\u043d\u0443\u044e \u0441\u043a\u0438\u0434\u043a\u0443","enter_coupon_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0443\u043f\u043e\u043d\u0430","expire_at":"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f","fixed":"\u0424\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f","flat":"\u041f\u043b\u043e\u0441\u043a\u0438\u0439","have_a_coupon_code":"\u0415\u0441\u0442\u044c \u043a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430?","percentage":"\u041f\u0440\u043e\u0446\u0435\u043d\u0442","remove":"\u0423\u0434\u0430\u043b\u044f\u0442\u044c"},"create_vcard":"\u0421\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u0441\u0432\u043e\u044e \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443","create_your_business_digital_card_with_lots_of_information":"\u0421\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u0441\u0432\u043e\u044e \u0431\u0438\u0437\u043d\u0435\u0441-\u0446\u0438\u0444\u0440\u043e\u0432\u0443\u044e \u043a\u0430\u0440\u0442\u0443 \u0441 \u0431\u043e\u043b\u044c\u0448\u0438\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u043c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438","currency":{"currencies":"\u0412\u0430\u043b\u044e\u0442\u044b","currency_code":"\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b","currency_icon":"\u0417\u043d\u0430\u0447\u043e\u043a \u0432\u0430\u043b\u044e\u0442\u044b"},"dashboard":"\u041f\u0430\u043d\u0435\u043b\u0438 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430","date":"\u0414\u0430\u0442\u0430","deactivate":"\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c","e_card":{"add_ecard":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u0443","ecard":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430","ecard_info":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c 150 x 150 \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439.","ecard_logo":"\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b","ecards":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043a\u0438"},"edit_subscription":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u043d \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438","email_not_found":"\u041c\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u043c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b.","email_password_reset_link":"\u0421\u0441\u044b\u043b\u043a\u0430 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enquiry":"\u0417\u0430\u043f\u0440\u043e\u0441\u044b","enquiry_detail":"\u0414\u0435\u0442\u0430\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430","expire_in":"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043b\u0430\u043d\u0430 \u0438\u0441\u0442\u0435\u043a\u0430\u0435\u0442 \u0447\u0435\u0440\u0435\u0437","extra_scripts":"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u044b","feature":{"affiliation":"\u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u044c","analytics":"\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u043a\u0430","appointments":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f","blog":"\u0411\u043b\u043e\u0433","custom_css":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 CSS","custom_fonts":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0448\u0440\u0438\u0444\u0442\u044b","custom_js":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 JS","custom_qrcode":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 QR-\u043a\u043e\u0434","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","edit_feature":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442","enquiry_form":"\u0424\u043e\u0440\u043c\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430","feature_image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438","gallery":"\u0413\u0430\u043b\u0435\u0440\u0435\u044f","hide_branding":"\u0421\u043a\u0440\u044b\u0442\u044c \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433","image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","name":"\u0418\u043c\u044f","order_nfc_card":"\u0417\u0430\u043a\u0430\u0437\u0430\u0442\u044c NFC-\u043a\u0430\u0440\u0442\u0443","password":"\u0417\u0430\u0449\u0438\u0442\u0430 \u043f\u0430\u0440\u043e\u043b\u0435\u043c","products":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b","products_services":"\u0423\u0441\u043b\u0443\u0433\u0438","seo":"Motor de Otimiza\u00e7\u00e3o de Busca","social_links":"\u0421\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438","testimonials":"\u041e\u0442\u0437\u044b\u0432\u044b"},"features":"\u0424\u0443\u043d\u043a\u0446\u0438\u0438","flash":{"about_us_create":"\u041e \u043d\u0430\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e.","can_not_change_time_format":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0436\u0435 \u0437\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438","city_create":"\u0413\u043e\u0440\u043e\u0434 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d.","city_update":"\u0413\u043e\u0440\u043e\u0434 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","country_create":"\u0421\u0442\u0440\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430.","country_update":"\u0421\u0442\u0440\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","country_used":"\u0421\u0442\u0440\u0430\u043d\u0430 \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f","create_blog":"\u0411\u043b\u043e\u0433 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","create_front_testimonial":"\u041e\u0442\u0437\u044b\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","create_product":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","create_service":"\u0421\u0435\u0440\u0432\u0438\u0441 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","create_testimonial":"\u041e\u0442\u0437\u044b\u0432 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","current_invalid":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","database_upgrade_succesfully":"\u0412\u0430\u0448\u0430 \u0431\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","decription_is_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","feature_update":"\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","front_cms":"\u041f\u0435\u0440\u0435\u0434\u043d\u044f\u044f CMS \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","language_update":"\u042f\u0437\u044b\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","mobile_validation":"\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","name_is_required":"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u0432\u0435\u0441\u0442\u0438 \u0438\u043c\u044f \u0432 \u043f\u043e\u043b\u0435","password_update":"\u041f\u0430\u0440\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","plan_create":"\u041f\u043b\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","plan_default":"\u041f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d.","plan_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","plan_update":"\u041f\u043b\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","reactive_account":"\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0439\u0442\u0435 \u0441\u0432\u043e\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u043f\u043e\u0447\u0442\u044b.","setting_update":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b.","social_links_img_is_required":"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0441\u044b\u043b\u043e\u043a","social_links_is_required":"\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438","state_create":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e.","state_update":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e.","state_used":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f","success_theme_update":"\u0422\u0435\u043c\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","update_blog":"\u0411\u043b\u043e\u0433 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","update_front_testimonial":"\u041e\u0442\u0437\u044b\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","update_product":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","update_service":"\u0421\u0435\u0440\u0432\u0438\u0441 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","update_testimonial":"\u041e\u0442\u0437\u044b\u0432 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","user_create":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","user_profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","user_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","user_update":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","vcard_create":"VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430.","vcard_delete":"VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","vcard_retrieve":"VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430","vcard_status":"\u0421\u0442\u0430\u0442\u0443\u0441 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","vcard_update":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e.","verified_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430"},"font":{"font_family":"\u0421\u0435\u043c\u0435\u0439\u0441\u0442\u0432\u043e \u0448\u0440\u0438\u0444\u0442\u043e\u0432","font_size":"\u0420\u0430\u0437\u043c\u0435\u0440 \u0448\u0440\u0438\u0444\u0442\u0430","font_size_in_px":"P\u0430\u0437\u043c\u0435\u0440 \u0448\u0440\u0438\u0444\u0442\u0430 \u0432 \u043f\u0438\u043a\u0441\u0435\u043b\u044f\u0445","fonts":"\u0428\u0440\u0438\u0444\u0442\u044b","px":"\u043f\u0438\u043a\u0441."},"form":{"DOB":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f","allowed_vcard":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445 Vcards","blog":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0431\u043b\u043e\u0433\u0430","c_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u041f\u0430\u0440\u043e\u043b\u044c","company":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438","contact":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","css":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 CSS","description":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0430\u0448\u0435\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","designation":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u0431\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435","email":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enter_email":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enter_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f","enter_phone":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d","enter_trial":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0440\u043e\u0431\u043d\u044b\u0435 \u0434\u043d\u0438","f_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f","facebook":"URL-\u0430\u0434\u0440\u0435\u0441 Facebook","first_name":"\u0418\u043c\u044f","google_analytics":"\u041a\u043e\u0434 Google \u0410\u043d\u0430\u043b\u0438\u0442\u0438\u043a\u0438","home_title":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u043c\u0430","instagram":"URL-\u0430\u0434\u0440\u0435\u0441 Instagram","job":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c","js":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 Js","l_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0444\u0430\u043c\u0438\u043b\u0438\u044e","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","linkedin":"URL-\u0430\u0434\u0440\u0435\u0441 LinkedIn","location":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0432\u043e\u0435 \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435","location_url":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 URL-\u0430\u0434\u0440\u0435\u0441 \u0432\u0430\u0448\u0435\u0433\u043e \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f","mail":"\u042d\u043b. \u0430\u0434\u0440\u0435\u0441","meta_description":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043c\u0435\u0442\u0430-\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","meta_keyword":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u043c\u0435\u0442\u0430-\u0441\u043b\u043e\u0432\u043e","my_vcard_url":"URL-\u0430\u0434\u0440\u0435\u0441 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043c\u043e\u0435\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","occupation":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0440\u043e\u0434 \u0437\u0430\u043d\u044f\u0442\u0438\u0439","password":"\u041f\u0430\u0440\u043e\u043b\u044c","phone":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430","pick_date":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0430\u0442\u0443","pinterest":"URL-\u0430\u0434\u0440\u0435\u0441 Pinterest","plan_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043b\u0430\u043d\u0430","price":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443","product":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","product_url":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 URL \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","reddit":"\u0420\u0435\u0434\u0434\u0438\u0442 \u0423\u0420L","select_country":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0443","select_currency":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u043b\u044e\u0442\u0443","select_state":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0442\u0430\u0442","service":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u043b\u0443\u0436\u0431\u044b","service_url":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 URL-\u0430\u0434\u0440\u0435\u0441 \u0441\u043b\u0443\u0436\u0431\u044b","short_description":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","site_title":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0430\u0439\u0442\u0430","testimonial":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f \u043e\u0442\u0437\u044b\u0432\u0430","tiktok":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043d\u0430 URL-\u0430\u0434\u0440\u0435\u0441","tumblr":"\u0422\u0430\u043c\u0431\u043b\u0435\u0440 URL","twitter":"URL-\u0430\u0434\u0440\u0435\u0441 Twitter","type_message":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0437\u0434\u0435\u0441\u044c...","vcard_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","website":"\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0441\u0430\u0439\u0442","whatsapp":"URL WhatsApp","your_email":"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","your_name":"\u0412\u0430\u0448\u0435 \u0438\u043c\u044f","youtube":"\u042e\u0442\u0443\u0431 URL"},"from_time":"\u041e\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438","front":{"enter_your_email":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enter_your_message":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","enter_your_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u0430\u0448\u0435 \u0438\u043c\u044f","your_email_address":"\u0412\u0430\u0448 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b"},"front_cms":{"banner":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0431\u0430\u043d\u043d\u0435\u0440\u0430","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","front_cms":"\u041f\u0435\u0440\u0435\u0434\u043d\u044f\u044f CMS","title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"},"gallery":{"gallery_name":"Galeries","image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","type":"\u0422\u0438\u043f","youtube":"Youtube"},"hour":"\u0427\u0430\u0441","language":"\u042f\u0437\u044b\u043a","languages":{"edit_language":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044f\u0437\u044b\u043a","edit_translation":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u0432\u043e\u0434","iso_code":"\u041a\u041e\u0414 \u0418\u0421\u041e","language":"\u044f\u0437\u044b\u043a","languages":"\u044f\u0437\u044b\u043a\u0438","new_language":"\u041d\u043e\u0432\u044b\u0439 \u044f\u0437\u044b\u043a","translation":"\u041f\u0435\u0440\u0435\u0432\u043e\u0434"},"made_by":"\u0421\u0434\u0435\u043b\u0430\u043d","made_by_url":"\u0421\u0434\u0435\u043b\u0430\u043d\u043e \u043f\u043e URL-\u0430\u0434\u0440\u0435\u0441\u0443","mail":{"action_required":"\u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u043b\u0438 \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c, \u043d\u0438\u043a\u0430\u043a\u0438\u0445 \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0438\u0445 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f.","appointment_time":"\u0412\u0440\u0435\u043c\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0438 : ","approved_successfully":"\u0412\u0430\u0448\u0430 \u0432\u0441\u0442\u0440\u0435\u0447\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0434\u043e\u0431\u0440\u0435\u043d\u0430 \u043d\u0430","attachment":"\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435","between":"\u043c\u0435\u0436\u0434\u0443","book_appointment":"\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043f\u0440\u0438\u0435\u043c","book_successfully":"\u0412\u0430\u0448\u0430 \u0432\u0441\u0442\u0440\u0435\u0447\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043d\u0430","booked_appointment_with_you":"\u0437\u0430\u043f\u0438\u0441\u0430\u043b\u0441\u044f \u043a \u0432\u0430\u043c \u043d\u0430 \u043f\u0440\u0438\u0435\u043c","email":"\u042d\u043b. \u0430\u0434\u0440\u0435\u0441: ","hello":"\u041f\u0440\u0438\u0432\u0435\u0442,","hello!":"\u041f\u0440\u0438\u0432\u0435\u0442!","here_is_enquiry":"\u0412\u043e\u0442 \u0434\u0435\u0442\u0430\u043b\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0430","messages":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: ","name":"\u0418\u043c\u044f: ","new_manual_payment_request":"\u041d\u043e\u0432\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432\u0440\u0443\u0447\u043d\u0443\u044e","new_nfc_order":"\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043d\u043e\u0432\u044b\u0439 \u0437\u0430\u043a\u0430\u0437 NFC \u043e\u0442","notes":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f","password_change":"\u0412\u0430\u0448 \u043f\u0430\u0440\u043e\u043b\u044c \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c ","please_click":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 \u043d\u0438\u0436\u0435, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0441\u0432\u043e\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b.","please_contact_your_admin":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0441\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0430\u0440\u043e\u043b\u044f.","regard":"\u0421 \u0443\u0432\u0430\u0436\u0435\u043d\u0438\u0435\u043c,","slot_text":"\u0415\u0441\u043b\u0438 \u0443 \u0432\u0430\u0441 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u043d\u0430\u0436\u0430\u0442\u0438\u0435\u043c \u043a\u043d\u043e\u043f\u043a\u0438 \u00ab\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b\u00bb, \u0441\u043a\u043e\u043f\u0438\u0440\u0443\u0439\u0442\u0435 \u0438 \u0432\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u0438\u0436\u0435 URL-\u0430\u0434\u0440\u0435\u0441 \u0432 \u0441\u0432\u043e\u0439 \u0432\u0435\u0431-\u0431\u0440\u0430\u0443\u0437\u0435\u0440:","thanks_regard":"\u0421 \u0443\u0432\u0430\u0436\u0435\u043d\u0438\u0435\u043c,","vcard_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438: ","verify_email":"\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","whoops":"\u0423\u043f\u0441!"},"make_appointment":"\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0432\u0441\u0442\u0440\u0435\u0447\u0443","make_appointments":"\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043f\u0440\u0438\u0435\u043c","months":{"apr":"\u0430\u043f\u0440","aug":"\u0430\u0432\u0433","dec":"\u0434\u0435\u043a\u0430\u0431\u0440\u044c","feb":"\u0444\u0435\u0432\u0440\u0430\u043b\u044c","jan":"\u042f\u043d","jul":"\u0438\u044e\u043b\u044c","jun":"\u0438\u044e\u043d\u044c","mar":"\u043c\u0430\u0440\u0442","may":"\u041c\u0430\u0439","nov":"\u043d\u043e\u044f\u0431\u0440\u044c","oct":"\u043e\u043a\u0442\u044f\u0431\u0440\u044c","sep":"\u0441\u0435\u043d"},"nfc":{"Add_NFC_card_photos_and_set_prices":"\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0438 NFC-\u043a\u0430\u0440\u0442 \u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0446\u0435\u043d\u044b.","Admin_Guide":"\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430: \u041f\u0440\u043e\u0434\u0430\u0436\u0430 NFC-\u043a\u0430\u0440\u0442","Browse_and_select_an_NFC_card":"\u041f\u0440\u043e\u0441\u043c\u0430\u0442\u0440\u0438\u0432\u0430\u0439\u0442\u0435 \u0438 \u0432\u044b\u0431\u0438\u0440\u0430\u0439\u0442\u0435 NFC-\u043a\u0430\u0440\u0442\u0443.","Cancelled":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0432\u043e\u044e vCard, URL-\u0430\u0434\u0440\u0435\u0441 \u044d\u0442\u043e\u0439 vCard \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0430\u043d \u043d\u0430 \u043a\u0430\u0440\u0442\u0443 NFC.","Confirm_the_order_and_make_a_payment":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0437\u0430\u043a\u0430\u0437 \u0438 \u0441\u043e\u0432\u0435\u0440\u0448\u0438\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436.","Create_or_log_in_to_your_account":"\u0421\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u0438\u043b\u0438 \u0432\u043e\u0439\u0434\u0438\u0442\u0435 \u0432 \u0441\u0432\u043e\u044e \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c.","Delivered":"\u0414\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0439","Dispatch_the_NFC_cards_to_users":"\u041e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 NFC-\u043a\u0430\u0440\u0442\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c.","How_it_works":"\u041a\u0430\u043a \u044d\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442?","Log_in_to_the_Admin_Dashboard":"\u0412\u043e\u0439\u0434\u0438\u0442\u0435 \u0432 \u043f\u0430\u043d\u0435\u043b\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430.","Pending":"\u0412 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0438","Ready To Ship":"\u0413\u043e\u0442\u043e\u0432 \u043a \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435","Receive_and enjoy your NFC card":"\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u0435 \u0438 \u043d\u0430\u0441\u043b\u0430\u0436\u0434\u0430\u0439\u0442\u0435\u0441\u044c \u0432\u0430\u0448\u0435\u0439 NFC-\u043a\u0430\u0440\u0442\u043e\u0439.","Review_user_orders":"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439","Shipped":"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0439","User_Guide":"\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f: \u041f\u043e\u043a\u0443\u043f\u043a\u0430 \u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 NFC-\u043a\u0430\u0440\u0442","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"\u0414\u043e\u0436\u0434\u0438\u0442\u0435\u0441\u044c, \u043a\u043e\u0433\u0434\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0448\u0435\u0442 URL \u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442 \u043a\u0430\u0440\u0442\u0443.","Write_the_user_provided_URL_to_NFC_cards":"\u0417\u0430\u043f\u0438\u0448\u0438\u0442\u0435 URL, \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c, \u043d\u0430 NFC-\u043a\u0430\u0440\u0442\u044b.","add_nfc_card":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c NFC-\u043a\u0430\u0440\u0442\u0443","all":"\u0412\u0441\u0435","cancel":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","card_can_not_deleted":"\u041a\u0430\u0440\u0442\u0443 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u043e\u043d\u0430 \u0441\u0432\u044f\u0437\u0430\u043d\u0430 \u0441 \u0437\u0430\u043a\u0430\u0437\u0430\u043c\u0438 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432.","card_type":"\u0422\u0438\u043f \u043a\u0430\u0440\u0442\u044b","company_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438","designation":"\u041e\u0431\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435","edit_nfc_card":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c NFC-\u043a\u0430\u0440\u0442\u0443","enter_address":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441","failed":"\u041d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0439","logo":"\u041b\u043e\u0433\u043e\u0442\u0438\u043f","my_nfc_cards":"\u041c\u043e\u0438 NFC-\u043a\u0430\u0440\u0442\u044b","new_nfc_card":"\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0430 NFC","nfc":"\u041d\u0424\u041a","nfc_card":"NFC-\u043a\u0430\u0440\u0442\u0430","nfc_card_created_success":"\u041a\u0430\u0440\u0442\u0430 NFC \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430","nfc_card_deleted_success":"\u041a\u0430\u0440\u0442\u0430 NFC \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430","nfc_card_order_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u0437\u0430\u043a\u0430\u0437\u0430 \u043a\u0430\u0440\u0442\u044b NFC","nfc_card_orders":"NFC-\u043a\u0430\u0440\u0442\u0430 \u0417\u0430\u043a\u0430\u0437\u044b","nfc_card_type":"\u0422\u0438\u043f \u043a\u0430\u0440\u0442\u044b NFC","nfc_card_types":"\u0422\u0438\u043f\u044b NFC-\u043a\u0430\u0440\u0442","nfc_card_updated_success":"\u041a\u0430\u0440\u0442\u0430 NFC \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430","nfc_image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u044b","nfc_image_required":"\u041f\u043e\u043b\u0435 NFC-\u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","order":"\u0437\u0430\u043a\u0430\u0437","order_nfc":"\u0417\u0430\u043a\u0430\u0437\u0430\u0442\u044c NFC","order_placed_success":"\u0417\u0430\u043a\u0430\u0437 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d","order_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u043a\u0430\u0437\u0430","order_status_update_success":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u043a\u0430\u0437\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","orders":"\u0417\u0430\u043a\u0430\u0437\u044b","orders_count":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u0430\u043a\u0430\u0437\u043e\u0432","paid":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0439","payment_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","payment_status_update_success":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","pending":"\u0412 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0438","razorpay_session_success":"\u0421\u0435\u0430\u043d\u0441 RazorPay \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","required_vcard":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 Vcard","select_card":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u0430\u0440\u0442\u044b","select_vcard":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443","sell_nfc_cards":"\u041f\u0440\u043e\u0434\u0430\u0442\u044c NFC-\u043a\u0430\u0440\u0442\u044b","your_order_status_changed":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u0430\u0448\u0435\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f"},"no_data":"\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b","no_matching_records_found":"\u0421\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0449\u0438\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e","notification":{"mark_all_as_read":"\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u0430\u043a \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043d\u043e\u0435","notifications":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f","you_don`t_have_any_new_notification":"\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043d\u043e\u0432\u044b\u0445 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439"},"payment":{"cancelled":"\u041e\u0422\u041c\u0415\u041d\u0415\u041d\u041e","payment":"\u041e\u041f\u041b\u0410\u0422\u0410","payment_cancel":"\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","payment_success":"\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436","payment_successful":"\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e"},"payment_method":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","payment_type":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","placeholder":{"12_hour":"12 \u0447\u0430\u0441\u043e\u0432","24_hour":"24 \u0447\u0430\u0441\u0430","address_field":"\u041f\u043e\u043b\u0435 \u0410\u0434\u0440\u0435\u0441\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","agree_term":"\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0433\u043b\u0430\u0441\u0438\u0442\u044c\u0441\u044f \u0441 \u0423\u0441\u043b\u043e\u0432\u0438\u044f\u043c\u0438.","all_rights_reserve":"\u0412\u0441\u0435 \u043f\u0440\u0430\u0432\u0430 \u0437\u0430\u0449\u0438\u0449\u0435\u043d\u044b","app_name_required":"\u041f\u043e\u043b\u0435 \u0418\u043c\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","appointment_created":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e.","cannot_switch_to_zero":"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u043f\u043b\u0430\u043d, \u0435\u0441\u043b\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u043f\u0440\u043e\u0431\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \/ \u0435\u0441\u0442\u044c \u043f\u043b\u0430\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u043d, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u0430\u043a\u0442\u0438\u0432\u0435\u043d.","choose_one_template":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u044e\u0431\u043e\u0439 \u0448\u0430\u0431\u043b\u043e\u043d","copied_successfully":"\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","de_active":"\u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d","default_plan_can_not_be_delete":"\u041f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d","email_already_subscribed":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u0443\u0436\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0430.","email_verification":"\u0412\u0430\u0448 \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0431\u044b\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d. \u041c\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u0432\u0430\u043c \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435\u043c. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u0443\u044e \u043f\u043e\u0447\u0442\u0443.","enquiry_sent":"\u0417\u0430\u043f\u0440\u043e\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d.","enter_valid_email":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b.","enter_your_email_to_reset":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0412\u0430\u0448 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441, \u0447\u0442\u043e\u0431\u044b \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c.","favicon_invalid":"\u0424\u0430\u0432\u0438\u043a\u043e\u043d \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.","first_name_required":"\u041f\u043e\u043b\u0435 \u0418\u043c\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","forgot_your_password_no_problem":"\u0417\u0430\u0431\u044b\u043b\u0438 \u0441\u0432\u043e\u0439 \u043f\u0430\u0440\u043e\u043b\u044c? \u0411\u0435\u0437 \u043f\u0440\u043e\u0431\u043b\u0435\u043c. \u041f\u0440\u043e\u0441\u0442\u043e \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043d\u0430\u043c \u0441\u0432\u043e\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b, \u0438 \u043c\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043c \u0432\u0430\u043c \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043f\u043e\u0437\u0432\u043e\u043b\u0438\u0442 \u0432\u0430\u043c \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439.","gallery_created":"\u0413\u0430\u043b\u0435\u0440\u0435\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430.","gallery_updated":"\u0413\u0430\u043b\u0435\u0440\u0435\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","invalid_country_code":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"Invalid Number","lang_already_exists":" \u042f\u0437\u044b\u043a \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.","language_save":"\u042f\u0437\u044b\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d.","last_name_required":"\u041f\u043e\u043b\u0435 \u0424\u0430\u043c\u0438\u043b\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","last_week":"\u041f\u0440\u043e\u0448\u043b\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f","login_via_facebook":"\u0412\u043e\u0439\u0442\u0438 \u0447\u0435\u0440\u0435\u0437 Facebook","login_via_google":"\u0412\u043e\u0439\u0442\u0438 \u0447\u0435\u0440\u0435\u0437 Google","message_sent":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e.","multi_templates":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432","paid_appointment_cant_delete":"\u041f\u043b\u0430\u0442\u043d\u0430\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0430","password_character":"\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 8 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.   ","password_invalid":"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","password_is_correct":"\u041f\u0430\u0440\u043e\u043b\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439","password_must_match":"\u041f\u0430\u0440\u043e\u043b\u044c \u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c.","passwords":"\u041f\u043e\u043b\u0435 \u043f\u0430\u0440\u043e\u043b\u0435\u0439 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","payment_cancel":"\u0412\u0430\u0448 \u043f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d","payment_done":"\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d.","payment_not_complete":"\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d","payment_received":"\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d.","paypal_created":"\u0421\u0435\u0430\u043d\u0441 PayPal \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","paypal_key":"\u041f\u043e\u043b\u0435 \u043a\u043b\u044e\u0447\u0430 PayPal \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","paypal_mode":"\u041f\u043e\u043b\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 PayPal \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","paypal_secret":"\u041f\u043e\u043b\u0435 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 Paypal \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","phone_number_required":"\u041f\u043e\u043b\u0435 \u00ab\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430\u00bb \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","plan_already_used":"\u041f\u043b\u0430\u043d \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f","plan_expire_notification":"\u041f\u043e\u043b\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043e\u0431 \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u0438 \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043b\u0430\u043d\u0430 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","please_add_payment_credentials":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435","privacy_policy":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438.","product_purchase":"\u0422\u043e\u0432\u0430\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043a\u0443\u043f\u043b\u0435\u043d.","purchased_plan":"\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u0438\u043e\u0431\u0440\u0435\u043b\u0438 \u044d\u0442\u043e\u0442 \u043f\u043b\u0430\u043d.","receive_latest_news":"\u041f\u043e\u043b\u0443\u0447\u0430\u0439\u0442\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u0438, \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043c\u043d\u043e\u0433\u043e\u0435 \u0434\u0440\u0443\u0433\u043e\u0435 \u043a\u0430\u0436\u0434\u0443\u044e \u043d\u0435\u0434\u0435\u043b\u044e.","registered_success":"\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043b\u0438\u0441\u044c, \u0410\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0439\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u043f\u043e\u0447\u0442\u044b.","required_captcha":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u0430\u043f\u0447\u0443","role_created":"\u0420\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430..","select_hour":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0438\u043b\u0438 \u0447\u0430\u0441","select_one_or_more":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0443\u043d\u043a\u0446\u0438\u0439.","short_code_only_alpha":"\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u043a\u043e\u0434 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u0431\u0443\u043a\u0432 \u0430\u043b\u0444\u0430\u0432\u0438\u0442\u0430.","stripe_created":"\u0421\u0435\u0430\u043d\u0441 Stripe \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","stripe_key":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u043a\u043b\u044e\u0447\u0430 \u043f\u043e\u043b\u043e\u0441\u044b.","stripe_secret":"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 Stripe.","subscribed_plan":"\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c \u043d\u0430 \u044d\u0442\u043e\u0442 \u043f\u043b\u0430\u043d.","subscribed_plan_wait":"\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c \u043d\u0430 \u044d\u0442\u043e\u0442 \u043f\u043b\u0430\u043d, \u043d\u043e \u0436\u0434\u0435\u0442\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043e\u0442 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430","subscribed_successfully":"\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","subscription_date_updated":"\u0414\u0430\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","successfully_verified":"\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b\u0438 \u0441\u0432\u043e\u044e \u043f\u043e\u0447\u0442\u0443, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0443\u0439\u0442\u0435\u0441\u044c.","the_term_conditions":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f.","there_is_not_available_slot":"\u041d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u043c\u0435\u0441\u0442","this_currency_is_not_supported":"\u042d\u0442\u0430 \u0432\u0430\u043b\u044e\u0442\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f PayPal \u0434\u043b\u044f \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439.","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","time_format":"\u0424\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","unable_to_process_payment":"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0437\u0436\u0435","upload_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","valid_number":"Valid Number","we_could_not_fb_id":"\u041c\u044b \u043d\u0435 \u0441\u043c\u043e\u0433\u043b\u0438 \u043d\u0430\u0439\u0442\u0438 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u0432 \u0432\u0430\u0448\u0435\u0439 \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 Facebook","withdrawal_request_send":"\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0432\u044b\u0432\u043e\u0434 \u043e\u0434\u043e\u0431\u0440\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","your_mail_already_verified":"\u0412\u0430\u0448\u0430 \u043f\u043e\u0447\u0442\u0430 \u0443\u0436\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0443\u0439\u0442\u0435\u0441\u044c."},"plan":{"We'll_never_share_your_email_with_anyone_else":"\u041c\u044b \u043d\u0438\u043a\u043e\u0433\u0434\u0430 \u043d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u0434\u0438\u043c \u0432\u0430\u0448 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043a\u043e\u043c\u0443-\u043b\u0438\u0431\u043e \u0435\u0449\u0435.","additional_domains":"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u043e\u043c\u0435\u043d\u044b","affiliation":"\u041f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0438","analytics":"\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u043a\u0430","blog":"\u0411\u043b\u043e\u0433\u0438","currency":"\u0412\u0430\u043b\u044e\u0442\u0430","custom_css":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 CSS","custom_fields":"\u041d\u0430\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u043f\u043e\u043b\u044f","custom_js":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 JS","custom_qrcode":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 QR-\u043a\u043e\u0434","days":"\u0414\u043d\u0438","default_Plan":"\u041f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","domains_limit":"\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043c\u0435\u043d\u043e\u0432","duration":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c","duration_months":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u041c\u0435\u0441\u044f\u0446\u044b","duration_years":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0413\u043e\u0434\u044b","edit_plan":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u043d","email_address":"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enquiry_form":"\u0424\u043e\u0440\u043c\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430","features":"\u0424\u0443\u043d\u043a\u0446\u0438\u0438","frequency":"\u0427\u0430\u0441\u0442\u043e\u0442\u0430","gallery":"\u0413\u0430\u043b\u0435\u0440\u0435\u044f","hide_branding":"\u0421\u043a\u0440\u044b\u0442\u044c \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433","is_trial":"\u044d\u0442\u043e \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435","make_default":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","monthly":"\u0415\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u043e","months":"\u041c\u0435\u0441\u044f\u0446\u044b","multi_templates":"\u041c\u0443\u043b\u044c\u0442\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u044b","new_plan":"\u041d\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u043d","no_of_vcards":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e VCard","password_protection":"\u0417\u0430\u0449\u0438\u0442\u0430 \u043f\u0430\u0440\u043e\u043b\u0435\u043c","plan":"\u041f\u043b\u0430\u043d","plan_type":"\u0422\u0438\u043f \u043f\u043b\u0430\u043d\u0430","portfolio":"\u043f\u043e\u0440\u0442\u0444\u043e\u043b\u0438\u043e","price":"\u0426\u0435\u043d\u0430","products":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b","products_&_services":"\u0422\u043e\u0432\u0430\u0440\u044b \u0418 \u0423\u0441\u043b\u0443\u0433\u0438","qrcode":"QR \u043a\u043e\u0434","remaining_balance":"\u041e\u0441\u0442\u0430\u0442\u043e\u043a \u041f\u0440\u0435\u0434\u044b\u0434. \u041f\u043b\u0430\u043d","select_all_feature":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438","select_plan":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d","sendemail":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e","sendinvite":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0438\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435","seo":"Motor de Otimiza\u00e7\u00e3o de Busca","services":"\u0423\u0441\u043b\u0443\u0433\u0438","status":"\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u043b","testimonials":"\u041e\u0442\u0437\u044b\u0432\u044b","total_custom_domains_limit":"\u041e\u0431\u0449\u0438\u0439 \u043b\u0438\u043c\u0438\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0434\u043e\u043c\u0435\u043d\u043e\u0432","trial_days":"\u041f\u0440\u043e\u0431\u043d\u044b\u0435 \u0434\u043d\u0438","unlimited":"\u041d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u044b\u0439","valid_upto":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d \u0434\u043e","what_s_in_startup_plan":"\u0427\u0442\u043e \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u043d?","yearly":"\u0415\u0436\u0435\u0433\u043e\u0434\u043d\u043e","years":"\u0413\u043e\u0434\u044b"},"plan_expire":"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043b\u0430\u043d\u0430 \u0438\u0441\u0442\u0435\u043a. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435.","plan_expire_notification":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u0438 \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043b\u0430\u043d\u0430 (\u0432 \u0434\u043d\u044f\u0445)","plans":"\u041f\u043b\u0430\u043d\u044b","product_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u0437\u0430\u043a\u0430\u0437\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","product_orders":"\u0417\u0430\u043a\u0430\u0437\u044b \u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u044e","resend_verification_email":"\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f","reset_password":"\u0421\u0431\u0440\u043e\u0441 \u043f\u0430\u0440\u043e\u043b\u044f","role":{"edit_role":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u043e\u043b\u044c","name":"\u0418\u043c\u044f","new_role":"\u041d\u043e\u0432\u0430\u044f \u0440\u043e\u043b\u044c","permissions":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f","role_permissions":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0440\u043e\u043b\u0438","select_all_permissions":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f"},"roles":"\u0420\u043e\u043b\u0438","sadmin_dashboard":{"contact":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","day":"\u0414\u0435\u043d\u044c","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e","income":"\u0434\u043e\u0445\u043e\u0434","month":"\u041c\u0435\u0441\u044f\u0446","name":"\u0418\u043c\u044f","plans_by_users":"\u041f\u043b\u0430\u043d\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439","recent_users_registration":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439","registered_on":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d","week":"\u041d\u0435\u0434\u0435\u043b\u044e"},"save":"Save","select_payment_type":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0448\u043b\u044e\u0437","services":"\u0423\u0441\u043b\u0443\u0433\u0438","setting":{"add_contact":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b","address":"\u0410\u0434\u0440\u0435\u0441","affiliation_amount":"\u0421\u0443\u043c\u043c\u0430 \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u0430","affiliation_withdraw":"\u0410\u0444\u0444\u0438\u043b\u0438\u0430\u0446\u0438\u044f \u0441\u043d\u0438\u043c\u0430\u0435\u0442\u0441\u044f","app_logo":"\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","app_name":"\u0418\u043c\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","clinic_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u043d\u0438\u043a\u0438","contact_information":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b","credentials":"\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u0430","currency":"\u0412\u0430\u043b\u044e\u0442\u0430","currency_settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u0430\u043b\u044e\u0442\u044b","default_currency_format":"\u0424\u043e\u0440\u043c\u0430\u0442 \u0432\u0430\u043b\u044e\u0442\u044b \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","default_language":"\u042f\u0437\u044b\u043a \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","disable_landing_page":"\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0446\u0435\u043b\u0435\u0432\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443","enable_addcontact":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u043a\u043e\u043d\u0442\u0430\u043a\u0442","enable_affiliation":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0430\u0444\u0444\u0438\u043b\u0438\u0430\u0446\u0438\u044e","enable_contact":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442","favicon":"\u0424\u0430\u0432\u0438\u043a\u043e\u043d","front_page_enable":"\u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c","general":"\u041e\u0431\u0449\u0438\u0439","general_details":"\u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f","hide_stickybar":"\u0421\u043a\u0440\u044b\u0442\u044c \u043b\u0438\u043f\u043a\u0443\u044e \u043f\u043e\u043b\u043e\u0441\u0443 vCard","location_url":"URL-\u0430\u0434\u0440\u0435\u0441 \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f","manually":"\u0412\u0440\u0443\u0447\u043d\u0443\u044e","note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435. \u0418\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u00abWeChat.png\u00bb \/ \u00abTumbler.png\u00bb \/ \u00abXXX.png\u00bb, \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 .vcf \u044d\u0442\u043e \u0438\u043c\u044f \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043c\u0435\u0442\u043a\u0438.","paypal":"PayPal","paypal_client_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 Paypal","paypal_key":"\u043a\u043b\u044e\u0447 PayPal","paypal_mode":"\u0420\u0435\u0436\u0438\u043c PayPal","paypal_payout_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u0434\u043b\u044f \u0432\u044b\u043f\u043b\u0430\u0442 Paypal","paypal_secret":"\u041f\u0430\u0439\u041f\u0430\u043b \u0421\u0435\u043a\u0440\u0435\u0442","postal_code":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u041a\u043e\u0434","prefix":"\u041f\u0440\u0435\u0444\u0438\u043a\u0441","razorpay":"Razorpay","razorpay_key":"\u041a\u043b\u044e\u0447 Razorpay","razorpay_secret":"\u0421\u0435\u043a\u0440\u0435\u0442 \u0420\u0430\u0437\u043e\u0440\u043f\u0435\u0439","select_currency":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u043b\u044e\u0442\u0443","setting":"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440","shipping_address":"\u0410\u0434\u0440\u0435\u0441 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438","specialities":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","stripe":"\u041f\u043e\u043b\u043e\u0441\u0430","stripe_key":"\u041f\u043e\u043b\u043e\u0441\u0430\u0442\u044b\u0439 \u043a\u043b\u044e\u0447","stripe_secret":"\u041f\u043e\u043b\u043e\u0441\u0430\u0442\u044b\u0439 \u0441\u0435\u043a\u0440\u0435\u0442","upgrade_database":"\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0431\u0430\u0437\u0443 \u0434\u0430\u043d\u043d\u044b\u0445","user_default_language":"\u042f\u0437\u044b\u043a \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","whatsapp_share":"WhatsApp \u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f","withdraw_transactions":"\u0421\u043d\u044f\u0442\u0438\u0435 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439","withdrawals":"\u0412\u044b\u0432\u043e\u0434 \u0441\u0440\u0435\u0434\u0441\u0442\u0432","wp_number":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430"},"settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438","sign_out":"\u0412\u044b\u0445\u043e\u0434","social":{"Facebook":"\u0424\u0435\u0439\u0441\u0431\u0443\u043a","Instagram":"\u0418\u043d\u0441\u0442\u0430\u0433\u0440\u0430\u043c","Linkedin":"\u041b\u0438\u043d\u043a\u0435\u0434\u0438\u043d","Pinterest":"\u041f\u0438\u043d\u0442\u0435\u0440\u0435\u0441\u0442","Reddit":"\u0420\u0435\u0434\u0434\u0438\u0442","Share_on_email":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435","Share_on_facebook":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0444\u0435\u0439\u0441\u0431\u0443\u043a","Share_on_linkedin":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u0432 Linkedin","Share_on_pinterest":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043d\u0430 Pinterest","Share_on_reddit":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043d\u0430 Reddit","Share_on_twitter":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u0432 \u0422\u0432\u0438\u0442\u0442\u0435\u0440\u0435","Share_on_whatsapp":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u0432 WhatsApp","Tiktok":"\u0422\u0418\u041a \u0422\u0430\u043a","Tumblr":"\u0422\u0430\u043c\u0431\u043b\u0435\u0440","Twitter":"\u0422\u0432\u0438\u0442\u0442\u0435\u0440","Whatsapp":"WhatsApp","Youtube":"YouTube","map":"\u043a\u0430\u0440\u0442\u0430","social_links":"\u0421\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 - \u0412\u0435\u0431-\u0441\u0430\u0439\u0442","website":"\u0412\u0435\u0431-\u0441\u0430\u0439\u0442"},"state":{"country_name":"\u0418\u043c\u044f \u0441\u0442\u0440\u0430\u043d\u044b","edit_state":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","new_state":"\u041d\u043e\u0432\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","no_state_available":"\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0439","no_state_found":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","state_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0442\u0430\u0442\u0430","states":"\u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f"},"subscribe":"\u041f\u043e\u0434\u043f\u0438\u0441\u044b\u0432\u0430\u0439\u0441\u044f","subscribed_plans":"\u041f\u043e\u0434\u043f\u0438\u0441\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b","subscribed_user":"\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b \u0441 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u043e\u0439","subscriber":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","subscription":{"active_until":"\u0410\u043a\u0442\u0438\u0432\u0435\u043d \u0434\u043e","active_until_unlimited":"\u0410\u043a\u0442\u0438\u0432\u0435\u043d \u0434\u043e \u041d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u043e","amount":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","buy_now":"\u041a\u0443\u043f\u0438\u0442\u044c \u0441\u0435\u0439\u0447\u0430\u0441","buy_product":"\u041a\u0443\u043f\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442","cancel_subscription":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443","choose_plan":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d","current_expire":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u043d","current_plan":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043b\u0430\u043d","currently_active":"\u0412 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0430\u043a\u0442\u0438\u0432\u0435\u043d","end_date":"\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f","end_date_required":"\u041f\u043e\u043b\u0435 \u0434\u0430\u0442\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","expired":"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u043b\u0430\u043d\u0430 \u0443\u0436\u0435 \u0438\u0441\u0442\u0435\u043a","expired_date":"\u0414\u0430\u0442\u0430 \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430","free":"\u0411\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e","has_already_been_subscribed":"\u0443\u0436\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d","has_been_subscribed":"\u0431\u044b\u043b \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d","history":"\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438","manage_subscription":"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u043e\u0439","no_plan_available":"\u041f\u043b\u0430\u043d \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d","pay_or_switch_plan":"\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c\/\u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u043d","payable_amount":"\u0421\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435","payment":"\u041e\u043f\u043b\u0430\u0442\u0430","plan_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043b\u0430\u043d\u0430","plan_price":"\u0426\u0435\u043d\u0430 \u043f\u043b\u0430\u043d\u0430","proceed_to_payment":"\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u043e\u043f\u043b\u0430\u0442\u0435","purchase":"Purchase","remaining":"\u041e\u0441\u0442\u0430\u0432\u0448\u0438\u0439\u0441\u044f","remaining_balance":"\u041e\u0441\u0442\u0430\u0442\u043e\u043a \u0441\u0440\u0435\u0434\u0441\u0442\u0432","remaining_days":"\u041e\u0441\u0442\u0430\u0432\u0448\u0438\u0435\u0441\u044f \u0434\u043d\u0438","renew_free_plan":"\u0411\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u043d\u0435\u043b\u044c\u0437\u044f \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c\/\u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e","renew_plan":"\u041f\u0440\u043e\u0434\u043b\u0438\u0442\u044c \u043f\u043b\u0430\u043d","start_date":"\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430","subscribed_date":"\u0414\u0430\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438","subscribed_plan_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u043c \u043f\u043b\u0430\u043d\u0435 \u0441 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u043e\u0439","switch_plan":"\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u043d","total_days":"\u0412\u0441\u0435\u0433\u043e \u0434\u043d\u0435\u0439","trial_plan":"\u041f\u0440\u043e\u0431\u043d\u044b\u0439 \u043f\u043b\u0430\u043d","upgrade_plan":"\u041f\u043b\u0430\u043d \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f","used_balance":"Used Balance","used_days":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435 \u0434\u043d\u0438"},"subscriptions":"\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438","testimonial":"\u041e\u0442\u0437\u044b\u0432\u044b","to_time":"\u043a\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438","tooltip":{"about_description":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u043d\u0435 \u0431\u043e\u043b\u0435\u0435 500 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432","about_title":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u043d\u0435 \u0431\u043e\u043b\u0435\u0435 100 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432","allowed_image":"\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","app_logo":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c 90 x 60 \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439.","banner_title":"\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 34 \u0441\u0438\u043c\u0432\u043e\u043b\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e","cancel_app_logo":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","cancel_cover":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043e\u0431\u043b\u043e\u0436\u043a\u0443","cancel_favicon_logo":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0444\u0430\u0432\u0438\u043a\u043e\u043d","cancel_image":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","cancel_profile":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c","change_app_logo":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","change_favicon_logo":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u043e\u043a","change_icon":"\u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u043e\u043a","copy":"\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430","cover":"\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043e\u0431\u043b\u043e\u0436\u043a\u0438","custom_css":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 css \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0439 VCard.","custom_fonts":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0448\u0440\u0438\u0444\u0442\u043e\u0432 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0439 VCard.","custom_js":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 js \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0439 VCard.","dark_mode":"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0442\u0435\u043c\u043d\u044b\u0439 \u043c\u043e\u0434e","enable_affiliation":"\u0412\u043a\u043b\u044e\u0447\u0438\u0432 \u044d\u0442\u043e, \u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u043e \u0431\u0443\u0434\u0435\u0442 \u0432\u0438\u0434\u043d\u0430 \u0432\u0441\u0435\u043c \u0432\u0430\u0448\u0438\u043c \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u043c \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430\u043c.","enable_contact":"\u0412\u043a\u043b\u044e\u0447\u0438\u0432 \u044d\u0442\u043e, \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u0438\u0434\u043d\u044b \u043d\u0430 \u0432\u0441\u0435\u0445 \u0432\u0430\u0448\u0438\u0445 \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430\u0445. ","favicon_logo":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c 16 x 16 \u043f\u0438\u043a\u0441\u0435\u043b\u0435\u0439.","hide_branding":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0441\u043a\u0440\u044b\u0432\u0430\u0442\u044c \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433 \u0441 \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a.","hide_stickybar":"\u0412\u043a\u043b\u044e\u0447\u0438\u0432 \u044d\u0442\u043e, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u043a\u0440\u044b\u0442\u044c \u0437\u0430\u043b\u0438\u043f\u0430\u044e\u0449\u0438\u0435 \u043a\u043d\u043e\u043f\u043a\u0438 Vcards \u043d\u0430 \u0432\u0441\u0435\u0445 \u0432\u0430\u0448\u0438\u0445 Vcards. ","home_image":"\u041b\u0443\u0447\u0448\u0435\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0431\u0443\u0434\u0435\u0442.","image":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","light_mode":"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u0432 \u0441\u0432\u0435\u0442\u043b\u044b\u0439 \u0440\u0435\u0436\u0438\u043c","password_protection":"\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0437\u0430\u0449\u0438\u0449\u0435\u043d\u043d\u044b\u043c \u043f\u0430\u0440\u043e\u043b\u0435\u043c \u043a\u0430\u0440\u0442\u0430\u043c VCard.","product_image":"\u041b\u0443\u0447\u0448\u0435\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0431\u0443\u0434\u0435\u0442 250x250.","profile":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044ce","remove_branding":"\u0415\u0441\u043b\u0438 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e, vcard \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0439 \u0441\u0442\u0438\u043b\u044c \u043d\u0430\u0448\u0435\u0433\u043e \u0432\u0435\u0431-\u0441\u0430\u0439\u0442\u0430..","script":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 JS \u0431\u0435\u0437 \u0442\u0435\u0433\u0430 script","sub_text":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u043d\u0435 \u0431\u043e\u043b\u0435\u0435 60 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432","the_main_url":"\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 URL-\u0430\u0434\u0440\u0435\u0441, \u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0431\u0443\u0434\u0435\u0442 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0432\u0430\u0448\u0435\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0435..","whatsapp_share":"\u0412\u043a\u043b\u044e\u0447\u0438\u0432 \u044d\u0442\u043e, \u043a\u043d\u043e\u043f\u043a\u0430 WhatsApp Share \u0431\u0443\u0434\u0435\u0442 \u0432\u0438\u0434\u043d\u0430 \u043d\u0430 \u0432\u0441\u0435\u0445 \u0432\u0430\u0448\u0438\u0445 \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430\u0445."},"translation_manager":"\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u043e\u0432","type_in_script":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0434 js \u0432\u043d\u0443\u0442\u0440\u0438 \u0442\u0435\u0433\u0430 <script><\/script>","user":{"account":"\u0421\u0447\u0435\u0442","account_setting":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430","add_admin":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430","add_user":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","admin_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0435","avatar":"\u0410\u0432\u0430\u0442\u0430\u0440","change_language":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044f\u0437\u044b\u043a","change_password":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","contact_no":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","contact_number":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d","current_password":"\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","edit_user":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e","email_verified":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u0430","female":"\u0416\u0435\u043d\u0441\u043a\u0438\u0439","first_name":"\u0418\u043c\u044f","full_name":"\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f","impersonate":"\u0412\u044b\u0434\u0430\u0432\u0430\u0442\u044c \u0441\u0435\u0431\u044f \u0437\u0430","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","location":"\u041c\u0435\u0441\u0442\u043e \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f","male":"\u041c\u0443\u0436\u0441\u043a\u043e\u0439","new_password":"\u043d\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","overview":"\u041e\u0431\u0437\u043e\u0440","password":"\u041f\u0430\u0440\u043e\u043b\u044c","phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","profile_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043f\u0440\u043e\u0444\u0438\u043b\u044f","registered_date":"\u0414\u0430\u0442\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438","return_to_admin":"\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443","save_changes":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f","setting":"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440","theme_change":"\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u0442\u0435\u043c\u044b","user_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435","your_message":"\u0422\u0432\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","your_name":"\u0422\u0432\u043e\u0435 \u0438\u043c\u044f"},"users":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438","vcard":{"add_blog":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0431\u043b\u043e\u0433","add_gallery":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u0430\u043b\u0435\u0440\u0435\u044e","add_google_analytics":"\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043a\u043e\u0434 Google Analytics \u0431\u0435\u0437 \u0442\u0435\u0433\u0430 <script>","add_product":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442","add_service":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443","add_testimonial":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u0442\u0437\u044b\u0432","advanced":"\u041f\u0435\u0440\u0435\u0434\u043e\u0432\u043e\u0439","affiliate_user":"\u0410\u0444\u0444\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438","alter_email_address":"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b. \u043f\u043e\u0447\u0442\u044b","alter_mobile_number":"\u0410\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0433\u043e \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430","alternate_email":"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 e-mail","alternative_phone":"\u0434\u0440\u0443\u0433\u043e\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d","appointments":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f","back_color":"\u0424\u043e\u043d\u043e\u0432\u044b\u0439 \u0446\u0432\u0435\u0442","basic_details":"\u041e\u0441\u043d\u043e\u0432\u043d\u044b\u0435 \u0434\u0435\u0442\u0430\u043b\u0438","blog_details":"\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0431\u043b\u043e\u0433\u0430","blog_icon":"\u0417\u043d\u0430\u0447\u043e\u043a \u0431\u043b\u043e\u0433\u0430","blogs":"\u0411\u043b\u043e\u0433\u0438","buisness_hours":"\u0427\u0410\u0421\u042b \u0420\u0410\u0411\u041e\u0422\u042b","business-hours":"\u0427\u0430\u0441\u044b \u0440\u0430\u0431\u043e\u0442\u044b","business_hours":"\u0427\u0430\u0441\u044b \u0440\u0430\u0431\u043e\u0442\u044b","company":"\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f","contact":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442","copy_referral_link":"\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0444\u0435\u0440\u0430\u043b\u044c\u043d\u0443\u044e \u0441\u0441\u044b\u043b\u043a\u0443","cover_image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043e\u0431\u043b\u043e\u0436\u043a\u0438","created_at":"\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0432","created_on":"\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u043d\u0430","custom-fonts":"\u0428\u0440\u0438\u0444\u0442\u044b","custom_css":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 CSS","custom_fonts":"\u0428\u0440\u0438\u0444\u0442\u044b","custom_js":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 JS","date_of_birth":"\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","display_share_button":"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043d\u043e\u043f\u043a\u0443 \u00ab\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f\u00bb","dob":"\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f","download_my_qr_code":"\u0421\u043a\u0430\u0447\u0430\u0442\u044c \u043c\u043e\u0439 QR-\u043a\u043e\u0434","download_vcard":"\u0421\u043a\u0430\u0447\u0430\u0442\u044c \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443","duplicate_vcard":"\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0432\u0438\u0437\u0438\u0442\u043a\u0438!","edit_blog":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0431\u043b\u043e\u0433","edit_gallery":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0433\u0430\u043b\u0435\u0440\u0435\u044e","edit_product":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442","edit_service":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441","edit_testimonial":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0437\u044b\u0432","edit_vcard":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0438\u0437\u0438\u0442\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0443","email_address":"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enable_download_qr_code":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 QR-\u043a\u043e\u0434\u0430","enable_enquiry_form":"\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0444\u043e\u0440\u043c\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0430","enter_password":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","first_name":"\u0418\u043c\u044f","flag":"\u0424\u043b\u0430\u0433","galleries":"\u0413\u0430\u043b\u0435\u0440\u0435\u0438","gallery":"\u0413\u0430\u043b\u0435\u0440\u0435\u044f","google_analytics":"\u0413\u0443\u0433\u043b \u0410\u043d\u0430\u043b\u0438\u0442\u0438\u043a\u0430","google_config":"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f Google","header":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a","home_title":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u043c\u0430","image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","is_manual_payment":"\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e \u043e\u043f\u043b\u0430\u0442\u0435 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e","job_title":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u044b","language_enable":"\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u044f\u0437\u044b\u043a","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","last_updated":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435","location":"\u041c\u0435\u0441\u0442\u043e \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f","manage-section":"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0437\u0434\u0435\u043b\u043e\u043c","manual_payment_guide":"\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u043f\u043e \u043e\u043f\u043b\u0430\u0442\u0435 \u0432\u0440\u0443\u0447\u043d\u0443\u044e","map":"\u043a\u0430\u0440\u0442\u0430","meta_description":"\u041c\u0435\u0442\u0430-\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","meta_keyword":"\u041c\u0435\u0442\u0430 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u0441\u043b\u043e\u0432\u043e","mobile_number":"\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","new_blog":"\u041d\u043e\u0432\u044b\u0439 \u0431\u043b\u043e\u0433","new_gallery":"\u041d\u043e\u0432\u0430\u044f \u0433\u0430\u043b\u0435\u0440\u0435\u044f","new_product":"\u041d\u043e\u0432\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442","new_service":"\u041d\u043e\u0432\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430","new_testimonial":"\u041d\u043e\u0432\u044b\u0439 \u043e\u0442\u0437\u044b\u0432","new_vcard":"\u041d\u043e\u0432\u0430\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430","occupation":"\u0417\u0430\u043d\u044f\u0442\u0438\u0435","order_at":"\u0417\u0430\u043a\u0430\u0437\u0430\u043d\u043e \u0432","our_service":"\u041d\u0430\u0448\u0438 \u0443\u0441\u043b\u0443\u0433\u0438","payment_config":"\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f","preview_url":"URL-\u0430\u0434\u0440\u0435\u0441 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430","privacy_policy":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","product":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442","product_details":"\u0417\u043d\u0430\u0447\u043e\u043a \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","product_icon":"\u0417\u043d\u0430\u0447\u043e\u043a \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430","product_name":"\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430","product_transection":"\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c\u0438","products":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b","profile_image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0438\u043b\u044f","qr_code":"QR-\u043a\u043e\u0434e","qr_code_download_size":"\u0420\u0430\u0437\u043c\u0435\u0440 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 QR-\u043a\u043e\u0434\u0430","qrcode-customize":"\u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c QR-\u043a\u043e\u0434","qrcode_color":"\u0426\u0432\u0435\u0442 QR-\u043a\u043e\u0434\u0430","qrcode_customize":"\u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c QR-\u043a\u043e\u0434","qrcode_eye_style":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0438\u043b\u044c \u0433\u043b\u0430\u0437","qrcode_style":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0438\u043b\u044c","remove_branding":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433","select_template":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d","send_message":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","seo":"Motor de Otimiza\u00e7\u00e3o de Busca","service_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u043b\u0443\u0433\u0435","service_icon":"\u0417\u043d\u0430\u0447\u043e\u043a \u0441\u043b\u0443\u0436\u0431\u044b","services":"\u0423\u0441\u043b\u0443\u0433\u0438","share":"\u0434\u043e\u043b\u044f","share_my_vcard":"\u041f\u043e\u0434\u0435\u043b\u0438\u0442\u0435\u0441\u044c \u043c\u043e\u0435\u0439 \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u043e\u0439","show_qr_code":"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c QR-\u043a\u043e\u0434","site_title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0441\u0430\u0439\u0442\u0430","social-links":"\u0421\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438","social_links":"\u0421\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438","stats":"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430","status":"\u0421\u0442\u0430\u0442\u0443\u0441","template":"\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a","templates":"\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a","term-condition":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f","term-policy":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0430","term_condition":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f","term_policy":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0430","testimonial":"\u041e\u0442\u0437\u044b\u0432","testimonial_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043e\u0442\u0437\u044b\u0432\u0430","testimonials":"\u041e\u0442\u0437\u044b\u0432\u044b","theme_config":"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0442\u0435\u043c\u044b","url_alias":"\u041f\u0441\u0435\u0432\u0434\u043e\u043d\u0438\u043c URL","user":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438","user_name":"\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","vcard":"\u0432\u0438\u0437\u0438\u0442\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430","vcard_details":"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0435","vcard_is_active":"\u041a\u0430\u0440\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u043d\u0430","vcard_name":"\u0418\u043c\u044f \u0432\u0438\u0437\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438","vcard_service":"\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430"},"vcard_11":{"Latest_post":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u043f\u043e\u0441\u0442\u044b","contact_detail":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f","get_in_touch":"\u0421\u0432\u044f\u0437\u0430\u0442\u044c\u0441\u044f","my_email":"\u041c\u043e\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","my_phones":"\u041c\u043e\u0438 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u044b","provide_service":"\u041f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0438","read_more":"\u0427\u0438\u0442\u0430\u0442\u044c \u0434\u0430\u043b\u0435\u0435"},"vcards":"VCards","vcards_template":{"image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","used_count":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0441\u0447\u0435\u0442\u0447\u0438\u043a"},"vcards_templates":"\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0432\u0438\u0437\u0438\u0442\u043d\u044b\u0445 \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a","virtual_backgrounds":"\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0444\u043e\u043d\u044b","wait_for_apporove_of_cash_payment_by_admin":"\u0412\u0430\u0448 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0430 \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u0438\u0438.","weekdays":{"fri":"\u041f\u0422","mon":"\u041f\u041d","sat":"\u0421\u0438\u0434\u0435\u043b","sun":"\u0421\u041e\u041b\u041d\u0426\u0415","thu":"\u0427\u0422","tue":"\u0412\u0422","wed":"\u041c\u042b \u0411"},"your":"\u0422\u0432\u043e\u0439"},"ru.pagination":{"next":"\u0414\u0430\u043b\u0435\u0435 &raquo;","previous":"&laquo; \u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439"},"ru.passwords":{"reset":"\u0412\u0430\u0448 \u043f\u0430\u0440\u043e\u043b\u044c \u0431\u044b\u043b \u0441\u0431\u0440\u043e\u0448\u0435\u043d!","sent":"\u041c\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435!","throttled":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435, \u043f\u0440\u0435\u0436\u0434\u0435 \u0447\u0435\u043c \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u043f\u043e\u043f\u044b\u0442\u043a\u0443.","token":"\u042d\u0442\u043e\u0442 \u0442\u043e\u043a\u0435\u043d \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","user":"\u041c\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u043c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b."},"ru.validation":{"accepted":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u043d\u044f\u0442\u044b.","active_url":"\u0422\u043e :attribute \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441.","after":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 :date.","after_or_equal":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u043e\u0439 \u043f\u043e\u0441\u043b\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e\u0439 :date.","alpha":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b.","alpha_dash":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b, \u0434\u0435\u0444\u0438\u0441\u044b \u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u043f\u043e\u0434\u0447\u0435\u0440\u043a\u0438\u0432\u0430\u043d\u0438\u044f.","alpha_num":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b \u0438 \u0446\u0438\u0444\u0440\u044b.","array":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0430\u0441\u0441\u0438\u0432.","attributes":{"email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430","message":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","name":"\u0418\u043c\u044f","phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d","service_url":"Service URL"},"before":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u0430 \u0434\u043e :date.","before_or_equal":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u043e\u0439 \u0434\u043e \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e\u0439 :date.","between":{"array":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 :min \u0438 :max \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043c\u0438.","file":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 :min \u0438 :max \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u043c\u0438.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 :min \u0438 :max.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 \u0441\u0438\u043c\u0432\u043e\u043b\u0430\u043c\u0438 :min \u0438 :max."},"boolean":"\u0422\u043e :attribute field must be true or false.","confirmed":"\u0422\u043e :attribute \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442.","coupon_code":{"expired":"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u043a\u043e\u0434\u0430 \u043a\u0443\u043f\u043e\u043d\u0430 \u0438\u0441\u0442\u0435\u043a","not_found":"\u041a\u043e\u0434 \u043a\u0443\u043f\u043e\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"},"current_password":"\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0432\u0435\u0440\u0435\u043d.","custom":{"attribute-name":{"rule-name":"\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"}},"date":"\u0422\u043e :attribute \u043d\u0435 \u0432\u0435\u0440\u043d\u0430\u044f \u0434\u0430\u0442\u0430.","date_equals":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u0430, \u0440\u0430\u0432\u043d\u0430\u044f :date.","date_format":"\u0422\u043e :attribute \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 :format.","different":"\u0422\u043e :attribute \u0438 :other \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0440\u0443\u0433\u0438\u043c.","digits":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c :\u0446\u0438\u0444\u0440\u044b \u0446\u0438\u0444\u0440\u044b.","digits_between":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 \u0446\u0438\u0444\u0440\u0430\u043c\u0438 :min \u0438 :max.","dimensions":"\u0422\u043e :attribute \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.","distinct":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u0438\u043c\u0435\u0435\u0442 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0435\u0435\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.","email":"\u0422\u043e :attribute must be a valid email address.","ends_with":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0442\u044c\u0441\u044f \u043e\u0434\u043d\u0438\u043c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: :values.","exists":"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 :attribute \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","file":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b.","filled":"\u0422\u043e :attribute field must have a value.","gt":{"array":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c :value \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 :value \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 :value.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c :value \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"gte":{"array":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u044b \u0438\u043c\u0435\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b :value \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435.","file":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d :value \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e :value.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e :value \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"image":"\u0422\u043e :attribute must be an image.","in":"\u0422\u043e \u0432\u044b\u0431\u0440\u0430\u043d :attribute \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","in_array":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 :other.","integer":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c.","ip":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c IP-\u0430\u0434\u0440\u0435\u0441\u043e\u043c.","ipv4":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c IPv4.","ipv6":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c IPv6.","json":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 JSON.","lt":{"array":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0447\u0435\u043c :value \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 :value \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 :value.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 :value."},"lte":{"array":"\u0422\u043e :attribute \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u0435\u0435 :value \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0422\u043e :attribute must be less than or equal :value kilobytes.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e :value.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e :value \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"max":{"array":"\u0422\u043e :attribute \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u0435\u0435 :max \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0422\u043e :attribute \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c :max \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0422\u043e :attribute \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 :max.","string":"\u0422\u043e :attribute \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c :max \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"mimes":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: :values.","mimetypes":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: :values.","min":{"array":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 :min \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 :min \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 :min.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 :min \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"multiple_of":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043a\u0440\u0430\u0442\u043d\u043e :value.","not_in":"\u0422\u043e \u0432\u044b\u0431\u0440\u0430\u043d :attribute \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","not_regex":"\u0422\u043e :attribute \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c.","password":"\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0432\u0435\u0440\u0435\u043d.","present":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c.","prohibited":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e.","prohibited_if":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e, \u043a\u043e\u0433\u0434\u0430 :other \u0440\u0430\u0432\u043d\u043e :value.","prohibited_unless":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e, \u0435\u0441\u043b\u0438 \u0442\u043e\u043b\u044c\u043a\u043e :other \u043d\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 :values.","regex":"\u0422\u043e :attribute \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","required":"\u0422\u043e :attribute \u041f\u043e\u043b\u0435, \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","required_if":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e, \u043a\u043e\u0433\u0434\u0430 :other \u0440\u0430\u0432\u043d\u043e :value.","required_unless":"\u0422\u043e :attribute field is required unless :other is in :values.","required_with":"\u0422\u043e :attribute \u041f\u043e\u043b\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e, \u043a\u043e\u0433\u0434\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 :values.","required_with_all":"\u0422\u043e :attribute \u041f\u043e\u043b\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e, \u043a\u043e\u0433\u0434\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 :values.","required_without":"\u0422\u043e :attribute \u043f\u043e\u043b\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e, \u043a\u043e\u0433\u0434\u0430 :values \u200b\u200b\u043d\u0435\u0442.","required_without_all":"\u0422\u043e :attribute \u041f\u043e\u043b\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c, \u0435\u0441\u043b\u0438 \u043d\u0438 \u043e\u0434\u043d\u043e \u0438\u0437 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 :value \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.","same":"\u0422\u043e :attribute \u0438 :other \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c.","size":{"array":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b :size.","file":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c :size \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c: \u0440\u0430\u0437\u043c\u0435\u0440.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c :size \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"starts_with":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445: :values.","string":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0430.","timezone":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u043c \u0447\u0430\u0441\u043e\u0432\u044b\u043c \u043f\u043e\u044f\u0441\u043e\u043c.","unique":"\u0422\u043e :attribute \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e.","uploaded":"\u0422\u043e :attribute \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c.","url":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c URL.","uuid":"\u0422\u043e :attribute \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u043c UUID."},"sk.cookie-consent::texts":{"agree":"S\u00fahlas\u00edm","message":"T\u00e1to str\u00e1nka pou\u017e\u00edva cookies na vylep\u0161enie v\u00e1\u0161ho u\u017e\u00edvate\u013esk\u00e9ho z\u00e1\u017eitku."},"sk.cookieConsent::texts":{"agree":"S\u00fahlas\u00edm","message":"T\u00e1to str\u00e1nka pou\u017e\u00edva cookies na vylep\u0161enie v\u00e1\u0161ho u\u017e\u00edvate\u013esk\u00e9ho z\u00e1\u017eitku."},"sv.cookie-consent::texts":{"agree":"Jag f\u00f6rst\u00e5r","message":"Vi anv\u00e4nder kakor (cookies) f\u00f6r att webbplatsen ska fungera p\u00e5 ett bra s\u00e4tt f\u00f6r dig. Genom att surfa vidare godk\u00e4nner du att vi anv\u00e4nder kakor."},"sv.cookieConsent::texts":{"agree":"Jag f\u00f6rst\u00e5r","message":"Vi anv\u00e4nder kakor (cookies) f\u00f6r att webbplatsen ska fungera p\u00e5 ett bra s\u00e4tt f\u00f6r dig. Genom att surfa vidare godk\u00e4nner du att vi anv\u00e4nder kakor."},"th.cookie-consent::texts":{"agree":"\u0e15\u0e01\u0e25\u0e07","message":"\u0e40\u0e23\u0e32\u0e43\u0e0a\u0e49\u0e04\u0e38\u0e01\u0e01\u0e35\u0e49\u0e40\u0e1e\u0e37\u0e48\u0e2d\u0e40\u0e1e\u0e34\u0e48\u0e21\u0e1b\u0e23\u0e30\u0e2a\u0e1a\u0e01\u0e32\u0e23\u0e13\u0e4c\u0e43\u0e19\u0e01\u0e32\u0e23\u0e40\u0e22\u0e35\u0e48\u0e22\u0e21\u0e0a\u0e21\u0e40\u0e27\u0e47\u0e1a\u0e44\u0e0b\u0e15\u0e4c\u0e19\u0e35\u0e49 \u0e2d\u0e13\u0e38\u0e0d\u0e32\u0e15\u0e04\u0e38\u0e01\u0e01\u0e35\u0e49\u0e40\u0e1e\u0e37\u0e48\u0e2d\u0e23\u0e31\u0e1a\u0e1b\u0e23\u0e30\u0e2a\u0e1a\u0e01\u0e32\u0e23\u0e13\u0e4c\u0e17\u0e35\u0e48\u0e14\u0e35\u0e02\u0e36\u0e49\u0e19"},"th.livewire-tables::strings":{"All":"\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","Applied Filters":"\u0e01\u0e23\u0e2d\u0e07\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e15\u0e32\u0e21","Applied Sorting":"\u0e40\u0e23\u0e35\u0e22\u0e07\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e15\u0e32\u0e21","Bulk Actions":"\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e01\u0e32\u0e23\u0e01\u0e23\u0e30\u0e17\u0e33","Clear":"\u0e25\u0e49\u0e32\u0e07\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","Columns":"\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e04\u0e2d\u0e25\u0e31\u0e21\u0e19\u0e4c","Done Reordering":"\u0e08\u0e31\u0e14\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e41\u0e25\u0e49\u0e27","Filters":"\u0e15\u0e31\u0e27\u0e01\u0e23\u0e2d\u0e07","No items found. Try to broaden your search.":"\u0e44\u0e21\u0e48\u0e1e\u0e1a\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e04\u0e49\u0e19\u0e2b\u0e32","Remove filter option":"\u0e40\u0e2d\u0e32\u0e15\u0e31\u0e27\u0e01\u0e23\u0e2d\u0e07\u0e2d\u0e2d\u0e01","Remove sort option":"\u0e40\u0e2d\u0e32\u0e01\u0e32\u0e23\u0e40\u0e23\u0e35\u0e22\u0e07\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e2d\u0e2d\u0e01","Reorder":"\u0e08\u0e31\u0e14\u0e25\u0e33\u0e14\u0e31\u0e1a","Search":"\u0e04\u0e49\u0e19\u0e2b\u0e32...","Select All":"\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","Showing":"\u0e41\u0e2a\u0e14\u0e07","Unselect All":"\u0e44\u0e21\u0e48\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","You are currently selecting all":"\u0e02\u0e13\u0e30\u0e19\u0e35\u0e49\u0e04\u0e38\u0e13\u0e44\u0e14\u0e49\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e38\u0e01\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","You are not connected to the internet.":"\u0e02\u0e13\u0e30\u0e19\u0e35\u0e49\u0e04\u0e38\u0e13\u0e44\u0e21\u0e48\u0e44\u0e14\u0e49\u0e40\u0e0a\u0e37\u0e48\u0e2d\u0e21\u0e15\u0e48\u0e2d\u0e01\u0e31\u0e1a\u0e2d\u0e34\u0e19\u0e40\u0e17\u0e2d\u0e23\u0e4c\u0e40\u0e19\u0e47\u0e15","You have selected":"\u0e04\u0e38\u0e13\u0e40\u0e25\u0e37\u0e2d\u0e01","of":"\u0e08\u0e32\u0e01","results":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","row":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","rows":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","rows, do you want to select all":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23, \u0e04\u0e38\u0e13\u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","to":"-"},"tk.livewire-tables::strings":{"All":"Hemmesi","All Columns":"Colhli s\u00fct\u00fcnler","Applied Filters":"Ulanyl\u00fdan S\u00fczg\u00fc\u00e7ler","Applied Sorting":"Ulanyl\u00fdan Tertiple\u015fdirme","Bulk Actions":"K\u00f6p\u00e7\u00fclikle\u00fdin Hereketler","Clear":"Arassala","Columns":"S\u00fct\u00fcnler","Debugging Values":"Gymmatlyklary d\u00fczetmek","Deselect All":"Hemmesini A\u00fdyr","Done Reordering":"T\u00e4zeden Tertiplendi","Filters":"S\u00fczg\u00fc\u00e7ler","No":"Hayir","No items found. Try to broaden your search.":"Hi\u00e7 zat tapylmady. G\u00f6zlegi\u0148izi gi\u0148eltm\u00e4ge synany\u015fy\u0148.","Remove filter option":"S\u00fczg\u00fc\u00e7 g\u00f6rn\u00fc\u015fini a\u00fdyry\u0148","Remove sort option":"Tertiplemek g\u00f6rn\u00fc\u015fini a\u00fdyry\u0148","Reorder":"Tertibe salmak","Search":"G\u00f6zlemek","Select All":"Hepsini se\u00e7","Showing":"G\u00f6rkezmek","Yes":"Evet","You are currently selecting all":"H\u00e4zirki wagtda hemmesini sa\u00fdlap al\u00fdarsy\u0148yz","You are not connected to the internet.":"Siz internete birikmediksi\u0148iz.","You have selected":"Sa\u00fdlady\u0148yz","of":"aralygy","results":"netijeler","row":"hatarlar","rows":"hatarlar","rows, do you want to select all":"hatarlar, hemmesini sa\u00fdlamak isle\u00fd\u00e4rsi\u0148izmi?","to":"-"},"tr.auth":{"about":"Hakk\u0131nda","account_deactivate":"Hesab\u0131n\u0131z \u015fu anda etkin de\u011fil, l\u00fctfen y\u00f6netici ile ileti\u015fime ge\u00e7in.","app":{"create":"Yaratmak","export":"\u0130hracat","lock_account":"Kilitli hesap","member_since":"Den beri \u00fcye","messages":"Mesajlar","online":"\u0130nternet \u00fczerinden","print":"Yazd\u0131r","profile":"Profil","reload":"Tekrar y\u00fckle","reset":"S\u0131f\u0131rla","search":"Aramak","settings":"Ayarlar"},"choose_a_plan_that's_right_for_you":"Size uygun bir plan se\u00e7in","confirm_password":"\u015eifreyi Onayla","contact":"Temas","copyright_by":"Telif hakk\u0131 sahibi taraf\u0131ndan","email":"E-posta","email_verify":"L\u00fctfen giri\u015f yapmadan \u00f6nce e-posta adresinizi do\u011frulay\u0131n.","emails":{"password":{"reset_link":"\u015eifrenizi s\u0131f\u0131rlamak i\u00e7in buraya t\u0131klay\u0131n"}},"failed":"Bu kimlik bilgileri kay\u0131tlar\u0131m\u0131zla e\u015fle\u015fmiyor.","features":"\u00d6zellikleri","forgot_password":{"send_pwd_reset":"\u015eifre S\u0131f\u0131rlama Ba\u011flant\u0131s\u0131n\u0131 G\u00f6nder","title":"\u015eifreyi s\u0131f\u0131rlamak i\u00e7in E-posta girin"},"full_name":"Ad Soyad","get_started":"Ba\u015flamak","home":"Ev","let's_hear_what_they_say":"Ne Dediklerini Duyal\u0131m","login":{"forgot_password":"\u015eifremi Unuttum","register_membership":"Yeni bir \u00fcyelik kaydedin","title":"Oturumunuzu ba\u015flatmak i\u00e7in oturum a\u00e7\u0131n"},"modern_&_powerful_interface":"Modern ve G\u00fc\u00e7l\u00fc Aray\u00fcz","password":"Parola","pricing":"fiyatland\u0131rma","register":"Kay\u0131t olmak","registration":{"have_membership":"zaten \u00fcyeli\u011fim var","i_agree":"a kat\u0131l\u0131yorum","terms":"\u015fartlar","title":"Yeni bir \u00fcyelik kaydedin"},"remember_me":"Beni hat\u0131rla","reset_password":{"reset_pwd_btn":"\u015eifreyi yenile","title":"\u015fifrenizi s\u0131f\u0131rlay\u0131n"},"sign_in":"Kay\u0131t olmak","sign_out":"oturumu Kapat","sign_up":"\u00dcye olmak","stories_from_our_customers":"M\u00fc\u015fterilerimizden Hikayeler","subscribe_here":"Abone olun","throttle":"\u00c7ok fazla giri\u015f denemesi. L\u00fctfen :saniye saniye sonra tekrar deneyin."},"tr.cookie-consent::texts":{"agree":"\u00c7erezlere izin ver","message":"Bu sitedeki deneyiminizi \u00e7erezlere izin vererek geli\u015ftirebilirsiniz."},"tr.cookieConsent::texts":{"agree":"\u00c7erezlere izin ver","message":"Bu sitedeki deneyiminizi \u00e7erezlere izin vererek geli\u015ftirebilirsiniz."},"tr.crud":{"action":"Eylem","add_new":"Yeni ekle","are_you_sure":"Emin misin?","back":"geri","cancel":"\u0130ptal etmek","created_at":"Olu\u015fturulma Tarihi","deleted_at":"Silinme Tarihi","detail":"detay","edit":"D\u00fczenlemek","id":"\u0130D","save":"Kay\u0131t etmek","updated_at":"G\u00fcncellenme Tarihi"},"tr.livewire-tables::strings":{"All":"T\u00fcm","Applied Filters":"Uygulanan Filtreler","Applied Sorting":"Uygulamal\u0131 S\u0131ralama","Bulk Actions":" toplu eylemler","Clear":"\u00e7\u00f6zmek","Columns":"s\u00fctunlar","Done Reordering":"yeniden s\u0131raland\u0131  ","Filters":"Filtreler","No items found. Try to broaden your search.":"Hi\u00e7bir \u00f6\u011fe bulunamad\u0131. Araman\u0131z\u0131 geni\u015fletmeye \u00e7al\u0131\u015f\u0131n.","Remove filter option":"Filtre se\u00e7ene\u011fini kald\u0131r","Remove sort option":"S\u0131ralama se\u00e7ene\u011fini kald\u0131r","Reorder":"yeniden s\u0131ralamak","Search":"Srama","Select All":"Hepsini se\u00e7","Show":"G\u00f6stermek","Showing":"g\u00f6steriliyor","Unselect All":"Hi\u00e7birini se\u00e7me","You are currently selecting all":"\u015eu anda hepsini se\u00e7iyorsun","You are not connected to the internet.":"\u0130nternete ba\u011fl\u0131 de\u011filsiniz.","You have selected":"Sen se\u00e7ilmi\u015fsin","of":"itibaren","results":"Sonu\u00e7lar","rows":"\u00e7izgiler","rows, do you want to select all":"sat\u0131rlar, hepsini se\u00e7mek istiyor musunuz?","to":"ile"},"tr.messages":{"Business_Beacon":"\u0130\u015f \u0130\u015fareti","CEO\/CXO":"'Kurumsal CEO'lar\/CXO'lar vCard'","Clean_Canvas":"Kanvas\u0131 Temizle","Corporate_Classic":"Kurumsal Klasik","Corporate_Connect":"Kurumsal Ba\u011flant\u0131","Corporate_Identity":"Kurumsal kimlik","Culinary_Food_Services":"A\u015f\u00e7\u0131l\u0131k ve Yemek Hizmetleri vCard","Event_Management":"Olay y\u00f6netimi","Executive_Profile":"Y\u00f6netici Profili","Fashion_Beauty":"Moda ve G\u00fczellik vCard","Gym":"Spor salonu","Hospital":"Hastane","Lawyer":"Avukat","Manually":"Manuel olarak","Modern_Edge":"Modern Kenar","Paypal":"PayPal","Portfolio":"Portf\u00f6y","Pro_Network":"Profesyonel A\u011f","Professional":"Profesyonel","Programmer":"Programc\u0131","Razorpay":"Razorpay","Receive_latest_news_update_and_many_other_things_every_week":"Her hafta en son haberleri, g\u00fcncellemeleri ve daha bir\u00e7ok \u015feyi al\u0131n.","Salon":"Salon","Simple_Contact":"Basit \u0130leti\u015fim","Social_Media":"Sosyal Medya Etkileyicileri vCard","Stripe":"\u015eerit","Subscribe_Our_Newsletter":"B\u00fcltenimize Abone Olun","about_us":{"about_us":"Hakk\u0131m\u0131zda","description":"A\u00e7\u0131klama","image":"Resim Hakk\u0131nda","title":"Ba\u015fl\u0131k"},"admin":{"add_admin":"Y\u00f6netici Ekle","admin":"y\u00f6netici","admin_created_successfully":"Y\u00f6netici Ba\u015far\u0131yla Olu\u015fturuldu.","admin_delete_successfully":"Y\u00f6netici ba\u015far\u0131yla silindi.","admin_details":"Y\u00f6netici Ayr\u0131nt\u0131lar\u0131","admin_updated_successfully":"Y\u00f6netici Ba\u015far\u0131yla G\u00fcncellendi.","avatar":"Avatar","confirm_password":"\u015eifreyi Onayla","contact_number":"\u0130leti\u015fim numaras\u0131","edit_admin":"Y\u00f6neticiyi D\u00fczenle","email":"E-posta","female":"Di\u015fi","first_name":"\u0130lk ad\u0131","full_name":"Ad Soyad","gender":"Cinsiyet","last_name":"Soyad\u0131","male":"Erkek","not_allowed_to_access":"G\u00f6r\u00fcn\u00fc\u015fe g\u00f6re bu kayda eri\u015fmenize izin verilmiyor.","password":"Parola","profile":"Profil","profile_details":"Profil detaylar\u0131"},"admins":"Y\u00f6neticiler","affiliation":{"affiliate_note":"L\u00fctfen unutmay\u0131n: \u00dcyelik ayr\u0131nt\u0131lar\u0131n\u0131z vcards en bas sayfan\u0131zda yay\u0131nlanacakt\u0131r. Cella arac\u0131l\u0131\u011f\u0131yla kaydolursan\u0131z ve cella'dan sonra bir abonelik al\u0131rsan\u0131z, tutar\u0131nda \u00f6d\u00fcllendirileceksiniz.","affiliated_by":"Ba\u011fl\u0131 Oldu\u011fu","affiliation_transaction":"\u00dcyelik \u0130\u015flemleri","affiliation_withdraw_detail":"para \u00e7ekme detay\u0131","affiliations":"Ba\u011flant\u0131lar","approval_status":"Onay durumu","approve":"Onaylamak","approve_withdraw_request":"Geri \u00c7ekme Talebini Onayla","approved":"Onayl\u0131","cash_payment":"Nakit \u00f6demeler","current_amount":"Cari Tutar","reject":"Reddetmek","reject_withdraw_request":"Geri \u00c7ekme Talebini Reddet","rejected":"Reddedildi","rejection_note":"notu reddet","total_affiliation_amount":"Toplam \u00dcyelik Tutar\u0131","verify_paypal_email":"Paypal E-postas\u0131n\u0131 Do\u011frula","withdraw_amount":"\u00c7ekilen Tutar","withdrawal":"Para \u00e7ekme"},"allowed_file_types":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","analytic":{"vcard_analytic":"Vcard Analiti\u011fi"},"analytics":{"browsers":"taray\u0131c\u0131lar","countries":"\u00dclkeler","devices":"Cihazlar","languages":"Diller","os":"\u0130\u015fletim sistemleri","overview":"genel bak\u0131\u015f","see_all":"Hepsini g\u00f6r","view_more":"Daha fazla g\u00f6ster","visitors":"Ziyaret\u00e7i"},"appointment":{"appointment":"Randevu","appointment_details":"Randevu Detaylar\u0131","appointment_type":"Randevu Tipi :","calendar":"Takvim","ends":"Randevu Biti\u015f","free":"\u00d6zg\u00fcr","paid":"Paral\u0131","starts":"Randevu Ba\u015fl\u0131yor"},"appointments":"Randevular","business":{"business_hours":"\u0130\u015f vakitleri","end_time":"Biti\u015f zaman\u0131","fri":"Cuma","mon":"Pzt","sat":"Oturdu","start_time":"Ba\u015flang\u0131\u00e7 saati","sun":"Pazar","thu":"Toplamak","tue":"sal","wed":"evlenmek"},"by_signing_up_you_agree_to_our":"Kaydolarak \u015funlar\u0131 kabul etmi\u015f olursunuz:","cash_payment":"Nakit \u00f6demeler","city":{"cities":"\u015eehirler","city":"\u015eehir","city_name":"\u015eehir \u0130smi","edit_city":"\u015eehri D\u00fczenle","new_city":"Yeni \u015fehir","no_city_available":"\u015eehir Yok","no_city_found":"\u015eehir Bulunamad\u0131","state_name":"Devlet ad\u0131"},"common":{"Yes_Change":"Evet, De\u011fi\u015ftir","action":"Eylem","active":"Aktif","add":"Eklemek","add_virtual_background":"Sanal Arka Plan Ekle","allow_cookies":"\u00c7erezlere izin ver","already_have_an_account":"Zaten hesab\u0131n\u0131z var m\u0131","apply":"Uygulamak","apply_changes":"Bu De\u011fi\u015fiklikleri Uygula","are_you_completed":"Bu durumu de\u011fi\u015ftirmek istedi\u011finizden emin misiniz?","are_you_sure":"Bunu silmek istedi\u011finizden emin misiniz?","are_you_sure_dublicate_vcard":"Bu VCard'\u0131n kopyas\u0131n\u0131 olu\u015fturmak istedi\u011finizden emin misiniz?","back":"Geri","back_subscription":"Aboneliklere Geri D\u00f6n","cancel":"\u0130ptal etmek","captcha_enable":"Google Captcha'y\u0131 etkinle\u015ftirin","closed":"Kapal\u0131","completed":"Tamamlamak","cookie_banner_enabled":"\u00c7erez Ba\u015fl\u0131\u011f\u0131 Etkinle\u015ftir","cookie_msg":"Bu sitedeki deneyiminiz, \u00e7erezlere izin verilerek geli\u015ftirilecektir.","create_an_account":"Bir hesap olu\u015fturun","currency_position":"D\u00f6viz Pozisyonu","custom":"Gelenek","declined":"Reddetmek","default_country_code":"Varsay\u0131lan \u00dclke Kodu","delete":"Silmek","deleted":"silindi","description":"A\u00e7\u0131klama","details":"Detaylar","discard":"atmak","download":"\u0130ndirmek","duplicate":"Kopyalamak !","duplicate_vcard_create":"Yinelenen Vcard ba\u015far\u0131yla olu\u015fturuldu","edit":"D\u00fczenlemek","email":"E-posta","enable_cookie_banner":"\u00c7erez Afi\u015fini Etkinle\u015ftir","enable_page":"A\u00e7\u0131l\u0131\u015f Sayfas\u0131n\u0131 Etkinle\u015ftir","enable_register":"Kayd\u0131 Etkinle\u015ftir","enable_validation":"Do\u011frulamay\u0131 etkinle\u015ftir","enquiry":"Ara\u015ft\u0131rma","error":"Hata","filter":"filtre","forgot_password":"Parolan\u0131z\u0131 m\u0131 unuttunuz","forgot_your_password":"Parolan\u0131z\u0131 m\u0131 unuttunuz","from":"\u0130tibaren","has_been_completed":"Tamamlanm\u0131\u015f.","has_been_deleted":"silindi.","icon":"simge","inactive":"etkin de\u011fil","infyvcard":"InfyVcard","is_active":"Aktif","link":"Ba\u011flant\u0131","loading":"Y\u00fckleniyor...","login":"Giri\u015f yapmak","logout":"\u00c7\u0131k\u0131\u015f Yap","message":"\u0130leti","name":"\u0130sim","new_here":"Burada yeni","no":"Hay\u0131r, \u0130ptal","no_data_available":"No Data Available","notUsed":"Hen\u00fcz kullan\u0131lmad\u0131","ok":"Tamam","payment_methods":"\u00d6deme \u015fekli","paypal_email":"Paypal E-postas\u0131","pending":"Beklemek","phone":"Telefon","phone_validation":"Telefon Numaras\u0131 do\u011frulama","please_wait":"L\u00fctfen bekle...","price":"Fiyat","product_url":"\u00dcr\u00fcn URL'si","register":"Kay\u0131t olmak","register_enable":"Kay\u0131t Etkinle\u015ftir","remember_me":"Remember me","reset":"S\u0131f\u0131rla","save":"Kay\u0131t etmek","service_url":"hizmet URL'si","show_currency_behind":"Para Birimini Arkas\u0131nda G\u00f6ster","sign_in_here":"Oturum a\u00e7\u0131n","status":"Durum","sub_text":"Alt Metin","subject":"Ders","submit":"G\u00f6ndermek","successful":"Ba\u015far\u0131l\u0131","to":"\u0130le","today":"Bug\u00fcn","today_appointments":"Bug\u00fcnk\u00fc Randevular","today_enquiry":"Bug\u00fcn Sorular","total__active_vcards":"Toplam Aktif Kartlar","total__deactive_vcards":"Toplam Devre D\u0131\u015f\u0131 B\u0131rak\u0131lan VCard Say\u0131s\u0131","total_active_users":"Toplam Aktif Kullan\u0131c\u0131","total_amount":"Toplam tutar","total_deactive_users":"Toplam devre d\u0131\u015f\u0131 b\u0131rak\u0131lan Kullan\u0131c\u0131lar","total_plans":"Toplam Planlar","total_users":"Toplam Kullan\u0131c\u0131lar","total_vcards":"Toplam VC Kartlar\u0131","type":"Tip","unavailable":"Kullan\u0131m d\u0131\u015f\u0131","upload_file":"Dosya y\u00fckleme","user":"kullan\u0131c\u0131","view":"g\u00f6r\u00fc\u015f","virtual_note":"Not : Sanal Arka Planlar size logonuzun, ad\u0131n\u0131z\u0131n, adresinizin ve telefonunuzun yaz\u0131laca\u011f\u0131 kartvizit resimlerini verecektir. NFC kart\u0131n\u0131z\u0131 tasarlamak istedi\u011finizde kullan\u0131\u015fl\u0131 olacak standart boyutlarda yatay ve dikey sanal arka planlar d\u0131\u015fa aktar\u0131yoruz, bu g\u00f6r\u00fcnt\u00fcleri do\u011frudan NFC bask\u0131 i\u015fleyicilerine verebilirsiniz. Ayr\u0131ca bunu do\u011frudan arkada\u015flar\u0131n\u0131zla da payla\u015fabilir veya profil\/kapak resmi olarak ayarlayabilirsiniz.","yes":"Evet, Sil","yes_duplicate":"Evet \u00c7o\u011falt!"},"contact_us":{"contact":"Bizimle ileti\u015fime ge\u00e7in","contact_us":"Ara\u015ft\u0131rma","inquries":"Ara\u015ft\u0131rma","message":"\u0130leti","send_message":"Mesaj g\u00f6nder"},"copy_text":"kopyala","country":{"countries":"\u00dclkeler","country":"\u00dclke","country_name":"\u00dclke ad\u0131","edit_country":"\u00dclkeyi D\u00fczenle","new_country":"Yeni \u00fclke","no_country_available":"Kullan\u0131labilir \u00dclke Yok","no_country_found":"\u00dclke Bulunamad\u0131","phone_code":"Telefon Kodu","short_code":"K\u0131sa kod"},"coupon_code":{"add_coupon_code":"Kupon Kodu Ekle","apply_here":"Buraya ba\u015fvurun","coupon_code":"Kupon Kodu","coupon_code_applied":"Kupon Kodu Ba\u015far\u0131yla Uyguland\u0131.","coupon_code_created":"Kupon Kodu ba\u015far\u0131yla olu\u015fturuldu.","coupon_code_percent_validation":"Kupon indirimi %100'den fazla olmamal\u0131d\u0131r.","coupon_code_status_updated":"Kupon Kodu durumu ba\u015far\u0131yla g\u00fcncellendi.","coupon_code_updated":"Kupon Kodu ba\u015far\u0131yla g\u00fcncellendi.","coupon_codes":"Kupon Kodlar\u0131","coupon_discount":"Kupon \u0130ndirimi","coupon_name":"Kupon Ad\u0131","coupon_type":"Kupon T\u00fcr\u00fc","edit_coupon_code":"Kupon Kodunu D\u00fczenle","enter_coupon_code":"Kupon kodunu girin","enter_coupon_discount":"Kupon \u0130ndirimi Girin","enter_coupon_name":"Kupon Ad\u0131n\u0131 Girin","expire_at":"Son Kullanma Tarihi","fixed":"Sabit Tip","flat":"D\u00fcz","have_a_coupon_code":"Kupon kodun var m\u0131 ?","percentage":"Y\u00fczde","remove":"Kald\u0131rmak"},"create_vcard":"VCard'\u0131n\u0131z\u0131 Olu\u015fturun","create_your_business_digital_card_with_lots_of_information":"\u00c7ok say\u0131da bilgi i\u00e7eren dijital i\u015fletme kart\u0131n\u0131z\u0131 olu\u015fturun","currency":{"currencies":"para birimleri","currency_code":"Para Birimi Kodu","currency_icon":"para birimi simgesi"},"dashboard":"Panolar","date":"Tarih","deactivate":"Devre d\u0131\u015f\u0131 b\u0131rakmak","e_card":{"add_ecard":"E-kart ekle","ecard":"E-kart","ecard_info":"Resim 150 x 150 piksel boyutunda olmal\u0131d\u0131r","ecard_logo":"E-kart logosu","ecards":"E-kartlar"},"edit_subscription":"Abonelik Plan\u0131n\u0131 D\u00fczenle","email_not_found":"Bu e-posta adresine sahip bir kullan\u0131c\u0131 bulam\u0131yoruz","email_password_reset_link":"E-posta \u015eifre S\u0131f\u0131rlama Ba\u011flant\u0131s\u0131","enquiry":"Ara\u015ft\u0131rma","enquiry_detail":"sorgu detaylar\u0131","expire_in":"Plan\u0131n s\u00fcresi dolmak \u00fczere","extra_scripts":"Ekstra Komut Dosyalar\u0131","feature":{"affiliation":"\u00fcyelik","analytics":"Analitik","appointments":"Randevular","blog":"Blog","custom_css":"\u00d6zel CSS","custom_fonts":"\u00d6zel yaz\u0131 tipleri","custom_js":"\u00d6zel JS","custom_qrcode":"\u00d6zel QR Kodu","description":"A\u00e7\u0131klama","edit_feature":"\u00d6zelli\u011fi D\u00fczenle","enquiry_form":"Talep Formu","feature_image":"\u00d6zellik Resmi","gallery":"Galeri","hide_branding":"Markalamay\u0131 Gizle","image":"resim","name":"\u0130sim","order_nfc_card":"NFC Kart\u0131 Sipari\u015f Et","password":"\u015eifre Korumas\u0131","products":"\u00dcr\u00fcnler","products_services":"Hizmetler","seo":"Arama motoru optimizasyonu","social_links":"Sosyal Ba\u011flant\u0131lar","testimonials":"referanslar"},"features":"\u00d6zellikleri","flash":{"about_us_create":"Hakk\u0131m\u0131zda ba\u015far\u0131yla kaydedildi.","can_not_change_time_format":"Randevu bu saat bi\u00e7imi i\u00e7in zaten rezerve edildi","city_create":"\u015eehir ba\u015far\u0131yla kaydedildi.","city_update":"\u015eehir ba\u015far\u0131yla g\u00fcncellendi.","country_create":"\u00dclke ba\u015far\u0131yla kaydedildi.","country_update":"\u00dclke ba\u015far\u0131yla g\u00fcncellendi.","country_used":"\u00dclke zaten kullan\u0131l\u0131yor","create_blog":"Blog Ayr\u0131nt\u0131lar\u0131VCard blogu ba\u015far\u0131yla olu\u015fturuldu.","create_front_testimonial":"Referans ba\u015far\u0131yla olu\u015fturuldu.","create_product":"VCard \u00fcr\u00fcn\u00fc ba\u015far\u0131yla olu\u015fturuldu.","create_service":"VCard hizmeti ba\u015far\u0131yla olu\u015fturuldu.","create_testimonial":"VCard referans\u0131 ba\u015far\u0131yla olu\u015fturuldu.","current_invalid":"Mevcut \u015fifre ge\u00e7ersiz.","database_upgrade_succesfully":"Veritaban\u0131n\u0131z ba\u015far\u0131yla y\u00fckseltildi","decription_is_required":"A\u00e7\u0131klama alan\u0131 zorunludur","feature_update":"\u00d6zellik ba\u015far\u0131yla g\u00fcncellendi.","front_cms":"\u00d6n CMS ba\u015far\u0131yla g\u00fcncellendi.","language_update":"Dil ba\u015far\u0131yla g\u00fcncellendi.","mobile_validation":"Mobil do\u011frulama ba\u015far\u0131yla g\u00fcncellendi","name_is_required":"Ad alan\u0131 zorunludur","password_update":"\u015eifre ba\u015far\u0131yla g\u00fcncellendi.","plan_create":"Plan ba\u015far\u0131yla olu\u015fturuldu.","plan_default":"Varsay\u0131lan plan ba\u015far\u0131yla de\u011fi\u015ftirildi.","plan_status":"Plan durumu ba\u015far\u0131yla g\u00fcncellendi","plan_update":"Plan ba\u015far\u0131yla g\u00fcncellendi.","setting_update":"Ayarlar ba\u015far\u0131yla g\u00fcncellendi.","social_links_img_is_required":"Sosyal ba\u011flant\u0131lar Resim gereklidir","social_links_is_required":"sosyal ba\u011flant\u0131lar gereklidir","state_create":"Durum ba\u015far\u0131yla kaydedildi.","state_update":"Durum ba\u015far\u0131yla g\u00fcncellendi.","state_used":"Halihaz\u0131rda kullan\u0131l\u0131yor","success_theme_update":"Tema Ba\u015far\u0131yla G\u00fcncellendi","update_blog":"VCard blogu ba\u015far\u0131yla g\u00fcncellendi.","update_front_testimonial":"Referans ba\u015far\u0131yla g\u00fcncellendi.","update_product":"VCard \u00fcr\u00fcn\u00fc ba\u015far\u0131yla g\u00fcncellendi.","update_service":"VCard hizmeti ba\u015far\u0131yla g\u00fcncellendi.","update_testimonial":"VCard referans\u0131 ba\u015far\u0131yla g\u00fcncellendi.","user_create":"Kullan\u0131c\u0131 ba\u015far\u0131yla olu\u015fturuldu.","user_profile":"Kullan\u0131c\u0131 profili ba\u015far\u0131yla g\u00fcncellendi.","user_status":"Kullan\u0131c\u0131 durumu ba\u015far\u0131yla g\u00fcncellendi","user_update":"Kullan\u0131c\u0131 ba\u015far\u0131yla g\u00fcncellendi.","vcard_create":"VCard ba\u015far\u0131yla olu\u015fturuldu.","vcard_delete":"VCard ba\u015far\u0131yla silindi.","vcard_retrieve":"VCard ba\u015far\u0131yla al\u0131nd\u0131","vcard_status":"VCard durumu ba\u015far\u0131yla g\u00fcncellendi","vcard_update":"ba\u015far\u0131yla g\u00fcncellendi.","verified_email":"E-posta ba\u015far\u0131yla do\u011fruland\u0131"},"font":{"font_family":"Font ailesi","font_size":"Yaz\u0131 Boyutu","font_size_in_px":"Piksel cinsinden yaz\u0131 tipi boyutu","fonts":"yaz\u0131 tipleri","px":"piksel"},"form":{"DOB":"Do\u011fum Tarihini Girinh","allowed_vcard":"\u0130zin Verilen Vcard Say\u0131s\u0131n\u0131 Girin","blog":"Blog Ad\u0131n\u0131 Girin","c_password":"\u015eifreyi Onayla","company":"\u015eirket Ad\u0131n\u0131 Girin","contact":"Telefon numaras\u0131","css":"\u00d6zel Css'yi girin","description":"VCard'\u0131n\u0131z\u0131n A\u00e7\u0131klamas\u0131n\u0131 Girin","designation":"Tan\u0131m\u0131 Girin","email":"Email adresini gir","enter_email":"E-posta Girin","enter_name":"\u0130sim giriniz","enter_phone":"Telefon Girin","enter_trial":"Deneme G\u00fcnlerini Girin","f_name":"Ad\u0131 Girin","facebook":"Facebook URL","first_name":"\u0130lk ad\u0131","google_analytics":"Google Analytics Kodu","home_title":"Ana Ba\u015fl\u0131k Girin","instagram":"Instagram URL'si","job":"\u0130\u015f Unvan\u0131n\u0131 Girin","js":"\u00d6zel J'leri Girin","l_name":"Soy ad\u0131n\u0131 gir","last_name":"Soy isim","linkedin":"LinkedIn URL'si","location":"Bulundu\u011funuz yeri girin","location_url":"Konum URL'nizi Girin","mail":"E-posta","meta_description":"Meta A\u00e7\u0131klama Girin","meta_keyword":"Meta Anahtar Kelime Girin","my_vcard_url":"vcard-sayfam-url'm","occupation":"Meslek Girin","password":"\u015eifre","phone":"Telefon Numaras\u0131n\u0131 Girin","pick_date":"Bir tarih se\u00e7in","pinterest":"Pinterest URL'si","plan_name":"Plan Ad\u0131n\u0131 Girin","price":"Fiyat Girin","product":"\u00dcr\u00fcn Ad\u0131n\u0131 Girin","product_url":"\u00dcr\u00fcn URL'sini Girin","reddit":"Reddit URL'si","select_country":"\u00dclke Se\u00e7","select_currency":"Para birimini se\u00e7in","select_state":"Eyalet Se\u00e7","service":"Enter Service Name","service_url":"Hizmet URL'sini girin","short_description":"K\u0131sa A\u00e7\u0131klama Girin","site_title":"Site Ba\u015fl\u0131\u011f\u0131n\u0131 Girin","testimonial":"Referans Ad\u0131n\u0131 Girin","tiktok":"URL'ye t\u0131klay\u0131n","tumblr":"Tumblr URL'si","twitter":"Twitter URL'si","type_message":"Buraya bir mesaj yaz\u0131n...","vcard_name":"VCard Ad\u0131n\u0131 Girin","website":"Web Sitesi URL'si","whatsapp":"Whatsapp URL'si","your_email":"E-posta adresiniz","your_name":"Ad\u0131n\u0131z","youtube":"Youtube URL'si"},"from_time":"Zamandan","front":{"enter_your_email":"E-postan\u0131z\u0131 giriniz","enter_your_message":"Mesaj\u0131n\u0131z\u0131 Girin","enter_your_name":"Ad\u0131n\u0131z\u0131 giriniz","your_email_address":"E-posta adresiniz"},"front_cms":{"banner":"Afi\u015f Resmi","description":"A\u00e7\u0131klama","front_cms":"\u00d6n CMS","title":"Ba\u015fl\u0131k"},"gallery":{"gallery_name":"Galeriler","image":"resim","type":"Tip","youtube":"Youtube"},"hour":"Saat","language":"Dilim","languages":{"edit_language":"Dili D\u00fczenle","edit_translation":"\u00c7eviriyi D\u00fczenle","iso_code":"ISO KODU","language":"Dilim","languages":"Diller","new_language":"Yeni dil","translation":"Terc\u00fcme"},"made_by":"Yapan","made_by_url":"Url Taraf\u0131ndan Yap\u0131lan","mail":{"action_required":"Bir hesap olu\u015fturmad\u0131ysan\u0131z, ba\u015fka bir i\u015flem yapman\u0131z gerekmez.","appointment_time":"Bulu\u015fma zaman\u0131 : ","approved_successfully":"Randevunuz tarihinde ba\u015far\u0131yla onayland\u0131","attachment":"Ek","between":"aras\u0131nda","book_appointment":"Kitap randevusu","book_successfully":"Randevunuz ba\u015far\u0131yla rezerve edildi","booked_appointment_with_you":"seninle randevu ald\u0131","email":"E-posta: ","hello":"Merhaba,,","hello!":"Merhaba!","here_is_enquiry":"\u0130\u015fte bir Soru\u015fturma Detay\u0131","messages":"\u0130leti: ","name":"\u0130sim: ","new_manual_payment_request":"Yeni Manuel \u00d6deme Talebi","new_nfc_order":"\u015eu adresten Yeni NFC Sipari\u015fi Ald\u0131n\u0131z:","notes":"notlar","password_change":"\u015eifreniz y\u00f6netici taraf\u0131ndan de\u011fi\u015ftirildi ","please_click":"E-posta adresinizi do\u011frulamak i\u00e7in l\u00fctfen a\u015fa\u011f\u0131daki d\u00fc\u011fmeyi t\u0131klay\u0131n.","please_contact_your_admin":"Yeni bir \u015fifre almak i\u00e7in l\u00fctfen y\u00f6netici ile ileti\u015fime ge\u00e7in. ","regard":"Sayg\u0131lar\u0131m\u0131zla,","slot_text":"\"E-posta Adresini Do\u011frula\" d\u00fc\u011fmesini t\u0131klamada sorun ya\u015f\u0131yorsan\u0131z a\u015fa\u011f\u0131daki URL'yi kopyalay\u0131p web taray\u0131c\u0131n\u0131za yap\u0131\u015ft\u0131r\u0131n:","thanks_regard":"Te\u015fekk\u00fcrler & Sayg\u0131lar,,","vcard_name":"VKart Ad\u0131: ","verify_email":"E-posta Adresini do\u011frulay\u0131n","whoops":"Eyvah!"},"make_appointment":"Randevu ayarlamak","make_appointments":"Randevu Alt","months":{"apr":"Nisan","aug":"a\u011fustos","dec":"Aral\u0131k","feb":"\u015eubat","jan":"Ocak","jul":"Temmuz","jun":"Haziran","mar":"Mart","may":"May\u0131s","nov":"kas\u0131m","oct":"Ekim","sep":"Eyl\u00fcl"},"nfc":{"Add_NFC_card_photos_and_set_prices":"NFC kart foto\u011fraflar\u0131 ekleyin ve fiyatlar\u0131 belirleyin.","Admin_Guide":"Y\u00f6netici K\u0131lavuzu: NFC Kartlar\u0131 Satma","Browse_and_select_an_NFC_card":"Bir NFC kart\u0131n\u0131 g\u00f6z at\u0131n ve se\u00e7in.","Cancelled":"\u0130ptal edildi","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"vCard'\u0131n\u0131z\u0131 se\u00e7in, o vCard'\u0131n URL'si NFC kart\u0131na yaz\u0131lacakt\u0131r.","Confirm_the_order_and_make_a_payment":"Sipari\u015fi onaylay\u0131n ve \u00f6deme yap\u0131n.","Create_or_log_in_to_your_account":"Hesap olu\u015fturun veya giri\u015f yap\u0131n.","Delivered":"Teslim edilmi\u015f","Dispatch_the_NFC_cards_to_users":"NFC kartlar\u0131n\u0131 kullan\u0131c\u0131lara g\u00f6nderin.","How_it_works":"Nas\u0131l \u00c7al\u0131\u015f\u0131r?","Log_in_to_the_Admin_Dashboard":"Y\u00f6netici Panosuna Giri\u015f Yap\u0131n.","Pending":"Ask\u0131da olmas\u0131","Ready To Ship":"G\u00f6nderime Haz\u0131r","Receive_and enjoy your NFC card":"NFC kart\u0131n\u0131z\u0131 al\u0131n ve keyfini \u00e7\u0131kar\u0131n.","Review_user_orders":"Kullan\u0131c\u0131 sipari\u015flerini g\u00f6zden ge\u00e7irin","Shipped":"G\u00f6nderildi","User_Guide":"Kullan\u0131c\u0131 K\u0131lavuzu: NFC Kartlar\u0131 Sat\u0131n Alma ve \u00d6zelle\u015ftirme","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"Y\u00f6neticinin URL yazmas\u0131n\u0131 ve kart\u0131 g\u00f6ndermesini bekleyin.","Write_the_user_provided_URL_to_NFC_cards":"Kullan\u0131c\u0131 taraf\u0131ndan sa\u011flanan URL'yi NFC kartlara yaz\u0131n.","add_nfc_card":"NFC Kart\u0131 Ekle","all":"T\u00fcm","cancel":"\u0130ptal edildi","card_can_not_deleted":"Kart, m\u00fc\u015fteri sipari\u015flerine ba\u011fl\u0131 oldu\u011fundan silinemez.","card_type":"Kart tipi","company_name":"Firma Ad\u0131","designation":"Tan\u0131m","edit_nfc_card":"NFC Kart\u0131n\u0131 D\u00fczenle","enter_address":"Adresi girin","failed":"Ar\u0131zal\u0131","logo":"Logo","my_nfc_cards":"NFC Kartlar\u0131m","new_nfc_card":"Yeni NFC Kart\u0131","nfc":"NFC","nfc_card":"NFC Kart\u0131","nfc_card_created_success":"NFC kart\u0131 ba\u015far\u0131yla olu\u015fturuldu","nfc_card_deleted_success":"NFC kart\u0131 Ba\u015far\u0131yla Silindi","nfc_card_order_details":"NFC Kart Sipari\u015f Detaylar\u0131","nfc_card_orders":"NFC kart\u0131 Sipari\u015fleri","nfc_card_type":"NFC Kart T\u00fcr\u00fc","nfc_card_types":"NFC Kart \u00c7e\u015fitleri","nfc_card_updated_success":"NFC kart\u0131 Ba\u015far\u0131yla G\u00fcncellendi","nfc_image":"Kart Resmi","nfc_image_required":"NFC G\u00f6r\u00fcnt\u00fcs\u00fc alan\u0131 gereklidir.","order":"emir","order_nfc":"NFC'yi sipari\u015f edin","order_placed_success":"Sipari\u015f Ba\u015far\u0131yla Yerle\u015ftirildi","order_status":"Sipari\u015f durumu","order_status_update_success":"Sipari\u015f Durumu Ba\u015far\u0131yla G\u00fcncellendi","orders":"Emirler","orders_count":"Sipari\u015f Say\u0131s\u0131","paid":"Paral\u0131","payment_status":"\u00d6deme Durumu","payment_status_update_success":"\u00d6deme Durumu Ba\u015far\u0131yla G\u00fcncellendi","pending":"Ask\u0131da olmas\u0131","razorpay_session_success":"RazorPay Oturumu Ba\u015far\u0131yla Olu\u015fturuldu","required_vcard":"L\u00fctfen Vcard'\u0131 se\u00e7in","select_card":"L\u00fctfen Kart Tipini Se\u00e7iniz","select_vcard":"vCard'\u0131 se\u00e7in","sell_nfc_cards":"NFC Kartlar\u0131n\u0131 Sat","your_order_status_changed":"Sipari\u015f Durumunuz De\u011fi\u015ftirildi"},"no_data":"Veri Yok","no_matching_records_found":"Hi\u00e7bir e\u015fle\u015fen kay\u0131t bulunamad\u0131","notification":{"mark_all_as_read":"T\u00fcm\u00fcn\u00fc Okundu Olarak \u0130\u015faretle","notifications":"Bildirimler","you_don`t_have_any_new_notification":"Yeni bildiriminiz yok"},"payment":{"cancelled":"\u0130PTAL ED\u0130LD\u0130","payment":"\u00d6DEME","payment_cancel":"\u00d6deme \u0130ptal","payment_success":"Ba\u015far\u0131l\u0131 \u00f6deme","payment_successful":"\u00d6deme ba\u015far\u0131l\u0131"},"payment_method":"\u00d6deme \u015fekli","payment_type":"\u00d6deme \u015fekli","placeholder":{"12_hour":"12 saat","24_hour":"24 saat","address_field":"Adres Alan\u0131 alan\u0131 zorunludur.","agree_term":"\u015eartlar ve ko\u015fullar\u0131 kabul etmelisiniz.","all_rights_reserve":"T\u00fcm haklar\u0131 Sakl\u0131d\u0131r","app_name_required":"Uygulama Ad\u0131 alan\u0131 gerekli","appointment_created":"Randevu ba\u015far\u0131yla olu\u015fturuldu.","cannot_switch_to_zero":"Deneme mevcutsa \/ \u015fu anda aktif olan \u00fccretli bir plana sahipseniz s\u0131f\u0131r plana ge\u00e7ilemez","choose_one_template":"Herhangi bir \u015fablon se\u00e7in","copied_successfully":"Ba\u015far\u0131yla kopyaland\u0131.","de_active":"devre d\u0131\u015f\u0131","default_plan_can_not_be_delete":"Varsay\u0131lan plan silinemez","email_already_subscribed":"E-posta zaten abone oldu.","email_verification":"Profiliniz g\u00fcncellendi. Size bir do\u011frulama maili g\u00f6nderdik. L\u00fctfen de\u011fi\u015ftirilen postan\u0131z\u0131 do\u011frulay\u0131n.","enquiry_sent":"Sorgu ba\u015far\u0131yla g\u00f6nderildi.","enter_valid_email":"L\u00fctfen ge\u00e7erli bir e-posta girin.","enter_your_email_to_reset":"\u015eifrenizi s\u0131f\u0131rlamak i\u00e7in e-postan\u0131z\u0131 girin.","favicon_invalid":"Favicon'da ge\u00e7ersiz resim boyutlar\u0131 var.","first_name_required":"Ad alan\u0131 zorunludur.","forgot_your_password_no_problem":"Parolan\u0131z\u0131 m\u0131 unuttunuz? Sorun de\u011fil. Sadece bize e-posta adresinizi bildirin, size yeni bir tane se\u00e7menize izin verecek bir \u015fifre s\u0131f\u0131rlama ba\u011flant\u0131s\u0131n\u0131 e-posta ile g\u00f6nderelim.","gallery_created":"Galeri ba\u015far\u0131yla olu\u015fturuldu.","gallery_updated":"Galeri ba\u015far\u0131yla g\u00fcncellendi.","invalid_country_code":"Ge\u00e7ersiz \u00fclke kodu","invalid_number":"Ge\u00e7ersiz numara","lang_already_exists":" Dil zaten var.","language_save":"Dil ba\u015far\u0131yla kaydedildi.","last_name_required":"Soyad\u0131 alan\u0131 zorunludur.","last_week":"Ge\u00e7en hafta","login_via_facebook":"\u0412\u043e\u0439\u0442\u0438 \u0447\u0435\u0440\u0435\u0437 Facebook","login_via_google":"\u0412\u043e\u0439\u0442\u0438 \u0447\u0435\u0440\u0435\u0437 Google","multi_templates":"\u00c7oklu \u015fablonlar gerekli","paid_appointment_cant_delete":"\u00dccretli Randevu Silinemez","password_character":"\u015eifre en az 8 karakter olmal\u0131d\u0131r.","password_invalid":"\u015eifre ge\u00e7ersiz","password_is_correct":"\u015eifre do\u011fru","password_must_match":"\u015eifre ve \u015fifre onay\u0131 e\u015fle\u015fmelidir.","passwords":"\u015eifreler alan\u0131 zorunludur.","payment_cancel":"\u00d6demeniz \u0130ptal Edildi","payment_done":"\u00d6deme ba\u015far\u0131yla yap\u0131ld\u0131.","payment_not_complete":"\u00d6deme Tamamlanmad\u0131","payment_received":"\u00d6deme Ba\u015far\u0131yla Al\u0131nd\u0131.","paypal_created":"Paypal oturumu ba\u015far\u0131yla olu\u015fturuldu.","paypal_key":"Paypal anahtar alan\u0131 zorunludur.","paypal_mode":"Paypal modu alan\u0131 zorunludur.","paypal_secret":"Paypal gizli alan\u0131 zorunludur.","phone_number_required":"Telefon Numaras\u0131 alan\u0131 zorunludur.","plan_already_used":"Plan zaten kullan\u0131l\u0131yor","plan_expire_notification":"Plan Sona Erme Bildirimi alan\u0131 gereklidir.","please_add_payment_credentials":"L\u00fctfen \u00f6deme bilgilerini ekleyin","privacy_policy":"Gizlilik Politikas\u0131 gereklidir.","product_purchase":"\u00dcr\u00fcn ba\u015far\u0131yla sat\u0131n al\u0131nd\u0131.","purchased_plan":"Bu plan\u0131 ba\u015far\u0131yla sat\u0131n ald\u0131n\u0131z..","receive_latest_news":"Her hafta en son haberleri, g\u00fcncellemeleri ve di\u011fer bir\u00e7ok \u015feyi al\u0131n.","registered_success":"Ba\u015far\u0131yla kay\u0131t oldunuz, Hesab\u0131n\u0131z\u0131 postadan etkinle\u015ftirin.","required_captcha":"L\u00fctfen Captcha'y\u0131 Do\u011frulay\u0131n","role_created":"Rol ba\u015far\u0131yla olu\u015fturuldu.","select_hour":"L\u00fctfen Tarih veya Saat Se\u00e7iniz","select_one_or_more":"Bir veya daha fazla \u00d6zellik se\u00e7in gerekli","short_code_only_alpha":"K\u0131sa kod sadece alfabe harfleri olmal\u0131d\u0131r.","stripe_created":"\u015eerit oturumu ba\u015far\u0131yla olu\u015fturuldu.","stripe_key":"Stripe key alan\u0131 gereklidir.","stripe_secret":"\u015eerit gizli alan\u0131 gereklidir.","subscribed_plan":"Bu plana ba\u015far\u0131yla abone oldunuz.","subscribed_plan_wait":"Bu plana ba\u015far\u0131yla abone oldunuz ancak Y\u00f6netici'den onay bekliyorsunuz","subscription_date_updated":"Abonelik tarihi ba\u015far\u0131yla g\u00fcncellendi.","successfully_verified":"Postan\u0131z\u0131 ba\u015far\u0131yla do\u011frulad\u0131n\u0131z, l\u00fctfen giri\u015f yap\u0131n.","the_term_conditions":"\u015eartlar ve Ko\u015fullar gereklidir.","there_is_not_available_slot":"Belirtilen tarihte bo\u015f yer yok","this_currency_is_not_supported":"Bu para birimi PayPal taraf\u0131ndan \u00f6deme yapmak i\u00e7in desteklenmez.","this_week":"Bu hafta","time_format":"Zaman format\u0131","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","unable_to_process_payment":"\u015eu anda \u00f6deme i\u015flenemiyor. Daha sonra tekrar deneyin.","upload_required":"Dosya y\u00fckleme alan\u0131 zorunludur.","valid_number":"Ge\u00e7erli numara","we_could_not_fb_id":"Facebook hesab\u0131n\u0131zda e-posta adresini bulamad\u0131k","withdrawal_request_send":"Para \u00e7ekme talebi ba\u015far\u0131yla onayland\u0131.","your_mail_already_verified":"E-postan\u0131z zaten do\u011fruland\u0131, l\u00fctfen giri\u015f yap\u0131n."},"plan":{"We'll_never_share_your_email_with_anyone_else":"E-postan\u0131z\u0131 asla ba\u015fkas\u0131yla payla\u015fmayaca\u011f\u0131z.","additional_domains":"Ek Etki Alanlar\u0131","affiliation":"\u00fcyelikler","analytics":"Analitik","blog":"Bloglar","currency":"Para birimi","custom_css":"\u00d6zel CSS","custom_fields":"\u00d6zel Alanlar","custom_js":"\u00d6zel JS","custom_qrcode":"\u00d6zel QR kodu","days":"g\u00fcnler","default_Plan":"Varsay\u0131lan Plan","description":"A\u00e7\u0131klama","domains_limit":"Alan Ad\u0131 S\u0131n\u0131r\u0131","duration":"S\u00fcre","duration_months":"S\u00fcre Aylar\u0131","duration_years":"S\u00fcre Y\u0131llar","edit_plan":"Plan\u0131 D\u00fczenle","email_address":"E-posta Adresi","enquiry_form":"Talep Formu","features":"\u00d6zellikleri","frequency":"S\u0131kl\u0131k","gallery":"Galeri","hide_branding":"Markalamay\u0131 Gizle","is_trial":"Deneme","make_default":"Varsay\u0131lan Yap","monthly":"Ayl\u0131k","months":"ay","multi_templates":"\u00c7oklu \u015eablonlar","new_plan":"Yeni plan","no_of_vcards":"VKart Say\u0131s\u0131","password_protection":"\u015eifre Korumas\u0131","plan":"Plan","plan_type":"Plan Tipi","portfolio":"portf\u00f6y","price":"Fiyat","products":"\u00dcr\u00fcnler","products_&_services":"\u00dcr\u00fcnler","qrcode":"QR kod","remaining_balance":"\u00d6nceki Bakiye Plan","select_all_feature":"T\u00fcm \u00d6zelli\u011fi Se\u00e7","select_plan":"Plan se\u00e7","sendemail":"Eposta g\u00f6nder","sendinvite":"Davetiye g\u00f6nder","seo":"Arama motoru optimizasyonu","services":"Hizmetler","status":"durum","testimonials":"referanslar","total_custom_domains_limit":"Toplam \u00d6zel Alan Ad\u0131 S\u0131n\u0131r\u0131","trial_days":"Deneme G\u00fcnleri","unlimited":"S\u0131n\u0131rs\u0131z","valid_upto":"Ge\u00e7erlilik Tarihine Kadar","what_s_in_startup_plan":"Ba\u015flang\u0131\u00e7 \u200b\u200bplan\u0131na neler dahildir?","yearly":"Y\u0131ll\u0131k","years":"y\u0131llar"},"plan_expire":"Plan\u0131n s\u00fcresi doldu. L\u00fctfen hizmete devam etmek i\u00e7in bir plan se\u00e7in.","plan_expire_notification":"Plan Sona Erme Bildirimi (G\u00fcn olarak)","plans":"planlar","product_details":"\u00dcr\u00fcn Sipari\u015fi Detaylar\u0131","product_orders":"\u00dcr\u00fcn Sipari\u015fleri","resend_verification_email":"Do\u011frulama e-postas\u0131n\u0131 tekrar g\u00f6nder","reset_password":"\u015eifreyi yenile","role":{"edit_role":"Rol\u00fc D\u00fczenle","name":"\u0130sim","new_role":"Yeni rol","permissions":"izinler","role_permissions":"Rol \u0130zinleri","select_all_permissions":"T\u00fcm \u0130zinleri Se\u00e7"},"roles":"Roller","sadmin_dashboard":{"contact":"\u0130leti\u015fim Numaras\u0131","day":"G\u00fcn","email":"E-posta","income":"Gelir","month":"Ay","name":"\u0130sim","plans_by_users":"Kullan\u0131c\u0131lara G\u00f6re Planlar","recent_users_registration":"Son Kullan\u0131c\u0131 Kayd\u0131","registered_on":"Kaydedildi","week":"Hafta"},"save":"Save","select_payment_type":"\u00d6deme A\u011f Ge\u00e7idini Se\u00e7in","services":"Hizmetler","setting":{"add_contact":"Rehbere ekle","address":"Adres","affiliation_amount":"\u00dcyelik tutar\u0131","affiliation_withdraw":"\u00dcyelik geri \u00e7ekilir","app_logo":"Uygulama Logosu","app_name":"Uygulama ismi","clinic_name":"Klinik Ad\u0131","contact_information":"\u0130leti\u015fim bilgileri","credentials":"kimlik bilgileri","currency":"Para birimi","currency_settings":"Para Birimi Ayarlar\u0131","default_language":"Varsay\u0131lan dil","disable_landing_page":"A\u00e7\u0131l\u0131\u015f Sayfas\u0131n\u0131 Devre D\u0131\u015f\u0131 B\u0131rak","enable_addcontact":"Ki\u015fiye ekle'yi etkinle\u015ftir","enable_affiliation":"\u00dcyeli\u011fi Etkinle\u015ftir","enable_contact":"Ki\u015fiyi Etkinle\u015ftir","favicon":"Favicon","front_page_enable":"\u00d6n Sayfa Etkinle\u015ftir","general":"Genel","general_details":"Genel Detaylar","hide_stickybar":"vCard Yap\u0131\u015fkan \u00c7ubu\u011funu Gizle","location_url":"Konum URL'si","manually":"manuel olarak","note":"Not : Y\u00fcklenen ikon ad\u0131 \"WeChat.png\" \/ \"Tumbler.png\" \/ \"XXX.png\" olmal\u0131d\u0131r, .vcf dosyas\u0131 indirilirken etiket olarak bu isim kullan\u0131lacakt\u0131r.","paypal":"paypal","paypal_client_id":"Paypal M\u00fc\u015fteri Kimli\u011fi","paypal_key":"paypal anahtar\u0131","paypal_mode":"Paypal Modu","paypal_payout_email":"Paypal \u00d6deme E-postas\u0131","paypal_secret":"Paypal S\u0131rr\u0131","postal_code":"posta kodu","prefix":"\u00d6nek","razorpay":"Razorpay","razorpay_key":"Razorpay Anahtar\u0131","razorpay_secret":"Razorpay S\u0131rr\u0131","select_currency":"Para birimini se\u00e7in","setting":"Ayar","shipping_address":"G\u00f6nderi Adresi","specialities":"spesiyaller","stripe":"\u015eerit","stripe_key":"\u015ferit anahtar","stripe_secret":"\u015ferit s\u0131r","upgrade_database":"Veritaban\u0131n\u0131 Y\u00fckselt","whatsapp_share":"WhatsApp Payla\u015f\u0131m\u0131","withdraw_transactions":"Para \u00c7ekme \u0130\u015flemleri","withdrawals":"Para \u00c7ekme","wp_number":"Telefon No girin"},"settings":"Ayarlar","sign_out":"Oturumu Kapat","social":{"Facebook":"Facebook","Instagram":"Instagram","Linkedin":"Linkedin","Pinterest":"Pinterest","Reddit":"Reddit","Share_on_email":"E-postada Payla\u015f","Share_on_facebook":"Facebook'ta Payla\u015f","Share_on_linkedin":"Linkedin'de Payla\u015f","Share_on_pinterest":"Pinterest'te Payla\u015f","Share_on_reddit":"Reddit'te Payla\u015f","Share_on_twitter":"Twitter'da payla\u015f","Share_on_whatsapp":"Whatsapp'ta payla\u015f","Tiktok":"Tiktok","Tumblr":"Tumblr","Twitter":"heyecan","Whatsapp":"Naber","Youtube":"Youtube","map":"Harita","social_links":"Sosyal ba\u011flant\u0131lar - Web sitesi","website":"\u0130nternet sitesi"},"state":{"country_name":"\u00dclke ad\u0131","edit_state":"Durumu D\u00fczenle","new_state":"Yeni Devlet","no_state_available":"Mevcut Durum Yok","no_state_found":"Durum Bulunamad\u0131","state":"Belirtmek, bildirmek","state_name":"Devlet ad\u0131","states":"eyaletler"},"subscribe":"Abone olmak","subscribed_plans":"Aboneli Planlar","subscribed_user":"Abone Olunan Kullan\u0131c\u0131 Planlar\u0131","subscriber":"aboneler","subscription":{"active_until":"kadar aktif","active_until_unlimited":"S\u0131n\u0131rs\u0131za Kadar Aktif","amount":"Miktar","buy_now":"\u015eimdi al","buy_product":"\u00dcr\u00fcn\u00fc Sat\u0131n Al","cancel_subscription":"Aboneli\u011fi iptal et","choose_plan":"Plan\u0131 Se\u00e7","current_expire":"Ge\u00e7erli S\u00fcresi Dolmu\u015f Plan","current_plan":"Mevcut Plan","currently_active":"\u015eu anda Aktif","end_date":"Biti\u015f tarihi","end_date_required":"Biti\u015f tarihi alan\u0131 zorunludur","expired":"Plan\u0131n S\u00fcresi Zaten Doldu","expired_date":"Son kullanma tarihi ge\u00e7mi\u015f","free":"\u00d6zg\u00fcr","has_already_been_subscribed":"zaten abone","has_been_subscribed":"abone oldu","history":"Abonelik Ge\u00e7mi\u015fi","manage_subscription":"Aboneli\u011fi Y\u00f6net","no_plan_available":"Plan Yok","pay_or_switch_plan":"\u00d6deme \/ Ge\u00e7i\u015f Plan\u0131","payable_amount":"\u00d6denebilir miktar","payment":"\u00d6deme","plan_name":"Plan Ad\u0131","plan_price":"Plan Price","proceed_to_payment":"\u00d6demeye Devam Et","purchase":"Sat\u0131n alma","remaining":"Geriye kalan","remaining_balance":"Kalan Bakiye","remaining_days":"Kalan g\u00fcnler","renew_free_plan":"\u00dccretsiz Plan tekrar yenilenemez\/se\u00e7ilemez","renew_plan":"Plan\u0131 Yenile","start_date":"Ba\u015flang\u0131\u00e7 tarihi","subscribed_date":"Abonelik Tarihi","subscribed_plan_details":"Abone Olunan Plan Ayr\u0131nt\u0131lar\u0131","switch_plan":"Plan\u0131 De\u011fi\u015ftir","total_days":"Toplam G\u00fcn","trial_plan":"Deneme Plan\u0131","upgrade_plan":"Y\u00fckseltme Plan\u0131","used_balance":"Kullan\u0131lm\u0131\u015f Bakiye","used_days":"Kullan\u0131lan G\u00fcnler"},"subscriptions":"abonelikler","testimonial":"referanslar","to_time":"Zamana","tooltip":{"about_description":"\u0130zin verilen maksimum 500 karakter","about_title":"\u0130zin verilen maksimum 100 karakter","allowed_image":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","app_logo":"Resim 90 x 60 piksel olmal\u0131d\u0131r","banner_title":"\u0130zin verilen maksimum 34 karakter","cancel_app_logo":"Uygulama logosunu iptal et","cancel_cover":"Kapa\u011f\u0131 \u0130ptal Et","cancel_favicon_logo":"Favicon'u iptal et","cancel_image":"Resmi \u0130ptal Et","cancel_profile":"Profili \u0130ptal Et","change_app_logo":"Uygulama logosunu de\u011fi\u015ftir","change_favicon_logo":"Favicon'u de\u011fi\u015ftir","change_icon":"Simge de\u011fi\u015ftir","copy":"Panoya kopyala","cover":"Kapa\u011f\u0131 De\u011fi\u015ftir","custom_css":"Her VCard i\u00e7in \u00f6zel css ekleme \u00f6zelli\u011fini etkinle\u015ftirin.","custom_fonts":"Her VCard i\u00e7in \u00f6zel yaz\u0131 tipleri ekleme \u00f6zelli\u011fini etkinle\u015ftirin.","custom_js":"Her VCard i\u00e7in \u00f6zel js ekleme \u00f6zelli\u011fini etkinle\u015ftirin.","dark_mode":"Karanl\u0131k moda ge\u00e7","enable_affiliation":"Bunu etkinle\u015ftirerek, \u00fcyelik ba\u011flant\u0131s\u0131 t\u00fcm vcard'lar\u0131n\u0131z taraf\u0131ndan g\u00f6r\u00fclebilir","enable_contact":"Bunu etkinle\u015ftirdi\u011finizde, ileti\u015fim bilgileri t\u00fcm Vcard'lar\u0131n\u0131zda g\u00f6r\u00fcn\u00fcr olacakt\u0131r","favicon_logo":"Resim piksel 16 x 16 olmal\u0131d\u0131r","hide_branding":"Markay\u0131 VCard'lardan gizleme \u00f6zelli\u011fini etkinle\u015ftirin.","hide_stickybar":"Bunu etkinle\u015ftirerek, t\u00fcm Vcard'lar\u0131n\u0131zdaki Vcards Yap\u0131\u015fkan D\u00fc\u011fmelerini gizleyin","home_image":"Bu profil i\u00e7in en iyi \u00e7\u00f6z\u00fcn\u00fcrl\u00fck olacakt\u0131r","image":"Resmi de\u011fi\u015ftir","light_mode":"I\u015f\u0131k moduna ge\u00e7","message_sent":"Mesaj ba\u015far\u0131yla g\u00f6nderildi.","password_protection":"Parola korumal\u0131 VCard'lara eri\u015fimi etkinle\u015ftirin.","product_image":"Bu profil i\u00e7in en iyi \u00e7\u00f6z\u00fcn\u00fcrl\u00fck 250x250 olacakt\u0131r","profile":"Profili de\u011fi\u015ftir","remove_branding":"Etkinle\u015ftirilirse, vcard web sitemizin markas\u0131n\u0131 g\u00f6stermez.","script":"Komut dosyas\u0131 etiketi olmadan \u00f6zel JS kodu ekleyin","sub_text":"\u0130zin verilen maksimum 60 karakter","subscribed_successfully":"Ba\u015far\u0131yla Abone Olundu..","the_main_url":"vcard'\u0131n\u0131z\u0131n eri\u015febilece\u011fi ana URL.","whatsapp_share":"Bunu etkinle\u015ftirerek, WhatsApp Payla\u015f d\u00fc\u011fmesi t\u00fcm VCard'lar\u0131n\u0131zda g\u00f6r\u00fcn\u00fcr olacakt\u0131r"},"translation_manager":"\u00c7eviri Y\u00f6neticisi","type_in_script":"<script><\/script> etiketinin i\u00e7ine js kodunu yaz\u0131n","user":{"account":"Hesap","account_setting":"Hesap ayarlar\u0131","add_admin":"Y\u00f6netici Ekle","add_user":"Kullan\u0131c\u0131 Ekle","admin_details":"Y\u00f6netici Ayr\u0131nt\u0131lar\u0131","avatar":"avatar","change_language":"Dili de\u011fi\u015ftir","change_password":"\u015eifre de\u011fi\u015ftir","confirm_password":"\u015eifreyi Onayla","contact_no":"\u0130leti\u015fim Numaras\u0131","contact_number":"\u0130leti\u015fim numaras\u0131","current_password":"Mevcut \u015eifre","edit_user":"kullan\u0131c\u0131y\u0131 d\u00fczenle","email":"E-posta","email_verified":"E-posta Do\u011fruland\u0131","female":"Di\u015fi","first_name":"\u0130lk ad\u0131","full_name":"Ad Soyad","impersonate":"kimli\u011fine b\u00fcr\u00fcn","last_name":"Soyad\u0131","location":"Konum","male":"Erkek","new_password":"Yeni \u015eifre","overview":"genel bak\u0131\u015f","password":"Parola","phone":"Telefon","profile":"Profil","profile_details":"profil detaylar\u0131","registered_date":"Kay\u0131tl\u0131 Tarih","return_to_admin":"Y\u00f6neticiye D\u00f6n","save_changes":"De\u011fi\u015fiklikleri Kaydet","setting":"Ayar","theme_change":"Tema Modu De\u011fi\u015fikli\u011fi","user_details":"Kullan\u0131c\u0131 detaylar\u0131","your_message":"Mesaj\u0131n","your_name":"Ad\u0131n\u0131z"},"users":"Kullan\u0131c\u0131lar","vcard":{"add_blog":"Blog Ekle","add_gallery":"Galeri Ekle","add_google_analytics":"<script> etiketi olmadan Google Analytics kodunu ekleyin","add_product":"\u00fcr\u00fcn ekle","add_service":"Hizmet Ekle","add_testimonial":"G\u00f6r\u00fc\u015f Ekle","advanced":"ileri","affiliate_user":"Ba\u011fl\u0131 Kullan\u0131c\u0131lar","alter_email_address":"Alternatif e","alter_mobile_number":"Alternatif cep telefonu numaras\u0131","alternate_email":"Alternatif e","alternative_phone":"  alternatif telefon","appointments":"Randevular","back_color":"Arka plan rengi","basic_details":"Temel Ayr\u0131nt\u0131lar","blog_details":"Blog Ayr\u0131nt\u0131lar\u0131","blog_icon":"Blog Simgesi","blogs":"Bloglar","buisness_hours":"\u0130\u015e VAK\u0130TLER\u0130","business-hours":"\u0130\u015f vakitleri","business_hours":"\u0130\u015f vakitleri","company":"\u015eirket","contact":"Temas etmek","copy_referral_link":"Y\u00f6nlendirme ba\u011flant\u0131s\u0131n\u0131 kopyala","cover_image":"Kapak resmi","created_at":"Olu\u015fturulma Tarihi","created_on":"tarihinde olu\u015fturuldu","custom-fonts":"yaz\u0131 tipleri","custom_css":"\u00d6zel CSS","custom_fonts":"yaz\u0131 tipleri","custom_js":"\u00d6zel JS","date_of_birth":"Do\u011fum tarihi","description":"A\u00e7\u0131klama","display_share_button":"Payla\u015f d\u00fc\u011fmesini g\u00f6r\u00fcnt\u00fcle","dob":"Do\u011fum tarihi","download_my_qr_code":"QR Kodumu \u0130ndir","download_vcard":"VCard'\u0131 indirin","duplicate_vcard":"Vcard'\u0131 \u00e7o\u011falt\u0131n!","edit_blog":"Blogu D\u00fczenle","edit_gallery":"Galeriyi D\u00fczenle","edit_product":"\u00dcr\u00fcn\u00fc D\u00fczenle","edit_service":"Hizmeti D\u00fczenle","edit_testimonial":"G\u00f6r\u00fc\u015f\u00fc D\u00fczenle","edit_vcard":"VCard'\u0131 d\u00fczenle","email_address":"E-posta adresi","enable_download_qr_code":"QR Kodunu \u0130ndirmeyi Etkinle\u015ftir","enable_enquiry_form":"Talep formunu etkinle\u015ftirin","enter_password":"\u015eifre girin","first_name":"\u0130lk ad\u0131","flag":"Bayrak","galleries":"Galeriler","gallery":"Galeri","google_analytics":"Google Analytics","google_config":"Google Yap\u0131land\u0131rmas\u0131","header":"Ba\u015fl\u0131k","home_title":"Ana Ba\u015fl\u0131k","image":"resim","is_manual_payment":"Manuel \u00d6deme Rehberi A\u00e7\u0131k m\u0131","job_title":"\u0130\u015f Unvan\u0131e","language_enable":"Dil Etkinle\u015ftir","last_name":"Soyad\u0131","last_updated":"Son g\u00fcncelleme","location":"Konum","manage-section":"B\u00f6l\u00fcm\u00fc Y\u00f6net","manual_payment_guide":"Manuel \u00d6deme Rehberi","map":"Harita","meta_description":"Meta A\u00e7\u0131klamas\u0131","meta_keyword":"Meta Anahtar Kelime","mobile_number":"Cep numaras\u0131","new_blog":"Yeni Blog","new_gallery":"Yeni Galeri","new_product":"Yeni \u00fcr\u00fcn","new_service":"Yeni Hizmet","new_testimonial":"Yeni G\u00f6r\u00fc\u015f","new_vcard":"Yeni VC Kart\u0131","occupation":"Meslek","order_at":"Sipari\u015f Tarihi","our_service":"hizmetlerimiz","payment_config":"\u00d6deme Yap\u0131land\u0131rmas\u0131","preview_url":"\u00d6nizleme URL'si","privacy_policy":"Gizlilik Politikas\u0131","product":"\u00dcr\u00fcn","product_details":"\u00dcr\u00fcn Simgesi","product_icon":"\u00dcr\u00fcn Simgesi","product_name":"\u00dcr\u00fcn ad\u0131","product_transection":"\u00dcr\u00fcn \u0130\u015flemleri","products":"\u00dcr\u00fcn","profile_image":"Profil Resmi","qr_code":"QR kod","qr_code_download_size":"QR kodu indirme boyutu","qrcode-customize":"QR Kodunu \u00d6zelle\u015ftir","qrcode_color":"QR Kodu Rengi","qrcode_customize":"QR Kodunu \u00d6zelle\u015ftir","qrcode_eye_style":"G\u00f6z Stili Se\u00e7in","qrcode_style":"Stil Se\u00e7","remove_branding":"Markalamay\u0131 kald\u0131r","select_template":"\u015eablon Se\u00e7","send_message":"Mesaj g\u00f6nder","seo":"Arama motoru optimizasyonu","service_details":"Hizmet Detaylar\u0131","service_icon":"Hizmet Simgesi","services":"Hizmetler","share":"Payla\u015f","share_my_vcard":"VCard'\u0131m\u0131 Payla\u015f","show_qr_code":"QR Kodunu G\u00f6ster","site_title":"Site Ba\u015fl\u0131\u011f\u0131","social-links":"Sosyal ba\u011flant\u0131lar","social_links":"Sosyal ba\u011flant\u0131lar","stats":"istatistikler","status":"Durum","template":"VCard \u015eablonlar\u0131","templates":"VCard \u015eablonlar\u0131","term-condition":"\u015fartlar ve ko\u015fullar","term-policy":"\u015eartlar ve Politikalar","term_condition":"\u015fartlar ve ko\u015fullar","term_policy":"\u015eartlar ve Politikalar","testimonial":"referans","testimonial_details":"Referans Ayr\u0131nt\u0131lar\u0131","testimonials":"referanslar","theme_config":"Tema Yap\u0131land\u0131rmas\u0131","url_alias":"takma ad URL'si","user":"Kullan\u0131c\u0131lar","user_name":"Kullan\u0131c\u0131 ad\u0131","vcard":"V kart\u0131","vcard_details":"VCKart Ayr\u0131nt\u0131lar\u0131","vcard_is_active":"Vcard etkin","vcard_name":"VKart Ad\u0131","vcard_service":"VCard Hizmeti"},"vcard_11":{"Latest_post":"Son G\u00f6nderiler","contact_detail":"\u0130leti\u015fim detaylar\u0131","get_in_touch":"Temasta olmak","my_email":"E-postam","my_phones":"Telefonlar\u0131m","provide_service":"Hizmet Sa\u011flay\u0131n","read_more":"Devam\u0131n\u0131 oku"},"vcards":"VC kartlar\u0131","vcards_template":{"image":"resim","used_count":"Kullan\u0131lan Say\u0131"},"vcards_templates":"VKart \u015eablonlar\u0131","virtual_backgrounds":"Sanal Arka Planlar","wait_for_apporove_of_cash_payment_by_admin":"Manuel \u0130\u015flem Talebiniz Beklemede.","weekdays":{"fri":"Cuma","mon":"AY","sat":"Oturdu","sun":"G\u00dcNE\u015e","thu":"PHU","tue":"sal","wed":"EVLENMEK"},"your":"Senin"},"tr.pagination":{"next":"Sonraki &raquo;","previous":"&laquo; Previous"},"tr.passwords":{"reset":"\u015eifreniz s\u0131f\u0131rland\u0131!","sent":"\u015eifre s\u0131f\u0131rlama ba\u011flant\u0131n\u0131z\u0131 e-posta ile g\u00f6nderdik!","throttled":"L\u00fctfen yeniden denemeden \u00f6nce bekleyin.","token":"Bu parola s\u0131f\u0131rlama belirteci ge\u00e7ersiz.","user":"Bu e-posta adresine sahip bir kullan\u0131c\u0131 bulam\u0131yoruz."},"tr.validation":{"accepted":"bu :attribute kabul edilmeli.","active_url":"bu :attribute ge\u00e7erli bir URL de\u011fil.","after":"bu :attribute :date tarihinden sonraki bir tarih olmal\u0131d\u0131r.","after_or_equal":"bu :attribute :date'den sonraki veya buna e\u015fit bir tarih olmal\u0131d\u0131r.","alpha":"bu :attribute sadece harf i\u00e7ermelidir.","alpha_dash":"bu :attribute yaln\u0131zca harf, rakam, tire ve alt \u00e7izgi i\u00e7ermelidir.","alpha_num":"bu :attribute sadece harf ve rakamlardan olu\u015fmal\u0131d\u0131r.","array":"bu :attribute bir dizi olmal\u0131.","attributes":{"email":"E-posta","message":"Mesaj","name":"Ad","phone":"Telefon","service_url":"Service URL"},"before":"bu :attribute :date'den \u00f6nceki bir tarih olmal\u0131d\u0131r.","before_or_equal":"bu :attribute :date tarihinden \u00f6nce veya buna e\u015fit bir tarih olmal\u0131d\u0131r.","between":{"array":"bu :attribute :min ve :max \u00f6\u011feleri aras\u0131nda olmal\u0131d\u0131r.","file":"bu :attribute :min ile :max kilobayt aras\u0131nda olmal\u0131d\u0131r.","numeric":"bu :attribute :min ve :max aras\u0131nda olmal\u0131d\u0131r.","string":"bu :attribute :min ve :max karakterleri aras\u0131nda olmal\u0131d\u0131r."},"boolean":"bu :attribute alan do\u011fru veya yanl\u0131\u015f olmal\u0131d\u0131r.","confirmed":"bu :attribute onay e\u015fle\u015fmiyor.","coupon_code":{"expired":"Bu kupon kodunun s\u00fcresi dolmu\u015ftur","not_found":"Kupon Kodu bulunamad\u0131"},"current_password":"\u015eifre yanl\u0131\u015f.","custom":{"attribute-name":{"rule-name":"\u00f6zel mesaj"}},"date":"bu :attribute ge\u00e7erli bir tarih de\u011fil.","date_equals":"bu :attribute :date de\u011ferine e\u015fit bir tarih olmal\u0131d\u0131r.","date_format":"bu :attribute bi\u00e7imle e\u015fle\u015fmiyor :format.","different":"bu :attribute ve :di\u011fer farkl\u0131 olmal\u0131.","digits":"bu :attribute olmal\u0131d\u0131r :rakamlar rakamlar.","digits_between":"bu :attribute :min ve :max basamaklar aras\u0131nda olmal\u0131d\u0131r.","dimensions":"bu :attribute ge\u00e7ersiz resim boyutlar\u0131 var.","distinct":"bu :attribute alan yinelenen bir de\u011fere sahip.","email":"bu :attribute Ge\u00e7erli bir e-posta adresi olmal\u0131.","ends_with":"bu :attribute a\u015fa\u011f\u0131dakilerden biriyle bitmelidir: :de\u011ferler.","exists":"bu se\u00e7ilmi\u015f :attribute ge\u00e7ersizdir.","file":"bu :attribute bir dosya olmal\u0131.","filled":"bu :attribute alan\u0131n bir de\u011feri olmal\u0131d\u0131r.","gt":{"array":"bu :attribute :de\u011fer \u00f6\u011felerinden daha fazlas\u0131na sahip olmal\u0131d\u0131r.","file":"bu :attribute :de\u011fer kilobayttan b\u00fcy\u00fck olmal\u0131d\u0131r.","numeric":"bu :attribute :de\u011ferden b\u00fcy\u00fck olmal\u0131d\u0131r.","string":"bu :attribute de\u011fer karakterlerinden daha b\u00fcy\u00fck olmal\u0131d\u0131r."},"gte":{"array":"bu :attribute sahip olmal\u0131d\u0131r: de\u011fer \u00f6\u011feleri veya daha fazlas\u0131.","file":"bu :attribute :de\u011fer kilobayttan b\u00fcy\u00fck veya ona e\u015fit olmal\u0131d\u0131r.","numeric":"bu :attribute :de\u011ferden b\u00fcy\u00fck veya ona e\u015fit olmal\u0131d\u0131r.","string":"bu :attribute de\u011fer karakterlerinden b\u00fcy\u00fck veya e\u015fit olmal\u0131d\u0131r."},"image":"bu :attribute bir resim olmal\u0131.","in":"bu se\u00e7ilmi\u015f :attribute ge\u00e7ersizdir.","in_array":"bu :attribute alan \u015furada yok :di\u011fer.","integer":"bu :attribute tam say\u0131 olmak zorunda.","ip":"bu :attribute ge\u00e7erli bir IP adresi olmal\u0131d\u0131r.","ipv4":"bu :attribute ge\u00e7erli bir IPv4 adresi olmal\u0131d\u0131r.","ipv6":"bu :attribute ge\u00e7erli bir IPv6 adresi olmal\u0131d\u0131r.","json":"bu :attribute ge\u00e7erli bir JSON dizesi olmal\u0131d\u0131r.","lt":{"array":"bu :attribute :de\u011fer \u00f6\u011felerinden daha az\u0131na sahip olmal\u0131d\u0131r.","file":"bu :attribute :de\u011fer kilobayttan k\u00fc\u00e7\u00fck olmal\u0131d\u0131r.","numeric":"bu :attribute :de\u011ferden k\u00fc\u00e7\u00fck olmal\u0131d\u0131r.","string":"bu :attribute :de\u011fer karakterlerinden daha az olmal\u0131d\u0131r."},"lte":{"array":"bu :attribute :de\u011fer \u00f6\u011felerinden daha fazlas\u0131na sahip olmamal\u0131d\u0131r.","file":"bu :attribute :de\u011fer kilobayttan k\u00fc\u00e7\u00fck veya ona e\u015fit olmal\u0131d\u0131r.","numeric":"bu :attribute :de\u011ferden k\u00fc\u00e7\u00fck veya e\u015fit olmal\u0131d\u0131r.","string":"bu :attribute :de\u011fer karakterlerinden k\u00fc\u00e7\u00fck veya e\u015fit olmal\u0131d\u0131r."},"max":{"array":"bu :attribute en fazla :max \u00f6\u011feye sahip olmamal\u0131d\u0131r.","file":"bu :attribute :max kilobayttan b\u00fcy\u00fck olmamal\u0131d\u0131r.","numeric":"bu :attribute :max de\u011ferinden b\u00fcy\u00fck olmamal\u0131d\u0131r.","string":"bu :attribute :max karakterden b\u00fcy\u00fck olmamal\u0131d\u0131r."},"mimes":"bu :attribute :values t\u00fcr\u00fcnde bir dosya olmal\u0131d\u0131r.","mimetypes":"bu :attribute :values t\u00fcr\u00fcnde bir dosya olmal\u0131d\u0131r.","min":{"array":"bu :attribute en az :min \u00f6\u011felere sahip olmal\u0131d\u0131r.","file":"bu :attribute en az :min kilobayt olmal\u0131d\u0131r.","numeric":"bu :attribute en az :dk olmal\u0131d\u0131r.","string":"bu :attribute en az :min karakter olmal\u0131d\u0131r."},"multiple_of":"bu :attribute :de\u011ferin kat\u0131 olmal\u0131d\u0131r.","not_in":"bu se\u00e7ilmi\u015f :attribute ge\u00e7ersizdir.","not_regex":"bu :attribute bi\u00e7im ge\u00e7ersiz.","numeric":"bu :attribute bir say\u0131 olmal\u0131.","password":"\u015eifre yanl\u0131\u015f.","present":"bu :attribute alan mevcut olmal\u0131d\u0131r.","prohibited":"bu :attribute alan yasakt\u0131r.","prohibited_if":"bu :attribute :other :value oldu\u011funda alan yasakt\u0131r.","prohibited_unless":"bu :attribute :other :values \u200b\u200bi\u00e7inde olmad\u0131k\u00e7a alan yasakt\u0131r.","regex":"bu :attribute bi\u00e7im ge\u00e7ersiz.","required":"bu :attribute alan gereklidir.","required_if":"bu :attribute alan :other :value oldu\u011funda gereklidir.","required_unless":"bu :attribute :other :values i\u00e7inde olmad\u0131k\u00e7a alan gereklidir.","required_with":"bu :attribute :values mevcut oldu\u011funda bu alan gereklidir.","required_with_all":"bu :attribute alan :de\u011ferler mevcut oldu\u011funda gereklidir.","required_without":"bu :attribute alan :de\u011ferler olmad\u0131\u011f\u0131nda gereklidir.","required_without_all":"bu :attribute :de\u011ferlerinden hi\u00e7biri mevcut olmad\u0131\u011f\u0131nda alan gereklidir.","same":"bu :attribute ve :di\u011fer e\u015fle\u015fmelidir.","size":{"array":"bu :attribute \u015funlar\u0131 i\u00e7ermelidir: boyut \u00f6\u011feleri.","file":"bu :attribute olmal\u0131d\u0131r: boyut kilobayt.","numeric":"bu :attribute olmal\u0131d\u0131r:boyut.","string":"bu :attribute olmal\u0131d\u0131r :boyut karakterleri."},"starts_with":"bu :attribute a\u015fa\u011f\u0131dakilerden biriyle ba\u015flamal\u0131d\u0131r: :de\u011ferler.","string":"bu :attribute bir dize olmal\u0131.","timezone":"bu :attribute ge\u00e7erli bir saat dilimi olmal\u0131d\u0131re.","unique":"bu :attribute \u00e7oktan al\u0131nd\u0131.","uploaded":"bu :attribute y\u00fcklenemedi.","url":"bu :attribute ge\u00e7erli bir URL olmal\u0131d\u0131r.","uuid":"bu :attribute ge\u00e7erli bir UUID olmal\u0131d\u0131r."},"tw.livewire-tables::strings":{"All":"\u5168\u90e8","All Columns":"\u6240\u6709\u5c08\u6b04","Applied Filters":"\u5df2\u5957\u7528\u7684\u904e\u6ffe\u898f\u5247","Applied Sorting":"\u5df2\u5957\u7528\u7684\u641c\u5c0b\u898f\u5247","Bulk Actions":"\u6279\u6b21\u64cd\u4f5c","Clear":"\u6e05\u9664","Columns":"\u6b04\u4f4d","Debugging Values":"\u8abf\u8a66\u503c","Deselect All":"\u53d6\u6d88\u9078\u64c7","Done Reordering":"\u6392\u5e8f\u5b8c\u6210","Filters":"\u904e\u6ffe\u898f\u5247","No":"\u4e0d","No items found. Try to broaden your search.":"\u7121\u8cc7\u6599\u5448\u73fe\u3002\u8acb\u5617\u8a66\u64f4\u5927\u641c\u5c0b\u7bc4\u570d\u3002","Remove filter option":"\u79fb\u9664\u904e\u6ffe\u898f\u5247","Remove sort option":"\u79fb\u9664\u6392\u5e8f\u898f\u5247","Reorder":"\u91cd\u65b0\u6392\u5e8f","Search":"\u641c\u5c0b","Select All":"\u641c\u5c0b\u5168\u90e8","Showing":"\u986f\u793a","Yes":"\u662f\u7684","You are currently selecting all":"\u60a8\u76ee\u524d\u5df2\u9078\u64c7\u5168\u90e8\u8cc7\u6599","You are not connected to the internet.":"\u76ee\u524d\u70ba\u96e2\u7dda\u6a21\u5f0f","You have selected":"\u60a8\u5df2\u9078\u64c7","of":"\u7b46\u8cc7\u6599\uff0c\u5171","results":"\u7b46\u8cc7\u6599","row":"\u7b46\u8cc7\u6599","rows":"\u7b46\u8cc7\u6599","rows, do you want to select all":"\u7b46\u8cc7\u6599\uff0c\u60a8\u662f\u5426\u8981\u5168\u9078","to":"\u81f3"},"uk.livewire-tables::strings":{"All":"\u0412\u0441\u0456","All Columns":"\u0423\u0441\u0456 \u0441\u0442\u043e\u0432\u043f\u0446\u0456","Applied Filters":"\u0417\u0430\u0441\u0442\u043e\u0441\u043e\u0432\u0430\u043d\u0456 \u0444\u0456\u043b\u044c\u0442\u0440\u0438","Applied Sorting":"\u0417\u0430\u0441\u0442\u043e\u0441\u043e\u0432\u0430\u043d\u0456 \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f","Bulk Actions":"\u041c\u0430\u0441\u043e\u0432\u0456 \u0434\u0456\u0457","Clear":"\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438","Columns":"\u041a\u043e\u043b\u043e\u043d\u043a\u0438","Debugging Values":"\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043d\u0430\u043b\u0430\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f","Deselect All":"\u0417\u043d\u044f\u0442\u0438 \u0432\u0438\u0431\u0456\u0440 \u0456\u0437 \u0443\u0441\u0456\u0445","Done Reordering":"\u0421\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u0432\u0438\u043a\u043e\u043d\u0430\u043d\u043d\u043e","Filters":"\u0424\u0456\u043b\u044c\u0442\u0440\u0438","No":"\u041d\u0435\u043c\u0430\u0454","No items found. Try to broaden your search.":"\u041d\u0435\u043c\u0430\u0454 \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432. \u0421\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0440\u043e\u0437\u0448\u0438\u0440\u0438\u0442\u0438 \u043f\u043e\u0448\u0443\u043a.","Remove filter option":"\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u043e\u043f\u0446\u0456\u044e \u0444\u0456\u043b\u044c\u0442\u0440\u0430","Remove sort option":"\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f","Reorder":"\u0417\u043c\u0456\u043d\u0438\u0442\u0438 \u043f\u043e\u0440\u044f\u0434\u043e\u043a","Search":"\u041f\u043e\u0448\u0443\u043a","Select All":"\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u0432\u0441\u0435","Showing":"\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u043e","Unselect All":"\u041f\u0440\u0438\u0431\u0440\u0430\u0442\u0438 \u0432\u0438\u0431\u0456\u0440 \u0443\u0441\u0456\u0445","Yes":"\u0422\u0430\u043a","You are currently selecting all":"\u041d\u0430\u0440\u0430\u0437\u0456 \u0432\u0438 \u0432\u0438\u0431\u0438\u0440\u0430\u0454\u0442\u0435 \u0432\u0441\u0456","You are not connected to the internet.":"\u0412\u0438 \u043d\u0435 \u043f\u0456\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0456 \u0434\u043e \u0406\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443.","You have selected":"\u0412\u0438 \u0432\u0438\u0431\u0440\u0430\u043b\u0438","of":"\u0432\u0456\u0434","results":"\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0456\u0432","row":"\u0440\u044f\u0434\u043a\u0438","rows":"\u0440\u044f\u0434\u043a\u0438","rows, do you want to select all":"\u0440\u044f\u0434\u043a\u0456\u0432, \u0432\u0438 \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0431\u0440\u0430\u0442\u0438 \u0432\u0441\u0456","to":"\u0434\u043e"},"vi.cookie-consent::texts":{"agree":"Cho ph\u00e9p Cookie","message":"Tr\u1ea3i nghi\u1ec7m c\u1ee7a b\u1ea1n tr\u00ean trang web n\u00e0y s\u1ebd \u0111\u01b0\u1ee3c c\u1ea3i thi\u1ec7n b\u1eb1ng c\u00e1ch cho ph\u00e9p Cookie."},"vi.cookieConsent::texts":{"agree":"Cho ph\u00e9p Cookie","message":"Tr\u1ea3i nghi\u1ec7m c\u1ee7a b\u1ea1n tr\u00ean trang web n\u00e0y s\u1ebd \u0111\u01b0\u1ee3c c\u1ea3i thi\u1ec7n b\u1eb1ng c\u00e1ch cho ph\u00e9p Cookie."},"zh.auth":{"about":"\u95dc\u65bc","account_deactivate":"\u60a8\u7684\u5e10\u53f7\u76ee\u524d\u5904\u4e8e\u975e\u6d3b\u52a8\u72b6\u6001\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002","app":{"create":"\u5275\u5efa","export":"\u51fa\u53e3","lock_account":"\u9396\u5b9a\u5e33\u6236","member_since":"\u6210\u54e1\u81ea","messages":"\u7559\u8a00","online":"\u5728\u7dda\u7684","print":"\u6253\u5370","profile":"\u8f2a\u5ed3","reload":"\u91cd\u65b0\u52a0\u8f09","reset":"\u91cd\u555f","search":"\u641c\u7d22","settings":"\u8a2d\u7f6e"},"choose_a_plan_that's_right_for_you":"\u9078\u64c7\u9069\u5408\u60a8\u7684\u8a08\u5283","confirm_password":"\u78ba\u8a8d\u5bc6\u78bc","contact":"\u63a5\u89f8","copyright_by":"\u7248\u6b0a\u6240\u6709","email":"\u96fb\u5b50\u90f5\u4ef6","email_verify":"\u8bf7\u5728\u767b\u5f55\u524d\u9a8c\u8bc1\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u3002","emails":{"password":{"reset_link":"\u9ede\u64ca\u9019\u88e1\u91cd\u7f6e\u60a8\u7684\u5bc6\u78bc"}},"failed":"\u9019\u4e9b\u6191\u64da\u8207\u6211\u5011\u7684\u8a18\u9304\u4e0d\u7b26.","features":"\u7279\u5fb5","forgot_password":{"send_pwd_reset":"\u767c\u9001\u5bc6\u78bc\u91cd\u7f6e\u93c8\u63a5","title":"\u8f38\u5165\u90f5\u7bb1\u91cd\u7f6e\u5bc6\u78bc"},"full_name":"\u5168\u540d","get_started":"\u958b\u59cb\u4f7f\u7528","home":"\u5bb6","let's_hear_what_they_say":"\u8b93\u6211\u5011\u807d\u807d\u4ed6\u5011\u600e\u9ebc\u8aaa","login":{"forgot_password":"\u6211\u5fd8\u8a18\u4e86\u6211\u7684\u5bc6\u78bc","register_membership":"\u8a3b\u518a\u65b0\u6703\u54e1","title":"\u767b\u9304\u4ee5\u958b\u59cb\u60a8\u7684\u6703\u8a71"},"modern_&_powerful_interface":"\u73fe\u4ee3\u800c\u5f37\u5927\u7684\u754c\u9762","password":"\u5bc6\u78bc","pricing":"\u50f9\u9322","register":"\u767b\u8a18","registration":{"have_membership":"\u6211\u5df2\u7d93\u6709\u6703\u54e1\u4e86","i_agree":"\u6211\u540c\u610f","terms":"\u689d\u6b3e","title":"\u8a3b\u518a\u65b0\u6703\u54e1"},"remember_me":"\u8a18\u5f97\u6211","reset_password":{"reset_pwd_btn":"\u91cd\u8a2d\u5bc6\u78bc","title":"\u91cd\u7f6e\u60a8\u7684\u5bc6\u78bc"},"sign_in":"\u767b\u5165","sign_out":"\u767b\u51fa","sign_up":"\u5831\u540d","stories_from_our_customers":"\u6211\u4eec\u5ba2\u6237\u7684\u6545\u4e8b","subscribe_here":"\u5728\u9019\u88e1\u8a02\u95b1","throttle":"\u767b\u9304\u5617\u8a66\u6b21\u6578\u904e\u591a\u3002\u8acb\u5728 :seconds \u79d2\u5f8c\u91cd\u8a66."},"zh.crud":{"action":"\u884c\u52d5","add_new":"\u6dfb\u65b0","are_you_sure":"\u4f60\u78ba\u5b9a\u55ce\uff1f","back":"\u5f8c\u9000","cancel":"\u53d6\u6d88","created_at":"\u5275\u5efa\u65bc","deleted_at":"\u522a\u9664\u65bc","detail":"\u7d30\u7bc0","edit":"\u7de8\u8f2f","id":"ID","save":"\u4fdd\u5b58","updated_at":"\u66f4\u65b0\u65bc"},"zh.livewire-tables::strings":{"All":"\u5168\u90e8","Applied Filters":"\u5df2\u5957\u7528\u7684\u904e\u6ffe\u898f\u5247","Applied Sorting":"\u5df2\u5957\u7528\u7684\u641c\u5c0b\u898f\u5247","Bulk Actions":"\u6279\u6b21\u64cd\u4f5c","Clear":"\u6e05\u9664","Columns":"\u6b04\u4f4d","Done Reordering":"\u6392\u5e8f\u5b8c\u6210","Filters":"\u904e\u6ffe\u898f\u5247","No items found. Try to broaden your search.":"\u7121\u8cc7\u6599\u5448\u73fe\u3002\u8acb\u5617\u8a66\u64f4\u5927\u641c\u5c0b\u7bc4\u570d\u3002","Remove filter option":"\u79fb\u9664\u904e\u6ffe\u898f\u5247","Remove sort option":"\u79fb\u9664\u6392\u5e8f\u898f\u5247","Reorder":"\u91cd\u65b0\u6392\u5e8f","Search":"\u641c\u5c0b","Select All":"\u641c\u5c0b\u5168\u90e8","Show":"\u986f\u793a","Showing":"\u986f\u793a","Unselect All":"\u53d6\u6d88\u9078\u64c7","You are currently selecting all":"\u60a8\u76ee\u524d\u5df2\u9078\u64c7\u5168\u90e8\u8cc7\u6599","You are not connected to the internet.":"\u76ee\u524d\u70ba\u96e2\u7dda\u6a21\u5f0f","You have selected":"\u60a8\u5df2\u9078\u64c7","of":"\u7b46\u8cc7\u6599\uff0c\u5171","results":"\u7b46\u8cc7\u6599","rows":"\u7b46\u8cc7\u6599","rows, do you want to select all":"\u7b46\u8cc7\u6599\uff0c\u60a8\u662f\u5426\u8981\u5168\u9078","to":"\u81f3"},"zh.messages":{"Business_Beacon":"\u5546\u4e1a\u706f\u5854","CEO\/CXO":"\u4f01\u4e1a\u9996\u5e2d\u6267\u884c\u5b98\/CXO \u7535\u5b50\u540d\u7247","Clean_Canvas":"\u5e72\u51c0\u7684\u753b\u5e03","Corporate_Classic":"\u4f01\u4e1a\u7ecf\u5178","Corporate_Connect":"\u4f01\u4e1a\u8054\u7cfb","Corporate_Identity":"\u4f01\u4e1a\u5f62\u8c61","Culinary_Food_Services":"\u70f9\u996a\u548c\u98df\u54c1\u670d\u52a1\u7535\u5b50\u540d\u7247","Event_Management":"\u4e8b\u4ef6\u7ba1\u7406","Executive_Profile":"\u9ad8\u7ba1\u7b80\u4ecb","Fashion_Beauty":"\u65f6\u5c1a\u4e0e\u7f8e\u5bb9\u7535\u5b50\u540d\u7247","Gym":"\u5065\u8eab\u623f","Hospital":"\u533b\u9662","Lawyer":"\u5f8b\u5e08","Manually":"\u624b\u52a8","Modern_Edge":"\u73b0\u4ee3\u8fb9\u7f18","Paypal":"\u8d1d\u5b9d","Portfolio":"\u6587\u4ef6\u5939","Pro_Network":"\u4e13\u4e1a\u7f51\u7edc","Professional":"\u4e13\u4e1a\u7684","Programmer":"\u7a0b\u5e8f\u5458","Razorpay":"\u5243\u987b\u5200\u652f\u4ed8","Receive_latest_news_update_and_many_other_things_every_week":"\u6bcf\u5468\u63a5\u6536\u6700\u65b0\u6d88\u606f\u3001\u66f4\u65b0\u548c\u8bb8\u591a\u5176\u4ed6\u5185\u5bb9\u3002","Salon":"\u6c99\u9f99","Simple_Contact":"\u7b80\u5355\u8054\u7cfb","Social_Media":"\u793e\u4ea4\u5a92\u4f53\u5f71\u54cd\u8005\u7535\u5b50\u540d\u7247","Stripe":"\u6761\u7eb9","Subscribe_Our_Newsletter":"\u8ba2\u9605\u6211\u4eec\u7684\u65f6\u4e8b\u901a\u8baf","about_us":{"about_us":"\u95dc\u65bc\u6211\u5011","description":"\u63cf\u8ff0","image":"\u95dc\u65bc\u5f62\u8c61","title":"\u6a19\u984c"},"admin":{"add_admin":"\u6dfb\u52a0\u7ba1\u7406\u5458","admin":"\u884c\u653f","admin_created_successfully":"\u7ba1\u7406\u5458\u521b\u5efa\u6210\u529f\u3002","admin_delete_successfully":"\u7ba1\u7406\u5458\u5220\u9664\u6210\u529f\u3002","admin_details":"\u7ba1\u7406\u5458\u8be6\u60c5","admin_updated_successfully":"\u7ba1\u7406\u5458\u66f4\u65b0\u6210\u529f\u3002","avatar":"\u963f\u51e1\u8fbe","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_number":"\u8054\u7cfb\u7535\u8bdd","edit_admin":"\u7f16\u8f91\u7ba1\u7406\u5458","email":"\u7535\u5b50\u90ae\u4ef6","female":"\u5973\u6027","first_name":"\u540d\u5b57","full_name":"\u5168\u540d","gender":"\u6027\u522b","last_name":"\u59d3","male":"\u7537\u6027","not_allowed_to_access":"\u770b\u6765\u60a8\u65e0\u6743\u8bbf\u95ee\u6b64\u8bb0\u5f55\u3002","password":"\u5bc6\u7801","profile":"\u8f6e\u5ed3","profile_details":"\u4e2a\u4eba\u8d44\u6599\u8be6\u60c5"},"admins":"\u7ba1\u7406\u5458","affiliation":{"affiliate_note":"\u8bf7\u6ce8\u610f\uff1a\u60a8\u7684\u96b6\u5c5e\u5173\u7cfb\u8be6\u7ec6\u4fe1\u606f\u5c06\u53d1\u5e03\u5728\u60a8\u7684 vcards en bas \u9875\u9762\u4e0a\u3002\u5982\u679c\u60a8\u901a\u8fc7 cella \u6ce8\u518c\u5e76\u5728 cella \u4e4b\u540e\u83b7\u5f97\u8ba2\u9605\uff0c\u60a8\u5c06\u83b7\u5f97 \u5362\u6bd4\u7684\u5956\u52b1","affiliated_by":"\u96b6\u5c5e\u4e8e","affiliation_transaction":"\u9644\u5c5e\u4ea4\u6613","affiliation_withdraw_detail":"\u4ece\u5c5e\u5173\u7cfb\u63d0\u6b3e\u8be6\u60c5","affiliations":"\u96b6\u5c5e\u5173\u7cfb","approval_status":"\u6279\u51c6\u72b6\u6001","approve":"\u6279\u51c6","approve_withdraw_request":"\u6279\u51c6\u64a4\u56de\u8bf7\u6c42","approved":"\u5f97\u5230\u6b63\u5f0f\u8ba4\u53ef\u7684","cash_payment":"\u73b0\u91d1\u652f\u4ed8","current_amount":"\u5f53\u524d\u91d1\u989d","reject":"\u62d2\u7edd","reject_withdraw_request":"\u62d2\u7edd\u63d0\u6b3e\u8bf7\u6c42","rejected":"\u62d2\u7edd","rejection_note":"\u62d2\u7edd\u8bf4\u660e","total_affiliation_amount":"\u9644\u5c5e\u603b\u91d1\u989d","verify_paypal_email":"\u9a8c\u8bc1\u8d1d\u5b9d\u7535\u5b50\u90ae\u4ef6","withdraw_amount":"\u53d6\u6b3e\u6570\u91cf","withdrawal":"\u9000\u51fa"},"allowed_file_types":"\u5141\u8a31\u7684\u6587\u4ef6\u985e\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","analytic":{"vcard_analytic":"\u7535\u5b50\u540d\u7247\u5206\u6790"},"analytics":{"browsers":"\u700f\u89bd\u5668","countries":"\u570b\u5bb6","devices":"\u8a2d\u5099","languages":"\u8a9e\u8a00","os":"\u64cd\u4f5c\u7cfb\u7d71","overview":"\u6982\u8ff0","see_all":"\u67e5\u770b\u5168\u90e8","view_more":"\u67e5\u770b\u66f4\u591a","visitors":"\u8a2a\u5ba2"},"appointment":{"appointment":"\u9884\u7ea6","appointment_details":"\u9884\u7ea6\u8be6\u60c5","appointment_type":"\u9884\u7ea6\u7c7b\u578b\uff1a","calendar":"\u65e5\u5386","ends":"\u7ea6\u4f1a\u7ed3\u675f","free":"\u81ea\u7531","paid":"\u6709\u85aa\u916c\u7684","starts":"\u7ea6\u4f1a\u5f00\u59cb"},"appointments":"\u7d04\u6703","business":{"business_hours":"\u71df\u696d\u6642\u9593","end_time":"\u6642\u9593\u7d50\u675f","fri":"\u9031\u4e94","mon":"\u661f\u671f\u4e00","sat":"\u661f\u671f\u516d","start_time":"\u958b\u59cb\u6642\u9593","sun":"\u661f\u671f\u65e5","thu":"\u8490\u96c6","tue":"\u9031\u4e8c","wed":"\u661f\u671f\u4e09"},"by_signing_up_you_agree_to_our":"\u6ce8\u518c\u5373\u8868\u793a\u60a8\u540c\u610f\u6211\u4eec\u7684","cash_payment":"\u73b0\u91d1\u652f\u4ed8","city":{"cities":"\u57ce\u5e02","city":"\u57ce\u5e02","city_name":"\u57ce\u5e02\u540d","edit_city":"\u7de8\u8f2f\u57ce\u5e02","new_city":"\u65b0\u57ce\u5e02","no_city_available":"\u6c92\u6709\u53ef\u7528\u7684\u57ce\u5e02","no_city_found":"\u672a\u627e\u5230\u57ce\u5e02","state_name":"\u5dde\u540d"},"common":{"Yes_Change":"\u662f\u7684\uff0c\u6539\u53d8","action":"\u884c\u52d5","active":"\u7a4d\u6975\u7684","add":"\u6dfb\u52a0","add_virtual_background":"\u6dfb\u52a0\u865a\u62df\u80cc\u666f","allow_cookies":"\u5141\u8bb8 cookie","already_have_an_account":"\u5df2\u6709\u8cec\u865f","apply":"\u7533\u8bf7","apply_changes":"\u5e94\u7528\u6b64\u66f4\u6539","are_you_completed":"\u60a8\u786e\u5b9a\u8981\u66f4\u6539\u6b64\u72b6\u6001\u5417\uff1f","are_you_sure":"\u4f60\u78ba\u5b9a\u8981\u522a\u9664\u9019\u500b","are_you_sure_dublicate_vcard":"\u60a8\u786e\u5b9a\u8981\u521b\u5efa\u6b64 VCard \u526f\u672c\u5417\uff1f","back":"\u5f8c\u9000","back_subscription":"\u8fd4\u56de\u8a02\u95b1","cancel":"\u53d6\u6d88","captcha_enable":"\u542f\u7528\u8c37\u6b4c\u9a8c\u8bc1\u7801","closed":"\u95dc\u9589","completed":"\u5b8c\u5168\u7684","cookie_banner_enabled":"Cookie \u6a2a\u5e45\u542f\u7528","cookie_msg":"\u5141\u8bb8\u4f7f\u7528 cookie \u5c06\u6539\u5584\u60a8\u5728\u672c\u7f51\u7ad9\u4e0a\u7684\u4f53\u9a8c\u3002","create_an_account":"\u5275\u5efa\u4e00\u500b\u5e33\u6236","currency_position":"\u8d27\u5e01\u5934\u5bf8","custom":"\u98ce\u4fd7","declined":"\u8870\u9000","default_country_code":"\u9ed8\u8ba4\u56fd\u5bb6\u4ee3\u7801","delete":"\u522a\u9664","deleted":"\u5df2\u522a\u9664","description":"\u63cf\u8ff0","details":"\u7d30\u7bc0","discard":"\u4e1f\u68c4","download":"\u4e0b\u8f7d","duplicate":"\u590d\u5236 \uff01","duplicate_vcard_create":"\u91cd\u590d Vcard \u521b\u5efa\u6210\u529f","edit":"\u7de8\u8f2f","email":"\u96fb\u5b50\u90f5\u4ef6","enable_cookie_banner":"\u542f\u7528 Cookie \u6a2a\u5e45","enable_page":"\u542f\u7528\u767b\u9646\u9875\u9762","enable_register":"\u542f\u7528\u6ce8\u518c","enable_validation":"\u542f\u7528\u9a8c\u8bc1","enquiry":"\u67e5\u8a62","error":"\u9519\u8bef","filter":"\u7b5b\u9009","forgot_password":"\u5fd8\u8a18\u5bc6\u78bc","forgot_your_password":"\u5fd8\u8a18\u5bc6\u78bc\u4e86\u55ce","from":"\u4ece","has_been_completed":"\u5df2\u7ecf\u5b8c\u6210.","has_been_deleted":"\u5df2\u88ab\u522a\u9664.","icon":"\u5716\u6a19","inactive":"\u4e0d\u6d3b\u8e8d","infyvcard":"\u96fb\u5b50\u540d\u7247","is_active":"\u6d3b\u8e8d","link":"\u95dc\u806f","loading":"\u6b63\u5728\u52a0\u8f09...","login":"\u767b\u9304","logout":"\u767b\u51fa","message":"\u4fe1\u606f","name":"\u540d\u7a31","new_here":"\u65b0\u4f86\u7684","no":"\u4e0d\uff0c\u53d6\u6d88","no_data_available":"\u7121\u53ef\u7528\u6578\u64da","notUsed":"\u9084\u6c92\u7528","ok":"\u884c","payment_methods":"\u4ed8\u6b3e\u65b9\u6cd5","paypal_email":"\u8d1d\u5b9d\u90ae\u7bb1","pending":"\u5f85\u529e\u7684","phone":"\u96fb\u8a71","phone_validation":"\u7535\u8bdd\u53f7\u7801\u9a8c\u8bc1","please_wait":"\u8acb\u7a0d\u7b49...","price":"\u4ef7\u683c","product_url":"\u4ea7\u54c1\u7f51\u5740","register":"\u767b\u8a18","register_enable":"\u6ce8\u518c\u542f\u7528","remember_me":"\u8a18\u5f97\u6211","reset":"\u91cd\u542f","save":"\u4fdd\u5b58","service_url":"\u670d\u52a1\u7f51\u5740","show_currency_behind":"\u663e\u793a\u80cc\u540e\u7684\u8d27\u5e01","sign_in_here":"\u5728\u9019\u88e1\u767b\u9304","status":"\u5730\u4f4d","sub_text":"\u5b50\u6587\u672c","subject":"\u4e3b\u984c","submit":"\u63d0\u4ea4","successful":"\u6210\u529f\u7684","to":"\u81f3","today":"\u4eca\u5929","today_appointments":"\u4eca\u5929\u7684\u7d04\u6703","today_enquiry":"\u4eca\u65e5\u67e5\u8a62","total__active_vcards":"\u6d3b\u52a8\u5361\u603b\u6570","total__deactive_vcards":"\u505c\u7528\u7684\u7535\u5b50\u5361\u603b\u6570","total_active_users":"\u6d3b\u8dc3\u7528\u6237\u603b\u6570","total_amount":"\u603b\u91d1\u989d","total_deactive_users":"\u505c\u7528\u7528\u6237\u603b\u6570","total_plans":"\u7e3d\u8a08\u5283","total_users":"\u7e3d\u7528\u6236","total_vcards":"\u96fb\u5b50\u540d\u7247\u7e3d\u6578","type":"\u985e\u578b","unavailable":"\u4e0d\u53ef\u7528","upload_file":"\u4e0a\u4f20\u6587\u4ef6","user":"\u7528\u6237","view":"\u770b\u6cd5","virtual_note":"\u6ce8\u610f\uff1a\u865a\u62df\u80cc\u666f\u5c06\u4e3a\u60a8\u63d0\u4f9b\u540d\u7247\u56fe\u50cf\uff0c\u5176\u4e2d\u5c06\u5199\u6709\u60a8\u7684\u5fbd\u6807\u3001\u59d3\u540d\u3001\u5730\u5740\u548c\u7535\u8bdd\u3002\u6211\u4eec\u6b63\u5728\u5bfc\u51fa\u6c34\u5e73\u548c\u5782\u76f4\u865a\u62df\u80cc\u666f\u7684\u6807\u51c6\u5c3a\u5bf8\uff0c\u8fd9\u5728\u60a8\u60f3\u8981\u8bbe\u8ba1 NFC \u5361\u65f6\u975e\u5e38\u6709\u7528\uff0c\u60a8\u53ef\u4ee5\u76f4\u63a5\u5c06\u8fd9\u4e9b\u56fe\u50cf\u63d0\u4f9b\u7ed9 NFC \u6253\u5370\u5904\u7406\u7a0b\u5e8f\u3002\u6b64\u5916\uff0c\u60a8\u4e5f\u53ef\u4ee5\u76f4\u63a5\u4e0e\u60a8\u7684\u670b\u53cb\u5206\u4eab\u6216\u5c06\u5176\u8bbe\u7f6e\u4e3a\u4e2a\u4eba\u8d44\u6599\/\u5c01\u9762\u56fe\u7247\u3002","yes":"\u662f\u7684\uff0c\u522a\u9664","yes_duplicate":"\u662f\u7684\uff0c\u91cd\u590d\uff01"},"contact_us":{"contact":"\u806f\u7e6b\u6211\u5011","contact_us":"\u67e5\u8be2","inquries":"\u67e5\u8be2","message":"\u4fe1\u606f","send_message":"\u767c\u4fe1\u606f"},"copy_text":"\u590d\u5236","country":{"countries":"\u570b\u5bb6","country":"\u570b\u5bb6","country_name":"\u570b\u5bb6\u7684\u540d\u5b57","edit_country":"\u7de8\u8f2f\u570b\u5bb6","new_country":"\u65b0\u570b\u5bb6","no_country_available":"\u6c92\u6709\u53ef\u7528\u7684\u570b\u5bb6","no_country_found":"\u672a\u627e\u5230\u570b\u5bb6","phone_code":"\u96fb\u8a71\u4ee3\u78bc","short_code":"\u77ed\u9c48\u9b5ae"},"coupon_code":{"add_coupon_code":"\u6dfb\u52a0\u4f18\u60e0\u5238\u4ee3\u7801","apply_here":"\u5728\u8fd9\u91cc\u7533\u8bf7","coupon_code":"\u4f18\u60e0\u5238\u4ee3\u7801","coupon_code_applied":"\u4f18\u60e0\u5238\u4ee3\u7801\u5e94\u7528\u6210\u529f\u3002","coupon_code_created":"\u4f18\u60e0\u5238\u4ee3\u7801\u521b\u5efa\u6210\u529f\u3002","coupon_code_percent_validation":"\u4f18\u60e0\u5238\u6298\u6263\u4e0d\u5e94\u8d85\u8fc7100%\u3002","coupon_code_status_updated":"\u4f18\u60e0\u5238\u4ee3\u7801\u72b6\u6001\u5df2\u6210\u529f\u66f4\u65b0\u3002","coupon_code_updated":"\u4f18\u60e0\u5238\u4ee3\u7801\u66f4\u65b0\u6210\u529f\u3002","coupon_codes":"\u4f18\u60e0\u5238\u4ee3\u7801","coupon_discount":"\u4f18\u60e0\u5238\u6298\u6263","coupon_name":"\u4f18\u60e0\u5238\u540d\u79f0","coupon_type":"\u4f18\u60e0\u5238\u7c7b\u578b","edit_coupon_code":"\u7f16\u8f91\u4f18\u60e0\u5238\u4ee3\u7801","enter_coupon_code":"\u8f93\u5165\u4f18\u60e0\u5238\u4ee3\u7801","enter_coupon_discount":"\u8f93\u5165\u4f18\u60e0\u5238\u6298\u6263","enter_coupon_name":"\u8f93\u5165\u4f18\u60e0\u5238\u540d\u79f0","expire_at":"\u8fc7\u671f\u4e8e","fixed":"\u56fa\u5b9a\u7c7b\u578b","flat":"\u5e73\u5766\u7684","have_a_coupon_code":"\u6709\u4f18\u60e0\u5238\u4ee3\u7801\uff1f","percentage":"\u767e\u5206\u6bd4","remove":"\u6d88\u9664"},"create_vcard":"\u521b\u5efa\u60a8\u7684\u7535\u5b50\u540d\u7247","create_your_business_digital_card_with_lots_of_information":"\u521b\u5efa\u5305\u542b\u5927\u91cf\u4fe1\u606f\u7684\u5546\u52a1\u6570\u5b57\u5361n","currency":{"currencies":"\u8ca8\u5e63","currency_code":"\u8ca8\u5e63\u4ee3\u78bc","currency_icon":"\u8ca8\u5e63\u5716\u6a19"},"dashboard":"\u4eea\u8868\u677f","date":"\u65e5\u671f","deactivate":"\u505c\u7528","e_card":{"add_ecard":"\u6dfb\u52a0\u7535\u5b50\u8d3a\u5361","ecard":"\u7535\u5b50\u8d3a\u5361","ecard_info":"\u56fe\u50cf\u7684\u50cf\u7d20\u5fc5\u987b\u4e3a 150 x 150","ecard_logo":"\u7535\u5b50\u8d3a\u5361\u6807\u5fd7","ecards":"\u7535\u5b50\u8d3a\u5361"},"edit_subscription":"\u7de8\u8f2f\u8a02\u95b1\u8a08\u5283","edit_translation":"\u7f16\u8f91\u7ffb\u8bd1","email_not_found":"\u6211\u4eec\u627e\u4e0d\u5230\u5177\u6709\u8be5\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u7684\u7528\u6237","email_password_reset_link":"\u90f5\u7bb1\u5bc6\u78bc\u91cd\u7f6e\u93c8\u63a5","enquiry":"\u67e5\u8a62","enquiry_detail":"\u67e5\u8a62\u8a73\u60c5","expire_in":"\u8a08\u5283\u5373\u5c07\u5230\u671f","extra_scripts":"\u989d\u5916\u811a\u672c","feature":{"affiliation":"\u8054\u7cfb","analytics":"\u5206\u6790","appointments":"\u7d04\u6703","blog":"\u535a\u5ba2","custom_css":"\u81ea\u5b9a\u7fa9 CSS","custom_fonts":"\u81ea\u5b9a\u7fa9\u5b57\u9ad4","custom_js":"\u81ea\u5b9a\u7fa9 JS","custom_qrcode":"\u81ea\u5b9a\u4e49\u4e8c\u7ef4\u7801","description":"\u63cf\u8ff0","edit_feature":"\u7de8\u8f2f\u7279\u5fb5","enquiry_form":"\u67e5\u8a62\u8868\u683c","feature_image":"\u7279\u8272\u5716\u7247","gallery":"\u756b\u5eca","hide_branding":"\u96b1\u85cf\u54c1\u724c","image":"\u5716\u7247","name":"\u540d\u7a31","order_nfc_card":"\u8ba2\u8d2d NFC \u5361","password":"\u5bc6\u78bc\u4fdd\u8b77","products":"\u7522\u54c1","products_services":"\u670d\u52d9","seo":"\u641c\u7d22\u5f15\u64ce\u512a\u5316","social_links":"\u793e\u4ea4\u93c8\u63a5","testimonials":"\u611f\u8a00"},"features":"\u7279\u5fb5","flash":{"about_us_create":"\u95dc\u65bc\u6211\u5011\u5df2\u6210\u529f\u4fdd\u5b58\u3002","can_not_change_time_format":"\u6b64\u65f6\u95f4\u683c\u5f0f\u7684\u7ea6\u4f1a\u5df2\u88ab\u9884\u8ba2","city_create":"\u57ce\u5e02\u4fdd\u5b58\u6210\u529f\u3002","city_update":"\u57ce\u5e02\u66f4\u65b0\u6210\u529f\u3002","country_create":"\u570b\u5bb6\/\u5730\u5340\u4fdd\u5b58\u6210\u529f.","country_update":"\u570b\u5bb6\/\u5730\u5340\u66f4\u65b0\u6210\u529f.","country_used":"\u5df2\u5728\u4f7f\u7528\u7684\u570b\u5bb6\/\u5730\u5340","create_blog":"VCard \u535a\u5ba2\u521b\u5efa\u6210\u529f\u3002","create_front_testimonial":"\u63a8\u85a6\u4fe1\u5275\u5efa\u6210\u529f\u3002","create_product":"VCard \u7522\u54c1\u5275\u5efa\u6210\u529f\u3002","create_service":"VCard \u670d\u52d9\u5275\u5efa\u6210\u529f.","create_testimonial":"VCard \u898b\u8b49\u5275\u5efa\u6210\u529f.","current_invalid":"\u7576\u524d\u5bc6\u78bc\u7121\u6548.","database_upgrade_succesfully":"\u60a8\u7684\u6570\u636e\u5e93\u5347\u7ea7\u6210\u529f","decription_is_required":"\u63cf\u8ff0\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","feature_update":"\u529f\u80fd\u66f4\u65b0\u6210\u529f\u3002","front_cms":"\u524d\u53f0 CMS \u66f4\u65b0\u6210\u529f.","language_update":"\u8a9e\u8a00\u66f4\u65b0\u6210\u529f.","mobile_validation":"\u79fb\u52a8\u9a8c\u8bc1\u66f4\u65b0\u6210\u529f\u3002","name_is_required":"\u540d\u5b57\u7684\u5b57\u6bb5\u662f\u5fc5\u9700\u7684","password_update":"\u5bc6\u78bc\u66f4\u65b0\u6210\u529f\u3002","plan_create":"\u8a08\u5283\u5275\u5efa\u6210\u529f.","plan_default":"\u9ed8\u8a8d\u8a08\u5283\u66f4\u6539\u6210\u529f\u3002","plan_status":"\u8a08\u5283\u72c0\u614b\u66f4\u65b0\u6210\u529f","plan_update":"\u8a08\u5283\u66f4\u65b0\u6210\u529f.","setting_update":"\u8a2d\u7f6e\u66f4\u65b0\u6210\u529f\u3002","social_links_img_is_required":"\u793e\u4ea4\u94fe\u63a5\u56fe\u7247\u662f\u5fc5\u9700\u7684","social_links_is_required":"\u9700\u8981\u793e\u4ea4\u94fe\u63a5","state_create":"\u72c0\u614b\u4fdd\u5b58\u6210\u529f.","state_update":"\u72c0\u614b\u66f4\u65b0\u6210\u529f\u3002","state_used":"\u72c0\u614b\u5df2\u5728\u4f7f\u7528","success_theme_update":"\u4e3b\u9898\u66f4\u65b0\u6210\u529f","update_blog":"VCard \u535a\u5ba2\u66f4\u65b0\u6210\u529f\u3002","update_front_testimonial":"\u898b\u8b49\u66f4\u65b0\u6210\u529f\u3002","update_product":"VCard \u7522\u54c1\u66f4\u65b0\u6210\u529f\u3002","update_service":"VCard \u670d\u52d9\u66f4\u65b0\u6210\u529f.","update_testimonial":"VCard \u898b\u8b49\u66f4\u65b0\u6210\u529f.","user_create":"\u7528\u6236\u5275\u5efa\u6210\u529f.","user_profile":"\u7528\u6236\u8cc7\u6599\u66f4\u65b0\u6210\u529f.","user_status":"\u7528\u6236\u72c0\u614b\u66f4\u65b0\u6210\u529f","user_update":"\u7528\u6236\u66f4\u65b0\u6210\u529f.","vcard_create":"VCard \u5275\u5efa\u6210\u529f\u3002","vcard_delete":"VCard \u522a\u9664\u6210\u529f.","vcard_retrieve":"VCard \u6aa2\u7d22\u6210\u529f","vcard_status":"VCard\u72c0\u614b\u66f4\u65b0\u6210\u529f","vcard_update":"\u66f4\u65b0\u6210\u529f.","verified_email":"\u90f5\u7bb1\u9a57\u8b49\u6210\u529f"},"font":{"font_family":"\u5b57\u9ad4\u7cfb\u5217","font_size":"\u5b57\u9ad4\u5927\u5c0f","font_size_in_px":"\u5b57\u4f53\u5927\u5c0f\uff08\u4ee5\u50cf\u7d20\u4e3a\u5355\u4f4d\uff09","fonts":"\u5b57\u9ad4","px":"\u50cf\u7d20"},"form":{"DOB":"\u8f38\u5165\u51fa\u751f\u65e5\u671f","allowed_vcard":"\u8f38\u5165\u5141\u8a31\u7684\u96fb\u5b50\u540d\u7247\u6578\u91cf","blog":"\u8f93\u5165\u535a\u5ba2\u540d\u79f0","c_password":"\u78ba\u8a8d\u5bc6\u78bc","company":"\u8f38\u5165\u516c\u53f8\u540d\u7a31","contact":"\u96fb\u8a71\u865f\u78bcr","css":"\u8f38\u5165\u81ea\u5b9a\u7fa9 CSS","description":"\u8f38\u5165\u60a8\u7684 VCard \u7684\u63cf\u8ff0","designation":"\u8f93\u5165\u540d\u79f0","email":"\u8f38\u5165\u96fb\u90f5\u5730\u5740","enter_email":"\u8f38\u5165\u96fb\u5b50\u90f5\u4ef6","enter_name":"\u8f38\u5165\u540d\u5b57","enter_phone":"\u8f38\u5165\u96fb\u8a71","enter_trial":"\u8f38\u5165\u8a66\u7528\u5929\u6578","f_name":"\u8f38\u5165\u540d\u5b57","facebook":"\u81c9\u66f8\u7db2\u5740","first_name":"\u540d","google_analytics":"\u8c37\u6b4c\u5206\u6790\u4ee3\u78bc","home_title":"\u8f38\u5165\u4e3b\u9801\u6a19\u984c","instagram":"Instagram \u7db2\u5740","job":"\u8f38\u5165\u8077\u4f4d","js":"\u8f38\u5165\u81ea\u5b9a\u7fa9 Js","l_name":"\u8f38\u5165\u59d3\u6c0f","last_name":"\u59d3","linkedin":"\u9818\u82f1\u7db2\u5740","location":"\u8f38\u5165\u60a8\u7684\u4f4d\u7f6e","location_url":"\u8f38\u5165\u60a8\u7684\u4f4d\u7f6e URL","mail":"\u96fb\u5b50\u90f5\u4ef6","meta_description":"\u8f38\u5165\u5143\u63cf\u8ff0","meta_keyword":"\u8f38\u5165\u5143\u95dc\u9375\u5b57","my_vcard_url":"\u6211\u7684\u96fb\u5b50\u540d\u7247\u9801\u9762\u7db2\u5740","occupation":"\u8f38\u5165\u8077\u696d","password":"\u5bc6\u78bc","phone":"\u8f38\u5165\u96fb\u8a71\u865f\u78bc","pick_date":"\u9078\u64c7\u4e00\u500b\u65e5\u671f","pinterest":"Pinterest \u7db2\u5740","plan_name":"\u9032\u5165\u8a08\u5283\u5357e","price":"\u8f38\u5165\u50f9\u683c","product":"\u8f38\u5165\u7522\u54c1\u540d\u7a31","product_url":"\u8f93\u5165\u4ea7\u54c1\u7f51\u5740","reddit":"Reddit \u7db2\u5740","select_country":"\u9078\u64c7\u570b\u5bb6","select_currency":"\u9078\u64c7\u8ca8\u5e63","select_state":"\u9078\u64c7\u5dde","service":"\u8f38\u5165\u670d\u52d9\u540d\u7a31","service_url":"\u8f93\u5165\u670d\u52a1\u7f51\u5740","short_description":"\u8f38\u5165\u7c21\u77ed\u63cf\u8ff0","site_title":"\u8f38\u5165\u7db2\u7ad9\u6a19\u984c","testimonial":"\u8f38\u5165\u63a8\u85a6\u540d\u7a31","tiktok":"\u9ede\u64ca\u7db2\u5740","tumblr":"\u8c46\u74e3\u7db2\u5740","twitter":"\u63a8\u7279\u7db2\u5740","type_message":"\u5728\u6b64\u8655\u8f38\u5165\u6d88\u606f...","vcard_name":"\u8f38\u5165 VC \u5361\u540d\u7a31","website":"\u7db2\u5740","whatsapp":"WhatsApp \u7db2\u5740","your_email":"\u96fb\u5b50\u90f5\u4ef6\u5730\u5740","your_name":"\u4f60\u7684\u540d\u5b57","youtube":"\u512a\u9177\u7db2\u5740"},"from_time":"\u5f9e\u6642\u9593","front":{"enter_your_email":"\u8f93\u5165\u4f60\u7684\u7535\u5b50\u90ae\u7bb1","enter_your_message":"\u8f93\u5165\u60a8\u7684\u4fe1\u606f","enter_your_name":"\u8f93\u5165\u4f60\u7684\u540d\u5b57","your_email_address":"\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740"},"front_cms":{"banner":"\u6a6b\u5e45\u5716\u7247","description":"\u63cf\u8ff0","front_cms":"\u524d\u53f0CMS","title":"\u6a19\u984c"},"gallery":{"gallery_name":"\u753b\u5eca","image":"\u56fe\u50cf","type":"\u7c7b\u578b","youtube":"Youtube"},"hour":"\u5c0f\u6642","language":"\u8a9e","languages":{"edit_language":"\u7f16\u8f91\u8bed\u8a00","edit_translation":"\u7f16\u8f91\u7ffb\u8bd1","iso_code":"\u56fd\u9645\u6807\u51c6\u5316\u7ec4\u7ec7\u4ee3\u7801","language":"\u8bed\u8a00","languages":"\u8bed\u8a00","new_language":"\u65b0\u8bed\u8a00","translation":"\u7ffb\u8bd1"},"made_by":"\u7531\u88fd\u6210","made_by_url":"\u7531\u7f51\u5740\u5236\u4f5c","mail":{"action_required":"\u5982\u679c\u60a8\u6ca1\u6709\u521b\u5efa\u5e10\u6237\uff0c\u5219\u65e0\u9700\u8fdb\u4e00\u6b65\u64cd\u4f5c\u3002","appointment_time":"\u9884\u7ea6\u65f6\u95f4 ","approved_successfully":"\u60a8\u7684\u9884\u7ea6\u6210\u529f\u6279\u51c6\u4e8e","attachment":"\u9644\u4ef6","between":"\u4e4b\u95f4","book_appointment":"\u9884\u7ea6","book_successfully":"\u60a8\u7684\u9884\u7ea6\u6210\u529f\u9884\u7ea6","booked_appointment_with_you":"\u4e0e\u60a8\u9884\u7ea6","email":"\u7535\u5b50\u90ae\u4ef6\uff1a","hello":"\u4f60\u597d\uff0c","hello!":"\u4f60\u597d\uff01","here_is_enquiry":"\u8fd9\u662f\u67e5\u8be2\u8be6\u60c5","messages":"\u4fe1\u606f\uff1a ","name":"\u59d3\u540d\uff1a","new_manual_payment_request":"\u65b0\u7684\u4eba\u5de5\u4ed8\u6b3e\u8bf7\u6c42","new_nfc_order":"\u60a8\u5df2\u6536\u5230\u65b0\u7684 NFC \u8ba2\u5355","notes":"\u7b14\u8bb0","password_change":"\u60a8\u7684\u5bc6\u7801\u5df2\u88ab\u7ba1\u7406\u5458\u66f4\u6539 ","please_click":"\u8bf7\u5355\u51fb\u4e0b\u9762\u7684\u6309\u94ae\u4ee5\u9a8c\u8bc1\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u3002","please_contact_your_admin":"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u65b0\u5bc6\u7801\u3002 ","regard":"\u95ee\u5019\uff0c","slot_text":"\u5982\u679c\u60a8\u5728\u70b9\u51fb\u201c\u9a8c\u8bc1\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u201d\u6309\u94ae\u65f6\u9047\u5230\u95ee\u9898\uff0c\u8bf7\u5c06\u4ee5\u4e0b URL \u590d\u5236\u5e76\u7c98\u8d34\u5230\u60a8\u7684\u7f51\u7edc\u6d4f\u89c8\u5668\u4e2d","thanks_regard":"\u611f\u8c22\u548c\u95ee\u5019\uff0c","vcard_name":"\u540d\u7247\u540d\u79f0\uff1a","verify_email":"\u786e\u8ba4\u7535\u5b50\u90ae\u4ef6\u5730\u5740","whoops":"\u54ce\u5440\uff01"},"make_appointment":"\u7d04\u500b\u6642\u9593","make_appointments":"\u9810\u7d04","months":{"apr":"\u56db\u6708","aug":"\u4e5d\u6708","dec":"\u592a\u9633","feb":"\u4e8c\u6708","jan":"\u7b80","jul":"\u516b\u6708","jun":"\u541b","mar":"\u4e09\u6708","may":"\u53ef\u80fd","nov":"\u5341\u4e8c\u6708","oct":"\u5341\u4e00\u6708","sep":"\u5341\u6708"},"nfc":{"Add_NFC_card_photos_and_set_prices":"\u6dfb\u52a0 NFC \u5361\u7247\u7167\u7247\u5e76\u8bbe\u7f6e\u4ef7\u683c\u3002","Admin_Guide":"\u7ba1\u7406\u5458\u6307\u5357\uff1a\u9500\u552e NFC \u5361","Browse_and_select_an_NFC_card":"\u6d4f\u89c8\u5e76\u9009\u62e9\u4e00\u4e2a NFC \u5361\u3002","Choose_your_vCard_URL_of_that_vCard_will_be_written_to_NFC_card":"\u9009\u62e9\u60a8\u7684 vCard\uff0c\u8be5 vCard \u7684 URL \u5c06\u5199\u5165 NFC \u5361\u3002","Confirm_the_order_and_make_a_payment":"\u786e\u8ba4\u8ba2\u5355\u5e76\u8fdb\u884c\u652f\u4ed8\u3002","Create_or_log_in_to_your_account":"\u521b\u5efa\u6216\u767b\u5f55\u5230\u60a8\u7684\u5e10\u6237\u3002","Delivered":"\u53d1\u8868","Dispatch_the_NFC_cards_to_users":"\u5c06 NFC \u5361\u7247\u5206\u53d1\u7ed9\u7528\u6237\u3002","How_it_works":"\u5982\u4f55\u8fd0\u4f5c\uff1f","Log_in_to_the_Admin_Dashboard":"\u767b\u5f55\u5230\u7ba1\u7406\u5458\u4eea\u8868\u677f\u3002","Pending":"\u5f85\u529e\u7684","Ready To Ship":"\u51c6\u5907\u53d1\u8d27","Receive_and enjoy_your_NFC_card":"\u63a5\u6536\u5e76\u4eab\u53d7\u60a8\u7684 NFC \u5361\u3002","Review_user_orders":"\u67e5\u770b\u7528\u6237\u8ba2\u5355","Shipped":"\u5df2\u53d1\u8d27","User_Guide":"\u7528\u6237\u6307\u5357\uff1a\u8d2d\u4e70\u548c\u81ea\u5b9a\u4e49 NFC \u5361","Wait_for_the_admin_to_write_the_URL_and_dispatch_the_card":"\u7b49\u5f85\u7ba1\u7406\u5458\u5199\u5165 URL \u5e76\u5206\u53d1\u5361\u7247\u3002","Write_the_user_provided_URL_to_NFC_cards":"\u5c06\u7528\u6237\u63d0\u4f9b\u7684 URL \u5199\u5165 NFC \u5361\u7247\u3002","add_nfc_card":"\u6dfb\u52a0 NFC \u5361","all":"\u5168\u90e8","cancel":"\u53d6\u6d88","card_can_not_deleted":"\u8be5\u5361\u65e0\u6cd5\u5220\u9664\uff0c\u56e0\u4e3a\u5b83\u4e0e\u5ba2\u6237\u8ba2\u5355\u76f8\u5173\u8054\u3002","card_type":"\u5361\u7684\u79cd\u7c7b","company_name":"\u516c\u53f8\u540d\u79f0","designation":"\u6307\u5b9a","edit_nfc_card":"\u7f16\u8f91 NFC \u5361","enter_address":"\u8f93\u5165\u5730\u5740","failed":"\u5931\u8d25\u7684","logo":"\u6807\u8bc6","my_nfc_cards":"\u6211\u7684 NFC \u5361","new_nfc_card":"\u65b0NFC\u5361","nfc":"\u8fd1\u573a\u901a\u4fe1","nfc_card":"NFC\u5361","nfc_card_created_success":"NFC\u5361\u521b\u5efa\u6210\u529f","nfc_card_deleted_success":"NFC \u5361\u5220\u9664\u6210\u529f","nfc_card_order_details":"NFC \u5361\u8ba2\u5355\u8be6\u60c5","nfc_card_orders":"NFC\u5361\u8ba2\u5355","nfc_card_type":"NFC\u5361\u7c7b\u578b","nfc_card_types":"NFC \u5361\u7c7b\u578b","nfc_card_updated_success":"NFC\u5361\u66f4\u65b0\u6210\u529f","nfc_image":"\u5361\u56fe\u50cf","nfc_image_required":"NFC \u56fe\u50cf\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","order":"\u547d\u4ee4","order_nfc":"\u8ba2\u8d2d NFC","order_placed_success":"\u4e0b\u5355\u6210\u529f","order_status":"\u8ba2\u5355\u72b6\u6001","order_status_update_success":"\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u6210\u529f","orders":"\u547d\u4ee4","orders_count":"\u8ba2\u5355\u6570","paid":"\u6709\u85aa\u916c\u7684","payment_status":"\u652f\u4ed8\u72b6\u6001","payment_status_update_success":"\u4ed8\u6b3e\u72b6\u6001\u66f4\u65b0\u6210\u529f","pending":"\u5f85\u529e\u7684","razorpay_session_success":"RazorPay \u4f1a\u8bdd\u5df2\u6210\u529f\u521b\u5efa","required_vcard":"\u8bf7\u9009\u62e9\u7535\u5b50\u540d\u7247","select_card":"\u8bf7\u9009\u62e9\u5361\u7c7b\u578b","select_vcard":"\u9009\u62e9\u7535\u5b50\u540d\u7247","sell_nfc_cards":"\u9500\u552eNFC\u5361\u7247","your_order_status_changed":"\u60a8\u7684\u8ba2\u5355\u72b6\u6001\u5df2\u66f4\u6539"},"no_data":"\u7121\u53ef\u7528\u6578\u64da","no_matching_records_found":"\u6c92\u6709\u627e\u5230\u5339\u914d\u7684\u8a18\u9304","notification":{"mark_all_as_read":"\u6a19\u8a18\u70ba\u5df2\u8b80","notifications":"\u901a\u77e5","you_don`t_have_any_new_notification":"\u60a8\u6c92\u6709\u4efb\u4f55\u65b0\u901a\u77e5"},"paid_amount_can't_deleted":"\u4ed8\u8d39\u9884\u7ea6\u65e0\u6cd5\u5220\u9664","password_change":"\u60a8\u7684\u5bc6\u7801\u5df2\u88ab\u7ba1\u7406\u5458\u66f4\u6539 ","payment":{"cancelled":"\u53d6\u6d88","payment":"\u652f\u4ed8","payment_cancel":"\u4ed8\u6b3e\u53d6\u6d88","payment_success":"\u4ed8\u6b3e\u6210\u529f","payment_successful":"\u652f\u4ed8\u6210\u529f"},"payment_method":"\u4ed8\u6b3e\u65b9\u6cd5","payment_type":"\u652f\u4ed8\u65b9\u5f0f","placeholder":{"12_hour":"12 \u5c0f\u65f6 ","24_hour":"24\u5c0f\u65f6","address_field":"\u5730\u5740\u5b57\u6bb5\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","agree_term":"\u60a8\u5fc5\u987b\u540c\u610f\u6761\u6b3e\u548c\u6761\u4ef6\u3002","all_rights_reserve":"\u7248\u6743\u6240\u6709","app_name_required":"\u5e94\u7528\u540d\u79f0\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","appointment_created":"\u7ea6\u4f1a\u521b\u5efa\u6210\u529f\u3002","cannot_switch_to_zero":"\u5982\u679c\u8bd5\u7528\u53ef\u7528\/\u6709\u5f53\u524d\u6709\u6548\u7684\u4ed8\u8d39\u8ba1\u5212\uff0c\u5219\u65e0\u6cd5\u5207\u6362\u5230\u96f6\u8ba1\u5212","choose_one_template":"\u9009\u62e9\u4efb\u4f55\u4e00\u4e2a\u6a21\u677f","copied_successfully":"\u94fe\u63a5\u590d\u5236\u6210\u529f\u3002","de_active":"\u53bb\u6d3b","default_plan_can_not_be_delete":"\u65e0\u6cd5\u5220\u9664\u9ed8\u8ba4\u8ba1\u5212","email_already_subscribed":"\u8be5\u7535\u5b50\u90ae\u4ef6\u5df2\u8ba2\u9605\u3002","email_verification":"\u4f60\u7684\u500b\u4eba\u8cc7\u6599\u5df2\u7d93\u66f4\u65b0\u3002 \u6211\u5011\u5df2\u5411\u60a8\u767c\u9001\u4e86\u4e00\u5c01\u9a57\u8b49\u90f5\u4ef6\u3002 \u8acb\u9a57\u8b49\u60a8\u66f4\u6539\u7684\u90f5\u4ef6\u3002","enquiry_sent":"\u67e5\u8be2\u53d1\u9001\u6210\u529f\u3002","enter_valid_email":"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u7535\u5b50\u90ae\u4ef6\u3002","enter_your_email_to_reset":"\u8f93\u5165\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u4ee5\u91cd\u7f6e\u60a8\u7684\u5bc6\u7801\u3002","error":"\u9519\u8bef","favicon_invalid":"\u7f51\u7ad9\u56fe\u6807\u7684\u56fe\u7247\u5c3a\u5bf8\u65e0\u6548\u3002","first_name_required":"\u540d\u5b57\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","forgot_your_password_no_problem":"\u5fd8\u8bb0\u5bc6\u7801\u4e86\u5417\uff1f \u6ca1\u95ee\u9898\u3002 \u53ea\u9700\u8ba9\u6211\u4eec\u77e5\u9053\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740\uff0c\u6211\u4eec\u5c31\u4f1a\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u5411\u60a8\u53d1\u9001\u4e00\u4e2a\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5\uff0c\u8ba9\u60a8\u53ef\u4ee5\u9009\u62e9\u4e00\u4e2a\u65b0\u7684\u3002","gallery_created":"\u56fe\u5e93\u521b\u5efa\u6210\u529f\u3002","gallery_updated":"\u56fe\u5e93\u5df2\u6210\u529f\u66f4\u65b0\u3002","invalid_country_code":"\u56fd\u5bb6\u4ee3\u7801\u65e0\u6548","invalid_number":"\u65e0\u6548\u53f7\u7801","lang_already_exists":" \u8bed\u8a00\u5df2\u7ecf\u5b58\u5728\u3002","language_save":"\u8bed\u8a00\u4fdd\u5b58\u6210\u529f\u3002","last_name_required":"\u59d3\u6c0f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","last_week":"\u4e0a\u5468","login_via_facebook":"\u901a\u8fc7\u8138\u4e66\u767b\u5165","login_via_google":"\u901a\u8fc7\u8c37\u6b4c\u767b\u5f55","message_sent":"\u6d88\u606f\u53d1\u9001\u6210\u529f.","multi_templates":"\u9700\u8981\u591a\u4e2a\u6a21\u677f","paid_appointment_cant_delete":"\u4ed8\u8d39\u9884\u7ea6\u65e0\u6cd5\u5220\u9664","password_character":"\u5bc6\u7801\u5fc5\u987b\u81f3\u5c11\u4e3a 8 \u4e2a\u5b57\u7b26\u3002","password_invalid":"\u5bc6\u7801\u65e0\u6548","password_is_correct":"\u5bc6\u7801\u6b63\u786e","password_must_match":"\u5bc6\u7801\u548c\u5bc6\u7801\u786e\u8ba4\u5fc5\u987b\u5339\u914d\u3002","passwords":"\u5bc6\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","payment_cancel":"\u60a8\u7684\u4ed8\u6b3e\u5df2\u53d6\u6d88","payment_done":"\u4ed8\u6b3e\u6210\u529f\u5b8c\u6210\u3002","payment_not_complete":"\u4ed8\u6b3e\u672a\u5b8c\u6210","payment_received":"\u4ed8\u6b3e\u6210\u529f\u6536\u5230\u3002","paypal_created":"Paypal \u4f1a\u8bdd\u521b\u5efa\u6210\u529f\u3002","paypal_key":"\u8d1d\u5b9d\u952e\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","paypal_mode":"Paypal \u6a21\u5f0f\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","paypal_secret":"\u8d1d\u5b9d\u5bc6\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","phone_number_required":"\u7535\u8bdd\u53f7\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","plan_already_used":"\u8ba1\u5212\u5df2\u5728\u4f7f\u7528","plan_expire_notification":"\u8ba1\u5212\u5230\u671f\u901a\u77e5\u5b57\u6bb5\u662f\u5fc5\u586b\u9879\u3002","please_add_payment_credentials":"\u8bf7\u6dfb\u52a0\u4ed8\u6b3e\u51ed\u636e","privacy_policy":"\u9690\u79c1\u653f\u7b56\u662f\u5fc5\u9700\u7684\u3002","product_purchase":"\u4ea7\u54c1\u8d2d\u4e70\u6210\u529f\u3002","purchased_plan":"\u60a8\u6210\u529f\u8d2d\u4e70\u4e86\u6b64\u8ba1\u5212\u3002","receive_latest_news":"\u6bcf\u5468\u63a5\u6536\u6700\u65b0\u6d88\u606f\u3001\u66f4\u65b0\u548c\u8bb8\u591a\u5176\u4ed6\u5185\u5bb9\u3002","registered_success":"\u60a8\u5df2\u6ce8\u518c\u6210\u529f\uff0c\u8bf7\u901a\u8fc7\u90ae\u4ef6\u6fc0\u6d3b\u60a8\u7684\u5e10\u6237\u3002","required_captcha":"\u8bf7\u9a8c\u8bc1\u9a8c\u8bc1\u7801","role_created":"\u89d2\u8272\u521b\u5efa\u6210\u529f\u3002","select_hour":"\u8bf7\u9009\u62e9\u65e5\u671f\u6216\u65f6\u95f4","select_one_or_more":"\u9009\u62e9\u4e00\u9879\u6216\u591a\u9879\u529f\u80fd\u662f\u5fc5\u9700\u7684","short_code_only_alpha":"\u77ed\u4ee3\u7801\u53ea\u80fd\u662f\u5b57\u6bcd\u3002","stripe_created":"Stripe \u4f1a\u8bdd\u521b\u5efa\u6210\u529f\u3002","stripe_key":"\u6761\u5e26\u952e\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","stripe_secret":"\u6761\u5e26\u673a\u5bc6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","subscribed_plan":"\u60a8\u5df2\u6210\u529f\u8ba2\u9605\u6b64\u8ba1\u5212\u3002","subscribed_plan_wait":"\u60a8\u5df2\u6210\u529f\u8ba2\u9605\u6b64\u8ba1\u5212\uff0c\u4f46\u7b49\u5f85\u7ba1\u7406\u5458\u786e\u8ba4","subscribed_successfully":"\u8ba2\u9605\u6210\u529f.","subscription_date_updated":"\u8ba2\u9605\u65e5\u671f\u5df2\u6210\u529f\u66f4\u65b0\u3002","successful":"\u6210\u529f\u7684","successfully_verified":"\u60a8\u5df2\u6210\u529f\u9a8c\u8bc1\u60a8\u7684\u90ae\u4ef6\uff0c\u8bf7\u767b\u5f55\u3002","the_term_conditions":"\u6761\u6b3e\u548c\u6761\u4ef6\u662f\u5fc5\u9700\u7684\u3002","there_is_not_available_slot":"\u7ed9\u5b9a\u65e5\u671f\u6ca1\u6709\u7a7a\u4f4d","this_currency_is_not_supported":"PayPal \u4e0d\u652f\u6301\u4f7f\u7528\u6b64\u8d27\u5e01\u8fdb\u884c\u4ed8\u6b3e\u3002","this_week":"\u672c\u661f\u671f","time_format":"\u65f6\u95f4\u683c\u5f0f","too_long":"\u592a\u957f","too_short":"\u592a\u77ed","unable_to_process_payment":"\u76ee\u524d\u65e0\u6cd5\u5904\u7406\u4ed8\u6b3e\u3002\u7a0d\u540e\u518d\u8bd5\u3002","upload_required":"\u6587\u4ef6\u4e0a\u4f20\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","valid_number":"\u6709\u6548\u53f7\u7801","we_could_not_fb_id":"\u6211\u4eec\u5728\u60a8\u7684 Facebook \u5e10\u6237\u4e2d\u627e\u4e0d\u5230\u7535\u5b50\u90ae\u4ef6\u5730\u5740","withdrawal_request_send":"\u63d0\u6b3e\u7533\u8bf7 \u6210\u529f\u83b7\u6279\u3002","your_mail_already_verified":"\u60a8\u7684\u90ae\u4ef6\u5df2\u7ecf\u8fc7\u9a8c\u8bc1\uff0c\u8bf7\u767b\u5f55\u3002"},"plan":{"We'll_never_share_your_email_with_anyone_else":"\u6211\u4eec\u7edd\u4e0d\u4f1a\u4e0e\u5176\u4ed6\u4eba\u5206\u4eab\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u3002","additional_domains":"\u9644\u52a0\u57df","affiliation":"\u96b6\u5c5e\u5173\u7cfb","analytics":"\u5206\u6790","blog":"\u535a\u5ba2","currency":"\u8ca8\u5e63","custom_css":"\u81ea\u5b9a\u7fa9 CSS","custom_fields":"\u81ea\u5b9a\u7fa9\u5b57\u6bb5","custom_js":"\u81ea\u5b9a\u7fa9 JS","days":"\u5929","default_Plan":"\u9ed8\u8a8d\u8a08\u5283","description":"\u63cf\u8ff0","domains_limit":"\u57df\u9650\u5236","duration":"\u671f\u9593","duration_months":"\u6301\u7e8c\u6642\u9593\u6708","duration_years":"\u6301\u7e8c\u6642\u9593\u5e74","edit_plan":"\u7de8\u8f2f\u8a08\u5283","email_address":"\u7535\u5b50\u90ae\u4ef6\u5730\u5740","enquiry_form":"\u67e5\u8a62\u8868\u683c","features":"\u7279\u5fb5","frequency":"\u983b\u7387","gallery":"\u756b\u5eca","hide_branding":"\u96b1\u85cf\u54c1\u724c","is_trial":"\u6b63\u5728\u8a66\u7528","make_default":"\u4f7f\u9ed8\u8a8d","monthly":"\u6708\u520a","months":"\u5e7e\u500b\u6708","multi_templates":"\u591a\u6a21\u677f","new_plan":"\u65b0\u8a08\u5283","no_of_vcards":"\u96fb\u5b50\u540d\u7247\u6578\u91cf","password_protection":"\u5bc6\u78bc\u4fdd\u8b77","plan":"\u8a08\u5283","plan_type":"\u8a08\u5283\u985e\u578b","portfolio":"\u6587\u4ef6\u593e","price":"\u50f9\u683c","products":"\u7522\u54c1","products_&_services":"\u7522\u54c1\u8207\u670d\u52d9","qrcode":"\u4e8c\u7dad\u78bc","remaining_balance":"\u4e0a\u4e00\u4e2a\u8ba1\u5212\u7684\u4f59\u989d","select_all_feature":"\u9078\u64c7\u6240\u6709\u529f\u80fd","select_plan":"\u9009\u62e9\u65b9\u6848","sendemail":"\u53d1\u7535\u5b50\u90ae\u4ef6","sendinvite":"\u53d1\u9001\u9080\u8bf7","seo":"\u641c\u7d22\u5f15\u64ce\u512a\u5316","services":"\u670d\u52d9","testimonials":"\u611f\u8a00","total_custom_domains_limit":"\u81ea\u5b9a\u7fa9\u57df\u7e3d\u6578\u9650\u5236","trial_days":"\u8a66\u7528\u5929\u6578","unlimited":"\u7121\u9650","valid_upto":"\u6709\u6548Upto","what_s_in_startup_plan":"\u542f\u52a8\u8ba1\u5212\u4e2d\u6709\u4ec0\u4e48\uff1f","yearly":"\u6bcf\u5e74","years":"\u5e74"},"plan_expire":"\u8a08\u5283\u5df2\u904e\u671f\u3002\u8acb\u9078\u64c7\u4e00\u500b\u8a08\u5283\u4ee5\u7e7c\u7e8c\u670d\u52d9\u3002","plan_expire_notification":"\u8a08\u5283\u5230\u671f\u901a\u77e5\uff08\u4ee5\u5929\u70ba\u55ae\u4f4d\uff09","plans":"\u8a08\u5283","please_contact_your_admin":"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u65b0\u5bc6\u7801\u3002 ","product_details":"\u4ea7\u54c1\u8ba2\u5355\u8be6\u60c5","product_orders":"\u4ea7\u54c1\u8ba2\u5355","resend_verification_email":"\u91cd\u65b0\u767c\u9001\u9a57\u8b49\u96fb\u5b50\u90f5\u4ef6","reset_password":"\u91cd\u8a2d\u5bc6\u78bc","role":{"edit_role":"\u7de8\u8f2f\u89d2\u8272","name":"\u540d\u7a31","new_role":"\u65b0\u89d2\u8272","permissions":"\u6b0a\u9650","role_permissions":"\u89d2\u8272\u6b0a\u9650","select_all_permissions":"\u9078\u64c7\u6240\u6709\u6b0a\u9650"},"roles":"\u89d2\u8272","sadmin_dashboard":{"contact":"\u806f\u7e6b\u65b9\u5f0f","day":"\u65e5","email":"\u96fb\u5b50\u90f5\u4ef6","income":"\u6536\u5165","month":"\u6708","name":"\u540d\u7a31","plans_by_users":"\u7528\u6237\u8ba1\u5212","recent_users_registration":"\u6700\u8fd1\u7528\u6236\u8a3b\u518a","registered_on":"\u8a3b\u518a\u6642\u9593","week":"\u661f\u671f"},"save":"Save","select_payment_type":"\u9078\u64c7\u652f\u4ed8\u7db2\u95dc","services":"\u670d\u52d9","setting":{"add_contact":"\u6dfb\u52a0\u8054\u7cfb\u4eba","address":"\u5730\u5740","affiliation_amount":"\u52a0\u76df\u91d1\u989d","affiliation_withdraw":"\u4ece\u5c5e\u5173\u7cfb\u64a4\u56de","app_logo":"\u61c9\u7528\u7a0b\u5e8f\u5fbd\u6a19","app_name":"\u61c9\u7528\u540d\u7a31","clinic_name":"\u8a3a\u6240\u540d\u7a31","contact_information":"\u806f\u7e6b\u4fe1\u606f","credentials":"\u8bc1\u4e66","currency":"\u8ca8\u5e63","currency_settings":"\u8ca8\u5e63\u8a2d\u7f6e","default_currency_format":"\u9ed8\u8ba4\u8d27\u5e01\u683c\u5f0f","default_language":"\u9ed8\u8ba4\u8bed\u8a00","disable_landing_page":"\u7981\u7528\u767b\u9646\u9875\u9762","enable_addcontact":"\u542f\u7528\u6dfb\u52a0\u5230\u8054\u7cfb\u4eba","enable_affiliation":"\u542f\u7528\u4ece\u5c5e\u5173\u7cfb","enable_contact":"\u542f\u7528\u8054\u7cfb","favicon":"\u7db2\u7ad9\u5716\u6a19","front_page_enable":"\u9996\u9875\u542f\u7528","general":"\u4e00\u822c\u7684","general_details":"\u4e00\u822c\u7d30\u7bc0","hide_stickybar":"\u9690\u85cf vCard \u7c98\u6ede\u680f","location_url":"\u4f4d\u7f6e\u7db2\u5740","manually":"\u624b\u52a8","note":"\u6ce8\u610f\uff1a\u4e0a\u4f20\u7684\u56fe\u6807\u540d\u79f0\u5e94\u4e3a\u201cWeChat.png\u201d\/\u201cTumbler.png\u201d\/\u201cXXX.png\u201d\uff0c\u4e0b\u8f7d.vcf\u6587\u4ef6\u65f6\u8be5\u540d\u79f0\u5c06\u7528\u4f5c\u6807\u7b7e\u3002","paypal":"\u8d1d\u5b9d","paypal_client_id":"\u8d1d\u5b9d\u5ba2\u6237\u7aef ID","paypal_key":"\u8d1d\u5b9d\u94a5\u5319","paypal_mode":"\u8d1d\u5b9d\u6a21\u5f0f","paypal_payout_email":"Paypal \u4ed8\u6b3e\u7535\u5b50\u90ae\u4ef6","paypal_secret":"\u8d1d\u5b9d\u79d8\u5bc6","postal_code":"\u90f5\u653f\u7de8\u78bc","prefix":"\u5b57\u9996","razorpay":"\u5243\u987b\u5200\u652f\u4ed8","razorpay_key":"Razorpay \u94a5\u5319","razorpay_secret":"Razorpay \u79d8\u5bc6","select_currency":"\u9009\u62e9\u8d27\u5e01","setting":"\u74b0\u5883","shipping_address":"\u6536\u4ef6\u5730\u5740","specialities":"\u7279\u7522","stripe":"\u6761\u7eb9","stripe_key":"\u6761\u7eb9\u952e","stripe_secret":"\u6761\u7eb9\u79d8\u5bc6","upgrade_database":"\u5347\u7ea7\u6570\u636e\u5e93","user_default_language":"\u7528\u6237\u9ed8\u8ba4\u8bed\u8a00","whatsapp_share":"WhatsApp \u5206\u4eab","withdraw_transactions":"\u64a4\u56de\u4ea4\u6613","withdrawals":"\u63d0\u6b3e","wp_number":"\u8f93\u5165\u7535\u8bdd\u53f7\u7801"},"settings":"\u8a2d\u7f6e","sign_out":"\u767b\u51fa","social":{"Facebook":"Facebook","Instagram":"Instagram","Linkedin":"\u9818\u82f1","Pinterest":"Pinterest","Reddit":"\u7d05\u8fea\u7db2","Share_on_email":"\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u5206\u4eab","Share_on_facebook":"\u5728\u8138\u4e66\u4e0a\u5206\u4eab","Share_on_linkedin":"\u5728 LinkedIn \u4e0a\u5206\u4eab","Share_on_pinterest":"\u5728 Pinterest \u4e0a\u5206\u4eab","Share_on_reddit":"\u5728 Reddit \u4e0a\u5206\u4eab","Share_on_twitter":"\u5206\u4eab\u5230Twitter","Share_on_whatsapp":"\u5206\u4eab\u5230 Whatsapp","Tiktok":"\u6296\u97f3","Tumblr":"\u68d2\u68d2\u5660","Twitter":"\u63a8\u7279","Whatsapp":"Whatsapp","Youtube":"Youtube","map":"\u5730\u5716","social_links":"\u793e\u4ea4\u94fe\u63a5 - \u7f51\u7ad9","website":"\u7db2\u7ad9"},"state":{"country_name":"\u570b\u5bb6\u7684\u540d\u5b57","edit_state":"\u7de8\u8f2f\u72c0\u614b","new_state":"\u65b0\u5dde","no_state_available":"\u7121\u53ef\u7528\u72c0\u614b","no_state_found":"\u672a\u627e\u5230\u72c0\u614b","state":"\u72c0\u614b","state_name":"\u5dde\u540d","states":"\u72c0\u614b"},"subscribe":"\u8ba2\u9605","subscribed_plans":"\u8ba2\u9605\u8ba1\u5212","subscribed_user":"\u8ba2\u9605\u7684\u7528\u6237\u8ba1\u5212","subscriber":"\u8ba2\u6237","subscription":{"active_until":"\u6d3b\u52d5\u81f3","active_until_unlimited":"\u6d3b\u52d5\u81f3\u7121\u9650","amount":"\u6578\u91cf","buy_now":"\u7acb\u5373\u8d2d\u4e70","buy_product":"\u8d2d\u4e70\u4ea7\u54c1","cancel_subscription":"\u53d6\u6d88\u8a02\u95b1","choose_plan":"\u9009\u62e9\u8ba1\u5212","current_expire":"\u7576\u524d\u904e\u671f\u8a08\u5283","current_plan":"\u7576\u524d\u8a08\u5283","currently_active":"\u76ee\u524d\u6d3b\u8e8d","end_date":"\u7d50\u675f\u65e5\u671f","end_date_required":"\u7ed3\u675f\u65e5\u671f\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","expired":"\u8a08\u5283\u5df2\u904e\u671f","expired_date":"\u904e\u671f\u65e5\u671f","free":"\u81ea\u7531","has_already_been_subscribed":"\u5df2\u8a02\u95b1","has_been_subscribed":"\u5df2\u8a02\u95b1","history":"\u8a02\u95b1\u6b77\u53f2","manage_subscription":"\u7ba1\u7406\u8a02\u95b1","no_plan_available":"\u6c92\u6709\u53ef\u7528\u7684\u8a08\u5283","pay_or_switch_plan":"\u4ed8\u8cbb\/\u5207\u63db\u8a08\u5283","payable_amount":"\u61c9\u4ed8\u91d1\u984d","payment":"\u652f\u4ed8","plan_name":"\u8a08\u5283\u540d\u7a31","plan_price":"\u8a08\u5283\u50f9\u683c","proceed_to_payment":"\u7e7c\u7e8c\u4ed8\u6b3e","purchase":"\u8cfc\u8cb7","remaining":"\u5176\u9918\u7684","remaining_balance":"\u4fdd\u6301\u5e73\u8861","remaining_days":"\u5269\u4f59\u5929\u6578","renew_free_plan":"\u514d\u8cbb\u8a08\u5283\u7121\u6cd5\u7e8c\u8a02\/\u518d\u6b21\u9078\u64c7","renew_plan":"\u7e8c\u8a02\u8a08\u5283","start_date":"\u958b\u59cb\u65e5\u671f","subscribed_date":"\u8a02\u95b1\u65e5\u671f","subscribed_plan_details":"\u8ba2\u9605\u8ba1\u5212\u8be6\u60c5","switch_plan":"\u5207\u63db\u8a08\u5283","total_days":"\u7e3d\u5929\u6578","trial_plan":"\u8a66\u7528\u8a08\u5283","upgrade_plan":"\u5347\u7d1a\u8a08\u5283","used_balance":"\u7528\u904e\u7684\u9918\u984d","used_days":"\u4f7f\u7528\u5929\u6578"},"subscriptions":"\u8a02\u95b1","testimonial":"\u611f\u8a00","to_time":"\u5230\u6642\u9593","tooltip":{"about_description":"\u6700\u591a\u5141\u8a31 500 \u500b\u5b57\u7b26","about_title":"\u6700\u591a\u5141\u8a31 100 \u500b\u5b57\u7b26","allowed_image":"\u5141\u8a31\u7684\u6587\u4ef6\u985e\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","app_logo":"\u5716\u50cf\u5fc5\u9808\u70ba 90 x 60 \u50cf\u7d20","banner_title":"\u6700\u591a\u5141\u8a31 34 \u500b\u5b57\u7b26","cancel_app_logo":"\u53d6\u6d88\u61c9\u7528\u5fbd\u6a19","cancel_cover":"\u53d6\u6d88\u5c01\u9762","cancel_favicon_logo":"\u53d6\u6d88\u7db2\u7ad9\u5716\u6a19","cancel_image":"\u53d6\u6d88\u56fe\u7247","cancel_profile":"\u53d6\u6d88\u500b\u4eba\u8cc7\u6599","change_app_logo":"\u66f4\u6539\u61c9\u7528\u7a0b\u5e8f\u5fbd\u6a19","change_favicon_logo":"\u66f4\u6539\u7db2\u7ad9\u5716\u6a19","change_icon":"\u66f4\u6539\u56fe\u6807","copy":"\u8907\u88fd\u5230\u526a\u8cbc\u677f","cover":"\u66f4\u63db\u5c01\u9762","custom_css":"\u555f\u7528\u70ba\u6bcf\u500b VCard \u6dfb\u52a0\u81ea\u5b9a\u7fa9 CSS \u7684\u529f\u80fd\u3002","custom_fonts":"\u555f\u7528\u70ba\u6bcf\u500b VCard \u6dfb\u52a0\u81ea\u5b9a\u7fa9\u5b57\u9ad4\u7684\u529f\u80fd.","custom_js":"\u555f\u7528\u70ba\u6bcf\u500b VCard \u6dfb\u52a0\u81ea\u5b9a\u7fa9 js \u7684\u529f\u80fd.","dark_mode":"\u5207\u63db\u5230\u6df1\u8272\u6a21\u5f0f","enable_affiliation":"\u901a\u8fc7\u542f\u7528\u6b64\u529f\u80fd\uff0c\u4ece\u5c5e\u5173\u7cfb\u94fe\u63a5\u5c06\u5bf9\u60a8\u7684\u6240\u6709 vcards \u53ef\u89c1","enable_contact":"\u542f\u7528\u6b64\u529f\u80fd\u540e\uff0c\u8054\u7cfb\u65b9\u5f0f\u8be6\u7ec6\u4fe1\u606f\u5c06\u663e\u793a\u5728\u60a8\u7684\u6240\u6709\u7535\u5b50\u540d\u7247\u4e0a ","favicon_logo":"\u5716\u50cf\u5fc5\u9808\u70ba 16 x 16 \u50cf\u7d20","hide_branding":"\u555f\u7528\u5c0d VCard \u96b1\u85cf\u54c1\u724c\u7684\u80fd\u529b\u3002","hide_stickybar":"\u901a\u8fc7\u542f\u7528\u6b64\u529f\u80fd\uff0c\u53ef\u4ee5\u9690\u85cf\u6240\u6709 Vcard \u4e0a\u7684 Vcard \u7c98\u6ede\u6309\u94ae","home_image":"\u6b64\u914d\u7f6e\u6587\u4ef6\u7684\u6700\u4f73\u5206\u8fa8\u7387\u70ba","image":"\u66f4\u6539\u56fe\u50cf","light_mode":"\u5207\u63db\u5230\u71c8\u5149\u6a21\u5f0f","password_protection":"\u555f\u7528\u5c0d\u5bc6\u78bc\u4fdd\u8b77 VCard \u7684\u8a2a\u554f.","product_image":"\u6b64\u914d\u7f6e\u6587\u4ef6\u7684\u6700\u4f73\u5206\u8fa8\u7387\u70ba 250x250","profile":"\u66f4\u6539\u914d\u7f6e\u6587\u4ef6","remove_branding":"\u5982\u679c\u555f\u7528\uff0c\u96fb\u5b50\u540d\u7247\u5c07\u4e0d\u6703\u986f\u793a\u6211\u5011\u7db2\u7ad9\u7684\u54c1\u724c\u3002","script":"\u6dfb\u52a0\u4e0d\u5e36\u8173\u672c\u6a19\u7c64\u7684\u81ea\u5b9a\u7fa9 JS \u4ee3\u78bc","sub_text":"\u6700\u591a\u5141\u8a31 60 \u500b\u5b57\u7b26","the_main_url":"\u53ef\u4ee5\u5f9e\u4e2d\u8a2a\u554f\u60a8\u7684 vcard \u7684\u4e3b\u8981 URL\u3002","whatsapp_share":"\u542f\u7528\u6b64\u529f\u80fd\u540e\uff0cWhatsApp \u5206\u4eab\u6309\u94ae\u5c06\u5728\u60a8\u7684\u6240\u6709 VCard \u4e0a\u53ef\u89c1"},"type_in_script":"\u5728 <script><\/script> \u6807\u7b7e\u5185\u8f93\u5165 js \u4ee3\u7801","user":{"account":"\u5e33\u6236","account_setting":"\u5e33\u865f\u8a2d\u5b9a","add_admin":"\u6dfb\u52a0\u7ba1\u7406\u5458","add_user":"\u6dfb\u52a0\u7528\u6236","admin_details":"\u7ba1\u7406\u5458\u8be6\u60c5","avatar":"\u963f\u51e1\u9054","change_language":"\u6539\u8b8a\u8a9e\u8a00","change_password":"\u66f4\u6539\u5bc6\u78bc","confirm_password":"\u78ba\u8a8d\u5bc6\u78bc","contact_no":"\u806f\u7e6b\u65b9\u5f0f","contact_number":"\u806f\u7e6b\u96fb\u8a71","current_password":"\u7576\u524d\u5bc6\u78bc","edit_user":"\u7de8\u8f2f\u7528\u6236","email":"\u96fb\u5b50\u90f5\u4ef6","email_verified":"\u96fb\u5b50\u90f5\u4ef6\u5df2\u9a57\u8b49","female":"\u5973\u6027","first_name":"\u540d","full_name":"\u5168\u540d","impersonate":"\u6a21\u4eff","last_name":"\u59d3","location":"\u5730\u9ede","male":"\u7537\u6027","new_password":"\u65b0\u5bc6\u78bc","overview":"\u6982\u8ff0","password":"\u5bc6\u78bc","phone":"\u96fb\u8a71","profile":"\u8f2a\u5ed3","profile_details":"\u500b\u4eba\u8cc7\u6599\u8a73\u60c5","registered_date":"\u8a3b\u518a\u65e5\u671f","return_to_admin":"\u8fd4\u56de\u7ba1\u7406\u54e1","save_changes":"\u4fdd\u5b58\u66f4\u6539","setting":"\u74b0\u5883","theme_change":"\u4e3b\u984c\u6a21\u5f0f\u66f4\u6539","user_details":"\u7528\u6236\u8a73\u60c5","your_message":"\u60a8\u7684\u7559\u8a00","your_name":"\u4f60\u7684\u540d\u5b57"},"users":"\u7528\u6236","vcard":{"add_blog":"\u6dfb\u52a0\u535a\u5ba2","add_gallery":"\u6dfb\u52a0\u753b\u5eca","add_product":"\u6dfb\u52a0\u7522\u54c1","add_service":"\u6dfb\u52a0\u670d\u52d9","add_testimonial":"\u6dfb\u52a0\u63a8\u85a6","advanced":"\u5148\u9032\u7684","affiliate_user":"\u9644\u5c5e\u7528\u6237","alter_email_address":"\u5907\u7528\u7535\u5b50\u90ae\u4ef6\u5730\u5740","alter_mobile_number":"\u5907\u7528\u624b\u673a\u53f7\u7801","alternate_email":"\u5907\u7528\u7535\u5b50\u90ae\u4ef6","alternative_phone":"\u5907\u7528\u7535\u8bdd","appointments":"\u7d04\u6703","back_color":"\u80cc\u666f\u989c\u8272","basic_details":"\u57fa\u672c\u7d30\u7bc0s","blog_details":"\u535a\u5ba2\u8be6\u60c5","blog_icon":"\u535a\u5ba2\u56fe\u6807","blogs":"\u535a\u5ba2","buisness_hours":"\u71df\u696d\u6642\u9593","business-hours":"\u71df\u696d\u6642\u9593","business_hours":"\u71df\u696d\u6642\u9593","company":"\u516c\u53f8","contact":"\u63a5\u89e6","copy_referral_link":"\u590d\u5236\u63a8\u8350\u94fe\u63a5","cover_image":"\u5c01\u9762\u5716\u7247","created_at":"\u5275\u5efa\u65bc","created_on":"\u5275\u5efa\u65bc","custom-fonts":"\u5b57\u9ad4","custom_css":"\u81ea\u5b9a\u7fa9 CSS","custom_fonts":"\u5b57\u9ad4","custom_js":"\u81ea\u5b9a\u7fa9 JS","date_of_birth":"\u51fa\u751f\u65e5\u671f","description":"\u63cf\u8ff0","display_share_button":"\u986f\u793a\u5206\u4eab\u6309\u9215","dob":"\u51fa\u751f\u65e5\u671f","download_my_qr_code":"\u4e0b\u8f09\u6211\u7684\u4e8c\u7dad\u78bc","download_vcard":"\u4e0b\u8f09\u96fb\u5b50\u540d\u7247","duplicate_vcard":"\u91cd\u590d\u7684 Vcard\uff01","edit_blog":"\u7f16\u8f91\u535a\u5ba2","edit_gallery":"\u7f16\u8f91\u753b\u5eca","edit_product":"\u7de8\u8f2f\u7522\u54c1","edit_service":"\u7de8\u8f2f\u670d\u52d9","edit_testimonial":"\u7de8\u8f2f\u63a8\u85a6","edit_vcard":"\u7de8\u8f2f\u96fb\u5b50\u540d\u7247","email_address":"\u96fb\u5b50\u90f5\u4ef6\u5730\u5740","enable_download_qr_code":"\u542f\u7528\u4e0b\u8f7d\u4e8c\u7ef4\u7801","enable_enquiry_form":"\u6fc0\u6d3b\u7533\u8bf7\u8868","enter_password":"\u8f38\u5165\u5bc6\u78bc","first_name":"\u540d","flag":"\u65d7\u5e1c","galleries":"\u753b\u5eca","gallery":"\u753b\u5eca","google_analytics":"\u8c37\u6b4c\u5206\u6790","google_config":"\u8c37\u6b4c\u914d\u7f6e","header":"\u6807\u5934","home_title":"\u4e3b\u9801\u6a19\u984c","image":"\u5716\u7247","is_manual_payment":"\u624b\u52a8\u652f\u4ed8\u6307\u5357\u662f\u5426\u5f00\u542f","job_title":"\u8077\u7a31","language_enable":"\u542f\u7528\u8bed\u8a00","last_name":"\u59d3","last_updated":"\u6700\u8fd1\u66f4\u65b0\u65f6\u95f4","location":"\u5730\u9ede","manage-section":"\u7ba1\u7406\u90e8\u5206","manual_payment_guide":"\u624b\u52a8\u652f\u4ed8\u6307\u5357","map":"\u5730\u56fe","meta_description":"\u5143\u63cf\u8ff0","meta_keyword":"\u5143\u95dc\u9375\u5b57","mobile_number":"\u624b\u6a5f\u865f\u78bc","new_blog":"\u65b0\u535a\u5ba2","new_gallery":"\u65b0\u753b\u5eca","new_product":"\u65b0\u7522\u54c1","new_service":"\u65b0\u670d\u52d9","new_testimonial":"\u65b0\u8b49\u8a00","new_vcard":"\u65b0\u96fb\u5b50\u540d\u7247","occupation":"\u8077\u696d","order_at":"\u8ba2\u8d2d\u4e8e","our_service":"\u6211\u4eec\u7684\u670d\u52a1","payment_config":"\u652f\u4ed8\u914d\u7f6e","preview_url":"\u9810\u89bd\u7db2\u5740","privacy_policy":"\u9690\u79c1\u653f\u7b56","product":"\u7522\u54c1","product_details":"\u7522\u54c1\u8a73\u60c5","product_icon":"\u7522\u54c1\u5716\u6a19","product_name":"\u4ea7\u54c1\u540d\u79f0","product_transection":"\u4ea7\u54c1\u4ea4\u6613","products":"\u7522\u54c1","profile_image":"\u500b\u4eba\u8cc7\u6599\u5716\u7247","qr_code":"\u4e8c\u7dad\u78bc","qr_code_download_size":"\u4e8c\u7ef4\u7801\u4e0b\u8f7d\u5927\u5c0f","qrcode-customize":"\u81ea\u5b9a\u4e49\u4e8c\u7ef4\u7801","qrcode_color":"\u4e8c\u7ef4\u7801\u989c\u8272","qrcode_customize":"\u81ea\u5b9a\u4e49\u4e8c\u7ef4\u7801","qrcode_eye_style":"\u9009\u62e9\u773c\u578b","qrcode_style":"\u9009\u62e9\u98ce\u683c","remove_branding":"\u522a\u9664\u54c1\u724c","select_template":"\u9078\u64c7\u6a21\u677f","send_message":"\u767c\u4fe1\u606f","seo":"\u641c\u7d22\u5f15\u64ce\u512a\u5316","service_details":"\u670d\u52d9\u8a73\u60c5","service_icon":"\u670d\u52d9\u5716\u6a19","services":"\u670d\u52d9","share":"\u5206\u4eab","share_my_vcard":"\u5206\u4eab\u6211\u7684\u96fb\u5b50\u540d\u7247","show_qr_code":"\u663e\u793a\u4e8c\u7ef4\u7801","site_title":"\u7db2\u7ad9\u6a19\u984c","social-links":"\u793e\u4ea4\u93c8\u63a5","social_links":"\u793e\u4ea4\u93c8\u63a5","stats":"\u7d71\u8a08\u6578\u64da","status":"\u5730\u4f4d","template":"\u540d\u7247\u6a21\u677f","templates":"\u540d\u7247\u6a21\u677f","term-condition":"\u6761\u6b3e\u548c\u6761\u4ef6","term-policy":"\u6761\u6b3e\u548c\u653f\u7b56","term_condition":"\u6761\u6b3e\u548c\u6761\u4ef6","term_policy":"\u6761\u6b3e\u548c\u653f\u7b56","testimonial":"\u898b\u8b49","testimonial_details":"\u63a8\u85a6\u7d30\u7bc0","testimonials":"\u611f\u8a00","theme_config":"\u4e3b\u9898\u914d\u7f6e","url_alias":"\u5225\u540d\u7db2\u5740","user":"\u7528\u6237","user_name":"\u7528\u6236\u540d","vcard":"\u96fb\u5b50\u540d\u7247","vcard_details":"\u540d\u7247\u8a73\u60c5","vcard_is_active":"\u96fb\u5b50\u540d\u7247\u8655\u65bc\u6d3b\u52d5\u72c0\u614b","vcard_name":"\u540d\u7247\u540d\u7a31","vcard_service":"\u540d\u7247\u670d\u52d9"},"vcard_11":{"Latest_post":"\u6700\u65b0\u5e16\u5b50","contact_detail":"\u8054\u7cfb\u65b9\u5f0f","get_in_touch":"\u4fdd\u6301\u8054\u7cfb","my_email":"\u6211\u7684\u7535\u5b50\u90ae\u4ef6","my_phones":"\u6211\u7684\u624b\u673a","provide_service":"\u63d0\u4f9b\u670d\u52a1","read_more":"\u9605\u8bfb\u66f4\u591a"},"vcards":"\u96fb\u5b50\u540d\u7247","vcards_template":{"image":"Image","used_count":"\u4f7f\u7528\u6b21\u6578"},"vcards_templates":"\u540d\u7247\u6a21\u677f","virtual_backgrounds":"\u865a\u62df\u80cc\u666f","wait_for_apporove_of_cash_payment_by_admin":"\u60a8\u7684\u624b\u52a8\u4ea4\u6613\u8bf7\u6c42\u6b63\u5728\u7b49\u5f85\u5904\u7406\u3002","weekdays":{"fri":"\u5468\u4e94","mon":"\u661f\u671f\u4e00","sat":"\u661f\u671f\u516d","sun":"\u592a\u9633","thu":"\u5468\u56db","tue":"\u5468\u4e8c","wed":"\u661f\u671f\u4e09"},"your":"\u60a8\u7684"},"zh.pagination":{"next":"\u4e0b\u4e00\u500b\u201c","previous":"&laquo;\u4ee5\u524d\u7684"},"zh.passwords":{"reset":"\u60a8\u7684\u5bc6\u78bc\u5df2\u91cd\u7f6e\uff01","sent":"\u6211\u5011\u5df2\u5c07\u60a8\u7684\u5bc6\u78bc\u91cd\u7f6e\u93c8\u63a5\u901a\u904e\u96fb\u5b50\u90f5\u4ef6\u767c\u9001\u7d66\u60a8\uff01","throttled":"\u8acb\u7a0d\u5019\u518d\u91cd\u8a66\u3002","token":"\u6b64\u5bc6\u78bc\u91cd\u7f6e\u4ee4\u724c\u7121\u6548\u3002","user":"\u6211\u5011\u627e\u4e0d\u5230\u5177\u6709\u8a72\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\u7684\u7528\u6236."},"zh.validation":{"accepted":"\u9019 :attribute \u5fc5\u9808\u63a5\u53d7.","active_url":"\u9019 :attribute \u4e0d\u662f\u6709\u6548\u7684 URL.","after":"\u9019 :attribute \u5fc5\u9808\u662f :date \u4e4b\u5f8c\u7684\u65e5\u671f.","after_or_equal":"\u9019 :attribute \u5fc5\u9808\u662f :date \u4e4b\u5f8c\u6216\u7b49\u65bc\u7684\u65e5\u671f.","alpha":"\u9019 :attribute \u53ea\u80fd\u5305\u542b\u5b57\u6bcd.","alpha_dash":"\u9019 :attribute \u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6578\u5b57\u3001\u7834\u6298\u865f\u548c\u4e0b\u5283\u7dda.","alpha_num":"\u9019 :attribute \u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u548c\u6578\u5b57.","array":"\u9019attribute \u5fc5\u9808\u662f\u4e00\u500b\u6578\u7d44.","attributes":{"email":"\u7535\u5b50\u90ae\u4ef6","message":"\u6d88\u606f","name":"\u540d\u5b57","phone":"\u7535\u8bdd","service_url":"Service URL"},"before":"\u9019 :attribute \u5fc5\u9808\u662f :date \u4e4b\u524d\u7684\u65e5\u671f.","before_or_equal":"\u9019 :attribute \u5fc5\u9808\u662f\u65e9\u65bc\u6216\u7b49\u65bc :date \u7684\u65e5\u671f.","between":{"array":"\u9019 :attribute \u5fc5\u9808\u5728 :min \u548c :max \u4e4b\u9593\u7684\u9805\u76ee.","file":"\u9019 :attribute \u5fc5\u9808\u4ecb\u65bc :min \u548c :max \u5343\u5b57\u7bc0\u4e4b\u9593.","numeric":"\u9019 :attribute \u5fc5\u9808\u4ecb\u65bc :min \u548c :max \u4e4b\u9593\u3002","string":"\u9019 :attribute \u5fc5\u9808\u4ecb\u65bc :min \u548c :max \u5b57\u7b26\u4e4b\u9593."},"boolean":"\u9019 :attribute \u5b57\u6bb5\u5fc5\u9808\u70ba\u771f\u6216\u5047.","confirmed":"\u9019 :attribute \u78ba\u8a8d\u4e0d\u5339\u914d.","current_password":"\u5bc6\u78bc\u4e0d\u6b63\u78ba.","custom":{"attribute-name":{"rule-name":"\u81ea\u5b9a\u7fa9\u6d88\u606f"}},"date":"\u9019 :attribute \u4e0d\u662f\u6709\u6548\u65e5\u671f.","date_equals":"\u9019 :attribute \u5fc5\u9808\u662f\u7b49\u65bc :date \u7684\u65e5\u671f.","date_format":"\u9019 :attribute \u8207\u683c\u5f0f\u4e0d\u5339\u914d :format.","different":"\u9019 :attribute \u548c :other \u5fc5\u9808\u4e0d\u540c.","digits":"\u9019 :attribute \u5fc5\u9808\u662f :digits \u6578\u5b57.","digits_between":"\u9019 :attribute \u5fc5\u9808\u4ecb\u65bc :min \u548c :max \u6578\u5b57\u4e4b\u9593.","dimensions":"\u9019 :attribute \u5716\u7247\u5c3a\u5bf8\u7121\u6548.","distinct":"\u9019 :attribute \u5b57\u6bb5\u5177\u6709\u91cd\u8907\u503c.","email":"\u9019 :attribute \u5fc5\u9808\u662f\u4e00\u500b\u6709\u6548\u7684E-mail\u5730\u5740.","ends_with":"\u9019 :attribute \u5fc5\u9808\u4ee5\u4e0b\u5217\u4e4b\u4e00\u7d50\u5c3e: :values.","exists":"\u9019 \u9078\u64c7 :attribute \u662f\u7121\u6548\u7684.","file":"\u9019 :attribute \u5fc5\u9808\u662f\u6587\u4ef6.","filled":"\u9019 :attribute \u5b57\u6bb5\u5fc5\u9808\u6709\u503c.","gt":{"array":"\u9019 :attribute \u5fc5\u9808\u6709\u8d85\u904e :value \u9805.","file":"\u9019 :attribute \u5fc5\u9808\u5927\u65bc :value \u5343\u5b57\u7bc0.","numeric":"\u9019 :attribute \u5fc5\u9808\u5927\u65bc :value.","string":"\u9019 :attribute \u5fc5\u9808\u5927\u65bc :value \u5b57\u7b26\u3002"},"gte":{"array":"\u9019 :attribute \u5fc5\u9808\u6709 :value \u9805\u6216\u66f4\u591a.","file":"\u9019 :attribute \u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc :value \u5343\u5b57\u7bc0\u3002","numeric":"\u9019 :attribute \u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc :value\u3002","string":"\u9019 :attribute \u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc :value \u5b57\u7b26."},"image":"\u9019 :attribute \u5fc5\u9808\u662f\u5716\u50cf.","in":"\u9019 \u9078\u64c7 :attribute \u662f\u7121\u6548\u7684.","in_array":"\u9019 :attribute \u5b57\u6bb5\u4e0d\u5b58\u5728\u65bc :other.","integer":"\u9019 :attribute \u5fc5\u9808\u662f\u6574\u6578.","ip":"\u9019 :attribute \u5fc5\u9808\u662f\u6709\u6548\u7684 IP \u5730\u5740.","ipv4":"\u9019 :attribute \u5fc5\u9808\u662f\u6709\u6548\u7684 IPv4 \u5730\u5740.","ipv6":"\u9019 :attribute \u5fc5\u9808\u662f\u6709\u6548\u7684 IPv6 \u5730\u5740.","json":"\u9019 :attribute \u5fc5\u9808\u662f\u6709\u6548\u7684 JSON \u5b57\u7b26\u4e32.","lt":{"array":"\u9019 :attribute \u5fc5\u9808\u5c11\u65bc :value \u9805.","file":"\u9019 :attribute \u5fc5\u9808\u5c0f\u65bc :value \u5343\u5b57\u7bc0.","numeric":"\u9019 :attribute \u5fc5\u9808\u5c0f\u65bc :value.","string":"\u9019 :attribute \u5fc5\u9808\u5c0f\u65bc :value \u500b\u5b57\u7b26."},"lte":{"array":"\u9019 :attribute \u4e0d\u5f97\u8d85\u904e :value \u9805.","file":"\u9019 :attribute \u5fc5\u9808\u5c0f\u65bc\u6216\u7b49\u65bc :value \u5343\u5b57\u7bc0.","numeric":"\u9019 :attribute \u5fc5\u9808\u5c0f\u65bc\u6216\u7b49\u65bc :value.","string":"\u9019 :attribute \u5fc5\u9808\u5c0f\u65bc\u6216\u7b49\u65bc :value \u500b\u5b57\u7b26."},"max":{"array":"\u9019 :attribute \u4e0d\u5f97\u8d85\u904e :max \u500b\u9805\u76ee.","file":"\u9019 :attribute \u4e0d\u5f97\u5927\u65bc :max \u5343\u5b57\u7bc0.","numeric":"\u9019 :attribute \u4e0d\u5f97\u5927\u65bc :max.","string":"\u9019 :attribute \u4e0d\u5f97\u5927\u65bc :max \u500b\u5b57\u7b26."},"mimes":"\u9019 :attribute \u5fc5\u9808\u662f\u6587\u4ef6\u985e\u578b: :values.","mimetypes":"\u9019 :attribute \u5fc5\u9808\u662f\u6587\u4ef6\u985e\u578b: :values.","min":{"array":"\u9019 :attribute \u5fc5\u9808\u81f3\u5c11\u6709 :min \u500b\u9805\u76ee.","file":"\u9019 :attribute \u5fc5\u9808\u81f3\u5c11\u70ba :min \u5343\u5b57\u7bc0.","numeric":"\u9019 :attribute \u5fc5\u9808\u81f3\u5c11\u70ba :min.","string":"\u9019 :attribute \u5fc5\u9808\u81f3\u5c11\u70ba :min \u500b\u5b57\u7b26."},"multiple_of":"\u9019 :attribute \u5fc5\u9808\u662f :value \u7684\u500d\u6578.","not_in":"\u9019 \u9078\u64c7 :attribute \u662f\u7121\u6548\u7684.","not_regex":"\u9019 :attribute \u683c\u5f0f\u7121\u6548.","numeric":"\u9019 :attribute \u5fc5\u9808\u662f\u6578\u5b57.","password":"\u5bc6\u78bc\u4e0d\u6b63\u78ba.","present":"\u9019 :attribute \u5b57\u6bb5\u5fc5\u9808\u5b58\u5728.","prohibited":"\u9019 :attribute \u5b57\u6bb5\u88ab\u7981\u6b62\u3002","prohibited_if":"\u9019 :attribute \u7576 :other \u70ba :value \u6642\uff0c\u5b57\u6bb5\u88ab\u7981\u6b62.","prohibited_unless":"\u9019 :attribute \u9664\u975e :other \u5728 :values \u4e2d\uff0c\u5426\u5247\u7981\u6b62\u5b57\u6bb5.","regex":"\u9019 :attribute \u683c\u5f0f\u7121\u6548.","required":"\u9019 :attribute \u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","required_if":"\u9019 :attribute \u7576 :other \u70ba :value \u6642\uff0c\u8a72\u5b57\u6bb5\u662f\u5fc5\u9700\u7684.","required_unless":"\u9019 :attribute \u9664\u975e :other \u5728 :values \u4e2d\uff0c\u5426\u5247\u5b57\u6bb5\u662f\u5fc5\u9700\u7684.","required_with":"\u9019 :attribute \u5b58\u5728 :values \u6642\u9700\u8981\u5b57\u6bb5.","required_with_all":"\u9019 :attribute \u7576 :values \u5b58\u5728\u6642\uff0c\u5b57\u6bb5\u662f\u5fc5\u9700\u7684.","required_without":"\u9019 :attribute \u7576 :values \u4e0d\u5b58\u5728\u6642\uff0c\u8a72\u5b57\u6bb5\u662f\u5fc5\u9700\u7684.","required_without_all":"\u9019 :attribute \u7576\u6c92\u6709 :values \u6642\uff0c\u5b57\u6bb5\u662f\u5fc5\u9700\u7684.","same":"\u9019 :attribute \u548c :other \u5fc5\u9808\u5339\u914d.","size":{"array":"\u9019 :attribute \u5fc5\u9808\u5305\u542b :size \u9805\u76ee.","file":"\u9019 :attribute \u5fc5\u9808\u662f :size \u5343\u5b57\u7bc0.","numeric":"\u9019 :attribute \u5fc5\u9808\u662f\uff1a\u5927\u5c0f.","string":"\u9019 :attribute \u5fc5\u9808\u662f :size \u500b\u5b57\u7b26\u3002"},"starts_with":"\u9019 :attribute \u5fc5\u9808\u4ee5\u4e0b\u5217\u4e4b\u4e00\u958b\u982d\uff1a :values.","string":"\u9019 :attribute \u5fc5\u9808\u662f\u5b57\u7b26\u4e32.","timezone":"\u9019 :attribute \u5fc5\u9808\u662f\u6709\u6548\u7684\u6642\u5340.","unique":"\u9019 :attribute \u5df2\u6709\u4eba\u5e36\u8d70\u4e86.","uploaded":"\u9019 :attribute \u4e0a\u50b3\u5931\u6557.","url":"\u9019 :attribute \u5fc5\u9808\u662f\u6709\u6548\u7684 URL\u3002","uuid":"\u9019 :attribute \u5fc5\u9808\u662f\u6709\u6548\u7684 UUID\u3002"}});
})();
