@component('mail::layout')
    {{-- Header --}}
    @slot('header')
        @component('mail::header', ['url' => config('app.url')])
            <img src="{{ getLogoUrl() }}" class="logo" alt="{{ getAppName() }}" style="height:auto!important;width:auto!important;object-fit:cover">
        @endcomponent
    @endslot

    {{-- Body --}}
        # {{ __('messages.mail.hello') }} {{ $user->first_name . ' ' . $user->last_name }}

        {{ __('We have received your payment successfully.') }}

        {{ __('Transaction ID:') }} {{ $user->transaction_id }}
        {{ __('Amount Paid:') }} ${{ $amount }}
        {{ __('Subscription Plan:') }} {{ $subscription->plan->name }}

        {{ __('Thank you for your payment and continued trust in') }} {{ getAppName() }}.
        {{ __('If you have any questions, feel free to contact us.') }}


    {{-- Footer --}}
    @slot('footer')
        @component('mail::footer')
            <h6>© {{ date('Y') }} {{ getAppName() }}.</h6>
        @endcomponent
    @endslot
@endcomponent
