<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subscription Notification</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="margin-bottom: 20px;">
        <h2 style="color: #333; margin-bottom: 10px;">Hello {{ $user->first_name }} {{ $user->last_name }},</h2>
    </div>

    <div style="margin-bottom: 20px;">
        @if($isExpired)
            <p>Your subscription has expired.</p>
        @else
            <p>Your subscription will expire in {{ $daysRemaining }} days.</p>
        @endif
    </div>

    <div style="margin-bottom: 20px; background-color: #f9f9f9; padding: 15px; border-radius: 5px;">
        <p style="margin: 5px 0;"><strong>Plan Name:</strong> {{ $subscription->plan->name }}</p>
        <p style="margin: 5px 0;"><strong>Expired Date:</strong> {{ \Carbon\Carbon::parse($expirationDate)->format('dS M, Y') }}</p>
        @if(!$isExpired)
            <p style="margin: 5px 0;"><strong>Remaining Days:</strong> {{ $daysRemaining }} days</p>
        @endif
    </div>

    <div style="margin: 30px 0; text-align: center;">
        <a href="{{ route('subscription.upgrade') }}" style="display: inline-block; background-color: #007bff; color: #ffffff; padding: 12px 30px; text-decoration: none; border-radius: 5px; font-weight: bold;">Click here to upgrade</a>
    </div>

    <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; color: #666; font-size: 14px;">
        <p>Thank you for using {{ getAppName() }}.</p>
    </div>
</body>
</html>
