<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="title" content="{{ getAppName() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>404 - Page Not Found | {{ getAppName() }}</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Inter', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #fff;
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        @keyframes float {
            0% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
            100% { transform: translateY(0); }
        }
        .brand-font {
            font-family: 'Pacifico', cursive;
        }
    </style>
</head>
<body>

<div class="container my-5">
    <div class="row align-items-center gy-5">
        <!-- Text Column -->
        <div class="col-md-6 text-center text-md-start">
            <h1 class="display-1 fw-bold text-primary">404</h1>
            <h2 class="h3 text-secondary mb-3">Oops! Page Not Found</h2>
            <p class="text-muted mb-4">The page you're looking for doesn't exist or may have been moved.</p>
            <a href="https://www.ebizcard.me" class="btn btn-primary shadow-sm">
                <i class="ri-home-line mr-2"></i>Back to Home
            </a>
        </div>

        <!-- Image Column -->
        <div class="col-md-6">
            <div class="animate-float">
                <img
                    src="https://readdy.ai/api/search-image?query=3D%20illustration%20of%20a%20lost%20business%20card%20character%20with%20a%20confused%20expression%2C%20searching%20with%20a%20magnifying%20glass%2C%20stylized%20with%20blue%20color%20scheme%2C%20clean%20minimal%20design%2C%20friendly%20character%20with%20big%20eyes%2C%20isolated%20on%20white%20background%2C%20high%20quality%203D%20rendering%2C%20centered%20composition%2C%20the%20character%20should%20take%20up%2070%25%20of%20the%20frame&width=500&height=500&seq=404illustration&orientation=squarish"
                    alt="404 Illustration"
                    class="img-fluid rounded-4 shadow"
                >
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
