@extends('front.layouts.app')
@section('title')
{{ getAppName() }}
@endsection
@section('content')
<!-- Hero Section -->
<section class="w-full relative pt-40 pb-32 overflow-hidden bg-gradient-to-br from-[#F8FBFF] via-white to-[#F0F7FF] min-h-[90vh]">
    <div class="absolute right-0 top-0 w-2/3 h-full">
        <div class="absolute inset-0 bg-[url('{{ isset($setting['home_page_banner']) ? $setting['home_page_banner'] : asset('assets/img/new_front/hero-img.png') }}')] bg-cover bg-center opacity-95"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-[#F8FBFF] via-[#F8FBFF]/80 to-transparent"></div>
    </div>
    <div class="absolute -top-1/2 -left-1/2 w-full h-full bg-gradient-radial from-primary/5 to-transparent rounded-full blur-3xl"></div>
    <div class="container mx-auto px-4 relative">
        <div class="flex flex-col md:flex-row items-center">
            <div class="w-full md:w-1/2 mb-10 md:mb-0 z-10 relative">
                <div class="absolute -top-20 -left-20 w-40 h-40 bg-primary/5 rounded-full blur-2xl"></div>
                <div class="absolute -bottom-20 -right-20 w-40 h-40 bg-primary/5 rounded-full blur-2xl"></div>
                <span class="inline-block px-4 py-2 bg-primary/10 text-primary rounded-full text-sm font-medium mb-6">The Future of Networking</span>
                <h1 class="text-5xl md:text-7xl font-bold mb-8 leading-tight bg-clip-text text-transparent bg-gradient-to-r from-secondary via-secondary to-primary">{{ $setting['home_page_title'] }}</h1>
                <p class="text-xl text-gray-600 mb-10 max-w-lg leading-relaxed"> {{ $setting['sub_text'] ?? '' }}</p>
                <div class="flex flex-col sm:flex-row gap-6">
                    @if (empty(getLogInUser()))
                        <a href="{{ config('app.url') }}/admin/choose-payment-type/1"
                           onclick="pauseAndRedirect(event)"
                           class="px-8 py-4 bg-primary text-white rounded-button text-lg font-medium text-center hover:bg-primary/90 transition-colors whitespace-nowrap !rounded-button shadow-lg shadow-primary/20 hover:shadow-xl hover:shadow-primary/30 transform hover:-translate-y-0.5">
                            Get Started Free
                        </a>
                    @endif
                    <a href="javascript:void(0)" onclick="openModal()" class="px-8 py-4 bg-white border-2 border-gray-200 rounded-button text-gray-700 flex items-center justify-center hover:border-primary hover:text-primary transition-colors whitespace-nowrap group">
    <span class="w-6 h-6 flex items-center justify-center mr-2 bg-primary/10 rounded-full group-hover:bg-primary/20">
        <i class="ri-play-fill text-primary"></i>
    </span>
    <span class="text-lg font-medium">Watch Demo</span>
</a>
             <div id="videoModal" class="fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center z-50 hidden"
     onclick="handleOutsideClick(event)">
    <div class="relative bg-white rounded-xl overflow-hidden w-full max-w-3xl" id="videoModalContent">
        <!-- Close Button -->
        <button onclick="closeModal()" class="absolute top-2 right-2 text-white text-2xl z-10">&times;</button>

        <!-- Video -->
        <video id="videoElement" width="100%" controls>
            <source src="{{ config('app.url') }}/uploads/profile/output.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
    </div>
</div>

                </div>
                <div class="flex items-center mt-12 space-x-8">
                    <div class="flex -space-x-3">
                        <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200"></div>
                        <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200"></div>
                        <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200"></div>
                        <div class="w-10 h-10 rounded-full border-2 border-white bg-primary flex items-center justify-center text-white text-sm">99+</div>
                    </div>
                    <div class="text-gray-600">
                        <span class="font-semibold text-gray-800">4.9/5</span> from over 10,000+ users
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- end hero section -->

<!-- start features section -->
<section id="features" class="py-20 bg-[#F8FBFF]">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">Powerful Features</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">Everything you need to create, share, and manage your digital business identity.</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Feature 1 -->
            <?php $i = 0; ?>
            @foreach ($features as $feature)
            <?php
            $class = '';
            if ($i == 0) {
                $class = 'ri-nfc-line';
            } elseif ($i == 1) {
                $class = 'ri-dashboard-line';
            } elseif ($i == 2) {
                $class = 'ri-layout-4-line';
            } elseif ($i == 3) {
                $class = 'ri-line-chart-line';
            }
            ?>
            <div class="feature-card bg-white p-8 rounded-lg shadow-sm hover:shadow-lg transition-all duration-300">
                <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mb-6 mx-auto">
                    <i class="{{ $class ?? '' }} text-primary ri-xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-secondary mb-3 text-center">{{ $feature->name }}</h3>
                <p class="text-gray-600 text-center">{{ $feature->description }}</p>
            </div>
            <?php $i++; ?>
            @endforeach

        </div>
    </div>
</section>


<!-- end features section -->

<!-- How It Works Section -->

<section id="enterprise-how-work" class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">
                How It Works
            </h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Get started with ebizcard in three simple steps.
            </p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-4xl mx-auto">
            <!-- Step 1 -->
            <div class="text-center">
                <div class="w-16 h-16 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-bold mb-6 mx-auto">
                    1
                </div>
                <h3 class="text-xl font-semibold text-secondary mb-3">
                    Sign Up
                </h3>
                <p class="text-gray-600">
                    Create your account in seconds and access your dashboard.
                </p>
                <div class="mt-8 rounded-lg overflow-hidden shadow-sm">
                    <img src="https://readdy.ai/api/search-image?query=A%20professional%20person%20signing%20up%20on%20a%20laptop%20with%20a%20modern%20interface%20showing%20a%20business%20card%20creation%20platform.%20The%20scene%20features%20soft%20lighting%2C%20clean%20desk%20setup%20with%20minimal%20accessories%2C%20and%20a%20focused%20expression.%20The%20interface%20is%20modern%20and%20user-friendly%20with%20a%20signup%20form%20visible.%20High-quality%20professional%20photography%20with%20attention%20to%20detail&width=400&height=300&seq=signup1&orientation=landscape"
                    alt="Sign Up Process" class="w-full h-48 object-cover object-top">
                </div>
            </div>
            <!-- Step 2 -->
            <div class="text-center relative">
                <div class="hidden md:block absolute top-8 left-0 right-0 h-0.5 bg-gray-200">
                    <div class="absolute left-0 top-0 bottom-0 bg-primary" style="width: 50%;">
                    </div>
                </div>
                <div class="w-16 h-16 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-bold mb-6 mx-auto relative z-10">
                    2
                </div>
                <h3 class="text-xl font-semibold text-secondary mb-3">
                    Customize Card
                </h3>
                <p class="text-gray-600">
                    Add your info, links, and branding to make it uniquely yours.
                </p>
                <div class="mt-8 rounded-lg overflow-hidden shadow-sm">
                    <img src="https://readdy.ai/api/search-image?query=A%20person%20customizing%20a%20digital%20business%20card%20on%20a%20modern%20computer%20screen.%20The%20interface%20shows%20a%20sleek%20business%20card%20template%20being%20edited%20with%20drag%20and%20drop%20elements%2C%20color%20customization%2C%20and%20profile%20information.%20The%20scene%20has%20warm%20lighting%20and%20shows%20hands%20typing%20on%20a%20keyboard.%20Professional%20photography%20with%20clean%20composition&width=400&height=300&seq=customize1&orientation=landscape"
                    alt="Customize Card" class="w-full h-48 object-cover object-top">
                </div>
            </div>
            <!-- Step 3 -->
            <div class="text-center">
                <div class="w-16 h-16 bg-primary text-white rounded-full flex items-center justify-center text-2xl font-bold mb-6 mx-auto">
                    3
                </div>
                <h3 class="text-xl font-semibold text-secondary mb-3">
                    Share Instantly
                </h3>
                <p class="text-gray-600">
                    Share via NFC tap, QR code, or digital link. Connect anywhere.
                </p>
                <div class="mt-8 rounded-lg overflow-hidden shadow-sm">
                    <img src="https://readdy.ai/api/search-image?query=Two%20business%20professionals%20exchanging%20contact%20information%20using%20NFC-enabled%20phones%2C%20with%20one%20phone%20displaying%20a%20digital%20business%20card%20and%20the%20other%20showing%20a%20successful%20connection%20animation.%20The%20scene%20shows%20a%20modern%20office%20environment%20with%20natural%20lighting%20and%20professional%20attire.%20High-quality%20professional%20photography%20with%20soft%20focus%20background&width=400&height=300&seq=share1&orientation=landscape"
                    alt="Share Instantly" class="w-full h-48 object-cover object-top">
                </div>
            </div>
        </div>
    </div>
</section>


<!-- start pricing section -->
<section id="pricing" class="py-20 bg-gradient-to-b from-[#F8FBFF] to-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">Simple, Transparent Pricing</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto"> {{ __("auth.choose_a_plan_that's_right_for_you") }}</p>
            <!--<div class="flex items-center justify-center mt-8">-->
            <!--    <span class="mr-3 text-gray-700">Yearly</span>-->
            <!--    <label class="custom-switch">-->
            <!--        <input type="checkbox" checked disabled>-->
            <!--        <span class="switch-slider"></span>-->
            <!--    </label>-->
            <!--    <span class="ml-3 text-gray-700">Best Values</span>-->
            <!--</div>-->
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-5xl mx-auto">
            <!-- Free Plan -->
            <?php $j = 0; ?>
            @foreach ($plans as $plan)
            <?php
            if ($j == 0) {
                $ulhtml = '<ul class="space-y-3 mb-8">
                        <li class="flex items-start">
                            <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                                <i class="ri-check-line"></i>
                            </span>
                            <span class="text-gray-600">1 Digital Business Card</span>
                        </li>
                        <li class="flex items-start">
                            <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                                <i class="ri-check-line"></i>
                            </span>
                            <span class="text-gray-600">Basic Templates</span>
                        </li>
                        <li class="flex items-start">
                            <span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
                                <i class="ri-check-line"></i>
                            </span>
                            <span class="text-gray-600">QR Code Sharing</span>
                        </li>
                        <li class="flex items-start">
                            <span class="w-5 h-5 flex items-center justify-center text-gray-400 mr-2 mt-0.5">
                                <i class="ri-close-line"></i>
                            </span>
                            <span class="text-gray-400">No NFC Card</span>
                        </li>
                        <li class="flex items-start">
                            <span class="w-5 h-5 flex items-center justify-center text-gray-400 mr-2 mt-0.5">
                                <i class="ri-close-line"></i>
                            </span>
                            <span class="text-gray-400">No Analytics</span>
                        </li>
                    </ul>';
            } elseif ($j == 1) {
                $ulhtml = '<ul class="space-y-3 mb-8">
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">Unlimited Digital Cards</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">All Premium Templates</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">QR Code Sharing</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">Advanced Analytics</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">Physical NFC Card</span>
</li>
</ul>';
            } elseif ($j == 2) {
                $ulhtml = '<ul class="space-y-3 mb-8">
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">Unlimited Digital Cards</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">All Premium Templates</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">QR Code Sharing</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-primary mr-2 mt-0.5">
<i class="ri-check-line"></i>
</span>
<span class="text-gray-600">Advanced Analytics</span>
</li>
<li class="flex items-start">
<span class="w-5 h-5 flex items-center justify-center text-gray-400 mr-2 mt-0.5">
<i class="ri-close-line"></i>
</span>
<span class="text-gray-400">No Physical NFC Card</span>
</li>
</ul>';
            }
            ?>
            <div class="bg-white rounded-lg shadow-sm hover:shadow-lg transition-all duration-300 border border-gray-200">
                @if ($plan->name == 'Digital + NFC Card')
                <div class="bg-white rounded-lg shadow-md hover:shadow-lg transition-all duration-300 border-2 border-primary relative transform scale-105">
                <div class="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-primary text-white px-4 py-1 rounded-full text-sm font-medium select-none">
                  Most Popular
                </div>
                @endif
                <div class="p-8">
                    <h3 class="text-xl font-semibold text-secondary mb-2">{!! $plan->name !!}</h3>
                    <div class="flex items-end mb-6">
                        <span class="text-4xl font-bold text-secondary">{{ $plan->currency->currency_icon }}{{($plan->price) }}</span>
                        @if ($plan->frequency == 1)
                        <span class="text-gray-500 ml-1">/ {{ __('messages.plan.monthly') }}</span>
                        @elseif($plan->frequency == 2)
                        <span class="text-gray-500 ml-1">/ {{ __('messages.plan.yearly') }}</span>
                        @endif

                    </div>


                    {!! $ulhtml !!}

                    @if (getLoggedInUserRoleId() != getSuperAdminRoleId())
                    @if (getLogInUser() && getLoggedInUserRoleId() != getSuperAdminRoleId())
                    <div class="mx-auto">

                        @if (
                        !empty(getCurrentSubscription()) &&
                        $plan->id == getCurrentSubscription()->plan_id &&
                        !getCurrentSubscription()->isExpired())
                        @if ($plan->price != 0)
                        <button type="button"
                            class="btn btn-success rounded-pill mx-auto d-block cursor-remove-plan pricing-plan-button-active"
                            data-id="{{ $plan->id }}" data-turbo="false">
                            {{ __('messages.subscription.currently_active') }}</button>
                        @else
                        <button type="button"
                            class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                            data-turbo="false">
                            {{ __('messages.subscription.renew_free_plan') }}
                        </button>
                        @endif
                        @else
                        @if (
                        !empty(getCurrentSubscription()) &&
                        !getCurrentSubscription()->isExpired() &&
                        ($plan->price == 0 || $plan->price != 0))
                        @if ($plan->hasZeroPlan->count() == 0)
                        <a href="{{ $plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                            class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button" {{ $plan->price == 0 ? 'freePayment' : '' }}"
                            data-id="{{ $plan->id }}"
                            data-plan-price="{{ $plan->price }}" data-turbo="false">
                            {{ __('messages.subscription.switch_plan') }}</a>
                        @else
                        <button type="button"
                            class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                            data-turbo="false">
                            {{ __('messages.subscription.renew_free_plan') }}
                        </button>
                        @endif
                        @else
                        @if ($plan->hasZeroPlan->count() == 0)
                        <a href="{{ $plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                            class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button{{ $plan->price == 0 ? 'freePayment' : '' }}"
                            data-id="{{ $plan->id }}"
                            data-plan-price="{{ $plan->price }}" data-turbo="false">
                            {{ __('messages.subscription.choose_plan') }}</a>
                        @else
                        <button type="button"
                            class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                            data-turbo="false">
                            {{ __('messages.subscription.renew_free_plan') }}
                        </button>
                        @endif
                        @endif
                        @endif
                    </div>
                    @else
                    <div class="mx-auto">
                        @if ($plan->hasZeroPlan->count() == 0)
                        <a href="{{ $plan->price != 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                            class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button{{ $plan->price == 0 ? 'freePayment' : '' }}"
                            data-id="{{ $plan->id }}" data-plan-price="{{ $plan->price }}"
                            data-turbo="false">
                            {{ __('messages.subscription.choose_plan') }}</a>
                        @else
                        <!--  <button type="button"
                            class="text-xl text-gray-700 hover:text-primary transition-colors py-2 border-b border-gray-100"
                            data-turbo="false">
                            {{ __('messages.subscription.renew_free_plan') }}
                        </button> -->
                        <a href="{{ $plan->price == 0 ? route('choose.payment.type', $plan->id) : 'javascript:void(0)' }}"
                            class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button{{ $plan->price == 0 ? 'freePayment' : '' }}"
                            data-id="{{ $plan->id }}" data-plan-price="{{ $plan->price }}"
                            data-turbo="false">
                            {{ __('messages.subscription.choose_plan') }}</a>
                        @endif
                    </div>
                    @endif
                    @endif
                    <!--  <a href="#get-started" class="w-full px-6 py-3 border border-primary text-primary rounded-button text-center block hover:bg-primary hover:text-white transition-colors whitespace-nowrap !rounded-button">Start Free</a> -->
                </div>
            </div>
            @if ($plan->name == 'Digital + NFC Card')
            </div> {{-- Close the border-2 highlight wrapper --}}
            @endif
            
            <?php $j++; ?>
            @endforeach
            <!-- Digital + NFC Plan -->

        </div>
    </div>
</section>


<!-- Enterprise Solutions Section -->
<section id="enterprise" class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary mb-4">Enterprise Solutions</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">Powerful tools for managing your organization's digital business cards at scale.</p>
        </div>
        <div class="flex flex-col md:flex-row items-center gap-12">
            <div class="w-full md:w-1/2">
                <div class="space-y-8">
                    <!-- Bulk User Management -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-team-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">Bulk User Management</h3>
                            <p class="text-gray-600">Easily create and manage digital business cards for your entire team. Import user data in bulk and set up cards instantly.</p>
                        </div>
                    </div>
                    <!-- HR Dashboard -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-dashboard-3-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">HR Dashboard</h3>
                            <p class="text-gray-600">Centralized control panel for managing employee digital identities. Track usage, monitor engagement, and manage permissions.</p>
                        </div>
                    </div>
                    <!-- Quota Control -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-settings-3-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">Quota Control</h3>
                            <p class="text-gray-600">Set and manage usage limits across departments and teams. Allocate resources efficiently and maintain control over enterprise usage.</p>
                        </div>
                    </div>
                    <!-- Team-wide Branding -->
                    <div class="flex items-start">
                        <div class="w-14 h-14 bg-primary/10 rounded-full flex items-center justify-center mr-6 shrink-0">
                            <i class="ri-paint-brush-line text-primary ri-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-secondary mb-2">Team-wide Branding</h3>
                            <p class="text-gray-600">Maintain consistent brand identity across all employee cards. Apply company-wide templates and enforce brand guidelines effortlessly.</p>
                        </div>
                    </div>
                    <div class="mt-12">
                        <a href="javascript:void(0)" onclick="openContactModal()"
                           class="px-8 py-4 bg-white border-2 border-primary text-primary rounded-button text-lg font-medium hover:bg-primary hover:text-white transition-colors inline-flex items-center whitespace-nowrap !rounded-button">
                            <i class="ri-customer-service-2-line mr-2"></i>
                            Contact Sales
                        </a>
                    </div>
                </div>
            </div>
            <div class="w-full md:w-1/2">
                <img src="https://readdy.ai/api/search-image?query=A%20modern%20enterprise%20dashboard%20interface%20showing%20business%20card%20management%20system%20with%20analytics%20graphs%2C%20user%20management%20panel%2C%20and%20branding%20controls.%20The%20interface%20is%20clean%20and%20professional%20with%20a%20light%20color%20scheme.%20The%20scene%20shows%20multiple%20cards%20being%20managed%20simultaneously%20with%20team%20collaboration%20features%20visible.%20High%20quality%203D%20rendering%20with%20attention%20to%20detail%20and%20modern%20UI%2FUX%20design%20principles&width=600&height=600&seq=enterprise1&orientation=squarish" alt="Enterprise Dashboard" class="w-full h-auto rounded-lg shadow-lg">
            </div>
        </div>
    </div>
</section>
<!-- Testimonials Section -->
@if (!$testimonials->isEmpty())
<section id="enterprise" class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="py-12">
            <p class="text-center text-2xl font-medium text-black mb-8">Trusted by teams at</p>
            <div class="flex flex-wrap justify-center items-center gap-8 md:gap-16">
                @foreach ($testimonials as $testimonial)
                <div class="w-32 h-12 flex items-center justify-center grayscale opacity-70 hover:grayscale-0 hover:opacity-100 transition-all">
                    <img src="{{ $testimonial->testimonial_url }}" alt="Overleap logo" class="h-8">
                </div>
                @endforeach

            </div>
        </div>
    </div>
</section>
@endif
<!-- end pricing section -->


<!-- CTA Section -->
<section class="py-20 bg-primary text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-6">Ready to Upgrade Your Networking?</h2>
        <p class="text-lg text-white/80 max-w-2xl mx-auto mb-10">Join thousands of professionals who are making meaningful connections with ebizcard.</p>
        @if (empty(getLogInUser()))
            <a href="{{ config('app.url') }}/admin/choose-payment-type/1"
               onclick="pauseAndRedirect(event)"
               class="px-8 py-4 bg-white text-primary rounded-button text-lg font-medium hover:bg-gray-100 transition-colors inline-block whitespace-nowrap !rounded-button">
                Get Started Free
            </a>
            <p class="mt-6 text-white/70">
                No credit card required. 30-day free trial.
            </p>
        @endif
    </div>
</section>
<!-- end contact section -->

<!-- Contact Sales Modal -->
<div id="contactSalesModal" class="fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-xl p-8 w-full max-w-md relative shadow-lg">
        <!-- Close Button -->
        <button onclick="closeContactModal()" class="absolute top-3 right-3 text-black text-2xl font-bold">&times;</button>

        <h3 class="text-2xl font-semibold text-secondary mb-6 text-center">Contact Sales</h3>

        <div class="space-y-6 text-gray-700 text-base">
            <!-- Cambodia Contact -->
            <div>
                <span class="font-medium block mb-1">Cambodia:</span>
                <div class="flex items-center justify-between">
                    <span>+855 96 443 6883</span>
                    <div class="flex gap-3 text-xl">
                        <a href="https://t.me/+855964436883" target="_blank" title="Telegram" class="text-primary hover:text-secondary">
                            <i class="ri-telegram-line"></i>
                        </a>
                        <a href="https://wa.me/855964436883" target="_blank" title="WhatsApp" class="text-green-600 hover:text-green-800">
                            <i class="ri-whatsapp-line"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Sri Lanka Contact -->
            <div>
                <span class="font-medium block mb-1">Sri Lanka:</span>
                <div class="flex items-center justify-between">
                    <span>+94 777 567 776</span>
                    <div class="flex gap-3 text-xl">
                        <a href="https://t.me/+94777567776" target="_blank" title="Telegram" class="text-primary hover:text-secondary">
                            <i class="ri-telegram-line"></i>
                        </a>
                        <a href="https://wa.me/94777567776" target="_blank" title="WhatsApp" class="text-green-600 hover:text-green-800">
                            <i class="ri-whatsapp-line"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Email Contact -->
            <div>
                <span class="font-medium block mb-1">Email:</span>
                <a href="mailto:corporate@ebizcard.me" class="text-primary hover:underline">
                    corporate@ebizcard.me
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
<script>
function openContactModal() {
    // Only open when called by a user event
    if (typeof event === 'undefined' || !event.isTrusted) return;

    document.getElementById('contactSalesModal').classList.remove('hidden');
}

function closeContactModal() {
    document.getElementById('contactSalesModal').classList.add('hidden');
}
function pauseAndRedirect(event) {

    const video = document.getElementById('videoElement');
    const modal = document.getElementById('videoModal');

    if (video && !video.paused) {
        video.pause();
        video.currentTime = 0;
    }

    if (modal) {
        modal.classList.add('hidden');
    }

    // Now redirect after small delay to ensure pause applies
    setTimeout(() => {
        window.location.href = event.currentTarget.href;
    }, 0); // 0ms delay is usually enough
}

function openModal() {
    const modal = document.getElementById('videoModal');
    const video = document.getElementById('videoElement');

    modal.classList.remove('hidden');

    if (video) {
        video.currentTime = 0;
        video.play().catch(err => {
            console.warn("Autoplay blocked:", err);
        });
    }
}

function closeModal() {
    const modal = document.getElementById('videoModal');
    const video = document.getElementById('videoElement');
    video.pause();
    video.currentTime = 0;
    modal.classList.add('hidden');
}

function handleOutsideClick(event) {
    const modalContent = document.getElementById('videoModalContent');
    if (!modalContent.contains(event.target)) {
        closeModal();
    }
}
</script>