@php
    use App\Models\Transaction;
    use App\Models\Plan;
    use App\Models\User;
    use Carbon\Carbon;

    $transactionIdFormatted = 'N/A';

    if ($subscription->transaction_id) {
        $transaction = Transaction::where('transaction_id', $subscription->transaction_id)->first();
        $plan = Plan::find($subscription->plan_id);

        if ($transaction && $plan) {
            $prefix = $plan->plan_type == 2 ? 'ODR' : 'ODR-C'; // 2 = Regular, 1 = Corporate
            $date = Carbon::parse($transaction->created_at)->format('Y-m-d');
            $transactionIdFormatted = "{$prefix}-{$date}-{$transaction->id}";
        }
    }

    // Get user's currency preference and set symbol
    $user = User::where('tenant_id', $subscription->tenant_id)->first();
    $currencyPreference = $user->currency_preference ?? 'default';
    // Use 'Rs.' for LKR in PDF as most PDF renderers don't support Sinhala Unicode
    $currencySymbol = ($currencyPreference === 'LKR') ? 'LKR' : '$';
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice #{{ $transactionIdFormatted }}</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 14px;
            padding: 20px;
        }
        h2 {
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
        }
        th {
            background-color: #f3f3f3;
            text-align: left;
        }
        .label {
            font-weight: bold;
            width: 200px;
        }
    </style>
</head>
<body>
    <div style="text-align: center;">
        <img src="{{ public_path('images/logo.png') }}" alt="Logo" height="80">
    </div>
    <h2>Invoice</h2>

    <table>
    	<tr>
            <th class="label">Invoice ID</th>
            <td>#{{ $transactionIdFormatted}}</td>
        </tr>
        <tr>
            <th class="label">Transaction ID</th>
            <td>
                {{ $subscription->transaction_id ? '#' . $subscription->transaction_id : 'N/A' }}
            </td>
        </tr>
        <tr>
            <th class="label">Plan Name</th>
            <td>{{ $subscription->plan->name ?? '-' }}</td>
        </tr>
        <tr>
            <th class="label">Paid Amount</th>
            <td>{{ $currencySymbol }} {{ number_format($subscription->payable_amount ?? 0, 2) }}</td>
        </tr>
        <tr>
            <th class="label">Expired Date</th>
            <td>{{ \Carbon\Carbon::parse($subscription->ends_at)->format('d M Y') }}</td>
        </tr>
        <tr>
            <th class="label">Status</th>
            <td>{{ $subscription->status == 1 ? 'Active' : 'Closed' }}</td>
        </tr>
    </table>
</body>
</html>

