<header class='d-flex align-items-center justify-content-between flex-grow-1 header px-3 px-xl-0'>
    <button type="button" class="btn px-0 aside-menu-container__aside-menubar d-block d-xl-none sidebar-btn">
        <i class="fa-solid fa-bars fs-1"></i>
    </button>
    <nav class="navbar navbar-expand-xl navbar-light top-navbar d-xl-flex d-block px-3 px-xl-0 py-4 py-xl-0 {{ !getLogInUser()->theme_mode ? 'bg-white' : '' }}" id="nav-header">
        <div class="container-fluid pe-0">
            <div class="navbar-collapse">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    @include('layouts.sub_menu')
                </ul>
            </div>
        </div>
    </nav>
    <ul class="nav align-items-center flex-nowrap">
        @if(getLogInUser()->theme_mode)
            <li class="px-xxl-3 px-2">
                <a data-turbo="false" href="{{ route('mode.theme') }}" title="{{__('messages.tooltip.light_mode')}}">
                    <i class="fa-solid fa-sun text-primary fs-2"></i>
                </a>
            </li>
        @else
            <li class="px-xxl-3 px-2">
                <a data-turbo="false" href="{{ route('mode.theme') }}" title="{{__('messages.tooltip.dark_mode')}}">
                    <i class="fa-solid fa-moon text-primary fs-2"></i>
                </a>
            </li>
        @endif

        @role(\App\Models\Role::ROLE_ADMIN)
        @if(!empty(getCurrentSubscription()) && getCurrentSubscription()->plan->is_trial)
            <li class="px-xxl-3 px-2">
                <span class="text-primary">
                    {{ __('messages.subscription.trial_plan') }}
                </span>
            </li>
        @endif
        @endrole

        @impersonating
        <li class="px-xxl-3 px-2">
            <span class="text-primary">
                <a data-turbo="false" data-turbo-eval="false" href="{{ route('impersonate.leave') }}">
                    <i class="fas fa-user-check fs-2"></i>
                </a>
            </span>
        </li>
        @endImpersonating

        @php
            $loggedInUser = getLogInUser();
            $profileMedia = $loggedInUser->getMedia(\App\Models\User::PROFILE)->first();
            $profileImageUrl = asset('web/media/avatars/150-2.jpg'); // Default image

            if ($profileMedia) {
                $mediaPath = $profileMedia->getPath();
                // Check if the file actually exists on the filesystem
                if ($mediaPath && file_exists($mediaPath)) {
                    $profileImageUrl = $profileMedia->getFullUrl();
                }
            }
        @endphp

        <li class="px-xxl-3 px-2">
            <div class="dropdown d-flex align-items-center py-4">
                <div class="image image-circle image-mini">
                    <img src="{{ $profileImageUrl }}"
                         class="img-fluid" alt="profile image">
                </div>
                <button class="btn dropdown-toggle ps-2 pe-0" type="button" id="dropdownMenuButton1"
                        data-bs-toggle="dropdown" aria-expanded="false" data-bs-auto-close="outside">
                    {!! getLogInUser()->full_name !!}
                </button>
                <div class="dropdown-menu py-7 pb-4 my-2" aria-labelledby="dropdownMenuButton1" data-bs-auto-close="outside">
                    <div class="text-center border-bottom pb-5">
                        <div class="image image-circle image-tiny mb-5">
                            <img src="{{ $profileImageUrl }}" class="img-fluid" alt="profile image">
                        </div>
                        <h3 class="text-gray-900">{{ getLogInUser()->full_name }}</h3>
                        <h4 class="mb-0 fw-400 fs-6">{{ getLogInUser()->email }}</h4>
                    </div>
                    <ul class="pt-4">
                        <li>
                            <a class="dropdown-item text-gray-900" href="{{ route('profile.setting') }}">
                            <span class="dropdown-icon me-4 text-gray-600">
                                <i class="fa-solid fa-user"></i>
                            </span>
                                {{ __('messages.user.account_setting') }}
                            </a>
                        </li>
                        @role(\App\Models\Role::ROLE_ADMIN)
                            <li>
                                <a class="dropdown-item text-gray-900" href="{{ route('subscription.index') }}">
                                    <span class="dropdown-icon me-4 text-gray-600">
                                        <i class="fa-solid fa-money-bill"></i>
                                    </span>
                                    {{ __('messages.subscription.manage_subscription') }}</a>
                            </li>
                        @endrole
                        @if((is_impersonating() === false))
                            <li>
                                <a class="dropdown-item text-gray-900" id="changePassword" href="javascript:void(0)">
                                    <span class="dropdown-icon me-4 text-gray-600">
                                        <i class="fa-solid fa-lock"></i>
                                    </span>
                                    {{ __('messages.user.change_password') }}
                                </a>
                            </li>
                        @endif
                        <li>
                            <a class="dropdown-item text-gray-900" id="changeLanguage" href="javascript:void(0)">
                               <span class="dropdown-icon me-4 text-gray-600">
                                   <i class="fa-solid fa-globe"></i>
                               </span>
                                {{ __('messages.user.change_language') }}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item text-gray-900 d-flex" href="javascript:void(0)">
                                <span class="dropdown-icon me-4 text-gray-600">
                                    <i class="fa-solid fa-right-from-bracket"></i>
                                </span>
                                <form id="logout-form" action="{{ route('logout')}}" method="post">
                                    @csrf
                                </form>
                                <span onclick="event.preventDefault(); localStorage.clear();  document.getElementById('logout-form').submit();">
                                    {{ __('messages.sign_out') }}</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </li>
        <li>
            <button type="button" class="btn px-0 d-block d-xl-none header-btn pb-2">
                <i class="fa-solid fa-bars fs-1"></i>
            </button>
        </li>
    </ul>
</header>
<div class="bg-overlay" id="nav-overly"></div>

{{-- Trial Plan Remaining Days Popup --}}
@if(getLogInUser())
    @php
        $trialInfo = getTrialRemainingDays();
    @endphp
    @if($trialInfo && !$trialInfo['is_expired'])
        <style>
            #trialRemainingDaysPopup {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
                display: flex;
                align-items: center;
                justify-content: center;
                z-index: 9999;
                transition: opacity 0.3s ease;
            }
            #trialRemainingDaysPopup .popup-content {
                background: white;
                border-radius: 8px;
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
                max-width: 500px;
                width: 90%;
                margin: 20px;
                padding: 24px;
            }
            #trialRemainingDaysPopup .popup-header {
                display: flex;
                align-items: center;
                justify-content: space-between;
                margin-bottom: 20px;
            }
            #trialRemainingDaysPopup .popup-header h3 {
                font-size: 24px;
                font-weight: bold;
                color: #1A2B48;
                margin: 0;
            }
            #trialRemainingDaysPopup .close-btn {
                background: none;
                border: none;
                color: #6c757d;
                font-size: 24px;
                cursor: pointer;
                padding: 0;
                line-height: 1;
            }
            #trialRemainingDaysPopup .close-btn:hover {
                color: #495057;
            }
            #trialRemainingDaysPopup .days-box {
                background-color: rgba(11, 132, 255, 0.1);
                border-radius: 8px;
                padding: 20px;
                margin: 20px 0;
                text-align: center;
            }
            #trialRemainingDaysPopup .days-number {
                font-size: 48px;
                font-weight: bold;
                color: #0B84FF;
                margin-bottom: 5px;
            }
            #trialRemainingDaysPopup .days-label {
                font-size: 14px;
                color: #6c757d;
            }
            #trialRemainingDaysPopup .got-it-btn {
                background-color: #0B84FF;
                color: white;
                border: none;
                border-radius: 8px;
                padding: 10px 24px;
                font-weight: 500;
                cursor: pointer;
                float: right;
            }
            #trialRemainingDaysPopup .got-it-btn:hover {
                background-color: #0a73e6;
            }
            .upgradeBtn{
                color: white;
                text-decoration: none;
            }
            .upgradeBtn:hover{
                color: white;
            }
        </style>
        <script data-turbo-eval="false" data-turbolinks-eval="false">
            (function() {
                // Store popup data
                const popupData = {
                    remainingDays: {{ $trialInfo['remaining_days'] }},
                    planName: {!! json_encode($trialInfo['plan_name']) !!},
                    trialEndsAt: {!! json_encode($trialInfo['trial_ends_at']->format('M d, Y')) !!}
                };

                // Debug: Log when script runs (commented out for production)
                // console.log('Trial popup script loaded', popupData);

                // Function to show the popup
                function showTrialPopup() {
                    // Remove any existing popup first
                    const existingPopup = document.getElementById('trialRemainingDaysPopup');
                    if (existingPopup) {
                        existingPopup.remove();
                    }

                    // Wait a bit to ensure DOM is ready
                    setTimeout(function() {
                        // Create popup modal
                        const popupHTML = `
                            <div id="trialRemainingDaysPopup">
                                <div class="popup-content">
                                    <div class="popup-header">
                                        <h3>Trial Plan Reminder</h3>
                                        <button class="close-btn" onclick="window.closeTrialPopup()">
                                            <i class="fa-solid fa-times"></i>
                                        </button>
                                    </div>
                                    <div>
                                        <p style="color: #495057; margin-bottom: 10px;">
                                            Your plan <strong style="color: #0B84FF;">"${popupData.planName}"</strong> is active.
                                        </p>
                                        <div class="days-box">
                                            <div class="days-number">${popupData.remainingDays}</div>
                                            <div class="days-label">${popupData.remainingDays === 1 ? 'Day' : 'Days'} Remaining</div>
                                        </div>
                                        <p style="font-size: 14px; color: #6c757d; margin-bottom: 20px;">
                                            Your trial period ends on <strong>${popupData.trialEndsAt}</strong>
                                        </p>
                                        <button class="got-it-btn" onclick="window.closeTrialPopup()">
                                            <a href="{{ route('subscription.upgrade') }}" class="upgradeBtn">Upgrade Plan</a>
                                        </button>
                                        <div style="clear: both;"></div>
                                    </div>
                                </div>
                            </div>
                        `;

                        // Append to body
                        if (document.body) {
                            document.body.insertAdjacentHTML('beforeend', popupHTML);
                        }
                    }, 200);
                }

                // Function to close popup (make it global)
                window.closeTrialPopup = function() {
                    const popup = document.getElementById('trialRemainingDaysPopup');
                    if (popup) {
                        popup.style.opacity = '0';
                        setTimeout(() => {
                            popup.remove();
                        }, 300);
                    }
                };

                // Flag to prevent multiple simultaneous calls
                let isPopupShowing = false;
                let popupTimeout = null;

                // Function to initialize popup
                function initTrialPopup() {
                    // Prevent multiple calls
                    if (isPopupShowing) {
                        return;
                    }

                    // Check if popup already exists
                    if (document.getElementById('trialRemainingDaysPopup')) {
                        return;
                    }

                    // Clear any pending timeout
                    if (popupTimeout) {
                        clearTimeout(popupTimeout);
                    }

                    // Set flag and show popup
                    isPopupShowing = true;
                    popupTimeout = setTimeout(function() {
                        showTrialPopup();
                        // Reset flag after popup is shown
                        setTimeout(function() {
                            isPopupShowing = false;
                        }, 500);
                    }, 300);
                }

                // Single function to handle all navigation events
                function handlePageLoad() {
                    // Reset flag on new page
                    isPopupShowing = false;
                    if (popupTimeout) {
                        clearTimeout(popupTimeout);
                    }
                    initTrialPopup();
                }

                // Show popup immediately if DOM is ready
                if (document.readyState === 'complete' || document.readyState === 'interactive') {
                    handlePageLoad();
                } else {
                    document.addEventListener('DOMContentLoaded', handlePageLoad);
                }

                // Show popup on Turbolinks navigation
                document.addEventListener('turbolinks:load', handlePageLoad);

                // Show popup on Turbo navigation (Hotwired Turbo)
                document.addEventListener('turbo:load', handlePageLoad);

                // Show popup on regular page navigation (but only if not already handled)
                window.addEventListener('load', function() {
                    if (!isPopupShowing && !document.getElementById('trialRemainingDaysPopup')) {
                        handlePageLoad();
                    }
                });

                // Close on outside click
                document.addEventListener('click', function(e) {
                    const popup = document.getElementById('trialRemainingDaysPopup');
                    if (popup && e.target === popup) {
                        window.closeTrialPopup();
                    }
                });
            })();
        </script>
    @endif
@endif
