@php
    // Get user's currency preference
    $userCurrencyPreference = auth()->check() ? (auth()->user()->currency_preference ?? 'default') : 'default';
    $currencySymbol = ($userCurrencyPreference === 'LKR') ? 'LKR' : '$';
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('messages.payment.payment_success') }} - ebizcard</title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Remix Icon -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #F8FBFF, #ffffff, #F0F7FF);
            min-height: 100vh;
        }
        .success-animation {
            animation: successPulse 0.6s ease-out;
        }
        @keyframes successPulse {
            0% { transform: scale(0); opacity: 0; }
            50% { transform: scale(1.1); opacity: 1; }
            100% { transform: scale(1); opacity: 1; }
        }
        .countdown-ring {
            position: relative;
            width: 80px;
            height: 80px;
        }
        .countdown-ring svg {
            transform: rotate(-90deg);
        }
        .countdown-ring .progress {
            stroke-dasharray: 251.2;
            stroke-dashoffset: 251.2;
            transition: stroke-dashoffset 1s linear;
        }
        .fade-transition {
            opacity: 1;
            transition: opacity 0.5s ease-out;
        }
        .fade-out {
            opacity: 0;
        }
    </style>
</head>
<body>
    <div class="container py-5 fade-transition" id="successPage">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card shadow-lg rounded-4 p-4">
                    <div class="text-center mb-4">
                        <img src="{{ asset('uploads/settings/3/ebizcard.png') }}" alt="Logo" class="mb-3" height="64">
                        <p class="text-muted">Digital Business Card Solution</p>
                    </div>

                    <div class="success-animation text-center mb-5">
                        <div class="mx-auto bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-4" style="width: 96px; height: 96px;">
                            <i class="ri-check-line text-success" style="font-size: 48px;"></i>
                        </div>
                        <h1 class="h3 text-primary">Payment Successful!</h1>
                        <p class="text-muted">Thank you for your purchase. Your transaction has been completed successfully.</p>
                    </div>

                    <div class="bg-light rounded-3 p-4 mb-5">
                        <h5 class="mb-3">Transaction Details</h5>
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex justify-content-between mb-2">
                                <span>Invoice Number:</span>
                                <code>#{{ $transactionIdFormatted }}</code>
                            </li>
                            <li class="d-flex justify-content-between mb-2">
                                <span>Date & Time:</span>
                                <span>{{ $formattedDate }}</span>
                            </li>
                            <li class="d-flex justify-content-between mb-2">
                                <span>Amount Paid:</span>
                                <strong>{{ $currencySymbol }} {{ number_format($amountToPay, 2) }}</strong>
                            </li>
                            <li class="d-flex justify-content-between mb-2">
                                <span>Payment Method:</span>
                                <span>{{ $paymentMethod ?? 'Abapay khqr' }}</span>
                            </li>
                            <li class="d-flex justify-content-between">
                                <span>Plan:</span>
                                <span>{{ $plan_name }}</span>
                            </li>
                        </ul>
                    </div>

                    <div class="text-center mb-4">
                        <div class="countdown-ring mx-auto mb-3">
                            <svg width="80" height="80" class="position-absolute top-0 start-50 translate-middle-x">
                                <circle cx="40" cy="40" r="36" stroke="#e5e7eb" stroke-width="4" fill="none"></circle>
                                <circle cx="40" cy="40" r="36" stroke="#0B84FF" stroke-width="4" fill="none" class="progress" id="progressRing"></circle>
                            </svg>
                            <div class="position-absolute top-50 start-50 translate-middle">
                                <span class="fs-4 fw-bold text-primary" id="countdownNumber">5</span>
                            </div>
                        </div>
                        <p class="text-muted">
                            Redirecting to admin panel in <span id="countdownText" class="fw-semibold text-primary">5</span> seconds
                        </p>
                    </div>

                    <div class="d-grid gap-3 d-md-flex justify-content-md-center">
                        <a href="{{ route('dashboard') }}" class="btn btn-primary px-4">
                            Return to Dashboard
                        </a>
                        <button class="btn btn-outline-secondary px-4">
                            <i class="ri-download-line me-2"></i>
                            <a href="{{ url('/admin/invoices/download/' . $subscriptionID) }}"
   class="btn btn-sm btn-primary"
   target="_blank">
    Download Receipt
</a>
                            
                        </button>
                    </div>

                    <div class="text-center mt-5 border-top pt-4">
                        <p class="text-muted small mb-2">Need help? Contact our support team</p>
                        <div class="d-flex justify-content-center gap-3 small">
                            <a href="mailto:support@ebizcard.com" class="text-primary text-decoration-none">
                                <i class="ri-mail-line me-1"></i> support@ebizcard.com
                            </a>
                            <span class="text-muted">|</span>
                            <a href="tel:+1234567890" class="text-primary text-decoration-none">
                                <i class="ri-phone-line me-1"></i> +1 (234) 567-890
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Countdown and Receipt Scripts -->
    <script>
       document.addEventListener('DOMContentLoaded', function () {
    let countdown = 10; // start from 10
    const countdownNumber = document.getElementById('countdownNumber');
    const countdownText = document.getElementById('countdownText');
    const progressRing = document.getElementById('progressRing');
    const circumference = 2 * Math.PI * 36;
    const successPage = document.getElementById('successPage');

    progressRing.style.strokeDasharray = circumference;
    progressRing.style.strokeDashoffset = 0;

    const totalTime = 10; // total countdown time in seconds

    const timer = setInterval(() => {
        countdown--;
        countdownNumber.textContent = countdown;
        countdownText.textContent = countdown;
        const progress = (totalTime - countdown) / totalTime; // adjust for 10
        const offset = circumference * (1 - progress);
        progressRing.style.strokeDashoffset = offset;

        if (countdown <= 0) {
            clearInterval(timer);
            successPage.classList.add('fade-out');
            setTimeout(() => {
                window.location.href = "{{ route('subscription.index') }}";
            }, 500);
        }
    }, 1000);
});


        
    </script>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
