@extends('layouts.app')
@section('title')
    {{__('messages.vcards')}}
@endsection
@section('content')
    @if ($errors->has('import'))
        <div class="alert alert-danger">
            {{ $errors->first('import') }}
        </div>
    @endif
    <div class="container-fluid">
        <div class="mb-3">
            <h1>{{ __('messages.vcards') }}</h1>
            <!-- Buttons on new line -->
             @if ($currentSubscription->plan->plan_type == 1)
            <div class="mt-2">
                <!-- Import Form -->
                <form action="{{ route('vcards.import') }}" method="POST" enctype="multipart/form-data" style="display:inline-block;">
                    @csrf
                    <input type="file" name="file" required>
                    <button type="submit" class="btn btn-primary">Import</button>
                </form>

                <!-- Export Button -->
                <a href="{{ route('vcards.export') }}" class="btn btn-success"
                onclick="setTimeout(() => window.location='{{ route('vcards.index') }}', 1000);">
                Download Sample
                </a>
            </div>
             @endif
        </div>
        <div class="d-flex flex-column table-striped">
            @include('flash::message')
            <livewire:user-vcard-table/>
        </div>
    </div>
    @include('layouts.templates.actions')
    @include('vcards.templates.templates')
    @include('vcards.templates.analytics')
@endsection
