<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'super_admin')): ?>
<div class="container-fluid">
    <div class="d-flex flex-column">
        <div class="row">

            
            <div class="col-12 mb-4">
                <div class="row">
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div class="bg-primary shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center
                            justify-content-between my-3">
                            <div
                                class="bg-cyan-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-user fs-1-xl text-white"></i>
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($activeUsersCount); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.total_active_users')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div
                            class="bg-success shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center justify-content-between my-3">
                            <div
                                class="bg-green-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-id-card-clip fs-1-xl text-white"></i>
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($activeVcard); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.total__active_vcards')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div
                            class="bg-info shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center justify-content-between my-3">
                            <div
                                class="bg-blue-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-user-large-slash fs-1-xl text-white"></i>
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($deActiveUsersCount); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.total_deactive_users')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div
                            class="bg-warning shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center justify-content-between my-3">
                            <div
                                class="bg-yellow-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                <img src="<?php echo e(asset('assets/img/dashboard/deactive-vcard.svg')); ?>" alt="" class="w-50 h-50">
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($deActiveVcard); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.total__deactive_vcards')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-xxl-4 col-12 mb-7 mb-xxl-0">
                <div class="card">
                    <div class="card-header pb-0 px-10">
                        <h3 class="mb-0"><?php echo e(__('messages.sadmin_dashboard.plans_by_users')); ?></h3>
                    </div>
                    <div class="card-body">
                        <canvas id="dashboardPlanPieChart"></canvas>
                    </div>
                </div>
            </div>

            
            <div class="col-xxl-8 col-12 mb-7 mb-xxl-0">
                <div class="card">
                    <div class="card-header pb-0 px-10">
                        <h3 class="mb-0"><?php echo e(__('messages.sadmin_dashboard.income')); ?></h3>
                        <button type="button" class="btn btn-icon btn-outline-primary me-5" title="Switch Chart">
                                    <span class="svg-icon svg-icon-1 m-0 text-center" id="dashboardChangeIncomeChart">
                                    <i class="fa-solid fa-chart-line income-chart"></i>
                                </span>
                        </button>
                    </div>
                    <div class="mt-6 mx-6">
                        <div id="incomeChartCanvas">
                            <canvas id="dashboardIncomeChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12 mt-7">
                <div class="card">
                    <div class="card-header pb-0 px-10">
                        <h3 class="mb-0"><?php echo e(__('Top VCards by Visits')); ?></h3>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Rank')); ?></th>
                                        <th><?php echo e(__('VCard Name')); ?></th>
                                        <th><?php echo e(__('User Name')); ?></th>
                                        <th><?php echo e(__('VCard URL')); ?></th>
                                        <th><?php echo e(__('Total Visits')); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-600 fw-bold">
                                    <?php if(isset($topVcardsData) && $topVcardsData->count() > 0): ?>
                                        <?php $__currentLoopData = $topVcardsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $vcard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="text-center">
                                                    <span class="badge badge-circle badge-primary fs-6"><?php echo e($index + 1); ?></span>
                                                </td>
                                                <td>
                                                    <span class="text-muted fw-bold"><?php echo e($vcard['vcard_name']); ?></span>
                                                </td>
                                                <td>
                                                    <span class="text-muted"><?php echo e($vcard['user_name']); ?></span>
                                                </td>
                                                <td>
                                                    <?php if($vcard['url_alias']): ?>
                                                        <?php if($vcard['status'] == 1): ?>
                                                            <a href="<?php echo e(route('vcard.show', ['alias' => $vcard['url_alias']])); ?>"
                                                               id="vcardUrl<?php echo e($vcard['vcard_id']); ?>"
                                                               target="_blank"
                                                               class="text-decoration-none fs-6">
                                                                <?php echo e(route('vcard.show', ['alias' => $vcard['url_alias']])); ?>

                                                            </a>
                                                            <button class="btn px-2 text-primary fs-2 user-edit-btn copy-clipboard"
                                                                    data-id="<?php echo e($vcard['vcard_id']); ?>"
                                                                    title="<?php echo e(__('Copy')); ?>">
                                                                <i class="fa-regular fa-copy fs-2"></i>
                                                            </button>
                                                        <?php else: ?>
                                                            <span id="vcardUrl<?php echo e($vcard['vcard_id']); ?>">
                                                                <?php echo e(route('vcard.show', ['alias' => $vcard['url_alias']])); ?>

                                                            </span>
                                                            <button class="btn px-2 text-primary fs-2 user-edit-btn copy-clipboard"
                                                                    data-id="<?php echo e($vcard['vcard_id']); ?>"
                                                                    title="<?php echo e(__('Copy')); ?>">
                                                                <i class="fa-regular fa-copy fs-2"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <span class="text-muted">N/A</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge  fs-6"><?php echo e($vcard['total_visits']); ?></span>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr class="text-center">
                                            <td colspan="5" class="text-muted fw-bold"><?php echo e(__('No analytics data available')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12 mt-7">
                    <div class="d-flex">
                        <h3 class="card-title align-items-start flex-column">
                            <span
                                class="fw-bolder fs-3 mb-1"><?php echo e(__('messages.sadmin_dashboard.recent_users_registration')); ?></span>
                        </h3>
                        <div class="card-toolbar ms-auto">
                            <ul class="nav nav-tabs mb-5 pb-1 overflow-auto flex-nowrap text-nowrap" role="tablist">
                                <li class="nav-item position-relative me-7 mb-3" role="presentation">
                                    <button class="nav-link active p-0" id="dayData" data-bs-toggle="tab" data-bs-target="#day"
                                            type="button" role="tab" aria-controls="day" aria-selected="true">
                                        <?php echo e(__('messages.sadmin_dashboard.day')); ?>

                                    </button>
                                </li>
                                <li class="nav-item position-relative me-7 mb-3" role="presentation">
                                    <button class="nav-link p-0" id="weekData" data-bs-toggle="tab" data-bs-target="#week"
                                            type="button" role="tab" aria-controls="week" aria-selected="false">
                                        <?php echo e(__('messages.sadmin_dashboard.week')); ?>

                                    </button>
                                </li>
                                <li class="nav-item position-relative me-7 mb-3" role="presentation">
                                    <button class="nav-link p-0" id="monthData" data-bs-toggle="tab" data-bs-target="#month"
                                            type="button" role="tab" aria-controls="month" aria-selected="false">
                                        <?php echo e(__('messages.sadmin_dashboard.month')); ?>

                                    </button>
                                </li>

                            </ul>
                        </div>
                    </div>
                    <div class="pb-2">
                        <div class="tab-content">
                            <div class="tab-pane fade active" id="day">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('messages.sadmin_dashboard.name')); ?></th>
                                            <th><?php echo e(__('messages.sadmin_dashboard.email')); ?></th>
                                            <th class="text-nowrap"><?php echo e(__('messages.sadmin_dashboard.contact')); ?></th>
                                            <th class="text-nowrap"><?php echo e(__('messages.sadmin_dashboard.registered_on')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody id="dailyReport" class="text-gray-600 fw-bold">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="week">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('messages.sadmin_dashboard.name')); ?></th>
                                            <th><?php echo e(__('messages.sadmin_dashboard.email')); ?></th>
                                            <th class="text-nowrap"><?php echo e(__('messages.sadmin_dashboard.contact')); ?></th>
                                            <th class="text-nowrap"><?php echo e(__('messages.sadmin_dashboard.registered_on')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody id="weeklyReport" class="text-gray-600 fw-bold">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="month">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('messages.sadmin_dashboard.name')); ?></th>
                                            <th><?php echo e(__('messages.sadmin_dashboard.email')); ?></th>
                                            <th class="text-nowrap"><?php echo e(__('messages.sadmin_dashboard.contact')); ?></th>
                                            <th class="text-nowrap"><?php echo e(__('messages.sadmin_dashboard.registered_on')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody id="monthlyReport" class="text-gray-600 fw-bold">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'admin')): ?>
<div class="container-fluid">
    <div class="d-flex flex-column">
        <div class="row">
             <div class="col-12 d-flex justify-content-end">
                 <?php if($currentSubscription->plan->plan_type == 1): ?>
                <a href="<?php echo e(route('subscription.upgrade')); ?>" class="btn btn-primary mx-2">
                    <?php echo e(__('messages.subscription.upgrade_plan')); ?>

                </a>
                <?php endif; ?>
                <?php if($currentSubscription->plan->plan_type == 1): ?>
                <a href="javascript:;" class="btn btn-primary" id="downgradeBtn" style="margin-right: 10px;">
                    <?php echo e(__('messages.subscription.downgrade_plan')); ?>

                </a>
                <?php endif; ?>
                 <?php if($currentSubscription->plan->plan_type == 1): ?>
                <a href="javascript:;" class="btn btn-primary" id="requestCardBtn">
                    <?php echo e(__('messages.subscription.request_more_card')); ?>

                </a>
                <?php endif; ?>

            </div>
            
            <div class="col-12 mb-4">
                <div class="row">
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div class="bg-primary shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center
                            justify-content-between my-3">
                            <div class="bg-cyan-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-id-card-clip fs-1-xl text-white"></i>
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($activeVcard); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.total__active_vcards')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div class="bg-success shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center justify-content-between my-3">
                            <div class="bg-green-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                
                                <img src="<?php echo e(asset('assets/img/dashboard/deactive-vcard.svg')); ?>" alt="" class="w-50 h-50">
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($deActiveVcard); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.total__deactive_vcards')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div class="bg-info shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center justify-content-between my-3">
                            <div class="bg-blue-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-question fs-1-xl text-white"></i>
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($enquiry); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.today_enquiry')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-sm-6 widget">
                        <div class="bg-warning shadow-md rounded-10 p-xxl-10 px-7 py-10 d-flex align-items-center justify-content-between my-3">
                            <div class="bg-yellow-300 widget-icon rounded-10 d-flex align-items-center justify-content-center">
                                <i class="fa-solid fa-calendar-check fs-1-xl text-white"></i>
                            </div>
                            <div class="text-end text-white">
                                <h2 class="fs-1-xxl fw-bolder text-white"><?php echo e($appointment); ?></h2>
                                <h3 class="mb-0 fs-4 fw-light"><?php echo e(__('messages.common.today_appointments')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12 mb-4">
                <div class="card">
                    <div class="card-header pb-0 px-10">
                        <h3 class="mb-0"><?php echo e(__('messages.analytic.vcard_analytic')); ?></h3>
                        <div class="ms-auto">
                            <button type="button" class="btn btn-icon btn-outline-primary me-5" title="Switch Chart">
                                    <span class="svg-icon svg-icon-1 m-0 text-center" id="dashboardChangeChart">
                                    <i class="fa-solid fa-chart-line chart"></i>
                                </span>
                            </button>

                        </div>
                        <div id="dashboardTimeRange" class="time_range
                                    btn btn-outline-primary align-items-center">
                            <i class="far fa-calendar-alt" aria-hidden="true"></i>
                            &nbsp;&nbsp<span></span> <b class="caret"></b>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <div id="dashboardWeeklyUserBarChartContainer">
                                <canvas id="dashboardWeeklyUserBarChart" height="200" width="905"
                                        style="display: block; width: 905px; height: 200px;"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12">
                    <div class="mt-3 mb-5">
                        <h3><?php echo e(__('messages.common.today_appointments')); ?></h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th class="text-nowrap"><?php echo e(__('messages.vcard.vcard_name')); ?></th>
                                <th><?php echo e(__('messages.common.name')); ?></th>
                                <th><?php echo e(__('messages.common.phone')); ?></th>
                                <th><?php echo e(__('messages.common.email')); ?></th>
                            </tr>
                            </thead>
                            <tbody id="appointmentReport">

                            </tbody>
                        </table>
                    </div>
            </div>
        </div>
    </div>
</div>

<script>
    const calculateUrl = "<?php echo e(route('card-requests.calculate')); ?>";
    const cardRequestStoreUrl = "<?php echo e(route('card-requests.store')); ?>";
    const downgradeRequestUrl = "<?php echo e(route('downgrade-requests.store')); ?>";
    const csrf = "<?php echo e(csrf_token()); ?>";
</script>
<?php endif; ?>

<?php echo $__env->make('dashboard.templates.templates', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('dashboard.templates.userTemplate', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('dashboard.request-card-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('dashboard.downgrade-card-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('assets/js/request_card.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/downgrade_card.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\Ebizcard17-11-25\resources\views/dashboard/index.blade.php ENDPATH**/ ?>