<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subscription Notification</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="margin-bottom: 20px;">
        <h2 style="color: #333; margin-bottom: 10px;">Hello <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>,</h2>
    </div>

    <div style="margin-bottom: 20px;">
        <?php if($isExpired): ?>
            <p>Your subscription has expired.</p>
        <?php else: ?>
            <p>Your subscription will expire in <?php echo e($daysRemaining); ?> days.</p>
        <?php endif; ?>
    </div>

    <div style="margin-bottom: 20px; background-color: #f9f9f9; padding: 15px; border-radius: 5px;">
        <p style="margin: 5px 0;"><strong>Plan Name:</strong> <?php echo e($subscription->plan->name); ?></p>
        <p style="margin: 5px 0;"><strong>Expired Date:</strong> <?php echo e(\Carbon\Carbon::parse($expirationDate)->format('dS M, Y')); ?></p>
        <?php if(!$isExpired): ?>
            <p style="margin: 5px 0;"><strong>Remaining Days:</strong> <?php echo e($daysRemaining); ?> days</p>
        <?php endif; ?>
    </div>

    <div style="margin: 30px 0; text-align: center;">
        <a href="<?php echo e(route('subscription.upgrade')); ?>" style="display: inline-block; background-color: #007bff; color: #ffffff; padding: 12px 30px; text-decoration: none; border-radius: 5px; font-weight: bold;">Click here to upgrade</a>
    </div>

    <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; color: #666; font-size: 14px;">
        <p>Thank you for using <?php echo e(getAppName()); ?>.</p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\projects\Ebizcard17-11-25\resources\views/emails/subscription_expiration.blade.php ENDPATH**/ ?>