<?php $__env->startSection('title'); ?>
<?php echo e(__('messages.subscription.payment')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex flex-column">
        <div class="col-12">
            <div class="modal fade" id="paywayModal" tabindex="-1" aria-hidden="true" style="overflow: hidden;">
                <div class="modal-dialog modal-dialog-centered" style="max-width: 380px; margin: 2rem auto;">
                    <div class="modal-content"
                        style="position: relative; border-radius: 20px; box-shadow: 0 4px 20px rgba(0,0,0,0.2); overflow: hidden;">

                        <!-- Custom X Close Button -->
                        <button type="button" data-bs-dismiss="modal" aria-label="Close"
                            style="position: absolute; top: 12px; right: 12px; background: none; border: none; font-size: 24px; font-weight: bold; color: #000; z-index: 1000; cursor: pointer; line-height: 1;">
                            Ã—
                        </button>

                        <div class="modal-body" style="padding: 0; overflow: hidden;">
                            <iframe id="paywayIframe" src="" frameborder="0"
                                style="width: 100%; height: 585px; border: none; display: block; overflow: hidden;"></iframe>
                        </div>
                    </div>
                </div>
            </div>
            <div id="iframe-container"></div>

            <div class="d-flex justify-content-between align-items-end mb-5">
                <h1><?php echo $__env->yieldContent('title'); ?></h1>
                <a class="btn btn-outline-primary float-end"
                    href="<?php echo e(url()->previous()); ?>"><?php echo e(__('messages.common.back')); ?></a>
            </div>

            <div class="col-12">
                <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="card">
                <?php
                $cpData = getCurrentPlanDetails();
                $planText = $cpData['isExpired'] ? __('messages.subscription.current_expire') : __('messages.subscription.current_plan');
                $currentPlan = $cpData['currentPlan'];
                ?>
                <div class="card-body">
                    <div class="row">
                        <?php if($planText != 'Current Expired Plan'): ?>
                        <div class="col-md-4">
                            <div class="card p-5 me-2 shadow rounded">
                                <div class="card-header py-0 px-0">
                                    <h3 class="align-items-start flex-column p-sm-5 p-0">
                                        <span class="fw-bolder text-primary fs-1 mb-1 me-0"><?php echo e($planText); ?></span>
                                    </h3>
                                </div>
                                <div class="px-4">
                                    <div class="d-flex align-items-center py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-5 fw-bolder">
                                            <?php echo e(__('messages.subscription.plan_name')); ?>

                                        </h4>
                                        <span class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($cpData['name']); ?></span>
                                    </div>
                                    <div class="d-flex align-items-center  py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-3 fw-bolder">
                                            <?php echo e(__('messages.subscription.plan_price')); ?>

                                        </h4>
                                        <span class="fs-5 text-muted fw-bold mt-1">
                                            <span class="mb-2">
                                                <?php echo e(getCurrencyAmount($currentPlan->price, $currentPlan->currency->currency_icon)); ?>

                                            </span>
                                        </span>
                                    </div>
                                    <div class="d-flex align-items-center  py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-5 fw-bolder">
                                            <?php echo e(__('messages.subscription.start_date')); ?>

                                        </h4>
                                        <span class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($cpData['startAt']); ?></span>
                                    </div>
                                    <div class="d-flex align-items-center  py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-5 fw-bolder">
                                            <?php echo e(__('messages.subscription.end_date')); ?>

                                        </h4>
                                        <span class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($cpData['endsAt']); ?></span>
                                    </div>
                                    <div class="d-flex align-items-center  py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-5 fw-bolder">
                                            <?php echo e(__('messages.subscription.used_days')); ?>

                                        </h4>
                                        <span class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($cpData['usedDays']); ?>

                                            Days</span>
                                    </div>
                                    <div class="d-flex align-items-center  py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-5 fw-bolder">
                                            <?php echo e(__('messages.subscription.remaining_days')); ?>

                                        </h4>
                                        <span class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($cpData['remainingDays']); ?>

                                            <?php echo e(__('messages.plan.days')); ?></span>
                                    </div>
                                    <div class="d-flex align-items-center  py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-5 fw-bolder">
                                            <?php echo e(__('messages.subscription.used_balance')); ?>

                                        </h4>
                                        <span class="fs-5 w-50 text-muted fw-bold mt-1">
                                            <span class="mb-2">
                                                <?php echo e(getCurrencyAmount($cpData['usedBalance'], $currentPlan->currency->currency_icon)); ?>

                                            </span>
                                        </span>
                                    </div>
                                    <div class="d-flex align-items-center  py-2">
                                        <h4 class="fs-5 w-50 mb-0 me-5 fw-bolder">
                                            <?php echo e(__('messages.subscription.remaining_balance')); ?>

                                        </h4>
                                        <span class="fs-5 w-50 text-muted fw-bold mt-1">
                                            <span class="mb-2">
                                                <?php echo e(getCurrencyAmount($cpData['remainingBalance'], $currentPlan->currency->currency_icon)); ?>

                                            </span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php
                        $newPlan = getProratedPlanData($subscriptionsPricingPlan->id);
                        ?>

                        <?php echo e(Form::hidden('amount_to_pay', $newPlan['amountToPay'], ['id' => 'amountToPay'])); ?>

                        <?php echo e(Form::hidden('plan_end_date', $newPlan['endDate'], ['id' => 'planEndDate'])); ?>

                        <div class="col-md-8 col-12 <?php if($planText == 'Current Expired Plan'): ?> mx-auto <?php endif; ?>">
                            <div class="card h-100 p-5 me-2 shadow rounded">
                                <div class="card-header py-0 px-0">
                                    <div class="d-flex justify-content-between w-100">
                                        <!-- Left side header content -->
                                        <div class="w-50">
                                            <h3 class="align-items-start flex-column p-sm-5 p-0">
                                                <span
                                                    class="fw-bolder text-primary fs-1 mb-1 me-0"><?php echo e(__('messages.plan.new_plan')); ?></span>
                                            </h3>
                                        </div>
                                        <div class="w-50">
                                            <h3 class="align-items-start flex-column p-sm-5 p-0">
                                                <span
                                                    class="fw-bolder text-primary fs-1 mb-1 me-0"><?php echo e(__('messages.payment_method')); ?></span>
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                                <div class="px-5 pb-5">
                                    <!-- Flex container for side-by-side layout -->
                                    <div class="d-flex justify-content-between">

                                        <!-- Left side -->
                                        <div class="w-45">
                                            <div class="d-flex align-items-center py-2">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.subscription.plan_name')); ?>

                                                </h4>
                                                <span
                                                    class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($newPlan['name']); ?></span>
                                            </div>
                                            <div class="d-flex align-items-center py-2">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.subscription.plan_price')); ?>

                                                </h4>
                                                <span class="fs-5 w-50 text-muted fw-bold mt-1">
                                                    <span class="mb-2">
                                                        <?php echo e(getCurrencyAmount($subscriptionsPricingPlan->price, $subscriptionsPricingPlan->currency->currency_icon)); ?>

                                                    </span>
                                                </span>
                                            </div>
                                            <div class="d-flex align-items-center py-2">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.subscription.start_date')); ?>

                                                </h4>
                                                <span
                                                    class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($newPlan['startDate']); ?></span>
                                            </div>
                                            <div class="d-flex align-items-center py-2">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.subscription.end_date')); ?>

                                                </h4>
                                                <span
                                                    class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($newPlan['endDate']); ?></span>
                                            </div>
                                            <div class="d-flex align-items-center py-2">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.subscription.total_days')); ?>

                                                </h4>
                                                <span
                                                    class="fs-5 w-50 text-muted fw-bold mt-1"><?php echo e($newPlan['totalDays']); ?>

                                                    <?php echo e(__('messages.plan.days')); ?></span>
                                            </div>
                                            <div class="d-flex align-items-center py-2 d-none">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.coupon_code.coupon_discount')); ?>

                                                </h4>
                                                <span class="fs-5 w-50 text-muted fw-bold mt-1">
                                                    <span
                                                        class="coupon-discount"><?php echo e(getCurrencyAmount($subscriptionsPricingPlan->price, $subscriptionsPricingPlan->currency->currency_icon)); ?></span>
                                                </span>
                                            </div>
                                            <div class="d-flex align-items-center py-2">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.plan.remaining_balance')); ?>

                                                </h4>
                                                <span class="fs-5 w-50 text-muted fw-bold mt-1">
                                                    <?php echo e(getCurrencyAmount($newPlan['remainingBalance'], $subscriptionsPricingPlan->currency->currency_icon)); ?>

                                                </span>
                                            </div>
                                            <div class="d-flex align-items-center py-2">
                                                <h4 class="fs-5 w-50 plan-data mb-0 me-5 fw-bolder">
                                                    <?php echo e(__('messages.subscription.payable_amount')); ?>

                                                </h4>
                                                <span class="fs-5 w-50 text-muted fw-bold mt-1">
                                                    <span
                                                        class="payable-amount"><?php echo e(getCurrencyAmount($newPlan['amountToPay'], $subscriptionsPricingPlan->currency->currency_icon)); ?></span>
                                                </span>
                                            </div>
                                        </div>

                                        <!-- Right side (replication of the left side content) -->
                                        <div class="w-50">
                                            <div class="mb-3 coupon-code-section w-sm-50 <?php echo e($newPlan['amountToPay'] <= 0 ? 'd-none' : ''); ?>">
                                                    <label
                                                        class="form-label fs-6 text-muted mb-0"><?php echo e(__('messages.coupon_code.have_a_coupon_code')); ?></label>
                                                    <div class="input-group">
                                                        <?php echo e(Form::text('coupon_code', null, ['class' => 'form-control', 'id' => 'paymentCouponCode', 'placeholder' => __('messages.coupon_code.enter_coupon_code')])); ?>

                                                        <span
                                                            class="btn input-group-text bg-primary text-light disabled apply-coupon-code-btn"
                                                            id="applyCouponCodeBtn" data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"
                                                            data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>"><?php echo e(__('messages.common.apply')); ?></span>
                                                    </div>
                                                </div>
                                                
                                            <?php if(Auth::check() && (Auth::user()->currency_preference == 'default' || Auth::user()->currency_preference == null)): ?>
                                                <?php if(in_array('Payway', $paymentTypes)): ?>
                                            <div class="mt-5 paywayPayment proceed-to-payment <?php echo e($newPlan['amountToPay'] > 0 ? '' : 'd-none'); ?>"
                                                style="box-shadow: 10px 8px 12px rgba(0, 0, 0, 0.05);">
                                                <button type="button"
                                                    class="btn bg-white border rounded-3 shadow-sm p-4 d-inline-block paymentByPayway"
                                                    data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"
                                                    data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>"
                                                    style="width: 108%;">

                                                    <div
                                                        class="d-flex align-items-center justify-content-between w-100">
                                                        <!-- Left side: image + text -->
                                                        <div class="d-flex align-items-center">
                                                            <img src="<?php echo e(asset('images/ABAKHQR.png')); ?>" alt="ABA KHQR"
                                                                style="height: 50px; margin-right: 10px; border-radius: 8px;">
                                                            <div>
                                                                <div
                                                                    style="font-weight: 600; font-size: 16px; color: #000; text-align: left;">
                                                                    ABA KHQR</div>
                                                                <div
                                                                    style="font-size: 13px; color: #697386; text-align: left;">
                                                                    Scan to pay with any banking app.</div>
                                                            </div>
                                                        </div>

                                                     
                                                    </div>
                                                </button>

                                            </div>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            
                                                <?php if(Auth::check() && Auth::user()->currency_preference == 'LKR'): ?>
                                           <!-- <div class="mt-5 oneayPayment proceed-to-payment <?php echo e($newPlan['amountToPay'] > 0 ? '' : 'd-none'); ?>"
                                                id="onepay-btn" style="box-shadow: 10px 8px 12px rgba(0, 0, 0, 0.05);">
                                            </div> -->
                                            <div class="mt-5 onepayPayment proceed-to-payment <?php echo e($newPlan['amountToPay'] > 0 ? '' : 'd-none'); ?>"
                                                style="box-shadow: 10px 8px 12px rgba(0, 0, 0, 0.05);">
                                                <button type="button"
                                                    class="btn bg-white border rounded-3 shadow-sm p-4 d-inline-block paymentByOnepay"
                                                    data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"
                                                    data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>"
                                                    style="width: 108%;">

                                                    <div
                                                        class="d-flex align-items-center justify-content-between w-100">
                                                        <!-- Left side: image + text -->
                                                        <div class="d-flex align-items-center">
                                                            <img src="<?php echo e(asset('images/onepay.png')); ?>" alt="OnePay"
                                                                style="height: 50px; margin-right: 10px; border-radius: 8px;">
                                                            <div>
                                                                <div
                                                                    style="font-weight: 600; font-size: 16px; color: #000; text-align: left;">
                                                                    ABA KHQR</div>
                                                                <div
                                                                    style="font-size: 13px; color: #697386; text-align: left;">
                                                                    Scan to pay with any banking app.</div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </button>

                                            </div>
                                            <?php endif; ?>
                                           
                                            <?php if(in_array('Manually', $paymentTypes)): ?>
                                            <div class="mt-5 manualPayment proceed-to-payment <?php echo e($newPlan['amountToPay'] > 0 ? '' : 'd-none'); ?>"
                                                style="box-shadow: 10px 8px 12px rgba(0, 0, 0, 0.05);">
                                                <button type="button"
                                                    class="btn bg-white border rounded-3 shadow-sm p-4 d-inline-block"
                                                    data-id="<?php echo e($subscriptionsPricingPlan->id); ?>" id="manualPaymentBtn"
                                                    data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>"
                                                    style="width: 108%;">

                                                    <div
                                                        class="d-flex align-items-center justify-content-between w-100">
                                                        <!-- Left side: image + text -->
                                                        <div class="d-flex align-items-center">
                                                            <img src="<?php echo e(asset('images/money-cash.jpg')); ?>" alt="ABA KHQR"
                                                                style="height: 50px; margin-right: 10px; border-radius: 8px;">
                                                            <div>
                                                                <div
                                                                    style="font-weight: 600; font-size: 16px; color: #000; text-align: left;">
                                                                    <?php echo e(__('messages.subscription.manual_payment')); ?></div>
                                                                <div
                                                                    style="font-size: 13px; color: #697386; text-align: left;">
                                                                    Proceed with manual payment confirmation.</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </button>

                                            </div>
                                            <?php endif; ?>
                                            <div class="mt-5 switch-plan-btn  proceed-to-payment  d-none">
                                                <button type="button" class="btn btn-primary rounded-pill mx-auto d-block makePayment"
                                                    data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"
                                                    data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>">
                                                    <?php echo e(__('messages.subscription.pay_or_switch_plan')); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="alert alert-danger d-none mt-2 mx-1" id="manualPaymentValidationErrorsBox"></div>
                    <div class="row justify-content-center">
                        <div
                            class="col-lg-6 col-12 d-sm-flex justify-content-center align-items-center flex-column mt-5 plan-controls">
                            <div class="mt-5 me-3 w-sm-50 <?php echo e($newPlan['amountToPay'] <= 0 ? 'd-none' : ''); ?>">
                                <!--<div class="mb-3">-->
                                <!--    <label-->
                                <!--        class="form-label fs-6 text-muted mb-0"><?php echo e(__('messages.coupon_code.have_a_coupon_code')); ?></label>-->
                                <!--    <div class="input-group">-->
                                <!--        <?php echo e(Form::text('coupon_code', null, ['class' => 'form-control', 'id' => 'paymentCouponCode', 'placeholder' => __('messages.coupon_code.enter_coupon_code')])); ?>-->
                                <!--        <span-->
                                <!--            class="btn input-group-text bg-primary text-light disabled apply-coupon-code-btn"-->
                                <!--            id="applyCouponCodeBtn" data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"-->
                                <!--            data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>"><?php echo e(__('messages.common.apply')); ?></span>-->
                                <!--    </div>-->
                                <!--</div>-->
                                <?php
                                $translatedPaymentTypes = collect($paymentTypes)->map(function ($value) {
                                return trans('messages.' . $value);
                                });
                                ?>
                                <!-- <div class="plan-payment-type">
                                        <?php echo e(Form::select('payment_type', $translatedPaymentTypes, null, ['class' => 'form-select', 'required', 'id' => 'paymentType', 'data-control' => 'select2', 'placeholder' => __('messages.select_payment_type')])); ?>

                                    </div> -->
                            </div>

                            <!--<div-->
                            <!--    class="mt-5 stripePayment proceed-to-payment <?php echo e($newPlan['amountToPay'] > 0 ? 'd-none' : ''); ?>">-->
                            <!--    <button type="button" class="btn btn-primary rounded-pill mx-auto d-block makePayment"-->
                            <!--        data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"-->
                            <!--        data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>">-->
                            <!--        <?php echo e(__('messages.subscription.switch_plan')); ?></button>-->
                            <!--</div>-->
                            <!--<div class="mt-5 paypalPayment proceed-to-payment d-none">-->
                            <!--    <button type="button"-->
                            <!--        class="btn btn-primary rounded-pill mx-auto d-block paymentByPaypal"-->
                            <!--        data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"-->
                            <!--        data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>">-->
                            <!--        <?php echo e(__('messages.subscription.pay_or_switch_plan')); ?></button>-->
                            <!--</div>-->

                            <form method="POST" target="aba_webservice"
                                action="https://checkout.payway.com.kh/api/payment-gateway/v1/payments/purchase"
                                id="aba_merchant_request">
                                <input type="hidden" name="hash" id="hash" />
                                <input type="hidden" name="tran_id" id="tran_id" />
                                <input type="hidden" name="amount" id="amount" />
                                <input type="hidden" name="firstname" id="firstname" />

                                <input type="hidden" name="phone" id="phone" />
                                <input type="hidden" name="email" id="email" />
                                <!--                        <input ype="hidden" name="items" value="--><?php //echo $items; 
                                                                                                        ?><!--" id="items"/>-->
                                <!-- <input type="hidden" name="re0turn_params" value="<?php //echo $return_params; 
                                                                                        ?>"/> -->
                                <!--                        <input type="hidden" name="shipping" value="-->
                                <?php //echo $shipping; 
                                ?><!--"/>-->
                                <!--                        <input type="hidden" name="payment_option" value="cards"/>-->
                                <input type="hidden" name="payment_option" id="payment_option" />
                                <!--                        <input type="hidden" name="currency" value="KHR"/>-->
                                <!--                        <input type="hidden" name="type" value="--><?php //echo $type; 
                                                                                                        ?><!--"/>-->
                                <input type="hidden" name="return_url" id="return_url" />
                                <!--                        <input type="hidden" name="payment_gate" value="0"/>-->
                                <input type="hidden" name="merchant_id" id="merchant_id" />
                                <input type="hidden" name="req_time" id="req_time" />
                                <input type="hidden" name="continue_success_url" id="continue_success_url" />
                                <!--                        <input type="hidden" name="return_param" value="Hello, It's me!"/>-->
                            </form>
                            <div class="mt-5 RazorPayPayment proceed-to-payment d-none">
                                <button type="button"
                                    class="btn btn-primary rounded-pill mx-auto d-block paymentByRazorPay d-none"
                                    data-id="<?php echo e($subscriptionsPricingPlan->id); ?>"
                                    data-plan-price="<?php echo e($subscriptionsPricingPlan->price); ?>">
                                    <?php echo e(__('messages.subscription.pay_or_switch_plan')); ?></button>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center align-items-center">
                        <div
                            class="col-12 d-flex flex-column justify-content-center align-items-center mt-5 plan-controls">
                            <form class="manuallyPaymentForm" type="post" enctype="multipart/form-data">
                                <div class="mb-3 d-none manuallyPayAttachment me-5" io-image-input="true">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="row">
                                                <div class="col-lg-3">
                                                    <label for="exampleInputImage"
                                                        class="form-label"><?php echo e(__('messages.mail.attachment')); ?>

                                                        :-</label>
                                                    <div class="d-block">
                                                        <div class="image-picker">
                                                            <div class="image previewImage" id="exampleInputImage"
                                                                style="background-image: url('<?php echo e(asset('assets/images/cover_image1.png')); ?>')">
                                                            </div>
                                                            <span
                                                                class="picker-edit rounded-circle text-gray-500 fs-small"
                                                                data-bs-toggle="tooltip" data-placement="top"
                                                                data-bs-original-title="Choose Attachment">
                                                                <label>
                                                                    <i class="fa-solid fa-pen"
                                                                        id="profileImageIcon"></i>
                                                                    <input type="file" id="manual_payment_attachment"
                                                                        name="attachment"
                                                                        class="image-upload file-validation d-none"
                                                                        accept="image/*" />
                                                                </label>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-9">
                                                    <label for="exampleInputImage"
                                                        class="form-label"><?php echo e(__('messages.mail.notes')); ?>

                                                        :-</label>
                                                    <?php echo e(Form::textarea('notes', null, ['class' => 'form-control', 'placeholder' => 'Add Your Notes', 'rows' => '5'])); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <?php echo e(Form::hidden('planId', $subscriptionsPricingPlan->id, ['id' => 'planId', 'class' => 'manuallyPaymentPlanId'])); ?>

                                        <?php echo e(Form::hidden('price', $subscriptionsPricingPlan->price, ['id' => 'price', 'class' => 'manuallyPaymentDataPlanPrice'])); ?>

                                        <?php echo e(Form::hidden('currency_icon', $subscriptionsPricingPlan->currency->currency_icon, ['id' => 'currencyIcon', 'class' => 'currencyIcon'])); ?>

                                        <?php echo e(Form::hidden('amount_to_pay', $newPlan['amountToPay'], ['id' => 'amountToPay'])); ?>

                                        <?php echo e(Form::hidden('couponCode', null, ['id' => 'couponCode'])); ?>

                                        <?php echo e(Form::hidden('couponCodeId', null, ['id' => 'couponCodeId'])); ?>

                                        <?php echo e(Form::hidden('plan_end_date', $newPlan['endDate'], ['id' => 'planEndDate'])); ?>

                                        <?php echo e(Form::hidden('payment_type', 4, ['id' => 'payment_type'])); ?>

                                        <?php echo e(Form::hidden('subscriptionId', null, ['id' => 'subscriptionId'])); ?>

                                        <input type="hidden" id="cardrequests" name="cardrequests"
                                            value="<?= isset($_REQUEST['cardrequests']) ? $_REQUEST['cardrequests'] : '' ?>" />

                                        <div class="col-lg-12">
                                            <div class="mt-5 ManuallyPayment proceed-to-payment d-none">
                                                <button type="submit"
                                                    class="btn btn-primary rounded-pill mx-auto d-block manuallyPay">
                                                    Cash Pay
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <?php if(getSuperAdminSettingValue('is_manual_payment_guide_on')): ?>
                        <div class="col-12 d-none mt-5 plan-controls manuallyPayAttachment">
                            <label
                                class="form-label text-muted mb-5 pb-md-3"><?php echo e(__('messages.vcard.manual_payment_guide')); ?>

                                :-</label>
                            <?php echo getSuperAdminSettingValue('manual_payment_guide'); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php if (! $__env->hasRenderedOnce('d70abb8c-2e0f-4ee2-b8ba-18bbec5c33d4')): $__env->markAsRenderedOnce('d70abb8c-2e0f-4ee2-b8ba-18bbec5c33d4');
$__env->startPush('scripts'); ?>
<script src="https://checkout.payway.com.kh/plugins/checkout2-0.js"></script>

<script>
    let options = {
        'key': "<?php echo e(getSelectedPaymentGateway('razorpay_key')); ?>",
        'amount': 0, //  100 refers to 1
        'currency': 'INR',
        'name': "<?php echo e(getAppName()); ?>",
        'order_id': '',
        'description': '',
        'image': '<?php echo e(asset(getAppLogo())); ?>', // logo here
        'callback_url': "<?php echo e(route('razorpay.success')); ?>",
        'prefill': {
            'email': '', // recipient email here
            'name': '', // recipient name here
            'contact': '', // recipient phone here
        },
        'readonly': {
            'name': 'true',
            'email': 'true',
            'contact': 'true',
        },
        'theme': {
            'color': '#0ea6e9',
        },
        'modal': {
            'ondismiss': function() {
                $('#paymentGatewayModal').modal('hide');
                displayErrorMessage(Lang.get('messages.placeholder.payment_not_complete'));
                setTimeout(function() {
                    Turbo.visit(window.location.href);
                }, 1000);
            },
        },
    };
</script>

<script>
    $(document).ready(function() {
        $('#paywayModal').on('hidden.bs.modal', function() {
            var subscriptionId = $('#subscriptionId').val();

            if (!subscriptionId) {
                console.error('Subscription ID not found.');
                return;
            }

            $.ajax({
                url: '/admin/check-subscription-status',
                type: 'GET',
                data: {
                    subscription_id: subscriptionId
                },
                success: function(response) {
                    if (response.status) {
                        window.location.href = "<?php echo e(route('payway.continuesuccessurl')); ?>";
                    } else {
                        window.location.href = "<?php echo e(route('failed-payment')); ?>";
                    }
                },
                error: function(xhr) {
                    console.error('AJAX error:', xhr.responseText);
                }
            });
        });

    });
</script>
<script>
    $(document).ready(function() {
        $('#paymentType').select2({
            templateResult: formatOptionWithImage,
            templateSelection: formatOptionWithImage,
            minimumResultsForSearch: -1
        });

        function formatOptionWithImage(option) {
            if (!option.id) return option.text;

            const text = option.text;
            if (text === 'ABA KHQR') {
                return $(`
                    <div style="display: flex; flex-direction: column;">
                        <span style="display: flex; align-items: center;">
                            <img src="<?php echo e(asset('images/ABAKHQR.png')); ?>" style="width: 25px; height: 25px; margin-right: 8px;">
                            ${text}
                        </span>
                        <small style="color: #6c757d; margin-left: 26px; font-size: 12px;">Scan to pay with any banking app.</small>
                    </div>
                `);
            }

            return text;
        }

        // Re-render selected container if "ABA Payway" is selected
        $('#paymentType').on('select2:select', function() {
            setTimeout(() => {
                const container = $('#select2-paymentType-container');
                const title = container.attr('title');

                if (title === 'ABA KHQR') {
                    container.html(`
                        <span style="display: flex; align-items: center;">
                            <img src="<?php echo e(asset('images/ABAKHQR.png')); ?>" style="width: 25px; height: 25px; margin-right: 8px;">
                            ${title}
                        </span>
                    `);
                }
            }, 50);
        });
    });
</script>


<script>
    document.addEventListener("DOMContentLoaded", function() {
        const applyBtn = document.getElementById("applyCouponCodeBtn");
        const amountToPayInput = document.getElementById("amountToPay");

        function togglePaymentUI() {
            const amountToPay = parseFloat(amountToPayInput.value) || 0;

            if (amountToPay <= 0) {
                // Hide payment buttons
                document.querySelectorAll(".proceed-to-payment").forEach(el => {
                    el.classList.add("d-none");
                });

                // Show switch plan
                document.querySelector(".switch-plan-btn").classList.remove("d-none");
            } else {
                // Show payment buttons
                document.querySelectorAll(".proceed-to-payment").forEach(el => {
                    el.classList.remove("d-none");
                });

                // Hide switch plan
                document.querySelector(".switch-plan-btn").classList.add("d-none");
            }
        }

        // Run check once on page load
        togglePaymentUI();

        // Run check again whenever Apply Coupon clicked
        if (applyBtn) {
            applyBtn.addEventListener("click", function() {
                togglePaymentUI();
            });
        }

        // Watch for manual changes (like coupon removed, or AJAX updates hidden input value)
        const observer = new MutationObserver(togglePaymentUI);
        observer.observe(amountToPayInput, {
            attributes: true,
            attributeFilter: ['value']
        });

        // Also catch direct input value changes (in case JS sets it)
        amountToPayInput.addEventListener("change", togglePaymentUI);
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const manualPaymentBtn = document.getElementById('manualPaymentBtn');
        const manualPaymentForm = document.querySelector('.manuallyPayAttachment');
        if (manualPaymentBtn && manualPaymentForm) {
            manualPaymentBtn.addEventListener('click', function() {
                manualPaymentForm.classList.toggle('d-none');
            });
        }
    });
</script>

<?php $__env->stopPush(); endif; ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\Ebizcard17-11-25\resources\views/subscription/payment_for_plan.blade.php ENDPATH**/ ?>