<?php ?>
<?php if($partName == 'basics'): ?>
    <?php if(isset($vcard)): ?>
        <input type="hidden" id="vcardId" value="<?php echo e($vcard->id); ?>">
    <?php endif; ?>
    <div class="row" id="basic">
        <div class="col-lg-12 mb-7">
            <?php echo e(Form::label('url_alias', __('messages.vcard.url_alias') . ':', ['class' => 'form-label required'])); ?>

            <span data-bs-toggle="tooltip" data-placement="top"
                data-bs-original-title="<?php echo e(__('messages.tooltip.the_main_url')); ?>">
                <i class="fas fa-question-circle ml-1 mt-1 general-question-mark"></i>
            </span>
            <div class="d-sm-flex">
                <div class="input-group">
                    <?php echo e(Form::text('url_alias', isset($vcard) ? $vcard->url_alias : null, [
                        'class' => 'form-control ms-1 vcard-url-alias',
                        'id' => 'vcard-url-alias',
                        'placeholder' => __('messages.form.my_vcard_url'),
                        isset($vcard->id) ? 'readonly' : '' => isset($vcard->id) ? true : false
                    ])); ?>

                    <?php if(!isset($vcard->id)): ?>
                        <button class="btn btn-secondary" type="button" id="generate-url-alias">
                            <i class="fa-solid fa-arrows-rotate"></i>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
            <div id="error-url-alias-msg" class="text-danger ms-2 fs-6 d-none fw-light">
                This URL Alias is already in use
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <?php echo e(Form::label('name', __('messages.vcard.vcard_name') . ':', ['class' => 'form-label required'])); ?>

            <?php echo e(Form::text('name', isset($vcard) ? $vcard->name : null, ['class' => 'form-control', 'placeholder' => __('messages.form.vcard_name'), 'required'])); ?>

        </div>
        <div class="col-lg-6 mb-7">
            <?php echo e(Form::label('occupation', __('messages.vcard.occupation') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('occupation', isset($vcard) ? $vcard->occupation : null, ['class' => 'form-control', 'placeholder' => __('messages.form.occupation')])); ?>

        </div>
        <div class="col-lg-6 mb-7">
            <div class="mb-5">
                <?php echo e(Form::label('description', __('messages.vcard.description') . ':', ['class' => 'form-label'])); ?>

                <div id="vcardDescriptionQuill" class="editor-height" style="height: 200px"></div>
                <?php echo e(Form::hidden('description', isset($vcard) ? $vcard->description : null, ['id' => 'vcardDescriptionData'])); ?>

            </div>
        </div>
        <div class="col-lg-3 col-sm-6 mb-7">
            <div class="mb-3" io-image-input="true">
                <label for="exampleInputImage"
                    class="form-label"><?php echo e(__('messages.vcard.profile_image') . ':'); ?></label>
                <div class="d-block">
                    <div class="image-picker">
                        <div class="image previewImage" id="exampleInputImage"
                            style="background-image: url('<?php echo e(!empty($vcard->profile_url) ? $vcard->profile_url : asset('web/media/avatars/150-26.jpg')); ?>')">
                        </div>
                        <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                            data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.profile')); ?>">
                            <label>
                                <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                <input type="file" id="profile_image" name="profile_img"
                                    class="image-upload file-validation d-none" accept="image/*" />
                            </label>
                        </span>

                        <!-- 🗑️ Delete icon -->
                        <?php if(!empty($vcard->profile_url)): ?>
                            <span type="button" class="profile_img_delete rounded-circle text-gray-500 fs-small"
                                onclick="deleteImage('<?php echo e(route('vcard.delete.profile_image')); ?>', '<?php echo e($vcard->id); ?>', 'profile')"
                                data-bs-toggle="tooltip" data-bs-original-title="Remove Profile Image">
                                <i class="fa-solid fa-trash"></i>
                            </span>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
            <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
        </div>
        <div class="col-lg-3 col-sm-6 mb-7">
            <div class="mb-3" io-image-input="true">
                <label for="exampleInputImage" class="form-label"><?php echo e(__('messages.vcard.cover_image') . ':'); ?></label>
                <div class="d-block">
                    <div class="image-picker">
                        <div class="image previewImage" id="exampleInputImage"
                            style="background-image: url('<?php echo e(!empty($vcard->cover_url) ? $vcard->cover_url : asset('assets/images/default_cover_image.jpg')); ?>')">
                        </div>
                        <span class="picker-edit rounded-circle text-gray-500 fs-small" data-bs-toggle="tooltip"
                            data-placement="top" data-bs-original-title="<?php echo e(__('messages.tooltip.cover')); ?>">
                            <label>
                                <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                <input type="file" id="profile_image" name="cover_img"
                                    class="image-upload file-validation d-none" accept="image/*" />
                            </label>
                        </span>

                        <!-- 🗑️ Delete icon -->
                        <?php if(!empty($vcard->cover_url)): ?>
                            <span type="button" class="cover_img_delete rounded-circle text-gray-500 fs-small"
                                onclick="deleteImage('<?php echo e(route('vcard.delete.cover_image')); ?>', '<?php echo e($vcard->id); ?>', 'cover')"
                                data-bs-toggle="tooltip" data-bs-original-title="Remove Cover Image">
                                <i class="fa-solid fa-trash"></i>
                            </span>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
            <div class="form-text"><?php echo e(__('messages.allowed_file_types')); ?></div>
        </div>
        <?php if(isset($vcard)): ?>
            <div class="mt-5 row">
                <h4 class="fw-bolder text-gray-800 mb-5"> <?php echo e(__('messages.vcard.vcard_details')); ?> </h4>
                <div class="col-md-6">
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('first_name', __('messages.vcard.first_name') . ':', ['class' => 'form-label required'])); ?>

                        <?php echo e(Form::text('first_name', isset($vcard) ? $vcard->first_name : null, ['class' => 'form-control', 'placeholder' => __('messages.form.f_name'), 'required'])); ?>

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('last_name', __('messages.vcard.last_name') . ':', ['class' => 'form-label required'])); ?>

                        <?php echo e(Form::text('last_name', isset($vcard) ? $vcard->last_name : null, ['class' => 'form-control', 'placeholder' => __('messages.form.l_name'), 'required'])); ?>

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('email', __('messages.user.email') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('email', isset($vcard) ? $vcard->email : null, ['class' => 'form-control', 'placeholder' => __('messages.form.email')])); ?>

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <?php echo e(Form::label('phone', __('messages.user.phone') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('phone', isset($vcard) ? (isset($vcard->region_code) ? '+' . $vcard->region_code . '' . $vcard->phone : $vcard->phone) : null, ['class' => 'form-control', 'placeholder' => __('messages.form.phone'), 'id' => 'phoneNumber', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")'])); ?>

                        <?php echo e(Form::hidden('region_code', isset($vcard) ? $vcard->region_code : null, ['id' => 'prefix_code'])); ?>

                        <div class="mt-2">
                            <span id="valid-msg"
                                class="text-success d-none fw-400 fs-small mt-2"><?php echo e(__('messages.placeholder.valid_number')); ?></span>
                            <span id="error-msg" class="text-danger d-none fw-400 fs-small mt-2">Invalid Number</span>
                        </div>
                    </div>
                </div>
                <div class='col-md-6 col-lg-6 col-sm-6 col-12'>
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('alternative_email', __('messages.vcard.alternate_email') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('alternative_email', isset($vcard) ? $vcard->alternative_email : null, ['class' => 'form-control', 'placeholder' => __('messages.vcard.alternate_email')])); ?>

                    </div>
                </div>
                <div class='col-md-6 col-lg-6 col-sm-6 col-12'>
                    <div class="form-group">
                        <?php echo e(Form::label('alternative_phone', __('messages.vcard.alternative_phone') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('alternative_phone', isset($vcard) ? (isset($vcard->alternative_region_code) ? '+' . $vcard->alternative_region_code . '' . $vcard->alternative_phone : $vcard->alternative_phone) : null, ['class' => 'form-control', 'placeholder' => __('messages.vcard.alternative_phone'), 'id' => 'alternativePhone', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")'])); ?>

                        <?php echo e(Form::hidden('alternative_region_code', isset($vcard) ? $vcard->alternative_region_code : null, ['id' => 'alternative_prefix_code'])); ?>

                        <div class="mt-2">
                            <span id="alter-valid-msg"
                                class="text-success d-none fw-400 fs-small mt-2"><?php echo e(__('messages.placeholder.valid_number')); ?></span>
                            <span id="alter-error-msg" class="text-danger d-none fw-400 fs-small mt-2">Invalid
                                Number</span>
                        </div>
                    </div>
                </div>
                <div class='col-md-6 col-lg-6 col-sm-6 col-12'>
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('whatsapp_number', __('messages.vcard.whatsapp_number') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('whatsapp_number', isset($vcard) ? (isset($vcard->whatsapp_region_code) ? '+' . $vcard->whatsapp_region_code . '' . $vcard->whatsapp_number : $vcard->whatsapp_number) : null, ['class' => 'form-control', 'placeholder' => __('messages.vcard.whatsapp_number'), 'id' => 'whatsappNumber', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")'])); ?>

                        <?php echo e(Form::hidden('whatsapp_region_code', isset($vcard) ? $vcard->whatsapp_region_code : null, ['id' => 'whatsapp_prefix_code'])); ?>

                    </div>
                </div>


                <div class='col-md-6 col-lg-6 col-sm-6 col-12'>
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('telegram_number', __('messages.vcard.telegram_number') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('telegram_number', isset($vcard) ? $vcard->telegram_number : null, ['class' => 'form-control', 'placeholder' => __('messages.vcard.telegram_number')])); ?>

                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('location', __('messages.user.location') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::textarea('location', isset($vcard) ? $vcard->location : null, ['class' => 'form-control', 'placeholder' => __('messages.form.location'), 'rows' => '1'])); ?>

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group mb-7">
                        <?php echo e(Form::label('location_url', __('messages.setting.location_url') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('location_url', isset($vcard) ? $vcard->location_url : null, ['class' => 'form-control', 'placeholder' => __('messages.form.location_url')])); ?>

                    </div>
                </div>
                <div class="col-lg-6 mb-7">
                    <?php echo e(Form::label('dob', __('messages.vcard.date_of_birth') . ':', ['class' => 'form-label'])); ?>

                    <?php echo e(Form::text('dob', isset($vcard) ? $vcard->dob : null, ['class' => 'form-control bg-white', 'placeholder' => __('messages.form.DOB')])); ?>

                </div>
                <div class="col-lg-6 mb-7">
                    <?php echo e(Form::label('company', __('messages.vcard.company') . ':', ['class' => 'form-label'])); ?>

                    <?php echo e(Form::text('company', isset($vcard) ? $vcard->company : null, ['class' => 'form-control', 'placeholder' => __('messages.form.company')])); ?>

                </div>
                <?php if(checkFeature('advanced')): ?>
                    <?php if(checkFeature('advanced')->hide_branding): ?>
                        <div class="col-lg-6 mb-7">
                            <?php echo e(Form::label('made_by', __('messages.made_by') . ':', ['class' => 'form-label'])); ?>

                            <?php echo e(Form::text('made_by', isset($vcard) ? $vcard->made_by : null, ['class' => 'form-control', 'placeholder' => __('messages.made_by')])); ?>

                        </div>
                        <div class="col-lg-6 mb-7">
                            <?php echo e(Form::label('made_by_url', __('messages.made_by_url') . ':', ['class' => 'form-label'])); ?>

                            <?php echo e(Form::text('made_by_url', isset($vcard) ? $vcard->made_by_url : null, ['class' => 'form-control', 'placeholder' => __('messages.made_by_url')])); ?>

                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <!--<div class="col-lg-6 mb-7">-->
                <!--    <?php echo e(Form::label('job_title', __('messages.vcard.job_title') . ':', ['class' => 'form-label'])); ?>-->
                <!--    <?php echo e(Form::text('job_title', isset($vcard) ? $vcard->job_title : null, ['class' => 'form-control', 'placeholder' => __('messages.form.job')])); ?>-->
                <!--</div>-->
                <div class="col-lg-12 mb-7">
                    <div class="d-flex">
                        <?php echo e(Form::label('default_language', __('messages.setting.default_language') . ':', ['class' => 'form-label'])); ?>

                    </div>
                    <div class="form-group">
                        <?php echo e(Form::select('default_language', getAllLanguage(), isset($vcard) ? $vcard->default_language : null, ['class' => 'form-control', 'data-control' => 'select2'])); ?>

                    </div>
                </div>
                <div class="col-lg-6 mb-7">
                    <div class="d-flex">
                        <?php echo e(Form::label('language_enable', __('messages.vcard.language_enable') . ':', ['class' => 'form-label'])); ?>

                        <div class="mx-4">
                            <div
                                class="form-check form-switch form-check-custom form-check-solid form-switch-sm col-6">
                                <div class="fv-row d-flex align-items-center">
                                    <?php echo e(Form::checkbox('language_enable', 1, $vcard['language_enable'] ?? 0, ['class' => 'form-check-input mt-0 ', 'id' => 'languageEnable'])); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mb-7">
                    <div class="d-flex">
                        <?php echo e(Form::label('enable_enquiry_form', __('messages.vcard.enable_enquiry_form') . ':', ['class' => 'form-label'])); ?>

                        <div class="mx-4">
                            <div
                                class="form-check form-switch form-check-custom form-check-solid form-switch-sm col-6">
                                <div class="fv-row d-flex align-items-center">
                                    <?php echo e(Form::checkbox('enable_enquiry_form', 1, $vcard['enable_enquiry_form'] ?? 0, ['class' => 'form-check-input mt-0 ', 'id' => 'enableEnquiryForm'])); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 mb-7">
                    <div class="d-flex">
                        <?php echo e(Form::label('enable_download_qr_code', __('messages.vcard.enable_download_qr_code') . ':', ['class' => 'form-label'])); ?>

                        <div class="mx-4">
                            <div
                                class="form-check form-switch form-check-custom form-check-solid form-switch-sm col-6">
                                <div class="fv-row d-flex align-items-center">
                                    <?php echo e(Form::checkbox('enable_download_qr_code', 1, $vcard['enable_download_qr_code'] ?? 0, ['class' => 'form-check-input mt-0 ', 'id' => 'enableDownloadQrCode'])); ?>

                                </div>
                            </div>
                        </div>
                    </div><br>
                    <div class="d-flex">
                        <?php echo e(Form::label('show_qr_code', __('messages.vcard.show_qr_code') . ':', ['class' => 'form-label'])); ?>

                        <div class="mx-3">
                            <div
                                class="form-check form-switch form-check-custom form-check-solid form-switch-sm col-6">
                                <div class="fv-row d-flex align-items-center">
                                    <?php echo e(Form::checkbox('show_qr_code', 1, $vcard['show_qr_code'] ?? 0, ['class' => 'form-check-input mt-0 ', 'id' => 'enableQrCode'])); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mb-7">
                    <label for="qrCodeDownloadSize"
                        class="form-label"><?php echo e(__('messages.vcard.qr_code_download_size') . ':'); ?></label>
                    <div class="d-flex align-items-center">
                        <input type="range" name="qr_code_download_size" class="form-range w-50 mx-2"
                            value="<?php echo e($vcard['qr_code_download_size']); ?>" min="100" max="500"
                            step="100" id="qrCodeDownloadSize"
                            oninput="document.getElementById('download-result').innerText = this.value+'px'"> <span
                            id="download-result"><?php echo e($vcard['qr_code_download_size'] . 'px'); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="d-flex">
            <?php echo e(Form::submit(__('messages.common.save'), ['class' => 'btn btn-primary me-3', 'id' => 'vcardSaveBtn'])); ?>

            <a href="<?php echo e(route('vcards.index')); ?>" class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
    </div>
<?php endif; ?>

<?php if($partName == 'templates'): ?>
    <div class="col-lg-12 mb-3">
        <input type="hidden" name="part" value="<?php echo e($partName); ?>">
        <label class="form-label required"><?php echo e(__('messages.vcard.select_template')); ?>

            :</label>
    </div>
    <div class="form-group mb-7 vcard-template">
        <div class="row">
            <input type="hidden" name="template_id" id="templateId" value="<?php echo e($vcard->template_id); ?>">
            <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 mb-3" style="width: 20%">
                    <div class="img-radio img-thumbnail <?php echo e($id == 11 ? 'screen vcard_11' : ''); ?> <?php echo e($vcard->template_id == $id ? 'img-border' : ''); ?>"
                        data-id="<?php echo e($id); ?>">
                        <img src="<?php echo e($url); ?>" alt="Template">
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <div class="col-lg-12 mt-5 mb-5">
        <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" id="vcardTemplateStatus" name="status"
                <?php echo e($vcard->status ? 'checked' : ''); ?>>
            <label class="form-check-label" for="vcardTemplateStatus">
                <?php echo e(__('messages.common.active')); ?>

            </label>
        </div>
    </div>
    <div class="col-lg-12 mt-2 d-flex">
        <button class="btn btn-primary me-3 template-save">
            <?php echo e(__('messages.common.save')); ?>

        </button>
        <a href="<?php echo e(route('vcards.index')); ?>" class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
    </div>
<?php endif; ?>

<?php if($partName === 'business-hours'): ?>
    <div class="row">
        <input type="hidden" name="part" value="<?php echo e($partName); ?>">
        <div class="col-12 mb-4 d-flex flex-wrap align-items-center gap-4">
            <div class="form-check d-flex align-items-center me-4">
                <input class="form-check-input feature mx-2" type="checkbox" id="selectAllDays">
                <label class="form-check-label mb-0" for="selectAllDays"><strong>Select All Days</strong></label>
            </div>

            <div class="d-flex align-items-center">
                <label class="me-2 mb-0">Start Time:</label>
                <div style="width: 130px;">
                    <select id="sharedStartTime" class="form-control" data-control="select2">
                        <?php $__currentLoopData = getSchedulesTimingSlot(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($time); ?>"><?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label class="ms-3 me-2 mb-0">End Time:</label>
                <div style="width: 130px;">
                    <select id="sharedEndTime" class="form-control" data-control="select2">
                        <?php $__currentLoopData = getSchedulesTimingSlot(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($time); ?>"><?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <?php $__currentLoopData = \App\Models\BusinessHour::DAY_OF_WEEK; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xxl-6 mb-7 d-sm-flex align-items-center mb-3">
                <div class="col-xl-4 col-lg-4 col-md-2 col-4">
                    <label class="form-check">
                        <input class="form-check-input feature mx-2" type="checkbox" value="<?php echo e($key); ?>"
                            name="days[]" <?php echo e(!empty($hours[$key]) ? 'checked' : ''); ?> />
                        <?php echo e(strtoupper(__('messages.business.' . $day))); ?>

                    </label>
                </div>
                <div class="col-xl-8 col-lg-3 col-3 d-flex align-items-center buisness_end">
                    <div class="d-inline-block">
                        <?php echo e(Form::select('startTime[' . $key . ']', getSchedulesTimingSlot(), isset($hours[$key]) ? $hours[$key]['start_time'] : null, ['class' => 'form-control', 'data-control' => 'select2'])); ?>

                    </div>
                    <span class="px-3">To</span>
                    <div class="d-inline-block">
                        <?php echo e(Form::select('endTime[' . $key . ']', getSchedulesTimingSlot(), isset($hours[$key]) ? $hours[$key]['end_time'] : null, ['class' => 'form-control', 'data-control' => 'select2'])); ?>

                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-12 mt-2 d-flex">
            <button class="btn btn-primary me-3">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>" class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
<?php endif; ?>

<?php if($partName == 'appointments'): ?>
    <div class="col-12">
        <table class="table table-striped mt-lg-4">
            <tbody>
                <input type="hidden" name="part" value="<?php echo e($partName); ?>">
                <?php $__currentLoopData = App\Models\BusinessHour::WEEKDAY_NAME; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day => $shortWeekDay): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="weekly-content" data-day="<?php echo e($day); ?>">
                                <div class="d-flex w-100 align-items-center position-relative">
                                    <div class="d-flex row flex-md-row flex-column w-100 weekly-row">
                                        <div class="col-xl-2 form-check mb-0 d-flex align-items-center ms-5">
                                            <input id="chkShortWeekDay_<?php echo e($shortWeekDay); ?>" class="form-check-input"
                                                type="checkbox" value="<?php echo e($day); ?>"
                                                name="checked_week_days[]" <?php echo e(!empty($time[$day]) ? 'checked' : ''); ?>>
                                            <label class="form-label mb-0 me-2"
                                                for="chkShortWeekDay_<?php echo e($shortWeekDay); ?>">
                                                <span
                                                    class="ms-4 d-md-block"><?php echo e(strtoupper(__('messages.business.' . strtolower($shortWeekDay)))); ?></span>
                                            </label>
                                        </div>
                                        <div class="col-xl-8 session-times">
                                            <?php echo $__env->make('vcards.appointment.slot', ['day' => $day], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    </div>
                                    <div class="weekly-icon position-absolute end-0 d-flex">
                                        <a href="javascript:void(0)" class="add-session-time"
                                            id="add-session-<?php echo e($day); ?>" data-day="<?php echo e($day); ?>"
                                            data-bs-toggle="tooltip" title="<?php echo e(__('messages.common.add')); ?>">
                                            <i class="fa fa-plus text-primary me-5 fs-2 mb-3" aria-hidden="true"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <p class="ms-1 fw-bold"><?php echo e(__('messages.appointment.appointment_type')); ?></p>
        <div class="weekly-icon end-0 d-flex py-4 px-0 ">
            <?php if(isset($appointmentDetail->is_paid)): ?>
                <button type="button"
                    class="btn me-3 <?php echo e($appointmentDetail->is_paid == 0 ? 'btn-primary' : 'btn-light btn-active-light-primary'); ?>"
                    id="freeButton"><?php echo e(__('messages.appointment.free')); ?></button>
                <button type="button"
                    class="btn me-3 <?php echo e($appointmentDetail->is_paid == 1 ? 'btn-primary' : 'btn-light btn-active-light-primary'); ?>"
                    id="paidButton"><?php echo e(__('messages.appointment.paid')); ?></button>
                <input type="hidden" id="isUserPaidId" name="is_paid" value="<?php echo e($appointmentDetail->is_paid); ?>">
            <?php else: ?>
                <button type="button" class="btn me-3 btn-primary"
                    id="freeButton"><?php echo e(__('messages.appointment.free')); ?></button>
                <button type="button" class="btn me-3 btn-light btn-active-light-primary"
                    id="paidButton"><?php echo e(__('messages.appointment.paid')); ?></button>
                <input type="hidden" id="isUserPaidId" name="is_paid" value="0">
            <?php endif; ?>
        </div>
        <div class="card-body px-0 pt-0">
            <div class="row <?php echo e(isset($appointmentDetail->is_paid) && $appointmentDetail->is_paid == 1 ? '' : 'd-none'); ?>"
                id="userPaidInputDiv">
                <div class="col-12">
                    <div class="row">
                        <div class="form-group col-sm-6 px-3">
                            <?php echo e(Form::label('price', __('messages.subscription.amount') . ':', ['class' => 'form-label required'])); ?>

                            <?php if(isset($appointmentDetail)): ?>
                                <?php echo e(Form::number('price', $appointmentDetail->price, ['class' => 'form-control', $appointmentDetail->is_paid == 1 ? 'required' : '', 'id' => 'userPaymentAmount', 'placeholder' => __('messages.subscription.amount'), 'min' => '0'])); ?>

                            <?php else: ?>
                                <?php echo e(Form::number('price', null, ['class' => 'form-control', 'id' => 'userPaymentAmount', 'placeholder' => __('Amount'), 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")', 'min' => '0'])); ?>

                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 d-flex">
            <button type="submit" class="btn btn-primary me-3">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>"
                class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
    </div>
<?php endif; ?>

<?php if($partName == 'social-links'): ?>
    <p><?php echo e(__('messages.setting.note')); ?></p>
    <input type="hidden" name="part" value="<?php echo e($partName); ?>">
    <div class="row social-links-add">
        <div class="col-12 mb-7 d-flex justify-content-end">
            <button type="button" class="btn btn-primary social-links"><?php echo e(__('messages.common.add')); ?></button>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fas fa-globe fa-2x text-primary mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('website', isset($socialLink) ? $socialLink->website : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.website'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-twitter fa-2x text-primary mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('twitter', isset($socialLink) ? $socialLink->twitter : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.twitter'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-facebook-square fa-2x text-primary mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('facebook', isset($socialLink) ? $socialLink->facebook : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.facebook'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-instagram fa-2x text-danger mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('instagram', isset($socialLink) ? $socialLink->instagram : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.instagram'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-reddit-alien fa-2x text-danger mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('reddit', isset($socialLink) ? $socialLink->reddit : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.reddit'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-tumblr-square fa-2x text-dark mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('tumblr', isset($socialLink) ? $socialLink->tumblr : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.tumblr'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-youtube fa-2x text-danger mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('youtube', isset($socialLink) ? $socialLink->youtube : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.youtube'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-linkedin fa-2x text-primary mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('linkedin', isset($socialLink->linkedin) ? $socialLink->linkedin : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.linkedin'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-pinterest fa-2x text-danger mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('pinterest', isset($socialLink) ? $socialLink->pinterest : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.pinterest'),
                    ]); ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-7">
            <div class="row">
                <div class="col-sm-1 mb-3 mb-sm-0">
                    <i class="fab fa-tiktok fa-2x text-danger mt-3 me-3"></i>
                </div>
                <div class="col-sm-11">
                    <?php echo Form::text('tiktok', isset($socialLink) ? $socialLink->tiktok : null, [
                        'class' => 'form-control',
                        'placeholder' => __('messages.form.tiktok'),
                    ]); ?>

                </div>
            </div>
        </div>

        <?php $__currentLoopData = $socialLink->icon; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-6 mb-7 social-links-div">
                <div class="d-flex">
                    <div class="mb-3 mb-sm-0 me-3">
                        <div class="" io-image-input="true">
                            <div class="    ">
                                <div class="image-picker">
                                    <div class="image previewImage " id="exampleInputImage"
                                        style="background-image: url('<?php echo $link->social_icon ?? 'https://cdn-icons-png.flaticon.com/512/87/87390.png'; ?> ') ;width: 40px; height: 40px">
                                    </div>
                                    <span class="picker-edit rounded-circle text-gray-500 fs-small"
                                        data-bs-toggle="tooltip" data-placement="top"
                                        data-bs-original-title="<?php echo e(__('messages.tooltip.profile')); ?>"
                                        style="width: 22px; height: 22px">
                                        <label>
                                            <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                            <input type="file" id="profile_image"
                                                name="social_links_image[<?php echo e($key); ?>]"
                                                class="image-upload file-validation d-none social_links_image"
                                                accept="image/*" value="<?php echo e($link->social_icon); ?>" />
                                        </label>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex ml-2 w-100">
                        <input type="text" class="form-control social_links"
                            name="social_links[<?php echo e($key); ?>]" value="<?php echo e($link->link); ?>">
                        <input type="hidden" name="social_link_id[<?php echo e($key); ?>]" class="socialLinkId"
                            value="<?php echo e($link->id); ?>">
                        <a href="javascript:void(0)" title="<?php echo e(__('messages.common.delete')); ?>"
                            class="btn px-1 text-danger fs-3 social-links-delete-btn">
                            <i class="fa-solid fa-trash"></i>
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="col-lg-12 d-flex">
        <button type="button" class="btn btn-primary me-3 social_link_save">
            <?php echo e(__('messages.common.save')); ?>

        </button>
        <a href="<?php echo e(route('vcards.index')); ?>" class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
    </div>

<?php endif; ?>

<?php if($partName == 'advanced'): ?>
    <div class="row">
        <input type="hidden" name="part" value="<?php echo e($partName); ?>">
        <?php if(checkFeature('advanced')->password): ?>
            <div class="col-lg-6 mb-7">
                <label class="form-label"><?php echo e(__('messages.user.password') . ':'); ?></label>
                <div class="position-relative mb-3">
                    <div class="mb-3 position-relative">
                        <input class="form-control" type="password"
                            placeholder="<?php echo e(__('messages.form.password')); ?>" name="password"
                            value="<?php echo e(!empty($vcard->password) ? Crypt::decrypt($vcard->password) : ''); ?>"
                            autocomplete="off" aria-label="Password" data-toggle="password" />
                        <span
                            class="position-absolute d-flex align-items-center top-0 bottom-0 end-0 me-4 input-icon input-password-hide cursor-pointer text-gray-600">
                            <i class="bi bi-eye-slash-fill"></i>
                        </span>
                    </div>
                    <div class="d-flex align-items-center mb-3"></div>
                </div>
            </div>
        <?php endif; ?>

        <?php if(checkFeature('advanced')->custom_css): ?>
            <div class="col-lg-12 mb-7">
                <?php echo e(Form::label('custom_css', __('messages.vcard.custom_css') . ':', ['class' => 'form-label'])); ?>

                <?php echo e(Form::textarea('custom_css', isset($vcard) ? $vcard->custom_css : null, ['class' => 'form-control', 'placeholder' => __('messages.form.css'), 'rows' => '5'])); ?>

            </div>
        <?php endif; ?>

        <?php if(checkFeature('advanced')->custom_js): ?>
            <div class="col-lg-12 mb-7">
                <?php echo e(Form::label('custom_js', __('messages.vcard.custom_js') . ':', ['class' => 'form-label'])); ?>

                <?php echo e(Form::textarea('custom_js', isset($vcard) ? $vcard->custom_js : null, ['class' => 'form-control', 'placeholder' => __('messages.form.js'), 'rows' => '5'])); ?>

            </div>
        <?php endif; ?>

        <?php if(checkFeature('advanced')->hide_branding): ?>
            <div class="col-lg-6 mb-7">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="branding" name="branding"
                        <?php echo e($vcard->branding ? 'checked' : ''); ?>>
                    <label class="form-label" for="branding">
                        <?php echo e(__('messages.vcard.remove_branding')); ?>

                    </label>
                    <span data-bs-toggle="tooltip" data-placement="top"
                        data-bs-original-title="<?php echo e(__('messages.tooltip.remove_branding')); ?>">
                        <i class="fas fa-question-circle ml-1 mt-1 general-question-mark"></i>
                    </span>
                </div>
            </div>
        <?php endif; ?>

        <div class="col-lg-12 d-flex">
            <button type="submit" class="btn btn-primary me-3">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>"
                class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
    </div>
<?php endif; ?>

<?php if($partName == 'custom-fonts'): ?>
    <div class="row">
        <div class="col-lg-6 mb-7">
            <?php echo e(Form::label('font_family', __('messages.font.font_family') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::select(
                'font_family',
                \App\Models\Vcard::FONT_FAMILY,
                \App\Models\Vcard::FONT_FAMILY[$vcard->font_family],
                ['class' => 'form-select', 'data-control' => 'select2'],
            )); ?>

        </div>
        <div class="col-lg-6 mb-7">
            <?php echo Form::label('font_size', __('messages.font.font_size') . ':', ['class' => 'form-label']); ?>


            <?php echo Form::number('font_size', $vcard->font_size, [
                'class' => 'form-control',
                'min' => '14',
                'max' => '40',
                'placeholder' => __('messages.font.font_size_in_px'),
            ]); ?>

        </div>
        <div class="col-lg-12 d-flex">
            <button type="submit" class="btn btn-primary me-3">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>"
                class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
<?php endif; ?>

<?php if($partName == 'seo'): ?>
    <div class="row">
        <div class="col-lg-6 mb-7">
            <?php echo e(Form::label('Site title', __('messages.vcard.site_title') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('site_title', isset($vcard) ? $vcard->site_title : null, ['class' => 'form-control', 'placeholder' => __('messages.form.site_title')])); ?>

        </div>
        <div class="col-lg-6 mb-7">
            <?php echo e(Form::label('Home title', __('messages.vcard.home_title') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('home_title', isset($vcard) ? $vcard->home_title : null, ['class' => 'form-control', 'placeholder' => __('messages.form.home_title')])); ?>

        </div>
        <div class="col-lg-6 mb-7">
            <?php echo e(Form::label('Meta keyword', __('messages.vcard.meta_keyword') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('meta_keyword', isset($vcard) ? $vcard->meta_keyword : null, ['class' => 'form-control', 'placeholder' => __('messages.form.meta_keyword')])); ?>

        </div>
        <div class="col-lg-6 mb-7">
            <?php echo e(Form::label('Meta Description', __('messages.vcard.meta_description') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('meta_description', isset($vcard) ? $vcard->meta_description : null, ['class' => 'form-control', 'placeholder' => __('messages.form.meta_description')])); ?>

        </div>
        <div class="col-lg-12 mb-7">
            <?php echo e(Form::label('Google Analytics', __('messages.vcard.google_analytics') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::textarea('google_analytics', isset($vcard) ? $vcard->google_analytics : null, ['class' => 'form-control', 'placeholder' => __('messages.form.google_analytics')])); ?>

        </div>
        <div class="col-lg-12 d-flex">
            <button type="submit" class="btn btn-primary me-3">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>"
                class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
<?php endif; ?>

<?php if($partName == 'privacy-policy'): ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="mb-5">
                <input type="hidden" name="part" value="<?php echo e($partName); ?>" id="privacyPolicyPartName">
                <?php echo e(Form::hidden('id', isset($privacyPolicy) ? $privacyPolicy->id : null, ['id' => 'privacyPolicyId'])); ?>

                <?php echo e(Form::label('privacy_policy', __('messages.vcard.privacy_policy') . ':', ['class' => 'form-label'])); ?>

                <div id="privacyPolicyQuill" class="editor-height" style="height: 200px"></div>
                <?php echo e(Form::hidden('privacy_policy', isset($privacyPolicy) ? $privacyPolicy->privacy_policy : null, ['id' => 'privacyData'])); ?>

            </div>
        </div>
        <div class="col-lg-12 d-flex">
            <button type="submit" class="btn btn-primary me-3" id="privacyPolicySave">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>"
                class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
    </div>
<?php endif; ?>

<?php if($partName == 'term-condition'): ?>
    <div class="row">
        <input type="hidden" name="part" value="<?php echo e($partName); ?>" id="termConditionPartName">
        <div class="col-lg-12">
            <div class="mb-5">
                <?php echo e(Form::hidden('id', isset($termCondition) ? $termCondition->id : null, ['id' => 'termConditionId'])); ?>

                <?php echo e(Form::label('term_condition', __('messages.vcard.term_condition') . ':', ['class' => 'form-label'])); ?>

                <div id="termConditionQuill" class="editor-height" style="height: 200px"></div>
                <?php echo e(Form::hidden('term_condition', isset($termCondition) ? $termCondition->term_condition : null, ['id' => 'conditionData'])); ?>

            </div>
        </div>
        <div class="col-lg-12 d-flex">
            <button type="submit" class="btn btn-primary me-3" id="termConditionSave">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>"
                class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
    </div>
<?php endif; ?>

<?php if($partName == 'qrcode-customize'): ?>
    <input type="hidden" name="part" value="<?php echo e($partName); ?>" id="qrcodeCustmizePartName">
    <div class="container">
        <div class="row">
            <div class="col order-first">
                <?php echo e(Form::label('QR-Code Color', __('messages.vcard.qrcode_color') . ':', ['class' => 'form-label'])); ?>

                <?php echo e(Form::color('qrcode_color', isset($customQrCode['qrcode_color']) ? $customQrCode['qrcode_color'] : null, ['class' => 'form-control form-control-color w-50 mb-2', 'id' => 'qrcode_color'])); ?>


                
                <label for="qrcode_opacity" class="form-label"><?php echo e(__('messages.vcard.qrcode_opacity')); ?>:</label>
                <input type="range" class="form-range mb-3" min="0" max="1" step="0.1"
                       name="qrcode_opacity" id="qrcode_opacity"
                       value="<?php echo e(isset($customQrCode['qrcode_opacity']) ? $customQrCode['qrcode_opacity'] : '1'); ?>">
                <small class="text-muted">Opacity: <span id="qrcode_opacity_value"><?php echo e(isset($customQrCode['qrcode_opacity']) ? $customQrCode['qrcode_opacity'] : '1'); ?></span></small>
            </div>
            <div class="col">
                <?php echo e(Form::label('Background Color', __('messages.vcard.back_color') . ':', ['class' => 'form-label'])); ?>

                <?php echo e(Form::color('background_color', isset($customQrCode['background_color']) ? $customQrCode['background_color'] : null, ['class' => 'form-control form-control-color w-50 mb-2', 'id' => 'background_color'])); ?>


                
                <label for="background_opacity" class="form-label"><?php echo e(__('messages.vcard.background_opacity')); ?>:</label>
                <input type="range" class="form-range mb-3" min="0" max="1" step="0.1"
                       name="background_opacity" id="background_opacity"
                       value="<?php echo e(isset($customQrCode['background_opacity']) ? $customQrCode['background_opacity'] : '1'); ?>">
                <small class="text-muted">Opacity: <span id="background_opacity_value"><?php echo e(isset($customQrCode['background_opacity']) ? $customQrCode['background_opacity'] : '1'); ?></span></small>
            </div>
            <div class="col order-last form-check form-switch mt-8">
                <input class="form-check-input" name="applySetting" type="checkbox" id="flexSwitchCheckChecked"
                    <?php echo e(isset($customQrCode['applySetting']) ? ($customQrCode['applySetting'] == 1 ? 'checked' : '') : ''); ?>>
                <label class="form-check-label"
                    for="flexSwitchCheckChecked"><?php echo e(__('messages.common.apply_changes')); ?></label>
            </div>
        </div>
        <div class="row">
            <div class="mb-5">
                <label for="exampleInputSelect2" class="form-label"><?php echo e(__('messages.vcard.qrcode_style')); ?></label>
                <?php echo e(Form::select('style', App\Models\QrcodeEdit::QRCODE_STYLE, isset($customQrCode['style']) ? $customQrCode['style'] : null, ['class' => 'form-control form-select', 'data-control' => 'select2', 'id' => 'qrcodeStyle', 'wire:ignore'])); ?>

            </div>
            <div class="mb-5">
                <label for="exampleInputSelect2"
                    class="form-label"><?php echo e(__('messages.vcard.qrcode_eye_style')); ?></label>
                <?php echo e(Form::select('eye_style', App\Models\QrcodeEdit::QRCODE_EYE_STYLE, isset($customQrCode['eye_style']) ? $customQrCode['eye_style'] : null, ['class' => 'form-control form-select', 'data-control' => 'select2', 'id' => 'qrcodeEyeStyle', 'wire:ignore'])); ?>

            </div>
            <div class="col-lg-12">
                <div class="col-lg-12 d-flex">
                    <button type="submit" class="btn btn-primary me-3" id="custmizationSave">
                        <?php echo e(__('messages.common.save')); ?>

                    </button>
                    <a href="<?php echo e(route('vcards.index')); ?>"
                        class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
                </div>
            </div>
        </div>
    </div>

    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const qrcodeOpacitySlider = document.getElementById('qrcode_opacity');
            const backgroundOpacitySlider = document.getElementById('background_opacity');
            const qrcodeOpacityValue = document.getElementById('qrcode_opacity_value');
            const backgroundOpacityValue = document.getElementById('background_opacity_value');

            qrcodeOpacitySlider.addEventListener('input', function() {
                qrcodeOpacityValue.textContent = this.value;
            });

            backgroundOpacitySlider.addEventListener('input', function() {
                backgroundOpacityValue.textContent = this.value;
            });
        });
    </script>
<?php endif; ?>
<?php if($partName == 'manage-section'): ?>
    <div class="col-12">
        <input type="hidden" name="part" value="<?php echo e($partName); ?>">
        <div class="row">
            <div class="col-6">
                <input id="" class="form-check-input" type="checkbox" value="1"
                    name="header" checked disabled>
                <label class="form-label mb-0 me-2" for="">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.header'); ?></span>
                </label>
            </div>
            <div class="col-6">
                <input id="contactListCheckbox" class="form-check-input" type="checkbox" value="1" name="contact_list" <?php echo e((isset($managesection) && ($managesection['contact_list'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="contactListCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.contact'); ?></span>
                </label>
            </div>
        </div>
        <div class="row mt-5">
            <div class="col-6">
                <input id="servicesCheckbox" class="form-check-input" type="checkbox" value="1" name="services" <?php echo e((isset($managesection) && ($managesection['services'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="servicesCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.services'); ?></span>
                </label>
            </div>
            <div class="col-6">
                <input id="galleriesCheckbox" class="form-check-input" type="checkbox" value="1" name="galleries" <?php echo e((isset($managesection) && ($managesection['galleries'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="galleriesCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.galleries'); ?></span>
                </label>
            </div>
        </div>
        <div class="row mt-5">
            <div class="col-6">
                <input id="productsCheckbox" class="form-check-input" type="checkbox" value="1" name="products" <?php echo e((isset($managesection) && ($managesection['products'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="productsCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.products'); ?></span>
                </label>
            </div>
            <div class="col-6">
                <input id="testimonialsCheckbox" class="form-check-input" type="checkbox" value="1" name="testimonials" <?php echo e((isset($managesection) && ($managesection['testimonials'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="testimonialsCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.testimonials'); ?></span>
                </label>
            </div>
        </div>
        <div class="row mt-5">
            <div class="col-6">
                <input id="blogsCheckbox" class="form-check-input" type="checkbox" value="1" name="blogs" <?php echo e((isset($managesection) && ($managesection['blogs'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="blogsCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.blogs'); ?></span>
                </label>
            </div>
            <div class="col-6">
                <input id="businessHoursCheckbox" class="form-check-input" type="checkbox" value="1" name="business_hours" <?php echo e((isset($managesection) && ($managesection['business_hours'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="businessHoursCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.business_hours'); ?></span>
                </label>
            </div>
        </div>
        <div class="row mt-5">
            <div class="col-6">
                <input id="appointmentsCheckbox" class="form-check-input" type="checkbox" value="1" name="appointments" <?php echo e((isset($managesection) && ($managesection['appointments'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="appointmentsCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.appointments'); ?></span>
                </label>
            </div>
            <div class="col-6">
                <input id="mapCheckbox" class="form-check-input" type="checkbox" value="1" name="map" <?php echo e((isset($managesection) && ($managesection['map'])) || empty($managesection) ? 'checked' : ''); ?>>
                <label class="form-label mb-0 me-2" for="mapCheckbox">
                    <span class="ms-4 d-md-block"><?php echo __('messages.vcard.map'); ?></span>
                </label>
            </div>
        </div>
        <div class="col-lg-12 d-flex mt-5">
            <button type="submit" class="btn btn-primary me-3">
                <?php echo e(__('messages.common.save')); ?>

            </button>
            <a href="<?php echo e(route('vcards.index')); ?>"
                class="btn btn-secondary"><?php echo e(__('messages.common.discard')); ?></a>
        </div>
    </div>
<?php endif; ?>

<?php if($partName == 'privacy-section'): ?>
<div class="col-lg-12 mb-7">
    <div class="card">
        <div class="card-body">
            <input type="hidden" id="vcardId" value="<?php echo e($vcard->id); ?>">
            
            <ul class="nav nav-tabs privacy-tabs mb-4" id="privacyTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link privacy-link active" id="lock-tab" data-bs-toggle="tab" data-bs-target="#lockTab" type="button" role="tab" aria-controls="lockTab" aria-selected="true">
                        Lock My Profile
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link privacy-link" id="share-tab" data-bs-toggle="tab" data-bs-target="#shareTab" type="button" role="tab" aria-controls="shareTab" aria-selected="false">
                        Share Link
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link privacy-link" id="cat-tab" data-bs-toggle="tab" data-bs-target="#catTab" type="button" role="tab" aria-controls="catTab" aria-selected="false">
                        Card Access Token
                    </button>
                </li>
            </ul>

            
            <div class="tab-content" id="privacyTabContent">

                
                <div class="tab-pane fade show active" id="lockTab" role="tabpanel" aria-labelledby="lock-tab">
                    <div class="d-flex align-items-center mb-4">
                        <span class="fs-3 me-3"><?php echo e(__('messages.setting.privacy')); ?></span>
                        <label class="form-switch">
                            <input type="checkbox" name="is_locked" class="form-check-input" value="1" id="lockProfile"
                                <?php echo e($vcard->is_locked ? 'checked' : ''); ?>>
                            <span class="custom-switch-indicator"></span>
                        </label>
                    </div>

                    <p class="text-muted">When you lock your profile, only people with permission can view your VCard.</p>
                </div>

                
                <div class="tab-pane fade" id="shareTab" role="tabpanel" aria-labelledby="share-tab">
                    <span class="fs-3 me-3"><?php echo e(__('messages.setting.sharelink')); ?></span>

                    
                    <div id="expiryOptions">
                        <div class="row align-items-end">
                            <div class="form-group col-sm-6 mb-5">
                                <?php echo e(Form::label('expiry_type', __('messages.setting.expiry_type') . ':', ['class' => 'form-label required'])); ?>

                                <div class="position-relative">
                                <?php echo e(Form::select('expiry_type', [
                                    '1_hour'   => __('1 hour'),
                                    '24_hours' => __('24 hours'),
                                    '7_days'   => __('7 days'),
                                    'custom'   => __('Custom'),
                                ], optional($privacy)->expiry_type, [
                                    'class' => 'form-control',
                                    'id'    => 'expiry_type',
                                    'placeholder' => __('Select expiry time')
                                ])); ?>

                                <i class="fas fa-chevron-down position-absolute" style="right: 15px; top: 50%; transform: translateY(-50%); pointer-events: none; color: #6c757d;"></i>
                                </div>
                            </div>
                            <div class="form-group col-sm-6 mb-5">
                                <label class="form-label d-block">&nbsp;</label>
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                            <div class="form-group col-sm-6 mb-5"
                                id="custom_days_div"
                                style="display: none; transition: all 0.3s ease;">
                                <?php echo e(Form::label('custom_days', __('messages.setting.custom_days') . ':', ['class' => 'form-label'])); ?>

                                <?php echo e(Form::number('custom_days', optional($privacy)->custom_days, [
                                    'class' => 'form-control mt-2',
                                    'id' => 'custom_days',
                                    'placeholder' => __('messages.setting.placeholder_days'),
                                    'min' => 1,
                                    'required' => false
                                ])); ?>

                            </div>
                        </div>
                    </div>

                    
                    <div class="table-responsive mt-3">
                        <table class="table table-bordered align-middle">
                            <thead class="table-success">
                                <tr>
                                    <th>Type</th>
                                    <th>Access URL</th>
                                    <th>Copy</th>
                                    <th>Generated At</th>
                                    <th>Expires At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $privacyRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>JWT Share Link</td>
                                        <td>
                                            <input type="text" class="form-control"
                                                value="<?php echo e($record->share_link); ?>"
                                                id="shareLinkInput<?php echo e($record->id); ?>" readonly>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-outline-primary btn-sm"
                                                onclick="copyText('<?php echo e($record->share_link); ?>', event)">
                                                Copy
                                            </button>
                                        </td>
                                        <td><?php echo e($record->created_at ? $record->created_at->format('Y-m-d H:i:s') : 'N/A'); ?></td>
                                        <td><?php echo e(optional($record->expires_at)->format('Y-m-d H:i:s') ?? 'No Expiry'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center">No share links generated yet.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div class="tab-pane fade" id="catTab" role="tabpanel" aria-labelledby="cat-tab">
                    
                    <div class="table-responsive mt-3">
                        <table class="table table-bordered align-middle" id="catTable">
                            <thead class="table-success">
                                <tr>
                                    <th>Access URL</th>
                                    <th>Copy</th>
                                    <th>Generated At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $cardAccessTokens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $token): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $tokenUrl = url("/{$vcard->url_alias}?tid={$token->id}&t={$token->token_hash}");
                                    ?>
                                    <tr data-token-id="<?php echo e($token->id); ?>">
                                        <td>
                                            <div class="qr-preview mb-2 text-center">
                                                <?php echo QrCode::size(100)->format('svg')->generate($tokenUrl); ?>

                                            </div>

                                             <button type="button" class="btn btn-outline-primary d-inline-flex align-items-center justify-content-center px-3 py-2 mb-2 downloadQrBtn">
                                                <i class="ri-download-line me-2"></i>
                                                Download QR Code
                                            </button>

                                        </td>
                                        <td>
                                            <button class="btn btn-outline-primary btn-sm mb-2" onclick="copyText('<?php echo e($tokenUrl); ?>', event)">
                                                Copy
                                            </button>
                                            <input type="text" class="form-control mt-2" value="<?php echo e($tokenUrl); ?>" readonly>
                                        </td>
                                        <td><?php echo e($token->created_at ? $token->created_at->format('Y-m-d H:i:s') : 'N/A'); ?></td>
                                        <td>
                                            <?php if(!$token->revoked): ?>
                                                <button class="btn btn-danger btn-sm"
                                                    onclick="revokeToken('<?php echo e($vcard->id); ?>', '<?php echo e($token->id); ?>', this, event)">
                                                    Revoke
                                                </button>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Revoked</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No Card Access Tokens generated yet.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <button type="button" id="generateCatBtn" class="btn btn-primary">
                            Generate Card Access Token
                        </button>
                    </div>
                </div>
            </div>

            
            <div class="col-lg-12 d-flex mt-4" id="vcardPrivacyFormActions">
                <button type="submit" class="btn btn-primary me-3">
                    <?php echo e(__('messages.common.save')); ?>

                </button>
                <a href="<?php echo e(route('vcards.index')); ?>" class="btn btn-secondary">
                    <?php echo e(__('messages.common.discard')); ?>

                </a>
            </div>

        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->startPush('scripts'); ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const actionsDiv = document.getElementById('vcardPrivacyFormActions');
        if (!actionsDiv) return;

        // Function to show/hide buttons
        function updateActionsVisibility() {
            // Check which tab is currently active
            const shareTabButton = document.getElementById('share-tab');
            const shareTabPane = document.getElementById('shareTab');

            // Check if Share Link tab is active
            const isShareTabActive =
                (shareTabButton && shareTabButton.classList.contains('active')) ||
                (shareTabPane && shareTabPane.classList.contains('active') && shareTabPane.classList.contains('show'));

            if (isShareTabActive) {
                // Use setProperty with important flag to override any CSS
                actionsDiv.style.setProperty('display', 'none', 'important');
                actionsDiv.style.setProperty('visibility', 'hidden', 'important');
                actionsDiv.style.setProperty('opacity', '0', 'important');
                actionsDiv.style.setProperty('height', '0', 'important');
                actionsDiv.style.setProperty('overflow', 'hidden', 'important');
                actionsDiv.style.setProperty('margin', '0', 'important');
                actionsDiv.style.setProperty('padding', '0', 'important');
                console.log('Share tab active - hiding buttons', {
                    display: window.getComputedStyle(actionsDiv).display,
                    visibility: window.getComputedStyle(actionsDiv).visibility
                });
            } else {
                // Use setProperty with important flag
                actionsDiv.style.setProperty('display', 'flex', 'important');
                actionsDiv.style.setProperty('visibility', 'visible', 'important');
                actionsDiv.style.setProperty('opacity', '1', 'important');
                actionsDiv.style.setProperty('height', 'auto', 'important');
                actionsDiv.style.setProperty('overflow', 'visible', 'important');
                console.log('Other tab active - showing buttons', {
                    display: window.getComputedStyle(actionsDiv).display,
                    visibility: window.getComputedStyle(actionsDiv).visibility
                });
            }
        }

        // Initial check
        updateActionsVisibility();

        // Listen for Bootstrap tab events on all privacy tab buttons
        const privacyTabButtons = document.querySelectorAll('#privacyTab .privacy-link, #privacyTab .nav-link');
        privacyTabButtons.forEach(button => {
            // Listen for Bootstrap's shown.bs.tab event
            button.addEventListener('shown.bs.tab', function(e) {
                setTimeout(updateActionsVisibility, 50);
            });

            // Also listen for click as fallback
            button.addEventListener('click', function(e) {
                setTimeout(updateActionsVisibility, 100);
            });
        });

        // Also watch for changes on tab panes
        const tabPanes = document.querySelectorAll('#privacyTabContent .tab-pane');
        const observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                    updateActionsVisibility();
                }
            });
        });

        tabPanes.forEach(pane => {
            observer.observe(pane, {
                attributes: true,
                attributeFilter: ['class']
            });
        });

        // Re-check after a delay to catch any restored tabs
        setTimeout(updateActionsVisibility, 200);
        setTimeout(updateActionsVisibility, 500);
    });
</script>


<script>
function initializeDownloadQrButtons() {
    const buttons = document.querySelectorAll(".downloadQrBtn");
    console.log('Found ' + buttons.length + ' download QR buttons');

    buttons.forEach((button, index) => {
        // Remove any existing event listeners by cloning
        const newButton = button.cloneNode(true);
        button.parentNode.replaceChild(newButton, button);

        newButton.addEventListener("click", function (e) {
            e.preventDefault();
            console.log('Download QR button clicked');

            const row = this.closest("tr");
            if (!row) {
                console.error('Could not find parent row');
                alert("Error: Could not find QR code container!");
                return;
            }

            const qrContainer = row.querySelector(".qr-preview");
            if (!qrContainer) {
                console.error('Could not find qr-preview container');
                alert("Error: QR code container not found!");
                return;
            }

            console.log('Processing QR code download...');

            // Check for SVG (server-rendered tokens) or Canvas/Image (dynamically generated tokens)
            const svg = qrContainer.querySelector("svg");
            const canvas = qrContainer.querySelector("canvas");
            const img = qrContainer.querySelector("img");

            try {
                const size = <?php echo e($vcard->qr_code_download_size ?? 300); ?>;
                let downloadCanvas = document.createElement("canvas");
                downloadCanvas.width = size;
                downloadCanvas.height = size;
                const ctx = downloadCanvas.getContext("2d");

                if (svg) {
                    // Handle SVG QR Code (server-rendered)
                    console.log('Found SVG QR code');
                    const opacity = parseFloat(window.getComputedStyle(qrContainer).opacity) || 1;
                    const serializer = new XMLSerializer();
                    const svgData = serializer.serializeToString(svg);
                    const svgBlob = new Blob([svgData], { type: "image/svg+xml;charset=utf-8" });
                    const url = URL.createObjectURL(svgBlob);

                    const tempImg = new Image();
                    tempImg.onload = () => {
                        ctx.globalAlpha = opacity;
                        ctx.drawImage(tempImg, 0, 0, size, size);

                        const pngData = downloadCanvas.toDataURL("image/png");
                        const a = document.createElement('a');
                        a.href = pngData;
                        a.download = "qr_code_token_" + (index + 1) + ".png";
                        document.body.appendChild(a);
                        a.click();
                        document.body.removeChild(a);

                        URL.revokeObjectURL(url);
                        console.log('SVG QR code downloaded successfully');
                    };

                    tempImg.onerror = () => {
                        console.error('Error loading SVG image');
                        alert('Error processing QR code. Please try again.');
                        URL.revokeObjectURL(url);
                    };

                    tempImg.src = url;
                } else if (canvas) {
                    // Handle Canvas QR Code (dynamically generated)
                    console.log('Found Canvas QR code');
                    ctx.drawImage(canvas, 0, 0, size, size);

                    const pngData = downloadCanvas.toDataURL("image/png");
                    const a = document.createElement('a');
                    a.href = pngData;
                    a.download = "qr_code_token_" + (index + 1) + ".png";
                    document.body.appendChild(a);
                    a.click();
                    document.body.removeChild(a);

                    console.log('Canvas QR code downloaded successfully');
                } else if (img) {
                    // Handle Image QR Code (alternative format)
                    console.log('Found Image QR code');
                    ctx.drawImage(img, 0, 0, size, size);

                    const pngData = downloadCanvas.toDataURL("image/png");
                    const a = document.createElement('a');
                    a.href = pngData;
                    a.download = "qr_code_token_" + (index + 1) + ".png";
                    document.body.appendChild(a);
                    a.click();
                    document.body.removeChild(a);

                    console.log('Image QR code downloaded successfully');
                } else {
                    console.error('No QR code element found (SVG, Canvas, or Image)');
                    alert("QR code not found for this token!");
                    return;
                }
            } catch (error) {
                console.error('Error processing QR code:', error);
                alert('Error downloading QR code: ' + error.message);
            }
        });
    });
}

// Initialize on page load
document.addEventListener("DOMContentLoaded", initializeDownloadQrButtons);

// Also initialize on turbo:load for Turbo compatibility
document.addEventListener("turbo:load", initializeDownloadQrButtons);

// Initialize immediately if DOM is already loaded
if (document.readyState === 'loading') {
    // Loading hasn't finished yet
} else {
    // DOM is ready
    initializeDownloadQrButtons();
}

function copyText(text, event) {
    if (event) {
        event.preventDefault();
        event.stopPropagation();
    }

    if (!navigator.clipboard) {
        const tempInput = document.createElement("input");
        tempInput.value = text;
        document.body.appendChild(tempInput);
        tempInput.select();
        document.execCommand("copy");
        document.body.removeChild(tempInput);
        alert("Copied!");
    } else {
        navigator.clipboard.writeText(text)
            .then(() => alert("Copied!"))
            .catch(err => console.error("Copy failed:", err));
    }
}

</script>

<?php if(isset($vcard) && $vcard->id): ?>
<script>
function revokeToken(vcardId, tokenId, btn , event) {
    if (!confirm('Are you sure you want to revoke this token?')) return;
    // Prevent page reload
    if (event) event.preventDefault();

    fetch(`/vcards/${vcardId}/revoke-token`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        credentials: 'same-origin',
        body: JSON.stringify({ token_id: tokenId })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status) {
            alert(data.message);
            const cell = btn.parentElement;
            cell.innerHTML = '<span class="badge bg-secondary">Revoked</span>';

        } else {
            alert(data.message || 'Failed to revoke token.');
        }
    })
    .catch(err => {
        console.error(err);
        alert('Something went wrong.');
    });
}

</script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const btn = document.getElementById('generateCatBtn');
    const tableBody = document.querySelector("#catTable tbody");


    if (!btn) return;

    btn.addEventListener('click', function () {
        btn.disabled = true;

        fetch("<?php echo e(route('vcards.generateToken', $vcard->id)); ?>", {
            method: "POST",
            headers: {
                "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",
                "Content-Type": "application/json"
            },
            body: JSON.stringify({})
        })
        .then(res => res.json())
        .then(data => {
            btn.disabled = false;

            if (data.status && data.data) {
                const tid = data.data.tid;
                const url = data.data.url;
                const createdAt = new Date().toLocaleString();

                const newRow = document.createElement("tr");
                newRow.dataset.tokenId = tid;

                // Append new row with revoke button (pass `this` to remove row later)
                 newRow.innerHTML = `

                        <td>
                            <div class="qr-preview mb-2 text-center" id="qr-${tid}"></div>

                            <button type="button" class="btn btn-outline-primary d-inline-flex align-items-center justify-content-center px-3 py-2 mb-2 downloadQrBtn">
                                <i class="ri-download-line me-2"></i>
                                Download QR Code
                            </button>
                        </td>
                        <td>
                            <button type="button" class="btn btn-outline-primary btn-sm mb-2" onclick="copyText('${url}', event)">
                                Copy
                            </button>
                            <input type="text" class="form-control mt-2" value="${url}" readonly>
                        </td>
                        <td>${createdAt}</td>

                        <td>
                            <button type="button" class="btn btn-danger btn-sm"
                                onclick="revokeToken('<?php echo e($vcard->id); ?>', '${tid}', this,event)">
                                Revoke
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(newRow);

                      new QRCode(document.getElementById(`qr-${tid}`), {
                                text: url,
                                width: 100,
                                height: 100
                            });

                // Reinitialize download QR button event listeners for the new button
                initializeDownloadQrButtons();
                // Optionally show a nice modal with QR/plain url here (not required).
                alert("Card Access Token generated successfully!");
            } else {
                alert("Error: " + (data.message || 'Unknown error'));
            }
        })
        .catch(err => {
            console.error(err);
            btn.disabled = false;
            alert("Something went wrong while generating the token.");
        });
    });
});
</script>
<?php endif; ?>
<script>
    function copyShareLink(inputId) {
        var copyText = document.getElementById(inputId);
        if (!copyText) {
            alert('Link not found.');
            return;
        }
        copyText.select();
        copyText.setSelectionRange(0, 99999); // mobile compatibility
        document.execCommand("copy");
        alert("Copied: " + copyText.value);
    }
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const expiryType = document.getElementById('expiry_type');
    const customDaysDiv = document.getElementById('custom_days_div');
    function toggleCustomDays() {
        if (expiryType.value === 'custom') {
            customDaysDiv.style.display = 'block';
        } else {
            customDaysDiv.style.display = 'none';
        }
    }
    expiryType.addEventListener('change', toggleCustomDays);
    // run once on page load
    toggleCustomDays();
});
</script>

<?php $__env->stopPush(); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.addEventListener('change', function (event) {
            if (event.target && event.target.id === 'selectAllDays') {
                const dayCheckboxes = document.querySelectorAll('input[name="days[]"]');
                const startTimeSelects = document.querySelectorAll('select[name^="startTime"]');
                const endTimeSelects = document.querySelectorAll('select[name^="endTime"]');

                const sharedStartTime = document.getElementById('sharedStartTime');
                const sharedEndTime = document.getElementById('sharedEndTime');

                if (!sharedStartTime || !sharedEndTime) {
                    console.warn("Start time or end time input is missing.");
                    return;
                }

                if (event.target.checked) {
                    dayCheckboxes.forEach(cb => cb.checked = true);

                    startTimeSelects.forEach(select => {
                        select.value = sharedStartTime.value;
                        $(select).trigger('change'); // for Select2
                    });

                    endTimeSelects.forEach(select => {
                        select.value = sharedEndTime.value;
                        $(select).trigger('change'); // for Select2
                    });
                } else {
                    dayCheckboxes.forEach(cb => cb.checked = false);
                }
            }
        });
    });

    $(document).ready(function() {
        // On change of start or end time, copy times if select all is checked
        $('#sharedStartTime, #sharedEndTime').on('change', function() {
            if ($('#selectAllDays').is(':checked')) {
                const startTime = $('#sharedStartTime').val();
                const endTime = $('#sharedEndTime').val();

                $('select[name^="startTime"]').each(function() {
                    $(this).val(startTime).trigger('change');
                });

                $('select[name^="endTime"]').each(function() {
                    $(this).val(endTime).trigger('change');
                });
            }
        });

        // Select or deselect all day checkboxes based on 'Select All Days'
        $('#selectAllDays').on('change', function() {
            const isChecked = $(this).is(':checked');
            $('input[name="days[]"]').prop('checked', isChecked);
        });

        // When any individual day checkbox is clicked, update 'Select All Days'
        $('input[name="days[]"]').on('change', function() {
            const total = $('input[name="days[]"]').length;
            const checked = $('input[name="days[]"]:checked').length;

            $('#selectAllDays').prop('checked', total === checked);
        });

        // Initialize 'Select All Days' on page load
        const total = $('input[name="days[]"]').length;
        const checked = $('input[name="days[]"]:checked').length;
        $('#selectAllDays').prop('checked', total === checked);
        // Handle expiry_type dropdown change to show/hide custom_days field
        $('#expiry_type').on('change', function() {
            const selectedValue = $(this).val();
            const customDaysDiv = $('#custom_days_div');
            const customDaysInput = $('#custom_days');

            if (selectedValue === 'custom') {
                customDaysDiv.slideDown(300);
                customDaysInput.prop('required', true);
            } else {
                customDaysDiv.slideUp(300);
                customDaysInput.prop('required', false);
            }
        });

        // Initialize custom_days visibility on page load
        const initialExpiryType = $('#expiry_type').val();
        const customDaysDiv = $('#custom_days_div');
        const customDaysInput = $('#custom_days');

        if (initialExpiryType === 'custom') {
            customDaysDiv.show();
            customDaysInput.prop('required', true);
        } else {
            customDaysDiv.hide();
            customDaysInput.prop('required', false);
        }

        // Privacy Tab Persistence - Save active tab to localStorage
        $('.privacy-link').on('click', function() {
            const targetTab = $(this).attr('data-bs-target');
            localStorage.setItem('activePrivacyTab', targetTab);
            console.log('Privacy tab changed to:', targetTab);

            // Update button visibility when tab is clicked
            setTimeout(function() {
                const actionsDiv = document.getElementById('vcardPrivacyFormActions');
                if (actionsDiv) {
                    if (targetTab === '#shareTab') {
                        actionsDiv.style.setProperty('display', 'none', 'important');
                        actionsDiv.style.setProperty('visibility', 'hidden', 'important');
                        actionsDiv.style.setProperty('opacity', '0', 'important');
                        actionsDiv.style.setProperty('height', '0', 'important');
                    } else {
                        actionsDiv.style.setProperty('display', 'flex', 'important');
                        actionsDiv.style.setProperty('visibility', 'visible', 'important');
                        actionsDiv.style.setProperty('opacity', '1', 'important');
                        actionsDiv.style.setProperty('height', 'auto', 'important');
                    }
                }
            }, 100);
        });

        // Restore active tab on page load
        setTimeout(function() {
            const savedTab = localStorage.getItem('activePrivacyTab');
            console.log('Restoring saved tab:', savedTab);

            if (savedTab && savedTab !== '#lockTab') {
                const tabButton = $('button[data-bs-target="' + savedTab + '"]');
                if (tabButton.length && typeof bootstrap !== 'undefined') {
                    console.log('Activating tab:', savedTab);
                    // Remove active classes from all tabs
                    $('.privacy-link').removeClass('active');
                    $('.tab-pane').removeClass('show active');

                    // Activate the saved tab
                    tabButton.addClass('active');
                    $(savedTab).addClass('show active');

                    // Use Bootstrap Tab API
                    const tabTrigger = new bootstrap.Tab(tabButton[0]);
                    tabTrigger.show();

                    // Update button visibility after tab is restored
                    setTimeout(function() {
                        const actionsDiv = document.getElementById('vcardPrivacyFormActions');
                        if (actionsDiv) {
                            if (savedTab === '#shareTab') {
                                actionsDiv.style.setProperty('display', 'none', 'important');
                                actionsDiv.style.setProperty('visibility', 'hidden', 'important');
                                actionsDiv.style.setProperty('opacity', '0', 'important');
                                actionsDiv.style.setProperty('height', '0', 'important');
                                console.log('Tab restored to Share - hiding buttons');
                            } else {
                                actionsDiv.style.setProperty('display', 'flex', 'important');
                                actionsDiv.style.setProperty('visibility', 'visible', 'important');
                                actionsDiv.style.setProperty('opacity', '1', 'important');
                                actionsDiv.style.setProperty('height', 'auto', 'important');
                                console.log('Tab restored to other - showing buttons');
                            }
                        }
                    }, 250);
                }
            }
        }, 100);

        // Handle form submission - save current active tab
        $('form').on('submit', function() {
            const activeTab = $('.privacy-link.active').attr('data-bs-target');
            if (activeTab) {
                localStorage.setItem('activePrivacyTab', activeTab);
                console.log('Saving active tab on form submit:', activeTab);
            }
        });
    });

    // Also handle for Turbo page loads
    document.addEventListener('turbo:load', function() {
        // Initialize expiry_type dropdown on Turbo load
        const expiryTypeSelect = document.getElementById('expiry_type');
        const customDaysDiv = document.getElementById('custom_days_div');

        if (expiryTypeSelect && customDaysDiv) {
            // Show/hide based on current value
            if (expiryTypeSelect.value === 'custom') {
                customDaysDiv.style.display = 'block';
            } else {
                customDaysDiv.style.display = 'none';
            }

            // Add change event listener
            expiryTypeSelect.addEventListener('change', function() {
                if (this.value === 'custom') {
                    customDaysDiv.style.display = 'block';
                } else {
                    customDaysDiv.style.display = 'none';
                }
            });
        }

        // Restore active privacy tab on Turbo load
        const savedTab = localStorage.getItem('activePrivacyTab');
        if (savedTab && typeof bootstrap !== 'undefined') {
            const tabButton = document.querySelector('button[data-bs-target="' + savedTab + '"]');
            if (tabButton) {
                const tabTrigger = new bootstrap.Tab(tabButton);
                tabTrigger.show();
            }
        }
    });

    document.addEventListener("turbo:load", (function() {

        if (!$("#whatsappNumber").length) return !1;
        var e = document.querySelector("#whatsappNumber"),
            t = document.querySelector("#alter-error-msg"),
            a = document.querySelector("#alter-valid-msg"),
            n = [Lang.get("messages.placeholder.invalid_number"), Lang.get("messages.placeholder.invalid_country_number"), Lang.get("messages.placeholder.too_short"), Lang.get("messages.placeholder.too_long"), Lang.get("messages.placeholder.invalid_number")],
            r = window.intlTelInput(e, {
                initialCountry: defaultCountryCodeValue,
                separateDialCode: !0,
                geoIpLookup: function(e, t) {
                    $.get("https://ipinfo.io", (function() {}), "jsonp").always((function(t) {
                        var a = t && t.country ? t.country : "";
                        e(a)
                    }))
                },
                utilsScript: "../../public/assets/js/inttel/js/utils.min.js"
            }),
            i = function() {
                e.classList.remove("error"), t.innerHTML = "", t.classList.add("d-none"), a.classList.add("d-none")
            };
        1 == mobileValidation && e.addEventListener("blur", (function() {
            if (i(), e.value.trim())
                if (r.isValidNumber()) a.classList.remove("d-none");
                else {
                    e.classList.add("error");
                    var s = r.getValidationError();
                    t.innerHTML = n[s], t.classList.remove("d-none")
                }
        })), e.addEventListener("change", i), e.addEventListener("keyup", i), "undefined" != typeof phoneNo && "" !== phoneNo && setTimeout((function() {
            $("#whatsappNumber").trigger("change")
        }), 500), $("#whatsappNumber").on("blur keyup change countrychange", (function() {
            "undefined" != typeof phoneNo && "" !== phoneNo && (r.setNumber("+" + phoneNo), phoneNo = "");
            var ew = r.selectedCountryData.dialCode;
            $("#whatsapp_prefix_code").val(ew)
        }));
        var sw = r.selectedCountryData.dialCode;
        $("#whatsapp_prefix_code").val(sw);
        var ow = $("#whatsappNumber").val().replace(/\s/g, "");
        $("#whatsappNumber").val(ow), $("#whatsappNumber").focus(), $("#whatsappNumber").trigger("blur")
    }));

    function deleteImage(route, vcardId, type) {
        if (!confirm('Are you sure you want to remove this image?')) return;

        fetch(route, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                id: vcardId,
                type: type,
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                toastr.success(data.message);
                location.reload(); // Or remove image preview dynamically
            } else {
                toastr.error('Failed to remove image');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            toastr.error('Something went wrong');
        });
    }
</script>
<?php /**PATH C:\xampp\htdocs\projects\Ebizcard17-11-25\resources\views/vcards/fields.blade.php ENDPATH**/ ?>