<!DOCTYPE html>

<html lang="en">

<head>

<meta charset="UTF-8">

<meta name="viewport" content="width=device-width, initial-scale=1.0">

<?php if(checkFeature('seo') && $vcard->site_title && $vcard->home_title): ?>

        <title><?php echo e($vcard->home_title); ?> | <?php echo e($vcard->site_title); ?></title>

    <?php else: ?>

        <title><?php echo e($vcard->name); ?> | <?php echo e(getAppName()); ?></title>

    <?php endif; ?>

<link rel="preconnect" href="https://fonts.googleapis.com">

<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" integrity="sha512-..." crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!--<link rel="stylesheet" href="<?php echo e(asset('assets/css/vcard3.css')); ?>">-->

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/new_vcard/custom.css')); ?>">


<link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Include Bootstrap CSS -->

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

<!-- Include Bootstrap Datepicker CSS -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">



<!-- Include Toastr CSS in the <head> section -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>



<style>

:root {

  --primary-color: #0B84FF;

  --secondary-color: #34495E;

  --light-gray: #F8FAFC;

}



body {

  font-family: 'Inter', sans-serif;

  background-color: #f8fafc;

  color: #333;

}



.container-fluid {

  max-width: 600px;

  margin: 0 auto;

  background-color: #ffffff;

}



.profile-gradient {

  background: linear-gradient(135deg, rgba(11, 132, 255, 0.08), rgba(52, 73, 94, 0.06));

}



.social-icon:hover {

  transform: translateY(-3px);

  transition: transform 0.2s ease;

}



.qr-code {

  background-image: radial-gradient(#fff 85%, transparent 85%),

    linear-gradient(135deg, rgba(11, 132, 255, 0.12), rgba(52, 73, 94, 0.12));

}



.fixed-header {

  position: fixed;

  top: 0;

  left: 0;

  right: 0;

  z-index: 1050;

  background: white;

  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);

}

/* Desktop: Adjust logo and share icon positioning */
@media (min-width: 768px) {
  .fixed-header {
    padding-left: 455px  !important;
    padding-right: 447px  !important;
  }
}

/* Mobile: Keep original spacing */
@media (max-width: 767px) {
  .fixed-header {
    padding-left: 12px !important;
    padding-right: 12px !important;
  }
}



.main-content {

  padding-top: 70px;

  padding-bottom: 16px;

}



.profile-section {

  position: relative;

  overflow: hidden;

  padding-bottom: 2rem;

}



.profile-bg-circle-1 {

  position: absolute;

  top: 0;

  right: 0;

  width: 128px;

  height: 128px;

  background: rgba(11, 132, 255, 0.05);

  border-radius: 50%;

  margin-right: -40px;

  margin-top: -40px;

}



.profile-bg-circle-2 {

  position: absolute;

  bottom: 0;

  left: 0;

  width: 96px;

  height: 96px;

  background: rgba(52, 73, 94, 0.05);

  border-radius: 50%;

  margin-left: -40px;

  margin-bottom: -40px;

}



.profile-image {

  width: 120px;

  height: 120px;

  border-radius: 50%;

  border: 5px solid white;

  box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);

  overflow: hidden;

  object-fit: cover;

}



.quick-action-btn {

  width: 48px;

  height: 48px;

  border-radius: 50%;

  background: white;

  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);

  display: flex;

  align-items: center;

  justify-content: center;

  color: var(--primary-color);

  text-decoration: none;

  transition: box-shadow 0.2s ease;

}



.quick-action-btn:hover {

  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);

  color: var(--primary-color);

}





.contact-card {

  background: white;

  border-radius: 12px;

  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);

  padding: 1.25rem;

  transition: all 0.3s ease;

  border: 1px solid rgba(0, 0, 0, 0.05);

}



.contact-card:hover {

  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);

  transform: translateY(-2px);

}



.contact-icon {

  width: 48px;

  height: 48px;

  border-radius: 12px;

  background: rgba(11, 132, 255, 0.1);

  display: flex;

  align-items: center;

  justify-content: center;

  color: var(--primary-color);

  flex-shrink: 0;

}



.contact-icon img {

  width: 24px;

  height: 24px;

}



.social-card {

  background: white;

  border-radius: 8px;

  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);

  padding: 1rem;

  text-decoration: none;

  color: inherit;

  transition: transform 0.2s ease;

}



.social-card:hover {

  color: inherit;

  text-decoration: none;

}



.skill-tag {

  background: rgba(11, 132, 255, 0.1);

  color: var(--primary-color);

  padding: 0.25rem 0.75rem;

  border-radius: 20px;

  font-size: 0.75rem;

  display: inline-block;

  margin: 0.125rem;

}



.fixed-bottom-action {

  position: fixed;

  bottom: 0;

  left: 0;

  right: 0;

  box-shadow: 0 -4px 10px rgba(0, 0, 0, 0.05);

  padding: 1rem;

  z-index: 1040;

}



.primary-btn {

  background: var(--primary-color);

  border: none;

  border-radius: 8px;

  color: white;

  font-weight: 500;

  padding: 0.875rem 1rem;

  width: 100%;

  cursor: pointer;

}



.modal-share {

  background: rgba(0, 0, 0, 0.5);

}



.share-platform {

  text-decoration: none;

  color: inherit;

  cursor: pointer;

}



.share-platform:hover {

  color: inherit;

  text-decoration: none;

}



.share-icon {

  width: 48px;

  height: 48px;

  border-radius: 50%;

  display: flex;

  align-items: center;

  justify-content: center;

  margin-bottom: 0.5rem;

}



.link-input {

  background: #f8f9fa;

  border: none;

  border-radius: 8px;

  padding: 0.75rem;

  width: 100%;

  font-size: 0.875rem;

  color: #495057;

}



.copy-btn {

  background: none;

  border: none;

  color: var(--primary-color);

  font-weight: 500;

  font-size: 0.875rem;

  cursor: pointer;

}



.success-notification {

  position: fixed;

  top: 70px;

  left: 50%;

  transform: translateX(-50%);

  background: #d4edda;

  color: #155724;

  padding: 0.5rem 1rem;

  border-radius: 8px;

  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);

  z-index: 1060;

}



.header-btn {

  width: 32px;

  height: 32px;

  display: flex;

  align-items: center;

  justify-content: center;

  color: #6c757d;

  background: none;

  border: none;

  cursor: pointer;

}

.service-card {

    background: white;

    border-radius: 12px;

    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);

    transition: all 0.3s ease;

    overflow: hidden;

    border: 1px solid rgba(0, 0, 0, 0.05);

    display: flex;

    flex-direction: row;

    align-items: center;

}



.service-card:hover {

    transform: translateY(-3px);

    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);

}



.service-card .card-img {

    width: 100px;

    height: 100px;

    flex-shrink: 0;

    margin-right: 1rem;

}



.service-new-image {

    width: 100%;

    height: 100%;

    object-fit: cover;

}



.title-text {

    font-size: 1.25rem;

    font-weight: 600;

}



.description-text {

    font-size: 0.875rem;

    color: #6c757d; /* Muted text color */

}



.description-text.more {

    max-height: 60px; /* Limit height for long descriptions */

    overflow: hidden;

    text-overflow: ellipsis;

}

.product-card {

    background: white;

    border-radius: 12px;

    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);

    transition: all 0.3s ease;

    overflow: hidden;

    border: 1px solid rgba(0, 0, 0, 0.05);

    height: 100%;

}



.product-card:hover {

    transform: translateY(-3px);

    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);

}



.product-profile img {

    width: 100%;

    height: 200px;

    object-fit: cover;

    border-radius: 0;

}



.product-name {

    font-size: 1.125rem;

    font-weight: 600;

    color: #000;

}



.product-description {

    font-size: 0.875rem;

    color: #6c757d;

    line-height: 1.5;

}



.view-more {

    background-color: var(--primary-color);

    color: white;

    padding: 0.75rem 2rem;

    border-radius: 8px;

    text-decoration: none;

    transition: all 0.3s ease;

    display: inline-block;

    font-weight: 500;

}



.view-more:hover {

    background-color: var(--secondary-color);

    transform: translateY(-2px);

    box-shadow: 0 4px 12px rgba(11, 132, 255, 0.3);

    color: white;

}



.testimonial-card {

    background: white;

    border-radius: 12px;

    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);

    transition: all 0.3s ease;

    border: 1px solid rgba(0, 0, 0, 0.05);

    padding: 1.5rem;

}



.testimonial-card:hover {

    transform: translateY(-3px);

    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);

}



.testimonial-profile img {

    width: 90px;

    height: 90px;

    object-fit: cover;

    border: 4px solid var(--primary-color);

    border-radius: 50%;

}



.testimonial-details h4 {

    font-size: 1.25rem;

    font-weight: 600;

}



.testimonial-details p {

    font-size: 0.875rem;

    color: #6c757d; /* Muted text color */

}



.testimonial-margin {

    margin-bottom: 20px; /* Adjust spacing between testimonials */

}



.appoint-date {

    font-weight: 600;

    font-size: 1rem;

    color: #000;

}



.appoint-input {

    border-radius: 10px;

    border: 1px solid #e0e0e0;

    padding: 0.75rem 1rem;

    transition: border-color 0.3s ease;

}



.appoint-input:focus {

    border-color: var(--primary-color);

    box-shadow: 0 0 0 0.2rem rgba(11, 132, 255, 0.25);

    outline: none;

}



.appoint-btn {

    background-color: var(--primary-color);

    border-radius: 10px;

    padding: 0.875rem 2rem;

    transition: all 0.3s ease;

    border: none;

    font-weight: 500;

}



.appoint-btn:hover {

    background-color: var(--secondary-color);

    transform: translateY(-2px);

    box-shadow: 0 4px 12px rgba(11, 132, 255, 0.3);

}



.sticky-bar {

    position: fixed;

    right: 20px; /* Adjust as needed */

    top: 50%;

    transform: translateY(-50%);

    z-index: 9999; /* Ensure it stays on top */

}



.time-slot {

    cursor: pointer;

    padding: 10px;

    background: #fff;

    font-size: 12px;

    border-radius: 8px;

    border: 1px solid #e0e0e0;

    transition: all 0.3s ease;

}



.time-slot:hover {

    border-color: var(--primary-color);

    background: rgba(11, 132, 255, 0.05);

}



.activeSlot {

    background: #0B84FF !important;

    padding: 11px;

    color: #fff !important;

    border-color: #0B84FF !important;

}



/* Section Headings */

h2.fs-5 {

    position: relative;

    padding-bottom: 0.5rem;

}



/* Gallery Cards */

.gallery-card {

    border-radius: 12px !important;

    overflow: hidden;

    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);

    transition: all 0.3s ease;

}



.gallery-card:hover {

    transform: translateY(-3px);

    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);

}



.gallery-card img {

    border-radius: 12px;

}



/* Blog Cards */

.blog-card {

    background: white;

    border-radius: 12px;

    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);

    transition: all 0.3s ease;

    overflow: hidden;

}



.blog-card:hover {

    transform: translateY(-3px);

    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);

}



/* Form Inputs */

.form-control {

    border-radius: 10px;

    border: 1px solid #e0e0e0;

    transition: border-color 0.3s ease;

}



.form-control:focus {

    border-color: var(--primary-color);

    box-shadow: 0 0 0 0.2rem rgba(11, 132, 255, 0.25);

}



/* Primary Button */

.btn-primary {

    background-color: var(--primary-color);

    border-color: var(--primary-color);

    border-radius: 10px;

    padding: 0.75rem 1.5rem;

    font-weight: 500;

    transition: all 0.3s ease;

}



.btn-primary:hover {

    background-color: var(--secondary-color);

    border-color: var(--secondary-color);

    transform: translateY(-2px);

    box-shadow: 0 4px 12px rgba(11, 132, 255, 0.3);

}



/* Add spacing between sections */

section {

    margin-bottom: 2rem;

}

</style>

</head>

<body>



<!-- Profile Card Container -->

<div class="container-fluid p-0">

  <!-- Header with Logo -->

  <header class="fixed-header d-flex justify-content-between align-items-center py-2">

    <div class="d-flex align-items-center header-logo-container">

      <img src="https://static.readdy.ai/image/ebe8a9b7c6bcd5c646860382bb233986/aff3e6ddbcf0dc23a5bae0fa83033b8b.png" alt="ebizcard logo" style="height: 32px;">

    </div>

    <div class="d-flex align-items-center header-share-container">

      <button class="header-btn me-2" data-bs-toggle="modal" data-bs-target="#shareModal">

        <i class="ri-share-line ri-lg"></i>

      </button>

    </div>

  </header>



  <!-- Main Content -->

  <main class="main-content" style="padding-top: 50px;

    padding-bottom: 16px;">

    <!-- Profile Section -->

<?php if($locked): ?>
    <section class="profile-gradient profile-section position-relative overflow-hidden">
    <img src="<?php echo e($vcard->cover_url ?? asset('assets/images/Final-Cover-for-ebizcard.jpg')); ?>"
     class="position-absolute top-0 start-0 w-100 h-100"
     style="object-fit: cover; object-position: center; z-index: 0;">
        <div class="container pt-4 position-relative" style="z-index: 10;">
            <div class="text-center">
                <div class="profile-image mx-auto mb-3">
                    <img src="<?php echo e($vcard->profile_url); ?>" alt="Profile" class="w-100 h-100 object-fit-cover">
                </div>
                <h1 class="fs-3 fw-semibold text-dark mb-1"><?php echo e(ucwords($vcard->first_name . ' ' . $vcard->last_name)); ?></h1>
                <p class="fw-medium mb-2" style="color: var(--primary-color);"><?php echo e(ucwords($vcard->occupation)); ?></p>
                <p class="text-muted small mb-2"><?php echo e(ucwords($vcard->company)); ?></p>
            </div>
        </div>

    </section>
<?php else: ?>
<section class="profile-gradient profile-section position-relative overflow-hidden">

  <!-- Background Cover Image -->
<img src="<?php echo e($vcard->cover_url ?? asset('assets/images/Final-Cover-for-ebizcard.jpg')); ?>"
     class="position-absolute top-0 start-0 w-100 h-100"
     style="object-fit: cover; object-position: center; z-index: 0;">
  <!-- Optional background circles -->

  <div class="profile-bg-circle-1"></div>

  <div class="profile-bg-circle-2"></div>



  <div class="container pt-4 position-relative" style="z-index: 10;">

    <div class="text-center">

      <!-- Profile Image -->

      <div class="profile-image mx-auto mb-3">

        <img src="<?php echo e($vcard->profile_url); ?>" alt="John Anderson" class="w-100 h-100 object-fit-cover">

      </div>



      <!-- Name and Title -->

      <h1 class="fs-3 fw-semibold text-dark mb-1"><?php echo e(ucwords($vcard->first_name . ' ' . $vcard->last_name)); ?></h1>

      <p class="fw-medium mb-2" style="color: var(--primary-color);"><?php echo e(ucwords($vcard->occupation)); ?></p>

       <!-- <p class="text-muted small mb-2"><?php echo e(ucwords($vcard->job_title)); ?></p> -->

      <p class="text-muted small mb-2"><?php echo e(ucwords($vcard->company)); ?></p>



      <!-- Location -->

      <?php if(checkFeature('location') && !empty($vcard->location)): ?>

        <div class="d-flex align-items-center justify-content-center text-muted small mb-2">

          <i class="ri-map-pin-line me-1"></i>

          <span><?php echo e($vcard->location); ?></span>

        </div>

      <?php endif; ?>



      <!-- Social Links -->

      <?php if(checkFeature('social_links') && isset($vcard->socialLink) && getSocialLink($vcard)): ?>

        <section class="py-4">

          <div class="d-flex justify-content-center flex-wrap gap-3 mb-3">

            <?php $__currentLoopData = getSocialLink($vcard); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

              <div class="d-flex align-items-center justify-content-center rounded-circle bg-white shadow-sm"

                   style="width: 48px; height: 48px; transition: box-shadow 0.3s; cursor: pointer;">

                <?php echo $value; ?>


              </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

          </div>

        </section>

      <?php endif; ?>



      <!-- (Optional) Quick Action Buttons commented out -->

    </div>

  </div>

</section>





    <!-- Contact Information Section -->



<?php if(

    (checkFeature('phone') && !empty($vcard->phone)) ||

    (checkFeature('email') && !empty($vcard->email)) ||

    (checkFeature('location') && !empty($vcard->location)) ||

    !empty($vcard->alternative_email) ||

    !empty($vcard->dob) ||

    !empty($vcard->alternative_phone)

): ?>

    <section class="px-3 py-4">

        <h2 class="fs-5 fw-semibold text-dark mb-4">Contact Information</h2>

        <div class="d-flex flex-column gap-3">



            

            <?php if(checkFeature('phone') && !empty($vcard->phone)): ?>

                <div class="contact-card d-flex align-items-center">

                    <div class="contact-icon me-3">

                        <i class="ri-phone-line fs-5"></i>

                    </div>

                    <div class="flex-grow-1">

                        <p class="text-muted mb-0 small fw-5">Phone</p>

                        <a href="tel:<?php echo e($vcard->region_code . $vcard->phone); ?>" class="text-dark text-decoration-none fw-5">

                            +<?php echo e($vcard->region_code); ?> <?php echo e($vcard->phone); ?>


                        </a>

                    </div>

                </div>

            <?php endif; ?>



            

            <?php if(!empty($vcard->alternative_phone)): ?>

                <div class="contact-card d-flex align-items-center">

                    <div class="contact-icon me-3">

                        <i class="ri-smartphone-line fs-5"></i>

                    </div>

                    <div class="flex-grow-1">

                        <p class="text-muted mb-0 small fw-5">Alternate Phone</p>

                        <a href="tel:+<?php echo e($vcard->alternative_region_code); ?><?php echo e($vcard->alternative_phone); ?>" class="text-dark text-decoration-none fw-5">

                            +<?php echo e($vcard->alternative_region_code); ?> <?php echo e($vcard->alternative_phone); ?>


                        </a>

                    </div>

                </div>

            <?php endif; ?>



            

            <?php if(checkFeature('email') && !empty($vcard->email)): ?>

                <div class="contact-card d-flex align-items-center">

                    <div class="contact-icon me-3">

                        <i class="ri-mail-line fs-5"></i>

                    </div>

                    <div class="flex-grow-1">

                        <p class="text-muted mb-0 small fw-5">Email</p>

                        <a href="mailto:<?php echo e($vcard->email); ?>" class="text-dark text-decoration-none fw-5">

                            <?php echo e($vcard->email); ?>


                        </a>

                    </div>

                </div>

            <?php endif; ?>



            

            <?php if(!empty($vcard->alternative_email)): ?>

                <div class="contact-card d-flex align-items-center">

                    <div class="contact-icon me-3">

                        <i class="ri-mail-open-line fs-5"></i>

                    </div>

                    <div class="flex-grow-1">

                        <p class="text-muted mb-0 small fw-5">Alternate Email</p>

                        <a href="mailto:<?php echo e($vcard->alternative_email); ?>" class="text-dark text-decoration-none fw-5">

                            <?php echo e($vcard->alternative_email); ?>


                        </a>

                    </div>

                </div>

            <?php endif; ?>



            

            <?php if(checkFeature('location') && !empty($vcard->location)): ?>

                <div class="contact-card d-flex align-items-center">

                    <div class="contact-icon me-3">

                        <i class="ri-map-pin-line fs-5"></i>

                    </div>

                    <div class="flex-grow-1">

                        <p class="text-muted mb-0 small fw-5">Address</p>

                        <a href="https://maps.google.com/?q=<?php echo e(urlencode($vcard->location)); ?>" target="_blank" class="text-dark text-decoration-none fw-5">

                            <?php echo e($vcard->location); ?>


                        </a>

                    </div>

                </div>

            <?php endif; ?>



            

            <?php if(!empty($vcard->dob)): ?>

                <div class="contact-card d-flex align-items-center">

                    <div class="contact-icon me-3">

                        <i class="ri-cake-2-line fs-5"></i>

                    </div>

                    <div class="flex-grow-1">

                        <p class="text-muted mb-0 small fw-5">Date of Birth</p>

                        <p class="text-dark mb-0 fw-5"><?php echo e($vcard->dob); ?></p>

                    </div>

                </div>

            <?php endif; ?>

        </div>

    </section>

<?php endif; ?>











<?php if((isset($managesection) && $managesection['business_hours']) || empty($managesection)): ?>

    <?php if($vcard->businessHours->count()): ?>

        <div class="mt-4 px-3">

            <h5 class="mb-3 fw-semibold text-dark fs-5">

                <?php echo e(__('messages.business.business_hours')); ?>


            </h5>

            <div class="d-flex flex-column gap-2 fs-6">

                <!-- <?php

                    $groupedHours = [

                        'Monday - Friday' => ['mon', 'tue', 'wed', 'thu', 'fri'],

                        'Saturday' => ['sat'],

                        'Sunday' => ['sun'],

                    ];

                    $dayMapping = array_flip(\App\Models\BusinessHour::DAY_OF_WEEK);

                ?>



                <?php $__currentLoopData = $groupedHours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $days): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php

                        $times = array_map(function($dayKey) use ($businessDaysTime, $dayMapping) {

                            $index = $dayMapping[$dayKey] ?? null;

                            return $index !== null ? ($businessDaysTime[$index] ?? null) : null;

                        }, $days);



                        $uniqueTimes = array_unique(array_filter($times));

                        $displayTime = count($uniqueTimes) === 1 ? $uniqueTimes[0] : null;

                        $isClosed = empty($displayTime) && empty($uniqueTimes);

                    ?>



                    <div class="d-flex justify-content-between align-items-center py-1 px-1">

                        <span class="<?php echo e($isClosed ? 'text-muted' : 'text-dark'); ?>">

                            <?php echo e($label); ?>


                        </span>

                        <span class="<?php echo e($isClosed ? 'text-muted' : 'text-primary fw-semibold'); ?>">

                            <?php echo e($displayTime ?? __('messages.common.closed')); ?>


                        </span>

                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> -->



                <?php

                    $dayNames = ['mon' => 'Monday', 'tue' => 'Tuesday', 'wed' => 'Wednesday', 'thu' => 'Thursday', 'fri' => 'Friday', 'sat' => 'Saturday', 'sun' => 'Sunday'];

                    $dayMapping = array_flip(\App\Models\BusinessHour::DAY_OF_WEEK);



                    // Prepare time mapping

                    $businessDayKeys = ['mon', 'tue', 'wed', 'thu', 'fri'];

                    $dayTimes = [];



                    foreach (array_keys($dayNames) as $dayKey) {

                        $index = $dayMapping[$dayKey] ?? null;

                        $dayTimes[$dayKey] = $index !== null ? ($businessDaysTime[$index] ?? null) : null;

                    }



                    // Check if Mon-Fri all have same time

                    $weekdays = array_map(fn($k) => $dayTimes[$k], $businessDayKeys);

                    $uniqueWeekdayTimes = array_unique(array_filter($weekdays));



                    $groupWeekdays = count($uniqueWeekdayTimes) === 1;

                ?>



                

                <?php if($groupWeekdays): ?>

                    <div class="d-flex justify-content-between align-items-center py-1 px-1">

                        <span class="text-dark">Monday - Friday</span>

                        <span class="<?php echo e(empty($uniqueWeekdayTimes[0]) ? 'text-muted' : 'text-primary fw-semibold'); ?>">

                            <?php echo e($uniqueWeekdayTimes[0] ?? __('messages.common.closed')); ?>


                        </span>

                    </div>

                <?php else: ?>

                    <?php $__currentLoopData = $businessDayKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="d-flex justify-content-between align-items-center py-1 px-1">

                            <span class="text-dark"><?php echo e($dayNames[$key]); ?></span>

                            <span class="<?php echo e(empty($dayTimes[$key]) ? 'text-muted' : 'text-primary fw-semibold'); ?>">

                                <?php echo e($dayTimes[$key] ?? __('messages.common.closed')); ?>


                            </span>

                        </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php endif; ?>



                

                <div class="d-flex justify-content-between align-items-center py-1 px-1">

                    <span class="text-dark">Saturday</span>

                    <span class="<?php echo e(empty($dayTimes['sat']) ? 'text-muted' : 'text-primary fw-semibold'); ?>">

                        <?php echo e($dayTimes['sat'] ?? __('messages.common.closed')); ?>


                    </span>

                </div>



                

                <div class="d-flex justify-content-between align-items-center py-1 px-1">

                    <span class="text-dark">Sunday</span>

                    <span class="<?php echo e(empty($dayTimes['sun']) ? 'text-muted' : 'text-primary fw-semibold'); ?>">

                        <?php echo e($dayTimes['sun'] ?? __('messages.common.closed')); ?>


                    </span>

                </div>



                <!--<div class="mt-3 d-flex align-items-center text-muted small ps-1">-->

                <!--    <i class="ri-time-line me-2"></i>-->

                <!--    <span>Pacific Time (PT)</span>-->

                <!--</div>-->

            </div>

        </div>

    <?php endif; ?>

<?php endif; ?>







<?php if((isset($managesection) && $managesection['appointments']) || empty($managesection)): ?>

    <?php if(checkFeature('appointments') && $vcard->appointmentHours->count()): ?>

        <section class="container py-4">

            <h2 class="fs-5 fw-semibold text-dark mb-3 text-center"><?php echo e(__('messages.make_appointments')); ?></h2>

            <div class="vcard-one__appointment py-3 mb-10 mt-0">

                <div class="container px-4">

                    <div class="appointment-one">

                        <div class="row d-flex align-items-center justify-content-center mb-3">

                            <div class="col-md-2">

                                <label for="date" class="appoint-date mb-2"><?php echo e(__('messages.date')); ?></label>

                            </div>

                            <div class="col-md-10">

                                <?php echo e(Form::text('date', null, ['class' => 'date appoint-input mb-2 form-control', 'placeholder' => __('messages.form.pick_date'), 'id' => 'pickUpDate'])); ?>


                            </div>

                        </div>

                        <div class="row d-flex align-items-center justify-content-center mb-md-3">

                            <div class="col-md-2">

                                <label for="hour" class="appoint-date mb-2 text-left"><?php echo e(__('messages.hour')); ?></label>

                            </div>

                            <div class="col-md-10">

                                <div id="slotData" class="row">

                                    <!-- Time slots will be dynamically populated here -->

                                </div>

                            </div>

                        </div>

                        <button type="button" class="appointmentAdd appoint-btn text-white mt-4 d-block mx-auto">

                            <?php echo e(__('messages.make_appointments')); ?>


                        </button>

                        <?php echo $__env->make('vcardTemplates.appointment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    </div>

                </div>

            </div>

        </section>

    <?php endif; ?>

<?php endif; ?>







<?php if((isset($managesection) && $managesection['services']) || empty($managesection)): ?>

    <?php if(checkFeature('services') && $vcard->services->count()): ?>

        <section class="container py-4">

            <h2 class="fs-5 fw-semibold text-dark mb-3 text-center"><?php echo e(__('messages.vcard.our_service')); ?></h2>

            <div class="vcard-one__service my-3 py-5 mb-10 mt-0">

                <div class="container">

                    <div class="row g-3 mb-5 pb-3">

                        <?php $__currentLoopData = $vcard->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-12">

                                <div class="service-card">

                                    <div class="card-img">

                                        <a href="<?php echo e($service->service_url ?? 'javascript:void(0)'); ?>"

                                            class="text-decoration-none <?php echo e($service->service_url ? 'pe-auto' : 'pe-none'); ?>"

                                            target="<?php echo e($service->service_url ? '_blank' : ''); ?>">

                                            <img src="<?php echo e($service->service_icon); ?>"

                                                class="service-new-image"

                                                alt="<?php echo e($service->name); ?>">

                                        </a>

                                    </div>

                                    <div class="card-body">

                                        <h5 class="title-text mb-2"><?php echo e(ucwords($service->name)); ?></h5>

                                        <p class="description-text mb-0 <?php echo e(\Illuminate\Support\Str::length($service->description) > 80 ? 'more' : ''); ?>">

                                            <?php echo $service->description; ?>


                                        </p>

                                    </div>

                                </div>

                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                </div>

            </div>

        </section>

    <?php endif; ?>

<?php endif; ?>





<?php if((isset($managesection) && $managesection['galleries']) || empty($managesection)): ?>

    <?php if(checkFeature('gallery') && $vcard->gallery->count()): ?>

        <section class="container py-4">

            <h2 class="fs-5 fw-semibold text-dark mb-3 text-center"><?php echo e(__('messages.plan.gallery')); ?></h2>

            <div class="vcard-one__gallery py-3 mb-10 mt-0">

                <div class="container">

                    <div class="row g-4 gallery-slider overflow-hidden">

                        <?php $__currentLoopData = $vcard->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php

                                $infoPath = pathinfo(public_path($file->gallery_image));

                                $extension = $infoPath['extension'];

                            ?>

                            <div class="col-sm-6 col-md-4 mb-2">

                                <div class="card gallery-card m-auto p-2 border-0 w-100 h-100 gallery-vcard-block">

                                    <div class="gallery-profile">

                                        <?php if($file->type == App\Models\Gallery::TYPE_IMAGE): ?>

                                            <a href="<?php echo e($file->gallery_image); ?>" data-lightbox="gallery-images">

                                                <img src="<?php echo e($file->gallery_image); ?>" alt="Gallery Image" class="w-100" />

                                            </a>

                                        <?php elseif($file->type == App\Models\Gallery::TYPE_FILE): ?>

                                            <a id="file_url" href="<?php echo e($file->gallery_image); ?>" class="gallery-link gallery-file-link" target="_blank">

                                                <div class="gallery-item"

                                                    <?php if($extension == 'pdf'): ?> style="background-image: url(<?php echo e(asset('assets/images/pdf-icon.png')); ?>)" <?php endif; ?>

                                                    <?php if($extension == 'xls'): ?> style="background-image: url(<?php echo e(asset('assets/images/xls.png')); ?>)" <?php endif; ?>

                                                    <?php if($extension == 'csv'): ?> style="background-image: url(<?php echo e(asset('assets/images/csv-file.png')); ?>)" <?php endif; ?>

                                                    <?php if($extension == 'xlsx'): ?> style="background-image: url(<?php echo e(asset('assets/images/xlsx.png')); ?>)" <?php endif; ?>>

                                                </div>

                                            </a>

                                        <?php elseif($file->type == App\Models\Gallery::TYPE_VIDEO): ?>

                                            <div class="d-flex align-items-center video-container">

                                                <video width="100%" controls>

                                                    <source src="<?php echo e($file->gallery_image); ?>">

                                                </video>

                                            </div>

                                        <?php elseif($file->type == App\Models\Gallery::TYPE_AUDIO): ?>

                                            <div class="audio-container">

                                                <img src="<?php echo e(asset('assets/img/music.jpeg')); ?>" alt="Album Cover" class="audio-image" height="173">

                                                <audio controls src="<?php echo e($file->gallery_image); ?>" class="mt-2">

                                                    Your browser does not support the <code>audio</code> element.

                                                </audio>

                                            </div>

                                        <?php else: ?>

                                            <iframe src="https://www.youtube.com/embed/<?php echo e(YoutubeID($file->link)); ?>" class="w-100" height="224"></iframe>

                                        <?php endif; ?>

                                    </div>

                                </div>

                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                </div>

            </div>

        </section>

    <?php endif; ?>

<?php endif; ?>





<?php if((isset($managesection) && $managesection['products']) || empty($managesection)): ?>

    <?php if(checkFeature('products') && $vcardProducts->count()): ?>

        <section class="container py-4">

            <h2 class="fs-5 fw-semibold text-dark mb-3 text-center"><?php echo e(__('messages.vcard.products')); ?></h2>

            <div class="vcard-one__product py-3 mb-10 mt-0">

                <div class="container">

                    <div class="row g-4 product-slider overflow-hidden">

                        <?php $__currentLoopData = $vcardProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-6 col-md-4 mb-2">

                                <a <?php if($product->product_url): ?> href="<?php echo e($product->product_url); ?>" <?php endif; ?>

                                   target="_blank" class="text-decoration-none fs-6">

                                    <div class="card product-card p-2 border-0 w-100 h-100">

                                        <div class="product-profile">

                                            <img src="<?php echo e($product->product_icon); ?>" alt="<?php echo e($product->name); ?>"

                                                 class="w-100" height="208px" />

                                        </div>

                                        <div class="product-details mt-3">

                                            <h4 class="product-name"><?php echo e($product->name); ?></h4>

                                            <p class="mb-2 product-description">

                                                <?php echo e($product->description); ?>


                                            </p>

                                            <?php if($product->currency_id && $product->price): ?>

                                                <span class="text-black product-price-<?php echo e($product->id); ?>">

                                                    <?php echo e($product->currency->currency_icon); ?><?php echo e(number_format($product->price, 2)); ?>


                                                </span>

                                            <?php elseif($product->price): ?>

                                                <span class="text-black product-price-<?php echo e($product->id); ?>">

                                                    <?php echo e(getUserCurrencyIcon($vcard->user->id) . ' ' . $product->price); ?>


                                                </span>

                                            <?php endif; ?>

                                        </div>

                                    </div>

                                </a>

                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                </div>

                <div class="text-center me-5 my-3 ms-5">

                    <a class="fs-6 mb-0 view-more"

                       href="<?php echo e(route('showProducts', ['id' => $vcard->id, 'alias' => $vcard->url_alias])); ?>">

                        <?php echo e(__('messages.analytics.view_more')); ?>


                    </a>

                </div>

            </div>

            <?php echo $__env->make('vcardTemplates.product-buy', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </section>

    <?php endif; ?>

<?php endif; ?>











<?php if(isset($vcard['show_qr_code']) && $vcard['show_qr_code'] == 1): ?>

    <section class="px-3 py-4">

        <h2 class="fs-5 fw-semibold text-dark mb-4 text-center">Share My Card</h2>



        <div class="bg-white rounded shadow-sm p-4 text-center">

            

            <div class="mx-auto mb-3 d-flex align-items-center justify-content-center"

                 style="width: 192px; height: 192px; border-radius: 8px; background-color: rgba(0, 123, 255, 0.08);">

                <div class="d-flex align-items-center justify-content-center" style="width: 160px; height: 160px;">



                    

                    <div id="qr-code-one"

                         style="opacity: <?php echo e($qrcodeColor['qrcodeOpacity'] ?? 1); ?>;

                                background-color: <?php echo e($qrcodeColor['backgroundColorRgba']

                                    ? 'rgba(' . $qrcodeColor['backgroundColorRgba']['r'] . ', '

                                               . $qrcodeColor['backgroundColorRgba']['g'] . ', '

                                               . $qrcodeColor['backgroundColorRgba']['b'] . ', '

                                               . $qrcodeColor['backgroundColorRgba']['a'] . ')'

                                    : 'transparent'); ?>;

                                padding: 5px; border-radius: 4px;">

                        <?php if(isset($customQrCode['applySetting']) && $customQrCode['applySetting'] == 1): ?>

                            <?php echo QrCode::color(

                                    $qrcodeColor['qrcodeColor']->red(),

                                    $qrcodeColor['qrcodeColor']->green(),

                                    $qrcodeColor['qrcodeColor']->blue()

                                )->backgroundColor(255, 255, 255, 0)

                                ->style($customQrCode['style'])

                                ->eye($customQrCode['eye_style'])

                                ->size(160)

                                ->format('svg')

                                ->generate(Request::url()); ?>


                        <?php else: ?>

                            <?php echo QrCode::size(160)->format('svg')->generate(Request::url()); ?>


                        <?php endif; ?>

                    </div>



                </div>

            </div>



            

            <p class="text-muted small mb-3">Scan this QR code to save my contact information</p>



            

            <button class="btn btn-outline-primary d-inline-flex align-items-center justify-content-center px-3 py-2"

                    id="downloadQrBtn">

                <i class="ri-download-line me-2"></i>

                Download QR Code

            </button>

        </div>

    </section>

<?php endif; ?>





<?php if((isset($managesection) && $managesection['testimonials']) || empty($managesection)): ?>

    <?php if(checkFeature('testimonials') && $vcard->testimonials->count()): ?>

        <section class="container py-4">

            <h2 class="fs-5 fw-semibold text-dark mb-3 text-center"><?php echo e(__('messages.plan.testimonials')); ?></h2>

            <div class="vcard-one__testimonial py-3 mb-10 mt-0">

                <div class="container">

                    <div class="row g-4 pt-5 testimonial-slider overflow-hidden">

                        <?php $__currentLoopData = $vcard->testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-6 col-md-4 testimonial-margin">

                                <div class="card testimonial-card position-relative p-3 border-0 w-100">

                                    <div class="testimonial-profile position-absolute top-0 start-50 translate-middle">

                                        <img src="<?php echo e($testimonial->image_url); ?>" alt="<?php echo e(ucwords($testimonial->name)); ?>"

                                             class="rounded-circle m-auto" />

                                    </div>

                                    <div class="testimonial-details mt-5">

                                        <h4 class="text-center"><?php echo e(ucwords($testimonial->name)); ?></h4>

                                        <p class="text-center text-muted <?php echo e(\Illuminate\Support\Str::length($testimonial->description) > 80 ? 'more' : ''); ?>">

                                            <?php echo $testimonial->description; ?>


                                        </p>

                                    </div>

                                </div>

                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                </div>

            </div>

        </section>

    <?php endif; ?>

<?php endif; ?>





<?php if((isset($managesection) && $managesection['blogs']) || empty($managesection)): ?>

    <?php if(checkFeature('blog') && $vcard->blogs->count()): ?>

        <section class="container py-4">

            <h2 class="fs-5 fw-semibold text-dark mb-3 text-center"><?php echo e(__('messages.feature.blog')); ?></h2>

            <div class="vcard-one__blog my-3 py-5 mt-0">

                <div class="container">

                    <div class="row g-3 mb-0 justify-content-center blog-slider overflow-hidden">

                        <?php $__currentLoopData = $vcard->blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-6 col-md-4 mb-2">

                                <div class="card blog-card p-4 border-0 w-100 h-100 d-flex flex-column">

                                    <div class="blog-image">

                                        <a href="<?php echo e(route('vcard.show-blog', [$vcard->url_alias, $blog->id])); ?>">

                                            <img src="<?php echo e($blog->blog_icon); ?>" alt="<?php echo e($blog->title); ?>" class="w-100" />

                                        </a>

                                    </div>

                                    <div class="blog-details mt-3">

                                        <a href="<?php echo e(route('vcard.show-blog', [$vcard->url_alias, $blog->id])); ?>"

                                           class="text-decoration-none">

                                            <h4 class="text-center text-black mb-0"><?php echo e($blog->title); ?></h4>

                                        </a>

                                    </div>

                                </div>

                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                </div>

            </div>

        </section>

    <?php endif; ?>

<?php endif; ?>





  </main>



  <!-- Fixed Bottom Action Button -->

  <!--<div class="fixed-bottom-action">-->

  <!--  <button id="addToContacts" class="primary-btn d-flex align-items-center justify-content-center">-->

  <!--    <i class="ri-user-add-line me-2"></i>-->

  <!--    Add to Contacts-->

  <!--  </button>-->

  <!--</div>-->



  <!-- Share Modal -->

  <div class="modal fade" id="shareModal" tabindex="-1" aria-labelledby="shareModalLabel" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered">

      <div class="modal-content">

        <div class="modal-header">

          <h5 class="modal-title fw-semibold" id="shareModalLabel">Share Business Card</h5>

          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

        </div>

        <div class="modal-body">

          <div class="row g-3 mb-4">

            <div class="col-3">

              <a href="https://wa.me/?text=<?php echo e(urlencode(route('vcard.show', ['alias' => $vcard->url_alias]))); ?>" target="_blank" class="share-platform text-center d-block">

                <div class="share-icon mx-auto" style="background: rgba(37, 211, 102, 0.1);">

                  <i class="ri-whatsapp-line ri-xl" style="color: #25D366;"></i>

                </div>

                <span class="small text-muted">WhatsApp</span>

              </a>

            </div>



            <?php if(!empty($vcard->telegram_number)): ?>

            <div class="col-3">

              <a href="https://t.me/<?php echo e(ltrim($vcard->telegram_number, '@')); ?>" target="_blank" class="share-platform text-center d-block">

                <div class="share-icon mx-auto" style="background: rgba(0, 136, 204, 0.1);">

                  <i class="ri-telegram-line ri-xl" style="color: #0088CC;"></i>

                </div>

                <span class="small text-muted">Telegram</span>

              </a>

            </div>

            <?php endif; ?>



            <div class="col-3">

              <a href="http://www.facebook.com/sharer.php?u=<?php echo e(urlencode(route('vcard.show', ['alias' => $vcard->url_alias]))); ?>" target="_blank" class="share-platform text-center d-block">

                <div class="share-icon mx-auto" style="background: rgba(24, 119, 242, 0.1);">

                  <i class="ri-messenger-line ri-xl" style="color: #1877F2;"></i>

                </div>

                <span class="small text-muted">Messenger</span>

              </a>

            </div>



            <div class="col-3">

              <a href="mailto:?Subject=&Body=<?php echo e(urlencode(route('vcard.show', ['alias' => $vcard->url_alias]))); ?>" class="share-platform text-center d-block">

                <div class="share-icon mx-auto" style="background: rgba(52, 120, 246, 0.1);">

                  <i class="ri-mail-line ri-xl" style="color: #3478F6;"></i>

                </div>

                <span class="small text-muted">Email</span>

              </a>

            </div>

          </div>



          <div class="d-flex align-items-center bg-light rounded p-3 mb-3">

            <input type="text" id="vcardLink" value="<?php echo e(route('vcard.show', ['alias' => $vcard->url_alias])); ?>" class="link-input border-0 bg-transparent flex-fill me-2" readonly>

            <button id="copyLink" class="copy-btn btn btn-sm btn-outline-primary">Copy</button>

        </div>



          <button id="downloadVcardBtn" class="primary-btn w-100">

                Download vCard

            </button>

        </div>

      </div>

    </div>

  </div>





  <!-- Inquiry Form Section -->

<?php

    $currentSubs = $vcard

        ->subscriptions()

        ->where('status', \App\Models\Subscription::ACTIVE)

        ->latest()

        ->first();

?>



<?php if($currentSubs && $currentSubs->plan->planFeature->enquiry_form && $vcard->enable_enquiry_form): ?>

    <section class="px-3 py-4">

        <h2 class="fs-5 fw-semibold text-dark mb-4 text-center"><?php echo e(__('messages.contact_us.inquries')); ?></h2>



        <div class="bg-white rounded shadow-sm p-4">

            <form id="enquiryForm">

                <?php echo csrf_field(); ?>

                <div id="enquiryError" class="alert alert-danger d-none"></div>



                

                <div class="mb-3">

                    <label class="form-label fw-semibold text-dark">

                        <?php echo e(__('messages.common.name')); ?> <span class="text-danger">*</span>

                    </label>

                    <div class="input-group">

                        <span class="input-group-text bg-white border-end-0">

                            <i class="ri-user-line text-primary"></i>

                        </span>

                        <input type="text" name="name"

                               class="form-control border-start-0"

                               placeholder="<?php echo e(__('messages.form.your_name')); ?>" required>

                    </div>

                </div>



                

                <div class="mb-3">

                    <label class="form-label fw-semibold text-dark">

                        <?php echo e(__('messages.user.email')); ?> <span class="text-danger">*</span>

                    </label>

                    <div class="input-group">

                        <span class="input-group-text bg-white border-end-0">

                            <i class="ri-mail-line text-primary"></i>

                        </span>

                        <input type="email" name="email"

                               class="form-control border-start-0"

                               placeholder="<?php echo e(__('messages.form.your_email')); ?>" required>

                    </div>

                </div>



                

                <div class="mb-3">

                    <label class="form-label fw-semibold text-dark">

                        <?php echo e(__('messages.user.phone')); ?>


                    </label>

                    <div class="input-group">

                        <span class="input-group-text bg-white border-end-0">

                            <i class="ri-phone-line text-primary"></i>

                        </span>

                        <input type="tel" name="phone"

                               class="form-control border-start-0"

                               placeholder="<?php echo e(__('messages.form.phone')); ?>">

                    </div>

                </div>



                

                <div class="mb-3">

                    <label class="form-label fw-semibold text-dark">

                        <?php echo e(__('messages.contact_us.message')); ?> <span class="text-danger">*</span>

                    </label>

                    <textarea class="form-control"

                              name="message"

                              placeholder="<?php echo e(__('messages.form.type_message')); ?>"

                              rows="5" required></textarea>

                </div>



                

                <div class="d-grid mt-4">

                    <button type="submit"

                            class="btn btn-primary text-white py-2">

                        <i class="ri-send-plane-line me-2"></i><?php echo e(__('messages.contact_us.send_message')); ?>


                    </button>

                </div>

            </form>

        </div>

    </section>

<?php endif; ?>

<div class="d-flex justify-content-center align-items-center gap-2 mt-5 flex-wrap text-center">

    

    <?php $hideBranding = checkFeature('advanced') && checkFeature('advanced')->hide_branding && $vcard->branding == 0; ?>



    <?php if($hideBranding || !checkFeature('advanced')): ?>

        <?php if(!empty($vcard->made_by)): ?>

            <a href="<?php echo e($vcard->made_by_url ?? '#'); ?>" class="text-decoration-none text-dark" target="_blank">

                <small><?php echo e(__('messages.made_by')); ?> <?php echo e($vcard->made_by); ?></small>

            </a>

        <?php else: ?>

            <div>

                <small><?php echo e(__('messages.made_by')); ?> <?php echo e($setting['app_name']); ?></small>

            </div>

        <?php endif; ?>

    <?php endif; ?>



    

    <?php if(!empty($vcard->privacy_policy) || !empty($vcard->term_condition)): ?>

        <a href="<?php echo e(route('vcard.show-privacy-policy', [$vcard->url_alias, $vcard->id])); ?>"

           class="text-decoration-none text-dark">

            <small><?php echo __('messages.vcard.term_policy'); ?></small>

        </a>

    <?php endif; ?>

</div>



<div class="w-100 d-flex justify-content-center position-fixed" style="top:50%; left:0; z-index: 9999;">

    <div class="vcard-bars-btn position-relative">

        <!--<?php if(empty($userSetting['hide_stickybar'])): ?>-->

        <!--    <a href="javascript:void(0)"-->

        <!--        class="vcard1-sticky-btn bars-btn d-flex justify-content-center text-white me-5 align-items-center rounded-0 px-5 mb-3 text-decoration-none py-1 rounded-pill justify-content-center">-->

        <!--        <img src="<?php echo e(asset('assets/img/vcard1/sticky.png')); ?>" />-->

        <!--    </a>-->

        <!--<?php endif; ?>-->



        <div class="sub-btn d-none">

            <div class="sub-btn-div">

                <?php if(isset($userSetting['whatsapp_share']) && $userSetting['whatsapp_share'] == 1): ?>

                    <div class="icon-search-container mb-3" data-ic-class="search-trigger">

                        <div class="wp-btn">

                            <i class="fab text-light fa-whatsapp fa-2x" id="wpIcon"></i>

                        </div>

                        <input type="number" class="search-input" id="wpNumber"

                            data-ic-class="search-input"

                            placeholder="<?php echo e(__('messages.setting.wp_number')); ?>" />

                        <div class="share-wp-btn-div">

                            <a href="javascript:void(0)"

                                class="vcard1-sticky-btn d-flex justify-content-center text-white align-items-center rounded-0 text-decoration-none py-1 rounded-pill justify-content share-wp-btn">

                                <i class="fa-solid fa-paper-plane"></i> </a>

                        </div>

                    </div>

                <?php endif; ?>

                <!--<?php if(empty($userSetting['hide_stickybar'])): ?>-->

                <!--    <div-->

                <!--        class="<?php echo e(isset($userSetting['whatsapp_share']) && $userSetting['whatsapp_share'] == 1 ? 'vcard1-btn-group' : 'stickyIcon'); ?>">-->

                <!--        <button type="button"-->

                <!--            class="vcard1-share vcard1-sticky-btn d-flex justify-content-center align-items-center vcard1-btn-group px-2 mb-3 py-2"><i-->

                <!--                class="fas fa-share-alt fs-1"></i></button>-->

                <!--        <?php if(!empty($vcard->enable_download_qr_code)): ?>-->

                <!--        <a type="button"-->

                <!--            class="vcard1-sticky-btn d-flex justify-content-center align-items-center vcard1-btn-group px-2 mb-3 py-2"-->

                <!--            id="qr-code-btn" download="qr_code.png" style="color:#313BAC"><i-->

                <!--                class="fa-solid fa-qrcode fs-1"></i></a>-->

                <!--        <?php endif; ?>-->

                <!--    </div>-->

                <!--<?php endif; ?>-->

            </div>

        </div>

<?php if(!empty($userSetting['enable_contact'])): ?>

    <div class="position-fixed bottom-0 start-50 translate-middle-x bg-white shadow-sm p-3" style="max-width: 600px; width: 100%;">

        <div class="d-flex justify-content-center gap-2">

            <a href="<?php echo e(route('add-contact', $vcard->id)); ?>"
                class="btn btn-primary add-contact-btn flex-fill bg-primary text-white d-flex align-items-center justify-content-center rounded text-decoration-none">
                <i class="fas fa-download fa-address-book"></i>
                &nbsp;<?php echo e(__('messages.setting.add_contact')); ?>

            </a>


            <?php if(!empty($vcard->whatsapp_number)): ?>

                <?php

                    $whatsappNumber = $vcard->whatsapp_number;

                    if (!empty($vcard->whatsapp_region_code)) {

                        $whatsappNumber = $vcard->whatsapp_region_code . $vcard->whatsapp_number;

                    }

                ?>

                <a href="https://wa.me/<?php echo e($whatsappNumber); ?>" target="_blank"

                   class="d-flex align-items-center justify-content-center bg-success text-white rounded text-decoration-none"

                   style="width: 48px; height: 48px;">

                    <i class="fab fa-whatsapp fs-5"></i>

                </a>

            <?php endif; ?>



            <?php if(!empty($vcard->telegram_number)): ?>

                <a href="https://t.me/<?php echo e(ltrim($vcard->telegram_number, '@')); ?>" target="_blank"

                   class="d-flex align-items-center justify-content-center bg-info text-white rounded text-decoration-none"

                   style="width: 48px; height: 48px;">

                    <i class="fab fa-telegram-plane fs-5"></i>

                </a>

            <?php endif; ?>

        </div>

    </div>

<?php endif; ?>









    </div>

</div>





                

                <div id="vcard1-shareModel" class="modal fade" role="dialog">

                    <div class="modal-dialog modal-dialog-centered">

                        <div class="modal-content">

                            <div class="">

                                <div class="row align-items-center mt-5">

                                    <div class="col-10 text-center">

                                        <h5 class="modal-title" style="padding-left: 50px;"><?php echo e(__('messages.vcard.share_my_vcard')); ?></h5>

                                    </div>

                                    <div class="col-2 p-0">

                                        <button type="button" aria-label="Close"

                                            class="btn btn-sm btn-icon btn-active-color-danger border-none"

                                            data-bs-dismiss="modal">

                                            <span class="svg-icon svg-icon-1">

                                                <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px"

                                                    viewBox="0 0 24 24" version="1.1">

                                                    <g transform="translate(12.000000, 12.000000) rotate(-45.000000) translate(-12.000000, -12.000000) translate(4.000000, 4.000000)"

                                                        fill="#000000">

                                                        <rect fill="#000000" x="0" y="7" width="16"

                                                            height="2" rx="1" />

                                                        <rect fill="#000000" opacity="0.5"

                                                            transform="translate(8.000000, 8.000000) rotate(-270.000000) translate(-8.000000, -8.000000)"

                                                            x="0" y="7" width="16" height="2"

                                                            rx="1" />

                                                    </g>

                                                </svg>

                                            </span>

                                        </button>

                                    </div>

                                </div>

                            </div>

                            <?php

                                $shareUrl = route('vcard.show', ['alias' => $vcard->url_alias]);

                            ?>

                            <div class="modal-body">

                                <a href="http://www.facebook.com/sharer.php?u=<?php echo e($shareUrl); ?>" target="_blank"

                                    class="text-decoration-none share" title="Facebook">

                                    <div class="row">

                                        <div class="col-2">

                                            <i class="fab fa-facebook fa-2x" style="color: #1B95E0"></i>



                                        </div>

                                        <div class="col-9 p-1">

                                            <p class="align-items-center text-dark"><?php echo e(__('messages.social.Share_on_facebook')); ?></p>

                                        </div>

                                        <div class="col-1 p-1">

                                            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" height="16px"

                                                viewBox="0 0 512.000000 512.000000"

                                                preserveAspectRatio="xMidYMid meet">

                                                <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"

                                                    fill="#000000" stroke="none">

                                                    <path

                                                        d="M1277 4943 l-177 -178 1102 -1102 1103 -1103 -1103 -1103 -1102 -1102 178 -178 177 -177 1280 1280 1280 1280 -1280 1280 -1280 1280 -178 -177z" />

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </a>

                                <a href="http://twitter.com/share?url=<?php echo e($shareUrl); ?>&text=<?php echo e($vcard->name); ?>&hashtags=sharebuttons"

                                    target="_blank" class="text-decoration-none share" title="Twitter">

                                    <div class="row">

                                        <div class="col-2">



                                            <span><svg xmlns="http://www.w3.org/2000/svg"

                                                    height="2em"

                                                    viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->

                                                    <path

                                                        d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z" />

                                                </svg></span>



                                        </div>

                                        <div class="col-9 p-1">

                                            <p class="align-items-center text-dark"><?php echo e(__('messages.social.Share_on_twitter')); ?></p>

                                        </div>

                                        <div class="col-1 p-1">

                                            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" height="16px"

                                                viewBox="0 0 512.000000 512.000000"

                                                preserveAspectRatio="xMidYMid meet">

                                                <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"

                                                    fill="#000000" stroke="none">

                                                    <path

                                                        d="M1277 4943 l-177 -178 1102 -1102 1103 -1103 -1103 -1103 -1102 -1102 178 -178 177 -177 1280 1280 1280 1280 -1280 1280 -1280 1280 -178 -177z" />

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </a>

                                <a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo e($shareUrl); ?>"

                                    target="_blank" class="text-decoration-none share" title="Linkedin">

                                    <div class="row">

                                        <div class="col-2">

                                            <i class="fab fa-linkedin fa-2x" style="color: #1B95E0"></i>

                                        </div>

                                        <div class="col-9 p-1">

                                            <p class="align-items-center text-dark"><?php echo e(__('messages.social.Share_on_linkedin')); ?></p>

                                        </div>

                                        <div class="col-1 p-1">

                                            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" height="16px"

                                                viewBox="0 0 512.000000 512.000000"

                                                preserveAspectRatio="xMidYMid meet">

                                                <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"

                                                    fill="#000000" stroke="none">

                                                    <path

                                                        d="M1277 4943 l-177 -178 1102 -1102 1103 -1103 -1103 -1103 -1102 -1102 178 -178 177 -177 1280 1280 1280 1280 -1280 1280 -1280 1280 -178 -177z" />

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </a>

                                <a href="mailto:?Subject=&Body=<?php echo e($shareUrl); ?>" target="_blank"

                                    class="text-decoration-none share" title="Email">

                                    <div class="row">

                                        <div class="col-2">

                                            <i class="fas fa-envelope fa-2x" style="color: #191a19  "></i>

                                        </div>

                                        <div class="col-9 p-1">

                                            <p class="align-items-center text-dark"><?php echo e(__('messages.social.Share_on_email')); ?></p>

                                        </div>

                                        <div class="col-1 p-1">

                                            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" height="16px"

                                                viewBox="0 0 512.000000 512.000000"

                                                preserveAspectRatio="xMidYMid meet">

                                                <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"

                                                    fill="#000000" stroke="none">

                                                    <path

                                                        d="M1277 4943 l-177 -178 1102 -1102 1103 -1103 -1103 -1103 -1102 -1102 178 -178 177 -177 1280 1280 1280 1280 -1280 1280 -1280 1280 -178 -177z" />

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </a>

                                <a href="http://pinterest.com/pin/create/link/?url=<?php echo e($shareUrl); ?>"

                                    target="_blank" class="text-decoration-none share" title="Pinterest">

                                    <div class="row">

                                        <div class="col-2">

                                            <i class="fab fa-pinterest fa-2x" style="color: #bd081c"></i>

                                        </div>

                                        <div class="col-9 p-1">

                                            <p class="align-items-center text-dark"><?php echo e(__('messages.social.Share_on_pinterest')); ?></p>

                                        </div>

                                        <div class="col-1 p-1">

                                            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" height="16px"

                                                viewBox="0 0 512.000000 512.000000"

                                                preserveAspectRatio="xMidYMid meet">

                                                <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"

                                                    fill="#000000" stroke="none">

                                                    <path

                                                        d="M1277 4943 l-177 -178 1102 -1102 1103 -1103 -1103 -1103 -1102 -1102 178 -178 177 -177 1280 1280 1280 1280 -1280 1280 -1280 1280 -178 -177z" />

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </a>

                                <a href="http://reddit.com/submit?url=<?php echo e($shareUrl); ?>&title=<?php echo e($vcard->name); ?>"

                                    target="_blank" class="text-decoration-none share" title="Reddit">

                                    <div class="row">

                                        <div class="col-2">

                                            <i class="fab fa-reddit fa-2x" style="color: #ff4500"></i>

                                        </div>

                                        <div class="col-9 p-1">

                                            <p class="align-items-center text-dark"><?php echo e(__('messages.social.Share_on_reddit')); ?></p>

                                        </div>

                                        <div class="col-1 p-1">

                                            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" height="16px"

                                                viewBox="0 0 512.000000 512.000000"

                                                preserveAspectRatio="xMidYMid meet">

                                                <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"

                                                    fill="#000000" stroke="none">

                                                    <path

                                                        d="M1277 4943 l-177 -178 1102 -1102 1103 -1103 -1103 -1103 -1102 -1102 178 -178 177 -177 1280 1280 1280 1280 -1280 1280 -1280 1280 -178 -177z" />

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </a>

                                <a href="https://wa.me/?text=<?php echo e($shareUrl); ?>" target="_blank"

                                    class="text-decoration-none share" title="Whatsapp">

                                    <div class="row">

                                        <div class="col-2">

                                            <i class="fab fa-whatsapp fa-2x" style="color: limegreen"></i>

                                        </div>

                                        <div class="col-9 p-1">

                                            <p class="align-items-center text-dark"><?php echo e(__('messages.social.Share_on_whatsapp')); ?></p>

                                        </div>

                                        <div class="col-1 p-1">

                                            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" height="16px"

                                                viewBox="0 0 512.000000 512.000000"

                                                preserveAspectRatio="xMidYMid meet">

                                                <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"

                                                    fill="#000000" stroke="none">

                                                    <path

                                                        d="M1277 4943 l-177 -178 1102 -1102 1103 -1103 -1103 -1103 -1102 -1102 178 -178 177 -177 1280 1280 1280 1280 -1280 1280 -1280 1280 -178 -177z" />

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </a>

                                <div class="col-12 justify-content-between social-link-modal">

                                    <div class="input-group">

                                        <input type="text" class="form-control"

                                            placeholder="<?php echo e(request()->fullUrl()); ?>" disabled>

                                        <span id="vcardUrlCopy<?php echo e($vcard->id); ?>" class="d-none" target="_blank">

                                            <?php echo e(route('vcard.show', ['alias' => $vcard->url_alias])); ?> </span>

                                        <button class="copy-vcard-clipboard btn btn-dark" title="Copy Link"

                                            data-id="<?php echo e($vcard->id); ?>">

                                            <i class="fa-regular fa-copy fa-2x"></i>

                                        </button>

                                    </div>

                                </div>

                                <div class="text-center">



                                </div>

                            </div>



                        </div>

                    </div>

                </div>



                <?php echo $__env->make('vcardTemplates.template.templates', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>





  <!-- Success Notification -->

  <div id="successNotification" class="success-notification d-none">

    <div class="d-flex align-items-center">

      <i class="ri-check-line me-2"></i>

      <span id="notificationText">Contact saved successfully!</span>

    </div>

  </div>

</div>
<?php endif; ?>


<!-- Include jQuery and Toastr JS just before closing </body> -->

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>



<script>

    document.addEventListener('DOMContentLoaded', function () {

        const enquiryForm = document.getElementById('enquiryForm');

        const submitButton = enquiryForm.querySelector('button[type="submit"]');



        enquiryForm.addEventListener('submit', function(e) {

            // Disable the submit button to prevent multiple submissions

            submitButton.disabled = true;

        });

    });

</script>

<script>

function displaySuccessMessage(message) {

    toastr.success(message);

}



function displayError(selector, message) {

    toastr.error(message);

}

</script>

<script>

document.getElementById('downloadQrBtn')?.addEventListener('click', function () {

    const qrContainer = document.getElementById("qr-code-one");
    const svg = qrContainer?.querySelector("svg");

    if (!svg) return;

    // Get the opacity from the container style (default to 1)
    const opacity = parseFloat(window.getComputedStyle(qrContainer).opacity) || 1;

    // Get the background color from the inline style attribute to preserve rgba format
    let backgroundColor = 'transparent';
    const styleAttr = qrContainer.getAttribute('style');
    if (styleAttr && styleAttr.includes('background-color:')) {
        const bgMatch = styleAttr.match(/background-color:\s*([^;]+)/);
        if (bgMatch) {
            backgroundColor = bgMatch[1].trim();
        }
    }

    // Fallback to computed style if not found in inline style
    if (!backgroundColor || backgroundColor === 'transparent') {
        const computedStyle = window.getComputedStyle(qrContainer);
        backgroundColor = computedStyle.backgroundColor || 'transparent';
    }

    const serializer = new XMLSerializer();
    const svgData = serializer.serializeToString(svg);
    const svgBlob = new Blob([svgData], { type: "image/svg+xml;charset=utf-8" });
    const url = URL.createObjectURL(svgBlob);

    const img = new Image();

    img.onload = () => {
        const canvas = document.createElement("canvas");
        const size = <?php echo e($vcard->qr_code_download_size ?? 300); ?>;

        canvas.width = size;
        canvas.height = size;
        const ctx = canvas.getContext("2d");

        // Fill canvas with background color first (if not transparent)
        if (backgroundColor && backgroundColor !== 'transparent' && backgroundColor !== 'rgba(0, 0, 0, 0)') {
            ctx.fillStyle = backgroundColor;
            ctx.fillRect(0, 0, size, size);
        } else {
            // Fill with white background if transparent (for better QR code visibility)
            ctx.fillStyle = '#ffffff';
            ctx.fillRect(0, 0, size, size);
        }

        // Apply QR code opacity before drawing
        ctx.globalAlpha = opacity;

        // Draw the QR code image on top of the background
        ctx.drawImage(img, 0, 0, size, size);

        const pngData = canvas.toDataURL("image/png");

        const a = document.createElement('a');
        a.href = pngData;
        a.download = "qr_code.png";
        a.click();

        URL.revokeObjectURL(url);

    };

    img.src = url;

});

// document.getElementById('downloadQrBtn')?.addEventListener('click', function () {



//     const qrContainer = document.getElementById("qr-code-one");



//     const svg = qrContainer?.querySelector("svg");

//     if (!svg) return;



//     // Get the opacity from the container style (default to 1)

//     const opacity = parseFloat(window.getComputedStyle(qrContainer).opacity) || 1;



//     const serializer = new XMLSerializer();

//     const svgData = serializer.serializeToString(svg);

//     const svgBlob = new Blob([svgData], { type: "image/svg+xml;charset=utf-8" });

//     const url = URL.createObjectURL(svgBlob);



//     const img = new Image();

//     img.onload = () => {

//         const canvas = document.createElement("canvas");

//         const size = <?php echo e($vcard->qr_code_download_size ?? 300); ?>;

//         canvas.width = size;

//         canvas.height = size;

//         const ctx = canvas.getContext("2d");



//         // Apply opacity before drawing

//         ctx.globalAlpha = opacity;



//         ctx.drawImage(img, 0, 0, size, size);



//         const pngData = canvas.toDataURL("image/png");

//         const a = document.createElement('a');

//         a.href = pngData;

//         a.download = "qr_code.png";

//         a.click();



//         URL.revokeObjectURL(url);

//     };

//     img.src = url;

// });



</script>

<script>

document.addEventListener('DOMContentLoaded', function() {

  const successNotification = document.getElementById('successNotification');

  const notificationText = document.getElementById('notificationText');

  const copyLinkBtn = document.getElementById('copyLink');



  // Add to contacts functionality

  if(document.getElementById('addToContacts')){

    addToContactsBtn.addEventListener('click', function() {

        const addToContactsBtn = document.getElementById('addToContacts');

        notificationText.textContent = 'Contact saved successfully!';

        successNotification.classList.remove('d-none');

        setTimeout(function() {

        successNotification.classList.add('d-none');

        }, 3000);

    });

  }

  // Copy link functionality

  copyLinkBtn.addEventListener('click', function() {

    const linkInput = this.previousElementSibling;

    linkInput.select();

    document.execCommand('copy');



    notificationText.textContent = 'Link copied to clipboard!';

    successNotification.classList.remove('d-none');

    setTimeout(function() {

      successNotification.classList.add('d-none');

    }, 3000);



    // Close modal after copying

    const modal = bootstrap.Modal.getInstance(document.getElementById('shareModal'));

    modal.hide();

  });

});





// document.getElementById('downloadQrBtn')?.addEventListener('click', function () {

//         const svg = document.querySelector('#qr-code-one svg');

//         if (!svg) return;



//         const serializer = new XMLSerializer();

//         const svgData = serializer.serializeToString(svg);

//         const blob = new Blob([svgData], { type: 'image/svg+xml;charset=utf-8' });

//         const url = URL.createObjectURL(blob);



//         const a = document.createElement('a');

//         a.href = url;

//         a.download = 'vcard-qr-code.svg';

//         a.click();



//         URL.revokeObjectURL(url);

//     });



        let isEdit = false;

        let password = "<?php echo e(isset(checkFeature('advanced')->password) && !empty($vcard->password)); ?>";

        let passwordUrl = "<?php echo e(route('vcard.password', $vcard->id)); ?>";

        let enquiryUrl = "<?php echo e(route('enquiry.store', ['vcard' => $vcard->id, 'alias' => $vcard->url_alias])); ?>";

        let appointmentUrl = "<?php echo e(route('appointment.store', ['vcard' => $vcard->id, 'alias' => $vcard->url_alias])); ?>";

        let paypalUrl = "<?php echo e(route('paypal.init')); ?>";

        let slotUrl = "<?php echo e(route('appointment-session-time', $vcard->url_alias)); ?>";

        let appUrl = "<?php echo e(config('app.url')); ?>";

        let vcardId = <?php echo e($vcard->id); ?>;

        let vcardAlias = "<?php echo e($vcard->url_alias); ?>";

        let languageChange = "<?php echo e(url('language')); ?>";

        let lang = "<?php echo e(checkLanguageSession($vcard->url_alias)); ?>";

    </script>



    <script>

$(document).ready(function() {

    // Initialize date picker

    // $('#pickUpDate').datepicker({

    //     format: 'mm/dd/yyyy',  Set the desired date format

    //     autoclose: true

    // });



    // Event listener for date change

    $('#pickUpDate').on('changeDate', function(e) {

        // Call a function to fetch available time slots based on the selected date

        fetchAvailableSlots(e.date);

    });

});



// Function to fetch available time slots

function fetchAvailableSlots(selectedDate) {

    // Example: Make an AJAX call to get available slots

    // Replace with your actual AJAX call

    $.ajax({

        url: '/get-available-slots', // Your endpoint to fetch slots

        method: 'GET',

        data: { date: selectedDate },

        success: function(response) {

            // Populate the slotData div with the available slots

            $('#slotData').empty(); // Clear previous slots

            response.slots.forEach(function(slot) {

                $('#slotData').append(`

                    <div class="col-md-4">

                        <div class="form-check">

                            <input class="form-check-input" type="radio" name="hour" id="slot-${slot.id}" value="${slot.time}">

                            <label class="form-check-label" for="slot-${slot.id}">

                                ${slot.time}

                            </label>

                        </div>

                    </div>

                `);

            });

        },

        error: function() {

            alert('Error fetching available slots.');

        }

    });

}

</script>

<script>

    // window.addEventListener('DOMContentLoaded', () => {

    //     const qrContainer = document.getElementById("qr-code-one");

    //     const svg = qrContainer.querySelector("svg");

    //     if (!svg) return;



    //     // Convert SVG to PNG using canvas

    //     const svgData = new XMLSerializer().serializeToString(svg);

    //     const svgBlob = new Blob([svgData], { type: "image/svg+xml;charset=utf-8" });

    //     const url = URL.createObjectURL(svgBlob);



    //     const img = new Image();

    //     img.onload = () => {

    //         const canvas = document.createElement("canvas");

    //         const size = <?php echo e($vcard->qr_code_download_size ?? 300); ?>; // fallback to 300

    //         canvas.width = size;

    //         canvas.height = size;

    //         const ctx = canvas.getContext("2d");

    //         ctx.drawImage(img, 0, 0, size, size);



    //         const pngData = canvas.toDataURL("image/png");

    //         const link = document.getElementById("downloadQrLink");

    //         link.href = pngData;

    //         link.download = "qr_code.png";



    //         // Trigger on button click

    //         document.getElementById("downloadQrBtn").addEventListener("click", () => {

    //             link.click();

    //         });



    //         URL.revokeObjectURL(url);

    //     };

    //     img.src = url;

    // });



document.getElementById("copyLink").addEventListener("click", function () {

    const input = document.getElementById("vcardLink");

    input.select();

    input.setSelectionRange(0, 99999); // For mobile compatibility



    try {

        document.execCommand("copy");

        this.innerText = "Copied!";

        setTimeout(() => this.innerText = "Copy", 2000);

    } catch (err) {

        alert("Failed to copy");

    }

});



    document.getElementById('downloadVcardBtn').addEventListener('click', function () {

        const link = document.createElement('a');

        link.href = "<?php echo e(route('add-contact', $vcard->id)); ?>";

        link.download = "contact.vcf";

        document.body.appendChild(link);

        link.click();

        document.body.removeChild(link);

    });

</script>

    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>

    <script src="<?php echo e(asset('messages.js')); ?>"></script>

    <script src="<?php echo e(mix('assets/js/custom/helpers.js')); ?>"></script>

    <script src="<?php echo e(mix('assets/js/custom/custom.js')); ?>"></script>

    <script src="<?php echo e(mix('assets/js/vcards/vcard-view.js')); ?>"></script>

    <script src="<?php echo e(mix('assets/js/lightbox.js')); ?>"></script>



</body>

</html>

<?php /**PATH C:\xampp\htdocs\projects\Ebizcard17-11-25\resources\views/vcardTemplates/vcard3.blade.php ENDPATH**/ ?>